<?php

/**
 * Artisan Creatif One Column Portfolio Page Template
 * 
 * This template will render the one column portfolio page with filter navigation.
 *
 * You should only customize this template in a child theme.
 *
 * @package Artisan Creatif
 * @version 1.0.0
 * @since 2.0.0
 * @author Erik Ford for We Are Pixel8 <@notdivisible>
 *
 */

/*
Template Name: One Column Portfolio
*/

get_header();

?>

	<?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>
	
		<div <?php post_class( 'flowlines' ); ?> id="post-<?php the_id(); ?>"><!-- Begin .flowlines -->
			<div class="wrapper">
			
				<?php the_title( '<h1>', '</h1>' ); ?>
			
			</div>
		</div><!-- End .flowlines -->
		
	<?php endwhile; endif; ?>
		
		<div id="page-content"><!-- Begin #page-content -->
			<div class="wrapper"><!-- Begin .wrapper for #page-content -->
			
				<div class="filter-module clear">
				
					<h3><?php _e( 'Filter Portfolio', 'wap8theme-i18n' ); ?></h3>
				
					<?php
				
						$services = get_terms( 'services' );
						$count = count( $services );
					
						if ( $count > 0 ) {
					
							echo '<ul class="filter_nav clear">';
						
								echo '<li><a href="#all" title="All">All</a></li>';
						
							foreach ( $services as $service ) {
						
								echo '<li><a href="#' . $service->slug . '" title="' . $service->name . '">' . $service->name . '</a></li>';
						
							}
				
							echo '</ul>';
						}
				
					?>
				
				</div>
		
				<ul id="filter-portfolio" class="one-column-portfolio">
				
					<?php
					
						// get the cached version of the query if one exists
						if ( false === ( $portfolio_pg = get_transient( 'portfolio_pg' ) ) ) {
    
							// it did not exist, so run through the query
							$args = array(
								'post_type'      => 'portfolio',
								'post_status'    => 'publish',
								'posts_per_page' => -1,
								'orderby'        => 'date',
								'order'          => 'DESC'
								);
							
							$portfolio_pg = new WP_Query( $args );
								
							// set the transient for 8 hours
							set_transient( 'portfolio_pg', $portfolio_pg, 60*60*8 );
					
							}
					
						while ( $portfolio_pg-> have_posts() ) : $portfolio_pg-> the_post();

						$terms = get_the_terms( get_the_ID(), 'services' );
						$clientname = get_post_meta( $post->ID, 'wap8_client_name', true ); ?>
					
					<li class="<?php foreach ( $terms as $term ) { echo $term->slug . ' '; } ?>all">
					
						<?php if ( has_post_thumbnail() ) { ?>
							
						<a href="<?php the_permalink(); ?>" rel="bookmark" title="<?php the_title_attribute(); ?>"><?php the_post_thumbnail( 'img-460x345', array( 'title' => get_the_title() ) ); ?></a>
							
						<?php } ?>
					
						<div class="one-column-meta" id="post-<?php the_ID(); ?>">
						
							<h3><a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>" rel="bookmark"><?php the_title(); ?></a></h3>
							
							<?php if ( $clientname ) { ?>
							<ul>
								<li><?php _e( '<strong>Client: </strong>', 'wap8theme-i18n' ); ?><?php echo stripslashes( $clientname ); ?></li>
							</ul>
							<?php } ?>
							
							<?php the_excerpt(); ?>
					
							<?php if ( of_get_option( 'artisan_home_slider_button_true' ) == '1' ) { ?>
							<p><a class="pill-button" href="<?php the_permalink(); ?>" rel="bookmark"><?php echo esc_html( of_get_option( 'artisan_home_slider_button' ) ); ?></a></p>
							<?php } ?>
						
						</div>
					
					</li>
					
					<?php endwhile; wp_reset_query(); ?>
				
				</ul>

			</div><!-- End .wrapper for #page-content -->
		</div><!-- End #page-content -->
		
		<?php if ( of_get_option( 'artisan_portfolio_callout' ) == '1' ) {
				
			if ( of_get_option( 'artisan_portfolio_callout_page' ) == 'both' || of_get_option( 'artisan_portfolio_callout_page' ) == 'portfolio' ) locate_template( '/includes/include-callout.php', true, true );
				
		} ?>

	</div><!-- End #vertical-grid -->
<?php get_footer(); ?>
