<?php

/**
 * Artisan Creatif Portfolio Post Template
 * 
 * This template will render the portfolio post.
 *
 * You should only customize this template in a child theme.
 *
 * @package Artisan Creatif
 * @version 1.0.0
 * @since 2.0.0
 * @author Erik Ford for We Are Pixel8 <@notdivisible>
 *
 */

get_header(); ?>

	<?php if ( have_posts() ) : while ( have_posts() ) : the_post(); // Begin the loop
	
		$clientname = esc_html( get_post_meta( $post->ID, 'wap8_client_name', true ) );
		$gallerytype = get_post_meta( $post->ID, 'wap8_gallery_type', true );
		$morecases = get_post_meta( $post->ID, 'wap8_portfolio_related_case', true ); ?>
	
		<div class="flowlines"><!-- Begin .flowlines -->
			<div class="wrapper">
				<?php the_title( '<h1>', '</h1>' ); ?>
				
				<ul class="return-portfolio">
					<li><a href="<?php echo site_url( '/portfolio/' ); ?>" title="<?php _e( 'Return to Portfolio', 'wap8theme-i18n' ); ?>"><?php _e( 'Return to Portfolio', 'wap8theme-i18n' ); ?></a></li>
				</ul>
			</div>
		</div><!-- End .flowlines -->
		
		<div id="page-content"><!-- Begin #page-content -->
			<div class="wrapper"><!-- Begin .wrapper for #page-content -->
			
				<div class="artisancolumn-960 clear"><!-- Begin case study text & images -->
			
					<div <?php post_class( 'post-entry case-study artisan-post alignleft' ); ?> id="post-<?php the_ID(); ?>"><!-- Begin .case-study -->
						
						<?php if ( $clientname ) { ?>
						<ul class="work-meta">
							<li><?php _e( '<strong>Client: </strong>', 'wap8theme-i18n' ); ?><?php echo stripslashes( $clientname ); ?></li>
						</ul>
						<?php } ?>
						
						<?php the_content(); ?>
				
					</div><!-- End .case-study -->
					
					<div class="artisan-portfolio alignright"><!-- Begin featured thumbnail -->
						
						<?php if ( $gallerytype == 'featured' ) {
						
							$full_image_url = wp_get_attachment_image_src( get_post_thumbnail_id(), 'full');
						
							echo '<a href="' . $full_image_url[0] . '" title="' . the_title_attribute( 'echo=0' ) . '" >';
						
							the_post_thumbnail( 'img-460x345' );
						
							echo '</a>';						

						} if ( $gallerytype == 'stacked' ) {
						
							locate_template( '/includes/include-simple-gallery.php', true, true );
						
						} if ( $gallerytype == 'slider' ) {
						
							locate_template( '/includes/include-slider-gallery.php', true, true );
						
						} if ( $gallerytype == 'video' && wap8HasVideo($post->ID) ) { 
						
							echo wap8GetVideo( $post->ID );
						
						} if ( $gallerytype == 'audio' ) {
						
							wap8_audio_player( $post->ID );
						
						} ?>
						
					</div><!-- End featured thumbnail -->
				
				</div><!-- End case study text & images -->
			</div><!-- End .wrapper for #page-content -->
		</div><!-- End #page-content -->
		
		<?php if ( $morecases == 'yes' ) {
			
			locate_template( '/includes/include-relatedcase.php', true, true );
			
			}
		
		endwhile; endif; // End the loop
		
				if ( of_get_option( 'artisan_portfolio_callout' ) == '1' ) {
				
					if ( of_get_option( 'artisan_portfolio_callout_page' ) == 'both' || of_get_option( 'artisan_portfolio_callout_page' ) == 'case-study' ) locate_template( '/includes/include-callout.php', true, true );
				
				} ?>
		
	</div><!-- End #vertical-grid -->
<?php get_footer(); ?>
