<?php

/*
Plugin Name: Flickr Feedr
Plugin URI: http://www.wearepixel8.com
Description: A simple Flickr Feed widget that allows streaming of public user or group feeds.
Version: 1.0.0
Author: We Are Pixel8
Author URI: http://www.wearepixel8.com
License:
	Copyright 2012 We Are Pixel8 <hello@wearepixel8.com>
	
	This program is free software; you can redistribute it and/or modify it under
	the terms of the GNU General Public License, version 2, as published by the Free
	Software Foundation.
	
	This program is distributed in the hope that it will be useful, but WITHOUT ANY
	WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
	PARTICULAR PURPOSE. See the GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software Foundation, Inc.,
	51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
*/

/*----------------------------------------------------------------------------*/
/* Flickr Feedr
/*----------------------------------------------------------------------------*/
 
add_action( 'widgets_init', 'wap8_flickr_feedr_widget' );

/**
 * Flickr Feedr widget.
 *
 * Register the Flickr Feedr widget.
 *
 * @package Flickr Feedr
 * @version 1.0.0
 * @since 1.0.0
 * @author Erik Ford for We Are Pixel8 <@notdivisible>
 *
 */

function wap8_flickr_feedr_widget() {
	register_widget( 'wap8_Flickr_Feedr_Widget' );
}

/*----------------------------------------------------------------------------*/
/* Extend WP_Widget by adding This Widget Class
/*----------------------------------------------------------------------------*/

class wap8_Flickr_Feedr_Widget extends WP_Widget {

	// widget setup
	function wap8_Flickr_Feedr_Widget() {
		$widget_ops = array(
			'classname'   => 'wap8_flickr_feedr_widget',
			'description' => __( 'Stream recent images from a designated Flickr account.', 'wap8theme-i18n' )
			);
			
		$this->WP_Widget( 'wap8-Flickr-Feedr-widget', __( 'Flickr Feedr', 'wap8theme-i18n' ), $widget_ops );
	}
	
	// widget output
	function widget( $args, $instance ) {
		
		extract( $args );
		
		// saved widget settings
		$title = apply_filters( 'widget_title', $instance['title'] );
		$flickr_id = $instance['flickr_id'];
		$flickr_group = $instance['flickr_group'];
		$flickr_count = $instance['flickr_count'];
		
		include_once( ABSPATH . WPINC . '/feed.php' ); // load feed.php
		
		// determine if this is a group feed or not
		if ( $flickr_group == 1 ) { // if a group feed
			$rss = fetch_feed( 'http://api.flickr.com/services/feeds/groups_pool.gne?id=' . $flickr_id . '&lang=en-us&format=rss_200' );
		} else { // if not a group feed
			$rss = fetch_feed( 'http://api.flickr.com/services/feeds/photos_public.gne?id=' . $flickr_id . '&lang=en-us&format=rss_200' );
		}
		
		include_once( get_template_directory() . '/lib/plugins/flickr-feedr/flickr-feedr-class.php' ); // load Flickr Feedr class
		
		echo $before_widget; // echo HTML set in register_sidebar by the currently active theme
		
		if ( $title ) { // if this widget has a title
		
			echo $before_title . $title . $after_title; // display the title wrapped with the HTML set by the currently active theme
			
		}
		
		// flickr image versions
		$thumb = 'square';
		$full = 'medium';

		// maximum amount of flickr images to fetch
		$maxitems = $rss->get_item_quantity( $flickr_count ); 

		// get the maximum amount of items
		$rss_items = $rss->get_items( 0, $maxitems ); 
			
		?>
		
		<ul class="flickr-feed clear"><!-- Begin .flickr-feed -->
				
		<?php if ( $maxitems == 0 ) echo '<li>' . __( 'No images found.', 'wap8theme-i18n' ) . '</li>'; // if no items were found for designated account
				
		else

		foreach ( $rss_items as $item ): // loop through the items
  		
  			$url = wap8_flickr::wap8_find_flickr_photo( $item->get_description() );
  			$title = wap8_flickr::wap8_flickr_cleanup( $item->get_title() );
  			$full_url = wap8_flickr::wap8_flickr_photo( $url, $full );
  			$thumb_url = wap8_flickr::wap8_flickr_photo( $url, $thumb );
		
		?>
			
			<li><a href="<?php echo $item->get_permalink(); ?>" title="<?php echo $item->get_title(); ?>" target="_blank"><img src="<?php echo $thumb_url; ?>" alt="<?php echo $item->get_title(); ?>" /></a></li>

		<?php endforeach; ?>	
		
		</ul><!-- End .flickr-feed -->	
		
		<?php		
		
		echo $after_widget;	// echo HTML set in register_sidebar by the currently active theme
	}
	
	// Update widget
	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = strip_tags( $new_instance['title'] );
		$instance['flickr_id'] = strip_tags( $new_instance['flickr_id'] );
		$instance['flickr_group'] = isset( $new_instance['flickr_group'] );
		$instance['flickr_count'] = ( int ) $new_instance['flickr_count'];
		return $instance;
	}
	
	// Widget form
	function form( $instance ) {
		$defaults = array(
			'title'        => __( 'Flickr Feed', 'wap8theme-i18n' ),
			'flickr_count' => 5
		);
		$instance = wp_parse_args( ( array ) $instance, $defaults );

		if ( ( int ) $instance['flickr_count'] < 1 )
			( int ) $intsance['flickr_count'] = 3;
		else if ( ( int ) $instance['flickr_count'] > 20 )
			( int ) $instance['flickr_count'] = 20;

		?>

		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title', 'wap8theme-i18n' ); ?></label><br />
			<input class="widefat" type="text" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title'];?>" />
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'flickr_id' ); ?>"><?php _e( 'Flickr ID', 'wap8theme-i18n' ); ?> &#40;<a href="<?php echo esc_url( 'http://idgettr.com/' ); ?>" target="_blank" title="<?php _e( 'Find your Flickr ID using idGettr', 'wap8theme-i18n' ); ?>">idGettr</a>&#41;</label><br />
			<input class="widefat" type="text" id="<?php echo $this->get_field_id( 'flickr_id' ); ?>" name="<?php echo $this->get_field_name( 'flickr_id' ); ?>" value="<?php echo $instance['flickr_id'];?>" />
		</p>
		
		<p>
			<input id="<?php echo $this -> get_field_id( 'flickr_group' ); ?>" name="<?php echo $this -> get_field_name( 'flickr_group' ); ?>" type="checkbox" <?php checked( isset( $instance['flickr_group'] ) ? $instance['flickr_group'] : 0); ?> />&nbsp;<label for="<?php echo $this -> get_field_id( 'flickr_group' ); ?>"><?php _e( 'This is a Flickr Group stream', 'wap8theme-i18n' ); ?></label>
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'flickr_count' ); ?>"><?php _e( 'Images to Show', 'wap8theme-i18n' ); ?></label>
			<input type="text" id="<?php echo $this->get_field_id( 'flickr_count' ); ?>" name="<?php echo $this->get_field_name( 'flickr_count' ); ?>" value="<?php echo $instance['flickr_count'];?>" size="3" maxlength="2" /> <small><?php _e( 'Max: 20', 'wap8theme-i18n' ); ?></small>
		</p>

		<?php	
	}
	
}

?>
