<?php

/**
 * Artisan Creatif Header Template
 *
 * This is the header template that will display the opening and closing <head>
 * tag, the opening <html> and <body> tags as well as the main menu.
 * 
 * This template also includes the wp_head() function which will allow the theme
 * and plugins to fire the wp_head action hook.
 *
 * You will also find the opening <div id="vertical-grid"> in this template.
 *
 * You should only customize this template in a child theme.
 *
 * @package Artisan Creatif
 * @version 1.0.0
 * @since 2.0.0
 * @author Erik Ford for We Are Pixel8 <@notdivisible>
 *
 */

?>

<!DOCTYPE html>
<html <?php language_attributes(); ?>>
	<head>
		<meta http-equiv="Content-Type" content="<?php bloginfo( 'html_type' ); ?>; charset=<?php bloginfo( 'charset' ); ?>" />

		<!-- behave IE8 -->
		<meta http-equiv="X-UA-Compatible" content="IE=8" />

		<title><?php wp_title( '|', true, 'right' ); ?></title>

		<!-- stylesheet -->
		<link rel="stylesheet" id="ac-core" href="<?php bloginfo( 'stylesheet_url' ); ?>" type="text/css" media="screen" />
	
		<!-- pingback -->
		<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />

		<?php wp_head(); // Do not delete this line or your world will come to an end ?>
	</head>

	<body <?php body_class(); ?>>
		<?php if ( of_get_option( 'artisan_qk_contact' ) == '1' ) { locate_template( '/includes/include-quickcontact.php', true, true ); } ?>
	
		<div id="vertical-grid"><!-- Begin #vertical-grid -->
			<div id="masthead" class="clear"><!-- Begin #masthead -->
				<div class="wrapper"><!-- Begin .wrapper for #masthead -->
					<?php if ( of_get_option( 'artisan_logo' ) != '' ) { ?>
					<div class="logo">
						<a href="<?php echo home_url(); ?>" title="<?php bloginfo( 'name' ); ?>"><img src="<?php echo of_get_option( 'artisan_logo', 'no entry' ); ?>" alt="<?php bloginfo( 'name' ); ?>" /></a>
					</div>
					<?php } else { ?>
					<div class="logo">
						<h1><a href="<?php echo home_url(); ?>" title="<?php bloginfo( 'name' ); ?>"><?php bloginfo( 'name' ); ?></a><span><?php bloginfo( 'description' ); ?></span></h1>
					</div>
					<?php } ?>
			
					<?php wp_nav_menu(
					
						/**
						 * Artisan Creatif Footer Menu
						 *
						 * Display the footer menu with a maximum depth of 2.
						 *
						 * You can override this functionality in a child theme.
						 *
						 * @package Artisan Creatif
						 * @version 1.0.0
						 * @since 1.1.1
						 * @author Erik Ford for We Are Pixel8 <@notdivisible>
						 *
						 */
						 
						array(
							'theme_location' => 'main-menu',
							'menu_class'     => 'masthead-menu',
							'container'      => false,
							'depth'          => 2
						)
					); ?>
				</div><!-- End .wrapper for #masthead -->
			</div><!-- End #masthead -->
