<?php

/**
 * Artisan Creatif Author Archive
 * 
 * This is the Author Archive Template that will be used to display blog posts
 * by a specific author.
 *
 * You should only customize this template in a child theme.
 *
 * @package Artisan Creatif
 * @version 1.0.0
 * @since 2.0.0
 * @author Erik Ford for We Are Pixel8 <@notdivisible>
 *
 */

get_header();

$paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1; // declare a variable to store current pagination number ?>

		<?php if ( have_posts() ) : 
		
			if ( isset( $_GET['author_name'] ) ) :
				
				$curauth = get_userdatabylogin( $author_name );
				
			else :
				
				$curauth = get_userdata( intval( $author ) );
			
			endif;
		
		?>

		<div class="flowlines"><!-- Begin .flowlines -->
			<div class="wrapper">

			<h1><?php _e( 'Blog Posts by ', 'wap8theme-i18n' ); ?><?php echo $curauth->display_name; ?></h1>

			</div>
		</div><!-- End .flowlines -->
		
		<div id="page-content" class="clear"><!-- Begin #page-content -->
			<div class="wrapper"><!-- Begin .wrapper for #page-content -->
				<div class="artisancolumn-700 vertmargin-10 <?php if ( of_get_option( 'artisan_sidebar' ) == '2c-l-fixed' ) { echo 'alignright'; } else if ( of_get_option( 'artisan_sidebar' ) == '2c-r-fixed' ) { echo 'alignleft'; } ?>"><!-- Begin .artisancolumn-700 -->
		
		<?php while ( have_posts() ) : the_post(); ?>
				
					<div <?php post_class( 'artisancolumn-700 horizmargin-80 clear' ); ?> id="post-<?php the_ID(); ?>"><!-- Begin returned post -->
						<?php if ( of_get_option( 'artisan_sidebar' ) == '2c-l-fixed' ) { // if sidebar is on the left ?>
						<div class="archive-title-right">
							<?php the_title( '<h2><a href="' . get_permalink() . '" title="' . the_title_attribute( array( 'before' => __( 'Permanent link to ', 'wap8theme-i18n' ), 'echo' => 0 ) ) . '" rel="bookmark">', '</a></h2>' ); ?>
						</div>
						<?php } else if ( of_get_option( 'artisan_sidebar' ) == '2c-r-fixed' ) { // if sidebar is on the right ?>
						<div class="archive-title-left">
							<?php the_title( '<h2><a href="' . get_permalink() . '" title="' . the_title_attribute( array( 'before' => __( 'Permanent link to ', 'wap8theme-i18n' ), 'echo' => 0 ) ) . '" rel="bookmark">', '</a></h2>' ); ?>
						</div>						
						<?php } ?>
						
						<div class="artisancolumn-700">
							<div class="artisan-baseline <?php if ( of_get_option( 'artisan_sidebar' ) == '2c-l-fixed' ) { echo 'alignright'; } else if ( of_get_option( 'artisan_sidebar' ) == '2c-r-fixed' ) { echo 'alignleft'; } ?>">
								<div class="baseline-section">
									<p><?php _e( 'Posted by ', 'wap8theme-i18n' ); ?><?php the_author(); ?></p>
								
									<p><?php the_time( 'd M Y' ); ?> &#151; <a href="<?php the_permalink(); ?>#comments"><?php comments_number(__( 'No Comments', 'wap8theme-i18n' ),__( '1 Comment', 'wap8theme-i18n' ),__( '% Comments', 'wap8theme-i18n' )); ?></a></p>
								</div>
								
								<div class="baseline-section top-decoration">
									<p><?php _e( 'Posted in ', 'wap8theme-i18n' ); ?><?php the_category(', '); ?></p>
								</div>
								
								<?php if ( has_tag() ) { ?>
								<div class="baseline-section top-decoration">
									<p><?php the_tags( __( 'Tagged: ', 'wap8theme-i18n' ), ', ', '' ); ?></p>
									</div>
								<?php } ?>
							</div>
						
							<div class="artisanthumb-460 <?php if ( of_get_option( 'artisan_sidebar' ) == '2c-l-fixed' ) { echo 'alignleft'; } else if ( of_get_option( 'artisan_sidebar' ) == '2c-r-fixed' ) { echo 'alignright'; } ?>"><!-- Begin archive thumbnail -->
								<div class="archivelink-460">
									<?php the_excerpt(); ?>
								</div>
								
								<div class="archivethumblink-460">
									<?php if ( has_post_thumbnail() ) { ?>
									<p><a href="<?php the_permalink(); ?>" rel="bookmark" title="<?php the_title_attribute(); ?>"><?php the_post_thumbnail('img-460x280', array('title' => get_the_title())); ?></a></p>
									<?php } ?>
								</div>
							</div><!-- End archive thumbnail -->
						</div>
					</div><!-- End returned post -->
	
		<?php endwhile;

			/**
			 * Artisan Creatif Pagination
			 *
			 * Show a pagination menu, using paginate_links(), if if it is time to paginate.
			 * If you would like to alter the $args, only do so by editing this template in
			 * a child theme.
			 *
			 * @package Artisan Creatif
			 * @version 2.0.0
			 * @since 2.0.0
			 * @author Erik Ford for We Are Pixel8 <@notdivisible>
			 *
			 */

			 $infinite = 999999999; // need an unlikely integer
	
			 // store pagination arguments in an array
			 $args = array(
			 	'base'		=> str_replace( $infinite, '%#%', esc_url( get_pagenum_link( $infinite ) ) ),
			 	'format'	=> '?paged=%#%',
			 	'current'	=> max( 1, get_query_var('paged') ),
			 	'total'		=> $wp_query->max_num_pages,
			 	'end_size'	=> 1,
			 	'mid_size'	=> 1,
			 	'prev_next'	=> false,
			 	'type'		=> 'list'
			 	);

			 if ( wap8_print_archive_pagination() ) { // if we need to print the pagination list ?>
	
			 	<div class="archive-pagination clear">
				 	<p class="paging-info"><?php printf( __( 'Page %1s <span>of</span> %2s', 'wap8theme-i18n' ), $paged , $wp_query->max_num_pages ); ?></p>
		
				 	<?php echo paginate_links( $args ); ?>
				 </div>

			<?php } // end the print pagination conditional check ?>

		<?php else : // no blog posts were published ?>
		
		<div class="flowlines"><!-- Begin .flowlines -->
			<div class="wrapper">
				<h1><?php echo $pagetitle; ?></h1>
			</div>
		</div><!-- End .flowlines -->
		
		<div id="page-content" class="clear"><!-- Begin #page-content -->
			<div class="wrapper"><!-- Begin .wrapper for #page-content -->
				<div class="artisancolumn-700 vertmargin-10 post-entry <?php if ( of_get_option( 'artisan_sidebar' ) == '2c-l-fixed' ) { echo 'alignright'; } else if ( of_get_option( 'artisan_sidebar' ) == '2c-r-fixed' ) { echo 'alignleft'; } ?>"><!-- Begin .artisancolumn-700 -->
		
				<p><?php _e( 'It seems we have not published any blog posts yet.', 'wap8theme-i18n' ); ?></p>

		<?php endif; ?>
	
				</div><!-- End .artisancolumn-700 -->
				
				<?php get_sidebar( 'archives' ); ?>
				
			</div><!-- End .wrapper for #page-content -->
		</div><!-- End #page-content -->		
	</div><!-- End #vertical-grid -->
<?php get_footer(); ?>
