<?php
/**********************************************************************
* OSAKA WORDPRESS THEME
* (Ideal For Business And Personal Use: Portfolio or Blog)   
* 
* File name:   
*      date.php
* Brief:       
*      theme posts archive page
* Author:      
*      DigitalCavalry
* Author URI:
*      http://themeforest.net/user/DigitalCavalry
* Contact:
*      digitalcavalry@gmail.com   
***********************************************************************/ 

    get_header();                                                
?>

    <div class="dc-primary-wrapper">  
        <div class="dc-secondary-wrapper">
            
            <?php 
            
                $year = GetDCCPI()->getIRenderer()->getYearQueryVar();
                $month = GetDCCPI()->getIRenderer()->getMonthQueryVar();                
                
                $month_name = '';
                if($month != '')
                {
                    $timestamp = mktime(0, 0, 0, $month, 1, 2010);
                    $datetime = date('Y-m-d H:i:s', $timestamp);    
                    $month_name = mysql2date('F', $datetime).' ';                   
                }
                $title = __('Archive for', CMS_TXT_DOMAIN).' '.$month_name.$year;                 
                                     
                $crumb = new DCC_Breadcrumb();
                echo $crumb->wpBreadcrumb(array('title' => $title)); 
            ?>
            <div class="dc-page-seo-wrapper <?php echo GetDCCPI()->getIRenderer()->getArchivePageLayoutClass(); ?>">
            <div class="dc-page-content">
            <div class="dc-sixteen dc-columns"> 
                <?php                   

                    $paged = GetDCCPI()->getIRenderer()->getPagedQueryVar();
                    $per_page = GetDCCPI()->getIGeneral()->getOption('archive_per_page'); 
                    $args = array('paged' => $paged, 'post_type' => 'post', 'posts_per_page' => $per_page, 'year' => $year, 'monthnum' => $month);                                                              

                    $dc_query = new WP_Query($args);                               
                    $out = '';  
                    for($i = 0; $i < $dc_query->post_count; $i++)
                    {
                        if($i > 0) { $out .= '<div class="blog-post-short-separator"></div>'; }
                        $p = new DCC_WPPost($dc_query->posts[$i]);
                        $out .= GetDCCPI()->getIRenderer()->wpPostShort(array('post' => $p));                               
                    }          
                    echo $out;                                                                             
                    echo GetDCCPI()->getIRenderer()->wpQueryPaginationBlock(array('paged' => $paged, 'maxpage' => $dc_query->max_num_pages));                                       
                ?>                           
                </div>
                <div class="dc-clear-both"></div>
            </div> 
            
                <?php GetDCCPI()->getIRenderer()->wpArchiveLeftSidebar(); ?>  
            </div>  <!-- seo-wrapper -->
            
            <?php 
                GetDCCPI()->getIRenderer()->wpArchiveRightSidebar();
            ?>
            <div class="dc-clear-both"></div>                
        </div> <!-- dc-secondary-wrapper -->    
    </div> <!-- dc-primary-wrapper --> 
    
<?php    
    get_footer();
?>                                                               



