<?php
/**********************************************************************
* OSAKA WORDPRESS THEME  
* (Ideal For Business And Personal Use: Portfolio or Blog)     
* 
* File name:   
*      cp_metapage.php
* Brief:       
*      Part of theme control panel.
* Author:      
*      DigitalCavalry
* Author URI:
*      http://themeforest.net/user/DigitalCavalry
* Contact:
*      digitalcavalry@gmail.com 
***********************************************************************/

/*********************************************************** 
* Definitions
************************************************************/

/*********************************************************** 
* Class name:
*    DCC_PageMetaCommonOpt
* Descripton:
*    Implementation of DCC_PageMetaCommonOpt
***********************************************************/
class DCC_PageMetaCommonOpt extends DCC_MetaMultiple 
{        
    /*********************************************************** 
    * Constructor
    ************************************************************/
    public function __construct() 
    {
        $this->_names = array(
            'page_common_opt', 
            'page_common_opt_cbox', 
            
            'page_layout', 
            
            'page_sid_left', 
            'page_sid_right',
            
            'page_bg_image', 
            'page_bg_attachment',
            'page_bg_repeat',
            'page_bg_color',
            'page_bg_pos_x',
            'page_bg_pos_y', 
            'page_bg_pos_x_px',
            'page_bg_pos_y_px',
            'page_bg_pos_x_px_use_cbox',
            'page_bg_pos_y_px_use_cbox',
            'page_bg_use_cbox',
            'page_bg_color_use_cbox',              
            
            'page_image',
            'page_image_desc',
            'page_image_alt',
            'page_image_desc_display_cbox',
            'page_image_filter',
            'page_image_hide_cbox',            
            
            'page_misc_allow_gmap_cbox',
            'page_misc_hide_breadcrumb_cbox',
            'page_misc_hide_title_cbox',
            'page_misc_subtitle_display_cbox',
            'page_misc_subtitle',
            
            'page_misc_footer_before_cbox',            
            'page_misc_footer_after_cbox',
            'page_misc_footer_sidebars_cbox',
            'page_misc_footer_logo_cbox',
            'page_misc_footer_copyright_cbox'
        );
                          
        $this->_std = array(
            'page_common_opt_cbox' => true,
            
            'page_layout' => CMS_PAGE_LAYOUT_RIGHT_SIDEBAR,
            
            'page_sid_left' => CMS_NOT_SELECTED,
            'page_sid_right' => CMS_NOT_SELECTED,
            
            'page_bg_image' => '',
            'page_bg_attachment' => 'scroll',
            'page_bg_repeat' => 'no-repeat',
            'page_bg_color' => '#E2E2E2',
            'page_bg_pos_x' => 'center',
            'page_bg_pos_y' => 'top',            
            'page_bg_pos_x_px' => 0,
            'page_bg_pos_y_px' => 0,
            'page_bg_pos_x_px_use_cbox' => false,
            'page_bg_pos_y_px_use_cbox' => false,            
            'page_bg_use_cbox' => false,
            'page_bg_color_use_cbox' => false,
            
            'page_image' => '',
            'page_image_desc' => '',
            'page_image_alt' => '',
            'page_image_desc_display_cbox' => false,
            'page_image_filter' => CMS_IMAGE_FILTER_NONE,
            'page_image_hide_cbox' => false,                 
            
            'page_misc_allow_gmap_cbox' => false,
            'page_misc_hide_breadcrumb_cbox' => false,
            'page_misc_hide_title_cbox' => false,
            'page_misc_subtitle_display_cbox' => false,
            'page_misc_subtitle' => '',
                       
            'page_misc_footer_before_cbox' => true,            
            'page_misc_footer_after_cbox' => true,
            'page_misc_footer_sidebars_cbox' => true,
            'page_misc_footer_logo_cbox' => true,
            'page_misc_footer_copyright_cbox' => true                         
        );
                             
        $this->_title = 'Page Common Settings';
        $this->_slug = '000-dc-page-common-settings';
        $this->_closed = true;
        $this->_post_type = 'page';
        
        add_action('admin_menu', array(&$this, 'adminMenu')); 
        add_action('save_post', array(&$this, 'save'));           
    }       
    
    /*********************************************************** 
    * Public functions
    ************************************************************/    
    
    public function display()
    {       
        $meta = $this->initDisplay();            
        global $post;
        
        $out = '';     
        $out .= '<div class="dc-cms-custom-field-panel">';     
            $out .= $this->getMetaTopSavePanel();       
            $out .= '<div class="center-content-panel">';          
                              
                $out .= '<input type="hidden" name="page_common_opt_cbox" checked="checked" />'; 

                // layout
                $out .= $this->getGroupFieldBegin(array('title' => 'Page layout', 'max_w' => 800, 'mtop' => 30));
                    $out .= '<span class="dc-cms-control-top-label-nomargin">Select page layout</span>';                    
                    $out .= '<div class="dc-cms-page-layout-box">';
                    
                        $out .= '<div class="item">';
                            $out .= '<div class="layout-image-both-sidebars">Both sidebars</div>';                    
                            $out .= '<input type="radio" name="page_layout" '.$this->attrChecked($meta['page_layout'] == CMS_PAGE_LAYOUT_BOTH_SIDEBARS).' value="'.CMS_PAGE_LAYOUT_BOTH_SIDEBARS.'" />';
                        $out .= '</div>';  
                        
                        $out .= '<div class="item">';
                            $out .= '<div class="layout-image-left-sidebar">Left sidebar</div>';                    
                            $out .= '<input type="radio" name="page_layout" '.$this->attrChecked($meta['page_layout'] == CMS_PAGE_LAYOUT_LEFT_SIDEBAR).' value="'.CMS_PAGE_LAYOUT_LEFT_SIDEBAR.'" />';
                        $out .= '</div>';                                             

                        $out .= '<div class="item">';
                            $out .= '<div class="layout-image-right-sidebar">Right sidebar</div>';                    
                            $out .= '<input type="radio" name="page_layout" '.$this->attrChecked($meta['page_layout'] == CMS_PAGE_LAYOUT_RIGHT_SIDEBAR).' value="'.CMS_PAGE_LAYOUT_RIGHT_SIDEBAR.'" />';
                        $out .= '</div>'; 
                        
                        $out .= '<div class="item">';
                            $out .= '<div class="layout-image-full-width">Full width</div>';                    
                            $out .= '<input type="radio" name="page_layout" '.$this->attrChecked($meta['page_layout'] == CMS_PAGE_LAYOUT_FULL_WIDTH).' value="'.CMS_PAGE_LAYOUT_FULL_WIDTH.'" />';
                        $out .= '</div>';                         
                        
                        $out .= $this->getClearBoth();
                        
                    $out .= '</div>';
                    
                $out .= $this->getGroupFieldEnd();
        
                // sidebar
                $out .= $this->getGroupFieldBegin(array('title' => 'Sidebars', 'max_w' => 800));
                    $out .= '<span class="dc-cms-control-top-label-nomargin">Left sidebar</span>';
                    $out .= GetDCCPI()->getIGeneral()->selectCtrlSidebarsList($meta['page_sid_left'], 'page_sid_left', 300);
                    
                    $out .= '<span class="dc-cms-control-top-label">Right sidebar</span>';
                    $out .= GetDCCPI()->getIGeneral()->selectCtrlSidebarsList($meta['page_sid_right'], 'page_sid_right', 300); 
                    $out .= '<div class="dc-cms-help-note-box">';
                        $out .= 'If sidebar is not selected, default sidebar will be used.';
                    $out .= '</div>';                      
                    
                $out .= $this->getGroupFieldEnd();        
                
                // main image
                $out .= $this->getGroupFieldBegin(array('title' => 'Main image', 'max_w' => 800)); 
    
                    $out .= '<span class="dc-cms-control-top-label-nomargin">URL</span>'; 
                    $out .= '<input type="text" class="dc-cms-control-100per" name="page_image" value="'.$meta['page_image'].'" id="dc_id_page_image" /> ';       
                                       
                    $out .= $this->getImagePreviewBox(array('path' => $meta['page_image'], 'width' => 240, 'height' => 180, 'info' => true));

                    $out .= '<div class="dc-cms-btn-frame">';
                        $out .= '<input class="dc-cms-submit-image-btn" type="submit" name="dc_id_page_image" value="'.__('Load image', CMS_TXT_DOMAIN).'"> ';  
                    $out .= '</div>';                     
                    
                    $out .= '<span class="dc-cms-control-top-label">Image filter</span>';  
                    $out .= $this->getStdInputsFieldStart();
                        $out .= '<input type="radio" name="page_image_filter" value="'.CMS_IMAGE_FILTER_NONE.'" '.$this->attrChecked($meta['page_image_filter'] == CMS_IMAGE_FILTER_NONE).' /> None';
                        $out .= $this->getBR();
                        $out .= '<input type="radio" name="page_image_filter" value="'.CMS_IMAGE_FILTER_GRAYSCALE.'" '.$this->attrChecked($meta['page_image_filter'] == CMS_IMAGE_FILTER_GRAYSCALE).' /> Grayscale';
                    $out .= $this->getStdInputsFieldEnd();                    
                    
                    $out .= '<span class="dc-cms-control-top-label">Image description</span>'; 
                    $out .= '<textarea class="dc-cms-control-wide dc-cms-control-textarea dc-cms-control-h-40" name="page_image_desc">'.$meta['page_image_desc'].'</textarea>';

                    $out .= '<span class="dc-cms-control-top-label">Image alt</span>'; 
                    $out .= '<textarea class="dc-cms-control-wide dc-cms-control-textarea dc-cms-control-h-40" name="page_image_alt">'.$meta['page_image_alt'].'</textarea>';
                    
                    $out .= '<span class="dc-cms-control-top-label">Other settings</span>'; 
                    $out .= $this->getStdInputsFieldStart();
                        $out .= '<input type="checkbox" name="page_image_desc_display_cbox" '.$this->attrChecked($meta['page_image_desc_display_cbox']).' /> Display image description';                   
                        $out .= $this->getBR();
                        $out .= '<input type="checkbox" name="page_image_hide_cbox" '.$this->attrChecked($meta['page_image_hide_cbox']).' /> Hide image';   
                    $out .= $this->getStdInputsFieldEnd();                         
                    
                $out .= $this->getGroupFieldEnd();
                     
                // background                                        
                $out .= $this->getGroupFieldBegin(array('title' => 'Background', 'max_w' => 800)); 
                
                    $out .= '<span class="dc-cms-control-top-label-nomargin">URL</span>'; 
                    $out .= '<input type="text" class="dc-cms-control-100per" name="page_bg_image" value="'.$meta['page_bg_image'].'" id="dc_id_page_bg_image" /> ';
                    $out .= '<div class="dc-cms-btn-frame">';
                        $out .= '<input class="dc-cms-submit-image-btn" type="submit" name="dc_id_page_bg_image" value="'.__('Load image', CMS_TXT_DOMAIN).'"> ';  
                    $out .= '</div>';                   
                
                    $out .= $this->getImagePreviewBox(array('path' => $meta['page_bg_image'], 'width' => 240, 'height' => 180));                                          
                    
                    $out .= $this->getStdWrapperStart();
                    
                        $out .= $this->getStdColumnStart(array('width'=>220)); 
                            
                                $out .= '<span class="dc-cms-control-top-label-nomargin">Background X align</span>';   
                                $out .= '<select name="page_bg_pos_x" class="dc-cms-control-100">';
                                    $out .= '<option value="left" '.$this->attrSelected($meta['page_bg_pos_x'] == 'left').'>Left</option>';
                                    $out .= '<option value="center" '.$this->attrSelected($meta['page_bg_pos_x'] == 'center').'>Center</option>';
                                    $out .= '<option value="right" '.$this->attrSelected($meta['page_bg_pos_x'] == 'right').'>Right</option>';
                                $out .= '</select>'; 
                                                                
                                $out .= '<span class="dc-cms-control-top-label">Background Y align</span>';
                                $out .= '<select name="page_bg_pos_y" class="dc-cms-control-100">';
                                    $out .= '<option value="top" '.$this->attrSelected($meta['page_bg_pos_y'] == 'top').'>Top</option>';
                                    $out .= '<option value="center" '.$this->attrSelected($meta['page_bg_pos_y'] == 'center').'>Center</option>';
                                    $out .= '<option value="bottom" '.$this->attrSelected($meta['page_bg_pos_y'] == 'bottom').'>Bottom</option>';
                                $out .= '</select>';
                                
                                
                                $out .= '<span class="dc-cms-control-top-label">Background X position in pixels</span>';
                                $out .= $this->getCtrlInputInt('page_bg_pos_x_px', $meta['page_bg_pos_x_px']);                        
  
                                $out .= '<span class="dc-cms-control-top-label">Background Y position in pixels</span>';
                                $out .= $this->getCtrlInputInt('page_bg_pos_y_px', $meta['page_bg_pos_y_px']);
                                   
                                               
                        $out .= $this->getStdColumnEnd();                       
                    
                        $out .= $this->getStdColumnStart(array('width'=>150));
                            $out .= '<span class="dc-cms-control-top-label-nomargin">Attachment mode</span>';
                            $out .= $this->getStdInputsFieldStart();
                                $out .= '<input type="radio" name="page_bg_attachment" '.$this->attrChecked($meta['page_bg_attachment'] == 'scroll').' value="scroll" /> Scroll';
                                $out .= $this->getBR();
                                $out .= '<input type="radio" name="page_bg_attachment" '.$this->attrChecked($meta['page_bg_attachment'] == 'fixed').' value="fixed" /> Fixed<br />';     
                                
                                $out .= '<span class="dc-cms-control-top-label">Background color</span>';
                                $out .= '<input type="text" class="dc-color-picker" value="'.$meta['page_bg_color'].'" name="page_bg_color" />';                                                    
                                 
                            $out .= $this->getStdInputsFieldEnd();                                  
                        $out .= $this->getStdColumnEnd();                    
     
                        $out .= $this->getStdColumnStart(array('width'=>150));
                            $out .= '<span class="dc-cms-control-top-label-nomargin">Repeat mode</span>';
                            $out .= $this->getStdInputsFieldStart();   
                                $out .= '<input type="radio" '.$this->attrChecked($meta['page_bg_repeat'] == 'repeat').' value="repeat" name="page_bg_repeat" /> Repeat';
                                $out .= $this->getBR();         
                                $out .= '<input type="radio" '.$this->attrChecked($meta['page_bg_repeat'] == 'repeat-x').' value="repeat-x" name="page_bg_repeat" /> Repeat X';
                                $out .= $this->getBR();
                                $out .= '<input type="radio" '.$this->attrChecked($meta['page_bg_repeat'] == 'repeat-y').' value="repeat-y" name="page_bg_repeat" /> Repeat Y';
                                $out .= $this->getBR();
                                $out .= '<input type="radio" '.$this->attrChecked($meta['page_bg_repeat'] == 'no-repeat').' value="no-repeat" name="page_bg_repeat" /> No repeat';    
                            $out .= $this->getStdInputsFieldEnd();
                        $out .= $this->getStdColumnEnd();                                            
                        
                        $out .= $this->getClearBoth();                   
                    $out .= $this->getStdWrapperEnd();
                      
                    $out .= '<span class="dc-cms-control-top-label">Other settings</span>';
                    $out .= $this->getStdInputsFieldStart(); 
                        $out .= '<input type="checkbox" name="page_bg_use_cbox" '.$this->attrChecked($meta['page_bg_use_cbox']).' /> Use background image'; 
                        $out .= $this->getBR(); 
                        $out .= '<input type="checkbox" name="page_bg_color_use_cbox" '.$this->attrChecked($meta['page_bg_color_use_cbox']).' /> Use background color';  
                        $out .= $this->getBR();                    
                        $out .= '<input type="checkbox" name="page_bg_pos_x_px_use_cbox" '.$this->attrChecked($meta['page_bg_pos_x_px_use_cbox']).' /> Use pixels X position';
                        $out .= $this->getBR(); 
                        $out .= '<input type="checkbox" name="page_bg_pos_y_px_use_cbox" '.$this->attrChecked($meta['page_bg_pos_y_px_use_cbox']).' /> Use pixels Y position';                    
                    $out .= $this->getStdInputsFieldEnd();                    
                $out .= $this->getGroupFieldEnd();                                                                                             
        
                // miscellaneous 
                $out .= $this->getGroupFieldBegin(array('title' => 'Miscellaneous', 'max_w' => 800)); 
                    $out .= $this->getStdInputsFieldStart();
                                               
                        $out .= '<input type="checkbox" name="page_misc_allow_gmap_cbox" '.$this->attrChecked($meta['page_misc_allow_gmap_cbox']).' /> Allow Google maps API loading'; 
                        $out .= $this->getBR();
                        $out .= '<input type="checkbox" name="page_misc_hide_breadcrumb_cbox" '.$this->attrChecked($meta['page_misc_hide_breadcrumb_cbox']).' /> Hide breadcrumb navigation'; 
                        $out .= $this->getBR();                        
                        $out .= '<input type="checkbox" name="page_misc_hide_title_cbox" '.$this->attrChecked($meta['page_misc_hide_title_cbox']).' /> Hide page title (only default page template)'; 
                    $out .= $this->getStdInputsFieldEnd();   
                    
                    $out .= '<span class="dc-cms-control-top-label">Page subtitle</span>';
                    $out .= '<textarea class="dc-cms-control-wide dc-cms-control-textarea dc-cms-control-h-40" name="page_misc_subtitle" >'.$meta['page_misc_subtitle'].'</textarea>';                      
                    
                    $out .= $this->getStdInputsFieldStart(array('mtop-type' => 'small')); 
                        $out .= '<input type="checkbox" name="page_misc_subtitle_display_cbox" '.$this->attrChecked($meta['page_misc_subtitle_display_cbox']).' /> Display page subtitle (only default page template)';  
                        $out .= $this->getBR();                    
                    $out .= $this->getStdInputsFieldEnd();                    
                      
                      
                    $out .= '<span class="dc-cms-control-top-label">Footer controls</span>';  
                    $out .= $this->getStdInputsFieldStart();
                        $out .= '<input type="checkbox" name="page_misc_footer_before_cbox" '.$this->attrChecked($meta['page_misc_footer_before_cbox']).' /> Display footer before content'; 
                        $out .= $this->getBR();
                        $out .= '<input type="checkbox" name="page_misc_footer_after_cbox" '.$this->attrChecked($meta['page_misc_footer_after_cbox']).' /> Display footer after content'; 
                        $out .= $this->getBR();
                        $out .= '<input type="checkbox" name="page_misc_footer_sidebars_cbox" '.$this->attrChecked($meta['page_misc_footer_sidebars_cbox']).' /> Display footer sidebars'; 
                        $out .= $this->getBR();
                        $out .= '<input type="checkbox" name="page_misc_footer_logo_cbox" '.$this->attrChecked($meta['page_misc_footer_logo_cbox']).' /> Display footer logo'; 
                        $out .= $this->getBR();
                        $out .= '<input type="checkbox" name="page_misc_footer_copyright_cbox" '.$this->attrChecked($meta['page_misc_footer_copyright_cbox']).' /> Display footer copyright text'; 
                        $out .= $this->getBR();               
                    $out .= $this->getStdInputsFieldEnd();                                                                                 
                                     
                $out .= $this->getGroupFieldEnd();
        
              $out .= '</div>';      
            $out .= $this->getMetaBottomSavePanel();     
        $out .= '</div>';
        
        echo $out;
    }   
}  


class DCC_HTML_BasicSliderSlide
{
    public function __construct()
    {
        $this->_url = '';    
        $this->_display = true;
        $this->_title = '';
        $this->_desc = '';
        $this->_desc_use = false;
        $this->_title_use = false;
        $this->_link = '';
        $this->_link_use = false;
        $this->_blank = false;
    }
    
    public $_url;  
    public $_display;
    public $_title;
    public $_desc;
    public $_desc_use;
    public $_title_use;
    public $_link;
    public $_link_use;
    public $_blank;
}

class DCC_CBuilderStdMetaObjData
{        
    public function __construct()     
    {
        $this->core = array();
        $this->cells = array();    
    }

    public $core;
    public $cells;
}

class DCC_CBuilderStdCellObjData
{        
    public function __construct()     
    {
        $this->core = array();
        $this->common = array();
        
        $this->blog = array();
        $this->post = array();  
        $this->page_title = array(); 
        $this->page_content = array(); 
        $this->heading = array(); 
        $this->sidebar = array();
        $this->gmap = array();
        $this->cform = array();  
        $this->text = array();
        $this->empty_space = array();
        $this->top_anchor = array();
        $this->line_divider = array(); 
        $this->img_divider = array(); 
        $this->note = array();  
        $this->blockquote = array();          
        $this->ul_list = array();  
        $this->postbox = array();  
        $this->pagebox = array();
        $this->image = array();   
        $this->video = array();  
        $this->tip = array();  
        $this->ngg = array();
        $this->ngg_thumbs_slider = array();  
        $this->ngg_gallery = array();  
        $this->service = array();  
        $this->project = array(); 
        $this->basic_slider = array();
        $this->code = array(); 
        $this->board_slider = array();  
        $this->anno_box = array(); 
        $this->ngg_recent_slider = array();  
        $this->recent_posts_list = array();  
        $this->download = array();  
        $this->member = array();  
        $this->wgt_member = array();   
        $this->wgt_twitter = array();  
        $this->colored_head = array();                       
    }

    public $core;
    public $common;
    
    // segments
    public $blog;
    public $post;
    public $page_title;
    public $page_content;
    public $heading; 
    public $sidebar;
    public $gmap;   
    public $cform;  
    public $text;
    public $empty_space;
    public $top_anchor;
    public $line_divider; 
    public $img_divider; 
    public $note;  
    public $blockquote;  
    public $ul_list;  
    public $postbox;  
    public $pagebox;
    public $image;   
    public $video;  
    public $tip;  
    public $ngg;
    public $ngg_thumbs_slider;  
    public $ngg_gallery;  
    public $service;  
    public $project; 
    public $basic_slider; 
    public $code; 
    public $board_slider;  
    public $anno_box; 
    public $ngg_recent_slider;  
    public $recent_posts_list; 
    public $download;  
    public $member;  
    public $wgt_member;   
    public $wgt_twitter;  
    public $colored_head;
}


/*********************************************************** 
* Class name:
*    DCC_PageMetaContentBuilderOpt
* Descripton:
***********************************************************/
class DCC_PageMetaContentBuilderOpt extends DCC_MetaPageBuilder 
{        
    /*********************************************************** 
    * Constructor
    ************************************************************/
    public function __construct($register=true) 
    {
        $this->_opt_name = 'content_builder_opt';
                                                       
        $this->_title = 'Content Builder Settings';
        $this->_slug = '004-dc-page-content-builder-settings';
        $this->_closed = true;
        $this->_post_type = 'page';
        
        if($register)
        {
            add_action('admin_menu', array(&$this, 'adminMenu')); 
            add_action('save_post', array(&$this, 'save'));  
        }         
    }       
    
    /*********************************************************** 
    * Public functions
    ************************************************************/    
    public function createStandardMetaOjectData($args=array())
    {
        $def = array(

        );
        
        $args = $this->combineArgs($def, $args);
        
      //  $meta = new stdClass();       
        $meta = new DCC_CBuilderStdMetaObjData();
        $meta->core = array();
        $meta->cells = array();
        
        // core
        $meta->core['order'] = '';  
        
        return $meta;
    }
    
    public function createStandardCellOjectData($args=array())
    {
        $def = array(                        
            'id' => CMS_NOT_SELECTED,
            'type' => CMS_NOT_SELECTED,
            'name' => CMS_NOT_SELECTED,
            'note' => '',
            'size-up' => 1,
            'size-down' => 4,
        );
        
        $args = $this->combineArgs($def, $args);        
        
       // $cell = new stdClass(); 
        $cell = new DCC_CBuilderStdCellObjData();        
        $cell->core = array();
        $cell->common = array();
                              
        $cell->core['id'] = $args['id'];
        $cell->core['type'] = $args['type'];
        $cell->core['name'] = $args['name'];
        $cell->core['note'] = $args['note'];
        $cell->core['size-up'] = $args['size-up'];
        $cell->core['size-down'] = $args['size-down'];     
        $cell->core['time'] = time(); 
        
        $cell->common['pb'] = 20;
        $cell->common['pt'] = 0;
        $cell->common['pl'] = 0;
        $cell->common['pr'] = 0;
        
        $cell->common['clear'] = 'none'; // none, left, right, both
        $cell->common['float'] = 'left'; // left, right
        $cell->common['display'] = true;
        
        $cell->common['pb-use'] = true;
        $cell->common['pt-use'] = false;
        $cell->common['pl-use'] = false;
        $cell->common['pr-use'] = false;

        $cell->common['pb-dis'] = false;
        $cell->common['pt-dis'] = false;
        $cell->common['pl-dis'] = false;
        $cell->common['pr-dis'] = false;
        
        $cell->common['header_title'] = '';
        $cell->common['header_subtitle'] = '';   
        $cell->common['header_display'] = false;
        $cell->common['header_sub_display'] = false; 
        $cell->common['header_bottom'] = 10;
        $cell->common['header_bstyle'] = 'solid';
        $cell->common['header_bcolor'] = '#E8E8E8';
        $cell->common['header_align'] = 'left';
        $cell->common['header_inside'] = false; 
        $cell->common['header_border'] = true;          
        $cell->common['header_as_h'] = false; 
        $cell->common['header_h_size'] = 4;
        $cell->common['header_h_pb'] = 0;
                        
        if($args['type'] == 'blog')
        {
            $cell->blog = array();    
   
            $cell->blog['cat'] = array();
            $cell->blog['cat-excluded'] = array();
            $cell->blog['order'] = 'DESC';
            $cell->blog['order-by'] = 'date';
            $cell->blog['per-page'] = 5;              
            $cell->blog['pagination'] = false;
            $cell->blog['layout'] = 'default'; // normal, compact, default
        }  
        
        if($args['type'] == 'post')
        {
            $cell->post = array();
        
            $cell->post['id'] = '';
            $cell->post['layout'] = 'default';
        }            

        if($args['type'] == 'page-title')
        {
            $cell->common['pb-use'] = false;
            
            $cell->page_title = array();  
                                    
            $cell->page_title['title'] = ''; 
            $cell->page_title['subtitle'] = ''; 
            $cell->page_title['title_use'] = false;
            $cell->page_title['subtitle_use'] = false;
            
            $cell->page_title['title_color'] = '#444444'; 
            $cell->page_title['title_color_use'] = false; 
            $cell->page_title['text'] = '';
            $cell->page_title['text_use'] = false;
            $cell->page_title['align_title'] = 'left';
            $cell->page_title['align_text'] = 'left';               
        }
        
        if($args['type'] == 'page-content')
        {
            $cell->common['pb-use'] = false;   
            
            $cell->page_content = array();             

            $cell->page_content['page'] = CMS_NOT_SELECTED;
            $cell->page_content['page_use'] = false; 
            $cell->page_content['pagination'] = true; 
            
        }      
                  
        if($args['type'] == 'heading')
        {  
            
            $cell->heading = array();             

            $cell->heading['size'] = 4;
            $cell->heading['align'] = 'left'; 
            $cell->heading['title'] = '';
            $cell->heading['subtitle'] = '';
            $cell->heading['title_color'] = '#444444';
            $cell->heading['subtitle_color'] = '#AAAAAA';

            $cell->heading['title_use'] = true;  
            $cell->heading['subtitle_use'] = false;

            $cell->heading['title_color_use'] = false;  
            $cell->heading['subtitle_color_use'] = false;        
            
            $cell->heading['title_fsize'] = 38;  
            $cell->heading['title_lheight'] = 42;  
            
            $cell->heading['subtitle_fsize'] = 20;  
            $cell->heading['subtitle_lheight'] = 22;  
            $cell->heading['subtitle_pt'] = 0;
            
            $cell->heading['title_font_sizes_use'] = false;  
            $cell->heading['subtitle_font_sizes_use'] = false;
            
        }    
        
        if($args['type'] == 'sidebar')
        {
            $cell->sidebar = array();  
            
            $cell->sidebar['sid'] = CMS_NOT_SELECTED;             
        }        
        
        if($args['type'] == 'gmap')
        {
            $cell->gmap = array();  
            
            $cell->gmap['height'] = 320;
            $cell->gmap['latitude'] = 0;
            $cell->gmap['longitude'] = 0;
            $cell->gmap['type'] = 'ROADMAP'; // ROADMAP, SATELLITE, HYBRID, TERRAIN
            $cell->gmap['marker-display'] = false;
            $cell->gmap['marker-popup'] = false;
            $cell->gmap['wheel'] = true;
            $cell->gmap['controls'] = true;
            $cell->gmap['marker-text'] = '';
            $cell->gmap['marker-head'] = '';
            $cell->gmap['zoom'] = 1; // 1-19
            $cell->gmap['hue'] = '#FFCC00';   
            $cell->gmap['saturation'] = 1; // -100 to 100    
            $cell->gmap['lightness'] = 0; // -100 to 100   
            $cell->gmap['gamma'] = 100; // 1 to 999                                 
            $cell->gmap['hue_use'] = false;   
            $cell->gmap['saturation_use'] = false;     
            $cell->gmap['lightness_use'] = false;    
            $cell->gmap['gamma_use'] = false;     
        } 
                 
        if($args['type'] == 'cform')
        {
            $cell->cform = array();  
            
            $cell->cform['id'] = CMS_NOT_SELECTED;
            $cell->cform['address'] = '';   
        }

        if($args['type'] == 'text')
        {
            $cell->text = array();
            
            $cell->text['content'] = '';
            $cell->text['sc_filter'] = false; 
            $cell->text['wp_filter'] = true;      
        } 

        if($args['type'] == 'empty-space')
        {
            $cell->empty_space = array();   
            
            $cell->empty_space['h'] = 50;              
        } 
        
        if($args['type'] == 'top-anchor')
        {
            $cell->top_anchor = array();   
            
            $cell->top_anchor['text'] = 'Top';                         
        }  
               
        if($args['type'] == 'line-divider')
        {
            $cell->line_divider = array();   
            
            $cell->line_divider['bsize'] = 1;
            $cell->line_divider['bstyle'] = 'solid'; // solid, dashed, dotted
            $cell->line_divider['bcolor'] = '#F0F0F0';                                     
        }  

        if($args['type'] == 'img-divider')
        {
            $cell->img_divider = array();   
            
            $cell->img_divider['h'] = 10;
            $cell->img_divider['pattern'] = '';
            $cell->img_divider['bgrepeat'] = 'repeat'; 
            $cell->img_divider['bgpos'] = 'left top';  
            $cell->img_divider['bgimage'] = '';
            $cell->img_divider['bgcolor'] = '#FFFFFF';
            $cell->img_divider['bgcolor_use'] = false;                       
        }  
        
        if($args['type'] == 'note') 
        {
            $cell->note = array(); 
            
            $cell->note['content'] = '';
            $cell->note['color'] = '#202020';  
            $cell->note['bgcolor'] = '#FFFFFF';  
            $cell->note['bcolor'] = '#F2F2F2';
            $cell->note['bwidth'] = 10;
            $cell->note['execute'] = false;
            $cell->note['rounded'] = 0;      
        }       
        
        if($args['type'] == 'blockquote')
        {
            $cell->blockquote = array();  
            
            $cell->blockquote['content'] = '';
            $cell->blockquote['title'] = '';
            $cell->blockquote['author'] = '';
            $cell->blockquote['align'] = 'left';
            $cell->blockquote['color'] = '#808080';
            $cell->blockquote['fsize'] = 16; 
            $cell->blockquote['lheight'] = 22;  
        }
                 
        if($args['type'] == 'ul-list')
        {
            $cell->ul_list = array(); 
            
            $cell->ul_list['content'] = '';
            $cell->ul_list['type'] = 'default';             
        }        
        
        if($args['type'] == 'postbox')  
        {
            $cell->postbox = array();   
            
            $cell->postbox['id'] = '';
            $cell->postbox['desc'] = '';
            $cell->postbox['words'] = 16;
            $cell->postbox['url'] = '';
            $cell->postbox['border'] = true;         
        }

        if($args['type'] == 'pagebox')  
        {
            $cell->pagebox = array();   
            
            $cell->pagebox['id'] = '';
            $cell->pagebox['desc'] = '';
            $cell->pagebox['words'] = 16;
            $cell->pagebox['url'] = ''; 
            $cell->pagebox['border'] = true;      
        }

        if($args['type'] == 'image')  
        {
            $cell->image = array();   
            
            $cell->image['url'] = '';
            $cell->image['alt'] = '';
            $cell->image['align'] = 'left';  
            $cell->image['title'] = '';
            $cell->image['desc'] = '';  
            $cell->image['padding'] = 0;
            $cell->image['border'] = false;
            $cell->image['lightbox'] = false;
            $cell->image['link'] = '';
            $cell->image['image_as_link'] = false;
            $cell->image['new_tab'] = false; 
            $cell->image['group'] = '';
            $cell->image['grayscale'] = false;
            $cell->image['real_size'] = true;
            $cell->image['viewport_w'] = 600;
            $cell->image['viewport_h'] = 400;                                      
        }        

        if($args['type'] == 'video')  
        {
            $cell->video = array();   
            
            $cell->video['content'] = ''; 
            $cell->video['url'] = '';    
            $cell->video['desc_use'] = true;  
        }  
        
        if($args['type'] == 'tip')  
        {
            $cell->tip = array();   
            
            $cell->tip['content'] = '';
            $cell->tip['url'] = '';
            $cell->tip['image_use'] = false;   
            $cell->tip['link'] = '';
            $cell->tip['link_use'] = false; 
            $cell->tip['link_name'] = __('Read more', CMS_TXT_DOMAIN);
            $cell->tip['color'] = '#666666'; 
            $cell->tip['new_tab'] = false;
            $cell->tip['title'] = '';
            $cell->tip['image_space'] = 100;       
        }        
            
        if($args['type'] == 'ngg')  
        {
            $cell->ngg = array();   
            
            $cell->ngg['id'] = CMS_NOT_SELECTED; 
            
            $cell->ngg['w'] = 80; 
            $cell->ngg['h'] = 80;  
            $cell->ngg['tright'] = 10; 
            $cell->ngg['tbottom'] = 10;   
            
            $cell->ngg['padding'] = 0;
            $cell->ngg['count'] = 16;
            $cell->ngg['group'] = '';
            
            $cell->ngg['bcolor'] = '#EEEEEE';
            $cell->ngg['bgcolor'] = '#FFFFFF';
            
            $cell->ngg['random'] = false;
            $cell->ngg['all'] = false;
            $cell->ngg['bgcolor_use'] = false;
            $cell->ngg['border'] = false;                  
        }              
                 
        if($args['type'] == 'ngg-thumbs-slider')  
        {
            $cell->ngg_thumbs_slider = array();   
            
            $cell->ngg_thumbs_slider['id'] = CMS_NOT_SELECTED; 
            $cell->ngg_thumbs_slider['desc'] = '';
            $cell->ngg_thumbs_slider['viewport_w'] = 960;
            $cell->ngg_thumbs_slider['viewport_h'] = 480;
            
            $cell->ngg_thumbs_slider['thumb_size'] = 40; 
            $cell->ngg_thumbs_slider['count'] = 16; 
            $cell->ngg_thumbs_slider['transition'] = 'slide'; // fade, slide, none 
            $cell->ngg_thumbs_slider['bcolor'] = '#FFFFFF'; 

            $cell->ngg_thumbs_slider['slide_title'] = false; 
            $cell->ngg_thumbs_slider['slide_desc'] = false; 
            $cell->ngg_thumbs_slider['all'] = false; 
            $cell->ngg_thumbs_slider['random'] = false;                        
        }       
        
        if($args['type'] == 'ngg-gallery')  
        {
            $cell->ngg_gallery = array();   
                                                            
            $cell->ngg_gallery['id'] = CMS_NOT_SELECTED; 
            $cell->ngg_gallery['per_page'] = 6;
            $cell->ngg_gallery['list'] = ''; 
            $cell->ngg_gallery['columns'] = 3;
            $cell->ngg_gallery['exclude'] = true;
            $cell->ngg_gallery['group'] = '';
            $cell->ngg_gallery['order'] = 'ASC';  // DESC, ASC 
            $cell->ngg_gallery['orderby'] = 'sortorder';  // sortorder, imagedate 
            $cell->ngg_gallery['pagination'] = true;
            $cell->ngg_gallery['viewport_w'] = 400;
            $cell->ngg_gallery['viewport_h'] = 300;
            $cell->ngg_gallery['viewport_use'] = true;
            $cell->ngg_gallery['item_bottom'] = 30; 
            $cell->ngg_gallery['item_bottom_use'] = false; 
            $cell->ngg_gallery['grayscale'] = false; 
            $cell->ngg_gallery['title_display'] = false; 
            $cell->ngg_gallery['date_display'] = false; 
            $cell->ngg_gallery['desc_display'] = false; 
            $cell->ngg_gallery['meta_size'] = false; 
            $cell->ngg_gallery['meta_download'] = false;                                              
        }                

        if($args['type'] == 'service')  
        {
            $cell->service = array();
            
            $cell->service['count'] = 10; 
            $cell->service['cats'] = array(); 
            $cell->service['words'] = 24; 
            $cell->service['columns'] = 2; 
            $cell->service['size'] = 80; 
            $cell->service['layout'] = 'classic'; // classic, box 
            $cell->service['list'] = '';
            $cell->service['order'] = 'DESC'; // DESC, ASC 
            $cell->service['orderby'] = 'date'; // date, title, rand        
            $cell->service['viewport_use'] = false;
            $cell->service['viewport_w'] = 400;
            $cell->service['viewport_h'] = 400;               
            $cell->service['item_bottom'] = 30; 
            $cell->service['item_bottom_use'] = false; 
            
        }
        
        if($args['type'] == 'project')  
        {
            $cell->project = array();
            
            $cell->project['per_page'] = 8; 
            $cell->project['cats'] = array(); 
            $cell->project['words'] = 24; 
            $cell->project['columns'] = 2;             
            $cell->project['pagination'] = false; 
            $cell->project['excerpt'] = true;
            $cell->project['list'] = '';
            $cell->project['order'] = 'DESC'; // DESC, ASC 
            $cell->project['orderby'] = 'date'; // date, title, comment_count 
            $cell->project['viewport_use'] = true;
            $cell->project['viewport_w'] = 400;
            $cell->project['viewport_h'] = 300;
            
            $cell->project['cats_display'] = true; 
            $cell->project['title_display'] = true; 
            $cell->project['item_bottom'] = 30; 
            $cell->project['item_bottom_use'] = false; 
                             
        }  
           
        
        if($args['type'] == 'basic-slider')  
        {
            $cell->basic_slider = array(); 
            
            $cell->basic_slider['auto'] = true;
            $cell->basic_slider['maxwidth'] = 0;
            $cell->basic_slider['speed'] = 600; 
            $cell->basic_slider['timeout'] = 6000; 
            $cell->basic_slider['transition'] = 'fade';  // fade, slide
            $cell->basic_slider['pause'] = true; 
            $cell->basic_slider['pager'] = true; 
            $cell->basic_slider['nextprev'] = true; 
            $cell->basic_slider['viewport_use'] = false;
            $cell->basic_slider['viewport_w'] = 600;
            $cell->basic_slider['viewport_h'] = 320;
            
            $cell->basic_slider['title_size'] = 3;  
            $cell->basic_slider['title_as_h'] = false;  
            $cell->basic_slider['title_color'] = '#FFFFFF';                                   
                        
            $cell->basic_slider['slides'] = array();   
        }     
                
        if($args['type'] == 'code')  
        {
            $cell->code = array(); 
        
            $cell->code['lang'] = 'code'; // code, php, css, html
            $cell->code['content'] = '';
            $cell->code['minimized'] = false;
            $cell->code['stripes'] = false;
            $cell->code['title'] = '';
            $cell->code['title_use'] = false;
            $cell->code['desc'] = '';  
            $cell->code['desc_use'] = false;
        }         

        if($args['type'] == 'board-slider')  
        {
            $cell->core['size-up'] = 1;
            $cell->core['size-down'] = 1;  
            
            $cell->common['pb-dis'] = false;
            $cell->common['pt-dis'] = false;
            $cell->common['pl-dis'] = true;
            $cell->common['pr-dis'] = true;                         
            
            $cell->board_slider = array(); 
        
            $cell->board_slider['lines_count'] = 2;
            $cell->board_slider['pages_count'] = 2;
            $cell->board_slider['cats_post'] = array(); 
            $cell->board_slider['cats_page'] = array();
            $cell->board_slider['list'] = '';
            $cell->board_slider['in_posts'] = true; 
            $cell->board_slider['in_pages'] = true; 
            $cell->board_slider['mode'] = 'normal'; // normal, full-gray, full-gray-hover-color   
            $cell->board_slider['excerpt'] = true;
            $cell->board_slider['title'] = true;
            $cell->board_slider['excerpt_words_count'] = 16; 
            $cell->board_slider['order'] = 'DESC';
            $cell->board_slider['orderby'] = 'date';
            $cell->board_slider['autoplay'] = false;
            $cell->board_slider['autoplay_time'] = 8;
            $cell->board_slider['desc_hide_on_hover'] = false; 
            $cell->board_slider['desc_show_on_hover'] = false; 
            $cell->board_slider['desc_bottom'] = false;  
            $cell->board_slider['show_hidden_post_img'] = false; 
             
        }   
        
        if($args['type'] == 'anno-box') 
        {
            $cell->anno_box = array();
            
            $cell->anno_box['title'] = '';
            $cell->anno_box['title_use'] = true; 
            $cell->anno_box['title_size'] = 2; 
            
            $cell->anno_box['subtitle'] = '';
            $cell->anno_box['subtitle_use'] = true;
            
            $cell->anno_box['text'] = '';            
            $cell->anno_box['text_use'] = true;
            $cell->anno_box['text_fsize'] = 14;  
            $cell->anno_box['text_lheight'] = 22;  
            $cell->anno_box['text_font_sizes_use'] = false;            
            $cell->anno_box['align'] = 'center';   
            
            $cell->anno_box['btn_color'] = '#444444'; 
            $cell->anno_box['btn_hcolor'] = '#000000'; 
            $cell->anno_box['btn_bgcolor'] = '#EAEAEA'; 
            $cell->anno_box['btn_bghcolor'] = '#D2D2D2';           
            
            $cell->anno_box['btn_a_display'] = false;
            $cell->anno_box['btn_a_name'] = '';
            $cell->anno_box['btn_a_link'] = '';
            $cell->anno_box['btn_a_blank'] = false;         

            $cell->anno_box['btn_b_display'] = false;
            $cell->anno_box['btn_b_name'] = '';
            $cell->anno_box['btn_b_link'] = '';
            $cell->anno_box['btn_b_blank'] = false;     
           
            $cell->anno_box['btn_c_display'] = false;
            $cell->anno_box['btn_c_name'] = '';
            $cell->anno_box['btn_c_link'] = '';
            $cell->anno_box['btn_c_blank'] = false;                         
        }
        
        if($args['type'] == 'ngg-recent-slider')
        {
            $cell->core['size-up'] = 1;
            $cell->core['size-down'] = 1;  
            
            $cell->common['pb-dis'] = false;
            $cell->common['pt-dis'] = false;
            $cell->common['pl-dis'] = true;
            $cell->common['pr-dis'] = true;              
            
            $cell->ngg_recent_slider = array();  
            
            $cell->ngg_recent_slider['id'] = CMS_NOT_SELECTED;                
            $cell->ngg_recent_slider['pages'] = 3;
            $cell->ngg_recent_slider['orderby'] = 'date';
            $cell->ngg_recent_slider['perpage'] = 4; // 1 to 5
            $cell->ngg_recent_slider['viewport_w'] = 400;
            $cell->ngg_recent_slider['viewport_h'] = 300;
            $cell->ngg_recent_slider['alttext'] = false;
            $cell->ngg_recent_slider['grayscale'] = false;
            $cell->ngg_recent_slider['desc'] = '';
            $cell->ngg_recent_slider['desc_use'] = false;                    
        } 
        
        
        if($args['type'] == 'recent-posts-list')
        {
            $cell->recent_posts_list = array(); 
            
            $cell->recent_posts_list['cats'] = array(); 
            $cell->recent_posts_list['list'] = '';
            $cell->recent_posts_list['count'] = 3; 
            $cell->recent_posts_list['words'] = 16;
            $cell->recent_posts_list['order'] = 'DESC'; // DESC, ASC  
            $cell->recent_posts_list['orderby'] = 'date'; // date, title, comment_count
            $cell->recent_posts_list['grayscale'] = false;   
            $cell->recent_posts_list['excerpt_use'] = true;
            $cell->recent_posts_list['elapsed_time'] = false; 
            $cell->recent_posts_list['layout'] = 'classic'; // classic, box  
            $cell->recent_posts_list['columns'] = 1;   
            $cell->recent_posts_list['item_bottom'] = 30; 
            $cell->recent_posts_list['item_bottom_use'] = false;    
            
            $cell->recent_posts_list['viewport_w'] = 400; 
            $cell->recent_posts_list['viewport_h'] = 400;  
            $cell->recent_posts_list['viewport_use'] = true;  
            
            $cell->recent_posts_list['title_display'] = true;  
            $cell->recent_posts_list['date_display'] = true;  
            $cell->recent_posts_list['excerpt_display'] = true;
            
            $cell->recent_posts_list['pagination'] = false;                            
        }

                 
        if($args['type'] == 'download')
        {
            $cell->download = array(); 
        
            $cell->download['title'] = '';
            $cell->download['title_size'] = 4;
            $cell->download['subtitle'] = ''; 
            $cell->download['desc'] = ''; 
            $cell->download['file_name'] = '';
            $cell->download['file_size'] = ''; 
            $cell->download['file_url'] = '';  
            $cell->download['icon_url'] = ''; 
            $cell->download['icon_w'] = 64; 
            $cell->download['btn_pos'] = 'left'; // left, center, right
            
            $cell->download['title_use'] = false;
            $cell->download['desc_use'] = false;   
            $cell->download['file_name_use'] = false;
            $cell->download['file_size_use'] = false;
            $cell->download['icon_use'] = false;    
            $cell->download['arrow_display'] = false; 
        }        
        
        if($args['type'] == 'member')  
        {
            $cell->member = array();
            
            $cell->member['per_page'] = 8; 
            $cell->member['cats'] = array(); 
            $cell->member['words'] = 24; 
            $cell->member['columns'] = 2;             
            $cell->member['pagination'] = false; 
            $cell->member['excerpt'] = true;
            $cell->member['list'] = '';
            $cell->member['order'] = 'DESC'; // DESC, ASC 
            $cell->member['orderby'] = 'date'; // date, title, comment_count 
            $cell->member['viewport_use'] = true;
            $cell->member['viewport_w'] = 300;
            $cell->member['viewport_h'] = 400;
            
            $cell->member['title_display'] = true; 
            $cell->member['item_bottom'] = 30; 
            $cell->member['item_bottom_use'] = false; 
            
            $cell->member['link_to_single'] = true;
            $cell->member['grayscale'] = false;
            
            $cell->member['meta_title'] = false;
            $cell->member['meta_subtitle'] = false;  
            $cell->member['meta_addinfo'] = false;
            $cell->member['addinfo_words'] = 24; 
            $cell->member['meta_website'] = false;
            $cell->member['meta_twitter'] = false;
            $cell->member['meta_facebook'] = false;                     
        }  
        
        if($args['type'] == 'wgt-member')  
        {
            $cell->wgt_member = array();
            
            $cell->wgt_member['per_page'] = 4; 
            $cell->wgt_member['cats'] = array(); 
            $cell->wgt_member['words'] = 24;         

            $cell->wgt_member['list'] = '';
            $cell->wgt_member['columns'] = 1;
            $cell->wgt_member['order'] = 'DESC'; // DESC, ASC 
            $cell->wgt_member['orderby'] = 'date'; // date, title, comment_count 
            $cell->wgt_member['viewport_use'] = false;
            $cell->wgt_member['viewport_w'] = 300;
            $cell->wgt_member['viewport_h'] = 400;
            
            $cell->wgt_member['link_to_single'] = true;
            $cell->wgt_member['grayscale'] = false;
            $cell->wgt_member['image_width'] = 50;  
            
            $cell->wgt_member['meta_title'] = false; 
            $cell->wgt_member['meta_subtitle'] = false; 
            $cell->wgt_member['meta_addinfo'] = false; 
            $cell->wgt_member['addinfo_words'] = 24;
            $cell->wgt_member['item_bottom'] = 25; 
            $cell->wgt_member['item_bottom_use'] = false;            
                                       
        }      
        
        if($args['type'] == 'wgt-twitter')  
        {
            $cell->wgt_twitter = array();
            
            $cell->wgt_twitter['twitter_screen_name'] = '';
            $cell->wgt_twitter['tweetes_count'] = 5;  
            $cell->wgt_twitter['tweetes_refresh'] = 7200;  
            $cell->wgt_twitter['image_display'] = true;   
            $cell->wgt_twitter['time_offset'] = 0;   
            $cell->wgt_twitter['time_format'] = 'F j, Y, g:i a'; 
            $cell->wgt_twitter['tweets_count_display'] = true; 
            $cell->wgt_twitter['date_display'] = true; 
            $cell->wgt_twitter['reset'] = false;
            $cell->wgt_twitter['layout'] = 'column'; // column, wide 
            $cell->wgt_twitter['left_side_w'] = 200;             
        }   
        
        if($args['type'] == 'colored-head')  
        {
            $cell->colored_head = array();
        
            $cell->colored_head['prefix'] = ''; 
            $cell->colored_head['prefix_w'] = 0; 
            $cell->colored_head['prefix_align'] = 'left'; 
            $cell->colored_head['prefix_bgcolor'] = '#71639C'; 
            $cell->colored_head['prefix_percent'] = false;
            $cell->colored_head['text'] = '';  
            $cell->colored_head['color'] = '#222222'; 
            $cell->colored_head['bgcolor'] = '#F4F4F4';                   
        }                               
            
        return $cell;    
    }                                               
    
    public function save($id)
    {
        $new_cells = array();
        $meta = $this->createStandardMetaOjectData();
        
        $meta->core['order'] = '';
        if(isset($_POST['dc-builder-meta-order'])) { $meta->core['order'] = $_POST['dc-builder-meta-order']; }
        
        if($meta->core['order'] != '')
        {
            $order = explode(',', $meta->core['order']);
            
            foreach($order as $id_) 
            {
                if(array_key_exists('segment-cell-id-'.$id_, $_POST))
                {
                    $cell = self::getCell($id_);                 
                    array_push($new_cells, $cell);  
                }              
            }   
        } else                                 
        {
            foreach($_POST as $key => $value)
            {
                if(strstr($key, 'segment-cell-id-'))
                {                    
                    $id_ = str_replace('segment-cell-id-', '', $key);                

                    $cell = self::getCell($id_);
                    
                    array_push($new_cells, $cell);
                }            
            }
        }        
       
       
        if(count($new_cells))
        {
            $meta->cells = $new_cells;
            
            update_post_meta(
                $id, 
                $this->_opt_name, 
                $meta); 
        } 
    }       
    
    private function convertWinBR($content)
    {
        return str_replace(array("\r\n", "\r", "\n"), "\n", $content);    
    }
    
    public function getCell($id)
    {        
        $cell = self::createStandardCellOjectData();
        $prename = 'segment-cell-data-'.$id;
       
        
        $cell->core['id'] = $_POST[$prename.'-core-id'];
        $cell->core['type'] = $_POST[$prename.'-core-type']; 
        $cell->core['name'] = $_POST[$prename.'-core-name'];
        $cell->core['note'] = $this->convertWinBR(trim($_POST[$prename.'-core-note']));
        $cell->core['size-up'] = $_POST[$prename.'-core-size-up'];
        $cell->core['size-down'] = $_POST[$prename.'-core-size-down'];        
        $cell->core['time'] = $_POST[$prename.'-core-time'];  
        
        $cell->common['pb'] = $_POST[$prename.'-common-pb']; 
        $cell->common['pt'] = $_POST[$prename.'-common-pt'];
        $cell->common['pl'] = $_POST[$prename.'-common-pl'];
        $cell->common['pr'] = $_POST[$prename.'-common-pr'];
        
        $cell->common['pb-use'] = isset($_POST[$prename.'-common-pb-use']) ? true : false;  
        $cell->common['pt-use'] = isset($_POST[$prename.'-common-pt-use']) ? true : false; 
        $cell->common['pl-use'] = isset($_POST[$prename.'-common-pl-use']) ? true : false; 
        $cell->common['pr-use'] = isset($_POST[$prename.'-common-pr-use']) ? true : false; 

        $cell->common['pb-dis'] = isset($_POST[$prename.'-common-pb-dis']) ? true : false;  
        $cell->common['pt-dis'] = isset($_POST[$prename.'-common-pt-dis']) ? true : false; 
        $cell->common['pl-dis'] = isset($_POST[$prename.'-common-pl-dis']) ? true : false; 
        $cell->common['pr-dis'] = isset($_POST[$prename.'-common-pr-dis']) ? true : false; 
        
        $cell->common['clear'] = $_POST[$prename.'-common-clear']; 
        $cell->common['float'] = $_POST[$prename.'-common-float'];  
        $cell->common['display'] = isset($_POST[$prename.'-common-display']) ? true : false;
        
        $cell->common['header_title']   = $this->convertWinBR($_POST[$prename.'-common-header_title']); 
        $cell->common['header_subtitle']   = $this->convertWinBR($_POST[$prename.'-common-header_subtitle']);  
        $cell->common['header_align']   = $_POST[$prename.'-common-header_align'];
        $cell->common['header_bstyle']  = $_POST[$prename.'-common-header_bstyle']; 
        $cell->common['header_bcolor']  = $_POST[$prename.'-common-header_bcolor']; 
        $cell->common['header_bottom']  = $_POST[$prename.'-common-header_bottom'];  
        $cell->common['header_display'] = isset($_POST[$prename.'-common-header_display']) ? true : false;
        $cell->common['header_sub_display'] = isset($_POST[$prename.'-common-header_sub_display']) ? true : false;   
        $cell->common['header_inside']  = isset($_POST[$prename.'-common-header_inside']) ? true : false;  
        $cell->common['header_border']  = isset($_POST[$prename.'-common-header_border']) ? true : false;  
        $cell->common['header_as_h']    = isset($_POST[$prename.'-common-header_as_h']) ? true : false;
        $cell->common['header_h_size']  = $_POST[$prename.'-common-header_h_size']; 
        $cell->common['header_h_pb']    = $_POST[$prename.'-common-header_h_pb']; 
        
        
        switch($cell->core['type'])
        {
            case 'page-title':
            {
                $cell->page_title['title'] = $this->convertWinBR($_POST[$prename.'-page_title-title']);
                $cell->page_title['subtitle'] = $this->convertWinBR($_POST[$prename.'-page_title-subtitle']);
                
                $cell->page_title['title_use'] = isset($_POST[$prename.'-page_title-title_use']) ? true : false;
                $cell->page_title['subtitle_use'] = isset($_POST[$prename.'-page_title-subtitle_use']) ? true : false; 
                          
                $cell->page_title['title_color'] = $_POST[$prename.'-page_title-title_color'];
                $cell->page_title['title_color_use'] = isset($_POST[$prename.'-page_title-title_color_use']) ? true : false;    
                
                $cell->page_title['text'] = $this->convertWinBR($_POST[$prename.'-page_title-text']);
                $cell->page_title['text_use'] = isset($_POST[$prename.'-page_title-text_use']) ? true : false; 
                $cell->page_title['align_title'] = $_POST[$prename.'-page_title-align_title'];
                $cell->page_title['align_text'] = $_POST[$prename.'-page_title-align_text'];
            } break;
            
            case 'page-content':
            {
                $cell->page_content['page'] = $_POST[$prename.'-page_content-page'];
                $cell->page_content['page_use'] = isset($_POST[$prename.'-page_content-page_use']) ? true : false;  
                $cell->page_content['pagination'] = isset($_POST[$prename.'-page_content-pagination']) ? true : false;
                     
            } break;
            
            case 'heading':
            {
                $cell->heading['size'] = $_POST[$prename.'-heading-size'];
                $cell->heading['title'] = $this->convertWinBR($_POST[$prename.'-heading-title']);  
                $cell->heading['subtitle'] = $this->convertWinBR($_POST[$prename.'-heading-subtitle']);  
                $cell->heading['title_color'] = $_POST[$prename.'-heading-title_color'];  
                $cell->heading['subtitle_color'] = $_POST[$prename.'-heading-subtitle_color'];
                $cell->heading['align'] = $_POST[$prename.'-heading-align'];
                $cell->heading['title_fsize'] = $_POST[$prename.'-heading-title_fsize'];   
                $cell->heading['title_lheight'] = $_POST[$prename.'-heading-title_lheight'];   
                $cell->heading['subtitle_fsize'] = $_POST[$prename.'-heading-subtitle_fsize'];   
                $cell->heading['subtitle_lheight'] = $_POST[$prename.'-heading-subtitle_lheight'];
                $cell->heading['subtitle_pt'] = $_POST[$prename.'-heading-subtitle_pt']; 
                
                      
                $cell->heading['title_use'] = isset($_POST[$prename.'-heading-title_use']) ? true : false;  
                $cell->heading['subtitle_use'] = isset($_POST[$prename.'-heading-subtitle_use']) ? true : false;
                $cell->heading['title_color_use'] = isset($_POST[$prename.'-heading-title_color_use']) ? true : false;  
                $cell->heading['subtitle_color_use'] = isset($_POST[$prename.'-heading-subtitle_color_use']) ? true : false;
                $cell->heading['title_font_sizes_use'] = isset($_POST[$prename.'-heading-title_font_sizes_use']) ? true : false;
                $cell->heading['subtitle_font_sizes_use'] = isset($_POST[$prename.'-heading-subtitle_font_sizes_use']) ? true : false;                       
            } break;
            
            case 'blog':
            {
                $cell->blog['cat'] = $_POST[$prename.'-blog-cat']; 
                $cell->blog['cat-excluded'] = $_POST[$prename.'-blog-cat-excluded'];
                $cell->blog['order'] = $_POST[$prename.'-blog-order']; 
                $cell->blog['order-by'] = $_POST[$prename.'-blog-order-by']; 
                $cell->blog['per-page'] = $_POST[$prename.'-blog-per-page'];
                $cell->blog['pagination'] = isset($_POST[$prename.'-blog-pagination']) ? true : false;
                $cell->blog['layout'] = $_POST[$prename.'-blog-layout'];                      
            } break;
            
            case 'post':
            {
                $cell->post['id'] = $_POST[$prename.'-post-id']; 
                $cell->post['layout'] = $_POST[$prename.'-post-layout'];
            } break;                
            
            case 'sidebar':
            {
                $cell->sidebar['sid'] = $_POST[$prename.'-sidebar-sid'];
            } break;
            
            case 'gmap':
            {
                $cell->gmap['type'] = $_POST[$prename.'-gmap-type'];
                $cell->gmap['height'] = $_POST[$prename.'-gmap-height'];
                $cell->gmap['latitude'] = $_POST[$prename.'-gmap-latitude']; 
                $cell->gmap['longitude'] = $_POST[$prename.'-gmap-longitude']; 
                
                $cell->gmap['zoom'] = $_POST[$prename.'-gmap-zoom'];  
                $cell->gmap['marker-text'] = $this->convertWinBR(stripcslashes($_POST[$prename.'-gmap-marker-text']));
                $cell->gmap['marker-head'] = $this->convertWinBR(stripcslashes($_POST[$prename.'-gmap-marker-head']));
                
                $cell->gmap['marker-display'] = isset($_POST[$prename.'-gmap-marker-display']) ? true : false;
                $cell->gmap['marker-popup'] = isset($_POST[$prename.'-gmap-marker-popup']) ? true : false;
                $cell->gmap['wheel'] = isset($_POST[$prename.'-gmap-wheel']) ? true : false; 
                $cell->gmap['controls'] = isset($_POST[$prename.'-gmap-controls']) ? true : false;   
                
                $cell->gmap['hue'] = $_POST[$prename.'-gmap-hue'];  
                $cell->gmap['saturation'] = $_POST[$prename.'-gmap-saturation'];        
                $cell->gmap['lightness'] = $_POST[$prename.'-gmap-lightness'];        
                $cell->gmap['gamma'] = $_POST[$prename.'-gmap-gamma'];        
                
                $cell->gmap['hue_use'] = isset($_POST[$prename.'-gmap-hue_use']) ? true : false; 
                $cell->gmap['saturation_use'] = isset($_POST[$prename.'-gmap-saturation_use']) ? true : false; 
                $cell->gmap['lightness_use'] = isset($_POST[$prename.'-gmap-lightness_use']) ? true : false; 
                $cell->gmap['gamma_use'] = isset($_POST[$prename.'-gmap-gamma_use']) ? true : false; 
                                    
            } break;
            
            case 'cform':
            {
                $cell->cform['id'] = $_POST[$prename.'-cform-id'];
                $cell->cform['address'] = $_POST[$prename.'-cform-address'];                
            } break;
            
            case 'text':
            {                
                $cell->text['content'] = $this->convertWinBR($_POST[$prename.'-text-content']);    
                $cell->text['sc_filter'] = isset($_POST[$prename.'-text-sc_filter']) ? true : false;
                $cell->text['wp_filter'] = isset($_POST[$prename.'-text-wp_filter']) ? true : false;
            
            } break;
            
            case 'empty-space':
            {                
                $cell->empty_space['h'] = $_POST[$prename.'-empty_space-h'];    
            
            } break;   
            
            case 'top-anchor':
            {
                $cell->top_anchor['text'] = $this->convertWinBR($_POST[$prename.'-top_anchor-text']);
            } break;   
            
            case 'line-divider':
            {
                $cell->line_divider['bsize'] = $_POST[$prename.'-line_divider-bsize'];
                $cell->line_divider['bstyle'] = $_POST[$prename.'-line_divider-bstyle'];
                $cell->line_divider['bcolor'] = $_POST[$prename.'-line_divider-bcolor']; 
            } break;

            case 'img-divider':
            {
                $cell->img_divider['h'] = $_POST[$prename.'-img_divider-h'];
                $cell->img_divider['pattern'] = $_POST[$prename.'-img_divider-pattern'];
                $cell->img_divider['bgrepeat'] = $_POST[$prename.'-img_divider-bgrepeat'];
                $cell->img_divider['bgpos'] = $_POST[$prename.'-img_divider-bgpos'];
                $cell->img_divider['bgimage'] = $_POST[$prename.'-img_divider-bgimage'];
                $cell->img_divider['bgcolor'] = $_POST[$prename.'-img_divider-bgcolor'];
                $cell->img_divider['bgcolor_use'] = isset($_POST[$prename.'-img_divider-bgcolor_use']) ? true : false;  
            } break;
            
            case 'note':
            {
                $cell->note['content'] = $this->convertWinBR($_POST[$prename.'-note-content']); 
                $cell->note['color'] = $_POST[$prename.'-note-color'];
                $cell->note['bgcolor'] = $_POST[$prename.'-note-bgcolor']; 
                $cell->note['bcolor'] = $_POST[$prename.'-note-bcolor'];
                $cell->note['bwidth'] = $_POST[$prename.'-note-bwidth']; 
                $cell->note['align'] = $_POST[$prename.'-note-align']; 
                $cell->note['rounded'] = $_POST[$prename.'-note-rounded']; 
                $cell->note['execute'] = isset($_POST[$prename.'-note-execute']) ? true : false;  
            } break;        
            
            case 'blockquote':
            {
                $cell->blockquote['content'] = $this->convertWinBR($_POST[$prename.'-blockquote-content']); 
                $cell->blockquote['title'] = $this->convertWinBR($_POST[$prename.'-blockquote-title']); 
                $cell->blockquote['author'] = $this->convertWinBR($_POST[$prename.'-blockquote-author']);
                $cell->blockquote['align'] = $_POST[$prename.'-blockquote-align']; 
                $cell->blockquote['color'] = $_POST[$prename.'-blockquote-color'];
                $cell->blockquote['fsize'] = $_POST[$prename.'-blockquote-fsize']; 
                $cell->blockquote['lheight'] = $_POST[$prename.'-blockquote-lheight'];                    
            } break; 
            
            case 'ul-list': 
            {
                $cell->ul_list['type'] = $_POST[$prename.'-ul_list-type'];
                $cell->ul_list['content'] = $this->convertWinBR($_POST[$prename.'-ul_list-content']);     
            } break;   
            
            case 'postbox':
            {
                $cell->postbox['id'] = (int)$_POST[$prename.'-postbox-id'];  
                $cell->postbox['desc'] = $this->convertWinBR($_POST[$prename.'-postbox-desc']); 
                $cell->postbox['words'] = (int)$_POST[$prename.'-postbox-words']; 
                $cell->postbox['url'] = $_POST[$prename.'-postbox-url'];
                $cell->postbox['border'] = isset($_POST[$prename.'-postbox-border']) ? true : false;     
            } break; 
            
            case 'pagebox':
            {
                $cell->pagebox['id'] = (int)$_POST[$prename.'-pagebox-id'];  
                $cell->pagebox['desc'] = $this->convertWinBR($_POST[$prename.'-pagebox-desc']); 
                $cell->pagebox['words'] = (int)$_POST[$prename.'-pagebox-words']; 
                $cell->pagebox['url'] = $_POST[$prename.'-pagebox-url'];
                $cell->pagebox['border'] = isset($_POST[$prename.'-pagebox-border']) ? true : false;     
            } break; 
            
            case 'image':
            {
                $cell->image['url'] = $_POST[$prename.'-image-url'];  
                $cell->image['alt'] = $_POST[$prename.'-image-alt'];  
                $cell->image['align'] = $_POST[$prename.'-image-align'];  
                $cell->image['title'] = $this->convertWinBR($_POST[$prename.'-image-title']);  
                $cell->image['desc'] = $this->convertWinBR($_POST[$prename.'-image-desc']);  
            
                $cell->image['group'] = $this->convertWinBR($_POST[$prename.'-image-group']);
                $cell->image['link'] = $_POST[$prename.'-image-link'];
                $cell->image['padding'] = $_POST[$prename.'-image-padding'];
                $cell->image['viewport_w'] = $_POST[$prename.'-image-viewport_w']; 
                $cell->image['viewport_h'] = $_POST[$prename.'-image-viewport_h']; 
            
                $cell->image['border'] = isset($_POST[$prename.'-image-border']) ? true : false; 
                $cell->image['lightbox'] = isset($_POST[$prename.'-image-lightbox']) ? true : false; 
                $cell->image['image_as_link'] = isset($_POST[$prename.'-image-image_as_link']) ? true : false; 
                $cell->image['new_tab'] = isset($_POST[$prename.'-image-new_tab']) ? true : false; 
                $cell->image['real_size'] = isset($_POST[$prename.'-image-real_size']) ? true : false;  
                $cell->image['grayscale'] = isset($_POST[$prename.'-image-grayscale']) ? true : false;               
            } break;      
            
            case 'video':
            {
                $cell->video['url'] = $_POST[$prename.'-video-url']; 
                $cell->video['content'] = $this->convertWinBR($_POST[$prename.'-video-content']);
                $cell->video['desc_use'] = isset($_POST[$prename.'-video-desc_use']) ? true : false;     
            } break;   
            
            case 'tip':
            {                   
                $cell->tip['content'] = $this->convertWinBR($_POST[$prename.'-tip-content']);
                $cell->tip['title'] = $this->convertWinBR($_POST[$prename.'-tip-title']);
                $cell->tip['link'] = $_POST[$prename.'-tip-link'];
                $cell->tip['link_use'] = isset($_POST[$prename.'-tip-link_use']) ? true : false;  
                $cell->tip['link_name'] = $this->convertWinBR($_POST[$prename.'-tip-link_name']);
                $cell->tip['url'] = $_POST[$prename.'-tip-url'];
                $cell->tip['image_use'] = isset($_POST[$prename.'-tip-image_use']) ? true : false;  
                $cell->tip['color'] = $_POST[$prename.'-tip-color'];  
                $cell->tip['new_tab'] = isset($_POST[$prename.'-tip-new_tab']) ? true : false;
                $cell->tip['image_space'] = $_POST[$prename.'-tip-image_space'];
                     
            } break; 
               
            case 'ngg':
            {
                $cell->ngg['id'] = $_POST[$prename.'-ngg-id']; 
                $cell->ngg['w'] = $_POST[$prename.'-ngg-w'];
                $cell->ngg['h'] = $_POST[$prename.'-ngg-h'];
                $cell->ngg['count'] = $_POST[$prename.'-ngg-count']; 
                $cell->ngg['tright'] = $_POST[$prename.'-ngg-tright']; 
                $cell->ngg['tbottom'] = $_POST[$prename.'-ngg-tbottom'];
                $cell->ngg['group'] = $this->convertWinBR($_POST[$prename.'-ngg-group']);
                $cell->ngg['padding'] = $_POST[$prename.'-ngg-padding']; 
                
                $cell->ngg['bcolor'] = $_POST[$prename.'-ngg-bcolor']; 
                $cell->ngg['bgcolor'] = $_POST[$prename.'-ngg-bgcolor']; 
                
                $cell->ngg['border'] = isset($_POST[$prename.'-ngg-border']) ? true : false;
                $cell->ngg['bgcolor_use'] = isset($_POST[$prename.'-ngg-bgcolor_use']) ? true : false; 
                $cell->ngg['all'] = isset($_POST[$prename.'-ngg-all']) ? true : false; 
                $cell->ngg['random'] = isset($_POST[$prename.'-ngg-random']) ? true : false;      
            } break;   
            
            case 'ngg-thumbs-slider':
            {
                $cell->ngg_thumbs_slider['id'] = $_POST[$prename.'-ngg_thumbs_slider-id'];
                $cell->ngg_thumbs_slider['desc'] = $this->convertWinBR($_POST[$prename.'-ngg_thumbs_slider-desc']);
                $cell->ngg_thumbs_slider['viewport_w'] = $_POST[$prename.'-ngg_thumbs_slider-viewport_w'];
                $cell->ngg_thumbs_slider['viewport_h'] = $_POST[$prename.'-ngg_thumbs_slider-viewport_h'];       
                
                $cell->ngg_thumbs_slider['thumb_size'] = $_POST[$prename.'-ngg_thumbs_slider-thumb_size']; 
                $cell->ngg_thumbs_slider['count'] = $_POST[$prename.'-ngg_thumbs_slider-count']; 
                $cell->ngg_thumbs_slider['transition'] = $_POST[$prename.'-ngg_thumbs_slider-transition']; 
                $cell->ngg_thumbs_slider['bcolor'] = $_POST[$prename.'-ngg_thumbs_slider-bcolor']; 
                
                $cell->ngg_thumbs_slider['slide_title'] = isset($_POST[$prename.'-ngg_thumbs_slider-slide_title']) ? true : false;
                $cell->ngg_thumbs_slider['slide_desc'] = isset($_POST[$prename.'-ngg_thumbs_slider-slide_desc']) ? true : false; 
                $cell->ngg_thumbs_slider['all'] = isset($_POST[$prename.'-ngg_thumbs_slider-all']) ? true : false; 
                $cell->ngg_thumbs_slider['random'] = isset($_POST[$prename.'-ngg_thumbs_slider-random']) ? true : false;                   
                 
            } break;
            
            case 'ngg-gallery':
            {
                $cell->ngg_gallery['id'] = $_POST[$prename.'-ngg_gallery-id'];
                $cell->ngg_gallery['per_page'] = $_POST[$prename.'-ngg_gallery-per_page']; 
                $cell->ngg_gallery['list'] = trim($_POST[$prename.'-ngg_gallery-list']); 
                
                $cell->ngg_gallery['columns'] = $_POST[$prename.'-ngg_gallery-columns']; 
                $cell->ngg_gallery['exclude'] = isset($_POST[$prename.'-ngg_gallery-exclude']) ? true : false; 
                $cell->ngg_gallery['group'] = trim($_POST[$prename.'-ngg_gallery-group']);  
                $cell->ngg_gallery['order'] = $_POST[$prename.'-ngg_gallery-order'];
                $cell->ngg_gallery['orderby'] = $_POST[$prename.'-ngg_gallery-orderby'];
                $cell->ngg_gallery['pagination'] = isset($_POST[$prename.'-ngg_gallery-pagination']) ? true : false;
                $cell->ngg_gallery['viewport_w'] = $_POST[$prename.'-ngg_gallery-viewport_w'];
                $cell->ngg_gallery['viewport_h'] = $_POST[$prename.'-ngg_gallery-viewport_h']; 
                $cell->ngg_gallery['viewport_use'] = isset($_POST[$prename.'-ngg_gallery-viewport_use']) ? true : false;
                $cell->ngg_gallery['item_bottom'] = $_POST[$prename.'-ngg_gallery-item_bottom'];
                $cell->ngg_gallery['item_bottom_use'] = isset($_POST[$prename.'-ngg_gallery-item_bottom_use']) ? true : false;
                
                $cell->ngg_gallery['grayscale'] = isset($_POST[$prename.'-ngg_gallery-grayscale']) ? true : false;    
                
                $cell->ngg_gallery['title_display'] = isset($_POST[$prename.'-ngg_gallery-title_display']) ? true : false; 
                $cell->ngg_gallery['date_display'] = isset($_POST[$prename.'-ngg_gallery-date_display']) ? true : false; 
                $cell->ngg_gallery['desc_display'] = isset($_POST[$prename.'-ngg_gallery-desc_display']) ? true : false; 
                $cell->ngg_gallery['meta_size'] = isset($_POST[$prename.'-ngg_gallery-meta_size']) ? true : false; 
                $cell->ngg_gallery['meta_download'] = isset($_POST[$prename.'-ngg_gallery-meta_download']) ? true : false;             
                                
            } break;            
            
            case 'service':
            {
                $cell->service['count'] = $_POST[$prename.'-service-count'];             
                $cell->service['cats'] = $_POST[$prename.'-service-cats'];
                $cell->service['words'] = $_POST[$prename.'-service-words'];
                $cell->service['columns'] = $_POST[$prename.'-service-columns'];
                $cell->service['size'] = $_POST[$prename.'-service-size'];
                $cell->service['layout'] = $_POST[$prename.'-service-layout'];
                $cell->service['list'] = $_POST[$prename.'-service-list'];
                $cell->service['order'] = $_POST[$prename.'-service-order'];
                $cell->service['orderby'] = $_POST[$prename.'-service-orderby'];
                $cell->service['viewport_w'] = $_POST[$prename.'-service-viewport_w'];
                $cell->service['viewport_h'] = $_POST[$prename.'-service-viewport_h'];     
                $cell->service['viewport_use'] = isset($_POST[$prename.'-service-viewport_use']) ? true : false; 
                $cell->service['item_bottom_use'] = isset($_POST[$prename.'-service-item_bottom_use']) ? true : false; 
                $cell->service['item_bottom'] = $_POST[$prename.'-service-item_bottom'];                  
            } break;                                         
            
            case 'project':  
            {                                       
                $cell->project['per_page'] = $_POST[$prename.'-project-per_page'];             
                $cell->project['cats'] = $_POST[$prename.'-project-cats'];
                $cell->project['words'] = $_POST[$prename.'-project-words'];
                $cell->project['columns'] = $_POST[$prename.'-project-columns'];
                $cell->project['excerpt'] = isset($_POST[$prename.'-project-excerpt']) ? true : false;
                $cell->project['pagination'] = isset($_POST[$prename.'-project-pagination']) ? true : false;
                $cell->project['list'] = $_POST[$prename.'-project-list'];
                $cell->project['order'] = $_POST[$prename.'-project-order'];
                $cell->project['orderby'] = $_POST[$prename.'-project-orderby'];
                $cell->project['viewport_use'] = isset($_POST[$prename.'-project-viewport_use']) ? true : false; 
                $cell->project['viewport_w'] = $_POST[$prename.'-project-viewport_w']; 
                $cell->project['viewport_h'] = $_POST[$prename.'-project-viewport_h'];  
                
                $cell->project['cats_display'] = isset($_POST[$prename.'-project-cats_display']) ? true : false;   
                $cell->project['title_display'] = isset($_POST[$prename.'-project-title_display']) ? true : false;   
                $cell->project['item_bottom_use'] = isset($_POST[$prename.'-project-item_bottom_use']) ? true : false; 
                $cell->project['item_bottom'] = $_POST[$prename.'-project-item_bottom'];   
                                                                       
            } break;   
            
            case 'basic-slider':  
            {
                $order = $_POST[$prename.'-basic_slider-slider-order'];
                $order = explode(',', $order); 
              
                $slides = array();
                if(is_array($order))
                {
                    foreach($order as $index)
                    {
                        if($index == '') { continue; }
                        $slide = new DCC_HTML_BasicSliderSlide();
                        
                        $slide->_url = $_POST[$prename.'-basic_slider-slide-'.$index.'-url'];
                        $slide->_display = isset($_POST[$prename.'-basic_slider-slide-'.$index.'-display']) ? true : false; 
                        $slide->_title = $this->convertWinBR($_POST[$prename.'-basic_slider-slide-'.$index.'-title']); 
                        $slide->_desc = $this->convertWinBR($_POST[$prename.'-basic_slider-slide-'.$index.'-desc']);
                        $slide->_link = $_POST[$prename.'-basic_slider-slide-'.$index.'-link']; 
                        $slide->_title_use = isset($_POST[$prename.'-basic_slider-slide-'.$index.'-title_use']) ? true : false; 
                        $slide->_desc_use = isset($_POST[$prename.'-basic_slider-slide-'.$index.'-desc_use']) ? true : false; 
                        $slide->_link_use = isset($_POST[$prename.'-basic_slider-slide-'.$index.'-link_use']) ? true : false;
                        $slide->_blank = isset($_POST[$prename.'-basic_slider-slide-'.$index.'-blank']) ? true : false;
                        array_push($slides, $slide);
                    }    
                }                
                $cell->basic_slider['slides'] = $slides;                
                
                $cell->basic_slider['auto'] = isset($_POST[$prename.'-basic_slider-auto']) ? true : false;
                $cell->basic_slider['maxwidth'] = $_POST[$prename.'-basic_slider-maxwidth']; 
                $cell->basic_slider['speed'] = $_POST[$prename.'-basic_slider-speed']; 
                $cell->basic_slider['timeout'] = $_POST[$prename.'-basic_slider-timeout'];   
                $cell->basic_slider['transition'] = $_POST[$prename.'-basic_slider-transition'];
                $cell->basic_slider['pause'] = isset($_POST[$prename.'-basic_slider-pause']) ? true : false;
                $cell->basic_slider['pager'] = isset($_POST[$prename.'-basic_slider-pager']) ? true : false;
                $cell->basic_slider['nextprev'] = isset($_POST[$prename.'-basic_slider-nextprev']) ? true : false;
                $cell->basic_slider['viewport_use'] = isset($_POST[$prename.'-basic_slider-viewport_use']) ? true : false; 
                $cell->basic_slider['viewport_w'] = $_POST[$prename.'-basic_slider-viewport_w']; 
                $cell->basic_slider['viewport_h'] = $_POST[$prename.'-basic_slider-viewport_h']; 
                
                $cell->basic_slider['title_size'] = $_POST[$prename.'-basic_slider-title_size']; 
                $cell->basic_slider['title_as_h'] = isset($_POST[$prename.'-basic_slider-title_as_h']) ? true : false; 
                $cell->basic_slider['title_color'] = $_POST[$prename.'-basic_slider-title_color'];                
                                               
            } break;  
            
            case 'code':
            {
                $cell->code['lang'] = $_POST[$prename.'-code-lang']; 
                $cell->code['content'] = $this->convertWinBR(htmlentities($_POST[$prename.'-code-content']));
                $cell->code['minimized'] = isset($_POST[$prename.'-code-minimized']) ? true : false;
                $cell->code['stripes'] = isset($_POST[$prename.'-code-stripes']) ? true : false; 
                $cell->code['title'] =  $this->convertWinBR($_POST[$prename.'-code-title']); 
                $cell->code['desc'] =  $this->convertWinBR($_POST[$prename.'-code-desc']); 
                $cell->code['title_use'] = isset($_POST[$prename.'-code-title_use']) ? true : false;
                $cell->code['desc_use'] = isset($_POST[$prename.'-code-desc_use']) ? true : false;
                
            } break;
    
            case 'board-slider':  
            {
                $cell->board_slider['lines_count'] = $_POST[$prename.'-board_slider-lines_count']; 
                $cell->board_slider['pages_count'] = $_POST[$prename.'-board_slider-pages_count']; 
                $cell->board_slider['mode'] = $_POST[$prename.'-board_slider-mode'];
                $cell->board_slider['cats_post'] = $_POST[$prename.'-board_slider-cats_post']; 
                $cell->board_slider['cats_page'] = $_POST[$prename.'-board_slider-cats_page'];  
                $cell->board_slider['list'] = $_POST[$prename.'-board_slider-list']; 
                $cell->board_slider['autoplay_time'] = $_POST[$prename.'-board_slider-autoplay_time']; 
                $cell->board_slider['autoplay'] = isset($_POST[$prename.'-board_slider-autoplay']) ? true : false;
                $cell->board_slider['title'] = isset($_POST[$prename.'-board_slider-title']) ? true : false;
                $cell->board_slider['excerpt'] = isset($_POST[$prename.'-board_slider-excerpt']) ? true : false;
                $cell->board_slider['in_posts'] = isset($_POST[$prename.'-board_slider-in_posts']) ? true : false;
                $cell->board_slider['in_pages'] = isset($_POST[$prename.'-board_slider-in_pages']) ? true : false;
                $cell->board_slider['excerpt_words_count'] = $_POST[$prename.'-board_slider-excerpt_words_count'];
                $cell->board_slider['order'] = $_POST[$prename.'-board_slider-order']; 
                $cell->board_slider['orderby'] = $_POST[$prename.'-board_slider-orderby'];
                $cell->board_slider['desc_hide_on_hover'] = isset($_POST[$prename.'-board_slider-desc_hide_on_hover']) ? true : false;
                $cell->board_slider['desc_show_on_hover'] = isset($_POST[$prename.'-board_slider-desc_show_on_hover']) ? true : false;                  
                $cell->board_slider['desc_bottom'] = isset($_POST[$prename.'-board_slider-desc_bottom']) ? true : false;   
                $cell->board_slider['show_hidden_post_img'] = isset($_POST[$prename.'-board_slider-show_hidden_post_img']) ? true : false;   
                    
            } break;                
                                                                                                    
            case 'anno-box':
            {
                $cell->anno_box['title'] = $this->convertWinBR($_POST[$prename.'-anno_box-title']);
                $cell->anno_box['title_use'] = isset($_POST[$prename.'-anno_box-title_use']) ? true : false; 
                $cell->anno_box['title_size'] = $_POST[$prename.'-anno_box-title_size']; 
                
                $cell->anno_box['subtitle'] = $this->convertWinBR($_POST[$prename.'-anno_box-subtitle']);  
                $cell->anno_box['subtitle_use'] = isset($_POST[$prename.'-anno_box-subtitle_use']) ? true : false; 
                
                $cell->anno_box['text'] = $this->convertWinBR($_POST[$prename.'-anno_box-text']);       
                $cell->anno_box['text_fsize'] = $_POST[$prename.'-anno_box-text_fsize'];          
                $cell->anno_box['text_lheight'] = $_POST[$prename.'-anno_box-text_lheight']; 
                $cell->anno_box['text_use'] = isset($_POST[$prename.'-anno_box-text_use']) ? true : false;     
                $cell->anno_box['text_font_sizes_use'] = isset($_POST[$prename.'-anno_box-text_font_sizes_use']) ? true : false;  
                $cell->anno_box['align'] = $_POST[$prename.'-anno_box-align'];   
                
                $cell->anno_box['btn_color'] = $_POST[$prename.'-anno_box-btn_color']; 
                $cell->anno_box['btn_hcolor'] = $_POST[$prename.'-anno_box-btn_hcolor']; 
                $cell->anno_box['btn_bgcolor'] = $_POST[$prename.'-anno_box-btn_bgcolor']; 
                $cell->anno_box['btn_bghcolor'] = $_POST[$prename.'-anno_box-btn_bghcolor'];                  
                      
                $cell->anno_box['btn_a_display'] = isset($_POST[$prename.'-anno_box-btn_a_display']) ? true : false;
                $cell->anno_box['btn_a_name'] = $this->convertWinBR($_POST[$prename.'-anno_box-btn_a_name']);
                $cell->anno_box['btn_a_link'] = $_POST[$prename.'-anno_box-btn_a_link'];
                $cell->anno_box['btn_a_blank'] = isset($_POST[$prename.'-anno_box-btn_a_blank']) ? true : false;
                               
                $cell->anno_box['btn_b_display'] = isset($_POST[$prename.'-anno_box-btn_b_display']) ? true : false;
                $cell->anno_box['btn_b_name'] = $this->convertWinBR($_POST[$prename.'-anno_box-btn_b_name']);
                $cell->anno_box['btn_b_link'] = $_POST[$prename.'-anno_box-btn_b_link'];
                $cell->anno_box['btn_b_blank'] = isset($_POST[$prename.'-anno_box-btn_b_blank']) ? true : false;
               
                $cell->anno_box['btn_c_display'] = isset($_POST[$prename.'-anno_box-btn_c_display']) ? true : false;
                $cell->anno_box['btn_c_name'] = $this->convertWinBR($_POST[$prename.'-anno_box-btn_c_name']);
                $cell->anno_box['btn_c_link'] = $_POST[$prename.'-anno_box-btn_c_link'];
                $cell->anno_box['btn_c_blank'] = isset($_POST[$prename.'-anno_box-btn_c_blank']) ? true : false;                                
            } break;
            
            case 'ngg-recent-slider':
            {                               
                $cell->ngg_recent_slider['id'] = $_POST[$prename.'-ngg_recent_slider-id'];
                $cell->ngg_recent_slider['pages'] = $_POST[$prename.'-ngg_recent_slider-pages']; 
                $cell->ngg_recent_slider['orderby'] = $_POST[$prename.'-ngg_recent_slider-orderby']; 
                $cell->ngg_recent_slider['perpage'] = $_POST[$prename.'-ngg_recent_slider-perpage']; 
                $cell->ngg_recent_slider['viewport_w'] = $_POST[$prename.'-ngg_recent_slider-viewport_w']; 
                $cell->ngg_recent_slider['viewport_h'] = $_POST[$prename.'-ngg_recent_slider-viewport_h']; 
                
                $cell->ngg_recent_slider['alttext'] = isset($_POST[$prename.'-ngg_recent_slider-alttext']) ? true : false;                
                $cell->ngg_recent_slider['grayscale'] = isset($_POST[$prename.'-ngg_recent_slider-grayscale']) ? true : false; 
                $cell->ngg_recent_slider['desc'] = $this->convertWinBR($_POST[$prename.'-ngg_recent_slider-desc']); 
                $cell->ngg_recent_slider['desc_use'] = isset($_POST[$prename.'-ngg_recent_slider-desc_use']) ? true : false;
                
            } break;
            
            case 'recent-posts-list':
            {                             
               $cell->recent_posts_list['cats'] = $_POST[$prename.'-recent_posts_list-cats']; 
               $cell->recent_posts_list['list'] = $_POST[$prename.'-recent_posts_list-list'];
               $cell->recent_posts_list['count'] = $_POST[$prename.'-recent_posts_list-count'];
               $cell->recent_posts_list['words'] = $_POST[$prename.'-recent_posts_list-words'];
               $cell->recent_posts_list['order'] = $_POST[$prename.'-recent_posts_list-order'];
               $cell->recent_posts_list['orderby'] = $_POST[$prename.'-recent_posts_list-orderby'];
               $cell->recent_posts_list['grayscale'] = isset($_POST[$prename.'-recent_posts_list-grayscale']) ? true : false;     
               $cell->recent_posts_list['excerpt_use'] = isset($_POST[$prename.'-recent_posts_list-excerpt_use']) ? true : false;
               $cell->recent_posts_list['elapsed_time'] = isset($_POST[$prename.'-recent_posts_list-elapsed_time']) ? true : false;  
               $cell->recent_posts_list['layout'] = $_POST[$prename.'-recent_posts_list-layout'];
               $cell->recent_posts_list['columns'] = $_POST[$prename.'-recent_posts_list-columns'];  
               $cell->recent_posts_list['item_bottom'] = $_POST[$prename.'-recent_posts_list-item_bottom'];  
               $cell->recent_posts_list['item_bottom_use'] = isset($_POST[$prename.'-recent_posts_list-item_bottom_use']) ? true : false;
               $cell->recent_posts_list['viewport_w'] = $_POST[$prename.'-recent_posts_list-viewport_w'];
               $cell->recent_posts_list['viewport_h'] = $_POST[$prename.'-recent_posts_list-viewport_h'];
               $cell->recent_posts_list['viewport_use'] = isset($_POST[$prename.'-recent_posts_list-viewport_use']) ? true : false;
               $cell->recent_posts_list['title_display'] = isset($_POST[$prename.'-recent_posts_list-title_display']) ? true : false; 
               $cell->recent_posts_list['date_display'] = isset($_POST[$prename.'-recent_posts_list-date_display']) ? true : false;
               $cell->recent_posts_list['excerpt_display'] = isset($_POST[$prename.'-recent_posts_list-excerpt_display']) ? true : false;                                                 
               $cell->recent_posts_list['pagination'] = isset($_POST[$prename.'-recent_posts_list-pagination']) ? true : false;
            } break;
        
            case 'download':
            {                             
               $cell->download['title'] = $this->convertWinBR($_POST[$prename.'-download-title']); 
               $cell->download['title_size'] = $_POST[$prename.'-download-title_size'];
               $cell->download['subtitle'] = $this->convertWinBR($_POST[$prename.'-download-subtitle']); 
               $cell->download['desc'] = $this->convertWinBR($_POST[$prename.'-download-desc']);   
               $cell->download['file_name'] = $this->convertWinBR($_POST[$prename.'-download-file_name']); 
               $cell->download['file_size'] = $this->convertWinBR($_POST[$prename.'-download-file_size']);   
               $cell->download['file_url'] = $_POST[$prename.'-download-file_url'];
               $cell->download['icon_url'] = $_POST[$prename.'-download-icon_url']; 
               $cell->download['icon_w'] = $_POST[$prename.'-download-icon_w'];  
               $cell->download['btn_pos'] = $_POST[$prename.'-download-btn_pos'];  
               
               $cell->download['title_use'] = isset($_POST[$prename.'-download-title_use']) ? true : false;
               $cell->download['desc_use'] = isset($_POST[$prename.'-download-desc_use']) ? true : false;                                             
               $cell->download['file_name_use'] = isset($_POST[$prename.'-download-file_name_use']) ? true : false;
               $cell->download['file_size_use'] = isset($_POST[$prename.'-download-file_size_use']) ? true : false;
               $cell->download['icon_use'] = isset($_POST[$prename.'-download-icon_use']) ? true : false;   
               $cell->download['arrow_display'] = isset($_POST[$prename.'-download-arrow_display']) ? true : false;  
               
            } break;        
        
            case 'member':  
            {                                       
                $cell->member['per_page'] = $_POST[$prename.'-member-per_page'];             
                $cell->member['cats'] = $_POST[$prename.'-member-cats'];
                $cell->member['words'] = $_POST[$prename.'-member-words'];
                $cell->member['columns'] = $_POST[$prename.'-member-columns'];
                $cell->member['excerpt'] = isset($_POST[$prename.'-member-excerpt']) ? true : false;
                $cell->member['pagination'] = isset($_POST[$prename.'-member-pagination']) ? true : false;
                $cell->member['list'] = $_POST[$prename.'-member-list'];
                $cell->member['order'] = $_POST[$prename.'-member-order'];
                $cell->member['orderby'] = $_POST[$prename.'-member-orderby'];
                $cell->member['viewport_use'] = isset($_POST[$prename.'-member-viewport_use']) ? true : false; 
                $cell->member['viewport_w'] = $_POST[$prename.'-member-viewport_w']; 
                $cell->member['viewport_h'] = $_POST[$prename.'-member-viewport_h'];  
                
                $cell->member['title_display'] = isset($_POST[$prename.'-member-title_display']) ? true : false;   
                $cell->member['item_bottom_use'] = isset($_POST[$prename.'-member-item_bottom_use']) ? true : false; 
                $cell->member['item_bottom'] = $_POST[$prename.'-member-item_bottom'];  
                                                                         
                $cell->member['link_to_single'] = isset($_POST[$prename.'-member-link_to_single']) ? true : false;
                $cell->member['grayscale'] = isset($_POST[$prename.'-member-grayscale']) ? true : false;
                $cell->member['meta_title'] = isset($_POST[$prename.'-member-meta_title']) ? true : false;
                $cell->member['meta_subtitle'] = isset($_POST[$prename.'-member-meta_subtitle']) ? true : false;
                $cell->member['meta_addinfo'] = isset($_POST[$prename.'-member-meta_addinfo']) ? true : false;  
                $cell->member['addinfo_words'] = $_POST[$prename.'-member-addinfo_words'];                    
                $cell->member['meta_twitter'] = isset($_POST[$prename.'-member-meta_twitter']) ? true : false;
                $cell->member['meta_facebook'] = isset($_POST[$prename.'-member-meta_facebook']) ? true : false;
                $cell->member['meta_website'] = isset($_POST[$prename.'-member-meta_website']) ? true : false;                               
                                                                       
            } break;          
        
            case 'wgt-member':  
            {      
                $cell->wgt_member['per_page'] = $_POST[$prename.'-wgt_member-per_page']; 
                $cell->wgt_member['cats'] = $_POST[$prename.'-wgt_member-cats'];
                $cell->wgt_member['words'] = $_POST[$prename.'-wgt_member-words'];
                $cell->wgt_member['list'] = $_POST[$prename.'-wgt_member-list'];
                $cell->wgt_member['columns'] = $_POST[$prename.'-wgt_member-columns'];  
                $cell->wgt_member['order'] = $_POST[$prename.'-wgt_member-order'];
                $cell->wgt_member['orderby'] = $_POST[$prename.'-wgt_member-orderby'];
                $cell->wgt_member['viewport_use'] = isset($_POST[$prename.'-wgt_member-viewport_use']) ? true : false;   
                $cell->wgt_member['viewport_w'] = $_POST[$prename.'-wgt_member-viewport_w'];
                $cell->wgt_member['viewport_h'] = $_POST[$prename.'-wgt_member-viewport_h'];
                $cell->wgt_member['link_to_single'] = isset($_POST[$prename.'-wgt_member-link_to_single']) ? true : false; 
                $cell->wgt_member['grayscale'] = isset($_POST[$prename.'-wgt_member-grayscale']) ? true : false; 
                $cell->wgt_member['image_width'] = $_POST[$prename.'-wgt_member-image_width'];  
                
                $cell->wgt_member['meta_title'] = isset($_POST[$prename.'-wgt_member-meta_title']) ? true : false;  
                $cell->wgt_member['meta_subtitle'] = isset($_POST[$prename.'-wgt_member-meta_subtitle']) ? true : false;  
                $cell->wgt_member['meta_addinfo'] = isset($_POST[$prename.'-wgt_member-meta_addinfo']) ? true : false;
                $cell->wgt_member['addinfo_words'] = $_POST[$prename.'-wgt_member-addinfo_words'];       
                                        
                $cell->wgt_member['item_bottom'] = $_POST[$prename.'-wgt_member-item_bottom'];
                $cell->wgt_member['item_bottom_use'] = isset($_POST[$prename.'-wgt_member-item_bottom_use']) ? true : false;  

            } break;       
            
            case 'wgt-twitter':
            {
                $cell->wgt_twitter['twitter_screen_name'] = $this->convertWinBR($_POST[$prename.'-wgt_twitter-twitter_screen_name']);
                $cell->wgt_twitter['tweetes_count'] = $_POST[$prename.'-wgt_twitter-tweetes_count'];     
                $cell->wgt_twitter['tweetes_refresh'] = $_POST[$prename.'-wgt_twitter-tweetes_refresh'];     
                $cell->wgt_twitter['image_display'] = isset($_POST[$prename.'-wgt_twitter-image_display']) ? true : false;   
                $cell->wgt_twitter['time_offset'] = $_POST[$prename.'-wgt_twitter-time_offset'];    
                $cell->wgt_twitter['time_format'] = $this->convertWinBR($_POST[$prename.'-wgt_twitter-time_format']);  
                $cell->wgt_twitter['tweets_count_display'] = isset($_POST[$prename.'-wgt_twitter-tweets_count_display']) ? true : false;  
                $cell->wgt_twitter['date_display'] = isset($_POST[$prename.'-wgt_twitter-date_display']) ? true : false;  
                $cell->wgt_twitter['reset'] = isset($_POST[$prename.'-wgt_twitter-reset']) ? true : false; 
                $cell->wgt_twitter['layout'] = $_POST[$prename.'-wgt_twitter-layout'];
                $cell->wgt_twitter['left_side_w'] = $_POST[$prename.'-wgt_twitter-left_side_w'];
                
                if($cell->wgt_twitter['reset'])
                {            
                    $consumer_key = GetDCCPI()->getIGeneral()->getOption('twitter_consumer_key');   
                    $consumer_secret = GetDCCPI()->getIGeneral()->getOption('twitter_consumer_secret');
                    $token_key = GetDCCPI()->getIGeneral()->getOption('twitter_token_key');
                    $token_secret = GetDCCPI()->getIGeneral()->getOption('twitter_token_secret');
                    
                    $twitter_args = array(
                        'consumer_key' => $consumer_key,
                        'consumer_secret' => $consumer_secret,
                        'token_key' => $token_key,
                        'token_secret' => $token_secret            
                    );           
                                   
                    $option_id = $cell->core['time'].'_dc_seg_TWITTER'; 
                    $time_now = time();
                    $data = array('time' => $time_now, 'user' => false, 'timeline' => false); 
                    
                    $twitter = new DCC_Twitter($twitter_args);
                    $user = $twitter->getUserData(array('screen_name' => $cell->wgt_twitter['twitter_screen_name']));
                    $timeline = $twitter->getUserTimelineData(array('screen_name' => $cell->wgt_twitter['twitter_screen_name'], 'count' => 20));
                
                    $data['time'] = $time_now;
                    $data['user'] = $user; 
                    $data['timeline'] = $timeline; 
                    
                    update_option($option_id, $data);
                    $cell->wgt_twitter['reset'] = false;              
                }                                    
            } break;              
        
            case 'colored-head':
            {          
                $cell->colored_head['prefix'] = $this->convertWinBR($_POST[$prename.'-colored_head-prefix']);  
                $cell->colored_head['prefix_w'] = $_POST[$prename.'-colored_head-prefix_w'];  
                $cell->colored_head['prefix_align'] = $_POST[$prename.'-colored_head-prefix_align']; 
                $cell->colored_head['prefix_bgcolor'] = $_POST[$prename.'-colored_head-prefix_bgcolor'];
                $cell->colored_head['prefix_percent'] = isset($_POST[$prename.'-colored_head-prefix_percent']) ? true : false; 
                $cell->colored_head['text'] = $this->convertWinBR($_POST[$prename.'-colored_head-text']); 
                $cell->colored_head['color'] = $_POST[$prename.'-colored_head-color'];
                $cell->colored_head['bgcolor'] = $_POST[$prename.'-colored_head-bgcolor'];                  
            } break;
                    
        
        } // switch   
        
        
        
        return $cell;     
    }    
    
    public function deleteTwitterSegDBData($args=array())
    {
        $def = array(
            'time' => null
        );
        $args = $this->combineArgs($def, $args);
        
        if($args['time'] != null)
        {
            global $wpdb;
            $option_id = $args['time'].'_dc_seg_TWITTER';
            $wpdb->query("DELETE FROM $wpdb->options WHERE option_name = '$option_id' "); 
        }
    }

    
    public function renderCellCMS($cell, $echo=false)
    {
        $out = '';
        
        if($cell->core['id'] != CMS_NOT_SELECTED and $cell->core['type'] != CMS_NOT_SELECTED)
        {
            $add_class = '';
            if(!$cell->common['display']) { $add_class .= ' segment-in-no-display'; }
            if($cell->common['float'] == 'right') { $add_class .= ' segment-in-float-right'; }
            
            $style = '';
            $style .= 'clear:'.$cell->common['clear'].';';
            $style .= 'float:'.$cell->common['float'].';';  
            $style = ' style="'.$style.'" ';
            
            $out .= '<li class="segment-'.$cell->core['size-up'].'-'.$cell->core['size-down'].' segment-cell" '.$style.'>';
                $out .= '<div class="segment-content '.$add_class.'">';
                    $out .= '<input type="hidden" name="segment-cell-id-'.$cell->core['id'].'" value="'.$cell->core['id'].'" />';                
                    $out .= '<span class="dc-cms-hidden" name="segment-cell-type">'.$cell->core['type'].'</span>';  
                    $out .= '<span class="dc-cms-hidden" name="segment-cell-time">'.$cell->core['time'].'</span>'; 
                
                    $out .= '<div class="left-panel">';
                        $out .= '<div class="edit-btn" title="'.__('Edit', CMS_TXT_DOMAIN).'"></div>';
                        $out .= '<div class="delete-btn" title="'.__('Delete segment?', CMS_TXT_DOMAIN).'"></div>';
                        $out .= '<div class="clone-btn" title="'.__('Clone segment?', CMS_TXT_DOMAIN).'"></div>'; 
                        $out .= '<div class="note-btn" title="'.__('Edit note', CMS_TXT_DOMAIN).'"></div>'; 
                    $out .= '</div>';
                    
                    $note_popup = '';
                    
                    if($cell->core['note'] != '')
                    {                        
                        $note_popup .= '<div class="help-book-popup"><div>'.$cell->core['note'].'</div></div>';
                    }                    
                    
                    if($cell->core['type'] == 'board-slider') 
                    { $note_popup .= '<div class="help-note-popup"><div>Can be displayed only in 1-1 size and only on pages with full width layout.</div></div>'; }
                    if($cell->core['type'] == 'ngg-recent-slider') 
                    { $note_popup .= '<div class="help-note-popup"><div>Can be displayed only in 1-1 size. Supported by all page layouts.</div></div>'; }                    
                    
                    $out .= '<div class="center-panel">';
                        if($cell->core['note'] == '')
                        {
                            $out .= '<div class="name name-alone">'.$cell->core['name'].$note_popup.'</div>';
                            $out .= '<div class="note"></div>';
                        } else
                        {
                            $out .= '<div class="name">'.$cell->core['name'].$note_popup.'</div>';
                            $out .= '<div class="note" style="display:block;">'.dcf_neatTrim($cell->core['note'], 20, '..').'</div>';                            
                        }                                                
                    $out .= '</div>';
                    
                    $out .= '<div class="right-panel">';
                        $out .= '<div class="top-opt-buttons">';
                            $out .= '<div class="pin-btn" title="Pin segment"></div>';
  
                            if(!$cell->common['display'])
                            { 
                                $out .= '<div class="display-btn display-btn-off" title="Segment OFF"></div>';     
                            } else 
                            { 
                                $out .= '<div class="display-btn" title="Segment ON"></div>';   
                            } 
  
                        $out .= '</div>';
                    
                        $out .= '<div class="bottom-opt-icons">';
                            $out .= '<div class="float-btn float-btn-'.$cell->common['float'].'" title="Float '.$cell->common['float'].'"></div>';
                            $out .= '<div class="clear-btn clear-btn-'.$cell->common['clear'].'" title="Clear '.$cell->common['clear'].'"></div>';       
                        $out .= '</div>';

                        $out .= '<div class="segment-size-info">';
                            $out .= '<span class="up">'.$cell->core['size-up'].'</span>/<span class="down">'.$cell->core['size-down'].'</span>';
                            $out .= '<div class="seg-order">'.($cell->core['id']+1).'</div>';
                        $out .= '</div>';
                        
                        switch($cell->core['type'])
                        {
                            case 'board-slider': 
                            case 'ngg-recent-slider':
                            {
                                $out .= '<div class="plus-btn deactivated"></div>';                            
                                $out .= '<div class="minus-btn deactivated"></div>';
                                $out .= '<div class="max-btn deactivated"></div>';
                                $out .= '<div class="min-btn deactivated"></div>';                                 
                            } break;
                            
                            default:
                            {
                                $out .= '<div class="plus-btn" title="'.__('Larger size', CMS_TXT_DOMAIN).'"></div>';                            
                                $out .= '<div class="minus-btn" title="'.__('Reduce size', CMS_TXT_DOMAIN).'"></div>';
                                $out .= '<div class="max-btn" title="'.__('Max size', CMS_TXT_DOMAIN).'"></div>';
                                $out .= '<div class="min-btn" title="'.__('Min size', CMS_TXT_DOMAIN).'"></div>';                                 
                            } break;
                        }
                        
                    $out .= '</div>';                                                            
                    
                $out .= '</div>';                                                                               
            $out .= '</li>';     
        }
        
        if($echo) { echo $out; } else { return $out; }     
    }
    
    public function renderCellOptionsCMS($cell, $echo=false)
    {
        $prename = 'segment-cell-data-'.$cell->core['id']; 
               
        $std = '';
        $std .= '<input type="hidden" name="'.$prename.'-core-id" value="'.$cell->core['id'].'" />';
        $std .= '<input type="hidden" name="'.$prename.'-core-type" value="'.$cell->core['type'].'" />'; 
        $std .= '<input type="hidden" name="'.$prename.'-core-name" value="'.$cell->core['name'].'" />';  
        $std .= '<input type="hidden" name="'.$prename.'-core-size-up" value="'.$cell->core['size-up'].'" />';
        $std .= '<input type="hidden" name="'.$prename.'-core-size-down" value="'.$cell->core['size-down'].'" />';      
        $std .= '<input type="hidden" name="'.$prename.'-core-time" value="'.$cell->core['time'].'" />'; 
                  
        $cmn = '';
        $cmn .= '<div class="common-settings dc-cms-no-user-select">';                
            $cmn .= '<div class="open-close-btn">Segment settings</div>';            
            $cmn .= '<div class="controls-wrapper">';  
                            
                $cmn .= $this->getStdColumnStart(array('width'=>140, 'mbottom' => 5, 'mtop' => 5));
                    $cmn .= '<span class="dc-cms-control-top-label-nomargin">Padding top</span>'; 
                    $cmn .= $this->getCtrlInputIntArgs(
                        array('name' => $prename.'-common-pt', 'value' => (int)$cell->common['pt'], 'min' => 0, 'disabled' => $cell->common['pt-dis']));
                    $cmn .= $this->getStdInputsFieldStart(array('mtop-type' => 'small')); 
                        $cmn .= '<input type="checkbox" '.$this->attrDisabled($cell->common['pt-dis']).' name="'.$prename.'-common-pt-use" '.$this->attrChecked($cell->common['pt-use']).' /> Use';
                    $cmn .= $this->getStdInputsFieldEnd();
                
                    if($cell->common['pt-dis']) { $cmn .= '<input type="hidden" name="'.$prename.'-common-pt-dis" checked="checked" />'; }
                $cmn .= $this->getStdColumnEnd();

                $cmn .= $this->getStdColumnStart(array('width'=>140, 'mbottom' => 5, 'mtop' => 5));
                    $cmn .= '<span class="dc-cms-control-top-label-nomargin">Padding right</span>';
                    $cmn .= $this->getCtrlInputIntArgs(
                        array('name' => $prename.'-common-pr', 'value' => (int)$cell->common['pr'], 'min' => 0, 'disabled' => $cell->common['pr-dis']));
                    $cmn .= $this->getStdInputsFieldStart(array('mtop-type' => 'small'));
                        $cmn .= '<input type="checkbox" '.$this->attrDisabled($cell->common['pr-dis']).' name="'.$prename.'-common-pr-use" '.$this->attrChecked($cell->common['pr-use']).' /> Use';
                    $cmn .= $this->getStdInputsFieldEnd();
                    
                    if($cell->common['pr-dis']) { $cmn .= '<input type="hidden" name="'.$prename.'-common-pr-dis" checked="checked" />'; } 
                $cmn .= $this->getStdColumnEnd();
                
                $cmn .= $this->getStdColumnStart(array('width'=>140, 'mbottom' => 5, 'mtop' => 5));
                    $cmn .= '<span class="dc-cms-control-top-label-nomargin">Padding bottom</span>';
                    $cmn .= $this->getCtrlInputIntArgs(
                        array('name' => $prename.'-common-pb', 'value' => (int)$cell->common['pb'], 'min' => 0, 'disabled' => $cell->common['pb-dis']));
                    $cmn .= $this->getStdInputsFieldStart(array('mtop-type' => 'small'));
                        $cmn .= '<input type="checkbox" '.$this->attrDisabled($cell->common['pb-dis']).' name="'.$prename.'-common-pb-use" '.$this->attrChecked($cell->common['pb-use']).' /> Use';
                    $cmn .= $this->getStdInputsFieldEnd(); 
                    
                    if($cell->common['pb-dis']) { $cmn .= '<input type="hidden" name="'.$prename.'-common-pb-dis" checked="checked" />'; }
                $cmn .= $this->getStdColumnEnd();
                
                $cmn .= $this->getStdColumnStart(array('width'=>140, 'mbottom' => 5, 'mtop' => 5));
                    $cmn .= '<span class="dc-cms-control-top-label-nomargin">Padding left</span>'; 
                    $cmn .= $this->getCtrlInputIntArgs(
                        array('name' => $prename.'-common-pl', 'value' => (int)$cell->common['pl'], 'min' => 0, 'disabled' => $cell->common['pl-dis']));
                    $cmn .= $this->getStdInputsFieldStart(array('mtop-type' => 'small'));
                        $cmn .= '<input type="checkbox" '.$this->attrDisabled($cell->common['pl-dis']).' name="'.$prename.'-common-pl-use" '.$this->attrChecked($cell->common['pl-use']).' /> Use';
                    $cmn .= $this->getStdInputsFieldEnd(); 
                    
                    if($cell->common['pl-dis']) { $cmn .= '<input type="hidden" name="'.$prename.'-common-pl-dis" checked="checked" />'; }
                $cmn .= $this->getStdColumnEnd();
                
                $cmn .= $this->getStdColumnStart(array('width'=>140, 'mbottom' => 5, 'mtop' => 5));  
                    $cmn .= '<span class="dc-cms-control-top-label-nomargin">Clear settings</span>'; 
                    $cmn .= '<select class="clear-select-btn-opt dc-cms-control-100" name="'.$prename.'-common-clear">';
                        $cmn .= '<option value="none" '.$this->attrSelected($cell->common['clear'] == 'none').'>None</option>';
                        $cmn .= '<option value="left" '.$this->attrSelected($cell->common['clear'] == 'left').'>Left</option>';
                        $cmn .= '<option value="both" '.$this->attrSelected($cell->common['clear'] == 'both').'>Both</option>';
                        $cmn .= '<option value="right" '.$this->attrSelected($cell->common['clear'] == 'right').'>Right</option>';
                    $cmn .= '</select>';             
                $cmn .= $this->getStdColumnEnd();

                $cmn .= $this->getStdColumnStart(array('width'=>140, 'mbottom' => 5, 'mtop' => 5));  
                    $cmn .= '<span class="dc-cms-control-top-label-nomargin">Float settings</span>'; 
                    $cmn .= '<select class="float-select-btn-opt dc-cms-control-100" name="'.$prename.'-common-float">';
                        $cmn .= '<option value="left" '.$this->attrSelected($cell->common['float'] == 'left').'>Left</option>';
                        $cmn .= '<option value="right" '.$this->attrSelected($cell->common['float'] == 'right').'>Right</option>';
                    $cmn .= '</select>';             
                $cmn .= $this->getStdColumnEnd();
                
                
                $cmn .= $this->getStdColumnStart(array('width'=>140, 'mbottom' => 5, 'mtop' => 5));
                    $cmn .= '<span class="dc-cms-control-top-label-nomargin">Other settings</span>';
                    $cmn .= $this->getStdInputsFieldStart(array('mtop-type' => 'none'));  
                        $cmn .= '<input type="checkbox" class="display-checkbox-btn" '.$this->attrChecked($cell->common['display']).' name="'.$prename.'-common-display"> Display'; 
                    $cmn .= $this->getStdInputsFieldEnd(); 
                $cmn .= $this->getStdColumnEnd();
                                        
                $cmn .= $this->getClearBoth();

                $cmn .= '<div class="multi-tabs-wrapper">';
                    $cmn .= '<div class="multi-tab">Segment header</div>';                      
                    $cmn .= '<div class="dc-cms-clear"></div>';
                    
                    $cmn .= '<div class="multi-tab-content">';
                    
                        $cmn .= '<span class="dc-cms-control-top-label-nomargin">Header title</span>';
                        $cmn .= '<textarea name="'.$prename.'-common-header_title" class="dc-cms-control-wide dc-cms-control-textarea dc-cms-control-h-40">'.$cell->common['header_title'].'</textarea>';

                        $cmn .= '<span class="dc-cms-control-top-label">Header subtitle</span>';
                        $cmn .= '<textarea name="'.$prename.'-common-header_subtitle" class="dc-cms-control-wide dc-cms-control-textarea dc-cms-control-h-40">'.$cell->common['header_subtitle'].'</textarea>';                        
                        
                        $cmn .= '<span class="dc-cms-control-top-label">Title align</span>'; 
                        $cmn .= '<select name="'.$prename.'-common-header_align" class="dc-cms-control-100">';
                            $cmn .= '<option value="left" '.$this->attrSelected($cell->common['header_align'] == 'left').'>Left</option>';
                            $cmn .= '<option value="center" '.$this->attrSelected($cell->common['header_align'] == 'center').'>Center</option>'; 
                            $cmn .= '<option value="right" '.$this->attrSelected($cell->common['header_align'] == 'right').'>Right</option>';  
                        $cmn .= '</select>';
                        
                        $cmn .= '<span class="dc-cms-control-top-label">Bottom line style</span>'; 
                        $cmn .= '<select name="'.$prename.'-common-header_bstyle" class="dc-cms-control-100">';
                            $cmn .= '<option value="solid" '.$this->attrSelected($cell->common['header_bstyle'] == 'solid').'>Solid</option>';
                            $cmn .= '<option value="dotted" '.$this->attrSelected($cell->common['header_bstyle'] == 'dotted').'>Dotted</option>'; 
                            $cmn .= '<option value="dashed" '.$this->attrSelected($cell->common['header_bstyle'] == 'dashed').'>Dashed</option>';  
                        $cmn .= '</select>';
                        
                        $cmn .= '<span class="dc-cms-control-top-label">Bottom line color</span>'; 
                        $cmn .= '<input type="text" class="dc-color-picker" value="'.$cell->common['header_bcolor'].'" name="'.$prename.'-common-header_bcolor" /> ';  
                        
                        $cmn .= '<span class="dc-cms-control-top-label">Standard header size</span>';
                        $cmn .= '<select name="'.$prename.'-common-header_h_size" class="dc-cms-control-100">';
                            $cmn .= '<option value="1" '.$this->attrSelected($cell->common['header_h_size'] == 1).'>H1</option>';
                            $cmn .= '<option value="2" '.$this->attrSelected($cell->common['header_h_size'] == 2).'>H2</option>'; 
                            $cmn .= '<option value="3" '.$this->attrSelected($cell->common['header_h_size'] == 3).'>H3</option>';  
                            $cmn .= '<option value="4" '.$this->attrSelected($cell->common['header_h_size'] == 4).'>H4</option>';
                            $cmn .= '<option value="5" '.$this->attrSelected($cell->common['header_h_size'] == 5).'>H5</option>'; 
                            $cmn .= '<option value="6" '.$this->attrSelected($cell->common['header_h_size'] == 6).'>H6</option>';  
                        $cmn .= '</select>';

                        $cmn .= '<span class="dc-cms-control-top-label">Header bottom margin</span>'; 
                        $cmn .= $this->getCtrlInputInt($prename.'-common-header_bottom', $cell->common['header_bottom'], 0);
                        
                        $cmn .= '<span class="dc-cms-control-top-label">Standard HTML header bottom padding</span>'; 
                        $cmn .= $this->getCtrlInputInt($prename.'-common-header_h_pb', $cell->common['header_h_pb'], 0);                         
                        
                        $cmn .= '<span class="dc-cms-control-top-label">Other settings</span>';
                        $cmn .= $this->getStdInputsFieldStart(array('mtop-type' => 'none')); 
                            $cmn .= '<input type="checkbox" '.$this->attrChecked($cell->common['header_display']).' name="'.$prename.'-common-header_display"> Display header'; 
                            $cmn .= $this->getBR();
                            $cmn .= '<input type="checkbox" '.$this->attrChecked($cell->common['header_sub_display']).' name="'.$prename.'-common-header_sub_display"> Display header subtitle';
                            $cmn .= $this->getBookHelp(array('text' => 'Will be visible if header is displayed and only if header is rendered as HTML head')); 
                            $cmn .= $this->getBR();
                            $cmn .= '<input type="checkbox" '.$this->attrChecked($cell->common['header_inside']).' name="'.$prename.'-common-header_inside"> Display header inside wrapper'; 
                            $cmn .= $this->getBR();
                            $cmn .= '<input type="checkbox" '.$this->attrChecked($cell->common['header_border']).' name="'.$prename.'-common-header_border"> Display bottom line'; 
                            $cmn .= $this->getBR(); 
                            $cmn .= '<input type="checkbox" '.$this->attrChecked($cell->common['header_as_h']).' name="'.$prename.'-common-header_as_h"> Display as standard HTML header'; 
                        $cmn .= $this->getStdInputsFieldEnd();                    
                    
                        $cmn .= $this->getMetaBottomSavePanel();
                    $cmn .= '</div>';

                    
                $cmn .= '</div>';
                
                   

            $cmn .= '</div>';
        $cmn .= '</div>';
        
        $empty_space = $this->getEmptySpaceField(15);  
        
                
        
        $out = ''; 
        switch($cell->core['type'])
        {
            case 'blog':
            {
                $out .= '<div class="segment-options">';  
                                                                                            
                    $out .= $std;                                             
                    $out .= $cmn;
                    $out .= $empty_space;
                    $out .= '<div class="inner-opt-wrapper">'; 
                       
                        $categories = get_terms('category', array('orderby' => 'name', 'hide_empty' => false)); 
                        
                        if(!is_array($cell->blog['cat'])) { $cell->blog['cat'] = array(); }
                        $out .= '<span class="dc-cms-control-top-label-nomargin">Categories to display</span>';                      
                        $out .= $this->getStdScrollBoxStart(array('height' => 100, 'width' => 300));
                            foreach($categories as $cat)
                            {
                                $checked = false;
                                if(in_array($cat->term_id, $cell->blog['cat'])) { $checked = true; }
                                $out .= '<input type="checkbox" value="'.$cat->term_id.'" name="'.$prename.'-blog-cat[]" '.($checked ? ' checked="checked" ' : '').'> '.$cat->name. '<br />';
                            }
                        $out .= $this->getStdScrollBoxEnd();
                        
                        $out .= '<div class="dc-cms-help-note-box">';
                            $out .= 'If no category is selected page is trying to display posts from all categories.';
                        $out .= '</div>';                      
                      
                        if(!is_array($cell->blog['cat-excluded'])) { $cell->blog['cat-excluded'] = array(); }
                        $out .= '<span class="dc-cms-control-top-label">Excluded categories</span>';                      
                        $out .= $this->getStdScrollBoxStart(array('height' => 100, 'width' => 300));
                            foreach($categories as $cat)
                            {
                                $checked = false;
                                if(in_array($cat->term_id, $cell->blog['cat-excluded'])) { $checked = true; }
                                $out .= '<input type="checkbox" value="'.$cat->term_id.'" name="'.$prename.'-blog-cat-excluded[]" '.($checked ? ' checked="checked" ' : '').'> '.$cat->name. '<br />';
                            }
                        $out .= $this->getStdScrollBoxEnd();                    
                        
                        $out .= '<span class="dc-cms-control-top-label">Posts layout</span>';
                        $out .= '<select name="'.$prename.'-blog-layout" class="dc-cms-control-100">';
                            $val = $cell->blog['layout'];
                            $out .= '<option value="normal" '.$this->attrSelected($val == 'normal').'>Normal</option>';
                            $out .= '<option value="compact" '.$this->attrSelected($val == 'compact').'>Compact</option>';
                            $out .= '<option value="default" '.$this->attrSelected($val == 'default').'>Default</option>';
                        $out .= '</select>';   
                        
                        $out .= '<span class="dc-cms-control-top-label">Posts order</span>';
                        $out .= '<input type="radio" name="'.$prename.'-blog-order" value="DESC" '.$this->attrChecked($cell->blog['order'] == 'DESC').' /> Descending';
                        $out .= $this->getBR();
                        $out .= '<input type="radio" name="'.$prename.'-blog-order" value="ASC" '.$this->attrChecked($cell->blog['order'] == 'ASC').' /> Ascending';
                        $out .= $this->getBR();   
                
                        $out .= '<span class="dc-cms-control-top-label">Sort displayed posts by parameter</span>';  
                        $out .= '<input type="radio" name="'.$prename.'-blog-order-by" value="date" '.$this->attrChecked($cell->blog['order-by'] == 'date').' /> Order by date';
                        $out .= $this->getBR();
                        $out .= '<input type="radio" name="'.$prename.'-blog-order-by" value="modified" '.$this->attrChecked($cell->blog['order-by'] == 'modified').' /> Order by last modified date';
                        $out .= $this->getBR();
                        $out .= '<input type="radio" name="'.$prename.'-blog-order-by" value="title" '.$this->attrChecked($cell->blog['order-by'] == 'title').' /> Order by title';
                        $out .= $this->getBR();                
                        $out .= '<input type="radio" name="'.$prename.'-blog-order-by" value="rand" '.$this->attrChecked($cell->blog['order-by'] == 'rand').' /> Random order';
                        $out .= $this->getBR();  
                        $out .= '<input type="radio" name="'.$prename.'-blog-order-by" value="comment_count" '.$this->attrChecked($cell->blog['order-by'] == 'comment_count').' /> Order by number of comments';                        
                        
                        $out .= '<span class="dc-cms-control-top-label">Posts per page</span>'; 
                        $out .= $this->getCtrlInputInt($prename.'-blog-per-page', $cell->blog['per-page'], 1);
                        $out .= $this->getBR();
                        
                        $out .= '<span class="dc-cms-control-top-label">Other settings</span>';                      
                        $out .= '<input type="checkbox" name="'.$prename.'-blog-pagination" '.$this->attrChecked($cell->blog['pagination']).' /> Display pagination';
                        
                    $out .= '</div>'; /* inner-opt-wrapper */
                $out .= '</div>';
            } break;
       
            case 'post':
            {
                $out .= '<div class="segment-options">';  
                                                                                    
                    $out .= $std;                                             
                    $out .= $cmn;
                    $out .= $empty_space;
                    
                    $out .= '<div class="inner-opt-wrapper">';  
                    
                        $out .= '<span class="dc-cms-control-top-label-nomargin">Post ID</span>'; 
                        $out .= '<input type="text" class="dc-cms-control-100" value="'.$cell->post['id'].'" name="'.$prename.'-post-id" />';
                              
                        $out .= '<span class="dc-cms-control-top-label">Post layout</span>';
                        $out .= '<select name="'.$prename.'-post-layout" class="dc-cms-control-100">';
                            $val = $cell->post['layout'];
                            $out .= '<option value="normal" '.$this->attrSelected($val == 'normal').'>Normal</option>';
                            $out .= '<option value="compact" '.$this->attrSelected($val == 'compact').'>Compact</option>';
                            $out .= '<option value="default" '.$this->attrSelected($val == 'default').'>Default</option>';
                        $out .= '</select>';                                     
                              
                    $out .= '</div>'; /* inner-opt-wrapper */
                $out .= '</div>';
            } break;       
            
            case 'page-content':
            {
                $out .= '<div class="segment-options">';  
                                                                                    
                    $out .= $std;                                             
                    $out .= $cmn;
                    $out .= $empty_space;
                    
                        $out .= '<div class="inner-opt-wrapper">';

                            $out .= '<span class="dc-cms-control-top-label-nomargin">Select page (content from this page will be displayed, but if not selected, content from current page will be used)</span>';
                            $args = array(
                                'value' => $cell->page_content['page'],
                                'name' => 'segment-cell-data-'.$cell->core['id'].'-page_content-page',
                                'width' => '',
                                'class' => 'dc-cms-control-wide');
                            $out .= $this->selectCtrlPagesList($args);  
                            
                            $out .= '<span class="dc-cms-control-top-label">Other options</span>'; 
                            $out .= $this->getStdInputsFieldStart();
                                $out .= '<input type="checkbox" name="segment-cell-data-'.$cell->core['id'].'-page_content-page_use" '.$this->attrChecked($cell->page_content['page_use']).' /> Use content from selected page';
                                $out .= $this->getBR();
                                $out .= '<input type="checkbox" name="segment-cell-data-'.$cell->core['id'].'-page_content-pagination" '.$this->attrChecked($cell->page_content['pagination']).' /> Display pagination <div class="dc-cms-help-note-inline">(will work, only if pagination is created in page content)</div>'; 
                            $out .= $this->getStdInputsFieldEnd();     
                                  
                        $out .= '</div>'; /* inner-opt-wrapper */
                $out .= '</div>';
            } break;
            
            case 'page-title':
            {
                $out .= '<div class="segment-options">';            
                                                              
                    $out .= $std;
                    $out .= $cmn;
                    $out .= $empty_space;
                    $out .= '<div class="inner-opt-wrapper">';                                   
            
                        $out .= '<span class="dc-cms-control-top-label-nomargin">Optional alternative page title</span>'; 
                        $out .= '<textarea class="dc-cms-control-wide dc-cms-control-h-40 dc-cms-control-textarea" name="'.$prename.'-page_title-title">'.$cell->page_title['title'].'</textarea>';                       
                        
                        $out .= '<span class="dc-cms-control-top-label">Optional subtitle</span>'; 
                        $out .= '<textarea class="dc-cms-control-wide dc-cms-control-h-40 dc-cms-control-textarea" name="'.$prename.'-page_title-subtitle">'.$cell->page_title['subtitle'].'</textarea>';                        

                        $out .= '<span class="dc-cms-control-top-label">Optional text</span>'; 
                        $out .= '<textarea class="dc-cms-control-wide dc-cms-control-h-120 dc-cms-control-textarea" name="'.$prename.'-page_title-text">'.$cell->page_title['text'].'</textarea>';            
         
                        $out .= '<span class="dc-cms-control-top-label">Title color</span>'; 
                        $out .= '<input type="text" class="dc-color-picker" value="'.$cell->page_title['title_color'].'" name="'.$prename.'-page_title-title_color" /> ';         
  
                        $out .= '<span class="dc-cms-control-top-label">Title align</span>';         
                        $out .= '<select name="'.$prename.'-page_title-align_title" class="dc-cms-control-100">';
                            $val = $cell->page_title['align_title'];
                            $out .= '<option value="left"   '.$this->attrSelected($val == 'left').'>Left</option>';
                            $out .= '<option value="center" '.$this->attrSelected($val == 'center').'>Center</option>';
                            $out .= '<option value="right"  '.$this->attrSelected($val == 'right').'>Right</option>';
                        $out .= '</select>';

                        $out .= '<span class="dc-cms-control-top-label">Optional text align</span>';         
                        $out .= '<select name="'.$prename.'-page_title-align_text" class="dc-cms-control-100">';
                            $val = $cell->page_title['align_text'];
                            $out .= '<option value="left"   '.$this->attrSelected($val == 'left').'>Left</option>';
                            $out .= '<option value="center" '.$this->attrSelected($val == 'center').'>Center</option>';
                            $out .= '<option value="right"  '.$this->attrSelected($val == 'right').'>Right</option>';
                        $out .= '</select>';
            
                        $out .= '<span class="dc-cms-control-top-label">Other settings</span>';
                        $out .= $this->getStdInputsFieldStart();
                            $out .= '<input type="checkbox" name="'.$prename.'-page_title-title_use" '.$this->attrChecked($cell->page_title['title_use']).' /> Use title';    
                            $out .= $this->getBR();
                            $out .= '<input type="checkbox" name="'.$prename.'-page_title-subtitle_use" '.$this->attrChecked($cell->page_title['subtitle_use']).' /> Use subtitle';  
                            $out .= $this->getBR();
                            $out .= '<input type="checkbox" name="'.$prename.'-page_title-title_color_use" '.$this->attrChecked($cell->page_title['title_color_use']).' /> Use title color';
                            $out .= $this->getBR();
                            $out .= '<input type="checkbox" name="'.$prename.'-page_title-text_use" '.$this->attrChecked($cell->page_title['text_use']).' /> Display optional text';
                        $out .= $this->getStdInputsFieldEnd();        
                        
                        $out .= '<div class="dc-cms-help-note-box">';
                            $out .= 'If title or subtitle is not used the default page title and subtitle will be displayed.';                        
                        $out .= '</div>';             
            
                    $out .= '</div>'; /* inner-opt-wrapper */
                $out .= '</div>';
            } break; 
            
            case 'heading':
            {                                
                $out .= '<div class="segment-options">';            
                                                              
                    $out .= $std;
                    $out .= $cmn;
                    $out .= $empty_space;
                    $out .= '<div class="inner-opt-wrapper">';                        
                    
                        $out .= '<span class="dc-cms-control-top-label-nomargin">Title</span>';  
                        $out .= '<textarea name="'.$prename.'-heading-title" class="dc-cms-control-textarea dc-cms-control-wide dc-cms-control-h-40">'.$cell->heading['title'].'</textarea>';

                        $out .= '<span class="dc-cms-control-top-label">Subtitle</span>';  
                        $out .= '<textarea name="'.$prename.'-heading-subtitle" class="dc-cms-control-textarea dc-cms-control-wide dc-cms-control-h-40">'.$cell->heading['subtitle'].'</textarea>';

                        $out .= '<span class="dc-cms-control-top-label">Heading size</span>';
                        $out .= '<select class="dc-cms-control-100" name="'.$prename.'-heading-size">';
                            $out .= '<option value="1" '.$this->attrSelected($cell->heading['size'] == 1).'>H1</option>';
                            $out .= '<option value="2" '.$this->attrSelected($cell->heading['size'] == 2).'>H2</option>';
                            $out .= '<option value="3" '.$this->attrSelected($cell->heading['size'] == 3).'>H3</option>';
                            $out .= '<option value="4" '.$this->attrSelected($cell->heading['size'] == 4).'>H4</option>';
                            $out .= '<option value="5" '.$this->attrSelected($cell->heading['size'] == 5).'>H5</option>';
                            $out .= '<option value="6" '.$this->attrSelected($cell->heading['size'] == 6).'>H6</option>';
                        $out .= '</select>'; 
                        
                        $out .= '<span class="dc-cms-control-top-label">Subtitle padding top</span>'; 
                        $out .= $this->getCtrlInputInt($prename.'-heading-subtitle_pt', $cell->heading['subtitle_pt'], 1);   
                    
                        $out .= '<span class="dc-cms-control-top-label">Align</span>';  
                        $out .= '<select class="dc-cms-control-100" name="'.$prename.'-heading-align">';
                            $out .= '<option value="left" '.$this->attrSelected($cell->heading['align'] == 'left').'>Left</option>';   
                            $out .= '<option value="center" '.$this->attrSelected($cell->heading['align'] == 'center').'>Center</option>';
                            $out .= '<option value="right" '.$this->attrSelected($cell->heading['align'] == 'right').'>Right</option>'; 
                        $out .= '</select>';
                        
                        $out .= '<span class="dc-cms-control-top-label">Title color</span>'; 
                        $out .= '<input type="text" class="dc-color-picker" value="'.$cell->heading['title_color'].'" name="'.$prename.'-heading-title_color" /> ';                        

                        $out .= '<span class="dc-cms-control-top-label">Subtitle color</span>'; 
                        $out .= '<input type="text" class="dc-color-picker" value="'.$cell->heading['subtitle_color'].'" name="'.$prename.'-heading-subtitle_color" /> '; 
                        
                        $out .= $this->getClearBoth(1);   
                        
                        $out .= $this->getStdColumnStart(array('width' => 200));
                        
                            $out .= '<span class="dc-cms-control-top-label">Title font size (optional)</span>'; 
                            $out .= $this->getCtrlInputInt($prename.'-heading-title_fsize', $cell->heading['title_fsize'], 1);                           

                            $out .= '<span class="dc-cms-control-top-label">Title line height (optional)</span>'; 
                            $out .= $this->getCtrlInputInt($prename.'-heading-title_lheight', $cell->heading['title_lheight'], 1);   

                        $out .= $this->getStdColumnEnd();
                        
                        $out .= $this->getStdColumnStart(array('width' => 200));          
                        
                            $out .= '<span class="dc-cms-control-top-label">Subtitle font size (optional)</span>'; 
                            $out .= $this->getCtrlInputInt($prename.'-heading-subtitle_fsize', $cell->heading['subtitle_fsize'], 1);                           

                            $out .= '<span class="dc-cms-control-top-label">Subtitle line height (optional)</span>'; 
                            $out .= $this->getCtrlInputInt($prename.'-heading-subtitle_lheight', $cell->heading['subtitle_lheight'], 1);  
                        
                        $out .= $this->getStdColumnEnd(); 
                        
                        $out .= $this->getClearBoth(1);                             
                    
                        $out .= '<span class="dc-cms-control-top-label">Other settings</span>';
                        $out .= $this->getStdInputsFieldStart(); 
                            $out .= '<input type="checkbox" name="'.$prename.'-heading-title_use" '.$this->attrChecked($cell->heading['title_use']).' /> Display title';
                            $out .= $this->getBR();
                            $out .= '<input type="checkbox" name="'.$prename.'-heading-subtitle_use" '.$this->attrChecked($cell->heading['subtitle_use']).' /> Display subtitle';  
                            $out .= $this->getBR();
                            $out .= '<input type="checkbox" name="'.$prename.'-heading-title_color_use" '.$this->attrChecked($cell->heading['title_color_use']).' /> Use title color';
                            $out .= $this->getBR();
                            $out .= '<input type="checkbox" name="'.$prename.'-heading-subtitle_color_use" '.$this->attrChecked($cell->heading['subtitle_color_use']).' /> Use subtitle color';  
                            $out .= $this->getBR();
                            $out .= '<input type="checkbox" name="'.$prename.'-heading-title_font_sizes_use" '.$this->attrChecked($cell->heading['title_font_sizes_use']).' /> Use title font size and line height settings';  
                            $out .= $this->getBR();
                            $out .= '<input type="checkbox" name="'.$prename.'-heading-subtitle_font_sizes_use" '.$this->attrChecked($cell->heading['subtitle_font_sizes_use']).' /> Use subtitle font size and line height settings';                              
                        $out .= $this->getStdInputsFieldEnd();                     
                    
                    $out .= '</div>'; /* inner-opt-wrapper */
                $out .= '</div>';                                    
            } break;
            
            case 'sidebar':
            {
                $out .= '<div class="segment-options">';            
                                                              
                    $out .= $std;
                    $out .= $cmn;
                    $out .= $empty_space; 
                    $out .= '<div class="inner-opt-wrapper">'; 
                    
                        $out .= '<span class="dc-cms-control-top-label-nomargin">Select sidebar to display</span>';
                        $out .= GetDCCPI()->getIGeneral()->selectCtrlSidebarsList($cell->sidebar['sid'], $prename.'-sidebar-sid', 300);                                  

                    $out .= '</div>';
                $out .= '</div>';
            } break;  
            
            case 'gmap':
            {
                $out .= '<div class="segment-options">';            
                                                              
                    $out .= $std;
                    $out .= $cmn;
                    $out .= $empty_space; 
                    $out .= '<div class="inner-opt-wrapper">';                                   

                        $out .= '<span class="dc-cms-control-top-label-nomargin">Map settings</span>';
                        $out .= $this->getStdInputsFieldStart();                                              
                            $out .= '<input type="checkbox" name="'.$prename.'-gmap-marker-display" '.$this->attrChecked($cell->gmap['marker-display']).' /> Display marker'; 
                            $out .= $this->getBR();  
                            $out .= '<input type="checkbox" name="'.$prename.'-gmap-marker-popup" '.$this->attrChecked($cell->gmap['marker-popup']).' /> Information window for marker will be shown when the map finished loading. If text for marker is empty this option will be ignored.'; 
                            $out .= $this->getBR();   
                            $out .= '<input type="checkbox" name="'.$prename.'-gmap-wheel" '.$this->attrChecked($cell->gmap['wheel']).' /> Allow zooming with your mouses scrollwheel'; 
                            $out .= $this->getBR();   
                            $out .= '<input type="checkbox" name="'.$prename.'-gmap-controls" '.$this->attrChecked($cell->gmap['controls']).' /> Display controls';                         
                       $out .= $this->getStdInputsFieldEnd();    
                        
                            $out .= '<span class="dc-cms-control-top-label">Map type</span>';
                            $out .= '<select name="'.$prename.'-gmap-type" class="dc-cms-control-400">';
                                $out .= '<option value="ROADMAP" '.$this->attrSelected($cell->gmap['type'] == 'ROADMAP').'>Default road map view</option>';
                                $out .= '<option value="SATELLITE" '.$this->attrSelected($cell->gmap['type'] == 'SATELLITE').'>Google Earth satellite images</option>';
                                $out .= '<option value="HYBRID" '.$this->attrSelected($cell->gmap['type'] == 'HYBRID').'>Mixture of normal and satellite views</option>';
                                $out .= '<option value="TERRAIN" '.$this->attrSelected($cell->gmap['type'] == 'TERRAIN').'>Physical map based on terrain information</option>';
                            $out .= '</select>';  

                            $out .= '<span class="dc-cms-control-top-label">Map zoom</span>';  
                            $out .= '<select name="'.$prename.'-gmap-zoom" class="dc-cms-control-60">';
                                for($i = 1; $i < 20; $i++)
                                {
                                    $out .= '<option value="'.$i.'" '.$this->attrSelected($i == $cell->gmap['zoom']).'>'.$i.'</option>';
                                }    
                            $out .= '</select>';
                           
                            $out .= '<span class="dc-cms-control-top-label">Map height in pixels</span>'; 
                            $out .= $this->getCtrlInputInt($prename.'-gmap-height', $cell->gmap['height'], 100, 2000);
                             
                            $out .= '<span class="dc-cms-control-top-label">Marker latitude</span>';
                            $out .= '<input type="text" class="dc-cms-control-400" name="'.$prename.'-gmap-latitude" value="'.$cell->gmap['latitude'].'" />';  

                            $out .= '<span class="dc-cms-control-top-label">Marker longitude</span>';
                            $out .= '<input type="text" class="dc-cms-control-400" name="'.$prename.'-gmap-longitude" value="'.$cell->gmap['longitude'].'" />';                     
                      
                            $out .= '<span class="dc-cms-control-top-label">Marker head text</span>';                              
                            $out .= '<textarea name="'.$prename.'-gmap-marker-head" class="dc-cms-control-textarea dc-cms-control-400 dc-cms-control-h-60">';
                                $out .= $cell->gmap['marker-head'];
                            $out .= '</textarea>';   
                                                          
                            $out .= '<span class="dc-cms-control-top-label">Marker description text</span>';                              
                            $out .= '<textarea name="'.$prename.'-gmap-marker-text" class="dc-cms-control-textarea dc-cms-control-400 dc-cms-control-h-60">';
                                $out .= $cell->gmap['marker-text'];
                            $out .= '</textarea>';                                                                                                                                                                                                                         
                        
                            $out .= '<span class="dc-cms-control-top-label">Hue</span>'; 
                            $out .= '<input type="text" class="dc-color-picker" value="'.$cell->gmap['hue'].'" name="'.$prename.'-gmap-hue" /> ';                           
                        
                            $out .= '<span class="dc-cms-control-top-label">Saturation</span>';                                
                            $args = array(
                                'name' => $prename.'-gmap-saturation',
                                'value' => $cell->gmap['saturation'],
                                'min' => -100,
                                'max' => 100,
                                'disabled' => false,
                                'step' => 2);
                            $out .= $this->getCtrlInputIntArgs($args);   
                            $out .= '<div class="dc-cms-help-note-box-small">';
                                $out .= 'Value from <strong>-100</strong> to <strong>100</strong>, in default is set to <strong>0</strong>';
                            $out .= '</div>';                                                     

                            $out .= '<span class="dc-cms-control-top-label">Lightness</span>';                                
                            $args = array(
                                'name' => $prename.'-gmap-lightness',
                                'value' => $cell->gmap['lightness'],
                                'min' => -100,
                                'max' => 100,
                                'disabled' => false,
                                'step' => 2);
                            $out .= $this->getCtrlInputIntArgs($args);    
                            $out .= '<div class="dc-cms-help-note-box-small">';
                                $out .= 'Value from <strong>-100</strong> to <strong>100</strong>, in default is set to <strong>0</strong>';
                            $out .= '</div>';                                                     
                            
                            $out .= '<span class="dc-cms-control-top-label">Gamma</span>';                                
                            $args = array(
                                'name' => $prename.'-gmap-gamma',
                                'value' => $cell->gmap['gamma'],
                                'min' => 1,
                                'max' => 999,
                                'disabled' => false,
                                'step' => 8);
                            $out .= $this->getCtrlInputIntArgs($args);
                            $out .= '<div class="dc-cms-help-note-box-small">';
                                $out .= 'Value from <strong>1</strong> to <strong>999</strong>, in default is set to <strong>100</strong>';
                            $out .= '</div>';                                                                                    
                        
                            $out .= '<span class="dc-cms-control-top-label">Style settings</span>'; 
                            $out .= $this->getStdInputsFieldStart();                                              
                                $out .= '<input type="checkbox" name="'.$prename.'-gmap-hue_use" '.$this->attrChecked($cell->gmap['hue_use']).' /> Use hue'; 
                                $out .= $this->getBR();  
                                $out .= '<input type="checkbox" name="'.$prename.'-gmap-saturation_use" '.$this->attrChecked($cell->gmap['saturation_use']).' /> Use saturation'; 
                                $out .= $this->getBR();   
                                $out .= '<input type="checkbox" name="'.$prename.'-gmap-lightness_use" '.$this->attrChecked($cell->gmap['lightness_use']).' /> Use lightness'; 
                                $out .= $this->getBR();   
                                $out .= '<input type="checkbox" name="'.$prename.'-gmap-gamma_use" '.$this->attrChecked($cell->gmap['gamma_use']).' /> Use gamma';                          
                           $out .= $this->getStdInputsFieldEnd();                           
                        
                        $out .= '<div class="dc-cms-help-note-box">';
                            $out .= 'If you want display <span class="dc-cms-marked-span">Google Map</span> on some page or post keep in mind that you need to allow for <span class="dc-cms-marked-span">Google Map API</span> library loading. ';
                            $out .= 'You will find this option in page/post common settings.';
                        $out .= '</div>';                                                                                                       
                    
                    $out .= '</div>'; /* inner-opt-wrapper */
                $out .= '</div>';
            } break; 
            
            case 'cform':
            {
                $out .= '<div class="segment-options">';            
                                                              
                    $out .= $std;
                    $out .= $cmn;
                    $out .= $empty_space; 
                    $out .= '<div class="inner-opt-wrapper">';                   
              
                        $out .= '<span class="dc-cms-control-top-label-nomargin">Select displayed contact form</span>';
                        $cf_list = GetDCCPI()->getIGeneral()->getOption('cf_list');
                        if(is_array($cf_list) and count($cf_list))
                        {   
                            $out .= '<select name="segment-cell-data-'.$cell->core['id'].'-cform-id" class="dc-cms-control-400">';
                                $out .= '<option value="'.CMS_NOT_SELECTED.'">'.__('Not selected', CMS_TXT_DOMAIN).'</option>';
                                foreach($cf_list as $form)
                                {
                                    $out .= '<option value="'.$form->_id.'" '.$this->attrSelected($form->_id == $cell->cform['id']).'>'.$form->_name.'</option>';
                                }
                            $out .= '</select>';                        
                        } else
                        {
                            $text = 'Contact form list is empty. Please go to theme options and create some contact form.';
                            $args = array('text' => $text);
                            $out .= $this->getCMSException($args);
                        }
                        
                        $out .= '<span class="dc-cms-control-top-label">Insert comma separated e-mail addresses</span>'; 
                        $out .= '<input type="text" class="dc-cms-control-wide" name="segment-cell-data-'.$cell->core['id'].'-cform-address" value="'.$cell->cform['address'].'" />';                                
            
                    $out .= '</div>'; /* inner-opt-wrapper */
                $out .= '</div>';            
            } break;
            
            case 'text':
            {
                $out .= '<div class="segment-options">';            
                                                              
                    $out .= $std;
                    $out .= $cmn;
                    $out .= $empty_space; 
                    $out .= '<div class="inner-opt-wrapper">';                    
                
                                    
                        $out .= '<span class="dc-cms-control-top-label-nomargin">Content (shorcodes allowed)</span>';
                        $out .= $this->getTextAreaShortCodeWrapperStart();
                            $out .= '<textarea class="dc-cms-control-wide dc-cms-control-h-400 dc-cms-control-textarea" name="segment-cell-data-'.$cell->core['id'].'-text-content" >'.$cell->text['content'].'</textarea>';
                        $out .= $this->getTextAreaShortCodeWrapperEnd();
                    
                        $out .= '<span class="dc-cms-control-top-label">Formating</span>';
                        $out .= '<div class="dc-cms-excludable-checkbox-field-nomargin">'; 
                            $out .= '<input type="checkbox" name="segment-cell-data-'.$cell->core['id'].'-text-sc_filter" '.$this->attrChecked($cell->text['sc_filter']).' /> Apply only shortcode filter';
                            $out .= $this->getBR();
                            $out .= '<input type="checkbox" name="segment-cell-data-'.$cell->core['id'].'-text-wp_filter" '.$this->attrChecked($cell->text['wp_filter']).' /> Apply standard WordPress content filters';  
                        $out .= '</div>'; 
                    
                
                    $out .= '</div>'; /* inner-opt-wrapper */
                $out .= '</div>';                   
            } break; 
            
            case 'empty-space':
            {
                $out .= '<div class="segment-options">';            
                                                              
                    $out .= $std;
                    $out .= $cmn;
                    $out .= $empty_space; 
                    $out .= '<div class="inner-opt-wrapper">';  
                    
                        $out .= '<span class="dc-cms-control-top-label-nomargin">Empty space height in pixels</span>'; 
                        $out .= $this->getCtrlInputInt('segment-cell-data-'.$cell->core['id'].'-empty_space-h', $cell->empty_space['h'], 0);

                    $out .= '</div>'; /* inner-opt-wrapper */
                $out .= '</div>';                      
            } break;
            
            case 'top-anchor':
            {
                $out .= '<div class="segment-options">';            
                                                              
                    $out .= $std;
                    $out .= $cmn;
                    $out .= $empty_space; 
                    $out .= '<div class="inner-opt-wrapper">';                      
                    
                        $out .= '<span class="dc-cms-control-top-label-nomargin">Text</span>'; 
                        $out .= '<textarea class="dc-cms-control-wide dc-cms-control-textarea dc-cms-control-h-40" name="segment-cell-data-'.$cell->core['id'].'-top_anchor-text">'.$cell->top_anchor['text'].'</textarea>';     
                                  
                    $out .= '</div>'; /* inner-opt-wrapper */ 
                $out .= '</div>';
            } break; 
            
            case 'line-divider':
            {
                $out .= '<div class="segment-options">';            
                                                              
                    $out .= $std;
                    $out .= $cmn;
                    $out .= $empty_space; 
                    $out .= '<div class="inner-opt-wrapper">';                      
                    
                        $out .= '<span class="dc-cms-control-top-label-nomargin">Line width</span>'; 
                        $out .= $this->getCtrlInputInt('segment-cell-data-'.$cell->core['id'].'-line_divider-bsize', $cell->line_divider['bsize'], 1);    
                        
                        $out .= '<span class="dc-cms-control-top-label">Line color</span>'; 
                        $out .= '<input type="text" class="dc-color-picker" value="'.$cell->line_divider['bcolor'].'" name="segment-cell-data-'.$cell->core['id'].'-line_divider-bcolor" /> '; 
                        
                        $out .= '<span class="dc-cms-control-top-label">Line style</span>'; 
                        $out .= '<select class="dc-cms-control-100" name="segment-cell-data-'.$cell->core['id'].'-line_divider-bstyle">';
                            $out .= '<option value="solid" '.$this->attrSelected($cell->line_divider['bstyle'] == 'solid').'>Solid</option>';
                            $out .= '<option value="dotted" '.$this->attrSelected($cell->line_divider['bstyle'] == 'dotted').'>Dotted</option>';
                            $out .= '<option value="dashed" '.$this->attrSelected($cell->line_divider['bstyle'] == 'dashed').'>Dashed</option>';
                        $out .= '</select>';
                                  
                    $out .= '</div>'; /* inner-opt-wrapper */ 
                $out .= '</div>';                
            } break;     

            case 'img-divider':
            {
                $out .= '<div class="segment-options">';            
                                                              
                    $out .= $std;
                    $out .= $cmn;
                    $out .= $empty_space; 
                    $out .= '<div class="inner-opt-wrapper">';     

                        $out .= '<span class="dc-cms-control-top-label-nomargin">Divider height</span>'; 
                        $out .= $this->getCtrlInputInt('segment-cell-data-'.$cell->core['id'].'-img_divider-h', $cell->img_divider['h'], 0); 
                        
                        $out .= '<span class="dc-cms-control-top-label">Background image URL</span>';  
                        $out .= '<input type="text" class="dc-cms-control-wide" name="segment-cell-data-'.$cell->core['id'].'-img_divider-bgimage" value="'.$cell->img_divider['bgimage'].'" id="dc-id-segment-cell-data-'.$cell->core['id'].'-img_divider-bgimage" />';
                        
                        $out .= $this->getImagePreviewBox(array('path' => $cell->img_divider['bgimage'], 'width' => 240, 'height' => 120, 'margin' => '15px 0px 0px 0px'));
                        
                        $out .= '<div class="dc-cms-btn-frame">';
                            $out .= '<input class="dc-cms-submit-image-btn" type="button" name="dc-id-segment-cell-data-'.$cell->core['id'].'-img_divider-bgimage" value="Load image" />';
                        $out .= '</div>';                           
                        
                        $out .= '<span class="dc-cms-control-top-label">Pattern</span>';  
                        $out .= '<select class="dc-cms-control-200" name="segment-cell-data-'.$cell->core['id'].'-img_divider-pattern" >';
                            $catalog = new DCC_ServerCatalogContent(); 
                            $catalog->readCatalog(array('catalog' => 'img/divider'));
                            
                            $out .= '<option value="">'.__('Not selected', CMS_TXT_DOMAIN).'</option>'; 
                            if(is_array($catalog->_files_list))
                            {
                                foreach($catalog->_files_list as $file)
                                {
                                    if(!(strpos($file, ' ') !== false))
                                    {
                                        $out .= '<option value="'.$file.'" '.$this->attrSelected($file == $cell->img_divider['pattern']).'>'.$file.'</option>';    
                                    }
                                }    
                            }   
                        $out .= '</select>';   
                        
                        $out .= '<span class="dc-cms-control-top-label">Background repeat mode</span>';
                        $out .= '<select name="segment-cell-data-'.$cell->core['id'].'-img_divider-bgrepeat" class="dc-cms-control-100">';
                            $out .= '<option value="repeat" '.$this->attrSelected('repeat' == $cell->img_divider['bgrepeat']).'>Repeat</option>';
                            $out .= '<option value="no-repeat" '.$this->attrSelected('no-repeat' == $cell->img_divider['bgrepeat']).'>No repeat</option>';
                            $out .= '<option value="repeat-x" '.$this->attrSelected('repeat-x' == $cell->img_divider['bgrepeat']).'>Repeat X</option>';
                            $out .= '<option value="repeat-y" '.$this->attrSelected('repeat-y' == $cell->img_divider['bgrepeat']).'>Repeat Y</option>';
                        $out .= '</select>';          

                        $out .= '<span class="dc-cms-control-top-label">Background position</span>';
                        $out .= '<select name="segment-cell-data-'.$cell->core['id'].'-img_divider-bgpos" class="dc-cms-control-100">';
                            $out .= '<option value="left top" '.$this->attrSelected('left top' == $cell->img_divider['bgpos']).'>Left Top</option>';
                            $out .= '<option value="left center" '.$this->attrSelected('left center' == $cell->img_divider['bgpos']).'>Left Center</option>';
                            $out .= '<option value="left bottom" '.$this->attrSelected('left bottom' == $cell->img_divider['bgpos']).'>Left Bottom</option>';
                            $out .= '<option value="center top" '.$this->attrSelected('center top' == $cell->img_divider['bgpos']).'>Center Top</option>';
                            $out .= '<option value="center center" '.$this->attrSelected('center center' == $cell->img_divider['bgpos']).'>Center Center</option>';
                            $out .= '<option value="center bottom" '.$this->attrSelected('center bottom' == $cell->img_divider['bgpos']).'>Center Bottom</option>';
                            $out .= '<option value="right top" '.$this->attrSelected('right top' == $cell->img_divider['bgpos']).'>Right Top</option>';
                            $out .= '<option value="right center" '.$this->attrSelected('right center' == $cell->img_divider['bgpos']).'>Right Center</option>';
                            $out .= '<option value="right bottom" '.$this->attrSelected('right bottom' == $cell->img_divider['bgpos']).'>Right Bottom</option>';
                        $out .= '</select>';  
                        
                        $out .= '<span class="dc-cms-control-top-label">Background color</span>'; 
                        $out .= '<input type="text" class="dc-color-picker" value="'.$cell->img_divider['bgcolor'].'" name="segment-cell-data-'.$cell->core['id'].'-img_divider-bgcolor" /> ';                    
                    
                        $out .= '<span class="dc-cms-control-top-label">Other settings</span>'; 
                        $out .= $this->getStdInputsFieldStart();
                            $out .= '<input type="checkbox" name="segment-cell-data-'.$cell->core['id'].'-img_divider-bgcolor_use" '.$this->attrChecked($cell->img_divider['bgcolor_use']).' /> Use background color';
                        $out .= $this->getStdInputsFieldEnd();                                                                   
                    
                    $out .= '</div>'; /* inner-opt-wrapper */ 
                $out .= '</div>';              
            } break;
            
            case 'note':
            {
                $out .= '<div class="segment-options">';            
                                                              
                    $out .= $std;
                    $out .= $cmn;
                    $out .= $empty_space; 
                    $out .= '<div class="inner-opt-wrapper">';                      
                    
                        $out .= '<span class="dc-cms-control-top-label-nomargin">Content (shorcodes allowed)</span>';
                        $out .= $this->getTextAreaShortCodeWrapperStart();
                            $out .= '<textarea class="dc-cms-control-wide dc-cms-control-h-120 dc-cms-control-textarea" name="segment-cell-data-'.$cell->core['id'].'-note-content" >'.$cell->note['content'].'</textarea>';
                        $out .= $this->getTextAreaShortCodeWrapperEnd();                    
                    
                        $out .= '<span class="dc-cms-control-top-label">Text color</span>'; 
                        $out .= '<input type="text" class="dc-color-picker" value="'.$cell->note['color'].'" name="segment-cell-data-'.$cell->core['id'].'-note-color" /> ';

                        $out .= '<span class="dc-cms-control-top-label">Background color</span>'; 
                        $out .= '<input type="text" class="dc-color-picker" value="'.$cell->note['bgcolor'].'" name="segment-cell-data-'.$cell->core['id'].'-note-bgcolor" /> ';
                        
                        $out .= '<span class="dc-cms-control-top-label">Border color</span>'; 
                        $out .= '<input type="text" class="dc-color-picker" value="'.$cell->note['bcolor'].'" name="segment-cell-data-'.$cell->core['id'].'-note-bcolor" /> ';                        

                        $out .= '<span class="dc-cms-control-top-label">Text align</span>';
                        $out .= '<select class="dc-cms-control-100" name="segment-cell-data-'.$cell->core['id'].'-note-align">'; 
                            $out .= '<option value="left" '.$this->attrSelected($cell->note['align'] == 'left').' >Left</option>';  
                            $out .= '<option value="center" '.$this->attrSelected($cell->note['align'] == 'center').' >Center</option>';
                            $out .= '<option value="right" '.$this->attrSelected($cell->note['align'] == 'right').' >Right</option>';
                        $out .= '</select>';

                        $out .= '<span class="dc-cms-control-top-label">Degree of rounding corners</span>';
                        $out .= '<select class="dc-cms-control-100" name="segment-cell-data-'.$cell->core['id'].'-note-rounded">';
                            for($i = 0; $i <= 16; $i++)
                            { 
                                $out .= '<option value="'.$i.'" '.$this->attrSelected($cell->note['rounded'] == $i).' >'.$i.'</option>';  
                            }
                        $out .= '</select>';
                        
                        $out .= '<span class="dc-cms-control-top-label">Border width</span>'; 
                        $out .= $this->getCtrlInputInt('segment-cell-data-'.$cell->core['id'].'-note-bwidth', $cell->note['bwidth'], 0);                        
                        
                        $out .= '<span class="dc-cms-control-top-label">Other settings</span>'; 
                        $out .= $this->getStdInputsFieldStart();
                            $out .= '<input type="checkbox" name="segment-cell-data-'.$cell->core['id'].'-note-execute" '.$this->attrChecked($cell->note['execute']).' /> Execute shortcodes';
                        $out .= $this->getStdInputsFieldEnd();          
                                  
                    $out .= '</div>'; /* inner-opt-wrapper */ 
                $out .= '</div>';
            } break;  
            
            case 'blockquote':
            {
                $out .= '<div class="segment-options">';            
                                                              
                    $out .= $std;
                    $out .= $cmn;
                    $out .= $empty_space; 
                    $out .= '<div class="inner-opt-wrapper">';  

                        $out .= '<span class="dc-cms-control-top-label-nomargin">Content</span>';
                        $out .= '<textarea class="dc-cms-control-wide dc-cms-control-h-120 dc-cms-control-textarea" name="segment-cell-data-'.$cell->core['id'].'-blockquote-content" >'.$cell->blockquote['content'].'</textarea>';                      
                    
                        $out .= '<span class="dc-cms-control-top-label">Blockquote author</span>'; 
                        $out .= '<textarea class="dc-cms-control-wide dc-cms-control-textarea dc-cms-control-h-40" name="segment-cell-data-'.$cell->core['id'].'-blockquote-author" >'.$cell->blockquote['author'].'</textarea>';     
                    
                        $out .= '<span class="dc-cms-control-top-label">Author title</span>'; 
                        $out .= '<textarea class="dc-cms-control-wide dc-cms-control-textarea dc-cms-control-h-40" name="segment-cell-data-'.$cell->core['id'].'-blockquote-title" >'.$cell->blockquote['title'].'</textarea>';     
                          
                        $out .= '<span class="dc-cms-control-top-label">Text align</span>';
                        $out .= '<select class="dc-cms-control-100" name="segment-cell-data-'.$cell->core['id'].'-blockquote-align">'; 
                            $out .= '<option value="left" '.$this->attrSelected($cell->blockquote['align'] == 'left').' >Left</option>';  
                            $out .= '<option value="center" '.$this->attrSelected($cell->blockquote['align'] == 'center').' >Center</option>';
                            $out .= '<option value="right" '.$this->attrSelected($cell->blockquote['align'] == 'right').' >Right</option>';
                        $out .= '</select>';                                              
                    
                        $out .= '<span class="dc-cms-control-top-label">Text color</span>'; 
                        $out .= '<input type="text" class="dc-color-picker" value="'.$cell->blockquote['color'].'" name="segment-cell-data-'.$cell->core['id'].'-blockquote-color" /> ';                                                                                                  
                    
                        $out .= '<span class="dc-cms-control-top-label">Font size</span>';
                        $out .= $this->getCtrlInputInt('segment-cell-data-'.$cell->core['id'].'-blockquote-fsize', $cell->blockquote['fsize'], 0, 1000);                       

                        $out .= '<span class="dc-cms-control-top-label">Line height</span>';
                        $out .= $this->getCtrlInputInt('segment-cell-data-'.$cell->core['id'].'-blockquote-lheight', $cell->blockquote['lheight'], 0, 1200);   
                    
                    $out .= '</div>'; /* inner-opt-wrapper */ 
                $out .= '</div>';                                   
            } break;                 
                 
            case 'ul-list':
            {
                $out .= '<div class="segment-options">';            
                                                              
                    $out .= $std;
                    $out .= $cmn;
                    $out .= $empty_space; 
                    $out .= '<div class="inner-opt-wrapper">';  
                    
                        $out .= '<span class="dc-cms-control-top-label-nomargin">Content</span>';
                        $out .= '<textarea class="dc-cms-control-wide dc-cms-control-h-200 dc-cms-control-textarea" name="segment-cell-data-'.$cell->core['id'].'-ul_list-content" >'.$cell->ul_list['content'].'</textarea>';                                                              
                    
                        $out .= '<span class="dc-cms-control-top-label">List type</span>'; 
                        $out .= '<select class="dc-cms-control-300" name="segment-cell-data-'.$cell->core['id'].'-ul_list-type">';
                            $out .= '<option value="default" '.$this->attrSelected($cell->ul_list['type'] == 'default').'>Default</option>';
                            $out .= '<option value="tag" '.$this->attrSelected($cell->ul_list['type'] == 'tag').'>Tag</option>';
                            $out .= '<option value="pin" '.$this->attrSelected($cell->ul_list['type'] == 'pin').'>Pin</option>';
                            $out .= '<option value="star" '.$this->attrSelected($cell->ul_list['type'] == 'star').'>Star</option>'; 
                            $out .= '<option value="arrow" '.$this->attrSelected($cell->ul_list['type'] == 'arrow').'>Arrow</option>';
                            $out .= '<option value="arrowdark" '.$this->attrSelected($cell->ul_list['type'] == 'arrowdark').'>Arrow dark</option>';
                            $out .= '<option value="arrowgrey" '.$this->attrSelected($cell->ul_list['type'] == 'arrowgrey').'>Arrow grey</option>';  
                            $out .= '<option value="document" '.$this->attrSelected($cell->ul_list['type'] == 'document').'>Document</option>'; 
                            $out .= '<option value="tick" '.$this->attrSelected($cell->ul_list['type'] == 'tick').'>Tick</option>';  
                            $out .= '<option value="asterisk" '.$this->attrSelected($cell->ul_list['type'] == 'asterisk').'>Asterisk</option>';
                            $out .= '<option value="cross" '.$this->attrSelected($cell->ul_list['type'] == 'cross').'>Cross</option>'; 
                            $out .= '<option value="exclamation" '.$this->attrSelected($cell->ul_list['type'] == 'exclamation').'>Exclamation</option>'; 
                        $out .= '</select>';
                        
                        $out .= $this->getHTMLUnorderedListLegend();
                        
                    $out .= '</div>'; /* inner-opt-wrapper */
                $out .= '</div>';                      
            } break;    
            
            case 'postbox':
            {
                $out .= '<div class="segment-options">';            
                                                              
                    $out .= $std;
                    $out .= $cmn;
                    $out .= $empty_space; 
                    $out .= '<div class="inner-opt-wrapper">';  

                        $out .= '<span class="dc-cms-control-top-label-nomargin">Post ID</span>'; 
                        $out .= '<input type="text" class="dc-cms-control-100" value="'.$cell->postbox['id'].'" name="segment-cell-data-'.$cell->core['id'].'-postbox-id" />'; 
                        
                        $out .= '<span class="dc-cms-control-top-label">Post description</span>';
                        $out .= '<textarea class="dc-cms-control-textarea dc-cms-control-wide dc-cms-control-h-60" name="segment-cell-data-'.$cell->core['id'].'-postbox-desc">'.$cell->postbox['desc'].'</textarea>';
                        
                        $out .= '<div class="dc-cms-help-note-box">';
                            $out .= 'Optional post description. If is not specified, shortcode is trying get description from post exceprt. If the excerpt is not given the description is taken from post content.';                    
                        $out .= '</div>';
                        
                        $out .= '<span class="dc-cms-control-top-label">Number of words to display</span>';                    
                        $out .= $this->getCtrlInputInt('segment-cell-data-'.$cell->core['id'].'-postbox-words', $cell->postbox['words'], 1); 
                        
                        $out .= '<span class="dc-cms-control-top-label">Optional image URL</span>';  
                        $out .= '<input type="text" class="dc-cms-control-wide" name="segment-cell-data-'.$cell->core['id'].'-postbox-url" value="'.$cell->postbox['url'].'" id="dc-id-segment-cell-data-'.$cell->core['id'].'-postbox-url" />';
                        
                        $out .= '<div class="dc-cms-btn-frame">';
                            $out .= '<input class="dc-cms-submit-image-btn" type="button" name="dc-id-segment-cell-data-'.$cell->core['id'].'-postbox-url" value="Load image" />';
                        $out .= '</div>';                        
                        
                        $out .= '<div class="dc-cms-help-note-box">'; 
                            $out .= 'This is optional. Here you can manually choose image displayed in post box. 
                                     If not specified, the image is takem from post custom settings. This can be also 
                                     native <span class="dc-cms-marked-span">WordPress</span> thumbnail assigned in post settings, 
                                     but only if theme options settings are set to WP thubmnail display.';
                        $out .= '</div>';
                        
                        $out .= '<span class="dc-cms-control-top-label">Other settings</span>';
                        $out .= $this->getStdInputsFieldStart();
                            $out .= '<input type="checkbox" name="segment-cell-data-'.$cell->core['id'].'-postbox-border" '.$this->attrChecked($cell->postbox['border']).' /> Display border ';    
                        $out .= $this->getStdInputsFieldEnd();                        

                    $out .= '</div>'; /* inner-opt-wrapper */
                $out .= '</div>';                
            } break;    
            
            case 'pagebox':
            {
                $out .= '<div class="segment-options">';            
                                                              
                    $out .= $std;
                    $out .= $cmn;
                    $out .= $empty_space; 
                    $out .= '<div class="inner-opt-wrapper">';  

                        $out .= '<span class="dc-cms-control-top-label-nomargin">Page ID</span>'; 
                        $out .= '<input type="text" class="dc-cms-control-100" value="'.$cell->pagebox['id'].'" name="segment-cell-data-'.$cell->core['id'].'-pagebox-id" />'; 
                        
                        $out .= '<span class="dc-cms-control-top-label">Page description</span>';
                        $out .= '<textarea class="dc-cms-control-textarea dc-cms-control-wide dc-cms-control-h-60" name="segment-cell-data-'.$cell->core['id'].'-pagebox-desc">'.$cell->pagebox['desc'].'</textarea>';
                        
                        $out .= '<div class="dc-cms-help-note-box">';
                            $out .= 'Optional page description. If is not specified, shortcode is trying get description from page exceprt. If the excerpt is not given the description is taken from page content.';                    
                        $out .= '</div>';
                        
                        $out .= '<span class="dc-cms-control-top-label">Number of words to display</span>';                    
                        $out .= $this->getCtrlInputInt('segment-cell-data-'.$cell->core['id'].'-pagebox-words', $cell->pagebox['words'], 1);                    
                        
                        $out .= '<span class="dc-cms-control-top-label">Optional image URL</span>';  
                        $out .= '<input type="text" class="dc-cms-control-wide" name="segment-cell-data-'.$cell->core['id'].'-pagebox-url" value="'.$cell->pagebox['url'].'" id="dc-id-segment-cell-data-'.$cell->core['id'].'-pagebox-url" />';
                        
                        $out .= '<div class="dc-cms-btn-frame">';
                            $out .= '<input class="dc-cms-submit-image-btn" type="button" name="dc-id-segment-cell-data-'.$cell->core['id'].'-pagebox-url" value="Load image" />';
                        $out .= '</div>';                        
                        
                        $out .= '<div class="dc-cms-help-note-box">'; 
                            $out .= 'This is optional. Here you can manually choose image displayed in page box. 
                                     If not specified, the image is takem from page custom settings. This can be also 
                                     native <span class="dc-cms-marked-span">WordPress</span> thumbnail assigned in page settings, 
                                     but only if theme options settings are set to WP thubmnail display.';
                        $out .= '</div>';
                        
                        $out .= '<span class="dc-cms-control-top-label">Other settings</span>';
                        $out .= $this->getStdInputsFieldStart();
                            $out .= '<input type="checkbox" name="segment-cell-data-'.$cell->core['id'].'-pagebox-border" '.$this->attrChecked($cell->pagebox['border']).' /> Display border ';    
                        $out .= $this->getStdInputsFieldEnd();
                            
                    $out .= '</div>'; /* inner-opt-wrapper */
                $out .= '</div>';                
            } break; 
            
            case 'tip':
            {
                $out .= '<div class="segment-options">';            
                                                              
                    $out .= $std;
                    $out .= $cmn;
                    $out .= $empty_space; 
                    $out .= '<div class="inner-opt-wrapper">';  
         
                        $out .= '<span class="dc-cms-control-top-label-nomargin">Content</span>';
                        $out .= '<textarea class="dc-cms-control-wide dc-cms-control-h-120 dc-cms-control-textarea" name="'.$prename.'-tip-content" >'.$cell->tip['content'].'</textarea>';                                                   
         
                        $out .= '<span class="dc-cms-control-top-label">Optional image symbol</span>';  
                        $out .= '<input type="text" class="dc-cms-control-wide" name="'.$prename.'-tip-url" value="'.$cell->tip['url'].'" id="dc-id-'.$prename.'-tip-url" />';
                        
                        $out .= $this->getImagePreviewBox(array('path' => $cell->tip['url'], 'width' => 240, 'height' => 120, 'margin' => '15px 0px 0px 0px'));                          
                        
                        $out .= '<div class="dc-cms-btn-frame">';
                            $out .= '<input class="dc-cms-submit-image-btn" type="button" name="dc-id-'.$prename.'-tip-url" value="Load image" />';
                        $out .= '</div>';    

                        $out .= '<span class="dc-cms-control-top-label">Title</span>';  
                        $out .= '<textarea class="dc-cms-control-wide dc-cms-control-textarea dc-cms-control-h-40" name="'.$prename.'-tip-title">'.$cell->tip['title'].'</textarea>';
                        
                        $out .= '<span class="dc-cms-control-top-label">Link URL</span>';  
                        $out .= '<input type="text" class="dc-cms-control-wide" name="'.$prename.'-tip-link" value="'.$cell->tip['link'].'" />';

                        $out .= '<span class="dc-cms-control-top-label">Link name</span>';  
                        $out .= '<textarea class="dc-cms-control-textarea dc-cms-control-300 dc-cms-control-h-40" name="'.$prename.'-tip-link_name">'.$cell->tip['link_name'].'</textarea>';
                       
                        $out .= '<span class="dc-cms-control-top-label">Text color</span>'; 
                        $out .= '<input type="text" class="dc-color-picker" value="'.$cell->tip['color'].'" name="'.$prename.'-tip-color" /> ';                    
                        
                        $out .= '<span class="dc-cms-control-top-label">Image space width in pixels</span>'; 
                        $out .= $this->getCtrlInputInt($prename.'-tip-image_space', $cell->tip['image_space'], 1, 1920);                        
                        
                        $out .= '<span class="dc-cms-control-top-label">Other settings</span>'; 
                        $out .= $this->getStdInputsFieldStart();
                            $out .= '<input type="checkbox" name="'.$prename.'-tip-link_use" '.$this->attrChecked($cell->tip['link_use']).' /> Use link'; 
                            $out .= $this->getBR();
                            $out .= '<input type="checkbox" name="'.$prename.'-tip-new_tab" '.$this->attrChecked($cell->tip['new_tab']).' /> Open link in new window/tab';
                            $out .= $this->getBR();   
                            $out .= '<input type="checkbox" name="'.$prename.'-tip-image_use" '.$this->attrChecked($cell->tip['image_use']).' /> Use image'; 
                            $out .= $this->getBR();                                                     
                        $out .= $this->getStdInputsFieldEnd();                                                                                    
                    
                    $out .= '</div>'; /* inner-opt-wrapper */
                $out .= '</div>';                                      
            } break;                                                           
                      
             case 'image':
             {
                $out .= '<div class="segment-options">';            
                                                              
                    $out .= $std;
                    $out .= $cmn;
                    $out .= $empty_space; 
                    $out .= '<div class="inner-opt-wrapper">';  
                    
                        $out .= '<span class="dc-cms-control-top-label-nomargin">Image URL</span>';  
                        $out .= '<input type="text" class="dc-cms-control-wide" name="'.$prename.'-image-url" value="'.$cell->image['url'].'" id="dc-id-'.$prename.'-image-url" />';
                        
                        $out .= $this->getImagePreviewBox(array('path' => $cell->image['url'], 'width' => 240, 'height' => 120, 'margin' => '15px 0px 0px 0px'));
                        
                        $img_info = dcf_getImageSize($cell->image['url']);
                        if(is_array($img_info))
                        {
                                $out .= '<span class="dc-cms-control-top-label">Image information</span>'; 
                                 
                                $out .= '<div class="dc-cms-object-data-box">';
                                    $out .= '<div class="option"><div class="property">Width</div><div class="value">'.$img_info['w'].'</div></div>';
                                    $out .= '<div class="option"><div class="property">Height</div><div class="value">'.$img_info['h'].'</div></div>';
                                    $out .= '<div class="option"><div class="property">Type</div><div class="value">'.strtoupper($img_info['ext']).'</div></div>'; 
                                $out .= '</div>';                        
                        }
                        
                        $out .= '<div class="dc-cms-btn-frame">';
                            $out .= '<input class="dc-cms-submit-image-btn" type="button" name="dc-id-'.$prename.'-image-url" value="Load image" />';
                        $out .= '</div>';                        

                        $out .= '<span class="dc-cms-control-top-label">Image Alt text</span>';  
                        $out .= '<input type="text" class="dc-cms-control-wide" name="'.$prename.'-image-alt" value="'.$cell->image['alt'].'" />';
                    
                        $out .= '<span class="dc-cms-control-top-label">Title</span>';  
                        $out .= '<textarea type="text" class="dc-cms-control-wide dc-cms-control-h-40 dc-cms-control-textarea" name="'.$prename.'-image-title" >'.$cell->image['title'].'</textarea>';                    

                        $out .= '<span class="dc-cms-control-top-label">Description</span>';  
                        $out .= '<textarea class="dc-cms-control-wide dc-cms-control-h-80 dc-cms-control-textarea" name="'.$prename.'-image-desc" >'.$cell->image['desc'].'</textarea>';                                                     
                    
                        $out .= '<span class="dc-cms-control-top-label">Description text align</span>';
                        $out .= '<select class="dc-cms-control-100" name="'.$prename.'-image-align">'; 
                            $out .= '<option value="left" '.$this->attrSelected($cell->image['align'] == 'left').' >Left</option>';  
                            $out .= '<option value="center" '.$this->attrSelected($cell->image['align'] == 'center').' >Center</option>';
                            $out .= '<option value="right" '.$this->attrSelected($cell->image['align'] == 'right').' >Right</option>';
                        $out .= '</select>';                       
                    
                        $out .= '<span class="dc-cms-control-top-label">Padding size</span>'; 
                        $out .= $this->getCtrlInputInt($prename.'-image-padding', $cell->image['padding'], 0);                        

                        $out .= '<span class="dc-cms-control-top-label">Viewport width</span>'; 
                        $out .= $this->getCtrlInputInt($prename.'-image-viewport_w', $cell->image['viewport_w'], 0);     

                        $out .= '<span class="dc-cms-control-top-label">Viewport height</span>'; 
                        $out .= $this->getCtrlInputInt($prename.'-image-viewport_h', $cell->image['viewport_h'], 0);     
                    
                        $out .= '<span class="dc-cms-control-top-label">Link URL</span>';  
                        $out .= '<input type="text" class="dc-cms-control-wide" name="'.$prename.'-image-link" value="'.$cell->image['link'].'" />';                     

                        $out .= '<span class="dc-cms-control-top-label">Group name (single word)</span>';  
                        $out .= '<textarea type="text" class="dc-cms-control-200 dc-cms-control-h-40 dc-cms-control-textarea" name="'.$prename.'-image-group" >'.$cell->image['group'].'</textarea>';  
                    
                        $out .= '<span class="dc-cms-control-top-label">Other settings</span>'; 
                        $out .= $this->getStdInputsFieldStart();
                            $out .= '<input type="checkbox" name="'.$prename.'-image-border" '.$this->attrChecked($cell->image['border']).' /> Display border'.$this->getBookHelp(array('text' => 'Border looks good only if image have some padding.'));  
                            $out .= $this->getBR();
                            $out .= '<input type="checkbox" name="'.$prename.'-image-real_size" '.$this->attrChecked($cell->image['real_size']).' /> Display image in original size'.$this->getBookHelp(array('text' => 'If checked, viewport settings will be ignored.'));
                            $out .= $this->getBR();
                            $out .= '<input type="checkbox" name="'.$prename.'-image-grayscale" '.$this->attrChecked($cell->image['grayscale']).' /> Display image in grayscale';
                            $out .= $this->getBR();                            
                            $out .= '<input type="checkbox" name="'.$prename.'-image-new_tab" '.$this->attrChecked($cell->image['new_tab']).' /> Open link in new window/tab ';
                            $out .= $this->getBR(2);
                            $out .= '<div class="dc-cms-excludable-checkbox-field-nomargin">';
                                $out .= '<input type="checkbox" name="'.$prename.'-image-lightbox" '.$this->attrChecked($cell->image['lightbox']).' /> Allow display image in lightbox  ';
                                $out .= $this->getBR();
                                $out .= '<input type="checkbox" name="'.$prename.'-image-image_as_link" '.$this->attrChecked($cell->image['image_as_link']).' /> Display image as link ';                            
                            $out .= '</div>';                            
                        $out .= $this->getStdInputsFieldEnd();                       
                    
                    $out .= '</div>'; /* inner-opt-wrapper */
                $out .= '</div>';                                       
             } break;         
                                 
             case 'video':
             {
                $out .= '<div class="segment-options">';            
                                                              
                    $out .= $std;
                    $out .= $cmn;
                    $out .= $empty_space; 
                    $out .= '<div class="inner-opt-wrapper">'; 
                    
                        $out .= '<span class="dc-cms-control-top-label-nomargin">Video URL from YouTube or Vimeo</span>';  
                        $out .= '<input type="text" class="dc-cms-control-wide" name="'.$prename.'-video-url" value="'.$cell->video['url'].'" />';                    
                    
                        $out .= '<span class="dc-cms-control-top-label">Video description</span>'; 
                        $out .= '<textarea class="dc-cms-control-wide dc-cms-control-h-140 dc-cms-control-textarea" name="'.$prename.'-video-content" >'.$cell->video['content'].'</textarea>';  
                    
                    $out .= '<span class="dc-cms-control-top-label">Other settings</span>';  
                        $out .= self::getStdInputsFieldStart();
                            $out .= '<input type="checkbox" name="'.$prename.'-video-desc_use" '.$this->attrChecked($cell->video['desc_use']).' /> Display description';                                                                                    
                        $out .= self::getStdInputsFieldEnd();                     
                    
                    $out .= '</div>'; /* inner-opt-wrapper */
                $out .= '</div>';                                         
             } break;                   
                     
             case 'ngg':
             {
                $out .= '<div class="segment-options">';            
                                                              
                    $out .= $std;
                    $out .= $cmn;
                    $out .= $empty_space; 
                    $out .= '<div class="inner-opt-wrapper">'; 
                    
                        $out .= '<span class="dc-cms-control-top-label-nomargin">Select NextGen Gallery to display</span>';  
                        $args = array(
                            'current' => $cell->ngg['id'],
                            'name' => 'segment-cell-data-'.$cell->core['id'].'-ngg-id',
                            'w' => 300
                        );
                        $out .= self::selectCtrlNGGList($args);                   
                    
                        $out .= '<span class="dc-cms-control-top-label">Thumb width</span>'; 
                        $out .= self::getCtrlInputInt('segment-cell-data-'.$cell->core['id'].'-ngg-w', $cell->ngg['w'], 1, 1000);            

                        $out .= '<span class="dc-cms-control-top-label">Thumb height</span>'; 
                        $out .= self::getCtrlInputInt('segment-cell-data-'.$cell->core['id'].'-ngg-h', $cell->ngg['h'], 1, 1000);   

                        $out .= '<span class="dc-cms-control-top-label">Number of displayed thumbs</span>'; 
                        $out .= self::getCtrlInputInt('segment-cell-data-'.$cell->core['id'].'-ngg-count', $cell->ngg['count'], 1, 1000);            

                        $out .= '<span class="dc-cms-control-top-label">Thumb right margin</span>'; 
                        $out .= self::getCtrlInputInt('segment-cell-data-'.$cell->core['id'].'-ngg-tright', $cell->ngg['tright'], 0, 1000);   

                        $out .= '<span class="dc-cms-control-top-label">Thumb bottom margin</span>'; 
                        $out .= self::getCtrlInputInt('segment-cell-data-'.$cell->core['id'].'-ngg-tbottom', $cell->ngg['tbottom'], 0, 1000);  
                    
                        $out .= '<span class="dc-cms-control-top-label">Group name (single word), overwrite default group name, can be used to connect and group two or more galleries</span>';
                        $out .= '<textarea class="dc-cms-control-wide dc-cms-control-textarea dc-cms-control-h-40" name="segment-cell-data-'.$cell->core['id'].'-ngg-group" >'.$cell->ngg['group'].'</textarea>';  

                        $out .= '<span class="dc-cms-control-top-label">Thumb padding</span>'; 
                        $out .= self::getCtrlInputInt('segment-cell-data-'.$cell->core['id'].'-ngg-padding', $cell->ngg['padding'], 0, 1000);  
                    
                        $out .= '<span class="dc-cms-control-top-label">Border color</span>'; 
                        $out .= '<input type="text" class="dc-color-picker" value="'.$cell->ngg['bcolor'].'" name="segment-cell-data-'.$cell->core['id'].'-ngg-bcolor" /> ';  
                        
                        $out .= '<span class="dc-cms-control-top-label">Background color</span>'; 
                        $out .= '<input type="text" class="dc-color-picker" value="'.$cell->ngg['bgcolor'].'" name="segment-cell-data-'.$cell->core['id'].'-ngg-bgcolor" /> ';                                              
                    
                        $out .= '<span class="dc-cms-control-top-label">Other settings</span>';
                        $out .= self::getStdInputsFieldStart();
                            $out .= '<input type="checkbox" name="segment-cell-data-'.$cell->core['id'].'-ngg-border" '.$this->attrChecked($cell->ngg['border']).' /> Display border';
                            $out .= self::getBR();                            
                            $out .= '<input type="checkbox" name="segment-cell-data-'.$cell->core['id'].'-ngg-bgcolor_use" '.$this->attrChecked($cell->ngg['border']).' /> Use background color';
                            $out .= self::getBR(); 
                            $out .= '<input type="checkbox" name="segment-cell-data-'.$cell->core['id'].'-ngg-all" '.$this->attrChecked($cell->ngg['all']).' />  Display all images from gallery (not working with <strong>random</strong> option, also the number of displayed thumbs will be ignored)';
                            $out .= self::getBR(); 
                            $out .= '<input type="checkbox" name="segment-cell-data-'.$cell->core['id'].'-ngg-random" '.$this->attrChecked($cell->ngg['random']).' /> Display random images from gallery';                                                                                    
                        $out .= self::getStdInputsFieldEnd(); 
                    
                    $out .= '</div>'; /* inner-opt-wrapper */
                $out .= '</div>';                                         
             } break;                          
                      
             case 'ngg-thumbs-slider':
             {
                $out .= '<div class="segment-options">';            
                                                              
                    $out .= $std;
                    $out .= $cmn;
                    $out .= $empty_space; 
                    $out .= '<div class="inner-opt-wrapper">'; 
                    
                        $out .= '<span class="dc-cms-control-top-label-nomargin">Select NextGen Gallery to display</span>';  
                        $args = array(
                            'current' => $cell->ngg_thumbs_slider['id'],
                            'name' => 'segment-cell-data-'.$cell->core['id'].'-ngg_thumbs_slider-id',
                            'w' => 300
                        );
                        $out .= self::selectCtrlNGGList($args);                                      
                    
                        $out .= '<span class="dc-cms-control-top-label">Slider description</span>';
                        $out .= '<textarea class="dc-cms-control-wide dc-cms-control-textarea dc-cms-control-h-100" name="segment-cell-data-'.$cell->core['id'].'-ngg_thumbs_slider-desc" >'.$cell->ngg_thumbs_slider['desc'].'</textarea>';                      
                    
                        $out .= '<span class="dc-cms-control-top-label">Viewport width</span>'; 
                        $out .= self::getCtrlInputInt('segment-cell-data-'.$cell->core['id'].'-ngg_thumbs_slider-viewport_w', $cell->ngg_thumbs_slider['viewport_w'], 1, 1000);            

                        $out .= '<span class="dc-cms-control-top-label">Viewport height</span>'; 
                        $out .= self::getCtrlInputInt('segment-cell-data-'.$cell->core['id'].'-ngg_thumbs_slider-viewport_h', $cell->ngg_thumbs_slider['viewport_h'], 1, 1000);                      
                    
                        $out .= '<span class="dc-cms-control-top-label">Transition</span>';
                        $out .= '<select class="dc-cms-control-100" name="segment-cell-data-'.$cell->core['id'].'-ngg_thumbs_slider-transition">';
                            $out .= '<option value="fade" '.$this->attrSelected($cell->ngg_thumbs_slider['transition'] == 'fade').'>Fade</option>';
                            $out .= '<option value="slide" '.$this->attrSelected($cell->ngg_thumbs_slider['transition'] == 'slide').'>Slide</option>';
                            $out .= '<option value="none" '.$this->attrSelected($cell->ngg_thumbs_slider['transition'] == 'none').'>None</option>';                        
                        $out .= '</select>'; 
                        
                        $out .= '<span class="dc-cms-control-top-label">Number of displayed images</span>'; 
                        $out .= self::getCtrlInputInt('segment-cell-data-'.$cell->core['id'].'-ngg_thumbs_slider-count', $cell->ngg_thumbs_slider['count'], 1, 1000);                           

                        $out .= '<span class="dc-cms-control-top-label">Thumb size</span>'; 
                        $out .= self::getCtrlInputInt('segment-cell-data-'.$cell->core['id'].'-ngg_thumbs_slider-thumb_size', $cell->ngg_thumbs_slider['thumb_size'], 1, 1000);  
                    
                        $out .= '<span class="dc-cms-control-top-label">Border color</span>'; 
                        $out .= '<input type="text" class="dc-color-picker" value="'.$cell->ngg_thumbs_slider['bcolor'].'" name="segment-cell-data-'.$cell->core['id'].'-ngg_thumbs_slider-bcolor" /> ';                     
                    
                        $out .= '<span class="dc-cms-control-top-label">Other settings</span>';
                        $out .= self::getStdInputsFieldStart();
                            $out .= '<input type="checkbox" name="segment-cell-data-'.$cell->core['id'].'-ngg_thumbs_slider-slide_title" '.$this->attrChecked($cell->ngg_thumbs_slider['slide_title']).' /> Display slide title';
                            $out .= self::getBR();                            
                            $out .= '<input type="checkbox" name="segment-cell-data-'.$cell->core['id'].'-ngg_thumbs_slider-slide_desc" '.$this->attrChecked($cell->ngg_thumbs_slider['slide_desc']).' /> Display slide description';
                            $out .= self::getBR(); 
                            $out .= '<input type="checkbox" name="segment-cell-data-'.$cell->core['id'].'-ngg_thumbs_slider-all" '.$this->attrChecked($cell->ngg_thumbs_slider['all']).' />  Display all images from gallery (not working with <strong>random</strong> option, also the number of displayed images will be ignored)';
                            $out .= self::getBR(); 
                            $out .= '<input type="checkbox" name="segment-cell-data-'.$cell->core['id'].'-ngg_thumbs_slider-random" '.$this->attrChecked($cell->ngg_thumbs_slider['random']).' /> Display random images from gallery';                                                                                    
                        $out .= self::getStdInputsFieldEnd();                     
                    
                    $out .= '</div>'; /* inner-opt-wrapper */
                $out .= '</div>';                                         
             } break;                         
                  
             case 'ngg-gallery':
             {
                $out .= '<div class="segment-options">';            
                                                              
                    $out .= $std;
                    $out .= $cmn;
                    $out .= $empty_space; 
                    $out .= '<div class="inner-opt-wrapper">'; 
                    
                        $out .= '<span class="dc-cms-control-top-label-nomargin">Select NextGen Gallery to display</span>';  
                        $args = array(
                            'current' => $cell->ngg_gallery['id'],
                            'name' => $prename.'-ngg_gallery-id',
                            'w' => 300
                        );
                        $out .= $this->selectCtrlNGGList($args);                                                                          
                    
                        $out .= '<span class="dc-cms-control-top-label">Comma separated NGG images ID list (if set, selected gallery, sorting, exclude options are ignored)</span>';   
                        $out .= '<input type="text" class="dc-cms-control-wide" name="'.$prename.'-ngg_gallery-list" value="'.$cell->ngg_gallery['list'].'" />';                         
                    
                        $out .= '<span class="dc-cms-control-top-label">Images per page</span>'; 
                        $out .= $this->getCtrlInputInt($prename.'-ngg_gallery-per_page', $cell->ngg_gallery['per_page'], 1);                       
                    
                        $out .= '<span class="dc-cms-control-top-label">Select number of displayed columns</span>'; 
                        $out .= '<select name="'.$prename.'-ngg_gallery-columns" class="dc-cms-control-100">';
                            $val = $cell->ngg_gallery['columns'];
                            $out .= '<option value="1" '.$this->attrSelected($val == 1).'>1</option>';
                            $out .= '<option value="2" '.$this->attrSelected($val == 2).'>2</option>';
                            $out .= '<option value="3" '.$this->attrSelected($val == 3).'>3</option>';
                            $out .= '<option value="4" '.$this->attrSelected($val == 4).'>4</option>';
                            $out .= '<option value="5" '.$this->attrSelected($val == 5).'>5</option>'; 
                            $out .= '<option value="6" '.$this->attrSelected($val == 6).'>6</option>';
                            $out .= '<option value="8" '.$this->attrSelected($val == 8).'>8</option>';  
                        $out .= '</select>';
                        
                        $out .= '<span class="dc-cms-control-top-label">Lightbox group name</span>';   
                        $out .= '<input type="text" class="dc-cms-control-300" name="'.$prename.'-ngg_gallery-group" value="'.$cell->ngg_gallery['group'].'" />';                                                
                    
                        $out .= '<div class="dc-cms-help-note-box">';
                            $out .= 'If lightbox group name field is empty, default NGG group name will be assigned to images.';
                        $out .= '</div>';                          
                        
                        $out .= '<span class="dc-cms-control-top-label">Images order</span>';
                        $out .= $this->getStdInputsFieldStart(); 
                            $out .= '<input type="radio" name="'.$prename.'-ngg_gallery-order" value="DESC" '.$this->attrChecked($cell->ngg_gallery['order'] == 'DESC').' /> Descending';
                            $out .= $this->getBR();
                            $out .= '<input type="radio" name="'.$prename.'-ngg_gallery-order" value="ASC" '.$this->attrChecked($cell->ngg_gallery['order'] == 'ASC').' /> Ascending';
                            $out .= $this->getBR();   
                        $out .= $this->getStdInputsFieldEnd(); 
                
                        $out .= '<span class="dc-cms-control-top-label">Sort displayed images by parameter</span>';  
                        $out .= $this->getStdInputsFieldStart(); 
                            $out .= '<input type="radio" name="'.$prename.'-ngg_gallery-orderby" value="sortorder" '.$this->attrChecked($cell->ngg_gallery['orderby'] == 'sortorder').' /> NGG sort order';
                            $out .= $this->getBR();
                            $out .= '<input type="radio" name="'.$prename.'-ngg_gallery-orderby" value="imagedate" '.$this->attrChecked($cell->ngg_gallery['orderby'] == 'imagedate').' /> Image upload date';
                        $out .= $this->getStdInputsFieldEnd();
                        
                        $out .= '<span class="dc-cms-control-top-label">Viewport width</span>'; 
                        $out .= $this->getCtrlInputInt($prename.'-ngg_gallery-viewport_w', $cell->ngg_gallery['viewport_w'], 1);                             

                        $out .= '<span class="dc-cms-control-top-label">Viewport height</span>'; 
                        $out .= $this->getCtrlInputInt($prename.'-ngg_gallery-viewport_h', $cell->ngg_gallery['viewport_h'], 1);                                                       
                    
                        $out .= '<span class="dc-cms-control-top-label">Images bottom margin</span>'; 
                        $out .= $this->getCtrlInputInt($prename.'-ngg_gallery-item_bottom', $cell->ngg_gallery['item_bottom'], 1);                        
                    
                        $out .= '<span class="dc-cms-control-top-label">Other settings</span>';                             
                        $out .= $this->getStdInputsFieldStart();                                                    
                            $out .= '<input type="checkbox" name="'.$prename.'-ngg_gallery-viewport_use" '.$this->attrChecked($cell->ngg_gallery['viewport_use']).' /> Use viewport';  
                            $out .= $this->getBR();                                                                                                                                                                                                                                              
                            $out .= '<input type="checkbox" name="'.$prename.'-ngg_gallery-exclude" '.$this->attrChecked($cell->ngg_gallery['exclude']).' /> Skip images marked as excluded in NGG';  
                            $out .= $this->getBR();
                            $out .= '<input type="checkbox" name="'.$prename.'-ngg_gallery-pagination" '.$this->attrChecked($cell->ngg_gallery['pagination']).' /> Display paggination';  
                            $out .= $this->getBR();
                            $out .= '<input type="checkbox" name="'.$prename.'-ngg_gallery-item_bottom_use" '.$this->attrChecked($cell->ngg_gallery['item_bottom_use']).' /> Use images bottom margin settings';  
                            $out .= $this->getBR();
                            $out .= '<input type="checkbox" name="'.$prename.'-ngg_gallery-grayscale" '.$this->attrChecked($cell->ngg_gallery['grayscale']).' /> Display images in grayscale';                                                                                                                                            
                            $out .= $this->getBR();                                 
                            $out .= '<input type="checkbox" name="'.$prename.'-ngg_gallery-title_display" '.$this->attrChecked($cell->ngg_gallery['title_display']).' /> Display image title';                                                                                                                                            
                            $out .= $this->getBR(); 
                            $out .= '<input type="checkbox" name="'.$prename.'-ngg_gallery-date_display" '.$this->attrChecked($cell->ngg_gallery['date_display']).' /> Display image upload date';                                                                                                                                            
                            $out .= $this->getBR(); 
                            $out .= '<input type="checkbox" name="'.$prename.'-ngg_gallery-desc_display" '.$this->attrChecked($cell->ngg_gallery['desc_display']).' /> Display image description';                                                                                                                                            
                            $out .= $this->getBR(); 
                            $out .= '<input type="checkbox" name="'.$prename.'-ngg_gallery-meta_size" '.$this->attrChecked($cell->ngg_gallery['meta_size']).' /> Display information about image width and height';                                                                                                                                            
                            $out .= $this->getBR(); 
                            $out .= '<input type="checkbox" name="'.$prename.'-ngg_gallery-meta_download" '.$this->attrChecked($cell->ngg_gallery['meta_download']).' /> Display download link';                                                                                                                                            
                            $out .= $this->getBR();                             
                        $out .= $this->getStdInputsFieldEnd();                                                          
                    
                    $out .= '</div>'; /* inner-opt-wrapper */
                $out .= '</div>';                                         
             } break;                     
                  
             case 'service':
             {
                $out .= '<div class="segment-options">';  
                                                                                            
                    $out .= $std;                                             
                    $out .= $cmn;
                    $out .= $empty_space;
                    $out .= '<div class="inner-opt-wrapper">'; 
                    
                        $out .= '<span class="dc-cms-control-top-label-nomargin">Number of displayed services</span>'; 
                        $out .= $this->getCtrlInputInt($prename.'-service-count', $cell->service['count'], 1);                   
                    
                        $categories = get_terms(DCC_ControlPanelCustomPosts::PT_SERVICE_CATEGORY, array('orderby' => 'name', 'hide_empty' => false)); 
                        
                        if(!is_array($cell->service['cats'])) { $cell->service['cats'] = array(); }
                        $out .= '<span class="dc-cms-control-top-label">Service categories to display</span>';                      
                        $out .= $this->getStdScrollBoxStart(array('height' => 100, 'width' => 300));
                            foreach($categories as $cat)
                            {
                                $checked = false;
                                if(in_array($cat->term_id, $cell->service['cats'])) { $checked = true; }
                                $out .= '<input type="checkbox" value="'.$cat->term_id.'" name="'.$prename.'-service-cats[]" '.($checked ? ' checked="checked" ' : '').'> '.$cat->name. '<br />';
                            }
                        $out .= $this->getStdScrollBoxEnd();
                        
                        $out .= '<div class="dc-cms-help-note-box">';
                            $out .= 'If no category is selected, page is trying to display services from all categories.';
                        $out .= '</div>'; 
                        
                        $out .= '<span class="dc-cms-control-top-label">Comma separated services ID list (if set, selected categories are ignored)</span>';   
                        $out .= '<input type="text" class="dc-cms-control-wide" name="'.$prename.'-service-list" value="'.$cell->service['list'].'" />';                   
                    
                        $out .= '<span class="dc-cms-control-top-label">Select number of displayed columns</span>'; 
                        $out .= '<select name="'.$prename.'-service-columns" class="dc-cms-control-120">';
                            $out .= '<option value="1" '.$this->attrSelected($cell->service['columns'] == 1).'>1</option>';
                            $out .= '<option value="2" '.$this->attrSelected($cell->service['columns'] == 2).'>2</option>';
                            $out .= '<option value="3" '.$this->attrSelected($cell->service['columns'] == 3).'>3</option>';
                            $out .= '<option value="4" '.$this->attrSelected($cell->service['columns'] == 4).'>4</option>';
                        $out .= '</select>';                    
                    
                        $out .= '<span class="dc-cms-control-top-label">Number of words in description</span>'; 
                        $out .= $this->getCtrlInputInt($prename.'-service-words', $cell->service['words'], 1);                       

                        $out .= '<span class="dc-cms-control-top-label">Image size (if layout is set to BOX this option is ignored)</span>'; 
                        $out .= $this->getCtrlInputInt($prename.'-service-size', $cell->service['size'], 1);  
                    
                        $out .= '<span class="dc-cms-control-top-label">Services layout</span>'; 
                        $out .= '<select name="'.$prename.'-service-layout" class="dc-cms-control-120">';
                            $out .= '<option value="classic" '.$this->attrSelected($cell->service['layout'] == 'classic').'>Classic</option>';
                            $out .= '<option value="box" '.$this->attrSelected($cell->service['layout'] == 'box').'>Box</option>';
                        $out .= '</select>';                      
                    
                        $out .= '<span class="dc-cms-control-top-label">Services order</span>';
                        $out .= '<input type="radio" name="'.$prename.'-service-order" value="DESC" '.$this->attrChecked($cell->service['order'] == 'DESC').' /> Descending';
                        $out .= $this->getBR();
                        $out .= '<input type="radio" name="'.$prename.'-service-order" value="ASC" '.$this->attrChecked($cell->service['order'] == 'ASC').' /> Ascending';
                        $out .= $this->getBR();   
                
                        $out .= '<span class="dc-cms-control-top-label">Sort displayed services by parameter</span>';  
                        $out .= '<input type="radio" name="'.$prename.'-service-orderby" value="date" '.$this->attrChecked($cell->service['orderby'] == 'date').' /> Order by date';
                        $out .= $this->getBR();
                        $out .= '<input type="radio" name="'.$prename.'-service-orderby" value="title" '.$this->attrChecked($cell->service['orderby'] == 'title').' /> Order by title';
                        $out .= $this->getBR();                
                        $out .= '<input type="radio" name="'.$prename.'-service-orderby" value="rand" '.$this->attrChecked($cell->service['orderby'] == 'rand').' /> Random order';                     
                    
                        $out .= '<span class="dc-cms-control-top-label">Viewport width</span>'; 
                        $out .= $this->getCtrlInputInt($prename.'-service-viewport_w', $cell->service['viewport_w'], 1);                             

                        $out .= '<span class="dc-cms-control-top-label">Viewport height</span>'; 
                        $out .= $this->getCtrlInputInt($prename.'-service-viewport_h', $cell->service['viewport_h'], 1);       
                        
                        $out .= '<span class="dc-cms-control-top-label">Items bottom margin</span>'; 
                        $out .= $this->getCtrlInputInt($prename.'-service-item_bottom', $cell->service['item_bottom'], 0);                           
                        
                        $out .= '<span class="dc-cms-control-top-label">Other settings</span>';                             
                        $out .= $this->getStdInputsFieldStart();                           
                            $out .= '<input type="checkbox" name="'.$prename.'-service-viewport_use" '.$this->attrChecked($cell->service['viewport_use']).' /> Use viewport';  
                            $out .= $this->getBR(); 
                            $out .= '<input type="checkbox" name="'.$prename.'-service-item_bottom_use" '.$this->attrChecked($cell->service['item_bottom_use']).' /> Use items margin bottom settings';                                                                                                                                                                                              
                        $out .= $this->getStdInputsFieldEnd();                      
                    
                    $out .= '</div>'; /* inner-opt-wrapper */
                $out .= '</div>';                                     
             } break;                                         
                   
             case 'project':
             {
                $out .= '<div class="segment-options">';  
                                                                                            
                    $out .= $std;                                             
                    $out .= $cmn;
                    $out .= $empty_space;
                    $out .= '<div class="inner-opt-wrapper">';                    
                            
                        $out .= '<span class="dc-cms-control-top-label-nomargin">Number of displayed projects</span>'; 
                        $out .= $this->getCtrlInputInt($prename.'-project-per_page', $cell->project['per_page'], 1);                                  
                                
                        $categories = get_terms(DCC_ControlPanelCustomPosts::PT_PROJECT_CATEGORY, array('orderby' => 'name', 'hide_empty' => false)); 
                        
                        if(!is_array($cell->project['cats'])) { $cell->project['cats'] = array(); }
                        $out .= '<span class="dc-cms-control-top-label">Project categories to display</span>';                      
                        $out .= $this->getStdScrollBoxStart(array('height' => 100, 'width' => 300));
                            foreach($categories as $cat)
                            {
                                $checked = false;
                                if(in_array($cat->term_id, $cell->project['cats'])) { $checked = true; }
                                $out .= '<input type="checkbox" value="'.$cat->term_id.'" name="'.$prename.'-project-cats[]" '.($checked ? ' checked="checked" ' : '').'> '.$cat->name . ' <span class="term-count">('.$cat->count.')</span><br />';
                            }
                        $out .= $this->getStdScrollBoxEnd();
                        
                        $out .= '<div class="dc-cms-help-note-box">';
                            $out .= 'If no category is selected, segment is trying to display projects from all categories.';
                        $out .= '</div>';  
                        
                        $out .= '<span class="dc-cms-control-top-label">Comma separated projects ID list (if set, selected categories are ignored)</span>';   
                        $out .= '<input type="text" class="dc-cms-control-wide" name="'.$prename.'-project-list" value="'.$cell->project['list'].'" />';                                                        
                                
                        $out .= '<span class="dc-cms-control-top-label">Select number of displayed columns</span>'; 
                        $out .= '<select name="'.$prename.'-project-columns" class="dc-cms-control-100">';
                            $out .= '<option value="1" '.$this->attrSelected($cell->project['columns'] == 1).'>1</option>';
                            $out .= '<option value="2" '.$this->attrSelected($cell->project['columns'] == 2).'>2</option>';
                            $out .= '<option value="3" '.$this->attrSelected($cell->project['columns'] == 3).'>3</option>';
                            $out .= '<option value="4" '.$this->attrSelected($cell->project['columns'] == 4).'>4</option>';
                        $out .= '</select>';                    
                    
                        $out .= '<span class="dc-cms-control-top-label">Number of words in excerpt</span>'; 
                        $out .= $this->getCtrlInputInt($prename.'-project-words', $cell->project['words'], 1);                                  
                                
                        $out .= '<span class="dc-cms-control-top-label">Projects order</span>';
                        $out .= '<input type="radio" name="'.$prename.'-project-order" value="DESC" '.$this->attrChecked($cell->project['order'] == 'DESC').' /> Descending';
                        $out .= $this->getBR();
                        $out .= '<input type="radio" name="'.$prename.'-project-order" value="ASC" '.$this->attrChecked($cell->project['order'] == 'ASC').' /> Ascending';
                        $out .= $this->getBR();   
                
                        $out .= '<span class="dc-cms-control-top-label">Sort displayed projects by parameter</span>';  
                        $out .= '<input type="radio" name="'.$prename.'-project-orderby" value="date" '.$this->attrChecked($cell->project['orderby'] == 'date').' /> Order by date';
                        $out .= $this->getBR();
                        $out .= '<input type="radio" name="'.$prename.'-project-orderby" value="title" '.$this->attrChecked($cell->project['orderby'] == 'title').' /> Order by title';
                        $out .= $this->getBR();                
                        $out .= '<input type="radio" name="'.$prename.'-project-orderby" value="comment_count" '.$this->attrChecked($cell->project['orderby'] == 'comment_count').' /> Comments count';                     
                        
                        $out .= '<span class="dc-cms-control-top-label">Viewport width</span>'; 
                        $out .= $this->getCtrlInputInt($prename.'-project-viewport_w', $cell->project['viewport_w'], 1);                             

                        $out .= '<span class="dc-cms-control-top-label">Viewport height</span>'; 
                        $out .= $this->getCtrlInputInt($prename.'-project-viewport_h', $cell->project['viewport_h'], 1);       

                        $out .= '<span class="dc-cms-control-top-label">Items bottom margin</span>'; 
                        $out .= $this->getCtrlInputInt($prename.'-project-item_bottom', $cell->project['item_bottom'], 0);                                                   
                        
                        $out .= '<span class="dc-cms-control-top-label">Other settings</span>';                             
                        $out .= $this->getStdInputsFieldStart();
                            $out .= '<input type="checkbox" name="'.$prename.'-project-excerpt" '.$this->attrChecked($cell->project['excerpt']).' /> Display project excerpt';
                            $out .= $this->getBR();                            
                            $out .= '<input type="checkbox" name="'.$prename.'-project-pagination" '.$this->attrChecked($cell->project['pagination']).' /> Display pagination';                                                                                 
                            $out .= $this->getBR();                            
                            $out .= '<input type="checkbox" name="'.$prename.'-project-viewport_use" '.$this->attrChecked($cell->project['viewport_use']).' /> Use viewport';  
                            $out .= $this->getBR();
                            $out .= '<input type="checkbox" name="'.$prename.'-project-title_display" '.$this->attrChecked($cell->project['title_display']).' /> Display item title';                                                                                 
                            $out .= $this->getBR(); 
                            $out .= '<input type="checkbox" name="'.$prename.'-project-cats_display" '.$this->attrChecked($cell->project['cats_display']).' /> Display item categories';                                                                                 
                            $out .= $this->getBR(); 
                            $out .= '<input type="checkbox" name="'.$prename.'-project-item_bottom_use" '.$this->attrChecked($cell->project['item_bottom_use']).' /> Use items margin bottom settings';                                                                                                                                                                      
                        $out .= $this->getStdInputsFieldEnd();                                   
                                
                    $out .= '</div>'; /* inner-opt-wrapper */
                $out .= '</div>';  
             } break;
             
             case 'basic-slider':
             {
                $out .= '<div class="segment-options">';  
                                                                                            
                    $out .= $std;                                             
                    $out .= $cmn;
                    $out .= $empty_space;
                    $out .= '<div class="inner-opt-wrapper">'; 
                    
                        $out .= '<div class="dc-cms-builder-basic-slider-type-wrapper">';
                        
                            $order = '';
                            $slides_count = 0;
                            if(is_array($cell->basic_slider['slides']))
                            {
                                $slides_count = count($cell->basic_slider['slides']);
                                for($i = 0; $i < $slides_count; $i++)
                                {
                                    if($i > 0) { $order .= ','; }
                                    $order .= $i;
                                }
                            }
                        
                            $out .= '<input type="hidden" class="slides-order" value="'.$order.'" name="'.$prename.'-basic_slider-slider-order" />';
                        
                            $out .= $this->getStdColumnStart();

                                $out .= '<span class="dc-cms-control-top-label-nomargin">Slider maximum width</span>';
                                $out .= $this->getCtrlInputInt($prename.'-basic_slider-maxwidth', $cell->basic_slider['maxwidth'], 0);
                        
                                $out .= '<div class="dc-cms-help-note-box">';
                                    $out .= 'If <span class="dc-cms-marked-span">maximum width</span> is set to zero, slider will take 100% of available space.';
                                $out .= '</div>';                         
                        
                                $out .= '<span class="dc-cms-control-top-label">Transition speed</span>';
                                $out .= $this->getCtrlInputInt($prename.'-basic_slider-speed', $cell->basic_slider['speed'], 1);

                                $out .= '<span class="dc-cms-control-top-label">Interval between slides change</span>';
                                $out .= $this->getCtrlInputInt($prename.'-basic_slider-timeout', $cell->basic_slider['timeout'], 1);

                                $out .= '<span class="dc-cms-control-top-label">Transition mode</span>';
                                $out .= '<select class="dc-cms-control-100" name="'.$prename.'-basic_slider-transition">';
                                    $out .= '<option value="slide" '.$this->attrSelected($cell->basic_slider['transition'] == 'slide').'>Slide</option>';
                                    $out .= '<option value="fade" '.$this->attrSelected($cell->basic_slider['transition'] == 'fade').'>Fade</option>';
                                $out .= '</select>';
                            
                                $out .= '<span class="dc-cms-control-top-label">Other settings</span>';               
                                $out .= $this->getStdInputsFieldStart();
                                    $out .= '<input type="checkbox" '.$this->attrChecked($cell->basic_slider['auto']).' name="'.$prename.'-basic_slider-auto" /> Autoplay';
                                    $out .= $this->getBR();
                                    $out .= '<input type="checkbox" '.$this->attrChecked($cell->basic_slider['pause']).' name="'.$prename.'-basic_slider-pause" /> Pause slider on mouse hover'; 
                                    $out .= $this->getBR();
                                    $out .= '<input type="checkbox" '.$this->attrChecked($cell->basic_slider['pager']).' name="'.$prename.'-basic_slider-pager" /> Display pages icons under slider'; 
                                    $out .= $this->getBR();
                                    $out .= '<input type="checkbox" '.$this->attrChecked($cell->basic_slider['nextprev']).' name="'.$prename.'-basic_slider-nextprev" /> Display next and previous slide buttons'; 
                                    $out .= $this->getBR();                                
                                    $out .= '<input type="checkbox" '.$this->attrChecked($cell->basic_slider['viewport_use']).' name="'.$prename.'-basic_slider-viewport_use" /> Fit images to viewport size'; 
                                    $out .= $this->getBR(); 
                                    $out .= '<input type="checkbox" '.$this->attrChecked($cell->basic_slider['title_as_h']).' name="'.$prename.'-basic_slider-title_as_h" /> Display slides title as HTML header'; 
                                    $out .= $this->getBR(); 
                                $out .= $this->getStdInputsFieldEnd();                        
                            
                            $out .= $this->getStdColumnEnd();
                            
                            $out .= $this->getStdColumnStart();
                            
                                $out .= '<span class="dc-cms-control-top-label-nomargin">Viewport width</span>';
                                $out .= $this->getCtrlInputInt($prename.'-basic_slider-viewport_w', $cell->basic_slider['viewport_w'], 1);                            

                                $out .= '<span class="dc-cms-control-top-label">Viewport height</span>';
                                $out .= $this->getCtrlInputInt($prename.'-basic_slider-viewport_h', $cell->basic_slider['viewport_h'], 1);    
                            
                                $out .= '<div class="dc-cms-help-note-box">';
                                    $out .= 'Viewport don\'t define slider width or height. This is <span class="dc-cms-marked-span">image size</span> transform, before it will be inserted to slider. If viewport is used, slide image will be fitted to viewport size before display. This can <span class="dc-cms-marked-span">crop</span> and <span class="dc-cms-marked-span">stretch</span> image in some way, but will keep all images in one size for proper slider work. In practice this is quite good tool for changing images aspect ratio and might be useful especially if you have images in different proportions or sizes. You can try to set slider <span class="dc-cms-marked-span">maximum width</span> and viewport width to the same value.';
                                $out .= '</div>';                              
                            
                            $out .= $this->getStdColumnEnd(); 
                                                        
                            $out .= $this->getStdColumnStart();  
                            
                                $out .= '<span class="dc-cms-control-top-label-nomargin">Title size (only if title as HTML header)</span>';
                                $out .= '<select name="'.$prename.'-basic_slider-title_size" class="dc-cms-control-100">';
                                    $out .= '<option value="1" '.$this->attrSelected($cell->basic_slider['title_size'] == 1).'>H1</option>';
                                    $out .= '<option value="2" '.$this->attrSelected($cell->basic_slider['title_size'] == 2).'>H2</option>';
                                    $out .= '<option value="3" '.$this->attrSelected($cell->basic_slider['title_size'] == 3).'>H3</option>';
                                    $out .= '<option value="4" '.$this->attrSelected($cell->basic_slider['title_size'] == 4).'>H4</option>';
                                    $out .= '<option value="5" '.$this->attrSelected($cell->basic_slider['title_size'] == 5).'>H5</option>';
                                    $out .= '<option value="6" '.$this->attrSelected($cell->basic_slider['title_size'] == 6).'>H6</option>';
                                $out .= '</select>';
                                 
                                $out .= '<span class="dc-cms-control-top-label">Title color</span>'; 
                                $out .= '<input type="text" class="dc-color-picker" value="'.$cell->basic_slider['title_color'].'" name="'.$prename.'-basic_slider-title_color" /> ';                                                                      
                            
                            $out .= $this->getStdColumnEnd();      
                            
                            $out .= $this->getClearBoth(1);
                            
                            $out .= $this->getFreeSectionHead(array('label' => 'Slides list'));
                            $out .= '<ul class="dc-cms-builder-basic-slider-list">';
                            
                                for($i = 0; $i < $slides_count; $i++)
                                {
                                    $id = $cell->core['id'];
                                    $index = $i;
                                    $out .= $this->getHTMLBasicSliderTypeSlide(array('id' => $id, 'index' => $index), $cell->basic_slider['slides'][$i], false);
                                }
                            
                            
                            $out .= '</ul>';
                        
                        
                            $out .= '<div class="dc-cms-clear"></div>';
                            $out .= '<div class="dc-cms-btn-frame">';
                                $out .= '<span class="dc-cms-action-name">dc_builder_basic_slider_add_slide</span>'; 
                                $out .= '<input class="dc-cms-submit-btn" type="button" name="dc-builder-basic-slider-add-slide" value="Add slide">';
                            $out .= '</div>';  
                            
                            $out .= '<div class="dc-cms-clear"></div>';                   
                        $out .= '</div>';                                
                                
                    $out .= '</div>'; /* inner-opt-wrapper */
                $out .= '</div>';  
             } break;                                   

             case 'code':
             {
                $out .= '<div class="segment-options">';  
                                                                                            
                    $out .= $std;                                             
                    $out .= $cmn;
                    $out .= $empty_space;
                    $out .= '<div class="inner-opt-wrapper">';                  
             
                        $out .= '<span class="dc-cms-control-top-label-nomargin">Select code language</span>';  
                        $out .= '<select class="dc-cms-control-160" name="'.$prename.'-code-lang">';
                            $out .= '<option value="code" '.$this->attrSelected($cell->code['lang'] == 'code').'>Generic code</option>';
                            $out .= '<option value="php" '.$this->attrSelected($cell->code['lang'] == 'php').'>PHP</option>';
                            $out .= '<option value="css" '.$this->attrSelected($cell->code['lang'] == 'css').'>CSS</option>';
                            $out .= '<option value="html" '.$this->attrSelected($cell->code['lang'] == 'html').'>HTML</option>';
                        $out .= '</select>'; 
                        
                        $out .= '<span class="dc-cms-control-top-label">Code</span>'; 
                        $out .= '<textarea class="dc-cms-control-wide dc-cms-control-h-600 dc-cms-control-monospace-textarea" name="'.$prename.'-code-content" >'.$cell->code['content'].'</textarea>';                                   
             
                        $out .= '<span class="dc-cms-control-top-label">Title for code description (optional)</span>';             
                        $out .= '<textarea class="dc-cms-control-wide dc-cms-control-h-40 dc-cms-control-textarea" name="'.$prename.'-code-title" >'.$cell->code['title'].'</textarea>';  

                        $out .= '<span class="dc-cms-control-top-label">Description text (optional)</span>';             
                        $out .= '<textarea class="dc-cms-control-wide dc-cms-control-h-80 dc-cms-control-textarea" name="'.$prename.'-code-desc" >'.$cell->code['desc'].'</textarea>';                                                             
             
                        $out .= '<span class="dc-cms-control-top-label">Other settings</span>';               
                        $out .= $this->getStdInputsFieldStart();
                            $out .= '<input type="checkbox" '.$this->attrChecked($cell->code['minimized']).' name="'.$prename.'-code-minimized" /> Display as minimized on page load';
                            $out .= $this->getBR();
                            $out .= '<input type="checkbox" '.$this->attrChecked($cell->code['stripes']).' name="'.$prename.'-code-stripes" /> Display colored stripes'; 
                            $out .= $this->getBR();
                            $out .= '<input type="checkbox" '.$this->attrChecked($cell->code['title_use']).' name="'.$prename.'-code-title_use" /> Display description title '; 
                            $out .= $this->getBR();
                            $out .= '<input type="checkbox" '.$this->attrChecked($cell->code['desc_use']).' name="'.$prename.'-code-desc_use" /> Display description text';                             
                        $out .= $this->getStdInputsFieldEnd();                 
             
                    $out .= '</div>'; /* inner-opt-wrapper */
                $out .= '</div>';  
             } break;      
                       
             case 'board-slider':
             {
                $out .= '<div class="segment-options">';  
                                                                                            
                    $out .= $std;                                             
                    $out .= $cmn;
                    $out .= $empty_space;
                    $out .= '<div class="inner-opt-wrapper">';    
                   
                        $categories = GetDCCPI()->getICache()->get_terms_by_post_type(array('category'), array('post')); 
                        
                        if(!is_array($cell->board_slider['cats_post'])) { $cell->board_slider['cats_post'] = array(); }
                        $out .= '<span class="dc-cms-control-top-label-nomargin">Post categories to display</span>';                      
                        $out .= $this->getStdScrollBoxStart(array('height' => 100, 'width' => 300));
                            foreach($categories as $cat)
                            {
                                $checked = false;
                                if(in_array($cat->term_id, $cell->board_slider['cats_post'])) { $checked = true; }
                                $out .= '<input type="checkbox" value="'.$cat->term_id.'" name="'.$prename.'-board_slider-cats_post[]" '.($checked ? ' checked="checked" ' : '').'> '.$cat->name. '<br />';
                            }
                        $out .= $this->getStdScrollBoxEnd();
                        $out .= '<div class="dc-cms-help-note-box">';
                            $out .= 'If no category is selected slider is trying to displays posts from all post categories.';
                        $out .= '</div>';
                
                    
                        $categories = GetDCCPI()->getICache()->get_terms_by_post_type(array('category_page'), array('page')); 
                        
                        if(!is_array($cell->board_slider['cats_page'])) { $cell->board_slider['cats_page'] = array(); }
                        $out .= '<span class="dc-cms-control-top-label">Page categories to display</span>';                      
                        $out .= $this->getStdScrollBoxStart(array('height' => 100, 'width' => 300));
                            foreach($categories as $cat)
                            {
                                $checked = false;
                                if(in_array($cat->term_id, $cell->board_slider['cats_page'])) { $checked = true; }
                                $out .= '<input type="checkbox" value="'.$cat->term_id.'" name="'.$prename.'-board_slider-cats_page[]" '.($checked ? ' checked="checked" ' : '').'> '.$cat->name. '<br />';
                            }
                        $out .= $this->getStdScrollBoxEnd();
                        $out .= '<div class="dc-cms-help-note-box">';
                            $out .= 'If no category is selected slider is trying to displays pages from all page categories.';
                        $out .= '</div>';                       
                   
                        $out .= '<span class="dc-cms-control-top-label">Comma separated post and pages ID list (if set, selected categories are ignored)</span>'; 
                        $out .= '<input type="text" class="dc-cms-control-wide" name="'.$prename.'-board_slider-list" value="'.$cell->board_slider['list'].'" />';  
                   
                        $out .= '<span class="dc-cms-control-top-label">Number of displayed cell lines on one page (one line is equal to four cells)</span>'; 
                        $out .= '<select class="dc-cms-control-60" name="'.$prename.'-board_slider-lines_count">';
                            $val = $cell->board_slider['lines_count'];
                            $out .= '<option value="1" '.$this->attrSelected($val == 1).'>1</option>';
                            $out .= '<option value="2" '.$this->attrSelected($val == 2).'>2</option>'; 
                            $out .= '<option value="3" '.$this->attrSelected($val == 3).'>3</option>'; 
                            $out .= '<option value="4" '.$this->attrSelected($val == 4).'>4</option>';
                            $out .= '<option value="5" '.$this->attrSelected($val == 5).'>5</option>';
                            $out .= '<option value="6" '.$this->attrSelected($val == 6).'>6</option>'; 
                        $out .= '</select>';   
                        
                        $out .= '<span class="dc-cms-control-top-label">Number of displayed cell pages</span>';
                        $out .= $this->getCtrlInputInt($prename.'-board_slider-pages_count', $cell->board_slider['pages_count'], 1, 10);                                          
                   
                        $out .= '<span class="dc-cms-control-top-label">Autoplay</span>'; 
                        $out .= $this->getStdInputsFieldStart(); 
                            $out .= '<input type="checkbox" name="'.$prename.'-board_slider-autoplay" '.$this->attrChecked($cell->board_slider['autoplay']).' /> Autoplay'; 
                        $out .= $this->getStdInputsFieldEnd();             
                
                        $out .= '<span class="dc-cms-control-top-label">Autoplay time</span>';
                        $out .= $this->getCtrlInputInt($prename.'-board_slider-autoplay_time', $cell->board_slider['autoplay_time'], 1, 128);                     
                   
                        $out .= '<span class="dc-cms-control-top-label">Color mode</span>'; 
                        $out .= $this->getStdInputsFieldStart(); 
                            $out .= '<input type="radio" name="'.$prename.'-board_slider-mode" value="normal" '.$this->attrChecked($cell->board_slider['mode'] == 'normal').' /> Cells are displayed in color. On hover action the hovered cell is colored and the rest displayed in grayscale'; 
                            $out .= $this->getBR();
                            $out .= '<input type="radio" name="'.$prename.'-board_slider-mode" value="full-gray" '.$this->attrChecked($cell->board_slider['mode'] == 'full-gray').' /> Cells are displayed in grayscale. On hover action the hovered cell is highlighted without color';
                            $out .= $this->getBR();
                            $out .= '<input type="radio" name="'.$prename.'-board_slider-mode" value="full-gray-hover-color" '.$this->attrChecked($cell->board_slider['mode'] == 'full-gray-hover-color').' /> Cells are displayed in grayscale. On hover action the hovered cell is displayed in color';                         
                        $out .= $this->getStdInputsFieldEnd();                   
                   
                        $out .= '<span class="dc-cms-control-top-label">Type of displayed posts</span>';
                        $out .= $this->getStdInputsFieldStart();
                            $out .= '<input type="checkbox" name="'.$prename.'-board_slider-in_posts" '.$this->attrChecked($cell->board_slider['in_posts']).' /> Display posts'; 
                            $out .= $this->getBR(); 
                            $out .= '<input type="checkbox" name="'.$prename.'-board_slider-in_pages"  '.$this->attrChecked($cell->board_slider['in_pages']).' /> Display pages'; 
                        $out .= $this->getStdInputsFieldEnd();
                    
                        $out .= '<span class="dc-cms-control-top-label">Title and excerpt</span>'; 
                        $out .= $this->getStdInputsFieldStart(); 
                            $out .= '<input type="checkbox" name="'.$prename.'-board_slider-title" '.$this->attrChecked($cell->board_slider['title']).' /> Display title'; 
                            $out .= $this->getBR(); 
                            $out .= '<input type="checkbox" name="'.$prename.'-board_slider-excerpt" '.$this->attrChecked($cell->board_slider['excerpt']).' /> Display excerpt';                     
                            $out .= $this->getBR(); 
                            $out .= '<input type="checkbox" name="'.$prename.'-board_slider-desc_bottom" '.$this->attrChecked($cell->board_slider['desc_bottom']).' /> Display description on cell bottom';
                        $out .= $this->getStdInputsFieldEnd();                   

                        $out .= '<span class="dc-cms-control-top-label">Description actions</span>'; 
                        $out .= '<div class="dc-cms-excludable-checkbox-field-nomargin">'; 
                            $out .= '<input type="checkbox" name="'.$prename.'-board_slider-desc_hide_on_hover" '.$this->attrChecked($cell->board_slider['desc_hide_on_hover']).' /> Hide description on cell hover';    
                            $out .= $this->getBR(); 
                            $out .= '<input type="checkbox" name="'.$prename.'-board_slider-desc_show_on_hover" '.$this->attrChecked($cell->board_slider['desc_show_on_hover']).' /> Show description on cell hover'; 
                        $out .= '</div>';   
                   
                        $out .= '<span class="dc-cms-control-top-label">Excerpt length in words</span>';
                        $out .= $this->getCtrlInputInt($prename.'-board_slider-excerpt_words_count', $cell->board_slider['excerpt_words_count'], 1, 128);   
                   
                    
                        $out .= '<span class="dc-cms-control-top-label">Posts/pages order</span>';
                        $out .= $this->getStdInputsFieldStart();
                            $out .= '<input type="radio" name="'.$prename.'-board_slider-order" value="DESC" '.$this->attrChecked($cell->board_slider['order'] == 'DESC').' /> Descending';
                            $out .= $this->getBR();
                            $out .= '<input type="radio" name="'.$prename.'-board_slider-order" value="ASC" '.$this->attrChecked($cell->board_slider['order'] == 'ASC').' /> Ascending';
                        $out .= $this->getStdInputsFieldEnd();                     
                   
                        $out .= '<span class="dc-cms-control-top-label">Sort displayed posts/pages by parameter</span>';  
                        $out .= $this->getStdInputsFieldStart(); 
                            $out .= '<input type="radio" name="'.$prename.'-board_slider-orderby" value="date" '.$this->attrChecked($cell->board_slider['orderby'] == 'date').' /> Order by date';
                            $out .= $this->getBR();
                            $out .= '<input type="radio" name="'.$prename.'-board_slider-orderby" value="modified" '.$this->attrChecked($cell->board_slider['orderby'] == 'modified').' /> Order by last modified date';
                            $out .= $this->getBR();
                            $out .= '<input type="radio" name="'.$prename.'-board_slider-orderby" value="title" '.$this->attrChecked($cell->board_slider['orderby'] == 'title').' /> Order by title';
                            $out .= $this->getBR();                
                            $out .= '<input type="radio" name="'.$prename.'-board_slider-orderby" value="rand" '.$this->attrChecked($cell->board_slider['orderby'] == 'rand').' /> Random order';
                            $out .= $this->getBR();  
                            $out .= '<input type="radio" name="'.$prename.'-board_slider-orderby" value="comment_count" '.$this->attrChecked($cell->board_slider['orderby'] == 'comment_count').' /> Order by number of comments';                        
                        $out .= $this->getStdInputsFieldEnd();                    
                   
                        $out .= '<span class="dc-cms-control-top-label">Other settings</span>';  
                        $out .= $this->getStdInputsFieldStart();
                            $out .= '<input type="checkbox" name="'.$prename.'-board_slider-show_hidden_post_img" '.$this->attrChecked($cell->board_slider['show_hidden_post_img']).' /> Display hidden post image';                          
                        $out .= $this->getStdInputsFieldEnd();                   
                   
                        
                   
                   
                    $out .= '</div>'; /* inner-opt-wrapper */
                $out .= '</div>';  
             } break;    
             
             case 'anno-box':
             {
                $out .= '<div class="segment-options">';  
                                                                                            
                    $out .= $std;                                             
                    $out .= $cmn;
                    $out .= $empty_space;
                    $out .= '<div class="inner-opt-wrapper">';  
                    
                        $out .= '<span class="dc-cms-control-top-label-nomargin">Title</span>';  
                        $out .= '<textarea name="segment-cell-data-'.$cell->core['id'].'-anno_box-title" class="dc-cms-control-textarea dc-cms-control-h-40 dc-cms-control-wide">'.$cell->anno_box['title'].'</textarea>';

                        $out .= '<span class="dc-cms-control-top-label">Subtitle</span>';  
                        $out .= '<textarea name="segment-cell-data-'.$cell->core['id'].'-anno_box-subtitle" class="dc-cms-control-textarea dc-cms-control-h-40 dc-cms-control-wide">'.$cell->anno_box['subtitle'].'</textarea>';
                                               
                        $out .= '<span class="dc-cms-control-top-label">Text</span>';  
                        $out .= '<textarea name="segment-cell-data-'.$cell->core['id'].'-anno_box-text" class="dc-cms-control-textarea dc-cms-control-h-120 dc-cms-control-wide">'.$cell->anno_box['text'].'</textarea>';
                    
                        $out .= '<span class="dc-cms-control-top-label">Other settings</span>';  
                        $out .= $this->getStdInputsFieldStart();
                            $out .= '<input type="checkbox" name="segment-cell-data-'.$cell->core['id'].'-anno_box-title_use" '.$this->attrChecked($cell->anno_box['title_use']).' /> Display title';
                            $out .= $this->getBR();
                            $out .= '<input type="checkbox" name="segment-cell-data-'.$cell->core['id'].'-anno_box-subtitle_use" '.$this->attrChecked($cell->anno_box['subtitle_use']).' /> Display subtitle';
                            $out .= $this->getBR();
                            $out .= '<input type="checkbox" name="segment-cell-data-'.$cell->core['id'].'-anno_box-text_use" '.$this->attrChecked($cell->anno_box['text_use']).' /> Display text';                            
                        $out .= $this->getStdInputsFieldEnd();                 
                    
                        $out .= '<span class="dc-cms-control-top-label">Title size</span>';  
                        $out .= '<select name="segment-cell-data-'.$cell->core['id'].'-anno_box-title_size" class="dc-cms-control-100">';
                            $out .= '<option value="1" '.$this->attrSelected($cell->anno_box['title_size'] == 1).'>H1</option>';
                            $out .= '<option value="2" '.$this->attrSelected($cell->anno_box['title_size'] == 2).'>H2</option>';
                            $out .= '<option value="3" '.$this->attrSelected($cell->anno_box['title_size'] == 3).'>H3</option>';
                            $out .= '<option value="4" '.$this->attrSelected($cell->anno_box['title_size'] == 4).'>H4</option>';
                            $out .= '<option value="5" '.$this->attrSelected($cell->anno_box['title_size'] == 5).'>H5</option>';
                            $out .= '<option value="6" '.$this->attrSelected($cell->anno_box['title_size'] == 6).'>H6</option>';
                        $out .= '</select>';
                        
                        $out .= '<span class="dc-cms-control-top-label">Text font size</span>'; 
                        $out .= $this->getCtrlInputInt('segment-cell-data-'.$cell->core['id'].'-anno_box-text_fsize', $cell->anno_box['text_fsize'], 1, 256);                      

                        $out .= '<span class="dc-cms-control-top-label">Text line height</span>'; 
                        $out .= $this->getCtrlInputInt('segment-cell-data-'.$cell->core['id'].'-anno_box-text_lheight', $cell->anno_box['text_lheight'], 1, 256); 
                                            
                    
                        $out .= $this->getStdInputsFieldStart(array('mtop-type' => 'normal')); 
                            $out .= '<input type="checkbox" name="segment-cell-data-'.$cell->core['id'].'-anno_box-text_font_sizes_use" '.$this->attrChecked($cell->anno_box['text_font_sizes_use']).' /> Use text font size and line height settings';
                        $out .= $this->getStdInputsFieldEnd(); 

                        $out .= '<span class="dc-cms-control-top-label">Text align (applies to the entire segment)</span>';  
                        $out .= '<select name="segment-cell-data-'.$cell->core['id'].'-anno_box-align" class="dc-cms-control-100">';
                            $out .= '<option value="left" '.$this->attrSelected($cell->anno_box['align'] == 'left').'>Left</option>';
                            $out .= '<option value="center" '.$this->attrSelected($cell->anno_box['align'] == 'center').'>Center</option>';
                            $out .= '<option value="right" '.$this->attrSelected($cell->anno_box['align'] == 'right').'>Right</option>';
                        $out .= '</select>';
                    
                        $out .= '<span class="dc-cms-control-top-label">Button text color</span>'; 
                        $out .= '<input type="text" class="dc-color-picker" value="'.$cell->anno_box['btn_color'].'" name="segment-cell-data-'.$cell->core['id'].'-anno_box-btn_color" /> ';                      

                        $out .= '<span class="dc-cms-control-top-label">Button text hover color</span>'; 
                        $out .= '<input type="text" class="dc-color-picker" value="'.$cell->anno_box['btn_hcolor'].'" name="segment-cell-data-'.$cell->core['id'].'-anno_box-btn_hcolor" /> ';                      
                    
                        $out .= '<span class="dc-cms-control-top-label">Button background color</span>'; 
                        $out .= '<input type="text" class="dc-color-picker" value="'.$cell->anno_box['btn_bgcolor'].'" name="segment-cell-data-'.$cell->core['id'].'-anno_box-btn_bgcolor" /> ';                      
                    
                        $out .= '<span class="dc-cms-control-top-label">Button background hover color</span>'; 
                        $out .= '<input type="text" class="dc-color-picker" value="'.$cell->anno_box['btn_bghcolor'].'" name="segment-cell-data-'.$cell->core['id'].'-anno_box-btn_bghcolor" /> ';                      
                                                            
                    
                        $out .= $this->getClearBoth(10);
                    
                        // btn A
                        $out .= $this->getStdColumnStart(array('width' => 360, 'mright' => 40));
                            
                            $out .= $this->getFreeSectionHead(array('label' => 'Button A', 'bottom' => 0));
                            $out .= $this->getFreeGrayBoxStart(array('bwidth' => 3, 'bcolor' => '#D8D8D8', 'bt_on' => false));
                                $out .= '<span class="dc-cms-control-top-label-nomargin">Name</span>';   
                                $out .= '<input type="text" class="dc-cms-control-wide" name="segment-cell-data-'.$cell->core['id'].'-anno_box-btn_a_name" value="'.$cell->anno_box['btn_a_name'].'" />'; 

                                $out .= '<span class="dc-cms-control-top-label">Destination URL link</span>';   
                                $out .= '<input type="text" class="dc-cms-control-wide" name="segment-cell-data-'.$cell->core['id'].'-anno_box-btn_a_link" value="'.$cell->anno_box['btn_a_link'].'" />';                      
                                
                                $out .= '<span class="dc-cms-control-top-label">Other settings</span>';  
                                $out .= $this->getStdInputsFieldStart();
                                    $out .= '<input type="checkbox" name="segment-cell-data-'.$cell->core['id'].'-anno_box-btn_a_display" '.$this->attrChecked($cell->anno_box['btn_a_display']).' /> Display';
                                    $out .= $this->getBR();
                                    $out .= '<input type="checkbox" name="segment-cell-data-'.$cell->core['id'].'-anno_box-btn_a_blank" '.$this->attrChecked($cell->anno_box['btn_a_blank']).' /> Open link in new window/tab';                            
                                $out .= $this->getStdInputsFieldEnd();
                            $out .= $this->getFreeGrayBoxEnd();                               
                        $out .= $this->getStdColumnEnd();

                        // btn B
                        $out .= $this->getStdColumnStart(array('width' => 360, 'mright' => 40));
                        
                            $out .= $this->getFreeSectionHead(array('label' => 'Button B', 'bottom' => 0));
                            $out .= $this->getFreeGrayBoxStart(array('bwidth' => 3, 'bcolor' => '#D8D8D8', 'bt_on' => false));    
                                $out .= '<span class="dc-cms-control-top-label-nomargin">Name</span>';   
                                $out .= '<input type="text" class="dc-cms-control-wide" name="segment-cell-data-'.$cell->core['id'].'-anno_box-btn_b_name" value="'.$cell->anno_box['btn_b_name'].'" />'; 

                                $out .= '<span class="dc-cms-control-top-label">Destination URL link</span>';   
                                $out .= '<input type="text" class="dc-cms-control-wide" name="segment-cell-data-'.$cell->core['id'].'-anno_box-btn_b_link" value="'.$cell->anno_box['btn_b_link'].'" />';                      
                                
                                $out .= '<span class="dc-cms-control-top-label">Other settings</span>';  
                                $out .= $this->getStdInputsFieldStart();
                                    $out .= '<input type="checkbox" name="segment-cell-data-'.$cell->core['id'].'-anno_box-btn_b_display" '.$this->attrChecked($cell->anno_box['btn_b_display']).' /> Display';
                                    $out .= $this->getBR();
                                    $out .= '<input type="checkbox" name="segment-cell-data-'.$cell->core['id'].'-anno_box-btn_b_blank" '.$this->attrChecked($cell->anno_box['btn_b_blank']).' /> Open link in new window/tab';                            
                                $out .= $this->getStdInputsFieldEnd();
                            $out .= $this->getFreeGrayBoxEnd();                                
                        
                        $out .= $this->getStdColumnEnd();

                        // btn C
                        $out .= $this->getStdColumnStart(array('width' => 360, 'mright' => 0));
                        
                            $out .= $this->getFreeSectionHead(array('label' => 'Button C', 'bottom' => 0)); 
                            $out .= $this->getFreeGrayBoxStart(array('bwidth' => 3, 'bcolor' => '#D8D8D8', 'bt_on' => false)); 
                                $out .= '<span class="dc-cms-control-top-label-nomargin">Name</span>';   
                                $out .= '<input type="text" class="dc-cms-control-wide" name="segment-cell-data-'.$cell->core['id'].'-anno_box-btn_c_name" value="'.$cell->anno_box['btn_c_name'].'" />'; 

                                $out .= '<span class="dc-cms-control-top-label">Destination URL link</span>';   
                                $out .= '<input type="text" class="dc-cms-control-wide" name="segment-cell-data-'.$cell->core['id'].'-anno_box-btn_c_link" value="'.$cell->anno_box['btn_c_link'].'" />';                      
                                
                                $out .= '<span class="dc-cms-control-top-label">Other settings</span>';  
                                $out .= $this->getStdInputsFieldStart();
                                    $out .= '<input type="checkbox" name="segment-cell-data-'.$cell->core['id'].'-anno_box-btn_c_display" '.$this->attrChecked($cell->anno_box['btn_c_display']).' /> Display';
                                    $out .= $this->getBR();
                                    $out .= '<input type="checkbox" name="segment-cell-data-'.$cell->core['id'].'-anno_box-btn_c_blank" '.$this->attrChecked($cell->anno_box['btn_c_blank']).' /> Open link in new window/tab';                            
                                $out .= $this->getStdInputsFieldEnd();
                            $out .= $this->getFreeGrayBoxEnd(); 
                                                            
                        $out .= $this->getStdColumnEnd();
                        
                        $out .= $this->getClearBoth(20);                  
                    $out .= '</div>'; /* inner-opt-wrapper */
                $out .= '</div>';  
                                                    
             } break;  
             
             case 'ngg-recent-slider':
             {
                $out .= '<div class="segment-options">';  
                                                                                            
                    $out .= $std;                                             
                    $out .= $cmn;
                    $out .= $empty_space;
                    $out .= '<div class="inner-opt-wrapper">';                                           

                        $out .= '<span class="dc-cms-control-top-label-nomargin">Select NextGen Gallery to display</span>';  
                        $args = array(
                            'current' => $cell->ngg_recent_slider['id'],
                            'name' => 'segment-cell-data-'.$cell->core['id'].'-ngg_recent_slider-id',
                            'w' => 300
                        );
                        $out .= self::selectCtrlNGGList($args);  
                        
                        $out .= '<div class="dc-cms-help-note-box">';
                            $out .= 'If not selected, images from whole NextGEN Gallery will be displayed.';
                        $out .= '</div>';

                        $out .= '<span class="dc-cms-control-top-label">Number of displayed pages</span>';
                        $out .= $this->getCtrlInputInt('segment-cell-data-'.$cell->core['id'].'-ngg_recent_slider-pages', $cell->ngg_recent_slider['pages'], 1, 32);                           
                        
                        $out .= '<span class="dc-cms-control-top-label">Images per page</span>';  
                        $out .= '<select name="segment-cell-data-'.$cell->core['id'].'-ngg_recent_slider-perpage" class="dc-cms-control-120">';
                            $out .= '<option value="1" '.$this->attrSelected($cell->ngg_recent_slider['perpage'] == 1).'>1</option>';
                            $out .= '<option value="2" '.$this->attrSelected($cell->ngg_recent_slider['perpage'] == 2).'>2</option>';
                            $out .= '<option value="3" '.$this->attrSelected($cell->ngg_recent_slider['perpage'] == 3).'>3</option>';
                            $out .= '<option value="4" '.$this->attrSelected($cell->ngg_recent_slider['perpage'] == 4).'>4</option>';
                            $out .= '<option value="5" '.$this->attrSelected($cell->ngg_recent_slider['perpage'] == 5).'>5</option>';
                        $out .= '</select>';                        

                        $out .= '<span class="dc-cms-control-top-label">Order images by</span>';  
                        $out .= '<select name="segment-cell-data-'.$cell->core['id'].'-ngg_recent_slider-orderby" class="dc-cms-control-120">';
                            $out .= '<option value="date" '.$this->attrSelected($cell->ngg_recent_slider['orderby'] == 'date').'>Date</option>'; 
                            $out .= '<option value="sort" '.$this->attrSelected($cell->ngg_recent_slider['orderby'] == 'sort').'>User sort order</option>'; 
                            $out .= '<option value="pid" '.$this->attrSelected($cell->ngg_recent_slider['orderby'] == 'pid').'>Image ID</option>'; 
                        $out .= '</select>';
                        
                        $out .= '<span class="dc-cms-control-top-label">Viewport width</span>';
                        $out .= $this->getCtrlInputInt('segment-cell-data-'.$cell->core['id'].'-ngg_recent_slider-viewport_w', $cell->ngg_recent_slider['viewport_w'], 1, 1920);                            

                        $out .= '<span class="dc-cms-control-top-label">Viewport height</span>';
                        $out .= $this->getCtrlInputInt('segment-cell-data-'.$cell->core['id'].'-ngg_recent_slider-viewport_h', $cell->ngg_recent_slider['viewport_h'], 1, 1920);
                        
                        $out .= '<span class="dc-cms-control-top-label">Optional slider description</span>';  
                        $out .= '<textarea name="segment-cell-data-'.$cell->core['id'].'-ngg_recent_slider-desc" class="dc-cms-control-textarea dc-cms-control-h-80 dc-cms-control-wide">'.$cell->ngg_recent_slider['desc'].'</textarea>';

                        $out .= '<span class="dc-cms-control-top-label">Other settings</span>'; 
                        $out .= $this->getStdInputsFieldStart();
                            $out .= '<input type="checkbox" name="segment-cell-data-'.$cell->core['id'].'-ngg_recent_slider-alttext" '.$this->attrChecked($cell->ngg_recent_slider['alttext']).' /> Display images titles in lightbox';
                            $out .= $this->getBR();
                            $out .= '<input type="checkbox" name="segment-cell-data-'.$cell->core['id'].'-ngg_recent_slider-grayscale" '.$this->attrChecked($cell->ngg_recent_slider['grayscale']).' /> Display images in grayscale';                            
                            $out .= $this->getBR();
                            $out .= '<input type="checkbox" name="segment-cell-data-'.$cell->core['id'].'-ngg_recent_slider-desc_use" '.$this->attrChecked($cell->ngg_recent_slider['desc_use']).' /> Display slider description';  
                        $out .= $this->getStdInputsFieldEnd();
                 
                    $out .= '</div>'; /* inner-opt-wrapper */
                $out .= '</div>';                   
             } break;  
             
             case 'recent-posts-list':
             {
                $out .= '<div class="segment-options">';                   
                                                                                            
                    $out .= $std;                                             
                    $out .= $cmn;
                    $out .= $empty_space;
                    $out .= '<div class="inner-opt-wrapper">';                                                     

                        $categories = get_terms('category', array('orderby' => 'name', 'hide_empty' => false)); 
                        
                        if(!is_array($cell->recent_posts_list['cats'])) { $cell->recent_posts_list['cats'] = array(); }
                        $out .= '<span class="dc-cms-control-top-label-nomargin">Post categories to display</span>';                      
                        $out .= $this->getStdScrollBoxStart(array('height' => 100, 'width' => 300));
                            foreach($categories as $cat)
                            {
                                $checked = false;
                                if(in_array($cat->term_id, $cell->recent_posts_list['cats'])) { $checked = true; }
                                $out .= '<input type="checkbox" value="'.$cat->term_id.'" name="'.$prename.'-recent_posts_list-cats[]" '.($checked ? ' checked="checked" ' : '').'> '.$cat->name . ' <span class="term-count">('.$cat->count.')</span><br />';
                            }
                        $out .= $this->getStdScrollBoxEnd();
                        
                        $out .= '<div class="dc-cms-help-note-box">';
                            $out .= 'If no category is selected, segment is trying to display posts from all categories.';
                        $out .= '</div>';                     
                        
                        $out .= '<span class="dc-cms-control-top-label">Comma separated posts ID list (if set, selected categories are ignored)</span>';   
                        $out .= '<input type="text" class="dc-cms-control-wide" name="'.$prename.'-recent_posts_list-list" value="'.$cell->recent_posts_list['list'].'" />';                                                                                                          
                        
                        $out .= '<span class="dc-cms-control-top-label">Display layout</span>';   
                        $out .= '<select name="'.$prename.'-recent_posts_list-layout" class="dc-cms-control-100">';
                            $val = $cell->recent_posts_list['layout'];
                            $out .= '<option value="box" '.$this->attrSelected($val == 'box').'>Box</option>';
                            $out .= '<option value="classic" '.$this->attrSelected($val == 'classic').'>Classic</option>';
                        $out .= '<select>';
                        
                         $out .= '<span class="dc-cms-control-top-label">Select number of displayed columns (only box layout)</span>'; 
                        $out .= '<select name="'.$prename.'-recent_posts_list-columns" class="dc-cms-control-100">';
                            $val = $cell->recent_posts_list['columns']; 
                            $out .= '<option value="1" '.$this->attrSelected($val == 1).'>1</option>';
                            $out .= '<option value="2" '.$this->attrSelected($val == 2).'>2</option>';
                            $out .= '<option value="3" '.$this->attrSelected($val == 3).'>3</option>';
                            $out .= '<option value="4" '.$this->attrSelected($val == 4).'>4</option>';
                        $out .= '</select>';  
                        
                        $out .= '<span class="dc-cms-control-top-label">Number of displayed posts (works as posts per page if pagination is enabled)</span>'; 
                        $out .= $this->getCtrlInputInt($prename.'-recent_posts_list-count', $cell->recent_posts_list['count'], 1);                            
                    
                        $out .= '<span class="dc-cms-control-top-label">Posts order</span>';
                        $out .= '<input type="radio" name="'.$prename.'-recent_posts_list-order" value="DESC" '.$this->attrChecked($cell->recent_posts_list['order'] == 'DESC').' /> Descending';
                        $out .= $this->getBR();
                        $out .= '<input type="radio" name="'.$prename.'-recent_posts_list-order" value="ASC" '.$this->attrChecked($cell->recent_posts_list['order'] == 'ASC').' /> Ascending';
                        $out .= $this->getBR();   
                
                        $out .= '<span class="dc-cms-control-top-label">Sort displayed posts by parameter</span>';  
                        $out .= '<input type="radio" name="'.$prename.'-recent_posts_list-orderby" value="date" '.$this->attrChecked($cell->recent_posts_list['orderby'] == 'date').' /> Order by date';
                        $out .= $this->getBR();
                        $out .= '<input type="radio" name="'.$prename.'-recent_posts_list-orderby" value="title" '.$this->attrChecked($cell->recent_posts_list['orderby'] == 'title').' /> Order by title';
                        $out .= $this->getBR();                
                        $out .= '<input type="radio" name="'.$prename.'-recent_posts_list-orderby" value="comment_count" '.$this->attrChecked($cell->recent_posts_list['orderby'] == 'comment_count').' /> Comments count';                     
                   
                        $out .= '<span class="dc-cms-control-top-label">Number of words displayed in excerpt</span>'; 
                        $out .= $this->getCtrlInputInt($prename.'-recent_posts_list-words', $cell->recent_posts_list['words'], 1);      
                        
                        $out .= '<span class="dc-cms-control-top-label">Viewport width</span>'; 
                        $out .= $this->getCtrlInputInt($prename.'-recent_posts_list-viewport_w', $cell->recent_posts_list['viewport_w'], 1);                             

                        $out .= '<span class="dc-cms-control-top-label">Viewport height</span>'; 
                        $out .= $this->getCtrlInputInt($prename.'-recent_posts_list-viewport_h', $cell->recent_posts_list['viewport_h'], 1);                            
                        
                        $out .= '<span class="dc-cms-control-top-label">Items bottom margin</span>'; 
                        $out .= $this->getCtrlInputInt($prename.'-recent_posts_list-item_bottom', $cell->recent_posts_list['item_bottom'], 0);                               
                        
                        $out .= '<span class="dc-cms-control-top-label">Other settings</span>';                             
                        $out .= $this->getStdInputsFieldStart();
                            $out .= '<input type="checkbox" name="'.$prename.'-recent_posts_list-pagination" '.$this->attrChecked($cell->recent_posts_list['pagination']).' /> Display pagination'.$this->getBookHelp(array('text' => 'NOTE: Recommended to use only when one segment with pagination (or of the same type) is palced on page - pagination affects all segments displayed on page.')); 
                            $out .= $this->getBR();
                            $out .= '<input type="checkbox" name="'.$prename.'-recent_posts_list-grayscale" '.$this->attrChecked($cell->recent_posts_list['grayscale']).' /> Display post thumb in grayscale';
                            $out .= $this->getBR();
                            $out .= '<input type="checkbox" name="'.$prename.'-recent_posts_list-excerpt_use" '.$this->attrChecked($cell->recent_posts_list['excerpt_use']).' /> Display post excerpt';
                            $out .= $this->getBR();
                            $out .= '<input type="checkbox" name="'.$prename.'-recent_posts_list-elapsed_time" '.$this->attrChecked($cell->recent_posts_list['elapsed_time']).' /> Calculate time that has elapsed from the date of publication';                                                                        
                            $out .= $this->getBR();
                            $out .= '<input type="checkbox" name="'.$prename.'-recent_posts_list-item_bottom_use" '.$this->attrChecked($cell->recent_posts_list['item_bottom_use']).' /> Use items margin bottom settings';
                            $out .= $this->getBR();
                            $out .= '<input type="checkbox" name="'.$prename.'-recent_posts_list-viewport_use" '.$this->attrChecked($cell->recent_posts_list['viewport_use']).' /> Use viewport';
                            $out .= $this->getBR();
                            $out .= '<input type="checkbox" name="'.$prename.'-recent_posts_list-title_display" '.$this->attrChecked($cell->recent_posts_list['title_display']).' /> Display post title';
                            $out .= $this->getBR();
                            $out .= '<input type="checkbox" name="'.$prename.'-recent_posts_list-date_display" '.$this->attrChecked($cell->recent_posts_list['date_display']).' /> Display post date';
                            $out .= $this->getBR();
                            $out .= '<input type="checkbox" name="'.$prename.'-recent_posts_list-excerpt_display" '.$this->attrChecked($cell->recent_posts_list['excerpt_display']).' /> Display post excerpt';                                                        
                        $out .= $this->getStdInputsFieldEnd();                                                                   
                                       
                    $out .= '</div>'; /* inner-opt-wrapper */
                $out .= '</div>';                   
             } break;  
             
             case 'download':
             {
                $out .= '<div class="segment-options">';                   
                                                                                            
                    $out .= $std;                                             
                    $out .= $cmn;
                    $out .= $empty_space;
                    $out .= '<div class="inner-opt-wrapper">';    

                        $out .= '<span class="dc-cms-control-top-label-nomargin">Optional title</span>';   
                        $out .= '<textarea name="'.$prename.'-download-title" class="dc-cms-control-textarea dc-cms-control-h-40 dc-cms-control-wide">'.$cell->download['title'].'</textarea>';

                        $out .= '<span class="dc-cms-control-top-label">Title size</span>'; 
                        $out .= '<select name="'.$prename.'-download-title_size" class="dc-cms-control-100">';
                            for($i = 1; $i <= 6; $i++)
                            {
                                $out .= '<option value="'.$i.'" '.$this->attrSelected($cell->download['title_size'] == $i).'>'.$i.'</option>';
                            }
                        $out .= '</select>';

                        $out .= '<span class="dc-cms-control-top-label">Optional subtitle</span>';   
                        $out .= '<textarea name="'.$prename.'-download-subtitle" class="dc-cms-control-textarea dc-cms-control-h-40 dc-cms-control-wide">'.$cell->download['subtitle'].'</textarea>';
                        
                        $out .= '<span class="dc-cms-control-top-label">File URL for download</span>'; 
                        $out .= '<input type="text" class="dc-cms-control-wide" name="'.$prename.'-download-file_url" value="'.$cell->download['file_url'].'" />';
                        
                        $out .= '<span class="dc-cms-control-top-label">Optional description</span>';   
                        $out .= '<textarea name="'.$prename.'-download-desc" class="dc-cms-control-textarea dc-cms-control-h-80 dc-cms-control-wide">'.$cell->download['desc'].'</textarea>';

                        $out .= '<span class="dc-cms-control-top-label">File name</span>';   
                        $out .= '<textarea name="'.$prename.'-download-file_name" class="dc-cms-control-textarea dc-cms-control-h-40 dc-cms-control-wide">'.$cell->download['file_name'].'</textarea>';

                        $out .= '<span class="dc-cms-control-top-label">File size (e.g 34.6 MB - ZIP file)</span>';   
                        $out .= '<textarea name="'.$prename.'-download-file_size" class="dc-cms-control-textarea dc-cms-control-h-40 dc-cms-control-wide">'.$cell->download['file_size'].'</textarea>';                        
                    
                        $out .= '<span class="dc-cms-control-top-label">File type icon URL</span>';  
                        $out .= '<input type="text" class="dc-cms-control-wide" name="'.$prename.'-download-icon_url" value="'.$cell->download['icon_url'].'" id="dc-id-'.$prename.'-download-icon_url" />';
                        
                        $out .= $this->getImagePreviewBox(array('path' => $cell->download['icon_url'], 'width' => 240, 'height' => 120, 'margin' => '15px 0px 0px 0px', 'info' => true));
                        
                        $out .= '<div class="dc-cms-btn-frame">';
                            $out .= '<input class="dc-cms-submit-image-btn" type="button" name="dc-id-'.$prename.'-download-icon_url" value="Load image" />';
                        $out .= '</div>';                                  
                        
                        $out .= '<span class="dc-cms-control-top-label">Icon area width in pixels</span>'; 
                        $out .= $this->getCtrlInputInt($prename.'-download-icon_w', $cell->download['icon_w'], 1);                                           
                    
                        $out .= '<span class="dc-cms-control-top-label">Button position</span>'; 
                        $out .= '<select name="'.$prename.'-download-btn_pos" class="dc-cms-control-100">'; 
                            $val = $cell->download['btn_pos'];
                            $out .= '<option value="left" '.$this->attrSelected($val == 'left').'>Left</option>';
                            $out .= '<option value="center" '.$this->attrSelected($val == 'center').'>Center</option>';
                            $out .= '<option value="right" '.$this->attrSelected($val == 'right').'>Right</option>';   
                        $out .= '</select>';                     
                    
                        $out .= '<span class="dc-cms-control-top-label">Other settings</span>';                             
                        $out .= $this->getStdInputsFieldStart();
                            $out .= '<input type="checkbox" name="'.$prename.'-download-title_use" '.$this->attrChecked($cell->download['title_use']).' /> Display title';
                            $out .= $this->getBR();
                            $out .= '<input type="checkbox" name="'.$prename.'-download-desc_use" '.$this->attrChecked($cell->download['desc_use']).' /> Display description';
                            $out .= $this->getBR();
                            $out .= '<input type="checkbox" name="'.$prename.'-download-file_name_use" '.$this->attrChecked($cell->download['file_name_use']).' /> Display file name';
                            $out .= $this->getBR();
                            $out .= '<input type="checkbox" name="'.$prename.'-download-file_size_use" '.$this->attrChecked($cell->download['file_size_use']).' /> Display file size';
                            $out .= $this->getBR();
                            $out .= '<input type="checkbox" name="'.$prename.'-download-icon_use" '.$this->attrChecked($cell->download['icon_use']).' /> Display file type icon';
                            $out .= $this->getBR();
                            $out .= '<input type="checkbox" name="'.$prename.'-download-arrow_display" '.$this->attrChecked($cell->download['arrow_display']).' /> Display download arrow button';
                            
                        $out .= $this->getStdInputsFieldEnd();                                                                                                                                      
                    
                    $out .= '</div>'; /* inner-opt-wrapper */
                $out .= '</div>';
                    
             } break;  
             
             case 'member':
             {
                $out .= '<div class="segment-options">';  
                                                                                            
                    $out .= $std;                                             
                    $out .= $cmn;
                    $out .= $empty_space;
                    $out .= '<div class="inner-opt-wrapper">';                    
                            
                        $out .= '<span class="dc-cms-control-top-label-nomargin">Number of displayed members</span>'; 
                        $out .= $this->getCtrlInputInt($prename.'-member-per_page', $cell->member['per_page'], 1);                                  
                                
                        $categories = get_terms(DCC_ControlPanelCustomPosts::PT_MEMBER_CATEGORY, array('orderby' => 'name', 'hide_empty' => false)); 
                        
                        if(!is_array($cell->member['cats'])) { $cell->member['cats'] = array(); }
                        $out .= '<span class="dc-cms-control-top-label">Member categories to display</span>';                      
                        $out .= $this->getStdScrollBoxStart(array('height' => 100, 'width' => 300));
                            foreach($categories as $cat)
                            {
                                $checked = false;
                                if(in_array($cat->term_id, $cell->member['cats'])) { $checked = true; }
                                $out .= '<input type="checkbox" value="'.$cat->term_id.'" name="'.$prename.'-member-cats[]" '.($checked ? ' checked="checked" ' : '').'> '.$cat->name . ' <span class="term-count">('.$cat->count.')</span><br />';
                            }
                        $out .= $this->getStdScrollBoxEnd();
                        
                        $out .= '<div class="dc-cms-help-note-box">';
                            $out .= 'If no category is selected, segment is trying to display members from all categories.';
                        $out .= '</div>';  
                        
                        $out .= '<span class="dc-cms-control-top-label">Comma separated members ID list (if set, selected categories are ignored)</span>';   
                        $out .= '<input type="text" class="dc-cms-control-wide" name="'.$prename.'-member-list" value="'.$cell->member['list'].'" />';                                                        
                                
                        $out .= '<span class="dc-cms-control-top-label">Select number of displayed columns</span>'; 
                        $out .= '<select name="'.$prename.'-member-columns" class="dc-cms-control-60">';
                            $out .= '<option value="1" '.$this->attrSelected($cell->member['columns'] == 1).'>1</option>';
                            $out .= '<option value="2" '.$this->attrSelected($cell->member['columns'] == 2).'>2</option>';
                            $out .= '<option value="3" '.$this->attrSelected($cell->member['columns'] == 3).'>3</option>';
                            $out .= '<option value="4" '.$this->attrSelected($cell->member['columns'] == 4).'>4</option>';
                            $out .= '<option value="5" '.$this->attrSelected($cell->member['columns'] == 5).'>5</option>';      
                            $out .= '<option value="6" '.$this->attrSelected($cell->member['columns'] == 6).'>6</option>';
                        $out .= '</select>';                    
                    
                        $out .= '<span class="dc-cms-control-top-label">Number of words in excerpt</span>'; 
                        $out .= $this->getCtrlInputInt($prename.'-member-words', $cell->member['words'], 1); 

                        $out .= '<span class="dc-cms-control-top-label">Number of words in meta additional information text</span>'; 
                        $out .= $this->getCtrlInputInt($prename.'-member-addinfo_words', $cell->member['addinfo_words'], 1);                                                                                  
                                
                        $out .= '<span class="dc-cms-control-top-label">Members order</span>';
                        $out .= $this->getStdInputsFieldStart(); 
                            $out .= '<input type="radio" name="'.$prename.'-member-order" value="DESC" '.$this->attrChecked($cell->member['order'] == 'DESC').' /> Descending';
                            $out .= $this->getBR();
                            $out .= '<input type="radio" name="'.$prename.'-member-order" value="ASC" '.$this->attrChecked($cell->member['order'] == 'ASC').' /> Ascending';
                            $out .= $this->getBR();   
                        $out .= $this->getStdInputsFieldEnd(); 
                
                        $out .= '<span class="dc-cms-control-top-label">Sort displayed members by parameter</span>';  
                        $out .= $this->getStdInputsFieldStart(); 
                            $out .= '<input type="radio" name="'.$prename.'-member-orderby" value="date" '.$this->attrChecked($cell->member['orderby'] == 'date').' /> Order by date';
                            $out .= $this->getBR();
                            $out .= '<input type="radio" name="'.$prename.'-member-orderby" value="title" '.$this->attrChecked($cell->member['orderby'] == 'title').' /> Order by title';
                            $out .= $this->getBR();                
                            $out .= '<input type="radio" name="'.$prename.'-member-orderby" value="comment_count" '.$this->attrChecked($cell->member['orderby'] == 'comment_count').' /> Comments count';                     
                        $out .= $this->getStdInputsFieldEnd(); 
                        
                        $out .= '<span class="dc-cms-control-top-label">Viewport width</span>'; 
                        $out .= $this->getCtrlInputInt($prename.'-member-viewport_w', $cell->member['viewport_w'], 1);                             

                        $out .= '<span class="dc-cms-control-top-label">Viewport height</span>'; 
                        $out .= $this->getCtrlInputInt($prename.'-member-viewport_h', $cell->member['viewport_h'], 1);       

                        $out .= '<span class="dc-cms-control-top-label">Items bottom margin</span>'; 
                        $out .= $this->getCtrlInputInt($prename.'-member-item_bottom', $cell->member['item_bottom'], 0);                                                   
                                                                        
                        $out .= '<span class="dc-cms-control-top-label">Other settings</span>';                             
                        $out .= $this->getStdInputsFieldStart();
                            $out .= '<input type="checkbox" name="'.$prename.'-member-excerpt" '.$this->attrChecked($cell->member['excerpt']).' /> Display member excerpt';
                            $out .= $this->getBR();                            
                            $out .= '<input type="checkbox" name="'.$prename.'-member-pagination" '.$this->attrChecked($cell->member['pagination']).' /> Display pagination';                                                                                 
                            $out .= $this->getBR();                            
                            $out .= '<input type="checkbox" name="'.$prename.'-member-viewport_use" '.$this->attrChecked($cell->member['viewport_use']).' /> Use viewport';  
                            $out .= $this->getBR();
                            $out .= '<input type="checkbox" name="'.$prename.'-member-title_display" '.$this->attrChecked($cell->member['title_display']).' /> Display post title';                                                                                 
                            $out .= $this->getBR(); 
                            $out .= '<input type="checkbox" name="'.$prename.'-member-item_bottom_use" '.$this->attrChecked($cell->member['item_bottom_use']).' /> Use items margin bottom settings';                                                                                                                                                                      
                            $out .= $this->getBR();                            
                            $out .= '<input type="checkbox" name="'.$prename.'-member-link_to_single" '.$this->attrChecked($cell->member['link_to_single']).' /> Link items to single page';  
                            $out .= $this->getBR();                            
                            $out .= '<input type="checkbox" name="'.$prename.'-member-grayscale" '.$this->attrChecked($cell->member['grayscale']).' /> Display images in grayscale';                              
                            $out .= $this->getBR();                            
                            $out .= '<input type="checkbox" name="'.$prename.'-member-meta_title" '.$this->attrChecked($cell->member['meta_title']).' /> Display post meta title'; 
                            $out .= $this->getBR();                            
                            $out .= '<input type="checkbox" name="'.$prename.'-member-meta_subtitle" '.$this->attrChecked($cell->member['meta_subtitle']).' /> Display post meta subtitle'; 
                            $out .= $this->getBR();                            
                            $out .= '<input type="checkbox" name="'.$prename.'-member-meta_addinfo" '.$this->attrChecked($cell->member['meta_addinfo']).' /> Display post meta additional information'; 
                            $out .= $this->getBR();  
                            $out .= '<input type="checkbox" name="'.$prename.'-member-meta_twitter" '.$this->attrChecked($cell->member['meta_twitter']).' /> Display post meta Twitter link'; 
                            $out .= $this->getBR();                            
                            $out .= '<input type="checkbox" name="'.$prename.'-member-meta_facebook" '.$this->attrChecked($cell->member['meta_facebook']).' /> Display post meta Facebook link'; 
                            $out .= $this->getBR();                            
                            $out .= '<input type="checkbox" name="'.$prename.'-member-meta_website" '.$this->attrChecked($cell->member['meta_website']).' /> Display post meta personal website link';                                                                                                                 
                        $out .= $this->getStdInputsFieldEnd();                                   
                                
                    $out .= '</div>'; /* inner-opt-wrapper */
                $out .= '</div>';  
             } break;                  
             
             case 'wgt-member':
             {
                $out .= '<div class="segment-options">';  
                                                                                            
                    $out .= $std;                                             
                    $out .= $cmn;
                    $out .= $empty_space;
                    $out .= '<div class="inner-opt-wrapper">';                        
                 
                        $out .= '<span class="dc-cms-control-top-label-nomargin">Number of displayed members</span>'; 
                        $out .= $this->getCtrlInputInt($prename.'-wgt_member-per_page', $cell->wgt_member['per_page'], 1);                                  
                                
                        $categories = get_terms(DCC_ControlPanelCustomPosts::PT_MEMBER_CATEGORY, array('orderby' => 'name', 'hide_empty' => false)); 
                        
                        if(!is_array($cell->wgt_member['cats'])) { $cell->wgt_member['cats'] = array(); }
                        $out .= '<span class="dc-cms-control-top-label">Member categories to display</span>';                      
                        $out .= $this->getStdScrollBoxStart(array('height' => 100, 'width' => 300));
                            foreach($categories as $cat)
                            {
                                $checked = false;
                                if(in_array($cat->term_id, $cell->wgt_member['cats'])) { $checked = true; }
                                $out .= '<input type="checkbox" value="'.$cat->term_id.'" name="'.$prename.'-wgt_member-cats[]" '.($checked ? ' checked="checked" ' : '').'> '.$cat->name . ' <span class="term-count">('.$cat->count.')</span><br />';
                            }
                        $out .= $this->getStdScrollBoxEnd();
                        
                        $out .= '<div class="dc-cms-help-note-box">';
                            $out .= 'If no category is selected, segment is trying to display members from all categories.';
                        $out .= '</div>';  
                        
                        $out .= '<span class="dc-cms-control-top-label">Comma separated members ID list (if set, selected categories are ignored)</span>';   
                        $out .= '<input type="text" class="dc-cms-control-wide" name="'.$prename.'-wgt_member-list" value="'.$cell->wgt_member['list'].'" />';                                                        
                                
                        $out .= '<span class="dc-cms-control-top-label">Select number of displayed columns</span>'; 
                        $out .= '<select name="'.$prename.'-wgt_member-columns" class="dc-cms-control-60">';
                            $out .= '<option value="1" '.$this->attrSelected($cell->wgt_member['columns'] == 1).'>1</option>';
                            $out .= '<option value="2" '.$this->attrSelected($cell->wgt_member['columns'] == 2).'>2</option>';
                            $out .= '<option value="3" '.$this->attrSelected($cell->wgt_member['columns'] == 3).'>3</option>';
                            $out .= '<option value="4" '.$this->attrSelected($cell->wgt_member['columns'] == 4).'>4</option>';
                        $out .= '</select>';                    
                    
                        $out .= '<span class="dc-cms-control-top-label">Number of words in excerpt</span>'; 
                        $out .= $this->getCtrlInputInt($prename.'-wgt_member-words', $cell->wgt_member['words'], 1);                    

                        $out .= '<span class="dc-cms-control-top-label">Number of words in post meta additional information text</span>'; 
                        $out .= $this->getCtrlInputInt($prename.'-wgt_member-addinfo_words', $cell->wgt_member['addinfo_words'], 1);    
                        
                        $out .= '<span class="dc-cms-control-top-label">Image area width</span>'; 
                        $out .= $this->getCtrlInputInt($prename.'-wgt_member-image_width', $cell->wgt_member['image_width'], 1);                              

                        $out .= '<span class="dc-cms-control-top-label">Items bottom margin</span>'; 
                        $out .= $this->getCtrlInputInt($prename.'-wgt_member-item_bottom', $cell->wgt_member['item_bottom'], 1);       
                 
                        $out .= '<span class="dc-cms-control-top-label">Members order</span>';
                        $out .= $this->getStdInputsFieldStart(); 
                            $out .= '<input type="radio" name="'.$prename.'-wgt_member-order" value="DESC" '.$this->attrChecked($cell->wgt_member['order'] == 'DESC').' /> Descending';
                            $out .= $this->getBR();
                            $out .= '<input type="radio" name="'.$prename.'-wgt_member-order" value="ASC" '.$this->attrChecked($cell->wgt_member['order'] == 'ASC').' /> Ascending';
                            $out .= $this->getBR();   
                        $out .= $this->getStdInputsFieldEnd(); 
                
                        $out .= '<span class="dc-cms-control-top-label">Sort displayed members by parameter</span>';  
                        $out .= $this->getStdInputsFieldStart(); 
                            $out .= '<input type="radio" name="'.$prename.'-wgt_member-orderby" value="date" '.$this->attrChecked($cell->wgt_member['orderby'] == 'date').' /> Order by date';
                            $out .= $this->getBR();
                            $out .= '<input type="radio" name="'.$prename.'-wgt_member-orderby" value="title" '.$this->attrChecked($cell->wgt_member['orderby'] == 'title').' /> Order by title';
                            $out .= $this->getBR();                
                            $out .= '<input type="radio" name="'.$prename.'-wgt_member-orderby" value="comment_count" '.$this->attrChecked($cell->wgt_member['orderby'] == 'comment_count').' /> Comments count';                     
                        $out .= $this->getStdInputsFieldEnd(); 
                        
                        $out .= '<span class="dc-cms-control-top-label">Viewport width</span>'; 
                        $out .= $this->getCtrlInputInt($prename.'-wgt_member-viewport_w', $cell->wgt_member['viewport_w'], 1);                             

                        $out .= '<span class="dc-cms-control-top-label">Viewport height</span>'; 
                        $out .= $this->getCtrlInputInt($prename.'-wgt_member-viewport_h', $cell->wgt_member['viewport_h'], 1);                                                        
                 
                        $out .= '<span class="dc-cms-control-top-label">Other settings</span>';                             
                        $out .= $this->getStdInputsFieldStart();                                                    
                            $out .= '<input type="checkbox" name="'.$prename.'-wgt_member-viewport_use" '.$this->attrChecked($cell->wgt_member['viewport_use']).' /> Use viewport';  
                            $out .= $this->getBR();                           
                            $out .= '<input type="checkbox" name="'.$prename.'-wgt_member-link_to_single" '.$this->attrChecked($cell->wgt_member['link_to_single']).' /> Link items to single page';  
                            $out .= $this->getBR();                            
                            $out .= '<input type="checkbox" name="'.$prename.'-wgt_member-item_bottom_use" '.$this->attrChecked($cell->wgt_member['item_bottom_use']).' /> Use items bottom margin settings';  
                            $out .= $this->getBR();   
                            $out .= '<input type="checkbox" name="'.$prename.'-wgt_member-grayscale" '.$this->attrChecked($cell->wgt_member['grayscale']).' /> Display images in grayscale';                                                                                                                                            
                            $out .= $this->getBR();                            
                            $out .= '<input type="checkbox" name="'.$prename.'-wgt_member-meta_title" '.$this->attrChecked($cell->wgt_member['meta_title']).' /> Display post meta title';                                                                                                                                                                  
                            $out .= $this->getBR();                            
                            $out .= '<input type="checkbox" name="'.$prename.'-wgt_member-meta_subtitle" '.$this->attrChecked($cell->wgt_member['meta_subtitle']).' /> Display post meta subtitle';                                                                                                                                            
                            $out .= $this->getBR();                            
                            $out .= '<input type="checkbox" name="'.$prename.'-wgt_member-meta_addinfo" '.$this->attrChecked($cell->wgt_member['meta_addinfo']).' /> Display post meta additional information';                                                                                                                                                                                                                    
                        $out .= $this->getStdInputsFieldEnd();                    
                 
                    $out .= '</div>'; /* inner-opt-wrapper */
                $out .= '</div>';                   
             } break;
                                
             case 'wgt-twitter':
             {
                $out .= '<div class="segment-options">';  
                                                                                            
                    $out .= $std;                                             
                    $out .= $cmn;
                    $out .= $empty_space;
                    $out .= '<div class="inner-opt-wrapper">';                                        
                    
                        $out .= '<span class="dc-cms-control-top-label-nomargin">Twitter nick name (screen name)</span>'; 
                        $out .= '<input type="text" class="dc-cms-control-300" name="'.$prename.'-wgt_twitter-twitter_screen_name" value="'.$cell->wgt_twitter['twitter_screen_name'].'" />'; 
                        
                        $out .= '<span class="dc-cms-control-top-label">Number of displayed tweets</span>';
                        $out .= '<select class="dc-cms-control-80" name="'.$prename.'-wgt_twitter-tweetes_count">';
                            for($i = 1; $i <= 20; $i++)
                            {
                                $out .= '<option value="'.$i.'" '.dcf_attrSelected($cell->wgt_twitter['tweetes_count'] == $i).'>'.$i.'</option>';
                            }
                        $out .= '</select>';                    
                    
                        $out .= '<span class="dc-cms-control-top-label">Refresh after every</span>';
                        $out .= '<select class="dc-cms-control-80" name="'.$prename.'-wgt_twitter-tweetes_refresh">';
                            $out .= '<option value="'.(900).'" '.dcf_attrSelected($cell->wgt_twitter['tweetes_refresh'] == 900).'>15 m</option>';
                            $out .= '<option value="'.(1800).'" '.dcf_attrSelected($cell->wgt_twitter['tweetes_refresh'] == 1800).'>30 m</option>';
                            for($i = 1; $i <= 12; $i++)
                            {
                                $out .= '<option value="'.(3600*$i).'" '.dcf_attrSelected($cell->wgt_twitter['tweetes_refresh'] == (3600*$i)).'>'.$i.' h</option>';
                            }
                        $out .= '</select>';        

                        $out .= '<span class="dc-cms-control-top-label">Time offset</span>';
                        $out .= '<select class="dc-cms-control-80" name="'.$prename.'-wgt_twitter-time_offset">';
                            for($i = -12; $i <= 12; $i++)
                            {
                                $out .= '<option value="'.(3600*$i).'" '.dcf_attrSelected($cell->wgt_twitter['time_offset'] == (3600*$i)).'>'.sprintf('%+d', $i).' h</option>';     
                            }
                        $out .= '</select>';                    
                    
                        $out .= '<span class="dc-cms-control-top-label">Tweet time format</span>'; 
                        $out .= '<input class="dc-cms-control-300" name="'.$prename.'-wgt_twitter-time_format" type="text" value="'.$cell->wgt_twitter['time_format'].'" />';                        
                    
                        $out .= '<span class="dc-cms-control-top-label">Layout</span>';
                        $out .= '<select class="dc-cms-control-100" name="'.$prename.'-wgt_twitter-layout">';
                            $out .= '<option value="column" '.dcf_attrSelected($cell->wgt_twitter['layout'] == 'column').'>Column</option>';
                            $out .= '<option value="wide" '.dcf_attrSelected($cell->wgt_twitter['layout'] == 'wide').'>Wide</option>';
                        $out .= '</select>';                         
                    
                        $out .= '<span class="dc-cms-control-top-label">Left side width</span>';
                        $out .= $this->getCtrlInputInt($prename.'-wgt_twitter-left_side_w', $cell->wgt_twitter['left_side_w'], 1);                      
                        $out .= '<div class="dc-cms-help-note-box-small">';
                            $out .= 'Works only width <strong>wide</strong> layout';
                        $out .= '</div>';
                    
                        $out .= '<span class="dc-cms-control-top-label">Other settings</span>';  
                        $out .= $this->getStdInputsFieldStart();
                            $out .= '<input type="checkbox" name="'.$prename.'-wgt_twitter-image_display" '.$this->attrChecked($cell->wgt_twitter['image_display']).' /> Display profile image and name';  
                            $out .= $this->getBR(); 
                            $out .= '<input type="checkbox" name="'.$prename.'-wgt_twitter-tweets_count_display" '.$this->attrChecked($cell->wgt_twitter['tweets_count_display']).' /> Display tweets count';  
                            $out .= $this->getBR(); 
                            $out .= '<input type="checkbox" name="'.$prename.'-wgt_twitter-date_display" '.$this->attrChecked($cell->wgt_twitter['date_display']).' /> Display tweet date';  
                            $out .= $this->getBR();   
                            $out .= '<input type="checkbox" name="'.$prename.'-wgt_twitter-reset" '.$this->attrChecked($cell->wgt_twitter['reset']).' /> One time reset twitter data';                                                                                                               
                        $out .= $this->getStdInputsFieldEnd();                        
                    
                    $out .= '</div>'; /* inner-opt-wrapper */
                $out .= '</div>';                                          
                                                       
             } break;                   
             
             case 'colored-head':
             {
                $out .= '<div class="segment-options">';  
                                                                                            
                    $out .= $std;                                             
                    $out .= $cmn;
                    $out .= $empty_space;
                    $out .= '<div class="inner-opt-wrapper">';   
                    
                        $out .= '<span class="dc-cms-control-top-label-nomargin">Prefix text</span>'; 
                        $out .= '<textarea class="dc-cms-control-wide dc-cms-control-textarea dc-cms-control-h-60" name="'.$prename.'-colored_head-prefix">';
                            $out .= $cell->colored_head['prefix'];
                        $out .= '</textarea>'; 
                        
                        $out .= '<span class="dc-cms-control-top-label">Prefix area width</span>';
                        $out .= $this->getCtrlInputInt($prename.'-colored_head-prefix_w', $cell->colored_head['prefix_w'], 0);                                                
                    
                        $out .= '<span class="dc-cms-control-top-label">Prefix align</span>';  
                        $out .= '<select class="dc-cms-control-100" name="'.$prename.'-colored_head-prefix_align">';
                            $val = $cell->colored_head['prefix_align'];
                            $out .= '<option value="left" '.$this->attrSelected($val == 'left').'>Left</option>';   
                            $out .= '<option value="center" '.$this->attrSelected($val == 'center').'>Center</option>';
                            $out .= '<option value="right" '.$this->attrSelected($val == 'right').'>Right</option>'; 
                        $out .= '</select>';                    
                    
                        $out .= '<span class="dc-cms-control-top-label">Prefix background color</span>'; 
                        $out .= '<input type="text" class="dc-color-picker" value="'.$cell->colored_head['prefix_bgcolor'].'" name="'.$prename.'-colored_head-prefix_bgcolor" /> ';                                          
                    
                        $out .= '<span class="dc-cms-control-top-label">Text</span>'; 
                        $out .= '<textarea class="dc-cms-control-wide dc-cms-control-textarea dc-cms-control-h-60" name="'.$prename.'-colored_head-text">';
                            $out .= $cell->colored_head['text'];
                        $out .= '</textarea>';                     

                        $out .= '<span class="dc-cms-control-top-label">Text color</span>'; 
                        $out .= '<input type="text" class="dc-color-picker" value="'.$cell->colored_head['color'].'" name="'.$prename.'-colored_head-color" /> ';                         
                        
                        $out .= '<span class="dc-cms-control-top-label">Text background color</span>'; 
                        $out .= '<input type="text" class="dc-color-picker" value="'.$cell->colored_head['bgcolor'].'" name="'.$prename.'-colored_head-bgcolor" /> '; 
                    
                        $out .= '<span class="dc-cms-control-top-label">Other settings</span>'; 
                        $out .= $this->getStdInputsFieldStart();
                            $out .= '<input type="checkbox" name="'.$prename.'-colored_head-prefix_percent" '.$this->attrChecked($cell->colored_head['prefix_percent']).' /> Interpret the prefix width as a percentage value';
                        $out .= $this->getStdInputsFieldEnd();
                    
                    $out .= '</div>'; /* inner-opt-wrapper */
                $out .= '</div>';                                          
                                                       
             } break;                                     
                                                                     
        } // switch
        
        if($echo) { echo $out; } else { return $out; }
    }
    
    public function getHTMLUnorderedListLegend()
    {
        $out = '';
        
        $folder_url = CMS_THEME_URL.'/img/list/';
        $out .= $this->getLegendInlineStart();                            
            $out .= $this->getLegendInlineItem(array('label' => 'Default', 'url' => $folder_url.'default.png')); 
            $out .= $this->getLegendInlineItem(array('label' => 'Tag', 'url' => $folder_url.'tag.png')); 
            $out .= $this->getLegendInlineItem(array('label' => 'Pin', 'url' => $folder_url.'pin.png')); 
            $out .= $this->getLegendInlineItem(array('label' => 'Star', 'url' => $folder_url.'star.png')); 
            $out .= $this->getLegendInlineItem(array('label' => 'Arrow', 'url' => $folder_url.'arrow.png'));
            $out .= $this->getLegendInlineItem(array('label' => 'Arrow dark', 'url' => $folder_url.'arrowdark.png')); 
            $out .= $this->getLegendInlineItem(array('label' => 'Arrow grey', 'url' => $folder_url.'arrowgrey.png')); 
            $out .= $this->getLegendInlineItem(array('label' => 'Document', 'url' => $folder_url.'document.png'));
            $out .= $this->getLegendInlineItem(array('label' => 'Tick', 'url' => $folder_url.'tick.png'));   
            $out .= $this->getLegendInlineItem(array('label' => 'Asterisk', 'url' => $folder_url.'asterisk.png'));
            $out .= $this->getLegendInlineItem(array('label' => 'Cross', 'url' => $folder_url.'cross.png')); 
            $out .= $this->getLegendInlineItem(array('label' => 'Exclamation', 'url' => $folder_url.'exclamation.png', 'last' => true)); 
        $out .= $this->getLegendInlineEnd();
        
        return $out;        
    }    
    
    public function getHTMLBasicSliderTypeSlide($args=array(), $obj=null, $echo=false)
    {
        $def = array(
            'id' => null, // segment id
            'index' => null  // slide unique index
        );        
        $args = $this->combineArgs($def, $args);

        if($obj == null)
        {
            $obj = new DCC_HTML_BasicSliderSlide();
        }
        
        $out = '';
        $out .= '<li>';
            $out .= '<div class="index-box">'.($args['index']+1).'</div>';
            $out .= '<div class="delete-box"></div>'; 
        
            $out .= '<input type="hidden" name="slide-index" value="'.$args['index'].'" />';
            $out .= '<span class="dc-cms-control-top-label-nomargin">Image URL</span>';
            $out .= '<input type="text" class="dc-cms-control-wide" value="'.$obj->_url.'" name="segment-cell-data-'.$args['id'].'-basic_slider-slide-'.$args['index'].'-url" id="dc-id-segment-cell-data-'.$args['id'].'-basic_slider-slide-'.$args['index'].'-url" />';
            
            $out .= $this->getImagePreviewBox(array('path' => $obj->_url, 'width' => 240, 'height' => 120, 'wide' => true, 'margin' => '15px 0px 0px 0px', 'info' => true, 'info_empty' => true)); 
                        
            $out .= '<div class="dc-cms-btn-frame">';
                $out .= '<input class="dc-cms-submit-image-btn" type="button" name="dc-id-segment-cell-data-'.$args['id'].'-basic_slider-slide-'.$args['index'].'-url" value="Load image" />';
            $out .= '</div>';              
            
            $out .= '<span class="dc-cms-control-top-label">Optional title for description</span>';
            $out .= '<textarea class="dc-cms-control-textarea dc-cms-control-wide dc-cms-control-h-40" name="segment-cell-data-'.$args['id'].'-basic_slider-slide-'.$args['index'].'-title">'.$obj->_title.'</textarea>';

            $out .= '<span class="dc-cms-control-top-label">Optional description</span>';
            $out .= '<textarea class="dc-cms-control-textarea dc-cms-control-wide dc-cms-control-h-120" name="segment-cell-data-'.$args['id'].'-basic_slider-slide-'.$args['index'].'-desc">'.$obj->_desc.'</textarea>';
            
            $out .= '<span class="dc-cms-control-top-label">Image link</span>';  
            $out .= '<input type="text" class="dc-cms-control-wide" value="'.$obj->_link.'" name="segment-cell-data-'.$args['id'].'-basic_slider-slide-'.$args['index'].'-link" />';
            
            $out .= '<span class="dc-cms-control-top-label">Other settings</span>';               
            $out .= $this->getStdInputsFieldStart();
                $out .= '<input type="checkbox" '.$this->attrChecked($obj->_display).' name="segment-cell-data-'.$args['id'].'-basic_slider-slide-'.$args['index'].'-display" /> Display slide';
                $out .= $this->getBR();
                $out .= '<input type="checkbox" '.$this->attrChecked($obj->_title_use).' name="segment-cell-data-'.$args['id'].'-basic_slider-slide-'.$args['index'].'-title_use" /> Display description title';
                $out .= $this->getBR();
                $out .= '<input type="checkbox" '.$this->attrChecked($obj->_desc_use).' name="segment-cell-data-'.$args['id'].'-basic_slider-slide-'.$args['index'].'-desc_use" /> Display description';
                $out .= $this->getBR();
                $out .= '<input type="checkbox" '.$this->attrChecked($obj->_link_use).' name="segment-cell-data-'.$args['id'].'-basic_slider-slide-'.$args['index'].'-link_use" /> Use image link';
                $out .= $this->getBR();
                $out .= '<input type="checkbox" '.$this->attrChecked($obj->_blank).' name="segment-cell-data-'.$args['id'].'-basic_slider-slide-'.$args['index'].'-blank" /> Open image link in new window/tab';                
            $out .= $this->getStdInputsFieldEnd();
            
        $out .= '</li>';
        
        if($echo) { echo $out; } else { return $out; }
    }           
    
    public function renderCellNoteCMS($cell, $echo=false)
    {
        $out = '';
        $out .= '<div class="segment-note">';
            $out .= '<input type="hidden" name="segment-cell-id-'.$cell->core['id'].'" value="'.$cell->core['id'].'" />';
            $out .= '<span class="dc-cms-control-top-label-nomargin">Insert your note</span>'; 
            $out .= '<textarea name="segment-cell-data-'.$cell->core['id'].'-core-note" class="note">'.$cell->core['note'].'</textarea>';
            
            $out .= '<div class="close-btn"></div>';
        $out .= '</div>';
        
        if($echo) { echo $out; } else { return $out; }
    }
    
    public function display()
    {   
        global $post;    
        $meta = get_post_meta($post->ID, $this->_opt_name, true);             
        
        $out = '';     
        $out .= '<div class="dc-cms-custom-field-panel">';     
            $out .= $this->getMetaTopSavePanel();       
            $out .= '<div class="center-content-panel">';          
            
                
            
                $out .= '<div id="dc-cms-content-builder-wrapper">';
                    
                    $out .= '<div class="dc-cms-content-builder-control-panel">';

                        // description
                        $out .= '<div class="insert-type-desc">';                            
                            $out .= '<div name="page-title" class="item" >Page title</div>';
                            $out .= '<div name="blog" class="item" >Display posts form selected categries also you can choose some type of posts sorting</div>';
                            $out .= '<div name="post" class="item" >Single post in short mode</div>';  
                            $out .= '<div name="page-content" class="item" >Page content</div>';
                            $out .= '<div name="heading" class="item" >Heading</div>';
                            $out .= '<div name="colored-head" class="item">Horizontal block head with prefix section and background</div>';                            
                            $out .= '<div name="sidebar" class="item" >Sidebar</div>';
                            $out .= '<div name="gmap" class="item" >Google Map</div>';    
                            $out .= '<div name="cform" class="item" >Contact form</div>';
                            $out .= '<div name="text" class="item" >Text area. You can put inside it any content. Also you can insert shortcodes.</div>';
                            $out .= '<div name="empty-space" class="item" >Empty space</div>';
                            $out .= '<div name="top-anchor" class="item" >Back to page top</div>';
                            $out .= '<div name="line-divider" class="item" >Line divider, simple block with line for dividing page content</div>';
                            $out .= '<div name="img-divider" class="item" >Image divider, allow display image as content divider</div>';
                            
                            $out .= '<div name="note" class="item" >Note field</div>'; 
                            $out .= '<div name="blockquote" class="item" >Blockquote</div>';
                            $out .= '<div name="ul-list" class="item" >Unordered list</div>'; 
                            $out .= '<div name="postbox" class="item" >Displays a special box with post image, description, and a link to post page</div>';
                            $out .= '<div name="pagebox" class="item" >Displays a special box with page image, description, and a link to page</div>';
                            $out .= '<div name="tip" class="item" >Configurable tip box</div>';
                            $out .= '<div name="image" class="item" >Configurable image</div>'; 
                            $out .= '<div name="video" class="item" >Video from YouTube or Vimeo</div>';
                            $out .= '<div name="ngg" class="item" >NextGEN Gallery images displayes as configurable thumbs</div>'; 
                            $out .= '<div name="ngg-thumbs-slider" class="item" >NextGEN Gallery as slider with thumbs list located at the bottom</div>'; 
                            $out .= '<div name="ngg-gallery" class="item" >NextGEN Gallery in classic box layout</div>';   
                            $out .= '<div name="service" class="item" >Configurable services custom post block</div>'; 
                            $out .= '<div name="project" class="item" >Configurable projects custom post block</div>';
                            $out .= '<div name="member" class="item" >Configurable members custom post block</div>';  
                            $out .= '<div name="basic-slider" class="item" >Basic image slider</div>';
                            $out .= '<div name="code" class="item" >Programming code in configurable box</div>';
                            $out .= '<div name="board-slider" class="item" >Board slider - theme main slider. Can be displayed only on full width layout</div>';
                            $out .= '<div name="anno-box" class="item" >Announcement box</div>';
                            $out .= '<div name="ngg-recent-slider" class="item" >NextGEN Gallery recent images slider</div>';
                            $out .= '<div name="recent-posts-list" class="item" >Recent posts stream</div>'; 
                            $out .= '<div name="download" class="item" >Configurable download block</div>';  
                            
                            $out .= '<div name="wgt-member" class="item">Widget member</div>';
                            $out .= '<div name="wgt-twitter" class="item">Widget twitter</div>';        
                        $out .= '</div>';                      

                        // insert list
                        $out .= '<span class="dc-cms-control-top-label-nomargin">Select content segment to insert</span>';
                        $out .= '<select class="insert-list">';
                            
                            $out .= '<optgroup label="Content">';
                                $out .= '<option value="page-title">Page title</option>'; 
                                $out .= '<option value="page-content">Page content</option>';
                                $out .= '<option value="heading">Heading</option>'; 
                                $out .= '<option value="colored-head">Colored head</option>';
                                $out .= '<option value="sidebar">Sidebar</option>';
                                $out .= '<option value="blog">Blog</option>';                                                                                                
                                $out .= '<option value="post">Post</option>';  
                                $out .= '<option value="gmap">Google Map</option>';                             
                                $out .= '<option value="cform">Contact form</option>';
                                $out .= '<option value="text">Text area</option>';
                                $out .= '<option value="note">Note</option>';
                                $out .= '<option value="blockquote">Blockquote</option>';
                                $out .= '<option value="ul-list">Unordered list</option>';
                                $out .= '<option value="postbox">Post box</option>'; 
                                $out .= '<option value="pagebox">Page box</option>';
                                $out .= '<option value="tip">Tip</option>'; 
                                $out .= '<option value="image">Image</option>'; 
                                $out .= '<option value="video">Video</option>';
                                $out .= '<option value="service">Services</option>';
                                $out .= '<option value="project">Projects</option>'; 
                                $out .= '<option value="member">Members</option>';
                                $out .= '<option value="code">Code</option>';
                                $out .= '<option value="anno-box">Announcement box</option>';
                                $out .= '<option value="recent-posts-list">Recent posts stream</option>';
                                $out .= '<option value="download">Download block</option>';  
                            $out .= '</optgroup>';
                            
                            $out .= '<optgroup label="Widgets">';
                                $out .= '<option value="wgt-member">WGT-Member</option>';
                                $out .= '<option value="wgt-twitter">WGT-Twitter</option>';   
                            $out .= '</optgroup>';
                            
                            $out .= '<optgroup label="Advanced">'; 
                                $out .= '<option value="basic-slider">Basic image slider</option>';
                                $out .= '<option value="ngg">NGG thumbs</option>';
                                $out .= '<option value="ngg-thumbs-slider">NGG thumbs slider</option>';
                                $out .= '<option value="ngg-gallery">NGG gallery</option>';   
                            $out .= '</optgroup>';
                            
                            $out .= '<optgroup label="Helpers">';
                                $out .= '<option value="empty-space">Empty space</option>';
                                $out .= '<option value="top-anchor">Back to page top</option>';
                                $out .= '<option value="line-divider">Line divider</option>';
                                $out .= '<option value="img-divider">Image divider</option>';
                            $out .= '</optgroup>';
                            
                            $out .= '<optgroup label="Only full width layout">'; 
                                $out .= '<option value="board-slider">Board slider</option>';
                                $out .= '<option value="ngg-recent-slider">NGG recent slider</option>';
                            $out .= '</optgroup>';                            
                            
                        $out .= '</select> ';
                        $out .= '<input type="button" class="dc-cms-submit-btn insert-btn" value="Insert" /> ';
                        $out .= '<input type="button" class="insert-place-btn" value=" " title="Insert after" />'; 
                        
                        // hidden meta values
                        $out .= '<input type="hidden" class="dc-cms-submit-btn meta-opt-btn" value="Opt" />';
                        $out .= '<div class="builder-meta">';
                            $out .= '<input type="hidden" name="dc-builder-meta-order" value="" />';
                        $out .= '</div>';
                        
                        $out .= '<div class="dc-cms-clear"></div>';
                    $out .= '</div>';
                    
                    $out .= '<div class="dc-cms-note-editor">';

                        if(is_object($meta))
                        {
                            if(is_array($meta->cells) and count($meta->cells))
                            {
                                $id = 0;
                                foreach($meta->cells as $cell)
                                {                                            
                                    $cell->core['id'] = $id;                                                                                          
                                    $out .= $this->renderCellNoteCMS($cell);
                                    $id++;
                                }
                            }
                        }                    
                    
                    $out .= '</div>';
                    
                    $out .= '<ul class="dc-cms-content-builder">';
                                        
                        if(is_object($meta))
                        {                        
                            if(is_array($meta->cells) and count($meta->cells))
                            {
                                $id = 0;
                                foreach($meta->cells as $cell)
                                {                                
                                    $cell->core['id'] = $id;                        
                                    $out .= $this->renderCellCMS($cell);
                                    $id++;               
                                }
                            }
                        }
                        
                        $out .= $this->getClearBoth();
                    $out .= '</ul>'; // content builder                                                             
                    
                    $out .= '<div class="dc-cms-segment-editor">';

                        if(is_object($meta))
                        {                    
                            if(is_array($meta->cells) and count($meta->cells))
                            {
                                $id = 0;
                                foreach($meta->cells as $cell)
                                {                                            
                                    $cell->core['id'] = $id;                                                                                          
                                    $out .= $this->renderCellOptionsCMS($cell);
                                    $id++;
                                }
                            }
                        }                                                 
                    
                    $out .= '</div>'; // segment editor  
                                 
                $out .= '</div>'; // content builder wrapper
        
            $out .= '</div>';      
            $out .= $this->getMetaBottomSavePanel();     
        $out .= '</div>';
        
        echo $out;
    }   
}  


/*********************************************************** 
* Class name:
*    DCC_PageMetaSEO
* Descripton:
*    Implementation of DCC_PageMetaSEO
***********************************************************/
class DCC_PageMetaSEO extends DCC_MetaMultiple 
{         
    /*********************************************************** 
    * Constructor
    ************************************************************/
    public function __construct() 
    {
        $this->_names = array(
            'page_seo_opt', 
            'page_seo_opt_cbox',
            
            'page_seo_active_cbox',
            
            'page_seo_title',
            'page_seo_title_use_cbox',
            'page_seo_add_blog_name_cbox',

            'page_seo_keywords',
            'page_seo_keywords_use_cbox',

            'page_seo_desc',
            'page_seo_desc_use_cbox',
            
            'page_seo_noindex_cbox',
            'page_seo_nofollow_cbox',
            'page_seo_nosnippet_cbox',
            'page_seo_noodp_cbox',
            'page_seo_noarchive_cbox',
            'page_seo_noimageindex_cbox',
            
            'page_seo_private_meta' 
            );     
                     
        $this->_std = array(
            'page_seo_opt_cbox' => true,
            
            'page_seo_active_cbox' => false,
            
            'page_seo_title' => '',
            'page_seo_title_use_cbox' => false,
            'page_seo_add_blog_name_cbox' => false,
            
            'page_seo_keywords' => '',
            'page_seo_keywords_use_cbox' => false,            

            'page_seo_desc' => '',
            'page_seo_desc_use_cbox' => false,
            
            'page_seo_noindex_cbox' => false,
            'page_seo_nofollow_cbox' => false,
            'page_seo_nosnippet_cbox' => false,
            'page_seo_noodp_cbox' => false,
            'page_seo_noarchive_cbox' => false,
            'page_seo_noimageindex_cbox'  => false,               
                
            'page_seo_private_meta' => array()    
            );
                             
        $this->_title = 'Page SEO Settings';
        $this->_slug = 'dc-page-seo-settings';
        $this->_closed = true;
        $this->_post_type = 'page';
        
        add_action('admin_menu', array(&$this, 'adminMenu')); 
        add_action('save_post', array(&$this, 'save'));        
    } // constructor 

    /*********************************************************** 
    * Public functions
    ************************************************************/        
    
    public function save($post_id)
    {    
        global $post;
          
        if(isset($_POST['post_type']) and 'page' == $_POST['post_type']) 
        {  
            if(!current_user_can('edit_page', $post_id))  
            {
                return $post_id;
            }  
        } else 
        {  
            if(!current_user_can('edit_post', $post_id))
            {  
                return $post_id;
            }  
        }  

        $data = array();
        $count = count($this->_names);
        if(isset($_POST[($this->_names[0].'_cbox')]))
        {        
            for($i = 1; $i < $count; $i++)
            {
                if($this->_names[$i] == 'page_seo_private_meta')
                {
                    $list = $_POST['page_seo_private_meta_list'];
                    $list = explode(',', $list);
                    
                    $private_meta = array();
                    if(is_array($list))
                    {
                        foreach($list as $index)
                        {
                            if($index == '') { continue; }
                            $obj = new DCC_PrivateSeoMeta();
                            
                            if(isset($_POST['dc-seo-private-meta-'.$index.'-name']))
                            {
                                $obj->_name = $_POST['dc-seo-private-meta-'.$index.'-name'];
                                $obj->_content = $_POST['dc-seo-private-meta-'.$index.'-content'];
                                $obj->_active = isset($_POST['dc-seo-private-meta-'.$index.'-active']) ? true : false; 
                                array_push($private_meta, $obj);                            
                            }
                        }
                    }                    
                    
                    $data[$this->_names[$i]] = $private_meta;
                } else
                {                
                    $checkbox = strstr($this->_names[$i], '_cbox');
                    if($checkbox !== false) { $checkbox = true; }
                    
                    if($checkbox)
                    {
                       $data[$this->_names[$i]] = isset($_POST[$this->_names[$i]]) ? true : false;
                    } else
                    {
                       $data[$this->_names[$i]] = $_POST[$this->_names[$i]]; 
                    }
                }
            }    

            update_post_meta($post_id, $this->_names[0], $data);                    
        } else
        {
           $t_value = get_post_meta($post_id, $this->_names[0], true);
           if($t_value != '')
           {
                $t_value[($this->_names[0].'_cbox')] = false;
                update_post_meta($post_id, $this->_names[0], $t_value);    
           }  
        }
    }
      
    public function display()
    {       
        $meta = $this->initDisplay();                            
        global $post;           
        
        $out = '';     
        $out .= '<div class="dc-cms-custom-field-panel">';     
            $out .= $this->getMetaTopSavePanel();       
            $out .= '<div class="center-content-panel">';   
                                
                $out .= '<input type="hidden" name="page_seo_opt_cbox" checked="checked" />';        
        
                $out .= $this->getGroupFieldBegin(array('title' => 'SEO Settings', 'max_w' => 800, 'mtop' => 30)); 
        
                    $out .= '<input type="checkbox" name="page_seo_active_cbox" '.$this->attrChecked($meta['page_seo_active_cbox']).' /> Active';    
        
                    $out .= '<span class="dc-cms-control-top-label">Title</span>'; 
                    $out .= '<textarea class="dc-cms-control-textarea dc-cms-control-h-40 dc-cms-control-wide" name="page_seo_title">'.$meta['page_seo_title'].'</textarea>';
                    $out .= $this->getStdInputsFieldStart();
                        $out .= '<input type="checkbox" name="page_seo_title_use_cbox" '.$this->attrChecked($meta['page_seo_title_use_cbox']).' /> Use title';
                        $out .= $this->getBR();
                        $out .= '<input type="checkbox" name="page_seo_add_blog_name_cbox" '.$this->attrChecked($meta['page_seo_add_blog_name_cbox']).' /> Add blog name before title';                        
                    $out .= $this->getStdInputsFieldEnd();
                    
                    $out .= '<span class="dc-cms-control-top-label">Keywords meta tag (if more then one, you can use comma to separate it)</span>'; 
                    $out .= '<textarea class="dc-cms-control-textarea dc-cms-control-h-60 dc-cms-control-wide" name="page_seo_keywords">'.$meta['page_seo_keywords'].'</textarea>';
                    $out .= $this->getStdInputsFieldStart();
                        $out .= '<input type="checkbox" name="page_seo_keywords_use_cbox" '.$this->attrChecked($meta['page_seo_keywords_use_cbox']).' /> Use keywords'; 
                    $out .= $this->getStdInputsFieldEnd();
                    
                    $out .= '<span class="dc-cms-control-top-label">Description meta tag</span>'; 
                    $out .= '<textarea class="dc-cms-control-textarea dc-cms-control-h-80 dc-cms-control-wide" name="page_seo_desc">'.$meta['page_seo_desc'].'</textarea>';
                    $out .= $this->getStdInputsFieldStart();
                        $out .= '<input type="checkbox" name="page_seo_desc_use_cbox" '.$this->attrChecked($meta['page_seo_desc_use_cbox']).' /> Use description';
                    $out .= $this->getStdInputsFieldEnd();                    
                    
                    $out .= '<span class="dc-cms-control-top-label">Robots meta tag</span>'; 
                    $out .= $this->getStdInputsFieldStart();
                        $out .= '<input type="checkbox" name="page_seo_noindex_cbox" '.$this->attrChecked($meta['page_seo_noindex_cbox']).' /> noindex';
                        $out .= $this->getBR();
                        $out .= '<input type="checkbox" name="page_seo_nofollow_cbox" '.$this->attrChecked($meta['page_seo_nofollow_cbox']).' /> nofollow';
                        $out .= $this->getBR();                                                 
                        $out .= '<input type="checkbox" name="page_seo_nosnippet_cbox" '.$this->attrChecked($meta['page_seo_nosnippet_cbox']).' /> nosnippet';
                        $out .= $this->getBR();  
                        $out .= '<input type="checkbox" name="page_seo_noodp_cbox" '.$this->attrChecked($meta['page_seo_noodp_cbox']).' /> noodp';
                        $out .= $this->getBR(); 
                        $out .= '<input type="checkbox" name="page_seo_noarchive_cbox" '.$this->attrChecked($meta['page_seo_noarchive_cbox']).' /> noarchive';
                        $out .= $this->getBR();  
                        $out .= '<input type="checkbox" name="page_seo_noimageindex_cbox" '.$this->attrChecked($meta['page_seo_noimageindex_cbox']).' /> noimageindex';                       
                    $out .= $this->getStdInputsFieldEnd();
                    
                    $out .= '<span class="dc-cms-control-top-label">Private meta tags</span>';  
                    if(!is_array($meta['page_seo_private_meta'])) { $meta['page_seo_private_meta'] = array(); }
                    
                    $list = '';
                    $meta_count = count($meta['page_seo_private_meta']);
                    
                    for($i = 0; $i < $meta_count; $i++)
                    {
                        if($i > 0) { $list .= ','; }
                        $list .= $i;
                    }                    
                     
                    $out .= '<div class="dc-page-private-seo-meta-wrapper">'; 

                        $out .= '<input type="hidden" name="page_seo_private_meta_list" value="'.$list.'" />';
                        for($i = 0; $i < $meta_count; $i++)
                        {
                            $out .= DCC_PrivateSeoMeta::getHTMLMeta($meta['page_seo_private_meta'][$i], $i);
                        }

                    $out .= '</div>';
                    
                    $out .= '<div class="dc-cms-btn-frame">';
                        $out .= '<span class="dc-cms-action-name">dc_add_seo_meta</span>';
                        $out .= '<input class="dc-cms-submit-btn" type="button" name="dc-page-meta-add-private-seo-meta" value="Add meta" /> ';  
                    $out .= '</div>';                      
                    
                    
                    
        
                $out .= $this->getGroupFieldEnd();
        
            $out .= '</div>';      
            $out .= $this->getMetaBottomSavePanel();     
        $out .= '</div>';
        
        echo $out;
    } 
}    
