<?php 

/**
 * Recent Comments Widget with Avatars 
 *
 * lambda framework v 1.0
 * by www.unitedthemes.com
 * since Passion 1.0
 */
 
class WP_Widget_Recent_Comments_Avatar extends WP_Widget {

	function __construct() {
		$widget_ops = array('classname' => 'lambda_widget_recent_comments', 'description' => __( 'The most recent comments with Avatar', UT_THEME_NAME) );
		parent::__construct('lw_recent-comments', __('Lambda - Recent Comments', UT_THEME_NAME), $widget_ops);
		$this->alt_option_name = 'lambda_widget_recent_comments';

		if ( is_active_widget(false, false, $this->id_base) )
			add_action( 'wp_head', array(&$this, 'recent_comments_style') );

		add_action( 'comment_post', array(&$this, 'flush_widget_cache') );
		add_action( 'transition_comment_status', array(&$this, 'flush_widget_cache') );
	}

	function recent_comments_style() {
		if ( ! current_theme_supports( 'widgets' ) // Temp hack #14876
			|| ! apply_filters( 'show_recent_comments_widget_style', true, $this->id_base ) )
			return;
		?>
<?php
	}

	function flush_widget_cache() {
		wp_cache_delete('widget_recent_comments_avatar', 'widget');
	}

	function widget( $args, $instance ) {
		global $comments, $comment;

		$cache = wp_cache_get('widget_recent_comments_avatar', 'widget');

		if ( ! is_array( $cache ) )
			$cache = array();

		if ( ! isset( $args['widget_id'] ) )
			$args['widget_id'] = $this->id;

		if ( isset( $cache[ $args['widget_id'] ] ) ) {
			echo $cache[ $args['widget_id'] ];
			return;
		}

 		extract($args, EXTR_SKIP);
 		$output = '';
		$title = apply_filters( 'widget_title', empty( $instance['title'] ) ? __( 'Recent Comments', UT_THEME_NAME) : $instance['title'], $instance, $this->id_base );

		if ( empty( $instance['number'] ) || ! $number = absint( $instance['number'] ) )
 			$number = 5;

		$comments = get_comments( array( 'number' => $number, 'status' => 'approve', 'post_status' => 'publish' ) );
		$output .= $before_widget;
		if ( $title )
			$output .= $before_title . $title . $after_title;

		$output .= '<ul id="recentcomments">';
		if ( $comments ) {
			foreach ( (array) $comments as $comment) {
				$avatar = get_avatar( $comment->comment_author_email, '45' );
				$comment_excerpt = wp_html_excerpt( $comment->comment_content, 72 );
				$output .=  '<li class="recentcomments clearfix"><div class="comments_avatar"><a href="' . esc_url( get_comment_link($comment->comment_ID) ) . '">'.$avatar.'</a></div><div class="l-description"><span>'.sprintf(_x('%1$s on %2$s', 'widgets', UT_THEME_NAME), get_comment_author(), '<a href="' . esc_url( get_comment_link($comment->comment_ID) ) . '">' . get_the_title($comment->comment_post_ID) . '</a>') . '</span><br /><span class="recentcomments-text">'.$comment_excerpt.'...</span></div></li>';
			}
 		}
		$output .= '</ul>';
		$output .= $after_widget;

		echo $output;
		$cache[$args['widget_id']] = $output;
		wp_cache_set('widget_recent_comments_avatar', $cache, 'widget');
	}

	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['number'] = absint( $new_instance['number'] );
		$this->flush_widget_cache();

		$alloptions = wp_cache_get( 'alloptions', 'options' );
		if ( isset($alloptions['widget_recent_comments_avatar']) )
			delete_option('widget_recent_comments_avatar');

		return $instance;
	}

	function form( $instance ) {
		$title = isset($instance['title']) ? esc_attr($instance['title']) : '';
		$number = isset($instance['number']) ? absint($instance['number']) : 5;
?>
		<p><label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:', UT_THEME_NAME); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" /></p>

		<p><label for="<?php echo $this->get_field_id('number'); ?>"><?php _e('Number of comments to show:', UT_THEME_NAME); ?></label>
		<input id="<?php echo $this->get_field_id('number'); ?>" name="<?php echo $this->get_field_name('number'); ?>" type="text" value="<?php echo $number; ?>" size="3" /></p>
<?php
	}
}
add_action( 'widgets_init', create_function( '', 'return register_widget("WP_Widget_Recent_Comments_Avatar");' ) );
?>