/*!
 * The following copyright notice may not be removed under any circumstances.
 * 
 * Copyright:
 * Copyright (c) 2001-2010 by David J. Perry (http://scholarsfonts.net), with
 * Reserved Font Name Cardo.  This Font Software is licensed under the SIL Open
 * Font License, Version 1.1.  This license is available with a FAQ at:
 * http://scripts.sil.org/OFL.
 * 
 * Trademark:
 * Cardo is a trademark of David J. Perry.
 * 
 * Description:
 * A font for scholarly use in classical and medieval languages as well as for
 * general-purpose typesetting. Contains characters for many languages as well as
 * those required for quality typography.
 * 
 * Manufacturer:
 * David J. Perry
 * 
 * Designer:
 * David J. Perry
 * 
 * Vendor URL:
 * http://scholarsfonts.net
 * 
 * License information:
 * http://scripts.sil.org/OFL
 */
Cufon.registerFont({"w":184,"face":{"font-family":"cufon","font-weight":400,"font-stretch":"normal","units-per-em":"360","panose-1":"2 2 6 0 0 0 0 0 0 0","ascent":"288","descent":"-72","x-height":"5","bbox":"-83 -348.03 397 112.27","underline-thickness":"17.5781","underline-position":"-18.457","unicode-range":"U+0020-U+2074"},"glyphs":{" ":{"w":96},"!":{"d":"43,5v-12,-1,-20,-8,-20,-21v0,-13,7,-20,20,-20v13,0,20,8,20,21v0,13,-9,18,-20,20xm43,-75v-4,0,-6,-2,-6,-6r-13,-179v5,-4,28,-3,37,0r-13,179v0,3,-1,6,-5,6","w":85},"\"":{"d":"99,-144v2,-34,-20,-74,-5,-100v18,-11,39,3,29,27r-10,73r-14,0xm23,-234v1,-17,37,-20,37,0v0,30,-10,62,-12,91r-13,0","w":146},"#":{"d":"23,-187r47,0r18,-83r23,0r-18,83r44,0r18,-83r22,0r-18,83r48,0r-5,21r-47,0r-13,62r49,0r-5,21r-49,0r-18,89r-24,0r19,-89r-43,0r-19,89r-23,0r19,-89r-48,0r6,-21r47,0r13,-62r-49,0xm76,-104r43,0r13,-62r-44,0","w":208},"$":{"d":"28,-171v0,-29,20,-43,43,-51r0,-28r10,0r0,26r25,1r0,-27r10,0r0,29v20,4,41,12,44,32v1,6,-4,12,-11,12v-18,-4,-18,-24,-33,-32r0,87v23,14,53,29,53,64v0,36,-24,52,-53,60r0,36r-10,0r0,-34v-8,0,-17,2,-25,0r0,34r-10,0r0,-35v-23,-6,-45,-17,-50,-41v3,-23,27,-13,28,3v4,11,12,21,22,27r0,-107v-20,-13,-43,-26,-43,-56xm106,-95r-25,-15r0,105v7,4,16,2,25,2r0,-92xm106,-214v-6,-3,-16,-2,-25,-2r0,72v8,6,16,11,25,17r0,-87xm116,-6v31,-7,41,-57,12,-74r-12,-9r0,83xm71,-214v-23,4,-29,41,-10,55v5,3,4,3,10,8r0,-63"},"%":{"d":"243,4v-66,-7,-65,-137,-2,-148v71,2,67,143,2,148xm244,0v43,-6,35,-93,21,-128v-36,-32,-57,12,-54,58v2,33,2,67,33,70xm239,-260r23,0r-194,270r-22,0xm64,-107v-66,-7,-65,-137,-2,-148v71,2,67,143,2,148xm65,-111v43,-6,35,-93,21,-128v-36,-32,-57,12,-54,58v2,33,2,67,33,70","w":307},"&":{"d":"246,-17v-2,25,-62,29,-71,7v-8,-10,-12,-23,-21,-31v-23,20,-47,46,-87,46v-39,0,-63,-31,-63,-69v0,-43,35,-57,66,-72v-13,-13,-26,-26,-26,-51v0,-28,23,-43,54,-43v46,0,63,58,24,78v-28,14,7,27,16,42v11,10,20,28,32,33v14,-25,33,-45,45,-72v2,-13,-24,-6,-17,-18v20,3,52,-7,65,4v-4,9,-31,1,-37,17r-51,82v15,25,30,72,71,47xm36,-66v-3,53,66,62,96,30v5,-5,15,-8,16,-17v-18,-30,-41,-56,-68,-75v-25,9,-43,29,-44,62xm94,-220v-33,-1,-27,51,-8,62v17,21,34,-8,36,-29v1,-21,-9,-32,-28,-33","w":267},"'":{"d":"23,-233v0,-19,39,-20,36,0r-12,90r-13,0v-1,-31,-10,-60,-11,-90","w":81},"(":{"d":"30,-106v0,-85,30,-151,72,-198v5,0,7,7,8,10v-29,54,-57,105,-57,189v0,79,27,133,57,187v-1,4,-3,10,-9,10v-40,-50,-71,-112,-71,-198","w":114},")":{"d":"12,-304v44,46,72,112,72,198v0,87,-29,151,-72,198v-4,-2,-7,-6,-8,-10v30,-54,59,-108,58,-187v0,-82,-28,-136,-58,-189v2,-4,4,-9,8,-10","w":114},"*":{"d":"121,-242r2,7r-40,21r20,41r-6,4r-32,-32r-32,31r-7,-4r21,-40r-40,-21r2,-8r44,7r8,-44r8,0r7,44","w":130},"+":{"d":"15,-121r66,0r0,-68r23,0r0,68r65,0r0,22r-65,0r0,68r-23,0r0,-68r-66,0r0,-22"},",":{"d":"27,49v0,-17,34,-24,24,-48v-31,6,-42,-41,-9,-42v50,9,23,90,-15,90","w":91},"-":{"d":"146,-102r0,24r-131,0r0,-24r131,0","w":160},".":{"d":"46,5v-13,0,-23,-10,-23,-23v0,-13,10,-23,23,-23v13,0,23,10,23,23v0,13,-10,23,-23,23","w":91},"\/":{"d":"93,-255r23,0r-92,260r-23,0","w":116},"0":{"d":"92,5v-106,-14,-102,-229,-3,-247v111,6,109,237,3,247xm91,-232v-49,0,-49,62,-49,115v0,54,2,111,51,111v56,0,49,-78,49,-136v0,-45,-7,-90,-51,-90"},"1":{"d":"109,-28v-4,25,20,17,39,22v0,3,1,6,-2,6r-107,-1v-2,-18,45,7,45,-23r0,-187v-13,5,-36,37,-51,25v21,-19,45,-34,63,-56v4,1,14,-3,13,3r0,211"},"2":{"d":"139,-24v20,1,22,-13,26,-29r7,0v-4,17,-2,42,-12,53r-147,-1v30,-65,107,-85,120,-165v-2,-31,-20,-55,-50,-55v-34,0,-51,27,-60,52v-5,0,-8,1,-5,-7v10,-37,29,-64,76,-66v62,-2,89,71,52,114v-33,37,-76,67,-106,104r99,0"},"3":{"d":"75,5v-28,0,-57,-5,-64,-28v0,-8,7,-12,15,-12v20,7,29,29,58,29v59,0,77,-121,4,-121v-9,0,-19,15,-22,5v17,-21,50,-31,50,-69v0,-19,-16,-31,-35,-32v-28,-1,-41,19,-51,36v-6,1,-10,-1,-6,-6v12,-25,31,-45,64,-49v63,-7,66,71,22,90v-3,3,-11,6,-1,6v38,0,56,27,56,63v0,52,-39,88,-90,88"},"4":{"d":"113,7v-11,-19,4,-59,-6,-77r-95,0v-2,0,-1,-6,0,-7r113,-165v5,0,10,-2,10,4r1,149r36,0v1,3,3,18,-2,19v-11,2,-32,-5,-35,4v-2,23,5,55,-3,73r-19,0xm105,-197v-27,32,-52,73,-72,108v25,-2,56,3,77,-3r-1,-103v0,-1,-2,-2,-4,-2"},"5":{"d":"70,5v-28,2,-73,-23,-38,-36v19,3,28,24,47,27v36,-3,52,-29,55,-64v4,-57,-61,-75,-99,-46v-5,-35,4,-82,3,-121r96,-1v5,0,3,-8,13,-6r-4,29v-31,2,-69,-4,-96,2r-3,67v50,-25,120,5,119,63v-1,57,-37,82,-93,86"},"6":{"d":"170,-77v0,74,-96,109,-136,52v-12,-16,-20,-38,-20,-63v0,-89,70,-128,146,-154v-25,31,-84,42,-92,90v52,-20,102,21,102,75xm85,-148v-65,0,-52,146,7,143v35,-2,47,-33,47,-67v0,-41,-13,-76,-54,-76"},"7":{"d":"167,-235v8,-1,5,15,2,21r-98,219r-20,0r90,-209v0,-1,-2,-3,-3,-3v-33,2,-75,-4,-103,3v-8,10,-10,24,-15,36v-2,0,-7,1,-6,-2r13,-65r140,0"},"8":{"d":"94,5v-66,4,-85,-83,-33,-115v30,-18,-31,-35,-26,-75v5,-35,21,-57,57,-57v34,0,59,20,59,53v0,31,-25,45,-41,59v21,20,46,33,46,73v0,37,-25,60,-62,62xm95,-3v41,0,46,-65,17,-85v-12,-8,-27,-35,-43,-18v-27,28,-25,105,26,103xm92,-235v-48,0,-40,67,-10,82v7,5,11,13,21,15v37,-11,39,-97,-11,-97"},"9":{"d":"87,-242v92,-4,104,122,55,178v-29,33,-69,65,-124,67v36,-25,90,-44,102,-90v-55,22,-109,-13,-107,-72v2,-47,27,-80,74,-83xm89,-233v-66,0,-59,143,6,143v43,0,47,-34,43,-78v-3,-35,-13,-65,-49,-65"},":":{"d":"46,5v-13,0,-23,-10,-23,-23v0,-13,10,-23,23,-23v13,0,23,10,23,23v0,13,-10,23,-23,23xm46,-118v-15,0,-23,-9,-23,-22v0,-13,10,-23,23,-23v13,0,23,10,23,23v0,13,-8,22,-23,22","w":91},";":{"d":"46,-118v-15,0,-23,-9,-23,-22v0,-13,10,-23,23,-23v13,0,23,10,23,23v0,13,-8,22,-23,22xm27,49v0,-17,34,-24,24,-48v-31,6,-42,-41,-9,-42v50,9,23,90,-15,90","w":91},"<":{"d":"65,-110r89,53r0,27r-124,-73r0,-13r124,-72r0,26"},"=":{"d":"169,-151r0,22r-153,0r0,-22r153,0xm169,-91r0,22r-153,0r0,-22r153,0"},">":{"d":"31,-162r0,-26r123,73r0,12r-123,73r0,-27r88,-53"},"?":{"d":"63,-114v-32,2,-14,38,-15,51v-13,-7,-15,-27,-20,-42v3,-49,78,-29,79,-81v1,-45,-59,-24,-89,-41v-8,-17,12,-22,28,-22v76,-6,91,109,27,131v-3,1,-6,3,-10,4xm47,5v-12,-2,-20,-8,-20,-21v0,-13,9,-18,20,-20v11,2,20,7,20,20v0,13,-8,19,-20,21","w":136},"@":{"d":"187,65v72,0,110,-42,132,-95r13,0v-24,60,-68,108,-145,108v-100,0,-161,-59,-161,-156v0,-102,59,-166,161,-175v144,-13,172,200,57,245v-37,14,-75,-3,-56,-49v-24,8,-38,39,-66,46v-27,-5,-22,-56,-13,-78v19,-46,66,-88,127,-83v-4,43,-22,87,-27,132v-2,13,10,24,22,22v49,-7,70,-54,74,-107v9,-119,-161,-145,-223,-65v-22,29,-42,63,-42,112v0,89,58,143,147,143xm207,-154v-60,0,-85,47,-81,105v3,36,40,7,50,-7v4,-5,9,-10,15,-15v4,-27,15,-56,16,-83","w":349},"A":{"d":"54,-25v2,18,24,16,40,19v0,3,1,5,-2,6r-91,-1v3,-12,32,-8,35,-32r72,-208r-2,-7v12,1,29,-3,37,2r82,224v4,10,20,11,30,17v0,2,1,4,-1,5r-109,-1v0,-15,50,-1,41,-26r-27,-77v-12,-13,-48,-3,-70,-6v-5,1,-7,5,-9,8xm119,-212v-8,24,-28,60,-25,83v16,-3,51,8,54,-6","w":256},"B":{"d":"226,-77v0,98,-129,76,-224,76v-2,-6,3,-7,10,-6v18,-3,43,-5,43,-24r0,-185v1,-25,-22,-25,-45,-27v-1,-6,2,-7,9,-6v86,-3,225,-16,185,84v-8,8,-17,17,-28,21v25,14,50,30,50,67xm189,-73v2,-51,-46,-73,-99,-62r0,96v0,21,19,28,38,28v36,0,59,-26,61,-62xm119,-241v-13,3,-29,-4,-30,9r1,83v40,5,89,3,87,-42v-2,-34,-23,-49,-58,-50","w":244},"C":{"d":"156,5v-82,-4,-135,-45,-138,-127v-4,-123,125,-148,230,-119v5,14,0,43,2,59v-7,4,-8,-4,-11,-8v-16,-31,-38,-53,-80,-53v-68,0,-102,42,-102,110v0,74,36,125,111,125v46,0,71,-28,88,-58v4,-1,8,1,5,6r-27,55v-25,-6,-51,11,-78,10","w":275},"D":{"d":"277,-129v0,81,-57,130,-140,129r-129,-1v-3,-8,5,-7,14,-7v12,-2,23,-5,23,-20r0,-193v0,-20,-20,-19,-37,-21v0,-4,-1,-7,5,-6r121,-2v84,2,143,40,143,121xm84,-242v-4,0,-5,1,-5,5r0,215v2,15,22,14,40,14v76,-2,120,-42,120,-118v0,-87,-57,-125,-155,-116","w":292},"E":{"d":"186,-189v-8,-14,-5,-42,-26,-42v-25,0,-55,-3,-76,2v2,30,-4,67,2,93v37,-2,86,11,86,-29v2,0,6,-1,6,1v-1,25,1,54,-2,77v0,0,-5,0,-5,-1v5,-43,-53,-34,-87,-30r0,86v2,28,51,15,78,15v25,0,35,-20,37,-42v0,-4,6,-7,8,-3v-4,19,0,49,-9,62r-197,-1v-3,-11,12,-6,21,-7v16,-1,28,-5,28,-23r0,-186v0,-21,-20,-21,-37,-25v0,-2,-1,-5,1,-6r167,0v5,0,7,1,7,6v0,17,4,37,2,53r-4,0","w":222},"F":{"d":"182,-198v-4,-17,-10,-36,-34,-33v-22,2,-53,-4,-70,3r0,82v0,3,1,4,4,4v36,-5,92,14,94,-25v2,0,6,-1,5,2v-1,22,2,47,-1,67v-3,0,-5,0,-6,-2v3,-42,-57,-21,-92,-26v-2,0,-4,3,-4,5r0,91v1,18,21,19,36,24v0,3,1,6,-2,6r-97,-1v1,-13,28,-7,28,-31r0,-189v1,-17,-16,-18,-28,-21v0,-3,0,-5,2,-6r169,1v0,13,7,43,-4,49","w":205},"G":{"d":"151,5v-81,0,-131,-49,-131,-131v0,-117,119,-146,222,-113v-1,20,2,44,-1,62v-8,1,-7,-5,-8,-11v-12,-37,-37,-55,-75,-55v-67,0,-99,49,-99,115v0,72,35,125,115,120v14,-1,30,-6,37,-15v3,-46,3,-85,-46,-80v0,-2,-1,-7,2,-6r109,1v0,0,1,6,-2,6v-13,4,-28,5,-28,24r0,57v-23,16,-58,26,-95,26","w":284},"H":{"d":"78,-28v-1,19,18,19,32,22v0,2,1,5,-1,6r-98,-1v0,-2,-1,-6,1,-6v18,-1,31,-5,31,-25r0,-188v0,-17,-14,-20,-28,-23v0,-2,0,-5,2,-5r89,1v0,2,1,5,-1,5v-46,-1,-21,68,-27,108v44,3,95,0,141,1v8,-23,2,-65,2,-93v-4,-14,-27,-12,-40,-17v0,-2,0,-5,2,-5r102,1v0,2,1,5,-1,5v-17,0,-29,7,-28,25r0,185v1,20,16,23,34,26v0,2,1,6,-1,6r-113,-1v-2,-8,6,-6,14,-7v15,-1,31,-6,32,-22r0,-84v-1,-2,-1,-2,-3,-3v-45,3,-100,-4,-141,3r0,86","w":300},"I":{"d":"107,-242v-16,2,-28,5,-28,26r0,188v-2,18,14,20,28,22v0,2,1,7,-2,6r-89,-1v0,-2,-1,-6,1,-6v18,0,27,-6,27,-25r0,-188v0,-17,-13,-20,-28,-22v0,0,-1,-6,2,-6r89,2r0,4","w":122},"J":{"d":"11,95v32,-4,32,-41,32,-77r0,-238v2,-20,-19,-19,-35,-22v0,-2,-1,-6,1,-6r97,2v0,2,1,5,-1,5v-18,0,-27,6,-27,25r0,218v-6,58,-27,106,-87,110v-23,3,-50,-23,-23,-33v21,-8,27,13,43,16","w":121},"K":{"d":"7,-5v15,-4,37,-5,37,-23r0,-192v-1,-18,-22,-19,-37,-23v0,-2,-1,-5,1,-5r105,1v0,2,1,5,-1,5v-17,1,-36,4,-34,23v2,29,-8,73,5,93v38,-22,64,-58,81,-101v1,-14,-13,-14,-26,-15v0,-2,-1,-5,1,-6r103,1v-3,14,-40,5,-51,23v-20,33,-43,65,-68,92v32,31,59,59,85,98v11,17,33,27,59,29v0,2,1,5,-1,5r-117,-1v1,-12,40,-4,22,-26v-27,-32,-44,-77,-93,-88v4,44,-18,114,35,110v0,2,1,4,-1,5r-105,-1r0,-4","w":267},"L":{"d":"217,-57v-10,19,-19,41,-31,57r-179,-1v-3,-9,9,-6,16,-7v15,-3,27,-10,27,-26r0,-186v-2,-18,-24,-20,-41,-22v0,-3,0,-5,2,-6r120,2v2,6,-3,5,-9,5v-17,3,-38,-2,-38,21r0,195v0,4,5,9,9,8v44,-1,94,9,108,-28v4,-4,11,-20,16,-12","w":217},"M":{"d":"68,-193v-9,52,-6,114,-11,172v3,11,20,12,32,15v0,2,1,6,-1,6r-83,-1v0,-2,-1,-6,1,-6v53,-1,26,-77,38,-128r3,-89v0,-13,-14,-14,-23,-18v0,-2,-1,-5,1,-6v18,2,45,-5,57,4r85,187v1,0,4,-1,4,-3r85,-186v13,-3,43,-4,56,0v0,4,1,5,-6,6v-9,1,-21,7,-20,18r11,195v2,16,20,18,35,21v0,3,1,5,-2,6r-101,-1v0,-13,34,-1,33,-21r-10,-170r-89,191v-2,0,-7,2,-8,0","w":339},"N":{"d":"267,-5v0,11,-14,7,-17,1r-184,-203r1,186v7,10,23,13,38,15v0,3,1,6,-2,6r-92,-1v-3,-9,9,-5,17,-7v12,-4,14,-20,15,-36r0,-182v-1,-14,-22,-12,-32,-16v0,-2,-1,-5,1,-6r64,0r168,186v7,-32,-1,-84,2,-122v2,-37,-2,-60,-39,-58v0,-2,-1,-5,1,-6r93,2v0,2,1,5,-1,5v-13,2,-33,7,-33,21r0,215","w":307},"O":{"d":"292,-129v0,81,-56,134,-138,134v-79,0,-135,-46,-135,-131v0,-83,58,-129,143,-129v79,0,130,48,130,126xm149,-243v-64,0,-93,48,-93,111v0,69,35,124,106,124v64,0,93,-49,93,-113v0,-69,-36,-122,-106,-122","w":311},"P":{"d":"18,0v-3,0,-2,-3,-2,-6v15,-4,31,-6,30,-24r0,-186v1,-22,-12,-26,-35,-25v-3,0,-5,-2,-4,-6r120,-3v43,4,73,28,73,73v0,64,-55,78,-119,74v2,46,-15,101,43,97v0,2,1,5,-1,6r-105,0xm165,-181v0,-47,-33,-66,-83,-60v-1,37,-5,91,2,125v50,6,80,-19,81,-65","w":212},"Q":{"d":"300,69v-71,28,-99,-55,-164,-66v-66,-11,-117,-52,-117,-127v0,-82,55,-131,138,-131v82,0,134,48,134,129v0,69,-46,101,-94,126v36,23,60,54,103,69xm151,-243v-63,0,-95,47,-95,112v0,69,37,123,108,123v61,0,91,-48,91,-111v0,-72,-35,-124,-104,-124","w":310},"R":{"d":"9,0v-4,-5,2,-8,8,-8v15,0,26,-7,26,-22r0,-186v0,-21,-18,-23,-36,-26v-2,-6,3,-7,10,-6r106,-2v44,3,74,29,74,73v0,31,-20,45,-42,55v30,42,46,97,92,122v-66,17,-93,-69,-124,-112v-14,2,-37,-7,-46,1r0,81v-1,23,25,19,42,24v0,3,1,5,-2,6r-108,0xm162,-181v0,-46,-41,-71,-85,-57r1,114v42,11,84,-8,84,-57","w":249},"S":{"d":"158,-88v33,74,-65,114,-126,81v-4,0,-10,5,-11,-1r-5,-50v7,-5,10,9,12,13v11,46,109,57,109,-4v0,-78,-116,-67,-116,-149v0,-57,70,-66,118,-47v4,0,12,-4,11,3v-1,13,10,36,1,43v-13,-22,-28,-45,-62,-46v-40,-1,-51,47,-23,72v30,27,75,44,92,85","w":180},"T":{"d":"227,-248v11,4,15,-15,19,-1v1,20,7,43,6,61v-5,1,-5,-3,-6,-7v-4,-15,-8,-33,-24,-36r-71,1v-7,60,-2,134,-2,198v0,22,24,24,45,26v0,3,1,5,-2,6r-122,-1v-2,-7,5,-6,12,-6v16,-3,33,-8,33,-25r-2,-198v-21,-3,-48,0,-71,-1v-18,5,-22,24,-25,43v-5,1,-7,-1,-6,-6v5,-19,2,-46,11,-61v5,2,6,7,15,7r190,0","w":264},"U":{"d":"151,5v-61,0,-114,-23,-114,-84r0,-141v0,-17,-18,-19,-31,-22v0,0,-1,-6,2,-6r96,2v2,7,-6,5,-12,6v-13,1,-21,9,-21,23v1,95,-19,206,82,205v51,-1,86,-26,86,-76r-1,-125v1,-22,-19,-27,-38,-29v0,0,-1,-6,2,-6r88,2v0,2,1,5,-2,5v-19,-1,-31,8,-31,24r0,115v-1,69,-36,107,-106,107","w":293},"V":{"d":"205,-215v7,-22,-16,-23,-33,-27v0,-2,-1,-5,1,-6r91,2v0,10,-20,3,-24,13v-12,11,-17,29,-23,45r-69,187v-1,8,-20,9,-24,2r-97,-231v-5,-8,-17,-8,-26,-12v0,-2,-1,-6,1,-6r105,2v-3,12,-47,3,-34,35r69,164","w":264},"W":{"d":"346,-224v10,-20,-14,-15,-30,-18v0,-2,-1,-5,1,-6v26,1,56,-1,80,2v0,10,-25,1,-27,20r-100,230v-5,1,-18,4,-20,-3r-48,-115v-18,38,-30,83,-52,118v-4,1,-18,4,-19,-3r-98,-230v-10,-6,-22,-10,-34,-13v0,-2,-1,-6,1,-6r102,2v-6,10,-35,5,-23,35r67,162v1,2,5,3,6,0r39,-92v-14,-29,-21,-63,-39,-88v-8,-7,-21,-9,-32,-13v0,-2,-1,-6,1,-6r163,2v-3,11,-30,1,-34,22r-29,66v17,36,28,78,48,111v30,-54,50,-119,77,-177xm229,-233v-16,-20,-40,-3,-30,22r11,27v6,-16,15,-31,19,-49","w":397},"X":{"d":"71,-25v-10,18,14,16,28,19v0,2,1,5,-1,6r-97,-1v-2,-11,21,-4,26,-12v40,-30,64,-76,96,-114v-29,-35,-53,-74,-86,-105v-8,-7,-24,-6,-36,-10v0,-2,-1,-5,1,-6r118,2v1,11,-46,0,-29,23v17,23,32,48,52,67v21,-22,40,-47,56,-74v-1,-12,-18,-9,-28,-12v0,-2,-1,-5,1,-6r96,2v-21,11,-57,31,-70,55v-10,19,-32,37,-41,55r88,115v8,9,21,13,36,14v3,4,-1,7,-6,7r-98,-1v-3,-13,34,1,23,-23r-64,-83v0,0,-4,-1,-4,2","w":283},"Y":{"d":"157,-97v-1,45,-8,88,36,93v0,4,-3,3,-6,4r-99,-1v-1,0,-2,-2,-2,-4v14,-8,39,-4,37,-27v-2,-19,2,-43,-1,-60r-78,-125v-9,-14,-25,-21,-43,-25v0,-2,-1,-7,2,-6v33,2,75,-3,104,3v-4,9,-38,4,-25,25r63,100v23,-32,43,-67,60,-105v2,-18,-22,-9,-25,-22v25,-1,67,-5,88,2v-11,10,-34,12,-42,28","w":268},"Z":{"d":"236,-10v0,5,-1,10,-5,10r-217,-3v0,-5,-1,-10,2,-12r165,-214v-34,-4,-94,-6,-127,2v-14,4,-12,25,-17,39v0,1,-6,2,-7,0v4,-18,-4,-48,7,-60r192,1v0,5,3,10,-1,14r-158,204v-4,4,-4,11,5,11r124,0v29,-2,30,-33,36,-57v6,-2,5,4,5,10","w":256},"[":{"d":"123,-304r0,15v-21,3,-60,-10,-60,13r0,308v1,24,43,9,64,13r0,15r-91,0r0,-364r87,0","w":130},"\\":{"d":"24,-255r-23,0r92,260r23,0","w":116},"]":{"d":"67,-276v0,-24,-39,-9,-60,-13r0,-15r87,0r0,364r-91,0r0,-15v22,-4,64,11,64,-13r0,-308","w":130},"^":{"d":"93,-208r-54,89r-26,0r74,-123r11,0r73,123r-26,0"},"_":{"d":"-3,36r184,0r0,20r-184,0r0,-20","w":178},"`":{"d":"34,-226v-14,-7,-9,-38,10,-27v15,18,34,41,44,60v-2,1,-4,7,-6,5","w":123},"a":{"d":"121,-29v1,18,27,2,30,7v-6,17,-43,40,-53,14r-5,-12v-15,8,-22,24,-44,24v-22,0,-37,-14,-37,-35v0,-42,61,-30,82,-55v1,-32,2,-65,-28,-65v-15,0,-25,13,-21,29v-9,2,-25,20,-29,6v3,-52,105,-67,105,-6r0,93xm40,-35v0,32,49,23,54,0v-1,-11,4,-35,-3,-37v-17,13,-51,11,-51,37","w":155},"b":{"d":"174,-83v3,76,-79,106,-146,77r0,-240v3,-16,-32,-7,-23,-21r47,-22v2,0,3,1,3,4v2,46,-3,101,3,143v18,-7,32,-21,56,-21v41,0,58,38,60,80xm149,-74v5,-54,-57,-89,-94,-52v1,52,-13,120,43,117v35,-2,48,-31,51,-65","w":193},"c":{"d":"83,5v-43,0,-66,-32,-67,-74v-2,-66,32,-97,100,-94v16,1,33,7,34,21v-11,31,-37,-8,-54,-10v-34,5,-50,31,-50,68v0,40,16,69,57,69v23,1,34,-13,45,-25v2,0,5,2,4,5v-14,22,-36,40,-69,40","w":164},"d":{"d":"134,-246v1,-16,-33,-7,-23,-21r47,-22v2,0,3,1,3,4r0,250v0,16,15,14,27,15v0,3,0,3,-3,4v-16,5,-37,20,-51,19v-2,-6,4,-19,-3,-20v-15,10,-31,22,-55,22v-43,0,-61,-36,-61,-78v0,-62,54,-98,118,-80v3,-28,-2,-63,1,-93xm93,-146v-36,0,-49,31,-52,65v-4,53,54,86,93,53r-1,-94v-9,-12,-20,-24,-40,-24","w":191},"e":{"d":"79,5v-42,0,-62,-34,-67,-76v-11,-87,117,-130,135,-37v0,4,-1,7,-4,7r-102,0v-23,62,56,115,101,64r4,4v-16,18,-36,38,-67,38xm80,-151v-22,0,-34,16,-37,38v-1,2,1,3,3,3r64,0v3,0,5,-1,5,-4v-2,-21,-13,-37,-35,-37","w":163},"f":{"d":"62,-158v23,1,53,-8,46,22v-12,4,-35,-3,-46,3r0,103v-1,26,32,19,46,29v-30,3,-67,0,-99,1v-1,0,-2,-1,-2,-3v10,-7,29,-4,27,-24v-3,-35,4,-77,-2,-108v-9,-1,-24,4,-25,-5v4,-12,27,-3,27,-24v0,-72,27,-130,95,-130v14,0,35,6,31,22v-9,34,-28,-2,-50,-2v-58,0,-48,61,-48,116","w":109},"g":{"d":"20,-97v-3,-60,84,-85,124,-49v22,2,62,-15,56,20r-43,0v26,48,-27,102,-88,84v-7,8,-24,10,-26,22v6,22,62,16,93,16v35,0,58,14,60,45v-11,51,-57,67,-118,71v-48,3,-87,-37,-50,-68v11,-8,21,-15,30,-26v-19,-3,-38,-11,-41,-30v2,-23,31,-21,44,-32v-23,-9,-40,-25,-41,-53xm67,20v-10,12,-26,17,-28,37v9,60,134,55,134,-8v0,-42,-63,-21,-106,-29xm94,-47v29,0,42,-22,42,-50v0,-33,-13,-58,-46,-58v-27,0,-41,18,-41,49v1,31,13,59,45,59","w":201},"h":{"d":"60,-27v-2,19,17,17,27,24v0,2,-1,3,-2,3r-78,0v-1,0,-2,-1,-2,-3v10,-7,28,-5,28,-24r0,-219v2,-16,-31,-7,-24,-21r48,-22v2,0,3,1,3,4v3,49,-4,108,3,153v13,-14,25,-29,49,-31v66,-4,52,74,53,136v-4,22,25,14,26,27r-79,0v-1,0,-2,-1,-2,-3v10,-7,30,-6,28,-24v-6,-45,20,-123,-33,-120v-22,1,-45,15,-45,37r0,83","w":197},"i":{"d":"65,-27v-4,22,25,14,26,27r-79,0v2,-14,26,-4,26,-27r0,-93v3,-16,-32,-7,-23,-21r47,-22v2,0,3,1,3,4r0,132xm50,-212v-10,0,-20,-6,-19,-18v-1,-10,8,-17,18,-17v22,0,21,35,1,35","w":101},"j":{"d":"38,-120v3,-16,-32,-7,-23,-21r47,-22v2,0,3,1,3,4v-9,109,37,271,-80,271v-24,0,-41,-36,-11,-37v15,6,21,23,45,20v17,-3,19,-22,19,-39r0,-176xm47,-212v-10,-1,-19,-7,-19,-18v0,-11,8,-18,19,-17v23,0,19,35,0,35","w":101},"k":{"d":"111,0v-8,-10,27,-5,13,-20r-59,-64v-7,25,-10,81,25,81v-1,1,0,3,-2,3r-79,0v2,-14,26,-4,26,-27r0,-219v4,-16,-32,-7,-23,-21r47,-22v2,0,3,1,3,4r0,175v1,5,4,7,9,7v20,-7,40,-21,47,-40v-1,-9,-20,-2,-21,-11v15,-7,63,-8,80,0v-8,8,-28,7,-38,15r-50,39v24,33,55,61,84,89v4,5,24,3,15,11r-77,0","w":192},"l":{"d":"58,-27v-4,22,25,14,26,27r-79,0v2,-14,26,-4,26,-27r0,-219v3,-16,-32,-7,-23,-21r47,-22v2,0,3,1,3,4r0,258","w":91},"m":{"d":"35,-128v1,-17,-24,-6,-26,-20r50,-24v8,5,0,26,4,35v25,-16,81,-44,98,-4v24,8,40,-26,72,-22v52,7,36,81,37,136v0,20,22,16,34,24v0,2,-1,3,-2,3r-85,0v7,-14,32,-8,27,-41v-6,-42,14,-106,-35,-105v-15,5,-30,10,-43,20r0,99v-1,18,17,18,28,24v0,2,-1,3,-2,3r-78,0v-1,0,-2,-1,-2,-3v9,-7,29,-5,27,-24v-5,-47,19,-122,-34,-119v-17,1,-33,12,-43,22r0,97v-4,22,25,14,26,27r-79,0v-1,0,-2,-1,-2,-3v10,-7,28,-5,28,-24r0,-101","w":304},"n":{"d":"36,-128v3,-17,-32,-9,-23,-21r48,-23v9,3,-4,34,7,33v21,-8,35,-24,62,-24v53,0,38,81,38,136v0,21,21,16,33,24v0,2,-1,3,-2,3r-84,0v-1,0,-2,-1,-2,-3v37,-3,28,-56,28,-101v0,-23,-7,-45,-35,-42v-14,5,-30,9,-42,20r0,99v-2,19,17,17,27,24v0,2,-1,3,-2,3r-78,0v-1,0,-2,-1,-2,-3v10,-7,27,-4,27,-24r0,-101","w":204},"o":{"d":"97,5v-52,0,-84,-34,-84,-86v0,-47,33,-82,82,-82v51,0,86,32,86,83v0,52,-33,85,-84,85xm89,-152v-33,0,-47,29,-47,60v0,45,17,87,62,87v33,0,47,-27,47,-61v0,-46,-19,-86,-62,-86","w":194},"p":{"d":"172,-82v0,60,-49,98,-112,83v-4,0,-3,3,-3,6v1,45,-13,98,37,99v0,2,-1,3,-2,3r-88,0v-1,0,-2,-1,-2,-3v10,-7,27,-4,27,-24r0,-210v3,-17,-30,-7,-23,-22r48,-22v8,3,-2,23,5,29v18,-9,32,-20,56,-20v40,0,57,40,57,81xm145,-64v-4,-41,-11,-77,-51,-80v-16,-1,-29,5,-37,13r0,106v27,33,93,13,88,-39","w":191},"q":{"d":"144,-152v11,1,11,-15,20,-11r0,245v-2,19,17,17,27,24v0,2,-1,3,-2,3r-94,0v-2,-8,7,-5,14,-7v12,-3,28,-5,28,-20r-1,-101v-20,10,-33,22,-59,24v-40,-5,-57,-38,-59,-80v-4,-67,67,-107,126,-77xm44,-73v-2,51,57,74,93,43v-2,-53,14,-126,-42,-123v-38,2,-50,39,-51,80","w":192},"r":{"d":"36,-120v3,-16,-31,-7,-23,-21r48,-22v8,7,-4,50,13,24v6,-9,13,-20,26,-21v21,-1,44,20,19,34v-20,-15,-55,-8,-55,20v0,45,-15,102,37,103v0,2,-1,3,-2,3r-88,0v-1,0,-2,-1,-2,-3v10,-7,27,-4,27,-24r0,-93","w":131},"s":{"d":"94,-116v-6,-26,-56,-55,-61,-6v17,36,73,32,74,83v1,39,-45,52,-79,38v-4,1,-13,12,-13,1v0,-13,-8,-33,-1,-41v13,14,16,38,44,37v15,-1,24,-12,25,-27v-6,-45,-71,-36,-71,-88v0,-38,60,-59,85,-31v-1,11,6,29,-3,34","w":120},"t":{"d":"54,-37v1,41,39,12,54,9v-6,17,-21,33,-43,33v-58,0,-33,-86,-38,-140v-8,0,-23,3,-18,-7v20,-12,30,-32,49,-45v7,7,-10,24,-1,29v21,2,60,-12,51,23v-17,1,-39,-2,-54,1r0,97","w":113},"u":{"d":"102,-3v-23,11,-73,12,-73,-19r0,-107v-1,-9,-11,-15,-21,-15v-1,-3,-2,-7,2,-7r44,-12v6,36,-2,85,2,125v3,32,60,30,77,9r0,-100v3,-14,-28,-11,-19,-22v15,-2,33,-13,46,-10r0,126v0,16,15,14,27,15v0,3,0,3,-3,4v-16,5,-37,20,-51,19r0,-20v-13,2,-21,9,-31,14","w":197},"v":{"d":"162,-147v-27,45,-42,103,-65,152v-8,0,-18,2,-18,-6v-19,-46,-31,-99,-55,-140v-5,-9,-20,-6,-24,-14v19,-5,65,-6,84,0v-4,9,-33,-1,-25,19v13,33,22,72,39,102v15,-32,30,-64,37,-99v3,-17,-19,-13,-27,-22v15,-7,51,-3,72,-2v2,10,-14,3,-18,10","w":182},"w":{"d":"143,-106v-16,36,-27,82,-45,111v-8,0,-18,2,-17,-6v-19,-46,-32,-99,-56,-140v-5,-9,-18,-7,-24,-14v19,-5,65,-6,84,0v-4,10,-33,-2,-25,19r39,102v16,-28,26,-64,37,-93v-5,-12,-14,-22,-29,-24v-2,1,-5,-2,-4,-4v19,-5,65,-6,84,0v-4,9,-33,-1,-25,19v13,33,22,72,39,102v15,-32,30,-64,37,-99v3,-17,-19,-13,-27,-22v15,-7,51,-3,72,-2v-5,10,-31,10,-31,33r-52,129v-8,0,-18,2,-18,-6","w":288},"x":{"d":"103,0v-8,-11,31,-3,13,-23v-13,-13,-22,-31,-37,-42v-13,15,-28,28,-36,48v-1,12,23,7,20,17v-18,-2,-46,5,-59,-3v28,-18,53,-47,68,-75v-23,-26,-41,-56,-69,-77v15,-5,56,-6,71,0v-6,4,-23,5,-15,18v12,11,19,34,35,37v9,-15,35,-26,27,-47v-5,-3,-15,-2,-15,-11r57,0v-2,13,-23,11,-29,26v-7,17,-44,35,-29,52v23,25,40,55,68,74v0,2,3,6,-1,6r-69,0","w":178},"y":{"d":"60,105v-8,16,-42,3,-28,-14v9,-7,24,-8,28,-20v8,-25,32,-51,27,-77r-67,-135v-5,-9,-20,-6,-24,-14v18,-5,64,-6,83,0v-3,10,-30,-4,-25,19r49,102v16,-31,28,-66,38,-99v2,-17,-20,-14,-28,-22v16,-5,57,-6,73,0v-2,4,-6,4,-12,5v-12,2,-15,17,-20,27","w":190},"z":{"d":"157,-43v-6,14,-9,32,-18,43r-124,0v-4,0,-5,-5,-3,-8r93,-130v-15,-3,-40,0,-59,-1v-24,-2,-16,29,-31,35r11,-61v20,20,92,-1,123,12v-24,47,-72,91,-94,136r68,0v20,1,18,-30,34,-26","w":160},"{":{"d":"54,-1v0,-39,37,-106,-13,-116v-6,-1,-6,-13,0,-14v51,-5,13,-73,13,-109v0,-45,41,-62,89,-62v4,0,6,2,6,6v1,9,-9,6,-17,7v-27,4,-47,17,-47,46v0,44,18,94,-16,117v1,17,26,24,23,50r-7,72v0,40,32,49,64,56v3,12,-5,12,-16,10v-41,-6,-79,-19,-79,-63","w":185},"|":{"d":"26,-289r23,0r0,295r-23,0r0,-295","w":75},"}":{"d":"145,-131v6,1,7,13,0,14v-50,10,-13,78,-13,116v0,49,-44,62,-93,64v-3,0,-2,-7,-2,-11v37,-5,73,-24,63,-76v-6,-37,-10,-79,17,-96v0,-17,-25,-24,-23,-50v2,-25,9,-47,7,-73v-2,-32,-24,-46,-60,-46v-6,0,-6,-13,2,-13v48,2,89,17,89,62v0,38,-37,99,13,109","w":186},"~":{"d":"128,-106v16,0,19,-15,20,-31r20,0v0,30,-12,55,-39,55v-32,0,-42,-32,-73,-32v-15,0,-18,15,-19,31r-21,0v1,-33,14,-58,48,-55v25,2,38,26,64,32"},"\u00a0":{"w":96},"\u00a1":{"d":"43,-163v-12,1,-20,8,-20,21v0,13,7,20,20,20v13,-0,20,-8,20,-21v0,-13,-9,-18,-20,-20xm43,-83v-4,-0,-6,2,-6,6r-13,179v5,4,28,3,37,-0r-13,-179v0,-3,-1,-6,-5,-6","w":85},"\u00a2":{"d":"41,-10v-42,-34,-27,-139,23,-146v10,-4,20,-6,31,-7r13,-34r22,0r-12,34v16,1,30,8,32,21v-4,24,-32,6,-38,-3r-43,120v22,19,68,8,79,-15v2,0,5,2,4,5v-16,27,-52,49,-92,36r-22,62r-23,0xm91,-151v-41,7,-55,65,-37,106","w":164},"\u00a3":{"d":"20,-23v-1,-31,43,-40,64,-24v4,-26,-8,-45,-16,-63v-13,-1,-32,3,-41,-2v-2,-16,24,-5,36,-8v-31,-38,-20,-122,42,-122v34,0,77,22,57,52v-31,1,-22,-48,-61,-43v-61,7,-24,87,-6,113v13,3,42,-8,37,10r-33,0v9,19,6,50,-1,70v11,10,22,22,42,22v19,0,27,-16,31,-30r7,0v3,51,-68,70,-90,29v-10,25,-66,36,-68,-4xm79,-29v-8,-20,-50,-22,-50,7v6,34,47,13,50,-7"},"\u00a4":{"d":"43,-83v-15,-18,-15,-58,2,-74r-34,-35r11,-11r34,35v18,-16,54,-18,74,-1r34,-34r11,11r-34,34v17,16,19,59,1,76r33,33r-11,11r-33,-33v-17,18,-60,15,-77,-1r-34,34r-11,-11xm93,-164v-27,0,-44,18,-44,44v0,27,18,45,44,45v26,0,45,-17,45,-45v0,-27,-18,-44,-45,-44"},"\u00a5":{"d":"49,-56v0,-6,-1,-11,6,-11r68,0v-1,-9,2,-21,-2,-27r-66,0v-7,1,-6,-5,-6,-11v11,-10,44,-1,63,-4r-68,-108v-9,-14,-25,-21,-43,-25v0,-2,-1,-7,2,-6v33,2,75,-3,104,3v-4,9,-38,4,-25,25r63,100v23,-32,43,-67,60,-105v2,-18,-22,-9,-25,-22v25,-1,67,-5,88,2v-11,10,-34,12,-42,28r-62,108v21,2,54,-5,67,4v0,6,0,12,-6,11r-68,0r0,27r68,0v6,0,6,5,6,11v-15,10,-51,1,-74,4v-7,35,14,40,36,48v0,4,-3,3,-6,4r-99,-1v-1,0,-2,-2,-2,-4v14,-8,40,-4,37,-27r0,-20r-68,0v-3,0,-6,-1,-6,-4","w":275},"\u00a6":{"d":"81,-289r0,132r-22,0r0,-132r22,0xm81,-126r0,132r-22,0r0,-132r22,0","w":138},"\u00a7":{"d":"101,-267v-80,10,-8,98,11,123v29,38,61,78,61,143v0,59,-39,101,-100,101v-24,0,-52,-9,-51,-32v21,-28,39,19,66,19v35,0,52,-39,29,-64v-36,-67,-98,-103,-101,-200v-2,-75,85,-133,149,-83v8,12,-2,23,-16,22v-17,-6,-23,-32,-48,-29xm142,49v52,-117,-70,-179,-96,-277v-51,120,70,177,96,277","w":195},"\u00a8":{"d":"97,-237v28,0,25,42,0,42v-12,-1,-21,-8,-21,-21v0,-12,9,-21,21,-21xm26,-237v22,-2,28,33,9,40v-14,6,-30,-3,-29,-19v0,-13,9,-20,20,-21","w":123},"\u00a9":{"d":"150,7v-82,0,-134,-52,-134,-134v0,-82,52,-134,134,-134v81,0,133,51,133,134v0,82,-53,134,-133,134xm149,-244v-71,0,-116,46,-116,117v0,72,46,117,116,117v71,0,117,-45,117,-117v0,-72,-45,-117,-117,-117xm205,-53v-65,16,-142,0,-142,-76v0,-80,87,-101,152,-75v-1,12,2,49,-8,31v-11,-19,-26,-35,-52,-35v-44,0,-67,28,-67,73v0,47,24,79,73,81v33,1,43,-28,61,-37v-4,13,-12,25,-17,38","w":301},"\u00aa":{"d":"82,-177v1,12,19,1,21,5v-5,12,-30,27,-37,10r-3,-9v-10,6,-15,17,-30,17v-15,-0,-26,-10,-26,-24v0,-29,42,-21,56,-38v1,-22,2,-45,-19,-45v-10,0,-17,9,-14,20v-6,2,-17,14,-20,4v2,-35,72,-45,72,-4r0,64xm26,-181v0,22,34,16,37,0v-0,-8,3,-24,-2,-25v-11,9,-35,7,-35,25","w":103},"\u00ab":{"d":"70,-163r-33,66r33,66r-8,0r-50,-66r50,-66r8,0xm119,-163r-33,66r34,66r-9,0r-49,-66r49,-66r8,0","w":139},"\u00ac":{"d":"167,-121r0,89r-22,0r0,-67r-130,0r0,-22r152,0"},"\u00ad":{"d":"146,-102r0,24r-131,0r0,-24r131,0","w":160},"\u00ae":{"d":"150,7v-82,0,-134,-52,-134,-134v0,-82,52,-134,134,-134v81,0,133,51,133,134v0,82,-53,134,-133,134xm149,-244v-71,0,-116,46,-116,117v0,72,46,117,116,117v71,0,117,-45,117,-117v0,-72,-45,-117,-117,-117xm80,-56v-2,-2,-1,-5,2,-5v9,-1,18,-2,18,-13r0,-112v0,-12,-10,-14,-21,-15v-1,-4,1,-5,6,-4v49,-2,107,-9,107,42v1,21,-12,27,-25,34v17,26,29,57,56,73v-42,10,-53,-44,-75,-67v-8,1,-22,-5,-27,0v2,28,-12,66,25,63v0,2,0,3,-1,4r-65,0xm171,-165v0,-28,-24,-42,-50,-34r0,69v29,4,50,-5,50,-35","w":299},"\u00af":{"d":"5,-232r113,0r0,22r-113,0r0,-22","w":122},"\u00b0":{"d":"92,-229v-17,0,-27,11,-27,27v0,39,55,33,55,0v-3,-15,-10,-27,-28,-27xm92,-162v-24,0,-40,-16,-40,-40v0,-24,15,-40,40,-40v25,0,40,15,40,40v0,25,-16,40,-40,40"},"\u00b1":{"d":"15,-121r66,0r0,-65r23,0r0,65r65,0r0,22r-65,0r0,67r-23,0r0,-67r-66,0r0,-22xm15,-22r154,0r0,22r-154,0r0,-22"},"\u00b2":{"d":"25,-111v28,-4,77,13,79,-18r4,0v-3,10,-2,24,-7,32r-92,0v17,-39,75,-52,75,-100v0,-41,-64,-41,-68,-3v-3,2,-7,3,-5,-3v7,-22,21,-39,48,-39v38,0,59,44,33,68","w":116},"\u00b3":{"d":"76,-184v54,17,21,93,-28,90v-17,-1,-36,-2,-40,-17v12,-20,25,14,46,10v36,1,47,-71,6,-72v-8,-1,-15,8,-18,3v20,-10,52,-53,10,-61v-16,1,-27,10,-32,22v-3,0,-5,-1,-5,-3v6,-28,70,-47,75,-6v-2,17,-13,26,-24,33","w":116},"\u00b4":{"d":"68,-247v6,-13,26,-8,26,5v-12,25,-40,41,-60,54v-1,-2,-4,-3,-4,-7","w":123},"\u00b5":{"d":"55,-38v4,33,61,30,76,9v2,-42,-4,-92,2,-129r25,0r0,123v1,15,14,14,27,15v0,0,1,3,-2,4v-17,5,-37,20,-52,19r0,-20v-30,8,-41,27,-76,20r-2,100r-25,9r1,-270v8,2,23,-4,26,3r0,117","w":193},"\u00b6":{"d":"18,-209v0,-84,87,-69,167,-71v6,-1,4,8,3,12v-7,2,-18,1,-27,1r-3,321v-6,-1,-14,3,-13,-6r0,-314r-29,0r0,319v-4,2,-18,4,-15,-5r0,-195v-46,-1,-83,-13,-83,-62","w":195},"\u00b7":{"d":"46,-96v-13,0,-23,-10,-23,-23v0,-13,10,-23,23,-23v13,0,23,10,23,23v0,13,-10,23,-23,23","w":91},"\u00b8":{"d":"54,72v19,-12,2,-35,-18,-34r31,-38r18,0r-24,27v13,4,24,12,25,27v-4,29,-31,36,-59,40v-7,1,-13,-7,-7,-12v11,-3,25,-4,34,-10","w":123},"\u00b9":{"d":"26,-97v2,-10,29,4,28,-13r0,-114v-9,5,-23,21,-32,16v14,-11,27,-22,40,-34v3,1,8,-2,8,2r0,135v0,9,25,-2,23,8r-67,0","w":116},"\u00ba":{"d":"120,-213v5,65,-93,78,-111,23v-13,-40,12,-79,52,-79v35,0,56,21,59,56xm57,-262v-48,6,-39,102,10,101v52,-6,37,-100,-10,-101","w":133},"\u00bb":{"d":"78,-163r49,66r-49,66r-9,0r33,-66r-33,-66r9,0xm28,-163r50,66r-50,66r-9,0r34,-66r-33,-66r8,0","w":139},"\u00bc":{"d":"232,-260r23,0r-194,270r-22,0xm21,-97v2,-10,29,4,28,-13r0,-114v-9,5,-23,21,-32,16v14,-11,27,-22,40,-34v3,1,8,-2,8,2r0,135v0,9,25,-2,23,8r-67,0xm222,-147v1,-2,8,-4,9,0v2,29,-4,65,2,90v9,0,29,-3,20,11v-7,1,-19,-3,-22,2v-1,14,3,34,-2,44v-5,-1,-14,3,-14,-3r0,-43v-19,-3,-50,7,-62,-4xm212,-122v-16,18,-32,42,-45,64v12,1,39,5,48,-2r0,-61v0,-1,-2,-1,-3,-1","w":272},"\u00bd":{"d":"218,-260r23,0r-194,270r-22,0xm176,-14v28,-4,77,13,79,-18r4,0v-3,10,-2,24,-7,32r-92,0v17,-39,75,-52,75,-100v0,-41,-64,-41,-68,-3v-3,2,-7,3,-5,-3v7,-22,21,-39,48,-39v38,0,59,44,33,68xm17,-97v2,-10,29,4,28,-13r0,-114v-9,5,-23,21,-32,16v14,-11,27,-22,40,-34v3,1,8,-2,8,2r0,135v0,9,25,-2,23,8r-67,0","w":272},"\u00be":{"d":"234,-260r23,0r-194,270r-22,0xm77,-184v54,17,21,93,-28,90v-17,-1,-36,-2,-40,-17v12,-20,25,14,46,10v36,1,47,-71,6,-72v-8,-1,-15,8,-18,3v20,-10,52,-53,10,-61v-16,1,-27,10,-32,22v-3,0,-5,-1,-5,-3v6,-28,70,-47,75,-6v-2,17,-13,26,-24,33xm222,-147v1,-2,8,-4,9,0v2,29,-4,65,2,90v9,0,29,-3,20,11v-7,1,-19,-3,-22,2v-1,14,3,34,-2,44v-5,-1,-14,3,-14,-3r0,-43v-19,-3,-50,7,-62,-4xm212,-122v-16,18,-32,42,-45,64v12,1,39,5,48,-2r0,-61v0,-1,-2,-1,-3,-1","w":272},"\u00bf":{"d":"86,-93v12,-3,22,24,22,39v0,51,-78,29,-78,82v-1,38,42,32,78,35v7,0,13,5,13,12v-1,14,-15,15,-30,15v-61,0,-90,-75,-50,-115v20,-20,75,-23,45,-68xm70,-143v0,-28,41,-23,40,0v0,12,-8,21,-20,21v-12,0,-20,-7,-20,-21","w":136},"\u00c0":{"d":"54,-25v2,18,24,16,40,19v0,3,1,5,-2,6r-91,-1v3,-12,32,-8,35,-32r72,-208r-2,-7v12,1,29,-3,37,2r82,224v4,10,20,11,30,17v0,2,1,4,-1,5r-109,-1v0,-15,50,-1,41,-26r-27,-77v-12,-13,-48,-3,-70,-6v-5,1,-7,5,-9,8xm119,-212v-8,24,-28,60,-25,83v16,-3,51,8,54,-6xm94,-314v-14,-7,-9,-38,10,-27v15,18,34,41,44,60v-2,1,-4,7,-6,5","w":256},"\u00c1":{"d":"54,-25v2,18,24,16,40,19v0,3,1,5,-2,6r-91,-1v3,-12,32,-8,35,-32r72,-208r-2,-7v12,1,29,-3,37,2r82,224v4,10,20,11,30,17v0,2,1,4,-1,5r-109,-1v0,-15,50,-1,41,-26r-27,-77v-12,-13,-48,-3,-70,-6v-5,1,-7,5,-9,8xm119,-212v-8,24,-28,60,-25,83v16,-3,51,8,54,-6xm158,-335v6,-13,26,-8,26,5v-12,25,-40,41,-60,54v-1,-2,-4,-3,-4,-7","w":256},"\u00c2":{"d":"54,-25v2,18,24,16,40,19v0,3,1,5,-2,6r-91,-1v3,-12,32,-8,35,-32r72,-208r-2,-7v12,1,29,-3,37,2r82,224v4,10,20,11,30,17v0,2,1,4,-1,5r-109,-1v0,-15,50,-1,41,-26r-27,-77v-12,-13,-48,-3,-70,-6v-5,1,-7,5,-9,8xm119,-212v-8,24,-28,60,-25,83v16,-3,51,8,54,-6xm174,-279v-15,10,-34,-29,-49,-39r-43,44v-3,-2,-7,-5,-3,-8v17,-18,27,-50,48,-59v15,21,33,39,47,62","w":256},"\u00c3":{"d":"54,-25v2,18,24,16,40,19v0,3,1,5,-2,6r-91,-1v3,-12,32,-8,35,-32r72,-208r-2,-7v12,1,29,-3,37,2r82,224v4,10,20,11,30,17v0,2,1,4,-1,5r-109,-1v0,-15,50,-1,41,-26r-27,-77v-12,-13,-48,-3,-70,-6v-5,1,-7,5,-9,8xm119,-212v-8,24,-28,60,-25,83v16,-3,51,8,54,-6xm162,-318v14,2,11,-33,22,-15v0,20,-10,35,-29,35v-27,0,-63,-37,-69,4v-3,0,-8,3,-8,-2v1,-21,8,-41,28,-41v22,0,34,17,56,19","w":256},"\u00c4":{"d":"54,-25v2,18,24,16,40,19v0,3,1,5,-2,6r-91,-1v3,-12,32,-8,35,-32r72,-208r-2,-7v12,1,29,-3,37,2r82,224v4,10,20,11,30,17v0,2,1,4,-1,5r-109,-1v0,-15,50,-1,41,-26r-27,-77v-12,-13,-48,-3,-70,-6v-5,1,-7,5,-9,8xm119,-212v-8,24,-28,60,-25,83v16,-3,51,8,54,-6xm164,-337v28,0,25,42,0,42v-12,-1,-21,-8,-21,-21v0,-12,9,-21,21,-21xm93,-337v22,-2,28,33,9,40v-14,6,-30,-3,-29,-19v0,-13,9,-20,20,-21","w":256},"\u00c5":{"d":"54,-25v2,18,24,16,40,19v0,3,1,5,-2,6r-91,-1v3,-12,32,-8,35,-32r72,-208r-2,-7v12,1,29,-3,37,2r82,224v4,10,20,11,30,17v0,2,1,4,-1,5r-109,-1v0,-15,50,-1,41,-26r-27,-77v-12,-13,-48,-3,-70,-6v-5,1,-7,5,-9,8xm119,-212v-8,24,-28,60,-25,83v16,-3,51,8,54,-6xm159,-316v2,34,-51,43,-62,13v-9,-22,6,-46,30,-45v20,0,30,14,32,32xm147,-316v0,-27,-41,-25,-41,0v0,27,41,25,41,0","w":256},"\u00c6":{"d":"303,-189v-7,-14,-4,-42,-26,-42v-25,0,-55,-3,-76,2v2,30,-4,67,2,93v36,-2,86,12,84,-29v0,0,6,-1,6,2v-2,24,4,56,-2,76v-2,0,-5,1,-5,-1v5,-44,-50,-30,-85,-30r0,86v2,28,51,12,78,15v25,2,35,-20,37,-42v0,-4,6,-7,8,-3v-3,20,-2,47,-8,62r-196,0v-8,0,-7,-8,0,-8v24,0,47,1,47,-23r0,-79v-22,3,-56,-8,-66,8r-47,80v0,20,36,6,40,21v-27,0,-71,5,-94,-2v9,-11,33,-8,35,-30r117,-195v3,-21,-32,-4,-38,-19v58,-4,124,0,184,-1v5,0,7,1,7,6v0,17,4,37,2,53r-4,0xm165,-212v-2,2,-7,2,-7,5r-48,79v14,5,39,0,57,2v-1,-28,3,-62,-2,-86","w":339},"\u00c7":{"d":"136,3v-68,-10,-116,-51,-118,-125v-4,-123,125,-148,230,-119v5,14,0,43,2,59v-7,4,-8,-4,-11,-8v-16,-31,-38,-53,-80,-53v-68,0,-102,42,-102,110v0,74,36,125,111,125v46,0,71,-28,88,-58v4,-1,8,1,5,6r-27,55v-26,-6,-52,12,-82,10r-19,22v13,4,24,12,25,27v-4,28,-30,40,-59,40v-14,0,-12,-12,0,-14v13,-2,36,-4,35,-23v-1,-12,-13,-18,-26,-19","w":275},"\u00c8":{"d":"186,-189v-8,-14,-5,-42,-26,-42v-25,0,-55,-3,-76,2v2,30,-4,67,2,93v37,-2,86,11,86,-29v2,0,6,-1,6,1v-1,25,1,54,-2,77v0,0,-5,0,-5,-1v5,-43,-53,-34,-87,-30r0,86v2,28,51,15,78,15v25,0,35,-20,37,-42v0,-4,6,-7,8,-3v-4,19,0,49,-9,62r-197,-1v-3,-11,12,-6,21,-7v16,-1,28,-5,28,-23r0,-186v0,-21,-20,-21,-37,-25v0,-2,-1,-5,1,-6r167,0v5,0,7,1,7,6v0,17,4,37,2,53r-4,0xm82,-314v-14,-7,-9,-38,10,-27v15,18,34,41,44,60v-2,1,-4,7,-6,5","w":222},"\u00c9":{"d":"186,-189v-8,-14,-5,-42,-26,-42v-25,0,-55,-3,-76,2v2,30,-4,67,2,93v37,-2,86,11,86,-29v2,0,6,-1,6,1v-1,25,1,54,-2,77v0,0,-5,0,-5,-1v5,-43,-53,-34,-87,-30r0,86v2,28,51,15,78,15v25,0,35,-20,37,-42v0,-4,6,-7,8,-3v-4,19,0,49,-9,62r-197,-1v-3,-11,12,-6,21,-7v16,-1,28,-5,28,-23r0,-186v0,-21,-20,-21,-37,-25v0,-2,-1,-5,1,-6r167,0v5,0,7,1,7,6v0,17,4,37,2,53r-4,0xm126,-335v6,-13,26,-8,26,5v-12,25,-40,41,-60,54v-1,-2,-4,-3,-4,-7","w":222},"\u00ca":{"d":"186,-189v-8,-14,-5,-42,-26,-42v-25,0,-55,-3,-76,2v2,30,-4,67,2,93v37,-2,86,11,86,-29v2,0,6,-1,6,1v-1,25,1,54,-2,77v0,0,-5,0,-5,-1v5,-43,-53,-34,-87,-30r0,86v2,28,51,15,78,15v25,0,35,-20,37,-42v0,-4,6,-7,8,-3v-4,19,0,49,-9,62r-197,-1v-3,-11,12,-6,21,-7v16,-1,28,-5,28,-23r0,-186v0,-21,-20,-21,-37,-25v0,-2,-1,-5,1,-6r167,0v5,0,7,1,7,6v0,17,4,37,2,53r-4,0xm161,-284v-15,10,-34,-29,-49,-39r-43,44v-3,-2,-7,-5,-3,-8v17,-18,27,-50,48,-59v15,21,33,39,47,62","w":222},"\u00cb":{"d":"186,-189v-8,-14,-5,-42,-26,-42v-25,0,-55,-3,-76,2v2,30,-4,67,2,93v37,-2,86,11,86,-29v2,0,6,-1,6,1v-1,25,1,54,-2,77v0,0,-5,0,-5,-1v5,-43,-53,-34,-87,-30r0,86v2,28,51,15,78,15v25,0,35,-20,37,-42v0,-4,6,-7,8,-3v-4,19,0,49,-9,62r-197,-1v-3,-11,12,-6,21,-7v16,-1,28,-5,28,-23r0,-186v0,-21,-20,-21,-37,-25v0,-2,-1,-5,1,-6r167,0v5,0,7,1,7,6v0,17,4,37,2,53r-4,0xm146,-337v28,0,25,42,0,42v-12,-1,-21,-8,-21,-21v0,-12,9,-21,21,-21xm75,-337v22,-2,28,33,9,40v-14,6,-30,-3,-29,-19v0,-13,9,-20,20,-21","w":222},"\u00cc":{"d":"107,-242v-16,2,-28,5,-28,26r0,188v-2,18,14,20,28,22v0,2,1,7,-2,6r-89,-1v0,-2,-1,-6,1,-6v18,0,27,-6,27,-25r0,-188v0,-17,-13,-20,-28,-22v0,0,-1,-6,2,-6r89,2r0,4xm38,-314v-14,-7,-9,-38,10,-27v15,18,34,41,44,60v-2,1,-4,7,-6,5","w":122},"\u00cd":{"d":"107,-242v-16,2,-28,5,-28,26r0,188v-2,18,14,20,28,22v0,2,1,7,-2,6r-89,-1v0,-2,-1,-6,1,-6v18,0,27,-6,27,-25r0,-188v0,-17,-13,-20,-28,-22v0,0,-1,-6,2,-6r89,2r0,4xm82,-335v6,-13,26,-8,26,5v-12,25,-40,41,-60,54v-1,-2,-4,-3,-4,-7","w":122},"\u00ce":{"d":"107,-242v-16,2,-28,5,-28,26r0,188v-2,18,14,20,28,22v0,2,1,7,-2,6r-89,-1v0,-2,-1,-6,1,-6v18,0,27,-6,27,-25r0,-188v0,-17,-13,-20,-28,-22v0,0,-1,-6,2,-6r89,2r0,4xm110,-279v-15,10,-34,-29,-49,-39r-43,44v-3,-2,-7,-5,-3,-8v17,-18,27,-50,48,-59v15,21,33,39,47,62","w":122},"\u00cf":{"d":"107,-242v-16,2,-28,5,-28,26r0,188v-2,18,14,20,28,22v0,2,1,7,-2,6r-89,-1v0,-2,-1,-6,1,-6v18,0,27,-6,27,-25r0,-188v0,-17,-13,-20,-28,-22v0,0,-1,-6,2,-6r89,2r0,4xm98,-337v28,0,25,42,0,42v-12,-1,-21,-8,-21,-21v0,-12,9,-21,21,-21xm27,-337v22,-2,28,33,9,40v-14,6,-30,-3,-29,-19v0,-13,9,-20,20,-21","w":122},"\u00d1":{"d":"267,-5v0,11,-14,7,-17,1r-184,-203r1,186v7,10,23,13,38,15v0,3,1,6,-2,6r-92,-1v-3,-9,9,-5,17,-7v12,-4,14,-20,15,-36r0,-182v-1,-14,-22,-12,-32,-16v0,-2,-1,-5,1,-6r64,0r168,186v7,-32,-1,-84,2,-122v2,-37,-2,-60,-39,-58v0,-2,-1,-5,1,-6r93,2v0,2,1,5,-1,5v-13,2,-33,7,-33,21r0,215xm193,-318v14,2,11,-33,22,-15v0,20,-10,35,-29,35v-27,0,-63,-37,-69,4v-3,0,-8,3,-8,-2v1,-21,8,-41,28,-41v22,0,34,17,56,19","w":307},"\u00d2":{"d":"292,-129v0,81,-56,134,-138,134v-79,0,-135,-46,-135,-131v0,-83,58,-129,143,-129v79,0,130,48,130,126xm149,-243v-64,0,-93,48,-93,111v0,69,35,124,106,124v64,0,93,-49,93,-113v0,-69,-36,-122,-106,-122xm122,-318v-14,-7,-9,-38,10,-27v15,18,34,41,44,60v-2,1,-4,7,-6,5","w":311},"\u00d3":{"d":"292,-129v0,81,-56,134,-138,134v-79,0,-135,-46,-135,-131v0,-83,58,-129,143,-129v79,0,130,48,130,126xm149,-243v-64,0,-93,48,-93,111v0,69,35,124,106,124v64,0,93,-49,93,-113v0,-69,-36,-122,-106,-122xm179,-339v6,-13,26,-8,26,5v-12,25,-40,41,-60,54v-1,-2,-4,-3,-4,-7","w":311},"\u00d4":{"d":"292,-129v0,81,-56,134,-138,134v-79,0,-135,-46,-135,-131v0,-83,58,-129,143,-129v79,0,130,48,130,126xm149,-243v-64,0,-93,48,-93,111v0,69,35,124,106,124v64,0,93,-49,93,-113v0,-69,-36,-122,-106,-122xm201,-284v-15,10,-34,-29,-49,-39r-43,44v-3,-2,-7,-5,-3,-8v17,-18,27,-50,48,-59v15,21,33,39,47,62","w":311},"\u00d5":{"d":"292,-129v0,81,-56,134,-138,134v-79,0,-135,-46,-135,-131v0,-83,58,-129,143,-129v79,0,130,48,130,126xm149,-243v-64,0,-93,48,-93,111v0,69,35,124,106,124v64,0,93,-49,93,-113v0,-69,-36,-122,-106,-122xm188,-306v14,2,11,-33,22,-15v0,20,-10,35,-29,35v-27,0,-63,-37,-69,4v-3,0,-8,3,-8,-2v1,-21,8,-41,28,-41v22,0,34,17,56,19","w":311},"\u00d6":{"d":"292,-129v0,81,-56,134,-138,134v-79,0,-135,-46,-135,-131v0,-83,58,-129,143,-129v79,0,130,48,130,126xm149,-243v-64,0,-93,48,-93,111v0,69,35,124,106,124v64,0,93,-49,93,-113v0,-69,-36,-122,-106,-122xm190,-325v28,0,25,42,0,42v-12,-1,-21,-8,-21,-21v0,-12,9,-21,21,-21xm119,-325v22,-2,28,33,9,40v-14,6,-30,-3,-29,-19v0,-13,9,-20,20,-21","w":311},"\u00d7":{"d":"37,-181r55,56r56,-56r15,15r-55,56r56,56r-16,16r-56,-56r-56,56r-15,-16r56,-56r-56,-55"},"\u00d8":{"d":"162,-255v35,-1,63,12,83,29r36,-37r12,11r-36,38v20,20,35,47,35,85v2,109,-128,169,-219,109r-37,39r-12,-11r36,-38v-22,-22,-41,-52,-41,-96v0,-83,58,-126,143,-129xm149,-243v-94,0,-114,126,-68,191r146,-154v-17,-20,-42,-37,-78,-37xm162,-8v89,0,113,-115,74,-184r-144,152v16,17,38,32,70,32","w":311},"\u00d9":{"d":"151,5v-61,0,-114,-23,-114,-84r0,-141v0,-17,-18,-19,-31,-22v0,0,-1,-6,2,-6r96,2v2,7,-6,5,-12,6v-13,1,-21,9,-21,23v1,95,-19,206,82,205v51,-1,86,-26,86,-76r-1,-125v1,-22,-19,-27,-38,-29v0,0,-1,-6,2,-6r88,2v0,2,1,5,-2,5v-19,-1,-31,8,-31,24r0,115v-1,69,-36,107,-106,107xm124,-314v-14,-7,-9,-38,10,-27v15,18,34,41,44,60v-2,1,-4,7,-6,5","w":293},"\u00da":{"d":"151,5v-61,0,-114,-23,-114,-84r0,-141v0,-17,-18,-19,-31,-22v0,0,-1,-6,2,-6r96,2v2,7,-6,5,-12,6v-13,1,-21,9,-21,23v1,95,-19,206,82,205v51,-1,86,-26,86,-76r-1,-125v1,-22,-19,-27,-38,-29v0,0,-1,-6,2,-6r88,2v0,2,1,5,-2,5v-19,-1,-31,8,-31,24r0,115v-1,69,-36,107,-106,107xm180,-335v6,-13,26,-8,26,5v-12,25,-40,41,-60,54v-1,-2,-4,-3,-4,-7","w":293},"\u00db":{"d":"151,5v-61,0,-114,-23,-114,-84r0,-141v0,-17,-18,-19,-31,-22v0,0,-1,-6,2,-6r96,2v2,7,-6,5,-12,6v-13,1,-21,9,-21,23v1,95,-19,206,82,205v51,-1,86,-26,86,-76r-1,-125v1,-22,-19,-27,-38,-29v0,0,-1,-6,2,-6r88,2v0,2,1,5,-2,5v-19,-1,-31,8,-31,24r0,115v-1,69,-36,107,-106,107xm201,-279v-15,10,-34,-29,-49,-39r-43,44v-3,-2,-7,-5,-3,-8v17,-18,27,-50,48,-59v15,21,33,39,47,62","w":293},"\u00dc":{"d":"151,5v-61,0,-114,-23,-114,-84r0,-141v0,-17,-18,-19,-31,-22v0,0,-1,-6,2,-6r96,2v2,7,-6,5,-12,6v-13,1,-21,9,-21,23v1,95,-19,206,82,205v51,-1,86,-26,86,-76r-1,-125v1,-22,-19,-27,-38,-29v0,0,-1,-6,2,-6r88,2v0,2,1,5,-2,5v-19,-1,-31,8,-31,24r0,115v-1,69,-36,107,-106,107xm194,-337v28,0,25,42,0,42v-12,-1,-21,-8,-21,-21v0,-12,9,-21,21,-21xm123,-337v22,-2,28,33,9,40v-14,6,-30,-3,-29,-19v0,-13,9,-20,20,-21","w":293},"\u00dd":{"d":"157,-97v-1,45,-8,88,36,93v0,4,-3,3,-6,4r-99,-1v-1,0,-2,-2,-2,-4v14,-8,39,-4,37,-27v-2,-19,2,-43,-1,-60r-78,-125v-9,-14,-25,-21,-43,-25v0,-2,-1,-7,2,-6v33,2,75,-3,104,3v-4,9,-38,4,-25,25r63,100v23,-32,43,-67,60,-105v2,-18,-22,-9,-25,-22v25,-1,67,-5,88,2v-11,10,-34,12,-42,28xm168,-335v6,-13,26,-8,26,5v-12,25,-40,41,-60,54v-1,-2,-4,-3,-4,-7","w":274},"\u00de":{"d":"74,-58v-12,32,10,54,41,52v0,2,1,6,-1,6r-107,-1v0,-2,-1,-7,2,-6v17,0,28,-7,28,-23r0,-186v1,-21,-12,-24,-30,-26v0,-3,-1,-6,2,-6r92,2v0,13,-34,-2,-29,22r0,20v69,-7,123,13,119,78v-3,55,-51,78,-117,68xm156,-136v2,-46,-40,-69,-84,-57r0,119v1,7,12,5,21,5v41,0,62,-26,63,-67","w":203},"\u00df":{"d":"167,-70v0,-51,-17,-85,-71,-82r0,-7v36,-4,59,-23,60,-62v0,-34,-15,-58,-48,-58v-35,0,-48,30,-49,66r0,183v-5,25,18,20,30,29v-25,3,-56,0,-83,1v-1,0,-2,-1,-2,-3v10,-7,27,-4,27,-24v0,-108,-30,-262,82,-262v41,0,72,24,72,64v0,40,-31,55,-61,68v39,10,75,30,75,80v0,50,-28,76,-72,82v-18,3,-28,-22,-10,-26v10,1,16,9,26,10v20,-6,24,-33,24,-59","w":214},"\u00e0":{"d":"121,-29v1,18,27,2,30,7v-6,17,-43,40,-53,14r-5,-12v-15,8,-22,24,-44,24v-22,0,-37,-14,-37,-35v0,-42,61,-30,82,-55v1,-32,2,-65,-28,-65v-15,0,-25,13,-21,29v-9,2,-25,20,-29,6v3,-52,105,-67,105,-6r0,93xm40,-35v0,32,49,23,54,0v-1,-11,4,-35,-3,-37v-17,13,-51,11,-51,37xm42,-226v-14,-7,-9,-38,10,-27v15,18,34,41,44,60v-2,1,-4,7,-6,5","w":153},"\u00e1":{"d":"121,-29v1,18,27,2,30,7v-6,17,-43,40,-53,14r-5,-12v-15,8,-22,24,-44,24v-22,0,-37,-14,-37,-35v0,-42,61,-30,82,-55v1,-32,2,-65,-28,-65v-15,0,-25,13,-21,29v-9,2,-25,20,-29,6v3,-52,105,-67,105,-6r0,93xm40,-35v0,32,49,23,54,0v-1,-11,4,-35,-3,-37v-17,13,-51,11,-51,37xm93,-247v6,-13,26,-8,26,5v-12,25,-40,41,-60,54v-1,-2,-4,-3,-4,-7","w":153},"\u00e2":{"d":"121,-29v1,18,27,2,30,7v-6,17,-43,40,-53,14r-5,-12v-15,8,-22,24,-44,24v-22,0,-37,-14,-37,-35v0,-42,61,-30,82,-55v1,-32,2,-65,-28,-65v-15,0,-25,13,-21,29v-9,2,-25,20,-29,6v3,-52,105,-67,105,-6r0,93xm40,-35v0,32,49,23,54,0v-1,-11,4,-35,-3,-37v-17,13,-51,11,-51,37xm119,-192v-15,10,-34,-29,-49,-39r-43,44v-3,-2,-7,-5,-3,-8v17,-18,27,-50,48,-59v15,21,33,39,47,62","w":153},"\u00e3":{"d":"122,-29v1,18,27,2,30,7v-6,17,-43,40,-53,14r-5,-12v-15,8,-22,24,-44,24v-22,0,-37,-14,-37,-35v0,-42,61,-30,82,-55v1,-32,2,-65,-28,-65v-15,0,-25,13,-21,29v-9,2,-25,20,-29,6v3,-52,105,-67,105,-6r0,93xm41,-35v0,32,49,23,54,0v-1,-11,4,-35,-3,-37v-17,13,-51,11,-51,37xm106,-220v14,2,11,-33,22,-15v0,20,-10,35,-29,35v-27,0,-63,-37,-69,4v-3,0,-8,3,-8,-2v1,-21,8,-41,28,-41v22,0,34,17,56,19","w":153},"\u00e4":{"d":"124,-29v1,18,27,2,30,7v-6,17,-43,40,-53,14r-5,-12v-15,8,-22,24,-44,24v-22,0,-37,-14,-37,-35v0,-42,61,-30,82,-55v1,-32,2,-65,-28,-65v-15,0,-25,13,-21,29v-9,2,-25,20,-29,6v3,-52,105,-67,105,-6r0,93xm43,-35v0,32,49,23,54,0v-1,-11,4,-35,-3,-37v-17,13,-51,11,-51,37xm108,-237v28,0,25,42,0,42v-12,-1,-21,-8,-21,-21v0,-12,9,-21,21,-21xm37,-237v22,-2,28,33,9,40v-14,6,-30,-3,-29,-19v0,-13,9,-20,20,-21","w":153},"\u00e5":{"d":"121,-29v1,18,27,2,30,7v-6,17,-43,40,-53,14r-5,-12v-15,8,-22,24,-44,24v-22,0,-37,-14,-37,-35v0,-42,61,-30,82,-55v1,-32,2,-65,-28,-65v-15,0,-25,13,-21,29v-9,2,-25,20,-29,6v3,-52,105,-67,105,-6r0,93xm40,-35v0,32,49,23,54,0v-1,-11,4,-35,-3,-37v-17,13,-51,11,-51,37xm107,-222v2,34,-51,43,-62,13v-9,-22,6,-46,30,-45v20,0,30,14,32,32xm95,-222v0,-27,-41,-25,-41,0v0,27,41,25,41,0","w":153},"\u00e6":{"d":"225,-37v4,18,-35,42,-63,42v-28,0,-45,-17,-56,-36v-15,14,-31,32,-57,36v-21,-2,-37,-14,-37,-36v0,-42,61,-30,82,-55v1,-32,2,-64,-28,-64v-15,0,-26,12,-21,28v-6,3,-26,19,-29,6v4,-46,81,-64,101,-21v14,-27,79,-39,97,-6v6,10,23,29,12,42v-34,2,-74,-4,-104,2v-14,71,58,108,103,62xm163,-151v-22,0,-33,17,-37,38v14,8,46,1,67,3v3,0,5,-1,5,-4v-2,-21,-13,-37,-35,-37xm40,-35v0,33,49,23,54,0v-2,-12,4,-31,-3,-37v-17,12,-51,11,-51,37","w":242},"\u00e7":{"d":"86,5v-46,0,-69,-31,-70,-74v-2,-66,32,-97,100,-94v16,1,33,7,34,21v-11,31,-37,-8,-54,-10v-34,5,-50,31,-50,68v0,40,16,69,57,69v23,1,34,-13,45,-25v9,14,-24,35,-41,41r-23,26v13,4,24,12,25,27v-4,29,-30,40,-59,40v-12,0,-12,-14,0,-14v17,-2,34,-6,36,-23v-2,-12,-14,-18,-27,-19","w":164},"\u00e8":{"d":"79,5v-42,0,-62,-34,-67,-76v-11,-87,117,-130,135,-37v0,4,-1,7,-4,7r-102,0v-23,62,56,115,101,64r4,4v-16,18,-36,38,-67,38xm80,-151v-22,0,-34,16,-37,38v-1,2,1,3,3,3r64,0v3,0,5,-1,5,-4v-2,-21,-13,-37,-35,-37xm48,-226v-14,-7,-9,-38,10,-27v15,18,34,41,44,60v-2,1,-4,7,-6,5","w":163},"\u00e9":{"d":"79,5v-42,0,-62,-34,-67,-76v-11,-87,117,-130,135,-37v0,4,-1,7,-4,7r-102,0v-23,62,56,115,101,64r4,4v-16,18,-36,38,-67,38xm80,-151v-22,0,-34,16,-37,38v-1,2,1,3,3,3r64,0v3,0,5,-1,5,-4v-2,-21,-13,-37,-35,-37xm101,-247v6,-13,26,-8,26,5v-12,25,-40,41,-60,54v-1,-2,-4,-3,-4,-7","w":163},"\u00ea":{"d":"79,5v-42,0,-62,-34,-67,-76v-11,-87,117,-130,135,-37v0,4,-1,7,-4,7r-102,0v-23,62,56,115,101,64r4,4v-16,18,-36,38,-67,38xm80,-151v-22,0,-34,16,-37,38v-1,2,1,3,3,3r64,0v3,0,5,-1,5,-4v-2,-21,-13,-37,-35,-37xm132,-192v-15,10,-34,-29,-49,-39r-43,44v-3,-2,-7,-5,-3,-8v17,-18,27,-50,48,-59v15,21,33,39,47,62","w":163},"\u00eb":{"d":"79,5v-42,0,-62,-34,-67,-76v-11,-87,117,-130,135,-37v0,4,-1,7,-4,7r-102,0v-23,62,56,115,101,64r4,4v-16,18,-36,38,-67,38xm80,-151v-22,0,-34,16,-37,38v-1,2,1,3,3,3r64,0v3,0,5,-1,5,-4v-2,-21,-13,-37,-35,-37xm120,-237v28,0,25,42,0,42v-12,-1,-21,-8,-21,-21v0,-12,9,-21,21,-21xm49,-237v22,-2,28,33,9,40v-14,6,-30,-3,-29,-19v0,-13,9,-20,20,-21","w":163},"\u00ec":{"d":"76,-27v-4,22,25,14,26,27r-79,0v2,-14,26,-4,26,-27r0,-93v3,-16,-32,-7,-23,-21r47,-22v2,0,3,1,3,4r0,132xm20,-226v-14,-7,-9,-38,10,-27v15,18,34,41,44,60v-2,1,-4,7,-6,5","w":101},"\u00ed":{"d":"65,-27v-4,22,25,14,26,27r-79,0v2,-14,26,-4,26,-27r0,-93v3,-16,-32,-7,-23,-21r47,-22v2,0,3,1,3,4r0,132xm65,-247v6,-13,26,-8,26,5v-12,25,-40,41,-60,54v-1,-2,-4,-3,-4,-7","w":101},"\u00ee":{"d":"76,-27v-4,22,25,14,26,27r-79,0v2,-14,26,-4,26,-27r0,-93v3,-16,-32,-7,-23,-21r47,-22v2,0,3,1,3,4r0,132xm107,-192v-15,10,-34,-29,-49,-39r-43,44v-3,-2,-7,-5,-3,-8v17,-18,27,-50,48,-59v15,21,33,39,47,62","w":106},"\u00ef":{"d":"84,-27v-4,22,25,14,26,27r-79,0v2,-14,26,-4,26,-27r0,-93v3,-16,-32,-7,-23,-21r47,-22v2,0,3,1,3,4r0,132xm102,-237v28,0,25,42,0,42v-12,-1,-21,-8,-21,-21v0,-12,9,-21,21,-21xm31,-237v22,-2,28,33,9,40v-14,6,-30,-3,-29,-19v0,-13,9,-20,20,-21","w":121},"\u00f0":{"d":"13,-78v-2,-63,73,-101,126,-67v0,-35,-21,-53,-36,-76r-38,30r-11,-13r39,-30v-19,-18,-32,-44,-58,-55v40,-4,50,25,71,44r41,-32r10,14r-40,31v29,41,59,87,59,154v0,51,-32,83,-82,83v-49,0,-79,-32,-81,-83xm147,-71v6,-74,-106,-110,-106,-18v0,43,15,84,60,84v35,0,43,-30,46,-66","w":191},"\u00f1":{"d":"36,-128v3,-17,-32,-9,-23,-21r48,-23v9,3,-4,34,7,33v21,-8,35,-24,62,-24v53,0,38,81,38,136v0,21,21,16,33,24v0,2,-1,3,-2,3r-84,0v-1,0,-2,-1,-2,-3v37,-3,28,-56,28,-101v0,-23,-7,-45,-35,-42v-14,5,-30,9,-42,20r0,99v-2,19,17,17,27,24v0,2,-1,3,-2,3r-78,0v-1,0,-2,-1,-2,-3v10,-7,27,-4,27,-24r0,-101xm130,-220v14,2,11,-33,22,-15v0,20,-10,35,-29,35v-27,0,-63,-37,-69,4v-3,0,-8,3,-8,-2v1,-21,8,-41,28,-41v22,0,34,17,56,19","w":204},"\u00f2":{"d":"97,5v-52,0,-84,-34,-84,-86v0,-47,33,-82,82,-82v51,0,86,32,86,83v0,52,-33,85,-84,85xm89,-152v-33,0,-47,29,-47,60v0,45,17,87,62,87v33,0,47,-27,47,-61v0,-46,-19,-86,-62,-86xm73,-226v-14,-7,-9,-38,10,-27v15,18,34,41,44,60v-2,1,-4,7,-6,5","w":194},"\u00f3":{"d":"97,5v-52,0,-84,-34,-84,-86v0,-47,33,-82,82,-82v51,0,86,32,86,83v0,52,-33,85,-84,85xm89,-152v-33,0,-47,29,-47,60v0,45,17,87,62,87v33,0,47,-27,47,-61v0,-46,-19,-86,-62,-86xm112,-247v6,-13,26,-8,26,5v-12,25,-40,41,-60,54v-1,-2,-4,-3,-4,-7","w":194},"\u00f4":{"d":"97,5v-52,0,-84,-34,-84,-86v0,-47,33,-82,82,-82v51,0,86,32,86,83v0,52,-33,85,-84,85xm89,-152v-33,0,-47,29,-47,60v0,45,17,87,62,87v33,0,47,-27,47,-61v0,-46,-19,-86,-62,-86xm147,-192v-15,10,-34,-29,-49,-39r-43,44v-3,-2,-7,-5,-3,-8v17,-18,27,-50,48,-59v15,21,33,39,47,62","w":194},"\u00f5":{"d":"97,5v-52,0,-84,-34,-84,-86v0,-47,33,-82,82,-82v51,0,86,32,86,83v0,52,-33,85,-84,85xm89,-152v-33,0,-47,29,-47,60v0,45,17,87,62,87v33,0,47,-27,47,-61v0,-46,-19,-86,-62,-86xm128,-220v14,2,11,-33,22,-15v0,20,-10,35,-29,35v-27,0,-63,-37,-69,4v-3,0,-8,3,-8,-2v1,-21,8,-41,28,-41v22,0,34,17,56,19","w":193},"\u00f6":{"d":"97,5v-52,0,-84,-34,-84,-86v0,-47,33,-82,82,-82v51,0,86,32,86,83v0,52,-33,85,-84,85xm89,-152v-33,0,-47,29,-47,60v0,45,17,87,62,87v33,0,47,-27,47,-61v0,-46,-19,-86,-62,-86xm134,-237v28,0,25,42,0,42v-12,-1,-21,-8,-21,-21v0,-12,9,-21,21,-21xm63,-237v22,-2,28,33,9,40v-14,6,-30,-3,-29,-19v0,-13,9,-20,20,-21","w":193},"\u00f7":{"d":"15,-121r154,0r0,22r-154,0r0,-22xm113,-47v0,27,-42,24,-41,0v0,-12,7,-21,20,-21v14,0,21,9,21,21xm113,-171v0,29,-42,25,-41,0v0,-12,8,-21,20,-21v13,0,21,9,21,21"},"\u00f8":{"d":"186,-80v0,71,-81,107,-134,69r-30,31r-11,-11r29,-30v-45,-48,-13,-146,60,-142v23,1,40,8,55,18r24,-24r12,11r-25,24v11,13,20,31,20,54xm94,-152v-51,1,-55,72,-36,111r79,-85v-9,-14,-22,-26,-43,-26xm67,-26v27,39,89,18,89,-40v0,-17,-4,-33,-10,-46","w":203},"\u00f9":{"d":"102,-3v-23,11,-73,12,-73,-19r0,-107v-1,-9,-11,-15,-21,-15v-1,-3,-2,-7,2,-7r44,-12v6,36,-2,85,2,125v3,32,60,30,77,9r0,-100v3,-14,-28,-11,-19,-22v15,-2,33,-13,46,-10r0,126v0,16,15,14,27,15v0,3,0,3,-3,4v-16,5,-37,20,-51,19r0,-20v-13,2,-21,9,-31,14xm66,-226v-14,-7,-9,-38,10,-27v15,18,34,41,44,60v-2,1,-4,7,-6,5","w":197},"\u00fa":{"d":"102,-3v-23,11,-73,12,-73,-19r0,-107v-1,-9,-11,-15,-21,-15v-1,-3,-2,-7,2,-7r44,-12v6,36,-2,85,2,125v3,32,60,30,77,9r0,-100v3,-14,-28,-11,-19,-22v15,-2,33,-13,46,-10r0,126v0,16,15,14,27,15v0,3,0,3,-3,4v-16,5,-37,20,-51,19r0,-20v-13,2,-21,9,-31,14xm117,-247v6,-13,26,-8,26,5v-12,25,-40,41,-60,54v-1,-2,-4,-3,-4,-7","w":197},"\u00fb":{"d":"102,-3v-23,11,-73,12,-73,-19r0,-107v-1,-9,-11,-15,-21,-15v-1,-3,-2,-7,2,-7r44,-12v6,36,-2,85,2,125v3,32,60,30,77,9r0,-100v3,-14,-28,-11,-19,-22v15,-2,33,-13,46,-10r0,126v0,16,15,14,27,15v0,3,0,3,-3,4v-16,5,-37,20,-51,19r0,-20v-13,2,-21,9,-31,14xm137,-192v-15,10,-34,-29,-49,-39r-43,44v-3,-2,-7,-5,-3,-8v17,-18,27,-50,48,-59v15,21,33,39,47,62","w":197},"\u00fc":{"d":"102,-3v-23,11,-73,12,-73,-19r0,-107v-1,-9,-11,-15,-21,-15v-1,-3,-2,-7,2,-7r44,-12v6,36,-2,85,2,125v3,32,60,30,77,9r0,-100v3,-14,-28,-11,-19,-22v15,-2,33,-13,46,-10r0,126v0,16,15,14,27,15v0,3,0,3,-3,4v-16,5,-37,20,-51,19r0,-20v-13,2,-21,9,-31,14xm130,-237v28,0,25,42,0,42v-12,-1,-21,-8,-21,-21v0,-12,9,-21,21,-21xm59,-237v22,-2,28,33,9,40v-14,6,-30,-3,-29,-19v0,-13,9,-20,20,-21","w":197},"\u00fd":{"d":"60,105v-8,16,-42,3,-28,-14v9,-7,24,-8,28,-20v8,-25,32,-51,27,-77r-67,-135v-5,-9,-20,-6,-24,-14v18,-5,64,-6,83,0v-3,10,-30,-4,-25,19r49,102v16,-31,28,-66,38,-99v2,-17,-20,-14,-28,-22v16,-5,57,-6,73,0v-2,4,-6,4,-12,5v-12,2,-15,17,-20,27xm122,-247v6,-13,26,-8,26,5v-12,25,-40,41,-60,54v-1,-2,-4,-3,-4,-7","w":192},"\u00fe":{"d":"172,-82v0,60,-49,98,-112,83v-4,0,-3,3,-3,6v1,45,-13,98,37,99v0,2,-1,3,-2,3r-88,0v-1,0,-2,-1,-2,-3v10,-7,27,-4,27,-24r0,-328v3,-16,-30,-6,-23,-21r48,-22v2,0,3,1,3,4r2,142v18,-9,32,-20,56,-20v40,0,57,40,57,81xm145,-64v-4,-41,-11,-77,-51,-80v-16,-1,-29,5,-37,13r0,106v27,33,93,13,88,-39","w":191},"\u00ff":{"d":"60,105v-8,16,-42,3,-28,-14v9,-7,24,-8,28,-20v8,-25,32,-51,27,-77r-67,-135v-5,-9,-20,-6,-24,-14v18,-5,64,-6,83,0v-3,10,-30,-4,-25,19r49,102v16,-31,28,-66,38,-99v2,-17,-20,-14,-28,-22v16,-5,57,-6,73,0v-2,4,-6,4,-12,5v-12,2,-15,17,-20,27xm132,-237v28,0,25,42,0,42v-12,-1,-21,-8,-21,-21v0,-12,9,-21,21,-21xm61,-237v22,-2,28,33,9,40v-14,6,-30,-3,-29,-19v0,-13,9,-20,20,-21","w":192},"\u0131":{"d":"65,-27v-4,22,25,14,26,27r-79,0v2,-14,26,-4,26,-27r0,-93v3,-16,-32,-7,-23,-21r47,-22v2,0,3,1,3,4r0,132","w":101},"\u02c6":{"d":"103,-192v-15,10,-34,-29,-49,-39r-43,44v-3,-2,-7,-5,-3,-8v17,-18,27,-50,48,-59v15,21,33,39,47,62","w":109},"\u02da":{"d":"94,-222v2,34,-51,43,-62,13v-9,-22,6,-46,30,-45v20,0,30,14,32,32xm82,-222v0,-27,-41,-25,-41,0v0,27,41,25,41,0","w":123},"\u02dc":{"d":"93,-220v14,2,11,-33,22,-15v0,20,-10,35,-29,35v-27,0,-63,-37,-69,4v-3,0,-8,3,-8,-2v1,-21,8,-41,28,-41v22,0,34,17,56,19","w":123},"\u2044":{"d":"110,-260r23,0r-194,270r-22,0","w":49},"\u2070":{"d":"58,-94v-66,-7,-65,-137,-2,-148v71,2,67,143,2,148xm59,-98v43,-6,35,-93,21,-128v-36,-32,-57,12,-54,58v2,33,2,67,33,70","w":116},"\u2074":{"d":"76,-240v1,-2,8,-4,9,0v2,29,-4,65,2,90v9,0,29,-3,20,11v-7,1,-19,-3,-22,2v-1,14,3,34,-2,44v-5,-1,-14,3,-14,-3r0,-43v-19,-3,-50,7,-62,-4xm66,-215v-16,18,-32,42,-45,64v12,1,39,5,48,-2r0,-61v0,-1,-2,-1,-3,-1","w":116}}});
