<?php

/**
 * Artisan Creatif Single Post Template
 * 
 * This is the single post template. This template will be used for all single
 * blog post views.
 *
 * You should only customize this template in a child theme.
 *
 * @package Artisan Creatif
 * @version 1.0.0
 * @since 2.0.0
 * @author Erik Ford for We Are Pixel8 <@notdivisible>
 *
 */

get_header(); ?>

	<?php if ( have_posts() ) : while ( have_posts() ) : the_post(); // Begin the loop ?>
	
		<div class="flowlines"><!-- Begin .flowlines -->
			<div class="wrapper">
				<?php the_title( '<h1>', '</h1>' ); ?>
			</div>
		</div><!-- End .flowlines -->
		
		<div id="page-content" class="clear"><!-- Begin #page-content -->
			<div class="wrapper"><!-- Begin .wrapper for #page-content -->
				<div class="artisancolumn-700 vertmargin-10 <?php if ( of_get_option( 'artisan_sidebar' ) == '2c-l-fixed' ) { echo 'alignright'; } else if ( of_get_option( 'artisan_sidebar' ) == '2c-r-fixed' ) { echo 'alignleft'; } ?>"><!-- Begin .artisancolumn-700 -->		
					<div class="artisancolumn-700 clear"><!-- Begin post -->
						<div class="artisan-baseline <?php if ( of_get_option( 'artisan_sidebar' ) == '2c-l-fixed' ) { echo 'alignright'; } else if ( of_get_option( 'artisan_sidebar' ) == '2c-r-fixed' ) { echo 'alignleft'; } ?>"><!-- Begin post meta data -->
							<div class="baseline-section">
								<p><?php _e( 'Posted by ', 'wap8theme-i18n' ); ?><?php the_author(); ?></p>
								
								<p><?php the_time( 'd M Y' ); ?> &#151; <a class="scroll-it" href="<?php the_permalink(); ?>#comments"><?php comments_number(__( 'No Comments', 'wap8theme-i18n' ),__( '1 Comment', 'wap8theme-i18n' ),__( '% Comments', 'wap8theme-i18n' )); ?></a></p>
							</div>
								
							<div class="baseline-section top-decoration">
								<p><?php _e( 'Posted in ', 'wap8theme-i18n' ); ?><?php the_category(', '); ?></p>
							</div>
							
							<?php if ( has_tag() ) { ?>
							<div class="baseline-section top-decoration">
								<p><?php the_tags( __( 'Tagged: ', 'wap8theme-i18n' ), ', ', '' ); ?></p>
							</div>
							<?php } ?>
						</div><!-- End post meta data -->
						
						<div class="post-entry artisan-post <?php if ( of_get_option( 'artisan_sidebar' ) == '2c-l-fixed' ) { echo 'alignleft'; } else if ( of_get_option( 'artisan_sidebar' ) == '2c-r-fixed' ) { echo 'alignright'; } ?>" id="post-<?php the_ID(); ?>"><!-- Begin .post-entry -->
						
							<?php
							
								if ( of_get_option( 'artisan_blog_image' ) == '1' && has_post_thumbnail() ) { 
							
									echo '<div class="artisan-feature">';
							
									the_post_thumbnail( 'img-460x', array('title' => get_the_title() ) );
							
									echo '</div>';
								}
								
								the_content(); // post content
						
								// store arguments in an array
								$args = array(
									'before'				=> '<p class="post-pagination">' . __( 'Pages: ', 'wap8theme-i18n' ),
									'after'					=> '</p>',
									'next_or_number'		=> 'number',
									'nextpagelink'			=> __( 'Next Page &rarr;', 'wap8theme-i18n' ),
									'previouspagelink'		=> __( '&larr; Previous Page', 'wap8theme-i18n' )
									);
			
								wp_link_pages( $args ); ?>
						
						</div><!-- End .post-entry -->
					
					</div><!-- End post -->
					
					<?php
					
						if ( of_get_option( 'artisan_blog_author' ) == '1' ) {
						
							locate_template( '/includes/include-author.php', true, true );
							
						}
						
						if ( of_get_option( 'artisan_blog_related' ) == '1' ) {
						
							locate_template( '/includes/include-relatedpost.php', true, true );
							
						}
						
						echo '<div class="artisancolumn-700 clear">' . "\n";
						
						comments_template( '', true ); // Load comments.php
						
						echo '</div>' . "\n";
						
					?>

				</div><!-- End .artisancolumn-700 -->
	
	<?php endwhile; endif; // End the loop
	
				get_sidebar( 'posts' ); // Load sidebar ?>
				
			</div><!-- End .wrapper for #page-content -->
		</div><!-- End #page-content -->
	</div><!-- End #vertical-grid -->
<?php get_footer(); ?>
