<?php

/**
 * Artisan Creatif Search Form
 * 
 * This is the search form template that will render a search form when using
 * get_search_form().
 *
 * There is a conditional statement which determines which form to return based
 * on which alternate stylesheet is set.
 *
 * You should only customize this template in a child theme.
 *
 * @package Artisan Creatif
 * @version 1.0.0
 * @since 2.0.0
 * @author Erik Ford for We Are Pixel8 <@notdivisible>
 *
 */

?>

<?php if ( of_get_option( 'artisan_stylesheet' ) == 'light' ) { // if the light version is set ?>

	<form class="search-form" action="<?php echo home_url(); ?>/" method="get">
		<fieldset>
			<label for="s"><?php _e( 'Search Form', 'wap8theme-i18n' ); ?></label>
			<input id="s" name="s" type="search" onblur="if (this.value == '') {this.value = '<?php _e( 'Enter keywords', 'wap8theme-i18n' ); ?>';}" onfocus="if (this.value == '<?php _e( 'Enter keywords', 'wap8theme-i18n' ); ?>') {this.value = '';}" value="<?php _e( 'Enter keywords', 'wap8theme-i18n' ); ?>" />
			<input class="search-submit" type="image" src="<?php echo get_template_directory_uri(); ?>/images/search-light.png" />
		</fieldset>
	</form>	

<?php } else if ( of_get_option( 'artisan_stylesheet' ) == 'dark' ) { // if the dark version is set ?>

	<form class="search-form" action="<?php echo home_url(); ?>/" method="get">
		<fieldset>
			<label for="s"><?php _e( 'Search Form', 'wap8theme-i18n' ); ?></label>
			<input id="s" name="s" type="search" onblur="if (this.value == '') {this.value = '<?php _e( 'Enter keywords', 'wap8theme-i18n' ); ?>';}" onfocus="if (this.value == '<?php _e( 'Enter keywords', 'wap8theme-i18n' ); ?>') {this.value = '';}" value="<?php _e( 'Enter keywords', 'wap8theme-i18n' ); ?>" />
			<input class="search-submit" type="image" src="<?php echo get_template_directory_uri(); ?>/images/search-dark.png" />
		</fieldset>
	</form>	

<?php } ?>
