<?php
/**
 * A unique identifier is defined to store the options in the database and reference them from the theme.
 * By default it uses the theme name, in lowercase and without spaces, but this can be changed if needed.
 * If the identifier changes, it'll appear as if the options have been reset.
 * 
 */

function optionsframework_option_name() {

	// This gets the theme name from the stylesheet (lowercase and without spaces)
	$themename = wp_get_theme();
	$themename = $themename->Name;
	$themename = preg_replace("/\W/", "", strtolower($themename) );
	
	$optionsframework_settings = get_option('optionsframework');
	$optionsframework_settings['id'] = $themename;
	update_option('optionsframework', $optionsframework_settings);
	
	// echo $themename;
}

/**
 * Defines an array of options that will be used to generate the settings page and be saved in the database.
 * When creating the "id" fields, make sure to use all lowercase and no spaces.
 *  
 */

function optionsframework_options() {
	
	// Various arrays
	$artisan_stylesheets = array( "none" => __( 'None', 'wap8theme-i18n' ), "light" => __( 'Light', 'wap8theme-i18n' ), "dark" => __( 'Dark', 'wap8theme-i18n' ) );
	
	$artisan_home_slider = array( "lrgslider" => __( 'Large', 'wap8theme-i18n' ), "smslider" => __( 'Small', 'wap8theme-i18n' ) );
	
	$artisan_home_slider_posts = array( "three" => "3", "four" => "4", "five" => "5", "six" => "6" );
	
	$artisan_home_slider_content = array( "featured" => __( 'Featured Work', 'wap8theme-i18n' ), "recent" => __( 'All Recent Work', 'wap8theme-i18n' ) );
	
	$artisan_carousel_content = array( "home-portfolio" => __( 'Home Portfolio', 'wap8theme-i18n' ), "recentwrk" => __( 'All Recent Work', 'wap8theme-i18n' ) );
	
	$artisan_callout_status = array( "available" => __( 'Available', 'wap8theme-i18n' ), "unavailable" => __( 'Unavailable', 'wap8theme-i18n' ) );
	
	$artisan_portfolio_callout_page = array( "both" => __( 'Both', 'wap8theme-i18n' ), "portfolio" => __( 'Portfolio', 'wap8theme-i18n' ), "case-study" => __( 'Case Study' , 'wap8theme-i18n' ) );
	
	$artisan_blog_posts = array( "four" => "4", "eight" => "8", "twelve" => "12", "sixteen" => "16" );
	
	$artisan_related_posts = array( "2" => "2", "4" => "4", "6" => "6", "8" => "8" );
		
	// Pull all the categories into an array
	$options_categories = array();  
	$options_categories_obj = get_categories();
	foreach ($options_categories_obj as $category) {
    	$options_categories[$category->cat_ID] = $category->cat_name;
	}
	
	// Pull all the pages into an array
	$options_pages = array();  
	$options_pages_obj = get_pages('sort_column=post_parent,menu_order');
	$options_pages[''] = 'Select a page:';
	foreach ($options_pages_obj as $page) {
    	$options_pages[$page->ID] = $page->post_title;
	}
		
	// If using image radio buttons, define a directory path
	$imagepath =  get_stylesheet_directory_uri() . '/images/';
		
	$options = array();
	
	// Global Settings
	
	$options[] = array( "name" => __( 'Global Settings', 'wap8theme-i18n' ),
						"type" => "heading"
						);
		
	$options[] = array( "name" => __( 'Website Logo', 'wap8theme-i18n' ),
						"desc" => __( 'Upload a .jpg, .gif or .png file to use as your logo image. If left blank, a plain text option will be initiated.', 'wap8theme-i18n' ),
						"id" => "artisan_logo",
						"type" => "upload"
						);
						
	$options[] = array( "name" => __( 'Website Favicon', 'wap8theme-i18n' ),
						"desc" => __( 'Upload a 16px x 16px .ico or .png file to use as your favicon image. If left blank, a default favicon will be displayed.', 'wap8theme-i18n' ),
						"id" => "artisan_favicon",
						"type" => "upload"
						);
						
	$options[] = array( "name" => __( 'Select Alternate Stylesheet', 'wap8theme-i18n' ),
						"desc" => __( 'Choose your alternate stylesheet.', 'wap8theme-i18n' ),
						"id" => "artisan_stylesheet",
						"std" => "light",
						"type" => "select",
						"class" => "mini",
						"options" => $artisan_stylesheets
						);
						
	$options[] = array( "name" => __( 'Sidebar Location', 'wap8theme-i18n' ),
						"desc" => __( 'Choose the location of your sidebar. This layout will be applied to pages that contain a sidebar. This will not be applied to the sidebar widget area on the home page.', 'wap8theme-i18n' ),
						"id" => "artisan_sidebar",
						"std" => "2c-r-fixed",
						"type" => "images",
						"options" => array(
							'2c-r-fixed' => $imagepath . '2cr.png',
							'2c-l-fixed' => $imagepath . '2cl.png'
							)
						);
	
	// Contact Settings
						
	$options[] = array( "name" => __( 'Contact Settings', 'wap8theme-i18n' ),
						"type" => "heading"
						);
						
	$options[] = array( "name" => __( 'Enable Quick Contact Nav Bar', 'wap8theme-i18n' ),
						"desc" => __( 'Check this option to enable your quick contact navigational bar, which will be located at the top of your website.', 'wap8theme-i18n' ),
						"id" => "artisan_qk_contact",
						"std" => "",
						"type" => "checkbox"
						);
						
	$options[] = array( "name" => __( 'Quick Contact Phone Number', 'wap8theme-i18n' ),
						"desc" => __( 'Enter the phone number you would like to display. If left blank, no phone number will appear on your website.', 'wap8theme-i18n' ),
						"id" => "artisan_phone",
						"std" => "",
						"type" => "text"
						);
						
	$options[] = array( "name" => __( 'Quick Contact Email Address', 'wap8theme-i18n' ),
						"desc" => __( 'Enter the email address you would like to display. To protect your email address from spam bots, you must enter your address in the following format: name at server.com. <strong>Do not include the &#147;&#64;&#148; symbol.</strong> If left blank, no email address will appear on your website.', 'wap8theme-i18n' ),
						"id" => "artisan_email",
						"std" => "",
						"type" => "text"
						);
						
	$options[] = array( "name" => __( 'Quick Contact Twitter Profile', 'wap8theme-i18n' ),
						"desc" => __( 'Enter the username of the Twitter profile you would like to display. An &#147;&#64;&#148; symbol will be prepended to the username. If left blank, no Twitter profile link will appear on your website.', 'wap8theme-i18n' ),
						"id" => "artisan_twitter",
						"std" => "",
						"type" => "text"
						);
						
	$options[] = array( "name" => __( 'Quick Contact Facebook URL', 'wap8theme-i18n' ),
						"desc" => __( 'Enter the URL of the Facebook page you would like to display. If left blank, no Facebook page link will appear on your website.', 'wap8theme-i18n' ),
						"id" => "artisan_facebook",
						"std" => "",
						"type" => "text"
						);
						
	$options[] = array( "name" => __( 'Enable Quick Contact Toggle Switch', 'wap8theme-i18n' ),
						"desc" => __( 'Check this option to enable your quick contact toggle switch. Once enabled, your users will be able to toggle the quick nontact navigation bar opened or closed.', 'wap8theme-i18n' ),
						"id" => "artisan_qk_contact_toggle",
						"std" => "",
						"type" => "checkbox"
						);
						
	// Featured Portfolio Slider Settings
						
	$options[] = array( "name" => __( 'Featured Portfolio Slider Settings', 'wap8theme-i18n' ),
						"type" => "heading"
						);
						
	$options[] = array( "name" => __( 'Enable Featured Portfolio Slider', 'wap8theme-i18n' ),
						"desc" => __( 'Check this option to enable your home page featured portfolio slider. Once enabled, you will be able to customize your slider in the following options.', 'wap8theme-i18n' ),
						"id" => "artisan_home_slider",
						"std" => "",
						"type" => "checkbox"
						);
						
	$options[] = array( "name" => __( 'Featured Portfolio Slider Content', 'wap8theme-i18n' ),
						"desc" => __( 'Choose the content for your featured portfolio slider.', 'wap8theme-i18n' ),
						"id" => "artisan_home_slider_content",
						"std" => "recent",
						"type" => "select",
						"class" => "medium",
						"options" => $artisan_home_slider_content
						);
						
	$options[] = array( "name" => __( 'Enter Featured Portfolio Slider Heading', 'wap8theme-i18n' ),
						"desc" => __( 'Enter the heading for your featured portfolio slider.', 'wap8theme-i18n' ),
						"id" => "artisan_home_slider_heading",
						"std" => __( 'Featured Work', 'wap8theme-i18n' ),
						"type" => "text"
						);
						
	$options[] = array( "name" => __( 'Select Featured Portfolio Slider Size', 'wap8theme-i18n' ),
						"desc" => __( 'Choose the size for your featured portfolio slider.', 'wap8theme-i18n' ),
						"id" => "artisan_home_slider_size",
						"std" => "lrgslider",
						"type" => "select",
						"class" => "mini",
						"options" => $artisan_home_slider
						);
						
	$options[] = array( "name" => __( 'Display Large Slider Overlay', 'wap8theme-i18n' ),
						"desc" => __( 'If you have chosen the large slider, for your featured portfolio slider, you can choose to disable the portfolio item&#146;s meta data overlay. The thumbnail image will link to the case study.', 'wap8theme-i18n' ),
						"id" => "artisan_home_slider_overylay",
						"std" => "1",
						"type" => "checkbox"
						);
						
	$options[] = array( "name" => __( 'Select Amount of Featured Portfolio Slider Items to Show', 'wap8theme-i18n' ),
						"desc" => __( 'Select how many slider items you would like to show in your featured portfolio slider.', 'wap8theme-i18n' ),
						"id" => "artisan_home_slider_posts",
						"std" => "three",
						"type" => "select",
						"class" => "mini",
						"options" => $artisan_home_slider_posts
						);
						
	$options[] = array( "name" => __( 'Enable Call to Action Button for Slides', 'wap8theme-i18n' ),
						"desc" => __( 'Check this option to enable the call to action button for each slide in your featured portfolio slider. Once enabled, you will be able to customize your call to action button text in the following option. Leave this option disabled if you require additional copy space for your excerpts.', 'wap8theme-i18n' ),
						"id" => "artisan_home_slider_button_true",
						"std" => "",
						"type" => "checkbox"
						);
						
	$options[] = array( "name" => __( 'Enter Slider Call to Action Text', 'wap8theme-i18n' ),
						"desc" => __( 'Enter the text for your slider call to action button. The button will automatically link to the case study page for that particular slide.', 'wap8theme-i18n' ),
						"id" => "artisan_home_slider_button",
						"std" => __( 'Case Study', 'wap8theme-i18n' ),
						"type" => "text"
						);
						
	$options[] = array( "name" => __( 'Enable Featured Portfolio Slider Toggle Switch', 'wap8theme-i18n' ),
						"desc" => __( 'Check this option to enable your featured portfolio slider toggle switch. Once enabled, your users will be able to toggle the featured portfolio slider opened or closed.', 'wap8theme-i18n' ),
						"id" => "artisan_home_portfolio_toggle",
						"std" => "",
						"type" => "checkbox"
						);
						
	// Portfolio Carousel Settings
						
	$options[] = array( "name" => __( 'Portfolio Carousel Settings', 'wap8theme-i18n' ),
						"type" => "heading"
						);
						
	$options[] = array( "name" => __( 'Enable Home Page Portfolio Carousel', 'wap8theme-i18n' ),
						"desc" => __( 'Check this option to enable your home page portfolio carousel. Once enabled, you will be able to customize your carousel in the following options.', 'wap8theme-i18n' ),
						"id" => "artisan_home_carousel",
						"std" => "",
						"type" => "checkbox"
						);
						
	$options[] = array( "name" => __( 'Portfolio Carousel Content', 'wap8theme-i18n' ),
						"desc" => __( 'Choose the content for your portfolio carousel.', 'wap8theme-i18n' ),
						"id" => "artisan_home_carousel_content",
						"std" => "home-portfolio",
						"type" => "select",
						"class" => "medium",
						"options" => $artisan_carousel_content
						);
						
	$options[] = array( "name" => __( 'Enter Portfolio Carousel Heading', 'wap8theme-i18n' ),
						"desc" => __( 'Enter the heading for your portfolio carousel.', 'wap8theme-i18n' ),
						"id" => "artisan_home_carousel_heading",
						"std" => __( 'Additional Recent Work', 'wap8theme-i18n' ),
						"type" => "text"
						);
						
	$options[] = array( "name" => __( 'Select Amount of Portfolio Carousel Items to Show', 'wap8theme-i18n' ),
						"desc" => __( 'Select home many portfolio carousel items you would like to show on your home page. Please note, if you choose &#147;4&#148;, the jQuery carousel will be automatically disabled.', 'wap8theme-i18n' ),
						"id" => "artisan_home_carousel_posts",
						"std" => "four",
						"type" => "select",
						"class" => "mini",
						"options" => $artisan_blog_posts
						);
						
	$options[] = array( "name" => __( 'Enable Portfolio Carousel Toggle Switch', 'wap8theme-i18n' ),
						"desc" => __( 'Check this option to enable your portfolio carousel toggle switch. Once enabled, your users will be able to toggle the portfolio carousel opened or closed.', 'wap8theme-i18n' ),
						"id" => "artisan_home_carousel_toggle",
						"std" => "",
						"type" => "checkbox"
						);
						
	// Home Page Body Settings
						
	$options[] = array( "name" => __( 'Home Body Settings', 'wap8theme-i18n' ),
						"type" => "heading"
						);
						
	$options[] = array( "name" => __( 'Enable Home Page Body Copy', 'wap8theme-i18n' ),
						"desc" => __( 'Check this option to enable your home page body copy. Once enabled, you will be able to enter your body copy in the next three options. Your home page, widget ready sidebar will automatically be enabled.', 'wap8theme-i18n' ),
						"id" => "artisan_home_body",
						"std" => "",
						"type" => "checkbox"
						);
						
	$options[] = array( "name" => __( 'Home Page Body Copy Heading', 'wap8theme-i18n' ),
						"desc" => __( 'Enter the heading for your home page body copy.', 'wap8theme-i18n' ),
						"id" => "artisan_home_body_heading",
						"std" => "",
						"type" => "text"
						);
						
	$options[] = array( "name" => __( 'Enter Home Page Body Copy Headline', 'wap8theme-i18n' ),
						"desc" => __( 'Enter the headline you would like for your home page body copy. Your headline will be wrapped inside of a <code>h3</code> tag. If left empty, no headline will appear.', 'wap8theme-i18n' ),
						"id" => "artisan_home_body_headline",
						"std" => "",
						"type" => "textarea"
						);
						
	$options[] = array( "name" => __( 'Enter Home Page Body Copy Text', 'wap8theme-i18n' ),
						"desc" => __( 'Enter the text you would like for your home page body copy. Your text will be wrapped inside of a <code>p</code> tag. If left empty, no body copy will appear.', 'wap8theme-i18n' ),
						"id" => "artisan_home_body_text",
						"std" => "",
						"type" => "textarea"
						);
						
	$options[] = array( "name" => __( 'Split Homae Page Body Copy into Columns', 'wap8theme-i18n' ),
						"desc" => __( 'Check this option to split your home page body copy into two columns.', 'wap8theme-i18n' ),
						"id" => "artisan_home_body_columns",
						"std" => "",
						"type" => "checkbox"
						);
						
	$options[] = array( "name" => __( 'Enable Callout Button', 'wap8theme-i18n' ),
						"desc" => __( 'Check this option to enable your home page body copy callout button. Once enabled, you will be able to enter the button&#146;s text and choose a page link in the next two options.', 'wap8theme-i18n' ),
						"id" => "artisan_home_body_callout",
						"std" => "",
						"type" => "checkbox"
						);
						
	$options[] = array( "name" => __( 'Enter Callout Button Text', 'wap8theme-i18n' ),
						"desc" => __( 'Enter the text you would like to appear in your callout button.', 'wap8theme-i18n' ),
						"id" => "artisan_home_body_button",
						"std" => __( 'Learn More', 'wap8theme-i18n' ),
						"type" => "text"
						);
						
	$options[] = array( "name" => __( 'Select Callout Button Page Link', 'wap8theme-i18n' ),
						"desc" => __( 'Select the page to link with your callout button.', 'wap8theme-i18n' ),
						"id" => "artisan_home_body_link",
						"type" => "select",
						"options" => $options_pages
						);
						
	// Home Page Blog Settings
						
	$options[] = array( "name" => __( 'Home Blog Settings', 'wap8theme-i18n' ),
						"type" => "heading"
						);
						
	$options[] = array( "name" => __( 'Enable Home Page Blog Posts', 'wap8theme-i18n' ),
						"desc" => __( 'Check this option to enable your home page blog posts.', 'wap8theme-i18n' ),
						"id" => "artisan_home_blog",
						"std" => "",
						"type" => "checkbox"
						);
						
	$options[] = array( "name" => __( 'Home Page Blog Posts Heading', 'wap8theme-i18n' ),
						"desc" => __( 'Enter the heading for your home page blog posts.', 'wap8theme-i18n' ),
						"id" => "artisan_home_blog_heading",
						"std" => __( 'From our Blog', 'wap8theme-i18n' ),
						"type" => "text"
						);
						
	$options[] = array( "name" => __( 'Select Amount of Home Page Blog Posts to Show', 'wap8theme-i18n' ),
						"desc" => __( 'Select home many blog posts you would like to show on your home page. Please note, if you choose &#147;4&#148;, the jQuery carousel will be automatically disabled.', 'wap8theme-i18n' ),
						"id" => "artisan_home_blog_count",
						"std" => "four",
						"type" => "select",
						"class" => "mini",
						"options" => $artisan_blog_posts
						);
						
	$options[] = array( "name" => __( 'Enable Home Page Blog Posts Toggle Switch', 'wap8theme-i18n' ),
						"desc" => __( 'Check this option to enable your Home Page Blog Posts Toggle Switch. Once enabled, your users will be able to toggle the Home Page Blog Posts off and on.', 'wap8theme-i18n' ),
						"id" => "artisan_home_blog_toggle",
						"std" => "",
						"type" => "checkbox"
						);
						
	// Portfolio Settings
						
	$options[] = array( "name" => __( 'Portfolio Settings', 'wap8theme-i18n' ),
						"type" => "heading"
						);
						
	$options[] = array( "name" => __( 'Enable Callout Messaging', 'wap8theme-i18n' ),
						"desc" => __( 'Check this option to enable your portfolio Callout Messaging. Once enabled, your designated messaging will appear at the end of either your portfolio page, case study page or both.', 'wap8theme-i18n' ),
						"id" => "artisan_portfolio_callout",
						"std" => "",
						"type" => "checkbox"
						);
						
	$options[] = array( "name" => __( 'Select Page to Display Callout Message', 'wap8theme-i18n' ),
						"desc" => __( 'Select which page you would like to display your callout message.', 'wap8theme-i18n' ),
						"id" => "artisan_portfolio_callout_page",
						"std" => "both",
						"type" => "select",
						"class" => "tiny",
						"options" => $artisan_portfolio_callout_page
						);
						
	$options[] = array( "name" => __( 'Select Current Callout Status', 'wap8theme-i18n' ),
						"desc" => __( 'Select your current callout status. If you select &#147;Available&#148;, a callout button will be displayed and you must select a linked page.', 'wap8theme-i18n' ),
						"id" => "artisan_portfolio_callout_status",
						"std" => "available",
						"type" => "select",
						"class" => "tiny",
						"options" => $artisan_callout_status
						);
						
	$options[] = array( "name" => __( 'Enter Available Callout Message', 'wap8theme-i18n' ),
						"desc" => __( 'Enter the message you would like to display when you are accepting new projects.', 'wap8theme-i18n' ),
						"id" => "artisan_portfolio_callout_available",
						"std" => __( 'We currently are accepting requests for new projects.', 'wap8theme-i18n' ),
						"type" => "text"
						);
						
	$options[] = array( "name" => __( 'Enter Portfolio Callout Button Text', 'wap8theme-i18n' ),
						"desc" => __( 'Enter the text you would like to appear in your callout button.', 'wap8theme-i18n' ),
						"id" => "artisan_portfolio_callout_button",
						"std" => __( 'Request a Quote', 'wap8theme-i18n' ),
						"type" => "text"
						);
						
	$options[] = array( "name" => __( 'Select Portfolio Callout Button Page Link', 'wap8theme-i18n' ),
						"desc" => __( 'Select the page to link with your portfolio callout button.', 'wap8theme-i18n' ),
						"id" => "artisan_portfolio_callout_link",
						"type" => "select",
						"options" => $options_pages
						);
						
	$options[] = array( "name" => __( 'Enter Unavailable Callout Message', 'wap8theme-i18n' ),
						"desc" => __( 'Enter the message you would like to display when you are not accepting new projects.', 'wap8theme-i18n' ),
						"id" => "artisan_portfolio_callout_unavailable",
						"std" => __( 'We currently are not accepting requests for new projects.', 'wap8theme-i18n' ),
						"type" => "text"
						);
						
	// Blog Posts Settings
						
	$options[] = array( "name" => __( 'Blog Posts Settings', 'wap8theme-i18n' ),
						"type" => "heading"
						);
						
	$options[] = array( "name" => __( 'Enable Post Featured Image', 'wap8theme-i18n' ),
						"desc" => __( 'Check this option to enable your blog post&#146;s featured image. Once enabled, your designated featured image will appear at the top of the post, below the title.', 'wap8theme-i18n' ),
						"id" => "artisan_blog_image",
						"std" => "",
						"type" => "checkbox"
						);
						
	$options[] = array( "name" => __( 'Enable Post Author Bio', 'wap8theme-i18n' ),
						"desc" => __( 'Check this option to enable your blog post author&#146;s bio. Once enabled, the bio will appear immediately following the post.', 'wap8theme-i18n' ),
						"id" => "artisan_blog_author",
						"std" => "",
						"type" => "checkbox"
						);
						
	$options[] = array( "name" => __( 'Enable Related Blog Posts', 'wap8theme-i18n' ),
						"desc" => __( 'Check this option to enable related blog posts based on a tag relationship. You will be able to set how many related posts to show in the next option.', 'wap8theme-i18n' ),
						"id" => "artisan_blog_related",
						"std" => "",
						"type" => "checkbox"
						);
						
	$options[] = array( "name" => __( 'Select Amount of Related Blog Posts to Show', 'wap8theme-i18n' ),
						"desc" => __( 'Select home many related blog posts you would like to show.', 'wap8theme-i18n' ),
						"id" => "artisan_blog_related_count",
						"std" => "four",
						"type" => "select",
						"class" => "mini",
						"options" => $artisan_related_posts
						);
									
	return $options;

}
