<?php

/*
Plugin Name: jPlayable
Plugin URI: http://www.wearepixel8.com
Description: Insert a HTML 5 media player, powered by jPlayer, into posts.
Version: 1.0.0
Author: We Are Pixel8
Author URI: http://www.wearepixel8.com
License:
	Copyright 2012 We Are Pixel8 <hello@wearepixel8.com>
	
	This program is free software; you can redistribute it and/or modify it under
	the terms of the GNU General Public License, version 2, as published by the Free
	Software Foundation.
	
	This program is distributed in the hope that it will be useful, but WITHOUT ANY
	WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
	PARTICULAR PURPOSE. See the GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software Foundation, Inc.,
	51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
*/

/*----------------------------------------------------------------------------*/
/* Audio Player
/*----------------------------------------------------------------------------*/

/**
 * Audio Player
 *
 * A template tag that will render an audio player for audio portfolio posts.
 * This template tag must be inside of the loop.
 *
 * @param $post_id
 *
 * @package Artisan Creatif
 * @version 2.0.0
 * @since 2.0.0
 * @author Erik Ford for We Are Pixel8 <@notdivisible>
 *
 */

function wap8_audio_player( $post_id ) {
	
	global $post;
	
	// saved meta data
	$cover = get_post_meta( $post->ID, '_wap8_audio_cover', true );
	$mp3 = get_post_meta( $post->ID, '_wap8_audio_file', true );
	$m4a = get_post_meta( $post->ID, '_wap8_audio_m4a_file', true );
	$oga = get_post_meta( $post->ID, '_wap8_audio_ogg_file', true );
	
	// supplied formats
	if ( !empty( $mp3 ) ) {
		
		$supplied = 'mp3, ';
		
	} if ( !empty( $m4a ) ) {
		
		$supplied .= 'm4a, ';
		
	} if ( !empty( $oga ) ) {
		
		$supplied .= 'oga,';
		
	}
	
	?>
<script type="text/javascript">
	(function($) {
		$(document).ready(function() {
				
			$('#jquery_jplayer_<?php the_ID(); ?>').jPlayer({
				ready: function (event) {
					$(this).jPlayer('setMedia', {
						<?php if ( !empty( $mp3 ) ) : ?>
						mp3: '<?php echo $mp3; ?>',
						<?php endif; if ( !empty( $m4a ) ) : ?>
						m4a: '<?php echo $m4a; ?>',
						<?php endif; if ( !empty( $oga ) ) : ?>
						oga: '<?php echo $oga; ?>'
						<?php endif; ?>
						});
					},
				swfPath: '<?php echo get_template_directory_uri() . '/js/jplayer/Jplayer.swf'; ?>',
				cssSelectorAncestor: '#jp_container_<?php the_ID(); ?>',
				supplied: '<?php echo $supplied; ?> all',
				volume: 0.5,
				wmode: 'window'
			});
		
		});
	})(jQuery);
</script>

<?php if ( $cover && has_post_thumbnail( $post->ID ) ) { // if use cover image and a featured image has been set

	echo '<div class="jp-audio-cover">' . "\n";

	the_post_thumbnail( 'img-460x460' );
	
	echo '</div>' . "\n";
	
} ?>
	
<div id="jquery_jplayer_<?php the_ID(); ?>" class="jp-jplayer"></div>
		
<div id="jp_container_<?php the_ID(); ?>" class="jp-audio"><!-- Begin .jp-audio -->
	<div class="jp-type-single"><!-- Begin .jp-type-single -->
		<div class="jp-gui jp-interface clear"><!-- Begin .jp-interface -->
			<ul class="jp-controls">
				<li><a href="#" class="jp-play" tabindex="1" title="<?php esc_attr_e( 'Play', 'wap8theme-i18n' ); ?>"><?php _e( 'Play', 'wap8theme-i18n' ); ?></a></li>
				<li class="jp-pause-button"><a href="#" class="jp-pause" tabindex="1" title="<?php esc_attr_e( 'Pause', 'wap8theme-i18n' ); ?>"><?php _e( 'Pause', 'wap8theme-i18n' ); ?></a></li>
			</ul>
			
			<div class="jp-current-time"></div>
				
			<div class="jp-progress"><!-- Begin .jp-progress -->
				<div class="jp-seek-bar">
					<div class="jp-play-bar"></div>
				</div>
			</div><!-- End .jp-progress -->
					
			<div class="jp-duration"></div>
							
			<div class="jp-volume-bar"><!-- Begin .jp-volume-bar -->
				<div class="jp-volume-bar-value"></div>
			</div><!-- End .jp-volume-bar -->
		</div><!-- End .jp-interface -->
	</div><!-- End .jp-type-single -->
</div><!-- End .jp-audio -->
	<?php
	
}

?>
