<?php

/**
 * We Are Pixel8 Flickr Class
 *
 * @package Flickr Feedr
 * @version 1.0.0
 * @since 1.0.0
 * @author Erik Ford for We Are Pixel8 <@notdivisible>
 *
 */

class wap8_flickr {

/*----------------------------------------------------------------------------*/
/* Sanitize Double Quotes
/*----------------------------------------------------------------------------*/

	function wap8_flickr_cleanup( $s = null ) {
		if ( !$s ) return false;
    
    	else {
    		return str_replace( '"', '', $s );
    	}
	}

/*----------------------------------------------------------------------------*/
/* Return Flickr URL based on Image Size
/*----------------------------------------------------------------------------*/	

	function wap8_flickr_photo( $url, $size ) {
	
		$url = explode( '/', $url );
		$photo = array_pop( $url );

		switch( $size ) {
		
			case 'square':
				$r = preg_replace( '/(_(s|t|m|b))?\./i', '_s.', $photo );
				break;
			
			case 'thumb':
				$r = preg_replace( '/(_(s|t|m|b))?\./i', '_t.', $photo );
				break;
			
			case 'small':
				$r = preg_replace( '/(_(s|t|m|b))?\./i', '_m.', $photo );
				break;
			
			case 'large':
				$r = preg_replace( '/(_(s|t|m|b))?\./i', '_b.', $photo );
				break;
			
			default: // Medium
				$r = preg_replace( '/(_(s|t|m|b))?\./i', '.', $photo );
				break;
			
			}

		$url[] = $r;
    
    	return implode( '/', $url );
    	
    }

/*----------------------------------------------------------------------------*/
/* Find First Image
/*----------------------------------------------------------------------------*/

	function wap8_find_flickr_photo( $data ) {
		preg_match_all( '/<img src="([^"]*)"([^>]*)>/i', $data, $m );
		return $m[1][0];
	}

}

?>
