<?php

/*
Plugin Name: Case Studies
Plugin URI: http://www.wearepixel8.com
Description: A widget that will display your recent case studies. This plugin will only work with the Portfolio plugin bundled with Artisan Creatif.
Version: 1.0.0
Author: We Are Pixel8
Author URI: http://www.wearepixel8.com
License:
	Copyright 2012 We Are Pixel8 <hello@wearepixel8.com>
	
	This program is free software; you can redistribute it and/or modify it under
	the terms of the GNU General Public License, version 2, as published by the Free
	Software Foundation.
	
	This program is distributed in the hope that it will be useful, but WITHOUT ANY
	WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
	PARTICULAR PURPOSE. See the GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software Foundation, Inc.,
	51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
*/

/*----------------------------------------------------------------------------*/
/* Case Studies
/*----------------------------------------------------------------------------*/
 
add_action( 'widgets_init', 'wap8_case_studies_widget' );

/**
 * Case Studies widget
 *
 * Register the Case Studies widget.
 *
 * @package Case Studies
 * @version 1.0.0
 * @since 1.0.0
 * @author Erik Ford for We Are Pixel8 <@notdivisible>
 *
 */

function wap8_case_studies_widget() {
	register_widget( 'wap8_Case_Studies_Widget' );
}

/*----------------------------------------------------------------------------*/
/* Extend WP_Widget by adding This Widget Class
/*----------------------------------------------------------------------------*/

class wap8_Case_Studies_Widget extends WP_Widget {

	// widget setup
	function wap8_Case_Studies_Widget() {
		$widget_ops = array(
			'classname'   => 'wap8_case_studies_widget',
			'description' => __( 'Display recent case studies.', 'wap8theme-i18n' )
			);
			
		$this->WP_Widget( 'wap8-Case-Studies-widget', __( 'Case Studies', 'wap8theme-i18n' ), $widget_ops );	
	}
	
	// widget output
	function widget( $args, $instance ) {
		
		extract( $args );
		
		$title = apply_filters( 'widget_title', $instance['title'] );
		$project_count = $instance['project_count'];
		
		echo $before_widget;
		
		if ( $title ) {
			echo $before_title . $title . $after_title;	
		}
		
		$args = array(
			'post_type'      => 'portfolio',
			'post_status'    => 'publish',
			'posts_per_page' => $project_count,
			'orderby'        => 'date',
			'order'          => 'DESC'
			);
							
		$case_studies_widget = new WP_Query( $args );
			
		if ( $case_studies_widget->have_posts() ) :
		
		echo '<ul class="clear">' . "\n";
		
		while ( $case_studies_widget-> have_posts() ) : $case_studies_widget-> the_post(); ?>
		
			<li>
				<?php if ( has_post_thumbnail() ) { ?>
				<a href="<?php the_permalink(); ?>" rel="bookmark" title="<?php the_title_attribute(); ?>"><?php the_post_thumbnail( 'img-75x75', array( 'title' => get_the_title() ) ); ?></a>
				<?php } ?>
			</li>
			
		<?php endwhile;
		
		echo '</ul>' . "\n";
		
		else : echo '<p>' . __( 'There are no published case studies', 'wap8theme-i18n' ) . '</p>' . "\n";
		
		endif; wp_reset_query();
		
		echo $after_widget;		
	}
	
	// update widget
	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = strip_tags( $new_instance['title'] );
		$instance['project_count'] = ( int ) $new_instance['project_count'];
		return $instance;
	}
	
	// widget form
	function form( $instance ) {
		$defaults = array(
			'title' => __( 'Recent Work', 'wap8theme-i18n' )
		);
		$instance = wp_parse_args( ( array ) $instance, $defaults );

		if ( (int) $instance['project_count'] < 1 )
			(int) $intsance['project_count'] = 4;
		else if ( (int) $instance['project_count'] > 8 )
			(int) $instance['project_count'] = 8;

		?>

		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title', 'wap8theme-i18n' ); ?></label><br />
			<input class="widefat" type="text" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title'];?>" />
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'project_count' ); ?>"><?php _e( 'Case Studies to Show', 'wap8theme-i18n' ); ?></label>
			<input type="text" id="<?php echo $this->get_field_id( 'project_count' ); ?>" name="<?php echo $this->get_field_name( 'project_count' ); ?>" value="<?php echo $instance['project_count'];?>" size="3" maxlength="1" /> <small><?php _e( 'Max: 8', 'wap8theme-i18n' ); ?></small>
		</p>

		<?php	
	}		
	
}

?>
