<?php

/**
 * Artisan Creatif Home Body Template
 * 
 * This is the custom Home Page Body Template that will be used to render the homw
 * page body copy and sidebar.
 *
 * You should only customize this template in a child theme.
 *
 * @package Artisan Creatif
 * @version 1.0.0
 * @since 2.0.0
 * @author Erik Ford for We Are Pixel8 <@notdivisible>
 *
 */

$callout = of_get_option( 'artisan_home_body_link' );
$link = get_permalink( $callout );
$cols = of_get_option( 'artisan_home_body_columns' ); ?>

		<div class="flowlines"><!-- Begin .flowlines -->
			<div class="wrapper"><!-- Begin .wrapper for home body .flowlines -->
				<h2><?php echo esc_html( of_get_option( 'artisan_home_body_heading' ) ); ?></h2>
			</div><!-- End .wrapper for home body .flowlines -->
		</div><!-- End .flowlines -->
		
		<div id="home-body-wrapper" class="clear"><!-- Begin #home-body-wrapper -->
			<div class="artisancolumn-700 vertmargin-10 alignleft home-body-entry">
				<?php if ( of_get_option( 'artisan_home_body_headline' ) != '' ) { ?>
				<h3><?php echo esc_html( of_get_option( 'artisan_home_body_headline' ) ); ?></h3>
				<?php } ?>
				
				<?php if ( of_get_option( 'artisan_home_body_text' ) != '' ) { ?>
				<p <?php if ( $cols ) { echo 'class="split-columns"'; } ?>><?php echo esc_html( of_get_option( 'artisan_home_body_text' ) ); ?></p>
				<?php } ?>
				
				<?php if ( of_get_option( 'artisan_home_body_callout' ) == '1' ) { ?>
				<p><a class="pill-button" href="<?php echo esc_url( $link ); ?>"><?php echo esc_html( of_get_option( 'artisan_home_body_button' ) ); ?></a></p>
				<?php } ?>
			</div>
			
			<?php get_sidebar( 'home' ); ?>
		
		</div><!-- End #home-body-wrapper -->
