<?php

/**
 * Artisan Creatif Carousel Slider Home Portfolio Template
 *
 * This template will be used to generate the home page carousel slider for
 * portfolio posts tagged as home-portfolio.
 *
 * You should only customize this template in a child theme.
 *
 * @package Artisan Creatif
 * @version 1.0.0
 * @since 2.0.0
 * @author Erik Ford for We Are Pixel8 <@notdivisible>
 *
 */

if ( of_get_option( 'artisan_home_carousel_posts' ) == 'four' ) {
	$numberposts = 4;
} else if ( of_get_option( 'artisan_home_carousel_posts' ) == 'eight' ) {
	$numberposts = 8;
} else if ( of_get_option( 'artisan_home_carousel_posts' ) == 'twelve' ) {
	$numberposts = 12;
} else if ( of_get_option( 'artisan_home_carousel_posts' ) == 'sixteen' ) {
	$numberposts = 16;
} ?>


		<div class="flowlines"><!-- Begin .flowlines -->
			<div class="wrapper"><!-- Begin .wrapper for home portfolio carousel .flowlines -->
				<h2><?php echo esc_html( of_get_option( 'artisan_home_carousel_heading' ) ); ?></h2>
				
				<?php if ( $numberposts > 4 || of_get_option( 'artisan_home_carousel_toggle' ) == '1' ) { ?>
				<ul class="slide-controls carousel-controls clear">
					<?php if ( $numberposts > 4 ) { // enough blog posts to warrant a slider ?>
					<li><a class="slide-controls-next" href="#" title="<?php _e( 'Next', 'wap8theme-i18n' ); ?>"><?php _e( 'Next', 'wap8theme-i18n' ); ?></a></li>
					<li><a class="slide-controls-previous" href="#" title="<?php _e( 'Previous', 'wap8theme-i18n' ); ?>"><?php _e( 'Previous', 'wap8theme-i18n' ); ?></a></li>
					<?php } ?>
					<?php if ( of_get_option( 'artisan_home_carousel_toggle' ) == '1' ) { ?><li><a class="slide-controls-toggler" href="#" title="<?php _e( 'Toggle Portfolio', 'wap8theme-i18n' ); ?>"><?php _e( 'Toggle Portfolio', 'wap8theme-i18n' ); ?></a></li><?php } ?>
				</ul>
				<?php } ?>
				
			</div><!-- End .wrapper for home portfolio carousel .flowlines -->
		</div><!-- End .flowlines -->
		
		<div id="home-carousel-wrapper" class="clear"><!-- Begin #home-carousel-wrapper -->
			<div id="home-carousel-slides"><!-- Begin #home-carousel-slides -->
				
			<?php
			
				// get the cached version of the query if one exists
				if ( false === ( $carousel_hm = get_transient( 'carousel_hm' ) ) ) {
    
					// it did not exist, so run through the query
					global $post;
				
					$args = array(
						'numberposts'    => $numberposts,
						'post_type'      => 'portfolio',
						'portfolio-tags' => 'home-portfolio'
						);
							
					$carousel_hm = get_posts( $args );
								
					// set the transient for 8 hours
					set_transient( 'carousel_hm', $carousel_hm, 60*60*8 );
					
					}
				
				foreach( $carousel_hm as $post ) :
				
				setup_postdata( $post );
				
				$postid = $post->ID;
   				$title = $post->post_title;		

				if ( ++$post_counter % 4 == 1 ) {
         			if ( $post_counter > 1 ) {
            			echo '</div><!-- End .blog-slides -->';  // End previous grp
         				}
       	  				echo '<div class="blog-slides">';  // Start a new grp
   					} ?>
				
				<div <?php post_class( 'home-blog-column alignleft' ); ?> id="post-<?php the_ID(); ?>-carousel">
					
					<div class="grid-title">
						<?php the_title( '<h3>', '</h3>' ); ?>
					</div>
					
					<div class="grid-thumb">
					<?php if ( has_post_thumbnail() ) { ?>
						<a href="<?php the_permalink(); ?>" rel="bookmark" title="<?php the_title_attribute(); ?>"><?php the_post_thumbnail( 'img-220x165', array( 'title' => get_the_title() ) ); ?></a>
					<?php } ?>					
					</div>
						
				</div>
				
			<?php endforeach; // End custom loop ?>
				</div><!-- End .blog-slides -->
				
			</div><!-- End #home-carousel-slides -->			
		</div><!-- End #home-carousel-wrapper -->
