<?php

/**
 * Artisan Creatif Comments
 *
 * This template is loaded by single.php and contains comments and the comment
 * form. The actual display of comments is handled the wap8_user_comments_cb()
 * and wap8_trackback_comments_cb() functions located in the functions.php file.
 *
 * @package Artisan Creatif
 * @version 1.0.0
 * @since 2.0.0
 * @author Erik Ford for We Are Pixel8 <@notdivisible>
 *
 */

?>
	<section id="comments" class="<?php if ( of_get_option( 'artisan_sidebar' ) == '2c-l-fixed' ) { echo 'alignleft'; } else if ( of_get_option( 'artisan_sidebar' ) == '2c-r-fixed' ) { echo 'alignright'; } ?>"><!-- Begin #comments -->
	<?php if ( post_password_required() ) : // if this is a password protected post ?>
		<p><?php _e( 'This post is password protected. Enter the password to view any comments.', 'wap8theme-i18n' ); ?></p>
	</section><!-- End #comments -->
	<?php
		
		/* Stop the rest of comments.php from being processed, but don't kill the
		 * script entirely -- we still have to fully load the template.
		 */
		
		return;
		
		endif; // end password protection conditional check
	
	?>

	<?php if ( have_comments() ) : // if this post has comments ?>
	
		<h3><?php printf( _n( 'One Comment', '%1$s Comments', get_comments_number(), 'wap8theme-i18n' ), number_format_i18n( get_comments_number() ) ); ?></h3>

	<?php if ( !empty( $comments_by_type['comment'] ) ) : // if there are user generated comments ?>
		
		<ol class="commentlist">
			<?php
				
				/* Loop through and list the comments. Tell wp_list_comments() to use the
				 * wap8_user_comments_cb() to markup the comments.
				 */
				
				wp_list_comments( array(
					'callback'	=> 'wap8_user_comments_cb',
					'type'		=> 'comment'
					)
				);
			
			?>
		</ol>
		
	<?php endif; // end user generated comments conditional check ?>
		
	<?php if ( !empty( $comments_by_type['pings'] ) ) : // if there are pingbacks and trackbacks ?>
		
		<h3><?php _e( 'Trackbacks &amp; Pingbacks', 'wap8theme-i18n' ); ?></h3>
		
		<ol class="trackbacklist">
			<?php
			
				/* Loop through and list the trackbacks. Tell wp_list_comments() to use the
				 * wap8_trackback_comments_cb() to markup the trackbacks.
				 */
				 
				wp_list_comments( array(
					'callback'	=> 'wap8_trackback_comments_cb',
					'type'		=> 'pings'
					)
				);
				
			?>		
		</ol>
	
	<?php endif; // end pingbacks and trackbacks conditional test ?>
	
	<?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) : // if comments pagination is enabled and there are more than one page of comments ?>
		
		<div class="post-navigation clear">
			<p class="alignleft"><?php previous_comments_link( __( '&laquo; Older Comments', 'wap8theme-i18n' ) ); ?></p>
			<p class="alignright"><?php next_comments_link( __( 'Newer Comments &raquo;', 'wap8theme-i18n' ) ); ?></p>
		</div>
		
	<?php endif; // end comments pagination conditional check ?>

	<?php elseif ( !comments_open() && !is_page() && post_type_supports( get_post_type(), 'comments' ) ) : // if there are no comments and comments are closed and the post type supports comments ?>
		
		<h3><?php _e( 'Comments Closed', 'wap8theme-i18n' ); ?></h3>
		
		<p><?php _e( 'Comments for this post are now closed.', 'wap8theme-i18n' ); ?></p>
		
	<?php endif; // end conditional check for post comments ?>

	<?php
		comment_form(
			array(
				'label_submit'			=> __( 'Submit Comment', 'wap8theme-i18n' ),
				'title_reply'			=> __( 'Leave a Comment', 'wap8theme-i18n' ),
				'fields'				=> array(
											'author' => '<p><label for="author">' . __( 'Your Name', 'wap8theme-i18n' )  . ( $req ? '<span class="rq">*</span>' : '' ) . '</label><input id="author" name="author" type="text" value="' . esc_attr( $commenter['comment_author'] ) . '" size="30" tabindex="1"' . $aria_req . ' /></p>',
											'email'  => '<p><label for="email">' . __( 'Your Email', 'wap8theme-i18n' ) . ( $req ? '<span class="rq">*</span>' : '' ) . '</label><input id="email" name="email" type="email" value="' . esc_attr(  $commenter['comment_author_email'] ) . '" size="30" tabindex="2"' . $aria_req . ' /></p>',
											'url'    => '<p><label for="url">' . __( 'Your URL', 'wap8theme-i18n' ) . '</label>' . '<input id="url" name="url" type="url" value="' . esc_attr( $commenter['comment_author_url'] ) . '" size="30" tabindex="3" /></p>' . '<!-- #<span class="hiddenSpellError" pre="">form-section-url</span> .form-section -->'
										),			
				'comment_field'			=> '<p><label for="comment">' . __( 'Comment<span class="rq">&#42;</span>', 'wap8theme-i18n' ) . '</label><textarea id="comment" name="comment" aria-required="true" tabindex="4"></textarea></p>',
				'comment_notes_before'	=> __( '<p>Your email address will never be published or shared and required fields are marked with an asterisk &#40;<span class="rq">&#42;</span>&#41;.</p>', 'wap8theme-i18n' ),
				'comment_notes_after'	=> ''	
			)
		);
		
	?>

	</section><!-- End #comments -->
