<?php
/**********************************************************************
* OSAKA WORDPRESS THEME
* (Ideal For Business And Personal Use: Portfolio or Blog)   
* 
* File name:   
*      search.php
* Brief:       
*      search page
* Author:      
*      DigitalCavalry
* Author URI:
*      http://themeforest.net/user/DigitalCavalry
* Contact:
*      digitalcavalry@gmail.com   
***********************************************************************/ 

    get_header();                                                
?>

      <div class="dc-primary-wrapper">      
        <div class="dc-secondary-wrapper">
            
            <?php 
            
                $search_query = GetDCCPI()->getIRenderer()->getSearchQueryVar(array('empty' => true));
                $breadcrumb_title = __('Search results', CMS_TXT_DOMAIN);

                $crumb = new DCC_Breadcrumb();
                echo $crumb->wpBreadcrumb(array('title' => $breadcrumb_title));                      
            ?>
            <div class="dc-page-seo-wrapper <?php echo GetDCCPI()->getIRenderer()->getSearchPageLayoutClass(); ?>">
            <div class="dc-page-content">
            <div class="dc-sixteen dc-columns"> 
                <?php                                                                                                          
                
                    if(GetDCCPI()->getIGeneral()->getOption('search_form_display'))
                    {
                        $out = '';                                    
                        $out .= '<div class="dc-search-page-form">';
                        
                            $out .= '<form role="search" method="get" id="searchform" action="'.get_bloginfo('url').'">';
                                $out .= '<div class="dc-control-label-nomargin"><span class="inner-label">'.GetDCCPI()->getIGeneral()->getOption('search_dummy_text').'</span></div>';                        
                                $out .= '<input type="text" class="dc-search-control" value="'.$search_query.'" name="s" />';
                            $out .= '</form>';
                        $out .= '</div>';
                        echo $out;        
                    }       

                    $per_page = GetDCCPI()->getIGeneral()->getOption('search_per_page');           
                    $paged = GetDCCPI()->getIRenderer()->getPagedQueryVar();

                    $args = array('s' => $search_query, 'posts_per_archive_page' => $per_page, 'paged' => $paged);

                    $search_in = array();                        
                    if(GetDCCPI()->getIGeneral()->getOption('search_in_posts')) { array_push($search_in, 'post'); }
                    if(GetDCCPI()->getIGeneral()->getOption('search_in_pages')) { array_push($search_in, 'page'); }
                    if(GetDCCPI()->getIGeneral()->getOption('search_in_member')) { array_push($search_in, DCC_ControlPanelCustomPosts::PT_MEMBER_POST); }         
                    if(GetDCCPI()->getIGeneral()->getOption('search_in_service')) { array_push($search_in, DCC_ControlPanelCustomPosts::PT_SERVICE_POST); }
                    if(GetDCCPI()->getIGeneral()->getOption('search_in_project')) { array_push($search_in, DCC_ControlPanelCustomPosts::PT_PROJECT_POST); }
                    if(count($search_in) == 0) { array_push($search_in, 'post'); }
                    $args['post_type'] = $search_in; 
                    
                    $dc_query = new WP_Query($args);                    
                    $out = '';
                    //var_dump((int)$dc_query->max_num_pages);
                    if($dc_query->post_count)
                    {
                        for($i = 0; $i < $dc_query->post_count; $i++)
                        {
                            if($i > 0) { $out .= '<div class="blog-post-short-separator"></div>'; }
                            $p = new DCC_WPPost($dc_query->posts[$i]);
                            
                            if($p->post_type == 'post') 
                            { $out .= GetDCCPI()->getIRenderer()->wpPostShort(array('post' => $p)); }
                            else   
                            if($p->post_type == 'page')
                            { $out .= GetDCCPI()->getIRenderer()->wpPageShort(array('post' => $p)); } 
                            else
                            if($p->post_type == DCC_ControlPanelCustomPosts::PT_MEMBER_POST)
                            { $out .= GetDCCPI()->getIRenderer()->wpMemberShort(array('post' => $p)); }           
                            else
                            if($p->post_type == DCC_ControlPanelCustomPosts::PT_SERVICE_POST)
                            { $out .= GetDCCPI()->getIRenderer()->wpServiceShort(array('post' => $p)); }
                            else
                            if($p->post_type == DCC_ControlPanelCustomPosts::PT_PROJECT_POST)
                            { $out .= GetDCCPI()->getIRenderer()->wpProjectShort(array('post' => $p)); }
                            
                        }    
                        echo $out;                       
                    } else
                    {
                        $content = GetDCCPI()->getIGeneral()->getOption('search_content');

                        $out = '';                    
                        $out .= apply_filters('the_content', $content);                                      
                        echo $out; 
                    }
                   
                    echo GetDCCPI()->getIRenderer()->wpQueryPaginationBlock(array('paged' => $paged, 'maxpage' => $dc_query->max_num_pages));                                               
                    
                ?>        
                                   
                </div> <!-- dc-sixteen dc-columns -->
                <div class="dc-clear-both"></div>
            </div> <!-- dc-page-content --> 
            
                <?php GetDCCPI()->getIRenderer()->wpSearchPageLeftSidebar(); ?>  
            </div>  <!-- seo-wrapper -->
            
            <?php 
                GetDCCPI()->getIRenderer()->wpSearchPageRightSidebar();
            ?>
            <div class="dc-clear-both"></div>                
        </div> <!-- dc-secondary-wrapper -->    
    </div> <!-- dc-primary-wrapper -->   
    
<?php    
    get_footer();
?>



