/**********************************************************************
* OSAKA WORDPRESS THEME 
* (Ideal For Business And Personal Use: Portfolio or Blog)   
* 
* File name:   
*      common.js
* Brief:       
*      Core theme javascript file file
* Author:      
*      DigitalCavalry
* Author URI:
*      http://themeforest.net/user/DigitalCavalry
* Contact:
*      digitalcavalry@gmail.com 
**********************************************************************/

if(!jQuery().dcf_BasicResponsiveSlider) 
{ 
 
 (function($) {
  jQuery.fn.dcf_BasicResponsiveSlider = function(options) {  
        
    // Default settings
    var settings = $.extend({
      auto: true,             // Boolean: Animate automatically, true or false
      speed: 1000,            // Integer: Speed of the transition, in milliseconds
      timeout: 4000,          // Integer: Time between slide transitions, in milliseconds
      pager: true,           // Boolean: Show pages, true or false
      pause: true,           // Boolean: Pause on hover, true or false
      maxwidth: 0,            // Integer: Max-width of the slideshow, in pixels  
      maxwidth_pager: true,
      maxwidth_wrapper: true,
      transition: 'fade',
      nextprev: true
    }, options);

    return this.each(function () {

        var $wrapper = jQuery(this);
        var $slider = jQuery(this).find('ul:first'); 
        $slider.data('dc_blocked', false);
        $slider.data('dc_hover_blocked', false);
        var $slide = $slider.find('li.slide');
        var $ghost = $slider.find('li.slide-ghost');
        
        $slider.find('li.slide:first').css('display','block');
        var slides_count = $slider.find('li.slide').length;
        var index = 0;
        var rotate = null;
        var $pager = null;
        var $options = $wrapper.find('.slider-options');                
                  
        // parse inline settings
        if($options.length)
        {
            var auto_opt = $options.find('span[name="auto"]');
            if(auto_opt.length) 
            { 
                var value = auto_opt.text()
                settings.auto = value == 'true' ? true : false;
            }      

            var speed_opt = $options.find('span[name="speed"]');
            if(speed_opt.length) { settings.speed = parseInt(speed_opt.text()); }    

            var timeout_opt = $options.find('span[name="timeout"]');
            if(timeout_opt.length) { settings.timeout = parseInt(timeout_opt.text()); }                
            
            var pager_opt = $options.find('span[name="pager"]');
            if(pager_opt.length) 
            { 
                var value = pager_opt.text()
                settings.pager = value == 'true' ? true : false;
            }  
            
            var pause_opt = $options.find('span[name="pause"]');
            if(pause_opt.length) 
            { 
                var value = pause_opt.text()
                settings.pause = value == 'true' ? true : false;
            }    
            
            var maxwidth_opt = $options.find('span[name="maxwidth"]');
            if(maxwidth_opt.length) { settings.maxwidth = parseInt(maxwidth_opt.text()); }   
            
            var maxwidth_pager_opt = $options.find('span[name="maxwidth_pager"]');
            if(maxwidth_pager_opt.length) 
            { 
                var value = maxwidth_pager_opt.text()
                settings.maxwidth_pager = value == 'true' ? true : false;
            }                                                     

            var maxwidth_wrapper_opt = $options.find('span[name="maxwidth_wrapper"]');
            if(maxwidth_wrapper_opt.length) 
            { 
                var value = maxwidth_wrapper_opt.text()
                settings.maxwidth_wrapper = value == 'true' ? true : false;
            } 
            
            var transition_opt = $options.find('span[name="transition"]');
            if(transition_opt.length) { settings.transition = transition_opt.text(); }  
            
            var nextprev_opt = $options.find('span[name="nextprev"]');
            if(nextprev_opt.length) 
            { 
                var value = nextprev_opt.text()
                settings.nextprev = value == 'true' ? true : false;
            }                                     
        }
       
        // mobile devices
        if('ontouchstart' in document.documentElement)    
        {
            var time_s = null;
            var time_end = null;
            var scroll = false;
            var delta_x = 0;
            var start_x = false;
            var start_y = false;
            var slider_w = $slider.width();
            
            $slider.each(function() { this.addEventListener('touchstart', onTouchStart, false); });

            function onTouchStart(e) 
            {
                var blocked = $slider.data('dc_blocked');
                if(blocked) 
                { 
                    e.preventDefault();
                    return; 
                }                
                restartCycle();               

                if(e.touches.length == 1) 
                {
                    time_s = new Date(); 
                    start_x = e.touches[0].pageX;
                    start_y = e.touches[0].pageY;

                    this.addEventListener('touchmove', onTouchMove, false);
                    this.addEventListener('touchend', onTouchEnd, false);
                }
            } 
            
            function onTouchMove(e) 
            {
                delta_x = e.touches[0].pageX - start_x;  
                scroll = (Math.abs(delta_x) < Math.abs(e.touches[0].pageY - start_y));                              
                if(!scroll) { e.preventDefault(); }                
            }    
            
           function onTouchEnd(e) 
           {
                time_end = new Date();  
                if(!scroll && (time_end.getTime() - time_s.getTime()) < 600 && (Math.abs(delta_x) > (slider_w/4)))
                {
                    var blocked = $slider.data('dc_blocked');
                    if(!blocked)
                    { 
                                        
                        var idx = index; 
                        var direction = 'next';
                        if(delta_x < 0) 
                        { 
                            direction = 'next';
                            idx = index + 1 < slides_count ? index + 1 : 0; 
                        } 
                        else 
                        { 
                            direction = 'prev';
                            idx = index - 1 >= 0 ? index - 1 : slides_count - 1; 
                        }       
                        
                        if(!settings.pause)
                        {
                            restartCycle();
                        }
                        slideTo(idx, direction);
                        selectPage(idx);  
                    
                    }                  
                }               
              
                this.removeEventListener('touchmove', onTouchMove, false);
                this.removeEventListener('touchend', onTouchEnd, false);
                start_x = null;
                start_y = null;
                delta_x = null;
            }                    
                           
        }
        
        
        // if max width is grater then zero assign it to slider
        if(settings.maxwidth > 0) 
        { 
            $slider.css('max-width', settings.maxwidth); 
            if(settings.maxwidth_wrapper)
            {
                $wrapper.find('> .inner-wrapper').css('max-width', settings.maxwidth); 
            }
        }
        
        if(settings.nextprev && slides_count > 1)
        {
            $wrapper.find('> .inner-wrapper').hover(
                function()
                {
                    jQuery(this).find('.nav-next-btn, .nav-prev-btn').css('display', 'block');    
                },
                function()
                {
                    jQuery(this).find('.nav-next-btn, .nav-prev-btn').css('display', 'none');    
                }
            );    
        }

        if(settings.pager && slides_count > 1)
        {
            $wrapper.append('<div class="nav-pager"></div>');
            $pager = $wrapper.find('.nav-pager'); 
            for(var i = 0; i < slides_count; i++)
            {
                $pager.append('<div class="page"></div>');
            }        
            $pager.find('.page:first').addClass('page-on');  
            
            $pager.children().click(function() 
            {     
                
                  var blocked = $slider.data('dc_blocked');
                  if(blocked) { return; }                
                
                var idx = $pager.children().index(this);
                if(idx != index)
                {
                    var direction = 'next';
                    if(idx < index) { direction = 'prev'; }
                    
                    restartCycle();
                    slideTo(idx, direction);
                    selectPage(idx);
                }
            }); 
            
            if(settings.maxwidth > 0 && settings.maxwidth_pager)
            {
                $pager.css('max-width', settings.maxwidth);    
            }
        }
        
        $wrapper.find('.nav-next-btn').click(function(){
            
            var $btn = jQuery(this);
                    
              var blocked = $slider.data('dc_blocked');
              if(blocked) { return; }    
              
              var idx = index + 1 < slides_count ? index + 1 : 0;    
              
                if(idx != index)
                {
                    if(!settings.pause)
                    {
                        restartCycle();
                    }
                    slideTo(idx, 'next');
                    selectPage(idx);
                }              
                         
            
        });

        $wrapper.find('.nav-prev-btn').click(function(){
            
            var $btn = jQuery(this);
            
              var blocked = $slider.data('dc_blocked');
              if(blocked) { return; }   
              
              var idx = index - 1 >= 0 ? index - 1 : slides_count - 1;    
              
                if(idx != index)
                {
                    if(!settings.pause)
                    {
                        restartCycle();
                    }
                    slideTo(idx, 'prev');
                    selectPage(idx);
                }                          
        
        });
        
        // Select pager item
        var selectPage = function (idx) 
        {
            if($pager != null)
            {
                $pager.children().removeClass('page-on').eq(idx).addClass('page-on');
            }
        };        
     
    
     
        // Fading animation
        var slideTo = function (idx, direction) 
        { 
          var blocked = $slider.data('dc_blocked');
          if(blocked) { return; }
                    
          $slider.data('dc_blocked', true);                   
          
          if(settings.transition == 'fade')
          {
              var w = $slider.width();
              
              $slide.stop().eq(idx).css({opacity:0.0,position:'absolute',left:0,top:0,display:'block','z-index':5}).animate({opacity:1.0}, settings.speed, function(){
                    index = idx;
                  $slider.data('dc_blocked', false);
                  jQuery(this).css('z-index', 0);
                  $slide.not(jQuery(this)).css({left:w,display:'none'});   
              });
          } else
          {
              var w = $slider.width(); 
                             
              if(direction == 'next')
              {               
                             
              $slide.stop().eq(idx).css({position:'absolute',left:w,top:0,display:'block','z-index':5}).animate({left:0}, settings.speed, function(){
                    index = idx;
                  $slider.data('dc_blocked', false);
                  jQuery(this).css('z-index', 0);
                  $slide.not(jQuery(this)).css({left:w,display:'none'});   
              });
              } else
              {
              $slide.stop().eq(idx).css({position:'absolute',left:-w,top:0,display:'block','z-index':5}).animate({left:0}, settings.speed, function(){
                    index = idx;
                  $slider.data('dc_blocked', false);
                  jQuery(this).css('z-index', 0);
                  $slide.not(jQuery(this)).css({left:w,display:'none'});   
              });                  
              }      
          } 
            
        };     
     
        var autoplay = function() 
        {
            // Clear the event queue
            $slide.stop(true, true);

            var idx = index + 1 < slides_count ? index + 1 : 0;

            // Remove active state and set new if pager is set
            if(settings.pager) 
            {
                selectPage(idx);
            }

            slideTo(idx, 'next');
            rotate = setTimeout(autoplay, settings.timeout);
        };     
   
        var startCycle = function () 
        {
            rotate = setTimeout(autoplay, settings.timeout);
        };   
     
        // if auto cycle
        if(settings.auto && slides_count > 1) 
        {   
            startCycle();
        }

        // restarting cycle
        var restartCycle = function() 
        {
            if(settings.auto && slides_count > 1) 
            {
                clearTimeout(rotate);
                startCycle();
            }
        }

        // pause on hover
        if(settings.pause) 
        {
            $slider.hover(function () 
            { 
                clearTimeout(rotate); 
            }, function () 
            { 
                restartCycle(); 
            });  
            
            if($pager != null)
            {
                $pager.hover(function () { 
                    clearTimeout(rotate); 
                }, 
                function () { 
                    restartCycle(); 
                });      
            }     
            
            
            $wrapper.find('.nav-next-btn').hover(function(){
                clearTimeout(rotate);                                                
            },
            function() {
                restartCycle();     
            }); 
            
            $wrapper.find('.nav-prev-btn').hover(function(){
                clearTimeout(rotate);                                                
            },
            function() {
                restartCycle();     
            });                        
                
        }
     
      });

  };
})(jQuery);

}

/*
 * jQuery Highlight Plugin
 * Examples and documentation at: http://demo.webcodingstudio.com/highlight/
 * Copyright (c) 2010 E. Matsakov
 * Version: 1.0 (26-FEB-2010)
 * Dual licensed under the MIT and GPL licenses:
 * http://www.opensource.org/licenses/mit-license.php
 * http://www.gnu.org/licenses/gpl.html
 * Requires: jQuery v1.2.6 or later
 * 
 * Changes: Oryginal code was change for better fit to my work.
 * The list type option was removed nad code lineas are display only
 * by using unordered list. The gutter was added, so now lines number
 * can be styled separately. Also tabs container is redesigned, now
 * adding new button and positioning it is very simple, also each
 * tab button can be programmed separately.
 */              
(function($){
    $.fn.highlight = function(element_params){
        
        var defaults = {
             // show source code tab
            source: true,
            // show stripes
            stripes: true,
            //indents: "tabs" or "space"  
            indent: 'tabs'
        }
        
        var params = $.extend({}, defaults, element_params);

        return this.each(function(){
            var code_container = $(this);
            var code_class = $(code_container).attr('class');
            var code_lang = $(code_container).attr('lang');
            var code_style = $(code_container).attr('style'); 
        
            if(code_style === undefined) 
            {
                code_style = '';   
            }
        
            var stripes = params.stripes;
            var data_stripes = $(code_container).attr('data-stripes');          
            
            if(data_stripes !== undefined)
            {
                if(data_stripes == 'true') { data_stripes = true } else { data_stripes = false; }
                stripes = data_stripes;
            }
            
            var data_mini = $(code_container).attr('data-minimized');        
            if(data_mini !== undefined)
            {
                if(data_mini == 'true') { data_mini = true } else { data_mini = false; }    
            }
            
            var code_lang_class = '';
            if(code_lang!='') {
                code_lang_class = ' '+code_lang;
            } 
            var show_class = '';
            if(data_mini)
            {
                show_class = ' minimized';    
            }
            
            $(code_container).wrap('<div class="dc-highlight-code'+code_lang_class+show_class+'" style="'+code_style+'"></div>');
            var $highlight_container = $(code_container).parent();
            var outer_desc = $highlight_container.next();
            var desc = '';
            var is_desc = outer_desc.is('div.dc-highlight-code-desc');
            if(is_desc)
            {
                desc = '<div class="description">'+outer_desc.html()+'</div>';        
                $highlight_container.append(desc);
                $description = $highlight_container.find('div.description');
                if(!$description.find('div.title').length)
                {
                    $description.addClass('no-title');    
                }
            }
            
            

            
            var source = code_container.html();
            source = source.replace(/</gm, '&lt;');
            
            //replace tabs with spaces
            if(params.indent=='space') {
                source = source.replace(/\t/g,'    ');
            }
            
            var code = source;
            
            //hightlight
            switch(code_lang) {
                case 'html':
                    code = $.highlightCode.hightlight_html(code);    
                    break;
                case 'css':
                    code = $.highlightCode.hightlight_css(code);    
                    break;
                case 'php':
                    code = $.highlightCode.hightlight_php(code);    
                  break;
                default:
                    code = $.highlightCode.hightlight(code);    
                    break;
            }
            
            code = code.replace(/(?:\r\n?|\n)$/, '');                       
            code = '<ul><li>'+code.split(/\r\n|\n/).join('\n</li><li>')+'\n</li></ul>';
             
            var tabs = '';                
            tabs = '<div class="code-header">';                                             
                //add source and tabs
                
                if(data_mini) 
                {
                    tabs += '<a class="toggle-btn">Show source code</a>'; 
                } else
                {
                    tabs += '<a class="toggle-btn">Hide source code</a>'; 
                }
                
                if(params.source==true) 
                {
                    tabs += '<a class="source-btn">Text</a>';
                    tabs += '<a class="code-btn active">Formated</a>';                                                                                    
                }
            tabs += '</div>';            
            $highlight_container.prepend(tabs);
                                
            var side_style = '';
            if(data_mini)
            {
                side_style = ' style="display:none;" ';    
            }
            
            $highlight_container.find('.code-header').after('<div class="left-side" '+side_style+'><div class="gutter"></div></div>'); 
            //replace instead of html, because of IE bug
            $(code_container).replaceWith('<div class="right-side" '+side_style+'><pre class="'+code_class+'">'+code+'</pre></div>');          
                     
            //add source and tabs
            if(params.source==true) {
                source = '<pre class="dc-source">'+source+'</pre>';                            
                $highlight_container.find('.right-side').append(source);                                
            }
            
            
            //init tabs
            var $tabs = $highlight_container.find('div.code-header'); 
            if(params.source==true) {
                
                
                $tabs.find('.code-btn').click(function(){
                    $tabs.find('.source-btn').removeClass('active');
                    jQuery(this).addClass('active');
                    $highlight_container.find('pre[class="dc-code"]').css('display', 'block');
                    $highlight_container.find('pre[class^="dc-source"]').css('display', 'none');
                });

                $tabs.find('.source-btn').click(function(){
                    $tabs.find('.code-btn').removeClass('active');
                    jQuery(this).addClass('active');
                    $highlight_container.find('pre[class="dc-code"]').css('display', 'none');
                    $highlight_container.find('pre[class^="dc-source"]').css('display', 'block');
                });               
            }      
                $tabs.find('.toggle-btn').click(function(){
                    var display = $highlight_container.find('.left-side').css('display');
                    if(display == 'block')
                    {
                        $highlight_container.find('.left-side, .right-side').css('display', 'none');    
                        jQuery(this).text('Show source code');
                        $highlight_container.addClass('minimized');
                    } else
                    {
                        $highlight_container.find('.left-side, .right-side').css('display', 'block');
                        jQuery(this).text('Hide source code');
                        $highlight_container.removeClass('minimized');   
                    }
                });            
                           
                                                                
            // gutter        
            var lines_count = $highlight_container.find('pre:first li').length;            
            var $gutter = $highlight_container.find('.gutter');             
            for(var i = 0; i < lines_count; i++)
            {
                $gutter.append('<span>'+i+'</span>');
            }
            
            //stripes
            if(stripes==true) {
                $highlight_container.find('pre[class="'+code_class+'"] ul li:even').addClass('even');
            }
        });
    };
    
    $.highlightCode = {
        
        //DEFAULT
        hightlight: function(code) {
                    
            var comments        = [];    // store comments
        
            code = code
                //replace keywords
                .replace(/(var|function|typeof|new|return|if|for|in|while|break|do|continue|case|switch)([^a-z0-9\$_])/gi,'<span class="kwd">$1</span>$2')
                //replace keywords
                .replace(/(\{|\}|\]|\[|\|)/gi,'<span class="kwd">$1</span>')
                //replace strings
                .replace(/('.*?')/g,'<span class="str">$1</span>')
                //replace multiline comments
                .replace(/\/\*([\s\S]*?)\*\//g, function(m, t)
                    { return '\0C'+push(comments, multiline_comments(m))+'\0'; })
                .replace(/\0C(\d+)\0/g, function(m, i)
                    { return comments[i]; })
                //replace one line comments
                .replace(/\/\/(.*$)/gm,'<span class="com">//$1</span>')
                //replace functons
                .replace(/([a-z\_\$][a-z0-9_]*)\(/gi,'<span class="fnc">$1</span>(');
            return code;
        },
        
        //PHP
        hightlight_php: function(code) {
            
            var comments        = [];    // store comments
            
            var funcs    =    'abs acos acosh addcslashes addslashes ' +
                'array_change_key_case array_chunk array_combine array_count_values array_diff '+
                'array_diff_assoc array_diff_key array_diff_uassoc array_diff_ukey array_fill '+
                'array_filter array_flip array_intersect array_intersect_assoc array_intersect_key '+
                'array_intersect_uassoc array_intersect_ukey array_key_exists array_keys array_map '+
                'array_merge array_merge_recursive array_multisort array_pad array_pop array_product '+
                'array_push array_rand array_reduce array_reverse array_search array_shift '+
                'array_slice array_splice array_sum array_udiff array_udiff_assoc '+
                'array_udiff_uassoc array_uintersect array_uintersect_assoc '+
                'array_uintersect_uassoc array_unique array_unshift array_values array_walk '+
                'array_walk_recursive atan atan2 atanh base64_decode base64_encode base_convert '+
                'basename bcadd bccomp bcdiv bcmod bcmul bindec bindtextdomain bzclose bzcompress '+
                'bzdecompress bzerrno bzerror bzerrstr bzflush bzopen bzread bzwrite ceil chdir '+
                'checkdate checkdnsrr chgrp chmod chop chown chr chroot chunk_split class_exists '+
                'closedir closelog copy cos cosh count count_chars date decbin dechex decoct '+
                'deg2rad delete ebcdic2ascii echo empty end ereg ereg_replace eregi eregi_replace error_log '+
                'error_reporting escapeshellarg escapeshellcmd eval exec exit exp explode extension_loaded '+
                'feof fflush fgetc fgetcsv fgets fgetss file_exists file_get_contents file_put_contents '+
                'fileatime filectime filegroup fileinode filemtime fileowner fileperms filesize filetype '+
                'floatval flock floor flush fmod fnmatch fopen fpassthru fprintf fputcsv fputs fread fscanf '+
                'fseek fsockopen fstat ftell ftok getallheaders getcwd getdate getenv gethostbyaddr gethostbyname '+
                'gethostbynamel getimagesize getlastmod getmxrr getmygid getmyinode getmypid getmyuid getopt '+
                'getprotobyname getprotobynumber getrandmax getrusage getservbyname getservbyport gettext '+
                'gettimeofday gettype glob gmdate gmmktime in_array ini_alter ini_get ini_get_all ini_restore ini_set '+
                'interface_exists intval ip2long is_a is_array is_bool is_callable is_dir is_double '+
                'is_executable is_file is_finite is_float is_infinite is_int is_integer is_link is_long '+
                'is_nan is_null is_numeric is_object is_readable is_real is_resource is_scalar is_soap_fault '+
                'is_string is_subclass_of is_uploaded_file is_writable is_writeable mkdir mktime nl2br '+
                'parse_ini_file parse_str parse_url passthru pathinfo readlink realpath rewind rewinddir rmdir '+
                'round str_ireplace str_pad str_repeat str_replace str_rot13 str_shuffle str_split '+
                'str_word_count strcasecmp strchr strcmp strcoll strcspn strftime strip_tags stripcslashes '+
                'stripos stripslashes stristr strlen strnatcasecmp strnatcmp strncasecmp strncmp strpbrk '+
                'strpos strptime strrchr strrev strripos strrpos strspn strstr strtok strtolower strtotime '+
                'strtoupper strtr strval substr substr_compare';
    
            var keywords =    'and or xor array as break case ' +
                'cfunction const continue declare default die do else ' +
                'elseif enddeclare endfor endforeach endif endswitch endwhile ' +
                'extends for foreach function include include_once global if ' +
                'new old_function return static switch use require require_once ' +
                'while abstract interface public implements extends private protected throw';
    
        funcs = new RegExp(get_keywords(funcs), 'gi');
            keywords = new RegExp(get_keywords(keywords), 'gi');
            
            code = code
                //replace strings
                .replace(/(".*?")/g,'<span class="str">$1</span>')
                .replace(/('.*?')/g,'<span class="str">$1</span>')    
                //replace multiline comments
                .replace(/\/\*([\s\S]*?)\*\//g, function(m, t)
                    { return '\0C'+push(comments, multiline_comments(m))+'\0'; })
                .replace(/\0C(\d+)\0/g, function(m, i)
                    { return comments[i]; })
                //replace one line comments
                .replace(/\/\/(.*$)/gm,'<span class="com">//$1</span>')
                //replace variables
                .replace(/\$(\w+)/g,'<span class="var">$$$1</span>')
                //replace functions
                .replace(funcs,'<span class="fnc">$1</span>$2')
                //replace keywords
                .replace(keywords,'<span class="kwd">$1</span>$2');
            return code;
        },
        
        //CSS
        hightlight_css: function(code) {
            
            var comments        = [];    // store comments
            
            var keywords =    'background-color background-image background-position ' +
                'background-repeat background border-collapse border-color border-spacing border-style border-top ' +
                'border-right border-bottom border-left border-top-color border-right-color border-bottom-color border-left-color ' +
                'border-top-style border-right-style border-bottom-style border-left-style border-top-width border-right-width ' +
                'border-bottom-width border-left-width border-width border color cursor direction display ' +
                'float font-size-adjust font-family font-size font-stretch font-style font-variant font-weight font ' +
                'height left letter-spacing line-height list-style-image list-style-position list-style-type list-style margin-top ' +
                'margin-right margin-bottom margin-left margin max-height max-width min-height min-width ' +
                'outline-color outline-style outline-width outline overflow padding-top padding-right padding-bottom padding-left padding position' +
                'quotes right size src table-layout text-align top text-decoration text-indent text-shadow text-transform ' +
                'vertical-align visibility white-space width word-spacing x-height z-index';
        
            var values =    'absolute all attr auto baseline behind below black blink block blue bold bolder '+
                'both bottom capitalize caption center center-left center-right circle close-quote collapse compact '+
                'continuous cursive dashed decimal default digits disc dotted double embed expanded fixed format '+
                'gray green groove help hidden hide high higher icon inline-table inline inset inside invert italic '+
                'justify large larger left-side left leftwards level line-through list-item '+
                'lowercase lower low ltr marker medium middle move none no-repeat normal nowrap oblique olive once outset '+
                'outside overline pointer print purple red relative repeat repeat-x repeat-y rgb right rtl screen scroll show silver slower slow '+
                'small small-caps small-caption smaller soft solid square s-resize static sub super '+
                'table-caption table-cell table-column table-column-group table-footer-group table-header-group table-row table-row-group '+
                'text-bottom text-top thick thin top transparent underline upper-alpha uppercase upper-latin '+
                'upper-roman url visible wait white wider w-resize x-fast x-high x-large x-low x-small x-soft yellow';
            
            var fonts =        '[mM]onospace [tT]ahoma [vV]erdana [aA]rial [hH]elvetica [sS]ans-serif [sS]erif [cC]ourier New mono sans serif';
            
            keywords = new RegExp(get_keywords(keywords), 'gi');
            values = new RegExp(get_keywords(values), 'gi');
            fonts = new RegExp(get_keywords(fonts), 'gi'); 

            code = code                     
                //replace comments
                .replace(/\/\*([\s\S]*?)\*\//g, function(m, t)
                    { return '\0C'+push(comments, multiline_comments(m))+'\0'; })
                .replace(/\0C(\d+)\0/g, function(m, i)
                    { return comments[i]; })
                //replace keywords
                .replace(keywords,'<span class="kwd">$1</span>$2')
                //replace values
                .replace(values,'<span class="pln">$1</span>$2')
                //replace fonts
                .replace(fonts,'<span class="str">$1</span>$2')
                //replace hex colors            
                .replace(/(\#[a-fA-F0-9]{3,6})/gi,'<span class="lit">$1</span>')
                //replace sizes
                .replace(/(-?\d+)(\.\d+)?(px|em|pt|\:|\%|)/gi,'<span class="lit">$1$3</span>');
            return code;
        },
        
        //HTML
        hightlight_html: function(code) {
            
            code = code
                //replace attributes
                .replace(/\s+([a-zA-Z\-]{0,15})\=\"([-a-z0-9_ \/\.\#\:\=\;]{0,49})\"/gi,' <span class="atn">$1</span>=<span class="atv">"$2"</span>')
                //replace open tags
                .replace(/(&lt;)(\w{0,15})(\s+|&gt;|>)/gi,'$1<span class="tag">$2</span>$3')
                //replace close tags
                .replace(/(&lt;)\/(\w{0,15})(&gt;|>)/gi,'$1/<span class="tag">$2</span>$3')
                //replace doctype
                .replace(/(&lt;!)([-a-z0-9_ \/\.\#\:\"]{0,150})(&gt;|>)/gi,'<span class="dec">$1$2$3</span>')        
                //replace comments
                .replace(/(&lt;|<)!--([\s\S]*?)--(&gt;|>)/gm,'<span class="com">$1!--$2--$3</span>');
                
            return code;
        }
    };
    
    /*
    * helpers
    */
    
    //prepare regexp template for keywords
    function get_keywords(str)
    {
        return '(' + str.replace(/ /g, '|') + ')([^a-z0-9\$_])';
    }
    
    //process multiline comments
    function multiline_comments(text)
    {
        text    = text.split('\n');
        for(var i=0; i<text.length; i++) {
            text[i] = '<span class="com">'+text[i]+'</span>';
        }
        return text.join('\n');
    }
    
    //add element, return index
    function push(array, element)
    {
        array.push(element);
        return array.length-1;
    }    
    
})(jQuery);
       

/**
 * jQuery gMap - Google Maps API V3
 *
 * @url        http://github.com/marioestrada/jQuery-gMap
 * @author    Mario Estrada <me@mario.ec> based on original plugin by Cedric Kastner <cedric@nur-text.de
 * @version    2.1.2
 */
 // (function(a){a.fn.gMap=function(b,c){switch(b){case"addMarker":return a(this).trigger("gMap.addMarker",[c.latitude,c.longitude,c.content,c.icon,c.popup]);case"centerAt":return a(this).trigger("gMap.centerAt",[c.latitude,c.longitude,c.zoom])}var d=a.extend({},a.fn.gMap.defaults,b);return this.each(function(){var b=new google.maps.Map(this),c=new google.maps.Geocoder;d.address?c.geocode({address:d.address},function(a,c){a&&a.length&&b.setCenter(a[0].geometry.location)}):d.latitude&&d.longitude?b.setCenter(new google.maps.LatLng(d.latitude,d.longitude)):a.isArray(d.markers)&&d.markers.length>0?d.markers[0].address?c.geocode({address:d.markers[0].address},function(a,c){a&&a.length>0&&b.setCenter(a[0].geometry.location)}):b.setCenter(new google.maps.LatLng(d.markers[0].latitude,d.markers[0].longitude)):b.setCenter(new google.maps.LatLng(34.885931,9.84375)),b.setZoom(d.zoom),b.setMapTypeId(google.maps.MapTypeId[d.maptype]);var e={scrollwheel:d.scrollwheel,disableDoubleClickZoom:!d.doubleclickzoom};d.controls===!1?a.extend(e,{disableDefaultUI:!0}):d.controls.length!=0&&a.extend(e,d.controls,{disableDefaultUI:!0}),b.setOptions(e);var f=new google.maps.Marker;marker_icon=new google.maps.MarkerImage(d.icon.image),marker_icon.size=new google.maps.Size(d.icon.iconsize[0],d.icon.iconsize[1]),marker_icon.anchor=new google.maps.Point(d.icon.iconanchor[0],d.icon.iconanchor[1]),f.setIcon(marker_icon),d.icon.shadow&&(marker_shadow=new google.maps.MarkerImage(d.icon.shadow),marker_shadow.size=new google.maps.Size(d.icon.shadowsize[0],d.icon.shadowsize[1]),marker_shadow.anchor=new google.maps.Point(d.icon.shadowanchor[0],d.icon.shadowanchor[1]),f.setShadow(marker_shadow)),a(this).bind("gMap.centerAt",function(a,c,d,e){e&&b.setZoom(e),b.panTo(new google.maps.LatLng(parseFloat(c),parseFloat(d)))});var g;a(this).bind("gMap.addMarker",function(a,c,e,h,i,j){var k=new google.maps.LatLng(parseFloat(c),parseFloat(e)),l=new google.maps.Marker({position:k});i?(marker_icon=new google.maps.MarkerImage(i.image),marker_icon.size=new google.maps.Size(i.iconsize[0],i.iconsize[1]),marker_icon.anchor=new google.maps.Point(i.iconanchor[0],i.iconanchor[1]),l.setIcon(marker_icon),i.shadow&&(marker_shadow=new google.maps.MarkerImage(i.shadow),marker_shadow.size=new google.maps.Size(i.shadowsize[0],i.shadowsize[1]),marker_shadow.anchor=new google.maps.Point(i.shadowanchor[0],i.shadowanchor[1]),f.setShadow(marker_shadow))):(l.setIcon(f.getIcon()),l.setShadow(f.getShadow()));if(h){h=="_latlng"&&(h=c+", "+e);var m=new google.maps.InfoWindow({content:d.html_prepend+h+d.html_append});google.maps.event.addListener(l,"click",function(){g&&g.close(),m.open(b,l),g=m}),j&&google.maps.event.addListenerOnce(b,"tilesloaded",function(){m.open(b,l)})}l.setMap(b)});for(var h=0;h<d.markers.length;h++){marker=d.markers[h];if(marker.address){marker.html=="_address"&&(marker.html=marker.address);var i=this;c.geocode({address:marker.address},function(b,c){return function(d,e){d&&d.length>0&&a(c).trigger("gMap.addMarker",[d[0].geometry.location.lat(),d[0].geometry.location.lng(),b.html,b.icon,b.popup])}}(marker,i))}else a(this).trigger("gMap.addMarker",[marker.latitude,marker.longitude,marker.html,marker.icon,marker.popup])}})},a.fn.gMap.defaults={address:"",latitude:0,longitude:0,zoom:1,markers:[],controls:[],scrollwheel:!1,doubleclickzoom:!0,maptype:"ROADMAP",html_prepend:'<div class="gmap_marker">',html_append:"</div>",icon:{image:"http://www.google.com/mapfiles/marker.png",shadow:"http://www.google.com/mapfiles/shadow50.png",iconsize:[20,34],shadowsize:[37,34],iconanchor:[9,34],shadowanchor:[6,34]}}})(jQuery)

/**
 * jQuery gMap - Google Maps API V3
 *
 * @url        http://github.com/marioestrada/jQuery-gMap
 * @author    Mario Estrada <me@mario.ec> based on original plugin by Cedric Kastner <cedric@nur-text.de>
 * @version    2.1.3
 */
(function($)
{
    // Main plugin function
    $.fn.gMap = function(options, methods_options)
    {
        // Optional methods
        switch(options)
        {
        case 'addMarker':
            return $(this).trigger('gMap.addMarker', [methods_options.latitude, methods_options.longitude, methods_options.content, methods_options.icon, methods_options.popup]);
        case 'centerAt':
            return $(this).trigger('gMap.centerAt', [methods_options.latitude, methods_options.longitude, methods_options.zoom]);
        case 'clearMarkers':
            return $(this).trigger('gMap.clearMarkers');
        }
        
        // Build main options before element iteration
        var opts = $.extend({}, $.fn.gMap.defaults, options);
        
        // Iterate through each element
        return this.each(function()
        {
            // Create map and set initial options
            var $gmap = new google.maps.Map(this);
            
            // Create new object to geocode addresses
            var $geocoder = new google.maps.Geocoder();
            
            // Check for address to center on
            if (opts.address)
            { 
                // Get coordinates for given address and center the map
                $geocoder.geocode(
                    {
                        address: opts.address
                    }, function(gresult, status)
                    {
                        if(gresult && gresult.length)
                            $gmap.setCenter(gresult[0].geometry.location);
                    }
                );
            }else{
                // Check for coordinates to center on
                if (opts.latitude && opts.longitude)
                {
                    // Center map to coordinates given by option
                    $gmap.setCenter(new google.maps.LatLng(opts.latitude, opts.longitude));
                }
                else
                {
                    // Check for a marker to center on (if no coordinates given)
                    if ($.isArray(opts.markers) && opts.markers.length > 0)
                    {
                        // Check if the marker has an address
                        if (opts.markers[0].address)
                        {
                            // Get the coordinates for given marker address and center
                            $geocoder.geocode(
                                {
                                    address: opts.markers[0].address
                                }, function(gresult, status)
                                {
                                    if(gresult && gresult.length > 0)
                                        $gmap.setCenter(gresult[0].geometry.location);
                                }
                            );
                        }else{
                            // Center the map to coordinates given by marker
                            $gmap.setCenter(new google.maps.LatLng(opts.markers[0].latitude, opts.markers[0].longitude));
                        }
                    }else{
                        // Revert back to world view
                        $gmap.setCenter(new google.maps.LatLng(34.885931, 9.84375));
                    }
                }
            }    
            $gmap.setZoom(opts.zoom);
            
            // Set the preferred map type
            
            if(opts.s_hue != null || opts.s_saturation != null || opts.s_lightness != null || opts.s_gamma != null)
            {         
                /*
                var stylez = [
                    {
                      featureType: "all",
                      elementType: "all",
                      stylers: [ {hue: "#FF1A00" }, { saturation: -80 }, { lightness: 60 }, { gamma: 0.16 } ]                  
                    }
                ]; 
                */
                
                var stylez = [
                {
                    featureType: "all",
                    elementType: "all",
                    stylers: []  }
                ];
                       
                if(opts.s_hue != null)
                {
                    var stylez_hue = new Object();
                    stylez_hue.hue = opts.s_hue;
                    stylez[0].stylers.push(stylez_hue);
                }
                
                if(opts.s_saturation != null) 
                {
                    var stylez_saturation = new Object();
                    stylez_saturation.saturation = opts.s_saturation;
                    stylez[0].stylers.push(stylez_saturation);                                 
                }

                if(opts.s_lightness != null) 
                {                
                    var stylez_lightness = new Object();
                    stylez_lightness.lightness = opts.s_lightness;
                    stylez[0].stylers.push(stylez_lightness);    
                }

                if(opts.s_gamma != null) 
                {                       
                    var stylez_gamma = new Object();
                    stylez_gamma.gamma = opts.s_gamma;
                    stylez[0].stylers.push(stylez_gamma);  
                }
                
                var mapType = new google.maps.StyledMapType(stylez, { name:"Grayscale" });    
                $gmap.mapTypes.set('dc_tehgrayz', mapType);
                $gmap.setMapTypeId('dc_tehgrayz');                    
                
            } else
            {
                $gmap.setMapTypeId(google.maps.MapTypeId[opts.maptype]);
            }
                    
            
            // Set scrollwheel option
            var map_options = { scrollwheel: opts.scrollwheel, disableDoubleClickZoom: !opts.doubleclickzoom };
            // Check for map controls
            if(opts.controls === false){
                $.extend(map_options, { disableDefaultUI: true });
            }else if (opts.controls.length != 0){
                $.extend(map_options, opts.controls, { disableDefaultUI: true });
            }
            
            $gmap.setOptions(map_options);
                                    
            // Create new icon
            var gicon = new google.maps.Marker();
            
            // Set icon properties from global options
            marker_icon = new google.maps.MarkerImage(opts.icon.image);
            marker_icon.size = new google.maps.Size(opts.icon.iconsize[0], opts.icon.iconsize[1]);
            marker_icon.anchor = new google.maps.Point(opts.icon.iconanchor[0], opts.icon.iconanchor[1]);
            gicon.setIcon(marker_icon);
            
            if(opts.icon.shadow)
            {
                marker_shadow = new google.maps.MarkerImage(opts.icon.shadow);
                marker_shadow.size = new google.maps.Size(opts.icon.shadowsize[0], opts.icon.shadowsize[1]);
                marker_shadow.anchor = new google.maps.Point(opts.icon.shadowanchor[0], opts.icon.shadowanchor[1]);
                gicon.setShadow(marker_shadow);
            }
            
            // Bind actions
            $(this).bind('gMap.centerAt', function(e, latitude, longitude, zoom)
            {
                if(zoom)
                    $gmap.setZoom(zoom);

                $gmap.panTo(new google.maps.LatLng(parseFloat(latitude), parseFloat(longitude)));
            });
            
            // Clear Markers
            var overlays = [];
            $(this).bind('gMap.clearMarkers', function() 
            {
                while(overlays[0]){
                    overlays.pop().setMap(null);
                }
            });

            var last_infowindow;
            $(this).bind('gMap.addMarker', function(e, latitude, longitude, content, icon, popup)
            {
                var glatlng = new google.maps.LatLng(parseFloat(latitude), parseFloat(longitude));

                var gmarker = new google.maps.Marker({
                    position: glatlng
                });

                if(icon)
                {
                    marker_icon = new google.maps.MarkerImage(icon.image);
                    marker_icon.size = new google.maps.Size(icon.iconsize[0], icon.iconsize[1]);
                    marker_icon.anchor = new google.maps.Point(icon.iconanchor[0], icon.iconanchor[1]);
                    gmarker.setIcon(marker_icon);
                    
                    if(icon.shadow)
                    {
                        marker_shadow = new google.maps.MarkerImage(icon.shadow);
                        marker_shadow.size = new google.maps.Size(icon.shadowsize[0], icon.shadowsize[1]);
                        marker_shadow.anchor = new google.maps.Point(icon.shadowanchor[0], icon.shadowanchor[1]);
                        gicon.setShadow(marker_shadow);
                    }
                }else{
                    gmarker.setIcon(gicon.getIcon());
                    gmarker.setShadow(gicon.getShadow());
                }
                
                if(content)
                {
                    if(content == '_latlng')
                        content = latitude + ', ' + longitude;
                    
                    var infowindow = new google.maps.InfoWindow({
                        content: opts.html_prepend + content + opts.html_append
                    });
                    
                    google.maps.event.addListener(gmarker, 'click', function()
                    {
                        last_infowindow && last_infowindow.close();
                        infowindow.open($gmap, gmarker);
                        last_infowindow = infowindow;
                    });

                    if(popup)
                    {
                        google.maps.event.addListenerOnce($gmap, 'tilesloaded', function()
                        {
                            infowindow.open($gmap, gmarker);
                        });
                    }
                }
                gmarker.setMap($gmap);
                overlays.push(gmarker);
            });
            
            // Loop through marker array
            for (var j = 0; j < opts.markers.length; j++)
            {
                // Get the options from current marker
                marker = opts.markers[j];
                
                // Check if address is available
                if (marker.address)
                {
                    // Check for reference to the marker's address
                    if (marker.html == '_address')
                        marker.html = marker.address;
                    
                    // Get the point for given address
                    var $this = this;
                    $geocoder.geocode({
                        address: marker.address
                    }, (function(marker, $this){
                        return function(gresult, status)
                        {
                            // Create marker
                            if(gresult && gresult.length > 0)
                            {
                                $($this).trigger('gMap.addMarker', [gresult[0].geometry.location.lat(), gresult[0].geometry.location.lng(), marker.html, marker.icon, marker.popup]);
                            }
                        };
                    })(marker, $this)
                    );
                }else{
                    $(this).trigger('gMap.addMarker', [marker.latitude, marker.longitude, marker.html, marker.icon, marker.popup]);
                }
            }
        });
        
    }
        
    // Default settings
    $.fn.gMap.defaults = {
        address: '',
        latitude: 0,
        longitude: 0,
        zoom: 1,
        markers: [],
        controls: [],
        scrollwheel: false,
        doubleclickzoom: true,
        s_hue: null,  
        s_saturation: null,
        s_lightness: null,
        s_gamma: null,  
        maptype: 'ROADMAP',
        html_prepend: '<div class="gmap_marker">',
        html_append: '</div>',
        icon: {
            image: "http://www.google.com/mapfiles/marker.png",
            shadow: "http://www.google.com/mapfiles/shadow50.png",
            iconsize: [20, 34],
            shadowsize: [37, 34],
            iconanchor: [9, 34],
            shadowanchor: [6, 34]
        }
    }
    
})(jQuery); 

/*
 * jQuery EasIng v1.1.2 - http://gsgd.co.uk/sandbox/jquery.easIng.php
 *
 * Uses the built In easIng capabilities added In jQuery 1.1
 * to offer multiple easIng options
 *
 * Copyright (c) 2007 George Smith
 * Licensed under the MIT License:
 *   http://www.opensource.org/licenses/mit-license.php
 */

// t: current time, b: begInnIng value, c: change In value, d: duration

jQuery.extend( jQuery.easing,
{
    easeInQuad: function (x, t, b, c, d) {
        return c*(t/=d)*t + b;
    },
    easeOutQuad: function (x, t, b, c, d) {
        return -c *(t/=d)*(t-2) + b;
    },
    easeInOutQuad: function (x, t, b, c, d) {
        if ((t/=d/2) < 1) return c/2*t*t + b;
        return -c/2 * ((--t)*(t-2) - 1) + b;
    },
    easeInCubic: function (x, t, b, c, d) {
        return c*(t/=d)*t*t + b;
    },
    easeOutCubic: function (x, t, b, c, d) {
        return c*((t=t/d-1)*t*t + 1) + b;
    },
    easeInOutCubic: function (x, t, b, c, d) {
        if ((t/=d/2) < 1) return c/2*t*t*t + b;
        return c/2*((t-=2)*t*t + 2) + b;
    },
    easeInQuart: function (x, t, b, c, d) {
        return c*(t/=d)*t*t*t + b;
    },
    easeOutQuart: function (x, t, b, c, d) {
        return -c * ((t=t/d-1)*t*t*t - 1) + b;
    },
    easeInOutQuart: function (x, t, b, c, d) {
        if ((t/=d/2) < 1) return c/2*t*t*t*t + b;
        return -c/2 * ((t-=2)*t*t*t - 2) + b;
    },
    easeInQuint: function (x, t, b, c, d) {
        return c*(t/=d)*t*t*t*t + b;
    },
    easeOutQuint: function (x, t, b, c, d) {
        return c*((t=t/d-1)*t*t*t*t + 1) + b;
    },
    easeInOutQuint: function (x, t, b, c, d) {
        if ((t/=d/2) < 1) return c/2*t*t*t*t*t + b;
        return c/2*((t-=2)*t*t*t*t + 2) + b;
    },
    easeInSine: function (x, t, b, c, d) {
        return -c * Math.cos(t/d * (Math.PI/2)) + c + b;
    },
    easeOutSine: function (x, t, b, c, d) {
        return c * Math.sin(t/d * (Math.PI/2)) + b;
    },
    easeInOutSine: function (x, t, b, c, d) {
        return -c/2 * (Math.cos(Math.PI*t/d) - 1) + b;
    },
    easeInExpo: function (x, t, b, c, d) {
        return (t==0) ? b : c * Math.pow(2, 10 * (t/d - 1)) + b;
    },
    easeOutExpo: function (x, t, b, c, d) {
        return (t==d) ? b+c : c * (-Math.pow(2, -10 * t/d) + 1) + b;
    },
    easeInOutExpo: function (x, t, b, c, d) {
        if (t==0) return b;
        if (t==d) return b+c;
        if ((t/=d/2) < 1) return c/2 * Math.pow(2, 10 * (t - 1)) + b;
        return c/2 * (-Math.pow(2, -10 * --t) + 2) + b;
    },
    easeInCirc: function (x, t, b, c, d) {
        return -c * (Math.sqrt(1 - (t/=d)*t) - 1) + b;
    },
    easeOutCirc: function (x, t, b, c, d) {
        return c * Math.sqrt(1 - (t=t/d-1)*t) + b;
    },
    easeInOutCirc: function (x, t, b, c, d) {
        if ((t/=d/2) < 1) return -c/2 * (Math.sqrt(1 - t*t) - 1) + b;
        return c/2 * (Math.sqrt(1 - (t-=2)*t) + 1) + b;
    },
    easeInElastic: function (x, t, b, c, d) {
        var s=1.70158;var p=0;var a=c;
        if (t==0) return b;  if ((t/=d)==1) return b+c;  if (!p) p=d*.3;
        if (a < Math.abs(c)) { a=c; var s=p/4; }
        else var s = p/(2*Math.PI) * Math.asin (c/a);
        return -(a*Math.pow(2,10*(t-=1)) * Math.sin( (t*d-s)*(2*Math.PI)/p )) + b;
    },
    easeOutElastic: function (x, t, b, c, d) {
        var s=1.70158;var p=0;var a=c;
        if (t==0) return b;  if ((t/=d)==1) return b+c;  if (!p) p=d*.3;
        if (a < Math.abs(c)) { a=c; var s=p/4; }
        else var s = p/(2*Math.PI) * Math.asin (c/a);
        return a*Math.pow(2,-10*t) * Math.sin( (t*d-s)*(2*Math.PI)/p ) + c + b;
    },
    easeInOutElastic: function (x, t, b, c, d) {
        var s=1.70158;var p=0;var a=c;
        if (t==0) return b;  if ((t/=d/2)==2) return b+c;  if (!p) p=d*(.3*1.5);
        if (a < Math.abs(c)) { a=c; var s=p/4; }
        else var s = p/(2*Math.PI) * Math.asin (c/a);
        if (t < 1) return -.5*(a*Math.pow(2,10*(t-=1)) * Math.sin( (t*d-s)*(2*Math.PI)/p )) + b;
        return a*Math.pow(2,-10*(t-=1)) * Math.sin( (t*d-s)*(2*Math.PI)/p )*.5 + c + b;
    },
    easeInBack: function (x, t, b, c, d, s) {
        if (s == undefined) s = 1.70158;
        return c*(t/=d)*t*((s+1)*t - s) + b;
    },
    easeOutBack: function (x, t, b, c, d, s) {
        if (s == undefined) s = 1.70158;
        return c*((t=t/d-1)*t*((s+1)*t + s) + 1) + b;
    },
    easeInOutBack: function (x, t, b, c, d, s) {
        if (s == undefined) s = 1.70158; 
        if ((t/=d/2) < 1) return c/2*(t*t*(((s*=(1.525))+1)*t - s)) + b;
        return c/2*((t-=2)*t*(((s*=(1.525))+1)*t + s) + 2) + b;
    },
    easeInBounce: function (x, t, b, c, d) {
        return c - jQuery.easing.easeOutBounce (x, d-t, 0, c, d) + b;
    },
    easeOutBounce: function (x, t, b, c, d) {
        if ((t/=d) < (1/2.75)) {
            return c*(7.5625*t*t) + b;
        } else if (t < (2/2.75)) {
            return c*(7.5625*(t-=(1.5/2.75))*t + .75) + b;
        } else if (t < (2.5/2.75)) {
            return c*(7.5625*(t-=(2.25/2.75))*t + .9375) + b;
        } else {
            return c*(7.5625*(t-=(2.625/2.75))*t + .984375) + b;
        }
    },
    easeInOutBounce: function (x, t, b, c, d) {
        if (t < d/2) return jQuery.easing.easeInBounce (x, t*2, 0, c, d) * .5 + b;
        return jQuery.easing.easeOutBounce (x, t*2-d, 0, c, d) * .5 + c*.5 + b;
    }
});
 
 
 
/*
 * Digital Cavalry Tips jQuery Plugin JS (version 1.0)
 * http://themeforest.net/user/DigitalCavalry
 * 
 * file: jquery-dc-tips.1.0.js
 * 
 * Copyright 2011, Digital Cavalry 
 * You can not use this plugin without author permission
 * Date: 21 April 2011
 */
 

if(!jQuery().dcf_TipCreate) 
{ 
 
 (function($) {
  jQuery.fn.dcf_TipCreate = function(options) {   
      var opts = jQuery.extend({}, jQuery.fn.dcf_TipCreate.defaults, options);
      var ttypes = { simple:'simple'};
      var tpos = { rightbottom:'right-bottom', bottom:'bottom', leftbottom:'left-bottom', left:'left', lefttop:'left-top', top:'top', righttop:'right-top', right:'right'};
      
      var DC_TIME_ID = 'dc-time-id';
      var DC_TEXT = 'dc-text'; 
      
      return this.each(function() {
        
        switch(opts.type)
        {
            case ttypes.simple:
                jQuery(this).hover(simpleTypeHoverIn, simpleTypeHoverOut); 
                jQuery(this).mousemove(simpleTypeMouseMove);
            break;
        }               
    });  
    
    function simpleTypeHoverIn(e)
    {
        if(jQuery('#dc-tip-simple').length) { jQuery('#dc-tip-simple').remove(); }        
        jQuery('body').append('<div id="dc-tip-simple"></div>');
        
        var tipbox = jQuery('#dc-tip-simple'); 
        tipbox.css('background-color', opts.bgcolor);
        tipbox.css('border-color', opts.bordercolor); 
        tipbox.css('color', opts.color);
        tipbox.css('border-width', opts.borderwidth);
        
        tipbox.css('padding-left', opts.paddingleft); 
        tipbox.css('padding-top', opts.paddingtop); 
        tipbox.css('padding-right', opts.paddingright); 
        tipbox.css('padding-bottom', opts.paddingbottom);         
        
        if(opts.use_width) { tipbox.css('max-width', opts.width);  }
        
        var loader = jQuery(this);   
        
        var text = '';
        if(opts.text != null)
        {
            text = opts.text;        
        } else
        {
            switch(opts.textattr)
            {
                case 'title':
                text = loader.attr('title');
                loader.removeAttr('title');
                loader.data(DC_TEXT, text);    
                break;
            }
        }  
        tipbox.text(text);   
        
        simpleSetPosition(tipbox, e);                          
        
        var timeout_id = setTimeout(function(){ simpleTypeHoverInEnd(loader); }, opts.delay);
        loader.data(DC_TIME_ID, timeout_id);
    }

    function simpleTypeHoverInEnd(loader)
    {
        var tipbox = jQuery('#dc-tip-simple');
        tipbox.css('opacity', 0.0).css('display', 'block').stop().animate({opacity:1.0}, opts.fade);  
    }    
    
    function simpleTypeMouseMove(e)
    {
        var tipbox = jQuery('#dc-tip-simple');

        simpleSetPosition(tipbox, e);
    }  
    
    function simpleSetPosition(tipbox, e)
    {
        var scroll_pos = jQuery(window).scrollTop(); 
        var width = tipbox.outerWidth();
        var height = tipbox.outerHeight(); 
        var start_pos_x = e.pageX;
        var start_pos_y = e.pageY;
        var window_w = jQuery(window).width();
        var window_h = jQuery(window).height();
        

        switch(opts.pos)
        {
            case tpos.left:
                var final_x =  start_pos_x - width - opts.offsetX;
                var final_y =  start_pos_y - Math.round(height / 2);
                
                if(opts.viewport)
                {
                    if(final_x < 0) { final_x = start_pos_x+opts.offsetX; }  // change to right
                    if(final_y < 0) { final_y = start_pos_y+opts.offsetY; }  // change to bottom
                }
                
                tipbox.css('left', final_x);
                tipbox.css('top', final_y);                 
            break;

            case tpos.lefttop:
                var final_x =  start_pos_x-width-opts.offsetX;
                var final_y =  start_pos_y-opts.offsetY;                  
                
                if(opts.viewport)
                {
                    if(final_x < 0) { final_x = start_pos_x+opts.offsetX; }  // change to right 
                    if(final_y - scroll_pos < 0) { final_y = start_pos_y+opts.offsetY; }  // change to bottom 
                }            
            
                tipbox.css('left', final_x);
                tipbox.css('top', final_y);                 
            break;              
            
            case tpos.righttop:
                var final_x =  start_pos_x + opts.offsetX;
                var final_y =  start_pos_y - opts.offsetY;                  
                
                if(opts.viewport)
                {
                    if(final_x + width > window_w ) { final_x = start_pos_x - width - opts.offsetX; } // change to left  
                    if(final_y - scroll_pos < 0) { final_y = start_pos_y + opts.offsetY; }  // change to bottom 
                }               
            
                tipbox.css('left', final_x);
                tipbox.css('top', final_y);                 
            break;              
            
            case tpos.right:
                var final_x =  start_pos_x + opts.offsetX;
                var final_y =  start_pos_y - Math.round(height / 2);
                
                if(opts.viewport)
                {
                    if(final_x + width > window_w ) { final_x = start_pos_x - width - opts.offsetX; } // change to left
                    if(final_y < 0) { final_y = start_pos_y + opts.offsetY; } // change to bottom
                }            
            
                tipbox.css('left', final_x);
                tipbox.css('top', final_y);                                                                 
            break;            
            
            case tpos.leftbottom:
                var final_x =  start_pos_x - width-opts.offsetX;
                var final_y =  start_pos_y + opts.offsetY;              
            
                if(opts.viewport)
                {
                    if(final_x < 0) { final_x = start_pos_x + opts.offsetX; }  // change to right
                    if(final_y - scroll_pos + height > window_h) { final_y = start_pos_y - opts.offsetY - height; } // change to top     
                }
            
                tipbox.css('left', final_x);
                tipbox.css('top', final_y);                 
            break;

            case tpos.rightbottom:
                var final_x =  start_pos_x + opts.offsetX;
                var final_y =  start_pos_y + opts.offsetY;  
            
                if(opts.viewport)
                {
                    if(final_x + width > window_w ) { final_x = start_pos_x - width - opts.offsetX; } // change to left
                    if(final_y - scroll_pos + height > window_h) { final_y = start_pos_y - opts.offsetY - height; } // change to top      
                }
            
                tipbox.css('left', final_x);
                tipbox.css('top', final_y);                 
            break;
            
            case tpos.bottom:
                var final_x =  start_pos_x - Math.round(width / 2);
                var final_y =  start_pos_y + opts.offsetY;                  
                if(opts.viewport)
                {
                    if(final_x < 0) { final_x = start_pos_x + opts.offsetX; } // change to right
                    else if(final_x + width > window_w ) { final_x = start_pos_x - width - opts.offsetX; } // change to left
                     
                    if(final_y - scroll_pos + height > window_h) { final_y = start_pos_y - opts.offsetY - height; } // change to top
                }               
            
                tipbox.css('left', final_x);
                tipbox.css('top', final_y);                 
            break; 
            
            case tpos.top:
                var final_x =  start_pos_x - Math.round(width / 2);
                var final_y =  start_pos_y - opts.offsetY - height;            
            
                if(opts.viewport)
                {
                    if(final_x < 0) { final_x = start_pos_x + opts.offsetX; } // change to right
                    else if(final_x + width > window_w ) { final_x = start_pos_x - width - opts.offsetX; } // change to left
                     
                    if(final_y - scroll_pos < 0) { final_y = start_pos_y + opts.offsetY; } // change to bottom
                }                
            
                tipbox.css('left', final_x);
                tipbox.css('top', final_y);                 
            break;                        
        }          
    }    
    
    function simpleTypeHoverOut()
    {
        if(isset(jQuery(this).data(DC_TIME_ID)))
        {
            clearTimeout(jQuery(this).data(DC_TIME_ID));
            jQuery(this).removeData(DC_TIME_ID);
        }
        if(jQuery('#dc-tip-simple').length) { jQuery('#dc-tip-simple').stop().remove(); } 
        
        if(opts.text == null)
        {
            switch(opts.textattr)
            {
                case 'title':
                text = jQuery(this).data(DC_TEXT);
                jQuery(this).attr('title', text);  
                break;
            }
        }            
    }
    
    // utilities
    function isset( variable )
    {
        return( typeof( variable ) != 'undefined' );
    }    
    
  } 
  
  jQuery.fn.dcf_TipCreate.defaults = {
    type:'simple', 
    pos:'bottom',
    bgcolor:'#FAFAFA',
    bordercolor:'#DDDDDD',
    borderwidth:1,
    color:'#666666', 
    paddingleft:8,
    paddingright:8,
    paddingtop:5,
    paddingbottom:5,
    width:300,
    align:'center',
    use_width:false,
    offsetX:15,
    offsetY:15,
    text:null,
    textattr:'title',
    delay:300,
    fade:200,
    viewport:true,
    cls:''
  }
})(jQuery);

}


/*
Lightbox v2.6
by Lokesh Dhakar - http://www.lokeshdhakar.com

For more information, visit:
http://lokeshdhakar.com/projects/lightbox2/

Licensed under the Creative Commons Attribution 2.5 License - http://creativecommons.org/licenses/by/2.5/
- free for use in both personal and commercial projects
- attribution requires leaving author name, author link, and the license info intact
*/


function dcf_lb(opt_fn) {
  var $, Lightbox, LightboxOptions;
  $ = jQuery;
  var opt_def = { label: 'Image %i of %c' };
  opt_fn = $.extend({}, opt_def, opt_fn);
             
  

  LightboxOptions = (function() {
    function LightboxOptions() {
      this.fadeDuration = 500;
      this.fitImagesInViewport = true;
      this.resizeDuration = 700;
      this.showImageNumberLabel = true;
      this.wrapAround = false;
    }

    LightboxOptions.prototype.albumLabel = function(curImageNum, albumSize) {
      
        var str = new String(opt_fn.label);
        str = str.replace('%i', curImageNum);
        str = str.replace('%c', albumSize); 
        
        return str;
    };

    return LightboxOptions;

  })();

  Lightbox = (function() {
    function Lightbox(options) {
      this.options = options;
      this.album = [];
      this.currentImageIndex = void 0;
      this.init();
    }

    Lightbox.prototype.init = function() {
      this.enable();
      return this.build();
    };

    Lightbox.prototype.enable = function() {
      var _this = this;
      return $('body').on('click', 'a[rel^=lightbox], area[rel^=lightbox], a[data-lightbox], area[data-lightbox]', function(e) {
        _this.start($(e.currentTarget));
        return false;
      });
    };

    Lightbox.prototype.build = function() {
      var _this = this;
      $("<div id='lightboxOverlay' class='lightboxOverlay'></div><div id='lightbox' class='lightbox'><div class='lb-outerContainer'><div class='lb-container'><img class='lb-image' src='' /><div class='lb-nav'><a class='lb-prev' href='' ></a><a class='lb-next' href='' ></a></div><div class='lb-loader'><a class='lb-cancel'></a></div></div></div><div class='lb-dataContainer'><div class='lb-data'><div class='lb-details'><span class='lb-caption'></span><span class='lb-number'></span></div><div class='lb-closeContainer'><a class='lb-close'></a></div></div></div></div>").appendTo($('body'));
      this.$lightbox = $('#lightbox');
      this.$overlay = $('#lightboxOverlay');
      this.$outerContainer = this.$lightbox.find('.lb-outerContainer');
      this.$container = this.$lightbox.find('.lb-container');
      this.containerTopPadding = parseInt(this.$container.css('padding-top'), 10);
      this.containerRightPadding = parseInt(this.$container.css('padding-right'), 10);
      this.containerBottomPadding = parseInt(this.$container.css('padding-bottom'), 10);
      this.containerLeftPadding = parseInt(this.$container.css('padding-left'), 10);
      this.$overlay.hide().on('click', function() {
        _this.end();
        return false;
      });
      this.$lightbox.hide().on('click', function(e) {
        if ($(e.target).attr('id') === 'lightbox') {
          _this.end();
        }
        return false;
      });
      this.$outerContainer.on('click', function(e) {
        if ($(e.target).attr('id') === 'lightbox') {
          _this.end();
        }
        return false;
      });
      this.$lightbox.find('.lb-prev').on('click', function() {
        if (_this.currentImageIndex === 0) {
          _this.changeImage(_this.album.length - 1);
        } else {
          _this.changeImage(_this.currentImageIndex - 1);
        }
        return false;
      });
      this.$lightbox.find('.lb-next').on('click', function() {
        if (_this.currentImageIndex === _this.album.length - 1) {
          _this.changeImage(0);
        } else {
          _this.changeImage(_this.currentImageIndex + 1);
        }
        return false;
      });
      return this.$lightbox.find('.lb-loader, .lb-close').on('click', function() {
        _this.end();
        return false;
      });
    };

    Lightbox.prototype.start = function($link) {
      var $window, a, dataLightboxValue, i, imageNumber, left, top, _i, _j, _len, _len1, _ref, _ref1;
      $(window).on("resize", this.sizeOverlay);
      $('select, object, embed').css({
        visibility: "hidden"
      });
      this.$overlay.width($(document).width()).height($(document).height()).fadeIn(this.options.fadeDuration);
      this.album = [];
      imageNumber = 0;
      dataLightboxValue = $link.attr('data-lightbox');
      if (dataLightboxValue) {
        _ref = $($link.prop("tagName") + '[data-lightbox="' + dataLightboxValue + '"]');
        for (i = _i = 0, _len = _ref.length; _i < _len; i = ++_i) {
          a = _ref[i];
          this.album.push({
            link: $(a).attr('href'),
            title: $(a).attr('title')
          });
          if ($(a).attr('href') === $link.attr('href')) {
            imageNumber = i;
          }
        }
      } else {
        if ($link.attr('rel') === 'lightbox') {
          this.album.push({
            link: $link.attr('href'),
            title: $link.attr('title')
          });
        } else {
          _ref1 = $($link.prop("tagName") + '[rel="' + $link.attr('rel') + '"]');
          for (i = _j = 0, _len1 = _ref1.length; _j < _len1; i = ++_j) {
            a = _ref1[i];
            this.album.push({
              link: $(a).attr('href'),
              title: $(a).attr('title')
            });
            if ($(a).attr('href') === $link.attr('href')) {
              imageNumber = i;
            }
          }
        }
      }
      $window = $(window);
      top = $window.scrollTop() + $window.height() / 10;
      left = $window.scrollLeft();
      this.$lightbox.css({
        top: top + 'px',
        left: left + 'px'
      }).fadeIn(this.options.fadeDuration);
      this.changeImage(imageNumber);
    };

    Lightbox.prototype.changeImage = function(imageNumber) {
      var $image, preloader,
        _this = this;
      this.disableKeyboardNav();
      $image = this.$lightbox.find('.lb-image');
      this.sizeOverlay();
      this.$overlay.fadeIn(this.options.fadeDuration);
      $('.lb-loader').fadeIn('slow');
      this.$lightbox.find('.lb-image, .lb-nav, .lb-prev, .lb-next, .lb-dataContainer, .lb-numbers, .lb-caption').hide();
      this.$outerContainer.addClass('animating');
      preloader = new Image();
      preloader.onload = function() {
        var $preloader, imageHeight, imageWidth, maxImageHeight, maxImageWidth, windowHeight, windowWidth;
        $image.attr('src', _this.album[imageNumber].link);
        $preloader = $(preloader);
        $image.width(preloader.width);
        $image.height(preloader.height);
        if (_this.options.fitImagesInViewport) {
          windowWidth = $(window).width();
          windowHeight = $(window).height();
          maxImageWidth = windowWidth - _this.containerLeftPadding - _this.containerRightPadding - 20;
          maxImageHeight = windowHeight - _this.containerTopPadding - _this.containerBottomPadding - 110;
          if ((preloader.width > maxImageWidth) || (preloader.height > maxImageHeight)) {
            if ((preloader.width / maxImageWidth) > (preloader.height / maxImageHeight)) {
              imageWidth = maxImageWidth;
              imageHeight = parseInt(preloader.height / (preloader.width / imageWidth), 10);
              $image.width(imageWidth);
              $image.height(imageHeight);
            } else {
              imageHeight = maxImageHeight;
              imageWidth = parseInt(preloader.width / (preloader.height / imageHeight), 10);
              $image.width(imageWidth);
              $image.height(imageHeight);
            }
          }
        }
        return _this.sizeContainer($image.width(), $image.height());
      };
      preloader.src = this.album[imageNumber].link;
      this.currentImageIndex = imageNumber;
    };

    Lightbox.prototype.sizeOverlay = function() {
      return $('#lightboxOverlay').width($(document).width()).height($(document).height());
    };

    Lightbox.prototype.sizeContainer = function(imageWidth, imageHeight) {
      var newHeight, newWidth, oldHeight, oldWidth,
        _this = this;
      oldWidth = this.$outerContainer.outerWidth();
      oldHeight = this.$outerContainer.outerHeight();
      newWidth = imageWidth + this.containerLeftPadding + this.containerRightPadding;
      newHeight = imageHeight + this.containerTopPadding + this.containerBottomPadding;
      this.$outerContainer.animate({
        width: newWidth,
        height: newHeight
      }, this.options.resizeDuration, 'swing');
      setTimeout(function() {
        _this.$lightbox.find('.lb-dataContainer').width(newWidth);
        _this.$lightbox.find('.lb-prevLink').height(newHeight);
        _this.$lightbox.find('.lb-nextLink').height(newHeight);
        _this.showImage();
      }, this.options.resizeDuration);
    };

    Lightbox.prototype.showImage = function() {
      this.$lightbox.find('.lb-loader').hide();
      this.$lightbox.find('.lb-image').fadeIn('slow');
      this.updateNav();
      this.updateDetails();
      this.preloadNeighboringImages();
      this.enableKeyboardNav();
    };

    Lightbox.prototype.updateNav = function() {
      this.$lightbox.find('.lb-nav').show();
      if (this.album.length > 1) {
        if (this.options.wrapAround) {
          this.$lightbox.find('.lb-prev, .lb-next').show();
        } else {
          if (this.currentImageIndex > 0) {
            this.$lightbox.find('.lb-prev').show();
          }
          if (this.currentImageIndex < this.album.length - 1) {
            this.$lightbox.find('.lb-next').show();
          }
        }
      }
    };

    Lightbox.prototype.updateDetails = function() {
      var _this = this;
      if (typeof this.album[this.currentImageIndex].title !== 'undefined' && this.album[this.currentImageIndex].title !== "") {
        this.$lightbox.find('.lb-caption').html(this.album[this.currentImageIndex].title).fadeIn('fast');
      }
      if (this.album.length > 1 && this.options.showImageNumberLabel) {
        this.$lightbox.find('.lb-number').text(this.options.albumLabel(this.currentImageIndex + 1, this.album.length)).fadeIn('fast');
      } else {
        this.$lightbox.find('.lb-number').hide();
      }
      this.$outerContainer.removeClass('animating');
      this.$lightbox.find('.lb-dataContainer').fadeIn(this.resizeDuration, function() {
        return _this.sizeOverlay();
      });
    };

    Lightbox.prototype.preloadNeighboringImages = function() {
      var preloadNext, preloadPrev;
      if (this.album.length > this.currentImageIndex + 1) {
        preloadNext = new Image();
        preloadNext.src = this.album[this.currentImageIndex + 1].link;
      }
      if (this.currentImageIndex > 0) {
        preloadPrev = new Image();
        preloadPrev.src = this.album[this.currentImageIndex - 1].link;
      }
    };

    Lightbox.prototype.enableKeyboardNav = function() {
      $(document).on('keyup.keyboard', $.proxy(this.keyboardAction, this));
    };

    Lightbox.prototype.disableKeyboardNav = function() {
      $(document).off('.keyboard');
    };

    Lightbox.prototype.keyboardAction = function(event) {
      var KEYCODE_ESC, KEYCODE_LEFTARROW, KEYCODE_RIGHTARROW, key, keycode;
      KEYCODE_ESC = 27;
      KEYCODE_LEFTARROW = 37;
      KEYCODE_RIGHTARROW = 39;
      keycode = event.keyCode;
      key = String.fromCharCode(keycode).toLowerCase();
      if (keycode === KEYCODE_ESC || key.match(/x|o|c/)) {
        this.end();
      } else if (key === 'p' || keycode === KEYCODE_LEFTARROW) {
        if (this.currentImageIndex !== 0) {
          this.changeImage(this.currentImageIndex - 1);
        }
      } else if (key === 'n' || keycode === KEYCODE_RIGHTARROW) {
        if (this.currentImageIndex !== this.album.length - 1) {
          this.changeImage(this.currentImageIndex + 1);
        }
      }
    };

    Lightbox.prototype.end = function() {
      this.disableKeyboardNav();
      $(window).off("resize", this.sizeOverlay);
      this.$lightbox.fadeOut(this.options.fadeDuration);
      this.$overlay.fadeOut(this.options.fadeDuration);
      return $('select, object, embed').css({
        visibility: "visible"
      });
    };

    return Lightbox;

  })();

  $(function() {
    var lightbox, options;
    options = new LightboxOptions();
    return lightbox = new Lightbox(options);
  });

}

dcf_lb({label:dccp_s.lb_label});
         

/***************************************************
  PAGE MAIN CODE
****************************************************/                  
jQuery(document).ready(function($) 
{     
/*
    // touchtesting
    if('ontouchstart' in document.documentElement) 
    {
        var time_start = null;
        
        jQuery('#testBox').each(function() 
        {
            if('ontouchstart' in document.documentElement) 
            {
                this.addEventListener('touchstart', onTouchStart, false);
            }
        });   
        
        function onTouchStart(e) {
          
            time_start = new Date();
            jQuery(this).find('.time-start').text(time_start.getTime());
            jQuery(this).css('background-color', 'yellow');            
            
            this.addEventListener('touchmove', onTouchMove, false);
            this.addEventListener('touchend', onTouchEnd, false);
        }     
        
      function onTouchMove(e) 
      {
        e.preventDefault();
      }
        
        function onTouchEnd(e) 
        {

          var time_end = new Date();
          jQuery(this).find('.time-end').text(time_end.getTime());            
          jQuery(this).find('.time-delta').text(time_end.getTime() - time_start.getTime());
          jQuery(this).css('background-color', '#66CCFF');  
            
          //Finish the touch by undoing the touch session
          this.removeEventListener('touchmove', onTouchMove, false);
          this.removeEventListener('touchend', onTouchEnd, false);
        }                
    }
 */ 
         
    function dcf_createCookie(name,value,days) 
    {
        var expires = '';
        if(days != 0) 
        {
            var date = new Date();  
            date.setTime(date.getTime()+(days*24*60*60*1000));
            expires = "; expires="+date.toGMTString();
        }
        document.cookie = name+"="+value+expires+"; path=/";
    }

    function dcf_readCookie(name) 
    {
        var nameEQ = name + '=';
        var ca = document.cookie.split(';');
        for(var i=0;i < ca.length;i++) {
            var c = ca[i];
            while (c.charAt(0)==' ') c = c.substring(1,c.length);
            if (c.indexOf(nameEQ) == 0) return c.substring(nameEQ.length,c.length);
        }
        return null;
    }

    function dcf_eraseCookie(name) 
    {
        createCookie(name,'',-1);
    }       
    
    /* dccp_s - dc theme object */     

    dccp_s.last_resolution = 0;

    jQuery(window).resize(function() 
    {         
        var w = jQuery(window).width(); 
        
        if(w < 320) { w = 319; } else
        if(w < 480) { w = 479; } else          
        if(w < 768) { w = 767; } else
        if(w < 960) { w = 959; } else       
        if(w < 1152) { w = 1151; } else  
        { w = 1200; } 
                        
        if(dccp_s.last_resolution != w)
        {   
            dccp_s.last_resolution = w;
        }
    });    

    /****************************************************
    * DC CSS LAYOUT CORRECT ACTIONS
    *****************************************************/
    jQuery('.dc-left-sidebar, .dc-right-sidebar').find('.dc-widget-wrapper:last').css('padding-bottom', 0);

    /****************************************************
    * DC CSS CORRECT ACTIONS
    *****************************************************/
    jQuery('#dc-announcement-bar').each(function() {
        
        var cn = 'dc_wp_cook_abar_hide';
        var cn_v = 'hide';
        var v = dcf_readCookie(cn);
        
        if(v == cn_v)
        {
            jQuery(this).remove();    
        } else
        {
            jQuery(this).css('display', 'block'); 
            jQuery(this).find('.close-btn').click(function() {
                jQuery(this).parent().remove();
                dcf_createCookie(cn, cn_v, 0);
            });       
        }
        
    });
    
    /****************************************************
    * DC BUILDER SEGMENT - NGG RECENT SLIDER
    *****************************************************/
    jQuery('.dc-ngg-recent-slider-seg').each(function() { 
        
        var $slider = jQuery(this);
        var $wrapper = $slider.parent();
        $slider.find('.page:first').css('opacity', 0.0).css('display', 'block').animate({opacity:1.0}, 600);
        var pages_count = $slider.find('.page').length;
        $slider.data('dc_blocked', false);                         
        $slider.data('dc_current', 0);
        
        $slider.find('.next-btn').click(function(){
            
            var b = $slider.data('dc_blocked');
            if(b) { return; }
            $slider.data('dc_blocked', true);
            
            var c = $slider.data('dc_current');
            var n = c + 1;
            if(n >= pages_count) { n = 0; }
            
            $slider.find('.page:eq('+c+')').animate({opacity:0.0}, 200, function() {
                $slider.find('.page:eq('+c+')').css('display', 'none');                
            });
            
            $slider.find('.page:eq('+n+')').css('opacity', 0.0).css('left', 0).css('display', 'block').animate({opacity:1.0}, 800, function() {
                
                $slider.data('dc_current', n);
                $slider.data('dc_blocked', false);
            });            
            
        });


        $slider.find('.prev-btn').click(function(){
            
            var b = $slider.data('dc_blocked');
            if(b) { return; }
            $slider.data('dc_blocked', true);
            
            var c = $slider.data('dc_current');
            var n = c - 1;
            if(n < 0) { n = pages_count - 1; }
            
            $slider.find('.page:eq('+c+')').animate({opacity:0.0}, 200, function() {
                $slider.find('.page:eq('+c+')').css('display', 'none');                
            });
            
            $slider.find('.page:eq('+n+')').css('opacity', 0.0).css('left', 0).css('display', 'block').animate({opacity:1.0}, 800, function() {
                
                $slider.data('dc_current', n);
                $slider.data('dc_blocked', false);
            });              
            
        });
        
        // mobile devices
        if('ontouchstart' in document.documentElement)    
        {
            var time_s = null;
            var time_end = null;
            var scroll = false;
            var delta_x = 0;
            var start_x = false;
            var start_y = false;
            var slider_w = $slider.width();

            $slider.each(function() { this.addEventListener('touchstart', onTouchStart, false); });

            function onTouchStart(e) 
            {
                var b = $slider.data('dc_blocked');
                if(b) 
                { 
                    e.preventDefault();
                    return; 
                }                                                       
                e.preventDefault(); 
                
                if(e.touches.length == 1) 
                {
                    time_s = new Date(); 
                    start_x = e.touches[0].pageX;
                    start_y = e.touches[0].pageY;

                    this.addEventListener('touchmove', onTouchMove, false);
                    this.addEventListener('touchend', onTouchEnd, false);
                }
            } 
            
            function onTouchMove(e) 
            {
                delta_x = e.touches[0].pageX - start_x;  
                scroll = (Math.abs(delta_x) < Math.abs(e.touches[0].pageY - start_y));                              
                if(!scroll) { e.preventDefault(); }                
            }    
            
           function onTouchEnd(e) 
           {
                time_end = new Date();  

                if(!scroll && (time_end.getTime() - time_s.getTime()) < 600 && (Math.abs(delta_x) > (slider_w/4)))
                {
                    var b = $slider.data('dc_blocked');
                    if(!b)
                    {                                         
                        if(delta_x < 0) 
                        { 
                            $slider.find('.next-btn').trigger('click');
                        } 
                        else 
                        { 
                            $slider.find('.prev-btn').trigger('click');   
                        }
                        e.preventDefault();                           
                    }                  
                }               
              
                this.removeEventListener('touchmove', onTouchMove, false);
                this.removeEventListener('touchend', onTouchEnd, false);
                start_x = null;
                start_y = null;
                delta_x = null;
            }                    
                           
        }        
                
    });
    
    /****************************************************
    * DC PROGRAM CODE FORMATING
    *****************************************************/     
    jQuery('pre.dc-code').highlight({source:true, stripes:false, indent:'space'});
    
    /****************************************************
    * DC BASIC SLIDER
    *****************************************************/    
    jQuery('.dc-basic-slider').dcf_BasicResponsiveSlider();
    
    /****************************************************
    * DCS NGG THUMBS SLIDER
    *****************************************************/
    jQuery('.dcs-ngg-thumbs-slider').each(
        function()
        {
            jQuery(this).find('.thumb').hover(
              function()
              {
                 jQuery(this).stop().animate({opacity:0.6}, 200);    
              },
              function()
              {
                 jQuery(this).stop().animate({opacity:1.0}, 900); 
              }
            );            
            
            $slider = jQuery(this);
            jQuery(this).find('.slide:first').css('display', 'block');                       
            jQuery(this).find('.slide:first .slide-desc').css('opacity', 1.0); 
            jQuery(this).find('.slider').data('dc_current', 0);
            jQuery(this).find('.slider').data('dc_block', false);
            
            var mode = jQuery(this).find('.trans').html();           
            var count = jQuery(this).find('.slide').length;
            var width = jQuery(this).find('.slide').width();
     
            jQuery(this).find('.thumb').click(
              function()
              {
                  var wrapper = jQuery(this).parent();
                  var index = wrapper.find('.thumb').index(this);
                  
                  var slider = jQuery(this).parent().parent().find('.slider'); 
                  if(slider.data('dc_block') || index == slider.data('dc_current'))
                  {
                      return;
                  }
                  slider.data('dc_block', true);
                  var current = slider.data('dc_current');
                  slider.find('.slide:eq('+current+')').css('z-index', 1);

                  
                  if(mode == 'none')
                  {
                      slider.find('.slide:eq('+index+') .slide-desc').css('opacity', 0.0); 
                      slider.find('.slide:eq('+index+')').css('opacity', 1.0).css('z-index', 2).css('display', 'block');                                     
                      slider.find('.slide:eq('+current+')').css('display', 'none');
                      slider.data('dc_current', index);
                      slider.data('dc_block', false);
                      slider.find('.slide:eq('+index+') .slide-desc').stop().css('opacity', 0.0).animate({opacity:1.0}, 800);
                  } else
                  if(mode == 'fade')
                  {
                      slider.find('.slide:eq('+index+') .slide-desc').css('opacity', 0.0); 
                      slider.find('.slide:eq('+index+')').css('opacity', 0.0).css('z-index', 2).css('display', 'block').animate({opacity: 1.0}, 400, 
                        function()
                        {
                            var slider = jQuery(this).parent();
                            slider.find('.slide:eq('+current+')').css('display', 'none');
                            slider.data('dc_current', index);
                            slider.data('dc_block', false);
                            jQuery(this).find('.slide-desc').stop().css('opacity', 0.0).animate({opacity:1.0}, 800);
                        });                      
                  } else
                  if(mode == 'slide')
                  {
                      var src_left = $slider.find('.slide:first').width();
                      if(index < current)
                      {
                        src_left = -src_left;    
                      }
                      
                      slider.find('.slide:eq('+index+') .slide-desc').css('opacity', 0.0); 
                      slider.find('.slide:eq('+index+')').css('left', src_left).css('z-index', 2).css('display', 'block').animate({left: 0}, 400, 
                        function()
                        {
                            var slider = jQuery(this).parent();
                            slider.find('.slide:eq('+current+')').css('display', 'none');
                            slider.data('dc_current', index);
                            slider.data('dc_block', false);
                            jQuery(this).find('.slide-desc').stop().css('opacity', 0.0).animate({opacity:1.0}, 800);
                        }); 
                    
                  } else
                  {
                      slider.find('.slide:eq('+index+') .slide-desc').css('opacity', 0.0); 
                      slider.find('.slide:eq('+index+')').css('opacity', 1.0).css('z-index', 2).css('display', 'block');                                     
                      slider.find('.slide:eq('+current+')').css('display', 'none');
                      slider.data('dc_current', index);
                      slider.data('dc_block', false);
                      slider.find('.slide:eq('+index+') .slide-desc').stop().css('opacity', 0.0).animate({opacity:1.0}, 800);                      
                  }
               
              });
                
        });         
    
    /****************************************************
    * DC HOMEPAGE BOARD SLIDER
    *****************************************************/
    jQuery('.dc-board-slider').each(function() {
        
        var $slider = jQuery(this);
        var $panel = $slider.find('.panel');
        var $n_btn = $panel.find('.next-btn');
        var $p_btn = $panel.find('.prev-btn');        
        var $pages_container = $slider.find('.pages-container');
        var w = $slider.width(); 
        var pages_count = $slider.find('.slide-page').length;
        var HOVER_DELAY = 120;
        
        for(var i = 0; i < pages_count; i++)
        {
            $slider.find('.slide-page:eq('+i+')').css('left', i*w);   
        }
        
        $pages_container.width(w*pages_count);
        
        $slider.data('dc_page_index', 0);
        $slider.data('autoplay_blocked', false);
        $slider.data('dc_blocked', false); 
        
        var cell_desc_on_hover = $slider.find('.cell-desc-on-hover');
        if(cell_desc_on_hover.length) { cell_desc_on_hover = true; } else { cell_desc_on_hover = false; }
        if(cell_desc_on_hover) { $slider.find('.cell .image-info').css('opacity', 0.0); }              
        
        $slider.find('.slide-page:first').css('display', 'block');
        var autoplay_anim = false;
        var autoplay_time = $slider.find('span.autoplay-time');
        if(autoplay_time.length)
        {
            autoplay_anim = true; 
            autoplay_time = parseInt(autoplay_time.text()); 
        }     
                                               
        if(pages_count > 1)
        {
            $panel.css('display', 'block');
            

            
            function dc_board_slider_autoplay()
            {
                $n_btn.trigger('click');   
                
                var autoplay_blocked = $slider.data('autoplay_blocked');
                if(!autoplay_blocked)
                {
                    var autoplay_handle = $slider.data('autoplay_handle');
                    clearTimeout(autoplay_handle);
                    autoplay_handle = setTimeout(dc_board_slider_autoplay, autoplay_time);
                    $slider.data('autoplay_handle', autoplay_handle);                      
                } 
            }
            
            if(autoplay_anim)
            {
                var autoplay_handle = setTimeout(dc_board_slider_autoplay, autoplay_time);
                $slider.data('autoplay_handle', autoplay_handle);
            }
            
            $n_btn.click(function(){                                

                var blocked = $slider.data('dc_blocked');
                if(blocked) { return; }
                
                var autoplay_blocked = $slider.data('autoplay_blocked');
                if(!autoplay_blocked && autoplay_anim)
                {
                    var autoplay_handle = $slider.data('autoplay_handle');
                    clearTimeout(autoplay_handle);
                    autoplay_handle = setTimeout(dc_board_slider_autoplay, autoplay_time);
                    $slider.data('autoplay_handle', autoplay_handle);                      
                }
                
                $slider.data('dc_blocked', true);
                var current_page = $slider.data('dc_page_index');
                var next_page = current_page + 1;
                if(next_page >= pages_count) { next_page = 0; }
                
                $slider.data('dc_next_index', next_page);
                
                var w = $slider.width();
                var left = -(next_page * w);
                
                $pages_container.find('.slide-page').css('display', 'block');
                $pages_container.animate({left:left}, 600, 'easeOutCirc', function(){
                  
                  $pages_container.find('.slide-page').not('.slide-page:eq('+next_page+')').css('display', 'none'); 
                  $slider.data('dc_page_index', next_page)       
                  $slider.data('dc_blocked', false);
                    
                });
                
            });
            
            $p_btn.click(function(){                                                           
                
                var blocked = $slider.data('dc_blocked');
                if(blocked) { return; }
                
                var autoplay_blocked = $slider.data('autoplay_blocked');
                if(!autoplay_blocked && autoplay_anim)
                {
                    var autoplay_handle = $slider.data('autoplay_handle');
                    clearTimeout(autoplay_handle);
                    autoplay_handle = setTimeout(dc_board_slider_autoplay, autoplay_time);
                    $slider.data('autoplay_handle', autoplay_handle);                      
                }                
                
                $slider.data('dc_blocked', true);
                var current_page = $slider.data('dc_page_index');
                var next_page = current_page - 1;
                if(next_page < 0) { next_page = pages_count - 1; }
                
                $slider.data('dc_next_index', next_page);
                
                var w = $slider.width();
                var left = -(next_page * w);
                
                $pages_container.find('.slide-page').css('display', 'block'); 
                $pages_container.animate({left:left}, 600, 'easeOutCirc', function(){
                  
                  $pages_container.find('.slide-page').not('.slide-page:eq('+next_page+')').css('display', 'none');
                  $slider.data('dc_page_index', next_page)       
                  $slider.data('dc_blocked', false);
                    
                });               
            });                 
        }
        
        jQuery(window).resize(function() {
            var w = jQuery(window).width();                   
            
            $pages_container.stop().css('left', 0);
            $slider.find('.slide-page').css('display', 'none');
            $slider.find('.slide-page:first').css('display', 'block');
            $slider.data('dc_page_index', 0);
            $slider.data('dc_blocked', false);  
            
            var pages_count = $slider.find('.slide-page').length;
            var s_w = $slider.width(); 
            for(var i = 0; i < pages_count; i++)
            {
                $slider.find('.slide-page:eq('+i+')').css('left', i*s_w); // .css('display', 'block');    
            }            
            
        });
        
        $slider.hover(
        function(){
                if(autoplay_anim)
                {
                    var autoplay_handle = $slider.data('autoplay_handle');
                    clearTimeout(autoplay_handle);
                    $slider.data('autoplay_blocked', true);   
                }         
        },
        function(){
                if(autoplay_anim)
                {
                    var autoplay_handle = $slider.data('autoplay_handle');
                    clearTimeout(autoplay_handle);                     
                    autoplay_handle = setTimeout(dc_board_slider_autoplay, autoplay_time);
                    $slider.data('autoplay_handle', autoplay_handle);     
                    $slider.data('autoplay_blocked', false);   
                }     
                
           $slider.find('.cell').find('.image-gray').stop().animate({opacity:0.0}, HOVER_DELAY); 
           $slider.find('.cell').find('.image-filter').stop().animate({opacity:0.0}, HOVER_DELAY);
           if(!cell_desc_on_hover)
           {
                $slider.find('.cell').find('.image-info').stop().animate({opacity:1.0}, HOVER_DELAY);                    
           }
        });
        
        // if mobile
        if('ontouchstart' in document.documentElement)    
        {
            $slider.find('.cell .image-trigger').each(function() {
                
                var time_s = null;
                var time_end = null;
                var scroll = false;
                var delta_x = 0;
                var start_x = false;
                var start_y = false;
                var slider_w = $slider.width();

                this.addEventListener('touchstart', onTouchStart, false);

                function onTouchStart(e) 
                {
                    var b = $slider.data('dc_blocked');
                    if(b) 
                    { 
                        e.preventDefault();
                        return; 
                    }                                                       
                    
                    if(jQuery(this).hasClass('mobile-set'))
                    {
                        
                    } else
                    {                                        
                        e.preventDefault();
                        if(e.touches.length == 1) 
                        {                                                        
                            time_s = new Date(); 
                            start_x = e.touches[0].pageX;
                            start_y = e.touches[0].pageY;
                         
                            this.addEventListener('touchmove', onTouchMove, false);
                            this.addEventListener('touchend', onTouchEnd, false);
                        }
                    }
                } 
                
                function onTouchMove(e) 
                {
                    delta_x = e.touches[0].pageX - start_x;  
                    scroll = (Math.abs(delta_x) < Math.abs(e.touches[0].pageY - start_y));                              
                    if(!scroll) { e.preventDefault(); }               
                }    
                
               function onTouchEnd(e) 
               {
                    time_end = new Date();  
                    
                    if((time_end.getTime() - time_s.getTime()) < 400 && (Math.abs(delta_x) < 40))
                    {                      
                        var b = $slider.data('dc_blocked');
                        if(!b)
                        {                                                                 
                            jQuery(this).addClass('mobile-set'); 
                            $cell = jQuery(this).parent();
                            $page = $cell.parent();
                            
                            var attr_hide_desc = $cell.attr('data-desc');    
                            var desc_opacity = 1.0;
                            if(attr_hide_desc == 'hide' && !cell_desc_on_hover) { desc_opacity = 0.0; }                
                            if(cell_desc_on_hover) { desc_opacity = 1.0; }                
                                            
                            $cell.find('.image-hover').stop().animate({opacity:1.0}, HOVER_DELAY); 
                            $cell.find('.image-info').stop().animate({opacity:desc_opacity}, HOVER_DELAY);          
                            $page.find('.cell').not($cell).find('.image-hover').stop().animate({opacity:0.0}, HOVER_DELAY); 
                            if(cell_desc_on_hover)
                            {
                                $page.find('.cell').not($cell).find('.image-info').stop().animate({opacity:0.0}, HOVER_DELAY);                
                            }                                
                            $page.find('.cell').not($cell).find('.image-gray').stop().animate({opacity:1.0}, HOVER_DELAY); 
                            $page.find('.cell').not($cell).find('.image-filter').stop().animate({opacity:0.3}, HOVER_DELAY);
                            $page.find('.cell').not($cell).find('.image-trigger').removeClass('mobile-set'); 
                            
                            if(!cell_desc_on_hover)
                            {
                                $page.find('.cell').not($cell).find('.image-info').stop().animate({opacity:0.7}, HOVER_DELAY);                
                            }                                                                       
                        }                  
                         
                    }               
                  
                    this.removeEventListener('touchmove', onTouchMove, false);
                    this.removeEventListener('touchend', onTouchEnd, false);
                    start_x = null;
                    start_y = null;
                    delta_x = null;
                }                                   
                
            });           
        } else
        {               
            $slider.find('.cell').each(function() {
                var $cell = jQuery(this);
                
                var hoverInEnd = function(loader)
                {
                    var $cell = loader.parent();                                
                    var $page = $cell.parent();       
                        
                    var attr_hide_desc = $cell.attr('data-desc');    
                    var desc_opacity = 1.0;
                    if(attr_hide_desc == 'hide' && !cell_desc_on_hover) { desc_opacity = 0.0; }                
                    if(cell_desc_on_hover) { desc_opacity = 1.0; }                
                                    
                    $cell.find('.image-hover').stop().animate({opacity:1.0}, HOVER_DELAY); 
                    $cell.find('.image-info').stop().animate({opacity:desc_opacity}, HOVER_DELAY);          
                    $page.find('.cell').not($cell).find('.image-gray').stop().animate({opacity:1.0}, HOVER_DELAY); 
                    $page.find('.cell').not($cell).find('.image-filter').stop().animate({opacity:0.3}, HOVER_DELAY);
                    
                    if(!cell_desc_on_hover)
                    {
                        $page.find('.cell').not($cell).find('.image-info').stop().animate({opacity:0.7}, HOVER_DELAY);                
                    }
                }            

     
                var hoverIn = function()
                {
                    var loader = jQuery(this);
                    var timeout_id = setTimeout(function() { hoverInEnd(loader); }, HOVER_DELAY);
                    jQuery(this).data('dc_hover_time', timeout_id);    
                } 
             
                $cell.find('.image-trigger').hover(
                hoverIn,           
                function() {       
                
                    var timeout_id = jQuery(this).data('dc_hover_time');
                    clearTimeout(timeout_id);
                                             
                    var $cell = jQuery(this).parent();
                    var $page = $cell.parent(); 
                    
                    if(cell_desc_on_hover)
                    {
                        $cell.find('.image-info').stop().animate({opacity:0.0}, HOVER_DELAY);     
                    }               
                    
                    if(typeof(timeout_id) != 'undefined')
                    {
                    $cell.find('.image-hover').stop().animate({opacity:0.0}, HOVER_DELAY);         
                    }

                });        
            });   
        }
        
   
        // mobile devices
        if('ontouchstart' in document.documentElement)    
        {
            var time_s = null;
            var time_end = null;
            var scroll = false;
            var delta_x = 0;
            var start_x = false;
            var start_y = false;
            var slider_w = $slider.width();

            $slider.each(function() { this.addEventListener('touchstart', onTouchStart, false); });

            function onTouchStart(e) 
            {
                var b = $slider.data('dc_blocked');
                if(b) 
                { 
                    e.preventDefault();
                    return; 
                }                                                       
                
                if(e.touches.length == 1) 
                {
                    time_s = new Date(); 
                    start_x = e.touches[0].pageX;
                    start_y = e.touches[0].pageY;

                    this.addEventListener('touchmove', onTouchMove, false);
                    this.addEventListener('touchend', onTouchEnd, false);
                }
            } 
            
            function onTouchMove(e) 
            {
                delta_x = e.touches[0].pageX - start_x;  
                scroll = (Math.abs(delta_x) < Math.abs(e.touches[0].pageY - start_y));                              
                if(!scroll) { e.preventDefault(); }                
            }    
            
           function onTouchEnd(e) 
           {
                time_end = new Date();  

                if(!scroll && (time_end.getTime() - time_s.getTime()) < 600 && (Math.abs(delta_x) > (slider_w/4)))
                {
                    var b = $slider.data('dc_blocked');
                    if(!b)
                    {                                         
                        if(delta_x < 0) 
                        { 
                            $n_btn.trigger('click');
                        } 
                        else 
                        { 
                            $p_btn.trigger('click'); 
                        }                        
                    }                  
                }               
              
                this.removeEventListener('touchmove', onTouchMove, false);
                this.removeEventListener('touchend', onTouchEnd, false);
                start_x = null;
                start_y = null;
                delta_x = null;
            }                    
                           
        }                                   
          
    });    
    
    /****************************************************
    * GOOGLE EMAP
    *****************************************************/
    jQuery(".dc-gmap-container").each(function() {
    
        var gmap_type = jQuery(this).find('span.gmap_type').text();
        var gmap_zoom = parseInt(jQuery(this).find('span.gmap_zoom').text());
        var gmap_height = parseInt(jQuery(this).find('span.gmap_height').text());
        jQuery(this).height(gmap_height);
        
        var gmap_wheel = parseInt(jQuery(this).find('span.gmap_wheel').text());        
        gmap_wheel = gmap_wheel != 0 ? true : false;
        
        var gmap_controls = parseInt(jQuery(this).find('span.gmap_controls').text()); 
        gmap_controls = gmap_controls != 0 ? true : false;
        
        var gmap_marker_display = parseInt(jQuery(this).find('span.gmap_marker_display').text());
        gmap_marker_display = gmap_marker_display != 0 ? true : false;
        
        var gmap_marker_popup = parseInt(jQuery(this).find('span.gmap_marker_popup').text());
        gmap_marker_popup = gmap_marker_popup != 0 ? true : false;
        
        var gmap_marker_text = jQuery(this).find('span.gmap_marker_text').text();
        var gmap_marker_head = jQuery(this).find('span.gmap_marker_head').text(); 
        if(gmap_marker_head != '') { gmap_marker_head = '<h5>'+gmap_marker_head+'</h5>'; }  
        
        var gmap_latitude = jQuery(this).find('span.gmap_latitude').text();
        var gmap_longitude = jQuery(this).find('span.gmap_longitude').text();         

        var gmap_hue = jQuery(this).find('span.gmap_hue');
        if(gmap_hue.length) { gmap_hue = gmap_hue.text(); } else { gmap_hue = null; }
        
        var gmap_saturation = jQuery(this).find('span.gmap_saturation');
        if(gmap_saturation.length) { gmap_saturation = parseInt(gmap_saturation.text()); } else { gmap_saturation = null; }

        var gmap_lightness = jQuery(this).find('span.gmap_lightness');
        if(gmap_lightness.length) { gmap_lightness = parseInt(gmap_lightness.text()); } else { gmap_lightness = null; }

        var gmap_gamma = jQuery(this).find('span.gmap_gamma');
        if(gmap_gamma.length) 
        { 
            gmap_gamma = parseInt(gmap_gamma.text())/100; 
            gmap_gamma = gmap_gamma.toFixed(2); 
        } else { gmap_gamma = null; }
        
        var args = { };
        args.latitude = gmap_latitude;
        args.longitude = gmap_longitude;
        args.maptype = gmap_type;
        args.zoom = gmap_zoom;
        args.scrollwheel = gmap_wheel;
        if(!gmap_controls)
        {
            args.controls = false;
        }
        
        if(gmap_marker_display)
        {
            args.markers = [{ latitude: gmap_latitude,
                              longitude: gmap_longitude,
                              html: gmap_marker_head+gmap_marker_text,
                              popup: gmap_marker_popup }];
        }
        
        args.s_hue = gmap_hue;
        args.s_saturation = gmap_saturation;
        args.s_lightness = gmap_lightness; 
        args.s_gamma = gmap_gamma;
    
        jQuery(this).gMap(args);
      
    });
    
    
    
    /****************************************************
    * THEME MAIN MENU RESPONISIVE
    ****************************************************/          
    jQuery('#dc-primary-theme-menu-responsive').change(function() 
    {
        location.href = jQuery(this).val();
    });   

    jQuery('.dc-wp-primary-theme-menu-responsive').change(function() 
    {
        location.href = jQuery(this).val();
    });   
    
    /****************************************************
    * THEME MAIN ICONS WRAPPER
    ****************************************************/       
    jQuery('.dc-main-icons-wrapper .icon-object').each(function() 
    { 
        jQuery(this).hover(function() 
        {    
            var is = jQuery(this).find('img.icon-img-hover').length;   
            if(is)
            {
               jQuery(this).find('img.icon-img-hover').css('display', 'block');
               jQuery(this).find('img.icon-img').css('display', 'none'); 
            }        
            
        }, function(){
           
           var is = jQuery(this).find('img.icon-img').length;
           if(is)
           {
               jQuery(this).find('img.icon-img-hover').css('display', 'none');
               jQuery(this).find('img.icon-img').css('display', 'block');                 
           } 
        });
    
    });
    
    /****************************************************
    * TOOL TIP
    ****************************************************/       
    jQuery('.dc-tip-top').dcf_TipCreate({pos:'top',use_width:true}); 
    
    /****************************************************
    * BLOG SINGLE RELATED POSTS SECTION
    ****************************************************/      
    jQuery('.bpf-related').each(function()
    {
        var m = jQuery(this).find('.cell:first').css('padding-right');
        var c = jQuery(this).find('> div[class^="cell"]').length;
        var last_n = c - (c % 4) - 1;
        
        if(c > 4)
        {
            jQuery(this).find('.cell').css('margin-bottom', m);
            jQuery(this).find('.cell-last').css('margin-bottom', m);
            jQuery(this).find('> div[class^="cell"]:gt('+last_n+')').css('margin-bottom', 0);
        }            
    });
    
    jQuery(window).resize(function()
    {
        jQuery('.bpf-related').each(function()
        {  
            var m = jQuery(this).find('.cell:first').css('padding-right');
            var c = jQuery(this).find('> div[class^="cell"]').length;
            var last_n = c - (c % 4) - 1;
            
            if(c > 4)
            {    
                jQuery(this).find('.cell').css('margin-bottom', m);
                jQuery(this).find('.cell-last').css('margin-bottom', m);
                jQuery(this).find('> div[class^="cell"]:gt('+last_n+')').css('margin-bottom', 0);
                
                jQuery('#test_xxx').text(m);
            }   
        });
    });     
    
    /****************************************************
    * CUFON FONT 
    ****************************************************/        
    if(dccp_s.font_type == 'cufon')
    {    
        var headings = jQuery('h1, h2, h3, h4, h5, h6').not('.no-cufon');        
        Cufon.replace(headings, {fontWeight: 500});            
    }      
    
    /****************************************************
    * SEARCH FORM
    *****************************************************/
    jQuery('.dc-search-control').focus(function() {       
        
        var val = jQuery(this).val();

        if(val == dccp_s.search_dummy_text)
        {
            jQuery(this).val('');
        }
        
    }).blur(function() {
        
        var val = jQuery(this).val();
        if(val == '')
        {
            jQuery(this).val(dccp_s.search_dummy_text);    
        }        
    });
    
    jQuery('.dc-header-search-box-wrapper .search-btn').click(function() {
        
        var $form = jQuery(this).parent();
        $form.submit();
                
    });
    
    /***************************************************
    * IMAGE ASYNC LOADING
    ****************************************************/
    jQuery('.async-img-white-small, .async-img-white-medium, .async-img-white-large, '+
           '.async-img-black-small, .async-img-black-medium, .async-img-black-large, '+
           '.async-img-skin-small,  .async-img-skin-medium,  .async-img-skin-large, .async-img-none').each(
        function()
        {   
            var loader = jQuery(this);
            var imagePath = loader.attr('rel');                              
            var img = new Image();
            jQuery(img).css('opacity', '0.0')

                .load(
                    function() 
                    {
                        loader.prepend(this).removeAttr('rel');
                        jQuery(this)
                            .css('margin', '0px')
                            .css('opacity', '0.0')
                            .animate({opacity: 1.0}, 500,
                                function()
                                {
                                    loader.css('background-image', 'none');
                                   // alert(jQuery(this).width());
                                }
                            );
                        
                        jQuery(this).attr('alt', '');
                        var alt = loader.attr('title');
                        if(alt !== undefined)
                        {
                            jQuery(this).attr('alt', alt);
                            loader.removeAttr('title'); 
                        } else 
                        { 
                            // alert('no alt');
                        }
                    }
                ).attr('src', imagePath);                        
        }
    );      
        
    /********************************
    * THEME STANDARD CONTACT FORM   
    *********************************/
    jQuery('.dc-theme-std-contact-form').each(function() {
    
        var $form = jQuery(this);
        $form.find('.dc-submit-btn').click(function() {
        
            var can_send = true;
            function element(type, value, title)
            {
                this.type = type;
                this.value = value;
                this.title = title;    
            }
            var form_inputs = new Array(); 
                        
            $form.find('input[type=text], input[type=hidden], textarea, select').each(function() 
            { 
                
                $ctrl = jQuery(this);
                if($ctrl.hasClass('bad-field'))
                {
                    $ctrl.removeClass('bad-field');
                }
                
                if($ctrl.attr('name') == 'dc_scode' || $ctrl.attr('name') == 'dc_scodeuser' || $ctrl.attr('name') == 'dc_email_address')
                {
                    var value = $ctrl.val(); 
                    if($ctrl.hasClass('dc-x-required'))
                    {
                        if(value == '') 
                        { 
                            can_send = false;
                            $ctrl.addClass('bad-field'); 
                        }                      
                    }                    
                    
                    var object = new element($ctrl.attr('name'), value, '');
                    form_inputs[form_inputs.length] = object;                          
    
                } else
                {
                
                    var type = 'additional';
                    var title = $ctrl.attr('title');
                    if(title == undefined) { title = ''; }
                    var value = '';
                    if($ctrl.is('select'))
                    {
                        value = $ctrl.find('option:selected').val();
                        if(value == undefined) { value = ''; }        
                    } else
                    {
                        value = $ctrl.val();
                    } 
                   
                    if($ctrl.hasClass('dc-x-email-analyse'))
                    {
                        var regExp = new RegExp(/^[-a-z0-9~!$%^&*_=+}{\'?]+(\.[-a-z0-9~!$%^&*_=+}{\'?]+)*@([a-z0-9]([-a-z0-9_]?[a-z0-9])*(\.[-a-z0-9_]+)*\.(aero|arpa|biz|com|coop|edu|gov|info|int|mil|museum|name|net|org|pro|travel|mobi|[a-z]{2})|([1]?\d{1,2}|2[0-4]{1}\d{1}|25[0-5]{1})(\.([1]?\d{1,2}|2[0-4]{1}\d{1}|25[0-5]{1})){3})(:[0-9]{1,5})?$/i);
                        var resultExp = regExp.exec(value); 
                        if(resultExp == null)
                        {
                            can_send = false;
                            $ctrl.addClass('bad-field');                        
                        }                    
                    }
                   
                    if($ctrl.hasClass('dc-x-required'))
                    {
                        if(value == '') 
                        { 
                            can_send = false;
                            $ctrl.addClass('bad-field'); 
                        };
                        
                    }
                    
                    // set functionality
                    if($ctrl.hasClass('dc-x-func-name')) { type = 'name'; } 
                    else
                    if($ctrl.hasClass('dc-x-func-email')) { type = 'ret_email'; } 
                    else
                    if($ctrl.hasClass('dc-x-func-subject')) { type = 'subject'; } 
                    else
                    if($ctrl.hasClass('dc-x-func-message')) { type = 'message'; }
                    
                    
                    var object = new element(type, value, title);
                    form_inputs[form_inputs.length] = object;    
                
                }            
            }); 
            
            if(can_send)
            {
                data = JSON.stringify(form_inputs);
               
            jQuery.ajax({
           type: "POST",
           url: dccp_s.theme_url+'/php/sendmessage.php',
           data: { data:data},
           dataType: 'text',
           success: function(str){           
                   if(str == 'okay')
                   {  
                       $form.find('.return-info').text(dccp_s.cf_message_ok);
                   } else
                   {
                       $form.find('.return-info').text(dccp_s.cf_message_error); 
                   }
                   
               }}); // ajax call
                
            }              
            
        });    
        
    });

    /********************************
    * THEME MAIN WP MENU    
    *********************************/
    function tmm_wp_topItemHoverIn()
    {
        var $loader = jQuery(this); 
       
        var w = $loader.find('div.mask-line:first').width();
        if(w == 0) 
        {
            w = $loader.find('> a').width();
            $loader.find('div.mask-line:first').width(w);
        }
        
        var time_id = setTimeout(function(){ tmm_wp_topItemHoverInEnd($loader); }, 500);
        $loader.data('dc_time_id', time_id);
    }

    function tmm_wp_topItemHoverOut()
    {
       clearTimeout(jQuery(this).data('dc_time_id')); 

        var mega = jQuery(this).find('div.mega-block'); 
        var count = mega.length;
        if(count)
        {
            if(mega.find('.first-column').length)
            {
                jQuery(this).removeClass('top-mega-hover'); 
            } else
            {
                jQuery(this).removeClass('top-hover');    
            }
            jQuery(this).find('> div.mega-block').css('display', 'none');    
        } else
        {
            jQuery(this).removeClass('top-hover');
            jQuery(this).find('> ul').css('display', 'none');
            jQuery(this).find('> div.mega-custom-block').css('display', 'none');            
        }        
    
        var index = jQuery(this).data('dc_clean_current');
        if(index != -1)
        {
            var len = index.length;            
            for(var i = 0; i < len; i++)
            {
                jQuery(this).parent().find('> li:eq('+index[i]+')').addClass('current-menu-item');    
            }
            
            jQuery(this).data('dc_clean_current', -1);
        }
    }    
       
    function tmm_wp_topItemHoverInEnd(loader)
    {
        loader.addClass('top-hover');
        loader.find('> ul').css('display', 'block');  

        var p = loader.parent();
        var loader_index = p.find('> li').index(loader);
        loader.data('dc_clean_current', -1);
        var index_array = new Array();
        p.find('> li').each(function() {
            var current = jQuery(this).hasClass('current-menu-item');
            var current_p = jQuery(this).hasClass('current-menu-parent'); 
            var current_a = jQuery(this).hasClass('current-menu-ancestor'); 
            
            if(current || current_p || current_a)
            {
                var index = -1;
                index = p.find('> li').index(this);
                            
                if(index != loader_index && loader.data('dc_clean_current') == -1)
                {
                    index_array[index_array.length] = index;
                    p.find('> li:eq('+index+')').removeClass('current-menu-item');
                    p.find('> li:eq('+index+')').removeClass('current-menu-parent');
                    p.find('> li:eq('+index+')').removeClass('current-menu-ancestor');      
                }
            }                        
        });
        if(index_array.length > 0)
        {
            loader.data('dc_clean_current', index_array); 
        }      
    }         
    
       
    if('ontouchstart' in document.documentElement) 
    {
        jQuery('.dc-wp-primary-theme-menu > li > a').click(function(e) 
        { 
            var $li = jQuery(this).closest('li');
            var $ul = $li.find('> ul');
            if($ul.length)
            {                
                $ul.find('li > a').click(function(e) { 

                    var $li = jQuery(this).closest('li');
                    var $ul = $li.find('> ul');
                    
                    if($ul.length)
                    {
                        var ul_display = $ul.css('display'); 
                        if(ul_display == 'block')
                        {
          
                        } else
                        {
                            e.preventDefault();  
                            $li.addClass('current-set-mobile');
                            $ul.css('display', 'block');                        
                        }
                    }                                       
                    
                });
                          
                if($li.hasClass('top-hover'))
                {
  
                } else
                {
                    e.preventDefault();  
                    
                    // find all submenus and close it
                    var $p = $li.parent();
                    $p.find('> li').removeClass('top-hover').find('> ul').css('display', 'none');
                    $p.find('li').removeClass('current-set-mobile');                                                            
                    $p.find('> li').removeClass('current-menu-item');
                    $p.find('> li').removeClass('current-menu-parent');  
                    $p.find('> li').removeClass('current-menu-ancestor');
                    
                    $li.addClass('top-hover');
                    $ul.css('display', 'block');
                }
            } 
                    
        });
    } else
    {        
        jQuery('.dc-wp-primary-theme-menu > li').hover(tmm_wp_topItemHoverIn, tmm_wp_topItemHoverOut);    
    }
    
    jQuery('.dc-wp-primary-theme-menu > li').each(function() 
    {                   
        jQuery(this).data('dc_clean_current', -1);  
        jQuery(this).find('> ul').prepend('<div class="mask-line"><div class="black-line"></div></div>');
        if(jQuery(this).find('> ul').length == 0)
        {
            jQuery(this).addClass('no-any-submenu');
        } else
        {
            jQuery(this).find('> a > div').append('<div class="sub-arrow"></div>');    
        }
        
        jQuery(this).find('> ul li').each(function() { 
          
          if(jQuery(this).find('> ul').length > 0)
          {
              jQuery(this).prepend('<div class="sub-submenu-arrow"></div>');      
          }
            
        });

        
        var li_w = jQuery(this).width();
        var w = jQuery(this).find('> a').width();
        jQuery(this).find('> ul > div.mask-line').each(function(){ jQuery(this).css('width', w); }); 
                                
    });       
    
    
    /********************************
    * THEME MAIN MENU    
    *********************************/
    function tmm_topItemHoverIn()
    {
        var $loader = jQuery(this); 
       
        var w = $loader.find('div.mask-line:first').width();
        if(w == 0) 
        {
            w = $loader.find('> a').width();
            $loader.find('div.mask-line:first').width(w);
        }
        
        var time_id = setTimeout(function(){ tmm_topItemHoverInEnd($loader); }, 500);
        $loader.data('dc_time_id', time_id);
    }

    function tmm_topItemHoverOut()
    {
       clearTimeout(jQuery(this).data('dc_time_id')); 

       var mega = jQuery(this).find('div.mega-block'); 
        var count = mega.length;
        if(count)
        {
            if(mega.find('.first-column').length)
            {
                jQuery(this).removeClass('top-mega-hover'); 
            } else
            {
                jQuery(this).removeClass('top-hover');    
            }
            jQuery(this).find('> div.mega-block').css('display', 'none');    
        } else
        {
            jQuery(this).removeClass('top-hover');
            jQuery(this).find('> ul').css('display', 'none');
            jQuery(this).find('> div.mega-custom-block').css('display', 'none');            
        }        
    
        var index = jQuery(this).data('dc_clean_current');
        if(index != -1)
        {
            var len = index.length;            
            for(var i = 0; i < len; i++)
            {
                jQuery(this).parent().find('> li:eq('+index[i]+')').addClass('top-current');    
            }
            
            jQuery(this).data('dc_clean_current', -1);
        }
    }    
       
    function tmm_topItemHoverInEnd(loader)
    {
        tmm_align_ul_right(loader);
        
        var mega = loader.find('div.mega-block');
        var count = mega.length;
        if(count)
        {
            if(mega.find('.first-column').length)
            {
                loader.addClass('top-mega-hover');    
            } else
            {
                loader.addClass('top-hover');
            }            
            loader.find('> div.mega-block').css('display', 'block');      
        } else
        {
            loader.addClass('top-hover');
            loader.find('> ul').css('display', 'block');  
            loader.find('> div.mega-custom-block').css('display', 'block');
        }  
        
        var p = loader.parent();
        var loader_index = p.find('> li').index(loader);
        loader.data('dc_clean_current', -1);
        var index_array = new Array();
        p.find('> li').each(function() {
            var current = jQuery(this).hasClass('top-current');            
            if(current)
            {
                var index = -1;
                index = p.find('> li').index(this);
                            
                if(index != loader_index && loader.data('dc_clean_current') == -1)
                {
                    index_array[index_array.length] = index;
                    p.find('> li:eq('+index+')').removeClass('top-current');    
                }
            }                        
        });
        if(index_array.length > 0)
        {
            loader.data('dc_clean_current', index_array); 
        }      
    }         
        
    if('ontouchstart' in document.documentElement) 
    {
        jQuery('#dc-primary-theme-menu > li > a').click(function(e) 
        { 
            var $li = jQuery(this).closest('li');
            var $ul = $li.find('> ul');
            var $mega = $li.find('> div.mega-block');
            var $mega_custom = $li.find('> div.mega-custom-block');
            
            // mega menu
            if($mega.length)
            {
                if($li.hasClass('top-hover') || $li.hasClass('top-mega-hover'))
                {
  
                } else
                {
                    e.preventDefault();  
                    
                    // find all submenus and close it
                    var $p = $li.parent();
                    $p.find('> li').removeClass('top-hover').removeClass('top-mega-hover').each(function() { 
                        jQuery(this).find('> ul').css('display', 'none');
                        jQuery(this).find('> div.mega-block').css('display', 'none');
                        jQuery(this).find('> div.mega-custom-block').css('display', 'none');      
                    });
                    $p.find('li').removeClass('current-set-mobile').removeClass('top-current');                                                            
                    
                    if($mega.find('.first-column').length)
                    {
                        $li.addClass('top-mega-hover');    
                    } else
                    {
                        $li.addClass('top-hover');
                    }            
                    $mega.css('display', 'block');                        
                }                
            }
            
            // std submenu
            if($ul.length)
            {                
                $ul.find('li > a').click(function(e) { 

                    var $li = jQuery(this).closest('li');
                    var $ul = $li.find('> ul');
                    
                    if($ul.length)
                    {
                        var ul_display = $ul.css('display'); 
                        if(ul_display == 'block')
                        {
          
                        } else
                        {
                            e.preventDefault();  
                            $li.addClass('current-set-mobile');
                            $ul.css('display', 'block');                        
                        }
                    }                                       
                    
                });
                          
                if($li.hasClass('top-hover'))
                {
  
                } else
                {
                    e.preventDefault();  
                    
                    // find all submenus and close it
                    var $p = $li.parent();
                    $p.find('> li').removeClass('top-hover').removeClass('top-mega-hover').each(function() { 
                        jQuery(this).find('> ul').css('display', 'none');
                        jQuery(this).find('> div.mega-block').css('display', 'none');
                        jQuery(this).find('> div.mega-custom-block').css('display', 'none');      
                    });
                    $p.find('li').removeClass('current-set-mobile').removeClass('top-current');                                                            
                    
                    $li.addClass('top-hover');
                    $ul.css('display', 'block');
                }
            } 
                    
        });        
    } else
    {       
        jQuery('#dc-primary-theme-menu > li').hover(tmm_topItemHoverIn, tmm_topItemHoverOut);
    }
    
    function tmm_align_ul_right($obj)
    {
        var li_w = $obj.width();
        
        if($obj.find('> ul > .opt-align-right').length)
        {             
            var left = 0;
                      
            var w = $obj.find('> ul').width();
           
            left = w - (li_w - 1); // 1px for border 
            
            $obj.find('> ul').css('left', -left);
            $obj.find('> ul > div.mask-line').css('left', 'auto').css('right', 0);
            
            $obj.find('> ul ul').each(function()
            {
                var w = jQuery(this).width(); 
                w = w + 2; // 2px for left and right border                               
                jQuery(this).css('left', -w);
            });          
        }        
    }
        
    jQuery('#dc-primary-theme-menu > li').each(function() 
    {                   
        jQuery(this).data('dc_clean_current', -1);  
        var li_w = jQuery(this).width();
        var w = jQuery(this).find('> a').width();
        jQuery(this).find('> div.mega-block > div.mask-line').each(function(){ jQuery(this).css('width', w); });
        jQuery(this).find('> div.mega-custom-block > div.mask-line').each(function(){ jQuery(this).css('width', w); });
        jQuery(this).find('> ul > div.mask-line').each(function(){ jQuery(this).css('width', w); }); 
        
        tmm_align_ul_right(jQuery(this));
        
        if(jQuery(this).find('> div.mega-custom-block > .opt-align-right').length)
        {            
            var left = 0;                       

            w = jQuery(this).find('> div.mega-custom-block').outerWidth();
            w = w - 2; // 2px for remove left and right border
            jQuery(this).find('> div.mega-custom-block > .opt-align-right').text(li_w);
            left = w - (li_w - 1); // 1px for border 
            
            jQuery(this).find('> div.mega-custom-block').css('left', -left);
            jQuery(this).find('> div.mega-custom-block > div.mask-line').css('left', 'auto').css('right', 0);         
        }        
        
        jQuery(this).find('> div.mega-block').each(function() {        
            
            var len = jQuery(this).find('> div.mega-column ul').length;
            var w = 0;
            
            for(var i = 0; i < len; i++)
            {
                var ul_w = jQuery(this).find('> div.mega-column ul:eq('+i+')').outerWidth(); 
                w += ul_w;  
            }    
            
            jQuery(this).css('width', w);
                
       
            if(jQuery(this).find('> .opt-align-right').length)
            {
                
                var li_w = jQuery(this).parent().width();
                var left = w - (li_w - 1); // 1px for border 

                jQuery(this).css('left', -left);
                jQuery(this).find('> div.mask-line').css('left', 'auto').css('right', 0); 
                
                if(jQuery(this).find(' > .mega-column:first').hasClass('first-column'))
                {
                    jQuery(this).find(' > .mega-column:first').removeClass('first-column');
                    jQuery(this).find(' > .mega-column:last').addClass('first-column');
                }
            }  
         
            
        });
                                
    });        
              
}); 
