<?php
/**********************************************************************
* OSAKA UNLIMITED WORDPRESS THEME 
* (Ideal For Business And Personal Use: Portfolio or Blog)     
* 
* File name:   
*      cp_widgets.php
* Brief:       
*      Part of theme control panel.
* Author:      
*      DigitalCavalry
* Author URI:
*      http://themeforest.net/user/DigitalCavalry
* Contact:
*      digitalcavalry@gmail.com 
***********************************************************************/

/*********************************************************** 
* Definitions
************************************************************/

define('CMS_DC_REGISTER_WIDGET_SEARCH', true);    
define('CMS_DC_REGISTER_WIDGET_RECENT_POSTS', true);  
define('CMS_DC_REGISTER_WIDGET_POSTS_TAGS', true);  
define('CMS_DC_REGISTER_WIDGET_TEXT', true);    
define('CMS_DC_REGISTER_WIDGET_TWITTER', true);
define('CMS_DC_REGISTER_WIDGET_NGG_RECENT', true);
define('CMS_DC_REGISTER_WIDGET_ARCHIVES', true); 
define('CMS_DC_REGISTER_WIDGET_CATEGORIES', true);
define('CMS_DC_REGISTER_WIDGET_PAGES', true);
define('CMS_DC_REGISTER_WIDGET_MEMBERS', true);
define('CMS_DC_REGISTER_WIDGET_HEADING', true);
define('CMS_DC_REGISTER_WIDGET_POSTBOX', true);
define('CMS_DC_REGISTER_WIDGET_PAGEBOX', true);
define('CMS_DC_REGISTER_WIDGET_IMAGE', true);
define('CMS_DC_REGISTER_WIDGET_VIDEO', true);
define('CMS_DC_REGISTER_WIDGET_CONTACT_DATA', true);  
  
/*
 * Plugin Name: Search Widget
 * Version: 1.0
 * Plugin URI: http://themeforest.net/user/DigitalCavalry
 * Description: Search
 * Author: Digital Cavalry
 * Author URI: http://themeforest.net/user/DigitalCavalry
 */  

if(CMS_DC_REGISTER_WIDGET_SEARCH)
{
 
class dcwp_search extends WP_Widget 
{
    function __construct() 
    {        
        $args = array(
            'classname' => 'dcwp_search', 
            'description' => __('Search', CMS_TXT_DOMAIN).' ('.CMS_THEME_NAME.' theme)' // description displayed in WP widgets area
        );
        
        parent::__construct(
            'dcwp_search_id',   // WP ID should be unique 
            'DC Search', // name displayed in WP widgets area
            $args);
    }

    function widget($args, $instance) 
    {
        echo $args['before_widget'];
        if(trim($instance['title']) != '') { echo $args['before_title'].$instance['title'].$args['after_title']; }
        $search = GetDCCPI()->getIRenderer()->getSearchQueryVar();
        
        $out = '';        
        $out .= '<div class="dc-widget-search">';
            $out .= '<form role="search" method="get" id="searchform" action="'.get_bloginfo('url').'">';
                $out .= '<div><input type="text" class="dc-search-control" value="'.$search.'" name="s" id="s"></div>';
            $out .= '</form>';
            $out .= '<div class="dc-clear-both"></div>';
        $out .= '</div>';                
        echo $out;         
        
        echo $args['after_widget'];
    }

    function update($new_instance, $old_instance) 
    {
        $instance = array();        
        $instance['title'] = $new_instance['title'];
        
        return $instance;
    }    
    
    function form($instance) 
    {
        $def = array('title' => '');
        $instance = dcf_combineArgs($def, $instance);

        $out = '';
        $out .= '<span class="dc-cms-control-top-label-nomargin">Widget title</span>'; 
        $out .= '<input id="'.$this->get_field_id('title').'" class="dc-cms-control-wide" name="'.$this->get_field_name('title').'" type="text" value="'.$instance['title'].'" />';
        
        echo $out;
    }
}

// Register widget
function dcwp_searchInit() { register_widget('dcwp_search'); }
add_action('widgets_init', 'dcwp_searchInit');  

}
  
/*
 * Plugin Name: Recent Posts Widget
 * Version: 1.0
 * Plugin URI: http://themeforest.net/user/DigitalCavalry
 * Description: Recent Posts
 * Author: Digital Cavalry
 * Author URI: http://themeforest.net/user/DigitalCavalry
 */

if(CMS_DC_REGISTER_WIDGET_RECENT_POSTS) 
{ 
 
class dcwp_recentposts extends WP_Widget 
{

    function __construct() 
    {        
        $args = array(
            'classname' => 'dcwp_recentposts', 
            'description' => __('The most recent posts on your site', CMS_TXT_DOMAIN).' ('.CMS_THEME_NAME.' theme)' // description displayed in WP widgets area
        );
        
        parent::__construct(
            'dcwp_recentposts_id',   // WP ID should be unique 
            'DC Recent Posts', // name displayed in WP widgets area
            $args);
    }      

   function widget($args, $instance) 
   {
       global $post;
       global $dc_is_single;        
       
       if($instance['count'] < 1) { $instance['count'] = 5; }         
       if($instance['words'] < 1) { $instance['words'] = 10; }  
       
       if(!is_array($instance['excluded'])) { $instance['excluded'] = array(); }
       if(!is_array($instance['cats'])) { $instance['cats'] = array(); } 
       
       if($instance['all-cats'])
       {
            $categories = get_terms('category', array('orderby' => 'count', 'hide_empty' => false));
            if(!is_array($categories)) 
            { 
                $categories = array(); 
            }
            else 
            {
                $temp = array();
                foreach($categories as $cat)
                {
                    array_push($temp, $cat->term_id);
                }
                $categories = $temp;
            }
            $instance['cats'] = $categories;
       }
       
       $query_args = array(
            'posts_per_page' => $instance['count'], 
            'paged' => 1, 
            'nopaging' => false, 
            'post_status' => 'publish', 
            'ignore_sticky_posts' => false, 
            'post_type' => 'post',
            'cache_results' => false, 
            'no_found_rows' => true);
           
        if($dc_is_single)
        {
            $query_args['post__not_in'] = array($post->ID);
        }    
  
        $query_args['tax_query'] = array(
            array(
                'taxonomy' => 'category',
                'field' => 'id',
                'terms' => $instance['cats'],
                'operator' => 'IN'
            ),        
            array(
                'taxonomy' => 'category',
                'field' => 'id',
                'terms' => $instance['excluded'],
                'operator' => 'NOT IN'
            )        
        );  
             
       $dc_query = new WP_Query($query_args);
       if($dc_query->post_count)
       {

           echo $args['before_widget'];
           if(trim($instance['title']) != '') { echo $args['before_title'].$instance['title'].$args['after_title']; }  
           
           $out = '';         
           $out .= '<div class="dc-widget-recent-posts"><ul>';

            for($i = 0; $i < $dc_query->post_count; $i++)
            {    
                $p = & $dc_query->posts[$i];           

                $out .= '<li>';
                if($instance['thumbs'])
                {
                    $meta = get_post_meta($p->ID, 'post_opt', true);
                    
                    $post_image = $meta['post_image'];
                    $post_image_alt = $meta['post_image_alt'];
                    
                    if(GetDCCPI()->getIGeneral()->getOption('theme_use_post_wp_thumbnail'))
                    {
                        $t_data = GetDCCPI()->getIRenderer()->getPostThumbnailURL($p->ID);
                        if($t_data['url'] !== false)
                        {
                            $post_image = $t_data['url'];
                            $post_image_alt = $t_data['alt'];
                        }           
                    } 
                    if($meta['post_image_hide_cbox']) { $post_image = ''; }                   
                    
                    if($post_image != '')
                    {   
                        $out .= '<a class="thumb" href="'.get_permalink($p->ID).'" ><img src="'.dcf_getImageURL($post_image, 50, 50, CMS_IMAGE_CROP_FIT).'" alt="'.$post_image_alt.'" /></a>';
                    }
                }
                
                $excerpt = '';
                if($p->post_excerpt != '') { $excerpt = dcf_strNWords($p->post_excerpt, $instance['words']); }                                              
                
                $add_class = '';
                if($instance['thumbs'] and $post_image != '') { $add_class .= 'description-margin'; }
                
                $out .= '<div class="description '.$add_class.'" >';
                    $out .= '<span class="date">'.mysql2date('F j, Y', $p->post_date_gmt, true).'</span>';
                    $out .= '<a class="title" href="'.get_permalink($p->ID).'" >'.$p->post_title.'</a>';
                    $out .= '<div class="excerpt">'.$excerpt.'</div>';
                    
                    $comment_txt = __('comments', CMS_TXT_DOMAIN);
                    if($p->comment_count == 1) { $comment_txt = __('comment', CMS_TXT_DOMAIN); }
                    
                    $out .= '<div class="comments-count">'.$p->comment_count.' '.$comment_txt.'</div>';
                $out .= '</div>';
            
                $out .= '<div class="dc-clear-both"></div>';
                $out .= '</li>';

            } 
            
           $out .= '</ul></div>';
           echo $out;
           echo $args['after_widget'];         
       }
   }
   
    function update($new_instance, $old_instance) 
    {
        $instance = array();                        
        $instance['title'] = $new_instance['title'];        
        $instance['count'] = (int)$new_instance['count'];        
        $instance['thumbs'] = isset($new_instance['thumbs']);
        $instance['all-cats'] = isset($new_instance['all-cats']);
        $instance['excluded'] = $new_instance['excluded'];  
        $instance['cats'] = $new_instance['cats'];       
        $instance['words'] = (int)$new_instance['words']; 
       
        return $instance;
    }
   
    function form($instance) 
    {   
        $tools = new DCC_BasicTools();
        
        $def = array('title' => '', 'count' => 5, 'thumbs' => true, 'excluded' => '', 'cats' => '', 'all-cats' => false, 'words' => 10);
        $instance = dcf_combineArgs($def, $instance);        
        
        if($instance['count'] < 1) { $instance['count'] = 5; }        
        if(!is_array($instance['cats'])) { $instance['cats'] = array(); }
        if(!is_array($instance['excluded'])) { $instance['excluded'] = array(); } 
        
        $out = '';       
        $out .= '<span class="dc-cms-control-top-label-nomargin">Widget title</span>';
        $out .= '<input class="dc-cms-control-wide" id="'.$this->get_field_id('title').'" name="'.$this->get_field_name('title').'" type="text" value="'.$instance['title'].'" />';

        $out .= '<span class="dc-cms-control-top-label-s-margin">Number of posts to show</span>';
        $out .= $tools->getCtrlInputInt($this->get_field_name('count'), $instance['count'], 1, null);

        $categories = get_terms('category', array('orderby' => 'count', 'hide_empty' => false)); 
        
        $out .= '<span class="dc-cms-control-top-label-s-margin">Categories to display</span>';                      
        $out .= $tools->getStdScrollBoxStart(array('height' => 80));
            foreach($categories as $cat)
            {
                $checked = false;
                if(in_array($cat->term_id, $instance['cats'])) { $checked = true; }
                $out .= '<input type="checkbox" value="'.$cat->term_id.'" name="'.$this->get_field_name('cats').'[]" '.($checked ? ' checked="checked" ' : '').'> '.$cat->name. '<br />';
            }
        $out .= $tools->getStdScrollBoxEnd();
        
        $out .= '<span class="dc-cms-control-top-label-s-margin">Excluded categories</span>';
        $out .= $tools->getStdScrollBoxStart(array('height' => 80));
            foreach($categories as $cat)
            {
                $checked = false;
                if(in_array($cat->term_id, $instance['excluded'])) { $checked = true; }
                $out .= '<input type="checkbox" value="'.$cat->term_id.'" name="'.$this->get_field_name('excluded').'[]" '.($checked ? ' checked="checked" ' : '').'> '.$cat->name. '<br />';
            }
        $out .= $tools->getStdScrollBoxEnd();
        
        $out .= '<span class="dc-cms-control-top-label-s-margin">Number of excerpt words</span>';
        $out .= $tools->getCtrlInputInt($this->get_field_name('words'), $instance['words'], 1, null);        
        
        $out .= '<span class="dc-cms-control-top-label-s-margin">Thumbs</span>'; 
        $out .= '<input name="'.$this->get_field_name('thumbs').'" type="checkbox"'.($instance['thumbs'] ? ' checked="checked" ' : '').' /> Show thumbs<br />';  
        
        $out .= '<span class="dc-cms-control-top-label-s-margin">Other settings</span>';
        $out .= '<input name="'.$this->get_field_name('all-cats').'" type="checkbox"'.($instance['all-cats'] ? ' checked="checked" ' : '').' /> Ignore categories selection - display posts from all available categories (widget will ignore selected categories in above list)';  
        echo $out;   
        
        $out = '<script type="text/javascript">';
            $out .= 'if(jQuery().dcf_setupIntCtrl)';
            $out .= '{';
                $out .= 'jQuery(\'body\').dcf_setupIntCtrl();';
            $out .= '}';
        $out .= '</script>';   
        echo $out;           
    }
}

  // Register widget
  function dcwp_recentpostsInit() { register_widget('dcwp_recentposts'); }
  add_action('widgets_init', 'dcwp_recentpostsInit');  
 
} 
 

/*
 * Plugin Name: Posts Tags Widget
 * Version: 1.0
 * Plugin URI: http://themeforest.net/user/DigitalCavalry
 * Description: Posts Tags
 * Author: Digital Cavalry
 * Author URI: http://themeforest.net/user/DigitalCavalry
 */

if(CMS_DC_REGISTER_WIDGET_POSTS_TAGS) 
{  
 
class dcwp_poststags extends WP_Widget 
{
    
    function __construct() 
    {        
        $args = array(
            'classname' => 'dcwp_poststags', 
            'description' => __('Your most used posts tags in cloud format', CMS_TXT_DOMAIN).' ('.CMS_THEME_NAME.' theme)' // description displayed in WP widgets area
        );
        
        parent::__construct(
            'dcwp_poststags_id',   // WP ID should be unique 
            'DC Posts Tags', // name displayed in WP widgets area
            $args);
    }           

   function widget($args, $instance) 
   {                         
        echo $args['before_widget'];
        if(trim($instance['title']) != '') { echo $args['before_title'].$instance['title'].$args['after_title']; } 

        if($instance['all-terms']) { $instance['count'] = ''; }
        
        $out = '';
        $out .= '<div class="dc-widget-posts-tags">';
        
            $tags = get_terms(
                'post_tag', 
                array(
                    'orderby' => $instance['orderby'], 
                    'order' => $instance['order'],
                    'number' => $instance['count']
                ));
   
            if(is_array($tags))
            {
                $out .= '<ul>';
                foreach($tags as $tag)
                {
                    if($tag->count > 0)
                    {
                        $title = '';
                        $title .= $tag->count.' ';
                        if($tag->count == 1) { $title .= __('topic', CMS_TXT_DOMAIN); } else { $title .= __('topic', CMS_TXT_DOMAIN); }                    
                        $out .= '<li><a class="tag-link" href="'.get_tag_link($tag->term_id).'" title="'.$title.'">'.$tag->name.'</a><span class="tag-count">('.$tag->count.')</span></li>'; 
                    }   
                }
                $out .= '</ul>';
            }
            
            $out .= '<div class="dc-clear-both"></div>';
        $out .= '</div>';
        
        echo $out;
        echo $args['after_widget'];
  }

    function update($new_instance, $old_instance) 
    {
        $instance = array();        
        $instance['title'] = $new_instance['title'];
        $instance['orderby'] = $new_instance['orderby']; 
        $instance['order'] = $new_instance['order']; 
        $instance['count'] = $new_instance['count'];
        $instance['all-terms'] = isset($new_instance['all-terms']);
        
        return $instance;
    }  

     function form($instance) 
    {
        $tools = new DCC_BasicTools();
        
        $def = array('title' => '', 'orderby' => 'name', 'order' => 'ASC', 'count' => 30, 'all-terms' => true);
        $instance = dcf_combineArgs($def, $instance);

        $out = '';
        $out .= '<span class="dc-cms-control-top-label-nomargin">Widget title</span>'; 
        $out .= '<input id="'.$this->get_field_id('title').'" class="dc-cms-control-wide" name="'.$this->get_field_name('title').'" type="text" value="'.$instance['title'].'" />';
        
        $out .= '<span class="dc-cms-control-top-label-s-margin">Number of tags to display</span>'; 
        $out .= $tools->getCtrlInputInt($this->get_field_name('count'), $instance['count'], 1, null);
                                                                              
        $out .= $tools->getStdInputsFieldStart(array('mtop-type' => 'small', 'line-height' => null));
            $out .= '<input name="'.$this->get_field_name('all-terms').'" type="checkbox"'.($instance['all-terms'] ? ' checked="checked" ' : '').' /> Show all tags<br />'; 
        $out .= $tools->getStdInputsFieldEnd();
        
        $out .= '<span class="dc-cms-control-top-label-s-margin">Order tags by</span>'; 
        $out .= '<select name="'.$this->get_field_name('orderby').'" class="dc-cms-control-wide">';
            $out .= '<option value="name" '.($instance['orderby'] == 'name' ? ' selected="selected" ' : '').'>Name</option>';
            $out .= '<option value="count" '.($instance['orderby'] == 'count' ? ' selected="selected" ' : '').'>Count</option>';
        $out .= '</select>';

        $out .= '<span class="dc-cms-control-top-label-s-margin">Order</span>'; 
        $out .= '<select name="'.$this->get_field_name('order').'" class="dc-cms-control-wide">';
            $out .= '<option value="ASC" '.($instance['order'] == 'ASC' ? ' selected="selected" ' : '').'>Ascending</option>';
            $out .= '<option value="DESC" '.($instance['order'] == 'DESC' ? ' selected="selected" ' : '').'>Descending</option>';
        $out .= '</select>';
                
        echo $out;
        
        $out = '<script type="text/javascript">';
            $out .= 'if(jQuery().dcf_setupIntCtrl)';
            $out .= '{';
                $out .= 'jQuery(\'body\').dcf_setupIntCtrl();';
            $out .= '}';
        $out .= '</script>';   
        echo $out;        
    }

}

// Register widget
function dcwp_poststagsInit() { register_widget('dcwp_poststags'); }
add_action('widgets_init', 'dcwp_poststagsInit'); 

}

/*
 * Plugin Name: Text Widget
 * Version: 1.0
 * Plugin URI: http://themeforest.net/user/DigitalCavalry
 * Description: Text
 * Author: Digital Cavalry
 * Author URI: http://themeforest.net/user/DigitalCavalry
 */
 
if(CMS_DC_REGISTER_WIDGET_TEXT) 
{  
 
class dcwp_text extends WP_Widget 
{    
    function __construct() 
    {        
        $args = array(
            'classname' => 'dcwp_text', 
            'description' => __('Arbitrary text or HTML', CMS_TXT_DOMAIN).' ('.CMS_THEME_NAME.' theme)' // description displayed in WP widgets area
        );

        parent::__construct(
            'dcwp_text_id',   // WP ID should be unique 
            'DC Text', // name displayed in WP widgets area
            $args);
    }        


    function widget($args, $instance) 
    {       
        echo $args['before_widget'];
        if(trim($instance['title']) != '') { echo $args['before_title'].$instance['title'].$args['after_title']; }        

        $out = '';
        $out .= '<div class="dc-widget-text">'; 
            if($instance['auto-p'])
            {
                $out .= wpautop(do_shortcode($instance['text']));
            } else 
            {
                $out .= do_shortcode($instance['text']);    
            }
        $out .= '</div>';
        echo $out;

        echo $args['after_widget'];
    }

    function update($new_instance, $old_instance) 
    {
        $instance = array();        
        $instance['title'] = $new_instance['title'];
        $instance['text'] = $new_instance['text'];
        $instance['auto-p'] = isset($new_instance['auto-p']);         

        return $instance;
    }

    function form($instance) 
    {
        $def = array('title' => '', 'text' => '', 'auto-p' => false);
        $instance = dcf_combineArgs($def, $instance);

        $out = '';
        $out .= '<span class="dc-cms-control-top-label-nomargin">Widget title</span>'; 
        $out .= '<input id="'.$this->get_field_id('title').'" class="dc-cms-control-wide" name="'.$this->get_field_name('title').'" type="text" value="'.$instance['title'].'" />';

        $out .= '<span class="dc-cms-control-top-label-s-margin">Text to display</span>';
        $out .= '<textarea class="dc-cms-control-wide" rows="16" cols="20" name="'.$this->get_field_name('text').'">'.$instance['text'].'</textarea>';

        $out .= '<span class="dc-cms-control-top-label-s-margin">Other settings</span>';
        $out .= '<input name="'.$this->get_field_name('auto-p').'" type="checkbox" '.($instance['auto-p'] ? ' checked="checked" ' : '').'/> Automatically add paragraphs';
        echo $out;
    }
}

// Register widget
function dcwp_textInit() { register_widget('dcwp_text'); }
add_action('widgets_init', 'dcwp_textInit');
  
}  
  
  

/*
 * Plugin Name: Twitter Widget
 * Version: 1.0
 * Plugin URI: http://themeforest.net/user/DigitalCavalry
 * Description: Twitter
 * Author: Digital Cavalry
 * Author URI: http://themeforest.net/user/DigitalCavalry
 */
 
if(CMS_DC_REGISTER_WIDGET_TWITTER) 
{  
 
class dcwp_twitter extends WP_Widget 
{    
    function __construct() 
    {        
        $args = array(
            'classname' => 'dcwp_twitter', 
            'description' => __('Recent Twitter tweets', CMS_TXT_DOMAIN).' ('.CMS_THEME_NAME.' theme)' // description displayed in WP widgets area
        );

        parent::__construct(
            'dcwp_twitter_id',   // WP ID should be unique 
            'DC Twitter', // name displayed in WP widgets area
            $args);
    }        


    function widget($args, $instance) 
    {       
        $option_id = $this->id.'_TWITTER';
        $data = get_option($option_id); 
        $time_now = time();

        $consumer_key = GetDCCPI()->getIGeneral()->getOption('twitter_consumer_key');   
        $consumer_secret = GetDCCPI()->getIGeneral()->getOption('twitter_consumer_secret');
        $token_key = GetDCCPI()->getIGeneral()->getOption('twitter_token_key');
        $token_secret = GetDCCPI()->getIGeneral()->getOption('twitter_token_secret');
        
        $twitter_args = array(
            'consumer_key' => $consumer_key,
            'consumer_secret' => $consumer_secret,
            'token_key' => $token_key,
            'token_secret' => $token_secret            
        );    
        
        if(!is_array($data))
        {            
            $data = array('time' => $time_now, 'user' => false, 'timeline' => false);
 
            $twitter = new DCC_Twitter($twitter_args);
            $user = $twitter->getUserData(array('screen_name' => $instance['twitter_screen_name']));
            $timeline = $twitter->getUserTimelineData(array('screen_name' => $instance['twitter_screen_name'], 'count' => 20));
                         
            $data['user'] = $user; 
            $data['timeline'] = $timeline; 
                        
            if($user !== false and $timeline !== false)
            {  
                add_option($option_id, $data);    
            }            
        } else
        {   
            $offset = $instance['tweetes_refresh'];
            
            if($time_now - $data['time'] > $offset)
            {   
                $twitter = new DCC_Twitter($twitter_args);
                $user = $twitter->getUserData(array('screen_name' => $instance['twitter_screen_name']));
                $timeline = $twitter->getUserTimelineData(array('screen_name' => $instance['twitter_screen_name'], 'count' => 20));
            
                $data['time'] = $time_now;
                $data['user'] = $user; 
                $data['timeline'] = $timeline; 
                
                update_option($option_id, $data);                     
            }    
            
            
        }                        
        
        echo $args['before_widget'];
        if(trim($instance['title']) != '') { echo $args['before_title'].$instance['title'].$args['after_title']; }        

        $out = '';
        $out .= '<div class="dc-widget-twitter">';

            $out .= GetDCCPI()->getIRenderer()->wgtTwitter(array(
                'tweetes_count' => $instance['tweetes_count'], 
                'image_display' => $instance['image_display'], 
                'time_offset' => $instance['time_offset'],
                'time_format' => $instance['time_format'], 
                'tweets_count_display' => $instance['tweets_count_display'], 
                'date_display' => $instance['date_display'],
                'data' => $data
            ));        
            
        $out .= '</div>';
        echo $out;

        echo $args['after_widget'];
    }

    function twitterify($text) 
    {
        $text = preg_replace("#(^|[\n ])([\w]+?://[\w]+[^ \"\n\r\t< ]*)[a-z0-9A-Z]*#", "\\1<a href=\"\\2\" target=\"_blank\">\\2</a>", $text);
        $text = preg_replace("#(^|[\n ])((www|ftp)\.[^ \"\t\n\r< ]*)[a-z0-9A-Z]*#", "\\1<a href=\"http://\\2\" target=\"_blank\">\\2</a>", $text);
        $text = preg_replace("/@(\w+)/", "<a href=\"http://www.twitter.com/\\1\" target=\"_blank\">@\\1</a>", $text);
        $text = preg_replace("/#(\w+)/", "<a href=\"http://search.twitter.com/search?q=\\1\" target=\"_blank\">#\\1</a>", $text);
        return $text;
    } 
    
    
    function update($new_instance, $old_instance) 
    {
        $instance = array();        
        $instance['title'] = $new_instance['title'];
        $instance['twitter_screen_name'] = $new_instance['twitter_screen_name'];
        $instance['tweetes_count'] = $new_instance['tweetes_count'];
        $instance['tweetes_refresh'] = $new_instance['tweetes_refresh'];
        $instance['image_display'] = isset($new_instance['image_display']); 
        $instance['tweets_count_display'] = isset($new_instance['tweets_count_display']);
        $instance['date_display'] = isset($new_instance['date_display']); 
        $instance['time_offset'] = $new_instance['time_offset'];
        $instance['time_format'] = $new_instance['time_format']; 
        $instance['reset'] = isset($new_instance['reset']);
        
        if($instance['reset'])
        {            
            $consumer_key = GetDCCPI()->getIGeneral()->getOption('twitter_consumer_key');   
            $consumer_secret = GetDCCPI()->getIGeneral()->getOption('twitter_consumer_secret');
            $token_key = GetDCCPI()->getIGeneral()->getOption('twitter_token_key');
            $token_secret = GetDCCPI()->getIGeneral()->getOption('twitter_token_secret');
            
            $twitter_args = array(
                'consumer_key' => $consumer_key,
                'consumer_secret' => $consumer_secret,
                'token_key' => $token_key,
                'token_secret' => $token_secret            
            );           
                           
            $option_id = $this->id.'_TWITTER';
            $time_now = time();
            $data = array('time' => $time_now, 'user' => false, 'timeline' => false); 
            
            $twitter = new DCC_Twitter($twitter_args);
            $user = $twitter->getUserData(array('screen_name' => $instance['twitter_screen_name']));
            $timeline = $twitter->getUserTimelineData(array('screen_name' => $instance['twitter_screen_name'], 'count' => 20));
        
            $data['time'] = $time_now;
            $data['user'] = $user; 
            $data['timeline'] = $timeline; 
            
            update_option($option_id, $data);
            $instance['reset'] = false;              
        }
        
        return $instance;
    }

    function form($instance) 
    {
        $def = array('title' => '', 'twitter_screen_name' => '', 
            'tweetes_count' => 5, 'tweetes_refresh' => 7200, 'image_display' => true, 'time_offset' => 0,
            'time_format' => 'F j, Y, g:i a', 'tweets_count_display' => true, 'date_display' => true);
        $instance = dcf_combineArgs($def, $instance);

        $out = '';
        $out .= '<span class="dc-cms-control-top-label-nomargin">Widget title</span>'; 
        $out .= '<input id="'.$this->get_field_id('title').'" class="dc-cms-control-wide" name="'.$this->get_field_name('title').'" type="text" value="'.$instance['title'].'" />';

        $out .= '<span class="dc-cms-control-top-label-s-margin">Twitter nick name (screen name)</span>'; 
        $out .= '<input class="dc-cms-control-wide" name="'.$this->get_field_name('twitter_screen_name').'" type="text" value="'.$instance['twitter_screen_name'].'" />'; 
        
        $out .= '<span class="dc-cms-control-top-label-s-margin">Number of displayed tweets</span>';
        $out .= '<select class="dc-cms-control-80" name="'.$this->get_field_name('tweetes_count').'">';
            for($i = 1; $i <= 20; $i++)
            {
                $out .= '<option value="'.$i.'" '.dcf_attrSelected($instance['tweetes_count'] == $i).'>'.$i.'</option>';
            }
        $out .= '</select>';
        
        $out .= '<span class="dc-cms-control-top-label-s-margin">Refresh after every</span>';
        $out .= '<select class="dc-cms-control-80" name="'.$this->get_field_name('tweetes_refresh').'">';
            $out .= '<option value="'.(900).'" '.dcf_attrSelected($instance['tweetes_refresh'] == 900).'>15 m</option>';
            $out .= '<option value="'.(1800).'" '.dcf_attrSelected($instance['tweetes_refresh'] == 1800).'>30 m</option>';
            for($i = 1; $i <= 12; $i++)
            {
                $out .= '<option value="'.(3600*$i).'" '.dcf_attrSelected($instance['tweetes_refresh'] == (3600*$i)).'>'.$i.' h</option>';
            }
        $out .= '</select>';        

        $out .= '<span class="dc-cms-control-top-label-s-margin">Time offset</span>';
        $out .= '<select class="dc-cms-control-80" name="'.$this->get_field_name('time_offset').'">';
            for($i = -12; $i <= 12; $i++)
            {
                $out .= '<option value="'.(3600*$i).'" '.dcf_attrSelected($instance['time_offset'] == (3600*$i)).'>'.sprintf('%+d', $i).' h</option>';     
            }
        $out .= '</select>';
        
        $out .= '<span class="dc-cms-control-top-label-s-margin">Tweet time format</span>'; 
        $out .= '<input class="dc-cms-control-wide" name="'.$this->get_field_name('time_format').'" type="text" value="'.$instance['time_format'].'" />';         
        
        $out .= '<span class="dc-cms-control-top-label-s-margin">Other settings</span>';
        $out .= '<input name="'.$this->get_field_name('image_display').'" type="checkbox" '.($instance['image_display'] ? ' checked="checked" ' : '').'/> Display profile image and name';
        $out .= '<br />';
        $out .= '<input name="'.$this->get_field_name('tweets_count_display').'" type="checkbox" '.($instance['tweets_count_display'] ? ' checked="checked" ' : '').'/> Display tweets count';
        $out .= '<br />';
        $out .= '<input name="'.$this->get_field_name('date_display').'" type="checkbox" '.($instance['date_display'] ? ' checked="checked" ' : '').'/> Display tweet date';
        
        $out .= '<span class="dc-cms-control-top-label-s-margin">Reset</span>'; 
        $out .= '<input name="'.$this->get_field_name('reset').'" type="checkbox" '.($instance['reset'] ? ' checked="checked" ' : '').'/> One time reset twitter data';
        echo $out;
    }
}

// Register widget
function dcwp_twitterInit() { register_widget('dcwp_twitter'); }
add_action('widgets_init', 'dcwp_twitterInit');
  
}  
  
  
/*
 * Plugin Name: NGG Recent Images Widget
 * Version: 1.0
 * Plugin URI: http://themeforest.net/user/DigitalCavalry
 * Description: NGG recent images
 * Author: Digital Cavalry
 * Author URI: http://themeforest.net/user/DigitalCavalry
 */
 
if(CMS_DC_REGISTER_WIDGET_NGG_RECENT) 
{  
 
class dcwp_ngg_recent extends WP_Widget 
{    
    function __construct() 
    {        
        $args = array(
            'classname' => 'dcwp_ngg_recent', 
            'description' => __('NGG recent images', CMS_TXT_DOMAIN).' ('.CMS_THEME_NAME.' theme)' // description displayed in WP widgets area
        );

        parent::__construct(
            'dcwp_ngg_recent_id',   // WP ID should be unique 
            'DC NGG Recent Images', // name displayed in WP widgets area
            $args);
    }        


    function widget($args, $instance) 
    {       
        
        echo $args['before_widget'];
        if(trim($instance['title']) != '') { echo $args['before_title'].$instance['title'].$args['after_title']; }        

        if($instance['gid'] == CMS_NOT_SELECTED) { $instance['gid'] = 0; }
        $images = dcf_getNGGLastImages(0, $instance['count'], true, $instance['gid'], $instance['orderby']);
        $filter = $instance['grayscale'] ? CMS_IMAGE_FILTER_GRAYSCALE : CMS_IMAGE_FILTER_NONE;
        
        $out = '';
        $out .= '<div class="dc-widget-ngg-recent">'; 

            if(is_array($images))
            {
                $style = ' style="width:'.$instance['thumb_w'].'px;height:auto;margin-right:'.$instance['thumb_margin'].'px;margin-bottom:'.$instance['thumb_margin'].'px;" ';
                $out .= '<div class="standard-ver">';
                foreach($images as $i)
                {
                    $out .= '<a href="'.$i->_imageURL.'" href="" rel="lightbox['.$args['widget_id'].']" '.$style.'>';
                        $out .= '<img src="'.dcf_getImageURL($i->_imageURL, $instance['thumb_w'], $instance['thumb_h'], CMS_IMAGE_CROP_FIT, $filter).'" />';
                    $out .= '</a>';
                }    
                $out .= '</div>';

                $out .= '<div class="mobile-ver">';
                foreach($images as $i)
                {
                    $out .= '<a href="'.$i->_imageURL.'" href="" rel="lightbox['.$args['widget_id'].']-mob">';
                        $out .= '<img src="'.dcf_getImageURL($i->_imageURL, 60, 60, CMS_IMAGE_CROP_FIT, $filter).'" />';
                    $out .= '</a>';
                }    
                $out .= '</div>';            
            
            }
        
            $out .= '<div class="dc-clear"></div>';
        $out .= '</div>';
        echo $out;

        echo $args['after_widget'];
    }

    function update($new_instance, $old_instance) 
    {
        $instance = array();        
        $instance['title'] = $new_instance['title'];
        $instance['gid'] = $new_instance['gid'];
        $instance['count'] = $new_instance['count'];
        $instance['grayscale'] = isset($new_instance['grayscale']);
        $instance['orderby'] = $new_instance['orderby'];       
        $instance['thumb_w'] = $new_instance['thumb_w'];
        $instance['thumb_h'] = $new_instance['thumb_h']; 
        $instance['thumb_margin'] = $new_instance['thumb_margin']; 
        
        return $instance;
    }

    function form($instance) 
    {
        $def = array(
            'title' => '', 
            'gid' => CMS_NOT_SELECTED, 
            'count' => 12, 
            'orderby' => 'date', 
            'thumb_w' => 60, 
            'thumb_h' => 60, 
            'thumb_margin' => 5,
            'grayscale' => false
            );
            
        $instance = dcf_combineArgs($def, $instance);
        $tools = new DCC_BasicTools();
        
        $out = '';
        $out .= '<span class="dc-cms-control-top-label-nomargin">Widget title</span>'; 
        $out .= '<input id="'.$this->get_field_id('title').'" class="dc-cms-control-wide" name="'.$this->get_field_name('title').'" type="text" value="'.$instance['title'].'" />';
        
        $out .= '<span class="dc-cms-control-top-label-s-margin">Select NGG gallery</span>'; 
        $args = array(
            'current' => $instance['gid'],
            'name' => $this->get_field_name('gid'),
            'wide' => true
        );
        $out .= $tools->selectCtrlNGGList($args);
        $out .= '<div class="dc-cms-help-note-box-small">';
            $out .= 'If gallery is not selected, widget will try to display recent images from whole NGG';
        $out .= '</div>';
        
        $out .= '<span class="dc-cms-control-top-label-s-margin">Number of images to display</span>'; 
        $out .= $tools->getCtrlInputInt($this->get_field_name('count'), $instance['count'], 1, null);        

        $out .= '<span class="dc-cms-control-top-label-s-margin">Thumb margin</span>'; 
        $out .= $tools->getCtrlInputInt($this->get_field_name('thumb_margin'), $instance['thumb_margin'], 0, null);     
        
        $out .= '<span class="dc-cms-control-top-label-s-margin">Order images by</span>';  
        $out .= '<select name="'.$this->get_field_name('orderby').'" class="dc-cms-control-wide">';
            $out .= '<option value="date" '.$tools->attrSelected($instance['orderby'] == 'date').'>Date</option>';
            $out .= '<option value="sort" '.$tools->attrSelected($instance['orderby'] == 'sort').'>User sort order</option>';
            $out .= '<option value="pid" '.$tools->attrSelected($instance['orderby'] == 'pid').'>Image ID</option>'; 
        $out .= '</select>';

        $out .= '<span class="dc-cms-control-top-label-s-margin">Thumb width</span>'; 
        $out .= $tools->getCtrlInputInt($this->get_field_name('thumb_w'), $instance['thumb_w'], 1, null);        

        $out .= '<span class="dc-cms-control-top-label-s-margin">Thumb height</span>'; 
        $out .= $tools->getCtrlInputInt($this->get_field_name('thumb_h'), $instance['thumb_h'], 1, null);      
        
        $out .= '<span class="dc-cms-control-top-label-s-margin">Other settings</span>';
        $out .= '<input name="'.$this->get_field_name('grayscale').'" type="checkbox" '.($instance['grayscale'] ? ' checked="checked" ' : '').'/> Display in grayscale';   
        
        echo $out;
        
        $out = '<script type="text/javascript">';
            $out .= 'if(jQuery().dcf_setupIntCtrl)';
            $out .= '{';
                $out .= 'jQuery(\'body\').dcf_setupIntCtrl();';
            $out .= '}';
        $out .= '</script>';   
        
        echo $out;        
    }
}

// Register widget
function dcwp_ngg_recentInit() { register_widget('dcwp_ngg_recent'); }
add_action('widgets_init', 'dcwp_ngg_recentInit');
  
}   



/*
 * Plugin Name: Archives
 * Version: 1.0
 * Plugin URI: http://themeforest.net/user/DigitalCavalry
 * Description: A monthly archive of your site posts
 * Author: Digital Cavalry
 * Author URI: http://themeforest.net/user/DigitalCavalry
 */

if(CMS_DC_REGISTER_WIDGET_ARCHIVES)
{  
 
class dcwp_archives extends WP_Widget 
{   
    function __construct() 
    {        
        $args = array(
            'classname' => 'dcwp_archives', 
            'description' => __('A monthly archive of your site posts', CMS_TXT_DOMAIN).' ('.CMS_THEME_NAME.' theme)' // description displayed in WP widgets area
        );

        parent::__construct(
            'dcwp_archives_id',   // WP ID should be unique 
            'DC Archives', // name displayed in WP widgets area
            $args);
    }         

   function widget($args, $instance) 
   {       
        echo $args['before_widget'];
        if(trim($instance['title']) != '') { echo $args['before_title'].$instance['title'].$args['after_title']; }                
           
        $archive_args = array('type' => 'monthly', 'show_post_count' => $instance['count_show'], 'echo' => 0);
        if($instance['limit'] > 0) { $archive_args['limit'] = $limit; } 

        $out = '';
        $out .= '<ul class="dc-widget-archives">';
        $out .= wp_get_archives(apply_filters('widget_archives_args', $archive_args));
        $out .= '</ul>';
        echo $out;

        echo $args['after_widget'];
  
   }

   function update($new_instance, $old_instance) 
   {
        $instance = array();        
        $instance['title'] = $new_instance['title'];
        $instance['limit'] = $new_instance['limit'];
        $instance['count_show'] = isset($new_instance['count_show']);     

        return $instance;    
   }

   function form($instance) 
   {
        $def = array('title' => '', 'count_show' => false, 'limit' => 0);
        $instance = dcf_combineArgs($def, $instance);       
        $tools = new DCC_BasicTools();
  
        $out = '';
        $out .= '<span class="dc-cms-control-top-label-nomargin">Widget title</span>'; 
        $out .= '<input id="'.$this->get_field_id('title').'" class="dc-cms-control-wide" name="'.$this->get_field_name('title').'" type="text" value="'.$instance['title'].'" />';        
  
        $out .= '<span class="dc-cms-control-top-label-s-margin">Number of archives to get</span>'; 
        $out .= $tools->getCtrlInputInt($this->get_field_name('limit'), $instance['limit'], 0, null);  
        $out .= '<div class="dc-cms-help-note-box-small">';
            $out .= 'If set to zero, there will be no limit';
        $out .= '</div>';                
        
        $out .= '<span class="dc-cms-control-top-label-s-margin">Other settings</span>';
        $out .= '<input name="'.$this->get_field_name('count_show').'" type="checkbox" '.($instance['count_show'] ? ' checked="checked" ' : '').'/> Show post counts';
        
        echo $out;
        
        $out = '<script type="text/javascript">';
            $out .= 'if(jQuery().dcf_setupIntCtrl)';
            $out .= '{';
                $out .= 'jQuery(\'body\').dcf_setupIntCtrl();';
            $out .= '}';
        $out .= '</script>';   
        
        echo $out;            
   }
}

// Register widget
function dcwp_archivesInit() { register_widget('dcwp_archives'); }
add_action('widgets_init', 'dcwp_archivesInit');

}


/*
 * Plugin Name: Categories
 * Version: 1.0
 * Plugin URI: http://themeforest.net/user/DigitalCavalry
 * Description: Categories
 * Author: Digital Cavalry
 * Author URI: http://themeforest.net/user/DigitalCavalry
 */

if(CMS_DC_REGISTER_WIDGET_CATEGORIES)
{ 
 
 class dcwp_categories extends WP_Widget 
 {  
    function __construct() 
    {        
        $args = array(
            'classname' => 'dcwp_categories', 
            'description' => __('A list of categories', CMS_TXT_DOMAIN).' ('.CMS_THEME_NAME.' theme)' // description displayed in WP widgets area
        );

        parent::__construct(
            'dcwp_categories_id',   // WP ID should be unique 
            'DC Categories', // name displayed in WP widgets area
            $args);
    }        

    function widget($args, $instance) 
    {
        echo $args['before_widget'];
        if(trim($instance['title']) != '') { echo $args['before_title'].$instance['title'].$args['after_title']; }     

        $categories_args = array(
            'orderby' => 'name', 
            'show_count' => $instance['count_show'], 
            'hierarchical' => $instance['hierarchical'],
            'title_li' => '',
            'echo' => false
        );

        $out = '';
        $out .= '<ul class="dc-widget-categories">';  
            $out .= wp_list_categories(apply_filters('widget_categories_args', $categories_args));  
        $out .= '</ul>';
        echo $out;

        echo $args['after_widget']; 
    }

    function update($new_instance, $old_instance) 
    {
        $instance = array();        
        $instance['title'] = $new_instance['title'];
        $instance['hierarchical'] = isset($new_instance['hierarchical']); 
        $instance['count_show'] = isset($new_instance['count_show']);     

        return $instance;                          
    }
   
    function form($instance) 
    {
        $def = array('title' => '', 'count_show' => false, 'hierarchical' => false);
        $instance = dcf_combineArgs($def, $instance);                

        $out = '';

        $out = '';
        $out .= '<span class="dc-cms-control-top-label-nomargin">Widget title</span>'; 
        $out .= '<input id="'.$this->get_field_id('title').'" class="dc-cms-control-wide" name="'.$this->get_field_name('title').'" type="text" value="'.$instance['title'].'" />';              

        $out .= '<span class="dc-cms-control-top-label-s-margin">Other settings</span>';
        $out .= '<input name="'.$this->get_field_name('count_show').'" type="checkbox" '.($instance['count_show'] ? ' checked="checked" ' : '').'/> Show post counts';
        $out .= '<br />';        
        $out .= '<input name="'.$this->get_field_name('hierarchical').'" type="checkbox" '.($instance['hierarchical'] ? ' checked="checked" ' : '').'/> Show hierarchy'; 

        echo $out;
    }
   
   }

// Register widget
function dcwp_categoriesInit() { register_widget('dcwp_categories'); }
add_action('widgets_init', 'dcwp_categoriesInit');  
  
}


/*
 * Plugin Name: Pages
 * Version: 1.0
 * Plugin URI: http://themeforest.net/user/DigitalCavalry
 * Description: Pages
 * Author: Digital Cavalry
 * Author URI: http://themeforest.net/user/DigitalCavalry
 */

if(CMS_DC_REGISTER_WIDGET_PAGES)
{
   
class dcwp_pages extends WP_Widget 
{   
    function __construct() 
    {        
        $args = array(
            'classname' => 'dcwp_pages', 
            'description' => __('Your site WordPress Pages', CMS_TXT_DOMAIN).' ('.CMS_THEME_NAME.' theme)' // description displayed in WP widgets area
        );

        parent::__construct(
            'dcwp_pages_id',   // WP ID should be unique 
            'DC Pages', // name displayed in WP widgets area
            $args);
    }        

    function widget($args, $instance)
    {           
        echo $args['before_widget'];
        if(trim($instance['title']) != '') { echo $args['before_title'].$instance['title'].$args['after_title']; }              
        
        $out = '';
        $out .= '<ul class="dc-widget-pages">';
        
            if($instance['list'] != '')
            {
                $list = $instance['list'];
                $exclude = ($instance['exclude'] != '') ? ' AND ID NOT IN ('.$instance['exclude'].') ' : '';  

                global $wpdb; 
                $data = $wpdb->get_results("SELECT ID, post_title FROM $wpdb->posts WHERE ID IN($list) $exclude AND post_status = 'publish' AND post_type = 'page' ORDER BY FIELD(ID, $list) "); 
                
                if(is_array($data))
                {
                    foreach($data as $p)
                    {
                        $out .= '<li class="page_item"><a href="'.get_permalink($p->ID).'">'.$p->post_title.'</a></li>';
                    }
                }                                          
            } else
            {
                $pages_args = array(
                    'title_li' => '', 
                    'echo' => false, 
                    'sort_column' => $instance['sort_column'], 
                    'exclude' => $instance['exclude'], 
                    'depth' => 0
                );  
                $out .= wp_list_pages($pages_args);              
            }        
                      
        $out .= '</ul>';
        echo $out;
        
        echo $args['after_widget'];  
    }

    function update($new_instance, $old_instance) 
    {
        $instance = array(); 
        $instance['title'] = $new_instance['title'];
        $instance['list'] = $new_instance['list']; 
        $instance['sort_column'] = $new_instance['sort_column'];
        $instance['exclude'] = $new_instance['exclude'];

        return $instance;
    }

    function form($instance) 
    {        
        $def = array(
            'title' => '', 
            'list' => '',            
            'sort_column' => 'post_title', 
            'exclude' => ''            
            );
        $instance = dcf_combineArgs($def, $instance);                

        $out = '';
        $out .= '<span class="dc-cms-control-top-label-nomargin">Widget title</span>'; 
        $out .= '<input id="'.$this->get_field_id('title').'" class="dc-cms-control-wide" name="'.$this->get_field_name('title').'" type="text" value="'.$instance['title'].'" />';           

        $out .= '<span class="dc-cms-control-top-label-s-margin">Comma separated pages ID list</span>'; 
        $out .= '<input class="dc-cms-control-wide" name="'.$this->get_field_name('list').'" type="text" value="'.$instance['list'].'" />';           
        $out .= '<div class="dc-cms-help-note-box-small">';
            $out .= 'If set, sort settings will be ignored';
        $out .= '</div>';  
    
        $out .= '<span class="dc-cms-control-top-label-s-margin">Sort pages by</span>'; 
        $out .= '<select name="'.$this->get_field_name('sort_column').'" class="dc-cms-control-wide">';
            $out .= '<option value="post_title" '.($instance['sort_column'] == 'post_title' ? ' selected="selected" ' : '').'>Page title</option>';
            $out .= '<option value="menu_order" '.($instance['sort_column'] == 'menu_order' ? ' selected="selected" ' : '').'>Page order</option>';
            $out .= '<option value="ID"         '.($instance['sort_column'] == 'ID'         ? ' selected="selected" ' : '').'>Page ID</option>';
        $out .= '</select>';

        $out .= '<span class="dc-cms-control-top-label-s-margin">Excluded pages</span>';
        $out .= '<input type="text" value="'.$instance['exclude'].'" name="'.$this->get_field_name('exclude').'" class="dc-cms-control-wide" />';
        $out .= '<div class="dc-cms-help-note-box-small">';
            $out .= 'Comma separated pages ID';
        $out .= '</div>';            
      
        echo $out;
 }

}

// Register widget
function dcwp_pagesInit() { register_widget('dcwp_pages'); }
add_action('widgets_init', 'dcwp_pagesInit');

}  
  
  
/*
 * Plugin Name: Members
 * Version: 1.0
 * Plugin URI: http://themeforest.net/user/DigitalCavalry
 * Description: Members list
 * Author: Digital Cavalry
 * Author URI: http://themeforest.net/user/DigitalCavalry
 */

if(CMS_DC_REGISTER_WIDGET_MEMBERS)
{  
 
class dcwp_members extends WP_Widget 
{   
    function __construct() 
    {        
        $args = array(
            'classname' => 'dcwp_members', 
            'description' => __('Members list', CMS_TXT_DOMAIN).' ('.CMS_THEME_NAME.' theme)' // description displayed in WP widgets area
        );

        parent::__construct(
            'dcwp_members_id',   // WP ID should be unique 
            'DC Members', // name displayed in WP widgets area
            $args);
    }         

   function widget($args, $instance) 
   {       
        echo $args['before_widget'];  
        if(trim($instance['title']) != '') { echo $args['before_title'].$instance['title'].$args['after_title']; }                        

        $m_args = array(
            'per_page' => $instance['per_page'],
            'cats' => $instance['cats'],
            'words' => $instance['words'],
            'list' => $instance['list'],
            'columns' => 1,           
            'order' => $instance['order'], 
            'orderby' => $instance['orderby'], 
            'viewport_use' => false,
            'viewport_w' => 0,
            'viewport_h' => 0,
            'link_to_single' => $instance['link_to_single'],
            'grayscale' => $instance['grayscale'],
            'image_width' => 50,
            'meta_title' => $instance['meta_title'],
            'meta_subtitle' => $instance['meta_subtitle'],
            'meta_addinfo' => $instance['meta_addinfo'],
            'addinfo_words' => $instance['addinfo_words'],
            'item_bottom' => 25,
            'item_bottom_use' => false                
        );           
        
        $out = '';
        $out .= '<div class="dc-widget-members">';
            $out .= GetDCCPI()->getIRenderer()->wgtMembers($m_args);  
        $out .= '</div>';
        echo $out;

        echo $args['after_widget'];
  
   }

   function update($new_instance, $old_instance) 
   {
        $instance = array();        
        $instance['title'] = $new_instance['title'];
        $instance['cats'] =  $new_instance['cats'];   
        $instance['per_page'] = $new_instance['per_page'];
        $instance['words'] = $new_instance['words'];     
        $instance['list'] = $new_instance['list'];
        $instance['order'] = $new_instance['order']; 
        $instance['orderby'] = $new_instance['orderby']; 
        $instance['link_to_single'] = isset($new_instance['link_to_single']);  
        $instance['grayscale'] = isset($new_instance['grayscale']); 
        $instance['meta_title'] = isset($new_instance['meta_title']); 
        $instance['meta_subtitle'] = isset($new_instance['meta_subtitle']); 
        $instance['meta_addinfo'] = isset($new_instance['meta_addinfo']); 
        $instance['addinfo_words'] = $new_instance['addinfo_words']; 
         
        return $instance;    
   }

   function form($instance) 
   {          
        $def = array(
            'title' => '', 
            'cats' => array(), 
            'per_page' => 4, 
            'words' => 24, 
            'list' => '', 
            'order' => 'DESC', 
            'orderby' => 'date',
            'link_to_single' => false,
            'grayscale' => false,
            'meta_title' => false,
            'meta_subtitle' => false,
            'meta_addinfo' => false,
            'addinfo_words' => 24
            );
            
        $instance = dcf_combineArgs($def, $instance);       
        $tools = new DCC_BasicTools();
  
        $out = '';
        $out .= '<span class="dc-cms-control-top-label-nomargin">Widget title</span>'; 
        $out .= '<input id="'.$this->get_field_id('title').'" class="dc-cms-control-wide" name="'.$this->get_field_name('title').'" type="text" value="'.$instance['title'].'" />';        

        $categories = get_terms(DCC_ControlPanelCustomPosts::PT_MEMBER_CATEGORY, array('orderby' => 'name', 'hide_empty' => false)); 
        
        if(!is_array($instance['cats'])) { $instance['cats'] = array(); }
        $out .= '<span class="dc-cms-control-top-label">Member categories to display</span>';                      
        $out .= $tools->getStdScrollBoxStart(array('height' => 100));
            foreach($categories as $cat)
            {
                $checked = false;
                if(in_array($cat->term_id, $instance['cats'])) { $checked = true; }
                $out .= '<input type="checkbox" value="'.$cat->term_id.'" name="'.$this->get_field_name('cats').'[]" '.($checked ? ' checked="checked" ' : '').'> '.$cat->name . ' <span class="term-count">('.$cat->count.')</span><br />';
            }
        $out .= $tools->getStdScrollBoxEnd();                
          
        $out .= '<span class="dc-cms-control-top-label-s-margin">Number of members to display</span>'; 
        $out .= $tools->getCtrlInputInt($this->get_field_name('per_page'), $instance['per_page'], 1, null);  
           
        $out .= '<span class="dc-cms-control-top-label-s-margin">Number of words from post excerpt</span>'; 
        $out .= $tools->getCtrlInputInt($this->get_field_name('words'), $instance['words'], 0, null);  
        $out .= '<div class="dc-cms-help-note-box-small">';
            $out .= 'If set to zero, the excerpt will be not displayed';
        $out .= '</div>';  
        
        $out .= '<span class="dc-cms-control-top-label-s-margin">Number of words from post meta additional information text</span>'; 
        $out .= $tools->getCtrlInputInt($this->get_field_name('addinfo_words'), $instance['addinfo_words'], 0, null);  
        $out .= '<div class="dc-cms-help-note-box-small">';
            $out .= 'If set to zero, the text will be not displayed';
        $out .= '</div>';                 
        
        $out .= '<span class="dc-cms-control-top-label-s-margin">Comma seprated members ID list</span>'; 
        $out .= '<input class="dc-cms-control-wide" name="'.$this->get_field_name('list').'" type="text" value="'.$instance['list'].'" />';           
           
        $out .= '<span class="dc-cms-control-top-label-s-margin">Members order</span>';
        $out .= '<select name="'.$this->get_field_name('order').'" class="dc-cms-control-wide">';      
            $out .= '<option value="DESC" '.($instance['order'] == 'DESC' ? ' selected="selected"' : '' ).'>Descending</option>';            
            $out .= '<option value="ASC"  '.($instance['order'] == 'ASC'  ? ' selected="selected"' : '' ).'>Ascending</option>';
        $out .= '</select>';

        $out .= '<span class="dc-cms-control-top-label-s-margin">Sort displayed members by parameter</span>';   
        $out .= '<select name="'.$this->get_field_name('orderby').'" class="dc-cms-control-wide">'; 
            $out .= '<option value="date"          '.($instance['orderby'] == 'date'           ? ' selected="selected"' : '' ).'>Order by date</option>';            
            $out .= '<option value="title"         '.($instance['orderby'] == 'title'          ? ' selected="selected"' : '' ).'>Order by title</option>';
            $out .= '<option value="comment_count" '.($instance['orderby'] == 'comment_count'  ? ' selected="selected"' : '' ).'>Comments count</option>';                   
        $out .= '</select>';            
                   
        $out .= '<span class="dc-cms-control-top-label-s-margin">Other settings</span>';
        $out .= '<input name="'.$this->get_field_name('link_to_single').'" type="checkbox" '.($instance['link_to_single'] ? ' checked="checked" ' : '').'/> Link items to single page';
        $out .= '<br />';
        $out .= '<input name="'.$this->get_field_name('grayscale').'" type="checkbox" '.($instance['grayscale'] ? ' checked="checked" ' : '').'/> Display images in grayscale';
        $out .= '<br />';
        $out .= '<input name="'.$this->get_field_name('meta_title').'" type="checkbox" '.($instance['meta_title'] ? ' checked="checked" ' : '').'/> Display post meta title';
        $out .= '<br />';
        $out .= '<input name="'.$this->get_field_name('meta_subtitle').'" type="checkbox" '.($instance['meta_subtitle'] ? ' checked="checked" ' : '').'/> Display post meta subtitle';
        $out .= '<br />';
        $out .= '<input name="'.$this->get_field_name('meta_addinfo').'" type="checkbox" '.($instance['meta_addinfo'] ? ' checked="checked" ' : '').'/> Display post meta additional information';                
        echo $out;   
        
        $out = '<script type="text/javascript">';
            $out .= 'if(jQuery().dcf_setupIntCtrl)';
            $out .= '{';
                $out .= 'jQuery(\'body\').dcf_setupIntCtrl();';
            $out .= '}';
        $out .= '</script>';   
     
        echo $out;            
   }
}

// Register widget
function dcwp_membersInit() { register_widget('dcwp_members'); }
add_action('widgets_init', 'dcwp_membersInit');

}  
  
  

/*
 * Plugin Name: Heading
 * Version: 1.0
 * Plugin URI: http://themeforest.net/user/DigitalCavalry
 * Description: Heading
 * Author: Digital Cavalry
 * Author URI: http://themeforest.net/user/DigitalCavalry
 */

if(CMS_DC_REGISTER_WIDGET_HEADING)
{
   
class dcwp_heading extends WP_Widget 
{   
    function __construct() 
    {        
        $args = array(
            'classname' => 'dcwp_heading', 
            'description' => __('Configurable heading', CMS_TXT_DOMAIN).' ('.CMS_THEME_NAME.' theme)' // description displayed in WP widgets area
        );

        parent::__construct(
            'dcwp_heading_id',   // WP ID should be unique 
            'DC Heading', // name displayed in WP widgets area
            $args);
    }        

    function widget($args, $instance)
    {           
        // echo $args['before_widget'];
        echo GetDCCPI()->getIGeneral()->getBeforeWidget(array('pb' => $instance['pb'], 'pb_use' => true));
        if(trim($instance['title']) != '') { echo $args['before_title'].$instance['title'].$args['after_title']; }      
        
        $out = '';
        $out .= '<div class="dc-widget-heading">';
             
             $style = '';
             if($instance['color_use']) { $style .= 'color:'.$instance['color'].';'; }
             $style .= 'text-align:'.$instance['align'].';';
             if($style != '') { $style = ' style="'.$style.'" '; }
             
             
             $out .= '<h'.$instance['size'].' '.$style.'>';
                $out .= $instance['heading'];
                if($instance['subtitle_use']) 
                { 
                     $style = '';
                     if($instance['subtitle_color_use']) { $style .= 'color:'.$instance['subtitle_color'].';'; }
                     if($style != '') { $style = ' style="'.$style.'" '; }                    
                    $out .= '<span '.$style.'>'.$instance['subtitle'].'</span>'; 
                }
             $out .= '</h'.$instance['size'].'>';
             if($instance['text_use'])
             {
                 $out .= '<div class="plain-text">';
                    $out .= wpautop($instance['text']);
                 $out .= '</div>'; 
             }
        
        $out .= '</div>';
        echo $out;  
        
        echo $args['after_widget'];  
    }

    function update($new_instance, $old_instance) 
    {
        $instance = array(); 
        $instance['title'] = $new_instance['title'];        
        $instance['heading'] = $new_instance['heading'];
        $instance['subtitle'] = $new_instance['subtitle']; 
        $instance['subtitle_use'] = isset($new_instance['subtitle_use']);
        $instance['text'] = $new_instance['text'];
        $instance['text_use'] = isset($new_instance['text_use']);  
        $instance['size'] = $new_instance['size'];
        $instance['color'] = $new_instance['color']; 
        $instance['color_use'] = isset($new_instance['color_use']);
        $instance['subtitle_color'] = $new_instance['subtitle_color']; 
        $instance['subtitle_color_use'] = isset($new_instance['subtitle_color_use']);
        $instance['pb'] = $new_instance['pb'];  
        $instance['align'] = $new_instance['align']; 
        
        return $instance;
    }

    function form($instance) 
    {        
        $def = array(
            'title' => '', 
            'heading' => '',
            'subtitle' => '',
            'subtitle_use' => false, 
            'text' => '',
            'text_use' => false,
            'size' => 4, 
            'color' => '#444444', 
            'color_use' => false,
            'subtitle_color' => '#AAAAAA',
            'subtitle_color_use' => false,
            'pb' => 40,
            'align' => 'left'
            );
        $instance = dcf_combineArgs($def, $instance);
        $tools = new DCC_BasicTools();                 

        $out = '';
        $out .= '<span class="dc-cms-control-top-label-nomargin">Widget title</span>'; 
        $out .= '<input id="'.$this->get_field_id('title').'" class="dc-cms-control-wide" name="'.$this->get_field_name('title').'" type="text" value="'.$instance['title'].'" />';           
    
        $out .= '<span class="dc-cms-control-top-label-s-margin">Heading text</span>'; 
        $out .= '<textarea class="dc-cms-control-wide dc-cms-control-textarea dc-cms-control-h-80" name="'.$this->get_field_name('heading').'">';
            $out .= $instance['heading'];
        $out .= '</textarea>';

        $out .= '<span class="dc-cms-control-top-label-s-margin">Subtitle text</span>'; 
        $out .= '<textarea class="dc-cms-control-wide dc-cms-control-textarea dc-cms-control-h-60" name="'.$this->get_field_name('subtitle').'">';
            $out .= $instance['subtitle'];
        $out .= '</textarea>';        

        $out .= '<span class="dc-cms-control-top-label-s-margin">Plain text</span>'; 
        $out .= '<textarea class="dc-cms-control-wide dc-cms-control-textarea dc-cms-control-h-100" name="'.$this->get_field_name('text').'">';
            $out .= $instance['text'];
        $out .= '</textarea>';    
        
        $out .= '<span class="dc-cms-control-top-label-s-margin">Heading size</span>';  
        $out .= '<select name="'.$this->get_field_name('size').'" class="dc-cms-control-wide">';      
            $out .= '<option value="1" '.($instance['size'] == 1 ? ' selected="selected"' : '' ).'>H1</option>';            
            $out .= '<option value="2" '.($instance['size'] == 2 ? ' selected="selected"' : '' ).'>H2</option>';
            $out .= '<option value="3" '.($instance['size'] == 3 ? ' selected="selected"' : '' ).'>H3</option>';
            $out .= '<option value="4" '.($instance['size'] == 4 ? ' selected="selected"' : '' ).'>H4</option>';
            $out .= '<option value="5" '.($instance['size'] == 5 ? ' selected="selected"' : '' ).'>H5</option>';
            $out .= '<option value="6" '.($instance['size'] == 6 ? ' selected="selected"' : '' ).'>H6</option>';
        $out .= '</select>';        

        $out .= '<span class="dc-cms-control-top-label-s-margin">Heading text align</span>';  
        $out .= '<select name="'.$this->get_field_name('align').'" class="dc-cms-control-wide">';      
            $out .= '<option value="left" '.($instance['align'] == 'left' ? ' selected="selected"' : '' ).'>Left</option>';            
            $out .= '<option value="center" '.($instance['align'] == 'center' ? ' selected="selected"' : '' ).'>Center</option>';
            $out .= '<option value="right" '.($instance['align'] == 'right' ? ' selected="selected"' : '' ).'>Right</option>';
        $out .= '</select>';  
        
        $out .= '<span class="dc-cms-control-top-label-s-margin">Heading color</span>';  
        $out .= '<input type="text" class="dc-color-picker" value="'.$instance['color'].'" name="'.$this->get_field_name('color').'" /> ';  

        $out .= '<span class="dc-cms-control-top-label-s-margin">Subtitle color</span>';  
        $out .= '<input type="text" class="dc-color-picker" value="'.$instance['subtitle_color'].'" name="'.$this->get_field_name('subtitle_color').'" /> ';  
        
        $out .= '<span class="dc-cms-control-top-label-s-margin">Widget padding bottom</span>'; 
        $out .= $tools->getCtrlInputInt($this->get_field_name('pb'), $instance['pb'], 0, null); 
        $out .= '<div class="dc-cms-help-note-box-small">';
            $out .= 'In default every widget have some bottom padding, you can\'t change it, but this is special widget and you can adjust the bottom empty space.';
        $out .= '</div>';                  
        
        $out .= '<span class="dc-cms-control-top-label-s-margin">Other settings</span>';
        $out .= '<input name="'.$this->get_field_name('subtitle_use').'" type="checkbox" '.($instance['subtitle_use'] ? ' checked="checked" ' : '').'/> Display subtitle';
        $out .= '<br />';
        $out .= '<input name="'.$this->get_field_name('text_use').'" type="checkbox" '.($instance['text_use'] ? ' checked="checked" ' : '').'/> Display plain text';
        $out .= '<br />';
        $out .= '<input name="'.$this->get_field_name('color_use').'" type="checkbox" '.($instance['color_use'] ? ' checked="checked" ' : '').'/> Use heading color';
        $out .= '<br />';
        $out .= '<input name="'.$this->get_field_name('subtitle_color_use').'" type="checkbox" '.($instance['subtitle_color_use'] ? ' checked="checked" ' : '').'/> Use subtitle color';
        
        echo $out;                        
        
        $out = '<script type="text/javascript">';
            
            $out .= 'if(jQuery().dcf_setupIntCtrl)';
            $out .= '{';
                $out .= 'jQuery(\'body\').dcf_setupIntCtrl(); ';
            $out .= '}';
            
            $out .= 'if(jQuery().dcf_setupColorPicker)';
            $out .= '{';
                $out .= 'jQuery(\'body\').dcf_setupColorPicker(); ';
            $out .= '}'; 
                       
        $out .= '</script>';   
     
        echo $out;              
    }

}                    

// Register widget
function dcwp_headingInit() { register_widget('dcwp_heading'); }
add_action('widgets_init', 'dcwp_headingInit');

}  
  
  
/*
 * Plugin Name: Post Box
 * Version: 1.0
 * Plugin URI: http://themeforest.net/user/DigitalCavalry
 * Description: Post Box
 * Author: Digital Cavalry
 * Author URI: http://themeforest.net/user/DigitalCavalry
 */

if(CMS_DC_REGISTER_WIDGET_POSTBOX)
{
   
class dcwp_postbox extends WP_Widget 
{   
    function __construct() 
    {        
        $args = array(
            'classname' => 'dcwp_postbox', 
            'description' => __('Featured post', CMS_TXT_DOMAIN).' ('.CMS_THEME_NAME.' theme)' // description displayed in WP widgets area
        );

        parent::__construct(
            'dcwp_postbox_id',   // WP ID should be unique 
            'DC Post Box', // name displayed in WP widgets area
            $args);
    }        

    function widget($args, $instance)
    {           
        echo $args['before_widget'];
        if(trim($instance['title']) != '') { echo $args['before_title'].$instance['title'].$args['after_title']; }      
             
        $out = '';
        $out .= '<div class="dc-widget-postbox">';
         
            $id_list = explode(',', $instance['id_list']);        
            
            if(is_array($id_list))
            {
                $counter = 0;
                foreach($id_list as $id)
                {
                    if(trim($id) != '')
                    {
                        $top = $counter ? 20 : 0;
                        $f_args = array(
                          'id' => $id,
                          'size' => '1-1',
                          'ctype' => 'none', 
                          'desc' => '',
                          'words' => $instance['words'],
                          'float' => 'none',
                          'top' => $top,
                          'right' => 0,
                          'bottom' => 0,
                          'left' => 0,
                          'url' => '',
                          'border' => $instance['border']
                        );
                        
                        $out .= GetDCCPI()->getIShortcodes()->render_dcs_postbox($f_args);
                        $counter++;
                    }
                }
            }             
               
        $out .= '</div>';
        echo $out;
        
        echo $args['after_widget'];  
    }

    function update($new_instance, $old_instance) 
    {
        $instance = array(); 
        $instance['title'] = $new_instance['title'];
        $instance['id_list'] = $new_instance['id_list'];
        $instance['words'] = $new_instance['words'];
        $instance['border'] = isset($new_instance['border']);
        
        return $instance;
    }

    function form($instance) 
    {        
        $def = array('title' => '', 'id_list' => '', 'words' => 16);
        $instance = dcf_combineArgs($def, $instance);
        $tools = new DCC_BasicTools();                 

        $out = '';
        $out .= '<span class="dc-cms-control-top-label-nomargin">Widget title</span>'; 
        $out .= '<input id="'.$this->get_field_id('title').'" class="dc-cms-control-wide" name="'.$this->get_field_name('title').'" type="text" value="'.$instance['title'].'" />';           
    
        $out .= '<span class="dc-cms-control-top-label-s-margin">Comma separated featured posts ID</span>';
        $out .= '<input type="text" value="'.$instance['id_list'].'" name="'.$this->get_field_name('id_list').'" class="dc-cms-control-wide" />';          
    
        $out .= '<span class="dc-cms-control-top-label-s-margin">Number of words displayed in excerpt</span>'; 
        $out .= $tools->getCtrlInputInt($this->get_field_name('words'), $instance['words'], 0, null); 
        $out .= '<div class="dc-cms-help-note-box-small">';
            $out .= 'If the post excerpt is not available, widget will be try to display text form post content.';
        $out .= '</div>';       
      
        $out .= '<span class="dc-cms-control-top-label-s-margin">Other settings</span>';
        $out .= '<input name="'.$this->get_field_name('border').'" type="checkbox" '.($instance['border'] ? ' checked="checked" ' : '').'/> Display border';
        $out .= '<br />';      
      
        echo $out;
        
        $out = '<script type="text/javascript">';
            
            $out .= 'if(jQuery().dcf_setupIntCtrl)';
            $out .= '{';
                $out .= 'jQuery(\'body\').dcf_setupIntCtrl(); ';
            $out .= '}';            
                       
        $out .= '</script>';   
     
        echo $out;         
 }

}

// Register widget
function dcwp_postboxInit() { register_widget('dcwp_postbox'); }
add_action('widgets_init', 'dcwp_postboxInit');

}  
  
  

/*
 * Plugin Name: Page Box
 * Version: 1.0
 * Plugin URI: http://themeforest.net/user/DigitalCavalry
 * Description: Page Box
 * Author: Digital Cavalry
 * Author URI: http://themeforest.net/user/DigitalCavalry
 */

if(CMS_DC_REGISTER_WIDGET_PAGEBOX)
{
   
class dcwp_pagebox extends WP_Widget 
{   
    function __construct() 
    {        
        $args = array(
            'classname' => 'dcwp_pagebox', 
            'description' => __('Featured page', CMS_TXT_DOMAIN).' ('.CMS_THEME_NAME.' theme)' // description displayed in WP widgets area
        );

        parent::__construct(
            'dcwp_pagebox_id',   // WP ID should be unique 
            'DC Page Box', // name displayed in WP widgets area
            $args);
    }        

    function widget($args, $instance)
    {           
        echo $args['before_widget'];
        if(trim($instance['title']) != '') { echo $args['before_title'].$instance['title'].$args['after_title']; }      
             
        $out = '';
        $out .= '<div class="dc-widget-pagebox">';
         
            $id_list = explode(',', $instance['id_list']);        
            
            if(is_array($id_list))
            {
                $counter = 0;
                foreach($id_list as $id)
                {
                    if(trim($id) != '')
                    {
                        $top = $counter ? 20 : 0;
                        $f_args = array(
                          'id' => $id,
                          'size' => '1-1',
                          'ctype' => 'none', 
                          'desc' => '',
                          'words' => $instance['words'],
                          'float' => 'none',
                          'top' => $top,
                          'right' => 0,
                          'bottom' => 0,
                          'left' => 0,
                          'url' => '',
                          'border' => $instance['border']
                        );
                        
                        $out .= GetDCCPI()->getIShortcodes()->render_dcs_pagebox($f_args);
                        $counter++;
                    }
                }
            }             
               
        $out .= '</div>';
        echo $out;
        
        echo $args['after_widget'];  
    }

    function update($new_instance, $old_instance) 
    {
        $instance = array(); 
        $instance['title'] = $new_instance['title'];
        $instance['id_list'] = $new_instance['id_list'];
        $instance['words'] = $new_instance['words'];
        $instance['border'] = isset($new_instance['border']);
        
        return $instance;
    }

    function form($instance) 
    {        
        $def = array('title' => '', 'id_list' => '', 'words' => 16, 'border' => false);
        $instance = dcf_combineArgs($def, $instance);
        $tools = new DCC_BasicTools();                 

        $out = '';
        $out .= '<span class="dc-cms-control-top-label-nomargin">Widget title</span>'; 
        $out .= '<input id="'.$this->get_field_id('title').'" class="dc-cms-control-wide" name="'.$this->get_field_name('title').'" type="text" value="'.$instance['title'].'" />';           
    
        $out .= '<span class="dc-cms-control-top-label-s-margin">Comma separated featured pages ID</span>';
        $out .= '<input type="text" value="'.$instance['id_list'].'" name="'.$this->get_field_name('id_list').'" class="dc-cms-control-wide" />';          
    
        $out .= '<span class="dc-cms-control-top-label-s-margin">Number of words displayed in excerpt</span>'; 
        $out .= $tools->getCtrlInputInt($this->get_field_name('words'), $instance['words'], 0, null); 
        $out .= '<div class="dc-cms-help-note-box-small">';
            $out .= 'If the page excerpt is not available, widget will be try to display text form page content.';
        $out .= '</div>';       
      
        $out .= '<span class="dc-cms-control-top-label-s-margin">Other settings</span>';
        $out .= '<input name="'.$this->get_field_name('border').'" type="checkbox" '.($instance['border'] ? ' checked="checked" ' : '').'/> Display border';
        $out .= '<br />';      
      
        echo $out;
        
        $out = '<script type="text/javascript">';
            
            $out .= 'if(jQuery().dcf_setupIntCtrl)';
            $out .= '{';
                $out .= 'jQuery(\'body\').dcf_setupIntCtrl(); ';
            $out .= '}';            
                       
        $out .= '</script>';   
     
        echo $out;         
 }

}

// Register widget
function dcwp_pageboxInit() { register_widget('dcwp_pagebox'); }
add_action('widgets_init', 'dcwp_pageboxInit');

}  
  
  
/*
 * Plugin Name: DC Widget Image
 * Version: 1.0
 * Plugin URI: http://themeforest.net/user/DigitalCavalry
 * Description: DC Widget Image
 * Author: Digital Cavalry
 * Author URI: http://themeforest.net/user/DigitalCavalry
 */

if(CMS_DC_REGISTER_WIDGET_IMAGE)
{
   
class dcwp_image extends WP_Widget 
{   
    function __construct() 
    {        
        $args = array(
            'classname' => 'dcwp_image', 
            'description' => __('Single image', CMS_TXT_DOMAIN).' ('.CMS_THEME_NAME.' theme)' // description displayed in WP widgets area
        );

        parent::__construct(
            'dcwp_image_id',   // WP ID should be unique 
            'DC Image', // name displayed in WP widgets area
            $args);
    }        

    function widget($args, $instance)
    {           
        // echo $args['before_widget'];
        echo GetDCCPI()->getIGeneral()->getBeforeWidget(array('pb' => $instance['pb'], 'pb_use' => true));  
        if(trim($instance['title']) != '') { echo $args['before_title'].$instance['title'].$args['after_title']; }      
             
        $out = '';
        $out .= '<div class="dc-widget-image">';
            
            if($instance['link_use']) 
            { 
                $target = $instance['new_tab'] ? ' target="_blank" ' : ' target="_self" ';
                $out .= '<a href="'.$instance['link'].'" '.$target.'>'; 
            }                  
            
            $filter = CMS_IMAGE_FILTER_NONE;
            if($instance['grayscale']) { $filter = CMS_IMAGE_FILTER_GRAYSCALE; }
            $out .= '<img src="'.dcf_getImageURL($instance['url'], null, null, CMS_IMAGE_NOCROP, $filter, true).'" alt="'.$instance['alt'].'" />';   
            
            if($instance['link_use']) { $out .= '</a>'; }
            
            if($instance['desc_use'] and $instance['desc'] != '')
            {
                $out .= '<div class="img-description">'.wpautop($instance['desc']).'</div>';
            }    
        $out .= '</div>';
        echo $out;
        
        echo $args['after_widget'];  
    }

    function update($new_instance, $old_instance) 
    {
        $instance = array(); 
        $instance['title'] = $new_instance['title'];
        $instance['url'] = $new_instance['url'];
        $instance['alt'] = $new_instance['alt'];
        $instance['desc'] = $new_instance['desc']; 
        $instance['desc_use'] = isset($new_instance['desc_use']); 
        $instance['link'] = $new_instance['link']; 
        $instance['link_use'] = isset($new_instance['link_use']); 
        $instance['grayscale'] = isset($new_instance['grayscale']);
        $instance['new_tab'] = isset($new_instance['new_tab']);        
        $instance['pb'] = $new_instance['pb']; 
        
        return $instance;
    }

    function form($instance) 
    {        
        $def = array(
            'title' => '',          
            'url' => '', 
            'alt' => '',
            'desc' => '', 
            'desc_use' => false,
            'link' => '',
            'link_use' => false,
            'grayscale' => false,
            'new_tab' => false, 
            'pb' => 40
            );
        $instance = dcf_combineArgs($def, $instance);
        $tools = new DCC_BasicTools();                 
                      
        $out = '';
        $out .= '<span class="dc-cms-control-top-label-nomargin">Widget title</span>'; 
        $out .= '<input id="'.$this->get_field_id('title').'" class="dc-cms-control-wide" name="'.$this->get_field_name('title').'" type="text" value="'.$instance['title'].'" />';                
      
        $out .= '<span class="dc-cms-control-top-label">Image URL</span>';  
        $out .= '<input type="text" class="dc-cms-control-wide" name="'.$this->get_field_name('url').'" value="'.$instance['url'].'" id="dc-id-'.$this->id.'-url" />';
        
        $out .= $tools->getImagePreviewBox(array('path' => $instance['url'], 'wide' => true, 'height' => 120, 'margin' => '15px 0px 0px 0px'));
        
        $out .= '<div class="dc-cms-btn-frame">';
            $out .= '<input class="dc-cms-submit-image-btn" type="button" name="dc-id-'.$this->id.'-url" value="Load image" />';
        $out .= '</div>';          

        $out .= '<span class="dc-cms-control-top-label">Image Alt</span>';  
        $out .= '<input type="text" class="dc-cms-control-wide" name="'.$this->get_field_name('alt').'" value="'.$instance['alt'].'" />';        
        
        $out .= '<span class="dc-cms-control-top-label-s-margin">Image description</span>'; 
        $out .= '<textarea class="dc-cms-control-wide dc-cms-control-textarea dc-cms-control-h-100" name="'.$this->get_field_name('desc').'">';
            $out .= $instance['desc'];
        $out .= '</textarea>';            
      
        $out .= '<span class="dc-cms-control-top-label-s-margin">Link</span>'; 
        $out .= '<input class="dc-cms-control-wide" name="'.$this->get_field_name('link').'" type="text" value="'.$instance['link'].'" />';       
      
        $out .= '<span class="dc-cms-control-top-label-s-margin">Widget padding bottom</span>'; 
        $out .= $tools->getCtrlInputInt($this->get_field_name('pb'), $instance['pb'], 0, null); 
        $out .= '<div class="dc-cms-help-note-box-small">';
            $out .= 'In default every widget have some bottom padding, you can\'t change it, but this is special widget and you can adjust the bottom empty space.';
        $out .= '</div>';        
      
        $out .= '<span class="dc-cms-control-top-label-s-margin">Other settings</span>';
        $out .= '<input name="'.$this->get_field_name('desc_use').'" type="checkbox" '.($instance['desc_use'] ? ' checked="checked" ' : '').'/> Display description';
        $out .= '<br />';           
        $out .= '<input name="'.$this->get_field_name('grayscale').'" type="checkbox" '.($instance['grayscale'] ? ' checked="checked" ' : '').'/> Display in grayscale';
        $out .= '<br />';  
        $out .= '<input name="'.$this->get_field_name('link_use').'" type="checkbox" '.($instance['link_use'] ? ' checked="checked" ' : '').'/> Use link';
        $out .= '<br />';  
        $out .= '<input name="'.$this->get_field_name('new_tab').'" type="checkbox" '.($instance['new_tab'] ? ' checked="checked" ' : '').'/> Open link in new window/tab';
        $out .= '<br />';          
      
        echo $out;
                                
        $out = '<script type="text/javascript">';
            
            $out .= 'if(jQuery().dcf_setupIntCtrl)';
            $out .= '{';
                $out .= 'jQuery(\'body\').dcf_setupIntCtrl(); ';
            $out .= '}';                  
            
            $out .= 'if(jQuery().dcf_setupCMSLightBox)';
            $out .= '{';
                $out .= 'jQuery(\'body\').dcf_setupCMSLightBox(); ';
            $out .= '} ';            

            $out .= 'if(jQuery().dcf_setupCMSLoadImageBtn)';
            $out .= '{';
                $out .= 'jQuery(\'body\').dcf_setupCMSLoadImageBtn(); ';
            $out .= '} ';   
                       
        $out .= '</script>';   
     
        echo $out;          
           
 }

}

// Register widget
function dcwp_imageInit() { register_widget('dcwp_image'); }
add_action('widgets_init', 'dcwp_imageInit');

}    
  
  
/*
 * Plugin Name: DC Widget Video
 * Version: 1.0
 * Plugin URI: http://themeforest.net/user/DigitalCavalry
 * Description: DC Widget Video
 * Author: Digital Cavalry
 * Author URI: http://themeforest.net/user/DigitalCavalry
 */

if(CMS_DC_REGISTER_WIDGET_VIDEO)
{
   
class dcwp_video extends WP_Widget 
{   
    function __construct() 
    {        
        $args = array(
            'classname' => 'dcwp_video', 
            'description' => __('Single video from YouTube or Vimeo', CMS_TXT_DOMAIN).' ('.CMS_THEME_NAME.' theme)' // description displayed in WP widgets area
        );

        parent::__construct(
            'dcwp_video_id',   // WP ID should be unique 
            'DC Video', // name displayed in WP widgets area
            $args);
    }        

    function widget($args, $instance)
    {           
        echo $args['before_widget'];
        if(trim($instance['title']) != '') { echo $args['before_title'].$instance['title'].$args['after_title']; }      
             
        $out = '';
        $out .= '<div class="dc-widget-video">';
             
            $desc_use = $instance['desc_use'] ? 'true' : 'false'; 
            $v_args = array(
              'size' => '1-1',
              'ctype' => 'none',
              'float' => 'none',
              'clear' => 'none',            
              'url' => $instance['url'],        
              'bottom' => 0,
              'desc_use' => $desc_use
            );              
             
            $out .= GetDCCPI()->getIShortcodes()->render_dcs_video($v_args, $instance['desc']);
                         
        $out .= '</div>';
        echo $out;
        
        echo $args['after_widget'];  
    }

    function update($new_instance, $old_instance) 
    {
        $instance = array(); 
        $instance['title'] = $new_instance['title'];
        $instance['url'] = $new_instance['url'];
        $instance['desc'] = $new_instance['desc']; 
        $instance['desc_use'] = isset($new_instance['desc_use']);      
        
        return $instance;
    }

    function form($instance) 
    {        
        $def = array(
            'title' => '', 
            'url' => '', 
            'desc' => '', 
            'desc_use' => false
            );
        $instance = dcf_combineArgs($def, $instance);
        $tools = new DCC_BasicTools();                 
                      
        $out = '';
        $out .= '<span class="dc-cms-control-top-label-nomargin">Widget title</span>'; 
        $out .= '<input id="'.$this->get_field_id('title').'" class="dc-cms-control-wide" name="'.$this->get_field_name('title').'" type="text" value="'.$instance['title'].'" />';                
 
        $out .= '<span class="dc-cms-control-top-label-s-margin">YouTube or Vimeo URL</span>';     
        $out .= '<input class="dc-cms-control-wide" name="'.$this->get_field_name('url').'" type="text" value="'.$instance['url'].'" />'; 
        
        $out .= '<span class="dc-cms-control-top-label-s-margin">Video description</span>'; 
        $out .= '<textarea class="dc-cms-control-wide dc-cms-control-textarea dc-cms-control-h-160" name="'.$this->get_field_name('desc').'">';
            $out .= $instance['desc'];
        $out .= '</textarea>';                     
      
        $out .= '<span class="dc-cms-control-top-label-s-margin">Other settings</span>';
        $out .= '<input name="'.$this->get_field_name('desc_use').'" type="checkbox" '.($instance['desc_use'] ? ' checked="checked" ' : '').'/> Display description';
        $out .= '<br />';                   
      
        echo $out;
                                                
    }

}

// Register widget
function dcwp_videoInit() { register_widget('dcwp_video'); }
add_action('widgets_init', 'dcwp_videoInit');

}      
  
  
  
/*
 * Plugin Name: DC Contact Data
 * Version: 1.0
 * Plugin URI: http://themeforest.net/user/DigitalCavalry
 * Description: DC Contact Data
 * Author: Digital Cavalry
 * Author URI: http://themeforest.net/user/DigitalCavalry
 */

if(CMS_DC_REGISTER_WIDGET_CONTACT_DATA)
{
   
class dcwp_contactdata extends WP_Widget 
{   
    function __construct() 
    {        
        $args = array(
            'classname' => 'dcwp_contactdata', 
            'description' => __('Your contact detail information', CMS_TXT_DOMAIN).' ('.CMS_THEME_NAME.' theme)' // description displayed in WP widgets area
        );

        parent::__construct(
            'dcwp_contactdata_id',   // WP ID should be unique 
            'DC Contact Data', // name displayed in WP widgets area
            $args);
    }        

    function widget($args, $instance)
    {           
        // echo $args['before_widget'];
        echo GetDCCPI()->getIGeneral()->getBeforeWidget(array('pb' => $instance['pb'], 'pb_use' => true)); 
        if(trim($instance['title']) != '') { echo $args['before_title'].$instance['title'].$args['after_title']; }      
             
        $out = '';
        $out .= '<div class="dc-widget-contact-data">';
             
             for($i = 1; $i < 5; $i++)
             {   
                 if($instance['display_'.$i])
                 {
                    if($instance['label_'.$i] != '') { $out .= '<div class="label">'.$instance['label_'.$i].'</div>'; }
                    if($instance['text_'.$i] != '') { $out .= '<div class="text">'.wpautop($instance['text_'.$i]).'</div>'; }
                 }
             }
                
        $out .= '</div>';
        echo $out;
        
        echo $args['after_widget'];  
    }

    function update($new_instance, $old_instance) 
    {
        $instance = array(); 
        $instance['title'] = $new_instance['title'];
        $instance['label_1'] = $new_instance['label_1'];
        $instance['text_1'] = $new_instance['text_1']; 
        $instance['display_1'] = isset($new_instance['display_1']);      
        $instance['label_2'] = $new_instance['label_2'];
        $instance['text_2'] = $new_instance['text_2']; 
        $instance['display_2'] = isset($new_instance['display_2']);   
        $instance['label_3'] = $new_instance['label_3'];
        $instance['text_3'] = $new_instance['text_3']; 
        $instance['display_3'] = isset($new_instance['display_3']);
        $instance['label_4'] = $new_instance['label_4'];
        $instance['text_4'] = $new_instance['text_4']; 
        $instance['display_4'] = isset($new_instance['display_4']);              
        $instance['pb'] = $new_instance['pb'];
        
        return $instance;
    }

    function form($instance) 
    {        
        $def = array(
            'title' => '', 
            'label_1' => '', 
            'text_1' => '', 
            'display_1' => false,
            'label_2' => '', 
            'text_2' => '', 
            'display_2' => false,  
            'label_3' => '', 
            'text_3' => '', 
            'display_3' => false,   
            'label_4' => '', 
            'text_4' => '', 
            'display_4' => false,                                     
            'pb' => 40
            );
        $instance = dcf_combineArgs($def, $instance);
        $tools = new DCC_BasicTools();                 
                      
        $out = '';
        $out .= '<span class="dc-cms-control-top-label-nomargin">Widget title</span>'; 
        $out .= '<input id="'.$this->get_field_id('title').'" class="dc-cms-control-wide" name="'.$this->get_field_name('title').'" type="text" value="'.$instance['title'].'" />';                     
        
        $out .= '<span class="dc-cms-control-top-label-s-margin">1) Label and text</span>'; 
        $out .= '<textarea class="dc-cms-control-wide dc-cms-control-textarea dc-cms-control-h-40" name="'.$this->get_field_name('label_1').'" >'.$instance['label_1'].'</textarea>';                
        $out .= '<textarea class="dc-cms-control-wide dc-cms-control-textarea dc-cms-control-h-60" name="'.$this->get_field_name('text_1').'" >'.$instance['text_1'].'</textarea>';
        $out .= $tools->getStdInputsFieldStart();
            $out .= '<input name="'.$this->get_field_name('display_1').'" type="checkbox" '.$tools->attrChecked($instance['display_1']).' /> Display';
        $out .= $tools->getStdInputsFieldEnd();
   
        $out .= '<span class="dc-cms-control-top-label-s-margin">2) Label and text</span>'; 
        $out .= '<textarea class="dc-cms-control-wide dc-cms-control-textarea dc-cms-control-h-40" name="'.$this->get_field_name('label_2').'" >'.$instance['label_2'].'</textarea>';                
        $out .= '<textarea class="dc-cms-control-wide dc-cms-control-textarea dc-cms-control-h-60" name="'.$this->get_field_name('text_2').'" >'.$instance['text_2'].'</textarea>';
        $out .= $tools->getStdInputsFieldStart();    
            $out .= '<input name="'.$this->get_field_name('display_2').'" type="checkbox" '.$tools->attrChecked($instance['display_2']).' /> Display';        
        $out .= $tools->getStdInputsFieldEnd();

        $out .= '<span class="dc-cms-control-top-label-s-margin">3) Label and text</span>'; 
        $out .= '<textarea class="dc-cms-control-wide dc-cms-control-textarea dc-cms-control-h-40" name="'.$this->get_field_name('label_3').'" >'.$instance['label_3'].'</textarea>';                
        $out .= '<textarea class="dc-cms-control-wide dc-cms-control-textarea dc-cms-control-h-60" name="'.$this->get_field_name('text_3').'" >'.$instance['text_3'].'</textarea>';
        $out .= $tools->getStdInputsFieldStart();    
            $out .= '<input name="'.$this->get_field_name('display_3').'" type="checkbox" '.$tools->attrChecked($instance['display_3']).' /> Display';        
        $out .= $tools->getStdInputsFieldEnd();
        
        $out .= '<span class="dc-cms-control-top-label-s-margin">4) Label and text</span>'; 
        $out .= '<textarea class="dc-cms-control-wide dc-cms-control-textarea dc-cms-control-h-40" name="'.$this->get_field_name('label_4').'" >'.$instance['label_4'].'</textarea>';                
        $out .= '<textarea class="dc-cms-control-wide dc-cms-control-textarea dc-cms-control-h-60" name="'.$this->get_field_name('text_4').'" >'.$instance['text_4'].'</textarea>';
        $out .= $tools->getStdInputsFieldStart();    
            $out .= '<input name="'.$this->get_field_name('display_4').'" type="checkbox" '.$tools->attrChecked($instance['display_4']).' /> Display';        
        $out .= $tools->getStdInputsFieldEnd();        
        
        $out .= '<span class="dc-cms-control-top-label-s-margin">Widget padding bottom</span>'; 
        $out .= $tools->getCtrlInputInt($this->get_field_name('pb'), $instance['pb'], 0, null); 
        $out .= '<div class="dc-cms-help-note-box-small">';
            $out .= 'In default every widget have some bottom padding, you can\'t change it, but this is special widget and you can adjust the bottom empty space.';
        $out .= '</div>';             
        
        echo $out;
    
        $out = '<script type="text/javascript">';
            
            $out .= 'if(jQuery().dcf_setupIntCtrl)';
            $out .= '{';
                $out .= 'jQuery(\'body\').dcf_setupIntCtrl(); ';
            $out .= '}';                              
                       
        $out .= '</script>';   
     
        echo $out;     
                                                
    }

}

// Register widget
function dcwp_contactdataInit() { register_widget('dcwp_contactdata'); }
add_action('widgets_init', 'dcwp_contactdataInit');

}    
  
?>
