<?php
/**********************************************************************
* OSAKA UNLIMITED WORDPRESS THEME   
* (Ideal For Business And Personal Use: Portfolio or Blog)     
* 
* File name:   
*      cp_customposts.php
* Brief:       
*      Part of theme control panel.
* Author:      
*      DigitalCavalry
* Author URI:
*      http://themeforest.net/user/DigitalCavalry
* Contact:
*      digitalcavalry@gmail.com 
***********************************************************************/ 
   
class DCC_ControlPanelCustomPosts extends DCC_ControlPanelBase  
{
    const PT_PAGE_CATEGORY = 'category_page';   
    
    const PT_SERVICE_POST = 'dc_service';
    const PT_SERVICE_CATEGORY = 'dc_service_category'; 
    const PT_SERVICE_POST_REWRITE_SLUG = 'service'; 
    const PT_SERVICE_CATEGORY_REWRITE_SLUG = 'service-category'; 
                                                                             
    const PT_PROJECT_POST = 'dc_project';
    const PT_PROJECT_CATEGORY = 'dc_project_category'; 
    const PT_PROJECT_POST_REWRITE_SLUG = 'project';  
    const PT_PROJECT_CATEGORY_REWRITE_SLUG = 'project-category';
             
    const PT_MEMBER_POST = 'dc_member';
    const PT_MEMBER_CATEGORY = 'dc_member_category';
    const PT_MEMBER_POST_REWRITE_SLUG = 'member';     
    const PT_MEMBER_CATEGORY_REWRITE_SLUG = 'member-category';
    
    /*********************************************************** 
    * Constructor
    ************************************************************/       
    public function __construct()
    {                                                              
        $is_admin = is_admin();        
        

        // pages category
        add_action('init', array(&$this, 'createPageTaxonomy'));  

        // member posts
        add_action('init', array(&$this, 'createMemberPosts'));
        add_action('init', array(&$this, 'createMemberTaxonomy'));  
        if($is_admin)
        {      
            add_filter('manage_edit-'.self::PT_MEMBER_POST.'_columns', array(&$this, 'adminMemberColumnsCreate'));
            add_action('manage_'.self::PT_MEMBER_POST.'_posts_custom_column', array(&$this, 'adminMemberColumnsRender'), 10, 2);       
        }                
        
        
        // service posts
        add_action('init', array(&$this, 'createServicePosts'));
        add_action('init', array(&$this, 'createServiceTaxonomy'));  
        if($is_admin)
        {      
            add_filter('manage_edit-'.self::PT_SERVICE_POST.'_columns', array(&$this, 'adminServiceColumnsCreate'));
            add_action('manage_'.self::PT_SERVICE_POST.'_posts_custom_column', array(&$this, 'adminServiceColumnsRender'), 10, 2);       
        }                
        
        // project post
        add_action('init', array(&$this, 'createProjectPosts'));
        add_action('init', array(&$this, 'createProjectTaxonomy'));  
        if($is_admin)
        {      
            add_filter('manage_edit-'.self::PT_PROJECT_POST.'_columns', array(&$this, 'adminProjectColumnsCreate'));
            add_action('manage_'.self::PT_PROJECT_POST.'_posts_custom_column', array(&$this, 'adminProjectColumnsRender'), 10, 2);       
        }
  
    }
    
    /*********************************************************** 
    * Public functions
    ************************************************************/               
    
    // pages post type
    public function createPageTaxonomy()
    {
        
         register_taxonomy(
            self::PT_PAGE_CATEGORY, 'page',
            array(
                'hierarchical' => true,
                'public' => true,
                'show_ui' => true,
                'query_var' => true,
                'show_tagcloud' => true,
                'rewrite' => array('slug' => self::PT_PAGE_CATEGORY, 'with_front' => false),
                
                'labels' => array(
                  'name' => 'Category',
                  'singular_name' => 'Category',
                  'search_items' => 'Search Categories',
                  'popular_items' => 'Popular Categories',
                  'all_items' => 'All Categories',
                  'parent_item' => 'Parent Category',
                  'parent_item_colon' => 'Parent Category',
                  'edit_item' => 'Edit Category',
                  'update_item' => 'Update Category',
                  'add_new_item' => 'Add New Category',
                  'new_item_name' => 'New Category Name' 
                ),
                
                'label' => 'Category'                
            ));                                    
    }    
    
    # member post type
    public function createMemberPosts()
    {
         register_post_type(
            self::PT_MEMBER_POST,
            Array(
                'labels' => Array(
                    'name' => 'Members',
                    'singular_name' => 'Member',
                    'add_new' => 'Add New Member',
                    'edit_item' => 'Edit Member', 
                    'add_new_item' => 'Add New Member'
                ),
            'supports' => Array('title', 'editor', 'custom-fields', 'excerpt'),
            'public' => true,
            'exclude_from_search' => false, 
            'has_archive' => false, 
            'rewrite' => Array('slug' => self::PT_MEMBER_POST_REWRITE_SLUG, 'with_front' => false)
        ));
    }  
    
    public function adminMemberColumnsCreate($columns)
    {
        $new_columns['cb'] = '<input type="checkbox" />';
 
        $new_columns['title'] = _x('Title', 'column name', CMS_TXT_DOMAIN);
        $new_columns['id'] = __('ID', CMS_TXT_DOMAIN); 
        $new_columns['cats'] = __('Categories', CMS_TXT_DOMAIN);  
        $new_columns['author'] = __('Author', CMS_TXT_DOMAIN);        
        $new_columns['date'] = _x('Date', 'column name', CMS_TXT_DOMAIN);
 
        return $new_columns;        
    }    
 
    public function adminMemberColumnsRender($column_name, $id) 
    {
        switch ($column_name) 
        {
            case 'id':
                {
                    echo $id;
                }
                break; 
                
            case 'cats':
                {
                    $p_cats = wp_get_object_terms($id, self::PT_MEMBER_CATEGORY);
                    if(is_array($p_cats))
                    {
                        $count = count($p_cats);
                        if($count == 0)
                        {
                            echo __('Uncategorized', CMS_TXT_DOMAIN);    
                        } else
                        {
                            $counter = 0;
                            foreach($p_cats as $c)
                            {
                                if($counter > 0) { echo ', '; } 
                                $counter++;
                                echo '<a href="'.get_admin_url().'edit.php?post_type='.self::PT_MEMBER_POST.'&'.self::PT_MEMBER_CATEGORY.'='.$c->slug.'">'.$c->name.'</a>';        
                            }        
                        }
                    } else
                    {
                        echo '-';
                    }
                }
                break;                  
                                  
            default:
                break;
                
        } // end switch
    }        
    
    public function createMemberTaxonomy()
    {
        
         register_taxonomy(
            self::PT_MEMBER_CATEGORY, self::PT_MEMBER_POST,
            Array(
                'hierarchical' => true,
                'public' => true,
                'show_ui' => true,
                'query_var' => true,
                'show_tagcloud' => true,
                'rewrite' => Array('slug' => self::PT_MEMBER_CATEGORY_REWRITE_SLUG, 'with_front' => false),
                
                'labels' => Array(
                  'name' => 'Member Category',
                  'singular_name' => 'Member Category',
                  'search_items' => 'Search Member Categories',
                  'popular_items' => 'Popular Member Categories',
                  'all_items' => 'All Member Categories',
                  'parent_item' => 'Parent Member Category',
                  'parent_item_colon' => 'Parent Member Category',
                  'edit_item' => 'Edit Member Category',
                  'update_item' => 'Update Member Category',
                  'add_new_item' => 'Add New Member Category',
                  'new_item_name' => 'New Member Category Name' 
                ),
                
                'label' => 'Member Category'
                
        ) 
         );                                    
    }        
    
    # service post type
    public function createServicePosts()
    {
         register_post_type(
            self::PT_SERVICE_POST,
            Array(
                'labels' => Array(
                    'name' => 'Services',
                    'singular_name' => 'Service',
                    'add_new' => 'Add New Service',
                    'edit_item' => 'Edit Service', 
                    'add_new_item' => 'Add New Service'
                ),
            'supports' => Array('title', 'editor', 'custom-fields', 'excerpt'),
            'public' => true,
            'exclude_from_search' => false, 
            'has_archive' => false, 
            'rewrite' => Array('slug' => self::PT_SERVICE_POST_REWRITE_SLUG, 'with_front' => false)
        ));
    }  
    
    public function adminServiceColumnsCreate($columns)
    {
        $new_columns['cb'] = '<input type="checkbox" />';
 
        $new_columns['title'] = _x('Title', 'column name', CMS_TXT_DOMAIN);
        $new_columns['id'] = __('ID', CMS_TXT_DOMAIN); 
        $new_columns['cats'] = __('Categories', CMS_TXT_DOMAIN);  
        $new_columns['author'] = __('Author', CMS_TXT_DOMAIN);        
        $new_columns['date'] = _x('Date', 'column name', CMS_TXT_DOMAIN);
 
        return $new_columns;        
    }    
 
    public function adminServiceColumnsRender($column_name, $id) 
    {
        switch ($column_name) 
        {
            case 'id':
                echo $id;
                break;
                
            case 'cats':
                {
                    $p_cats = wp_get_object_terms($id, self::PT_SERVICE_CATEGORY);
                    if(is_array($p_cats))
                    {
                        $count = count($p_cats);
                        if($count == 0)
                        {
                            echo __('Uncategorized', CMS_TXT_DOMAIN);    
                        } else
                        {
                            $counter = 0;
                            foreach($p_cats as $c)
                            {
                                if($counter > 0) { echo ', '; } 
                                $counter++;
                                echo '<a href="'.get_admin_url().'edit.php?post_type='.self::PT_SERVICE_POST.'&'.self::PT_SERVICE_CATEGORY.'='.$c->slug.'">'.$c->name.'</a>';        
                            }        
                        }
                    } else
                    {
                        echo '-';
                    }
                }
                break;  
                              
            default:
                break;
                
        } // end switch
    }                 
    
    public function createServiceTaxonomy()
    {
        
         register_taxonomy(
            self::PT_SERVICE_CATEGORY, self::PT_SERVICE_POST,
            Array(
                'hierarchical' => true,
                'public' => true,
                'show_ui' => true,
                'query_var' => true,
                'show_tagcloud' => true,
                'rewrite' => Array('slug' => self::PT_SERVICE_CATEGORY_REWRITE_SLUG, 'with_front' => false),
                
                'labels' => Array(
                  'name' => 'Service Category',
                  'singular_name' => 'Service Category',
                  'search_items' => 'Search Service Categories',
                  'popular_items' => 'Popular Service Categories',
                  'all_items' => 'All Service Categories',
                  'parent_item' => 'Parent Service Category',
                  'parent_item_colon' => 'Parent Service Category',
                  'edit_item' => 'Edit Service Category',
                  'update_item' => 'Update Service Category',
                  'add_new_item' => 'Add New Service Category',
                  'new_item_name' => 'New Service Category Name' 
                ),
                
                'label' => 'Service Category'
                
        ) 
         );                                    
    }      
    
    # project post type
    public function createProjectPosts()
    {
         register_post_type(
            self::PT_PROJECT_POST,
            Array(
                'labels' => Array(
                    'name' => 'Projects',
                    'singular_name' => 'Project',
                    'add_new' => 'Add New Project',
                    'edit_item' => 'Edit Project', 
                    'add_new_item' => 'Add New Project'
                ),
            'supports' => Array('title', 'editor', 'custom-fields', 'excerpt', 'comments'),
            'public' => true,
            'exclude_from_search' => false,
            'has_archive' => false, 
            'rewrite' => array('slug' => self::PT_PROJECT_POST_REWRITE_SLUG, 'with_front' => false)
        ));
    }  
    
    public function adminProjectColumnsCreate($columns)
    {
        $new_columns['cb'] = '<input type="checkbox" />';
 
        $new_columns['title'] = _x('Title', 'column name', CMS_TXT_DOMAIN);
        $new_columns['id'] = __('ID', CMS_TXT_DOMAIN); 
        $new_columns['cats'] = __('Categories', CMS_TXT_DOMAIN);  
        $new_columns['author'] = __('Author', CMS_TXT_DOMAIN);        
        $new_columns['date'] = _x('Date', 'column name', CMS_TXT_DOMAIN);
 
        return $new_columns;        
    }    
 
    public function adminProjectColumnsRender($column_name, $id) 
    {
        switch ($column_name) 
        {
            case 'id':
                echo $id;
                break;
                
            case 'cats':
                {
                    $p_cats = wp_get_object_terms($id, self::PT_PROJECT_CATEGORY);
                    if(is_array($p_cats))
                    {
                        $count = count($p_cats);
                        if($count == 0)
                        {
                            echo __('Uncategorized', CMS_TXT_DOMAIN);    
                        } else
                        {
                            $counter = 0;
                            foreach($p_cats as $c)
                            {
                                if($counter > 0) { echo ', '; } 
                                $counter++;
                                echo '<a href="'.get_admin_url().'edit.php?post_type='.self::PT_PROJECT_POST.'&'.self::PT_PROJECT_CATEGORY.'='.$c->slug.'">'.$c->name.'</a>';        
                            }        
                        }
                    } else
                    {
                        echo '-';
                    }
                }
                break; 
                               
            default:
                break;
                
        } // end switch
    }                 
    
    public function createProjectTaxonomy()
    {
        
         register_taxonomy(
            self::PT_PROJECT_CATEGORY, self::PT_PROJECT_POST,
            Array(
                'hierarchical' => true,
                'public' => true,
                'show_ui' => true,
                'query_var' => true,
                'show_tagcloud' => true,
                'rewrite' => Array('slug' => self::PT_PROJECT_CATEGORY_REWRITE_SLUG, 'with_front' => false),
                
                'labels' => Array(
                  'name' => 'Project Category',
                  'singular_name' => 'Project Category',
                  'search_items' => 'Search Project Categories',
                  'popular_items' => 'Popular Project Categories',
                  'all_items' => 'All Project Categories',
                  'parent_item' => 'Parent Project Category',
                  'parent_item_colon' => 'Parent Project Category',
                  'edit_item' => 'Edit Project Category',
                  'update_item' => 'Update Project Category',
                  'add_new_item' => 'Add New Project Category',
                  'new_item_name' => 'New Project Category Name' 
                ),
                
                'label' => 'Project Category'
                
        ) 
         );                                    
    }          
    
}
     
?>
