<?php
/**********************************************************************
* OSAKA UNLIMITED WORDPRESS THEME 
* (Ideal For Business And Personal Use: Portfolio or Blog)     
* 
* File name:   
*      cp_cache.php
* Brief:       
*      Part of theme control panel.
* Author:      
*      DigitalCavalry
* Author URI:
*      http://themeforest.net/user/DigitalCavalry
* Contact:
*      digitalcavalry@gmail.com 
***********************************************************************/

/*********************************************************** 
* Class name:
*    DCC_ControlPanelCache
* Descripton:
*    Implementation of DCC_ControlPanelCache 
***********************************************************/
class DCC_ControlPanelCache extends DCC_BasicTools
{

    /*********************************************************** 
    * Constructor
    ************************************************************/
    public function __construct() 
    {
    
    } // constructor 

    /*********************************************************** 
    * Public members
    ************************************************************/      
    
    /*********************************************************** 
    * Private members
    ************************************************************/      
    private $_terms = array();
    private $_wp_users = null;
    private $_pages_list = array();
   
    /*********************************************************** 
    * Public functions
    ************************************************************/                
 
    public function get_pages()
    {
        $result = array();
        
        if(count($this->_pages_list) == 0)
        {
            global $wpdb;
            $this->_pages_list = $this->_pages_list = $wpdb->get_results("SELECT ID, post_title FROM $wpdb->posts WHERE post_status = 'publish' AND post_type = 'page' ORDER BY post_title ");                                     
            if(!is_array($this->_pages_list)) { $this->_pages_list = array(); }
            
            $result = $this->_pages_list;
        } else
        {
            $result = $this->_pages_list;
        }
        
        return $result;
    }
 
    public function get_terms($taxonomy)
    {                                                             
        $result = array();
        if(in_array($taxonomy, $this->_terms))
        {                        
            $result = $this->_terms[$taxonomy];     
        } else
        {
            $terms = get_terms($taxonomy, array('hide_empty' => false));
            if(!is_array($terms)) { $terms = array(); }
            
            $this->_terms[$taxonomy] = $terms;
            $result = $terms;
        } 
        
        return $result;  
    }
    
    public function get_wp_users()
    {
        global $wpdb;
        
        if($this->_wp_users === null)
        {        
            $users = $wpdb->get_results("SELECT ID, display_name FROM $wpdb->users ORDER BY ID");
            if(is_array($users))
            {          
                $this->_wp_users = $users;
            }            
        }   
        
        return $this->_wp_users;              
    }
    
    public function get_wp_user_by_id($id=0)
    {
        $result = false;
        
        $this->get_wp_users();
        
        if(is_array($this->_wp_users))
        {
            foreach($this->_wp_users as $user)
            {
                if($user->ID == $id)
                {
                    $result = $user;
                    break;
                }    
            }
        }
        
        return $result;    
    }    
    
    public function get_terms_by_post_type($taxonomies=array(), $post_types=array()) 
    {
        global $wpdb;
        $query = "SELECT t.*, COUNT as count from $wpdb->terms AS t INNER JOIN $wpdb->term_taxonomy AS tt ON t.term_id = tt.term_id INNER JOIN $wpdb->term_relationships AS r ON r.term_taxonomy_id = tt.term_taxonomy_id INNER JOIN $wpdb->posts AS p ON p.ID = r.object_id WHERE p.post_type IN('".implode( "', '", $post_types )."') AND tt.taxonomy IN('".implode( "', '", $taxonomies )."') GROUP BY t.term_id ORDER BY t.name";
        $results = $wpdb->get_results( $query );

        return $results;

    }    
 
 
    /*********************************************************** 
    * Private functions
    ************************************************************/      

         
}
        
        
?>