<?php

/*
Plugin Name: Video Postr
Plugin URI: http://www.wearepixel8.com
Description: A simple plugin that will clean up the HTML image markup produced by WordPress.
Version: 1.0.2
Author: We Are Pixel8
Author URI: http://www.wearepixel8.com
License:
	Copyright 2011 We Are Pixel8 <hello@wearepixel8.com>
	
	This program is free software; you can redistribute it and/or modify it under
	the terms of the GNU General Public License, version 2, as published by the Free
	Software Foundation.
	
	This program is distributed in the hope that it will be useful, but WITHOUT ANY
	WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
	PARTICULAR PURPOSE. See the GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software Foundation, Inc.,
	51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
*/

/*----------------------------------------------------------------------------*/
/* GetVideo
/*----------------------------------------------------------------------------*/

/**
 * GetVideo
 *
 * Get the embed code for video saved to a post.
 *
 * @param $postID
 *
 * @package Video Postr
 * @version 1.0.0
 * @since 1.0.0
 * @author Erik Ford for We Are Pixel8 <@notdivisible>
 *
 */

function wap8GetVideo( $postID ) {
    
    global $wp_embed;

	// legacy support
	if ( $videoURL = get_post_meta( $postID, 'videoembed', true ) ) return $videoURL;
	
	if ( $videoEmbed = get_post_meta( $postID, '_videoembed_manual', true ) ) return $videoEmbed;

	$videoURL = get_post_meta( $postID, '_videoembed', true );
	if ( !( $videoWidth = get_post_meta( $postID, '_videowidth', true ) ) )
		$videoWidth = get_option( 'wap8_default_player_width' );
	if ( !( $videoHeight = get_post_meta( $postID, '_videoheight', true ) ) )
		$videoHeight = get_option( 'wap8_default_player_height' );

	return $wp_embed->shortcode( array( 'width' => $videoWidth, 'height' => $videoHeight ), $videoURL );

}

/*----------------------------------------------------------------------------*/
/* HasVideo
/*----------------------------------------------------------------------------*/

/**
 * HasVideo
 *
 * Determine if a video has been saved to this post.
 *
 * @param $postID
 * @return boolean
 *
 * @package Video Postr
 * @version 1.0.0
 * @since 1.0.0
 * @author Erik Ford for We Are Pixel8 <@notdivisible>
 *
 */

function wap8HasVideo( $postID ) {
	
	return ( bool )(
		
		get_post_meta( $postID, '_videoembed', true ) ||
		get_post_meta( $postID, '_videoembed_manual', true ) ||
		get_post_meta( $postID, 'videoembed', true )
		
		);

}

/*----------------------------------------------------------------------------*/
/* Video Poster Image
/*----------------------------------------------------------------------------*/

/**
 * Video Poster Image
 *
 * Return a poster image for self hosted videos
 *
 * @return $poster_image
 *
 * @package Video Postr
 * @version 1.0.0
 * @since 1.0.0
 * @author Erik Ford for We Are Pixel8 <@notdivisible>
 *
 */

function wap8_video_poster_image() {

	global $post;
	
	if ( wap8HasVideo( $post->ID ) ) {
	
		$poster_image = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'img-460x280' );
	
	}
	
	return $poster_image[0];
	
}

/*----------------------------------------------------------------------------*/
/* JW Player Handler
/*----------------------------------------------------------------------------*/

/**
 * JW Player Handler
 *
 * Register the custom JW Media Player embed handler.
 *
 * @param $matches
 * @param $attr
 * @param $url
 * @param $rawattr
 *
 * @package Video Postr
 * @version 1.0.0
 * @since 1.0.0
 * @author Erik Ford for We Are Pixel8 <@notdivisible>
 *
 */

function wap8_jw_player_handler( $matches, $attr, $url, $rawattr ) {
    static $counter = 1;

    if ( !empty( $rawattr['width'] ) && !empty( $rawattr['height'] ) ) { 
        $width  = ( int ) $rawattr['width'];
        $height = ( int ) $rawattr['height'];
    } else {
        list( $width, $height ) = wp_expand_dimensions( 
            get_option( 'wap8_default_player_width' ), 
            get_option( 'wap8_default_player_height' ), 
            $attr['width'], $attr['height'] );
    }

    $flashvars = get_option( 'wap8_jw_flashvars' );
    if ( !empty( $flashvars ) && substr( $flashvars, 0, 1 ) != '&' )
        parse_str( $flashvars, $vars );
                
    $file_loc = get_option( 'wap8_jw_files' );
        if ( substr($file_loc, -1)!='/' )
            $file_loc = $file_loc . '/';

	$res = "
<script type='text/javascript' src='{$file_loc}jwplayer.js'></script>
<div id='videoContainer-" . $counter . "'>This text will be replaced</div>
<script type='text/javascript'>
	jwplayer('videoContainer-" . $counter . "').setup({
		'flashplayer'	:	'{$file_loc}player.swf',
		'file'			:	'" . esc_attr( $url ) . "',
		'controlbar'	:	'over',
		'width'			:	'" . esc_attr( $width ) . "',
		'height'		:	'" . esc_attr( $height ) . "',
		'image'			:	'" . wap8_video_poster_image() . "'
	});
</script>\n";
    return $res;

}

wp_embed_register_handler( 
	'wap8_jw_player', 
	'#http://.*\.(flv|mp4)#i', 
	'wap8_jw_player_handler'
	);

/*----------------------------------------------------------------------------*/
/* Video Postr Meta Box and Theme Admin Page
/*----------------------------------------------------------------------------*/

// Add actions to display settings page and post metabox
add_action( 'admin_menu', 'wap8_videoAdminInit' );
add_action( 'save_post', 'wap8_saveVideo' );

// Add settings page and post metabox
function wap8_videoAdminInit() {

	add_meta_box( 'wap8-video-posting', __( 'Portfolio Video Options', 'wap8theme-i18n' ), 'wap8_videoPosting', 'portfolio', 'advanced' );
	add_theme_page( __( 'Portfolio Video Embedder Settings', 'wap8theme-i18n' ), __( 'Artisan Creatif Video', 'wap8theme-i18n' ), 'edit_theme_options', 'wap8-videooptions.php', 'wap8_videoOptionsAdmin' );

}

// Post metabox form
function wap8_videoPosting() {
	global $post_ID, $wp_embed;
	
	$videoURL = get_post_meta( $post_ID, '_videoembed', true );
	$videoHeight = get_post_meta( $post_ID, '_videoheight', true );
	$videoWidth = get_post_meta( $post_ID, '_videowidth', true );
	$videoEmbed = get_post_meta( $post_ID, '_videoembed_manual', true );
	
?>

	<div style="float:left; margin-right: 5px;">
		<label for="wap8-video-url"><?php _e( 'Video URL', 'wap8theme-i18n' ); ?>:</label><br />
		<input style="width: 300px; margin-top:5px;" type="text" id="wap8-video-url" name="wap8-video-url" value="<?php echo $videoURL; ?>" tabindex="100" />
	</div>
	<div style="float:left; margin-right: 5px;">
		<label for="wap8-video-width3"><?php _e( 'Width', 'wap8theme-i18n' ); ?>:</label><br />
		<input style="margin-top:5px;" type="text" id="wap8-video-width3" name="wap8-video-width" size="4" value="<?php echo $videoWidth; ?>" tabindex="101" />
	</div>
	<div style="float:left;">
		<label for="wap8-video-height4"><?php _e( 'Height', 'wap8theme-i18n' ); ?>:</label><br />
		<input style="margin-top:5px;" type="text" id="wap8-video-height4" name="wap8-video-height" size="4" value="<?php echo $videoHeight; ?>" tabindex="102" />
	</div>
	<div class="clear"></div>
	
	<div style="margin-top:10px;">
		  <label for="wap8-video-embed"><?php _e( 'Embed Code &#40;This overrides above settings&#41;', 'wap8theme-i18n' ); ?></label><br />
		  <textarea style="width: 100%; margin:5px 2px 0 0;" id="wap8-video-embed" name="wap8-video-embed" rows="4" tabindex="103"><?php echo htmlspecialchars(stripslashes($videoEmbed)); ?></textarea>
	</div>
	<p>
		<input id="wap8-remove-video" type="checkbox" name="wap8-remove-video" /> <label for="wap8-remove-video"><?php _e( 'Remove video', 'wap8theme-i18n' ); ?></label>
	</p>

<?php

	// Video preview
	if ( $videoURL ) {
		echo '<div style="margin-top:10px;">' . __( 'Video Preview', 'wap8theme-i18n' ) . ': (' . __( 'Actual Size', 'wap8theme-i18n' ) . ')<br /><div id="video_preview" style="padding: 3px; border: 1px solid #CCC;float: left; margin-top: 5px;">';
        echo wap8GetVideo($post_ID);
		echo '</div></div><div class="clear"></div>';
	}
	
	else if ( $videoEmbed ) {
		echo '<div style="margin-top:10px;">' . __( 'Video Preview', 'wap8theme-i18n' ) . ': (' . __( 'Actual Size', 'wap8theme-i18n' ) . ')<br /><div id="video_preview" style="padding: 3px; border: 1px solid #CCC;float: left; margin-top: 5px;">';
		echo stripslashes($videoEmbed);
		echo '</div></div><div class="clear"></div>';
	}
?>

<p style="margin:10px 0 0 0;"><input id="publish" class="button-primary" type="submit" value="<?php _e( 'Update Portfolio Item', 'wap8theme-i18n' ); ?>" accesskey="p" tabindex="5" name="save"/></p>

<?php

}

// Save video when post has been saved
function wap8_saveVideo( $postID ) {
	global $wpdb;

	// Get the correct post ID if revision.
	if ( $wpdb->get_var("SELECT post_type FROM $wpdb->posts WHERE ID=$postID")=='revision')
		$postID = $wpdb->get_var("SELECT post_parent FROM $wpdb->posts WHERE ID=$postID");

	// Trim white space just in case.
	$_POST['wap8-video-embed'] = trim($_POST['wap8-video-embed']);
	$_POST['wap8-video-url'] = trim($_POST['wap8-video-url']);
	$_POST['wap8-video-width'] = trim($_POST['wap8-video-width']);
	$_POST['wap8-video-height'] = trim($_POST['wap8-video-height']);

	if ( $_POST['wap8-remove-video'] ) {
		// Remove video
		delete_post_meta($postID, '_videoembed');
		delete_post_meta($postID, '_videowidth');
		delete_post_meta($postID, '_videoheight');
		delete_post_meta($postID, '_videoembed_manual');
	}
	
	elseif ( $_POST['wap8-video-embed'] ) {
		// Save video embed code.
		if( !update_post_meta($postID, '_videoembed_manual', $_POST['wap8-video-embed'] ) )
			add_post_meta($postID, '_videoembed_manual', $_POST['wap8-video-embed'] );
		delete_post_meta($postID, '_videoembed');
		delete_post_meta($postID, '_videowidth');
		delete_post_meta($postID, '_videoheight');
	}
	
	elseif ( $_POST['wap8-video-url'] ) {
		// Save video URL.
		if( !update_post_meta($postID, '_videoembed', $_POST['wap8-video-url'] ) )
			add_post_meta($postID, '_videoembed', $_POST['wap8-video-url'] );
		delete_post_meta($postID, '_videoembed_manual');
		
		// Save width and height.
		if ( is_numeric($_POST['wap8-video-width']) ) {
			if( !update_post_meta($postID, '_videowidth', $_POST['wap8-video-width']) )
				add_post_meta($postID, '_videowidth', $_POST['wap8-video-width']);
		}
		
		else if ( empty($_POST['wap8-video-width']) )
			delete_post_meta($postID, '_videowidth');
   
		if ( is_numeric($_POST['wap8-video-height']) ) {
			if( !update_post_meta($postID, '_videoheight', $_POST['wap8-video-height']) )
				add_post_meta($postID, '_videoheight', $_POST['wap8-video-height']);
		}
		
		else if ( empty($_POST['wap8-video-height']) )
			delete_post_meta($postID, '_videoheight');
	}

}

// Settings form
function wap8_videoOptionsAdmin() {
?>
	<div class="wrap">
	<h2><?php _e( 'Portfolio Video Embedder Settings', 'wap8theme-i18n' ); ?></h2>
	
		<form method="post" action="options.php">
			<?php wp_nonce_field('update-options'); ?>
	
			<table class="form-table">
				<tr valign="top">
					<th style="white-space:nowrap;" scope="row"><label for="wap8_default_player_width"><?php _e( 'Default Player Width', 'wap8theme-i18n' ); ?>:</label></th>
					<td><input id="wap8_default_player_width" type="text" name="wap8_default_player_width" value="<?php echo get_option('wap8_default_player_width'); ?>" /></td>
					<td style="width:100%;"><?php _e( 'The default player width, if not set.', 'wap8theme-i18n' ); ?></td>
				</tr>
				<tr valign="top">
					<th style="white-space:nowrap;" scope="row"><label for="wap8_default_player_height"><?php _e( 'Default Player Height', 'wap8theme-i18n' ); ?>:</label></th>
					<td><input id="wap8_default_player_height" type="text" name="wap8_default_player_height" value="<?php echo get_option('wap8_default_player_height'); ?>" /></td>
					<td><?php _e( 'The default player height, if not set.', 'wap8theme-i18n' ); ?></td>
				</tr>
				<tr valign="top">
					<th style="white-space:nowrap;" scope="row"><label for="wap8_jw_files"><?php _e( 'Path to JW Player files', 'wap8theme-i18n' ); ?></label>:</th>
					<td><input id="wap8_jw_files" type="text" name="wap8_jw_files" value="<?php echo get_option('wap8_jw_files'); ?>" /></td>
					<td><?php _e( 'The absolute path to the JW player files.', 'wap8theme-i18n' ); ?></td>
				</tr>
				<tr valign="top">
					<th style="white-space:nowrap;" scope="row"><a href="<?php echo esc_url( __( 'http://developer.longtailvideo.com/trac/wiki/FlashVars', 'wap8theme-i18n' ) ); ?>" title="<?php _e( 'What are flashvars?', 'wap8theme-i18n' ); ?>" target="_blank"><?php _e( 'JW Player flashvars', 'wap8theme-i18n' ); ?></a>:</th>
					<td><input type="text" name="wap8_jw_flashvars" value="<?php echo get_option('wap8_jw_flashvars'); ?>" /></td>
					<td><?php _e( 'Extra parameters for JW player. For experienced users.', 'wap8theme-i18n' ); ?></td>
				</tr>
			</table>
	
			<input type="hidden" name="action" value="update" />
			<input type="hidden" name="page_options" value="wap8_default_player_width,wap8_default_player_height,wap8_jw_files,wap8_jw_flashvars" />
	
			<p class="submit">
				<input type="submit" class="button-primary" value="<?php _e( 'Save Changes', 'wap8theme-i18n' ) ?>" />
			</p>
		</form>
	</div>

<?php
}

?>
