<?php

/*
Plugin Name: Twitter Feedr
Plugin URI: http://www.wearepixel8.com
Description: A simple Twitter Feed widget that allows streaming of a designated Twitter timeline.
Version: 1.0.1
Author: We Are Pixel8
Author URI: http://www.wearepixel8.com
License:
	Copyright 2012 We Are Pixel8 <hello@wearepixel8.com>
	
	This program is free software; you can redistribute it and/or modify it under
	the terms of the GNU General Public License, version 2, as published by the Free
	Software Foundation.
	
	This program is distributed in the hope that it will be useful, but WITHOUT ANY
	WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
	PARTICULAR PURPOSE. See the GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software Foundation, Inc.,
	51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
*/

/*----------------------------------------------------------------------------*/
/* Twitter Feedr
/*----------------------------------------------------------------------------*/
 
add_action( 'widgets_init', 'wap8_twitter_feedr_widget' );

/**
 * Twitter Feedr widget.
 *
 * Register the Twitter Feedr widget.
 *
 * @package Twitter Feedr
 * @version 1.0.0
 * @since 1.0.0
 * @author Erik Ford for We Are Pixel8 <@notdivisible>
 *
 */

function wap8_twitter_feedr_widget() {
	register_widget( 'wap8_Twitter_Feedr_Widget' );
}

/*----------------------------------------------------------------------------*/
/* Extend WP_Widget by adding This Widget Class
/*----------------------------------------------------------------------------*/

class wap8_Twitter_Feedr_Widget extends WP_Widget {

	// widget setup
	function wap8_Twitter_Feedr_Widget() {
		$widget_ops = array(
			'classname'   => 'wap8_twitter_feedr_widget',
			'description' => __( 'Stream recent tweets from a designated Twitter account.', 'wap8theme-i18n' )
			);
			
		$this->WP_Widget( 'wap8-Twitter-Feedr-widget', __( 'Twitter Feedr', 'wap8theme-i18n' ), $widget_ops );
	}
	
	// widget output
	function widget( $args, $instance ) {
		
		extract( $args );
		
		// saved widget settings
		$title = apply_filters( 'widget_title', $instance['title'] );
		$twitter_user = $instance['twitter_user'];
		$tweet_count = $instance['tweet_count'];
		$tweet_rt = $instance['tweet_rt'];
		$twitter_link = $instance['twitter_link'];
		
		echo $before_widget; // echo HTML set in register_sidebar by the currently active theme
		
		if ( $title ) { // if this widget has a title
		
			echo $before_title . $title . $after_title; // display the title wrapped with the HTML set by the currently active theme
			
		}
		
		?>
			<ul id="twitter_update_list"><li><?php _e( 'Loading Tweets', 'wap8theme-i18n' ); ?></li></ul>
			
			<?php if ( $twitter_link ) { // if show twitter follow link has been set ?>
			
			<p><?php printf( __( 'Follow <a href="%1$s">@%2$s</a> on Twitter', 'wap8theme-i18n' ), esc_url( 'http://twitter.com/' ) . $twitter_user, $twitter_user ); ?></p>
			
			<?php } // end twitter follow link conditional test ?>
			
			<script type="text/javascript" src="http://twitter.com/javascripts/blogger.js"></script>
			
			<?php if ( $tweet_rt == 1 ) { // if show retweets have been set ?>
			
			<script type="text/javascript" src="http://api.twitter.com/1/statuses/user_timeline.json?screen_name=<?php echo $twitter_user; ?>&callback=twitterCallback2&count=<?php echo $tweet_count; ?>&include_rts=<?php echo $tweet_rt; ?>"></script>
			
			<?php } else { // if show retweets has not been set ?>
			
			<script type="text/javascript" src="http://api.twitter.com/1/statuses/user_timeline.json?screen_name=<?php echo $twitter_user; ?>&callback=twitterCallback2&count=<?php echo $tweet_count; ?>"></script>
			<?php } // end conditional show retweets check ?>	
		<?php		
		
		echo $after_widget;	// echo HTML set in register_sidebar by the currently active theme
	}
	
	// Update widget
	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = strip_tags( $new_instance['title'] );
		$instance['twitter_user'] = strip_tags( $new_instance['twitter_user'] );
		$instance['tweet_count'] = ( int ) $new_instance['tweet_count'];
		$instance['tweet_rt'] = isset( $new_instance['tweet_rt'] );
		$instance['twitter_link'] = isset( $new_instance['twitter_link'] );
		return $instance;
	}
	
	// Widget form
	function form( $instance ) {
		$defaults = array(
			'title'       => __( 'Twitter Feed', 'wap8theme-i18n' ),
			'tweet_count' => 5
		);
		$instance = wp_parse_args( ( array ) $instance, $defaults );

		if ( ( int ) $instance['tweet_count'] < 1 )
			( int ) $intsance['tweet_count'] = 5;
		else if ( ( int ) $instance['tweet_count'] > 10 )
			( int ) $instance['tweet_count'] = 10;

		?>
		
		<p><?php _e( 'You are only allowed one instance of this widget per page.', 'wap8theme-i18n' ); ?></p>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title', 'wap8theme-i18n' ); ?></label><br />
			<input class="widefat" type="text" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title'];?>" />
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'twitter_user' ); ?>"><?php _e( 'Username', 'wap8theme-i18n' ); ?></label><br />
			<input class="widefat" type="text" id="<?php echo $this->get_field_id( 'twitter_user' ); ?>" name="<?php echo $this->get_field_name( 'twitter_user' ); ?>" value="<?php echo $instance['twitter_user'];?>" />
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'tweet_count' ); ?>"><?php _e( 'Tweets to Show', 'wap8theme-i18n' ); ?></label>
			<input type="text" id="<?php echo $this->get_field_id( 'tweet_count' ); ?>" name="<?php echo $this->get_field_name( 'tweet_count' ); ?>" value="<?php echo $instance['tweet_count'];?>" size="3" maxlength="2" /> <small><?php _e( 'Max: 10', 'wap8theme-i18n' ); ?></small>
		</p>
		
		<p>
			<input id="<?php echo $this -> get_field_id( 'tweet_rt' ); ?>" name="<?php echo $this -> get_field_name( 'tweet_rt' ); ?>" type="checkbox" <?php checked( isset( $instance['tweet_rt'] ) ? $instance['tweet_rt'] : 0 ); ?> />&nbsp;<label for="<?php echo $this -> get_field_id( 'tweet_rt' ); ?>"><?php _e( 'Include retweets&#63;', 'wap8theme-i18n' ); ?></label>
		</p>
		
		<p>
			<input id="<?php echo $this -> get_field_id( 'twitter_link' ); ?>" name="<?php echo $this -> get_field_name( 'twitter_link' ); ?>" type="checkbox" <?php checked( isset( $instance['twitter_link'] ) ? $instance['twitter_link'] : 0 ); ?> />&nbsp;<label for="<?php echo $this -> get_field_id( 'twitter_link' ); ?>"><?php _e( 'Show follow link&#63;', 'wap8theme-i18n' ); ?></label>
		</p>

		<?php	
	}
	
}

?>
