<?php

/*
Plugin Name: Testify
Plugin URI: http://www.wearepixel8.com
Description: A widget that will display testimonials in a jQuery slideshow.
Version: 1.0.0
Author: We Are Pixel8
Author URI: http://www.wearepixel8.com
License:
	Copyright 2012 We Are Pixel8 <hello@wearepixel8.com>
	
	This program is free software; you can redistribute it and/or modify it under
	the terms of the GNU General Public License, version 2, as published by the Free
	Software Foundation.
	
	This program is distributed in the hope that it will be useful, but WITHOUT ANY
	WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
	PARTICULAR PURPOSE. See the GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software Foundation, Inc.,
	51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
*/

/*----------------------------------------------------------------------------*/
/* Testify
/*----------------------------------------------------------------------------*/
 
add_action( 'widgets_init', 'wap8_testify_widget' );

/**
 * Testify widget
 *
 * Register the Testify widget.
 *
 * @package Testify
 * @version 1.0.0
 * @since 1.0.0
 * @author Erik Ford for We Are Pixel8 <@notdivisible>
 *
 */

function wap8_Testify_widget() {
	register_widget( 'wap8_Testify_Widget' );
}

/*----------------------------------------------------------------------------*/
/* Extend WP_Widget by adding This Widget Class
/*----------------------------------------------------------------------------*/

class wap8_Testify_Widget extends WP_Widget {

	// widget setup
	function wap8_Testify_Widget() {
		$widget_ops = array(
			'classname'   => 'wap8_testify_widget',
			'description' => __( 'Display up to three testimonials in a jQuery slideshow.', 'wap8theme-i18n' )
			);
			
		$control_ops = array(
			'width'  => 400,
			'height' => 350
			);
			
		$this->WP_Widget( 'wap8-testify-widget', __( 'Testify', 'wap8theme-i18n' ), $widget_ops, $control_ops );	
	}
	
	// widget output
	function widget( $args, $instance ) {
		
		extract( $args );
		
		$title = apply_filters( 'widget_title', $instance['title'] );
		$speed = $instance['sliderspeed'];
		$timeout = $instance['slidertimeout'];
		$kudos_a = $instance['kudosa'];
		$client_a = $instance['clienta'];
		$kudos_b = $instance['kudosb'];
		$client_b = $instance['clientb'];
		$kudos_c = $instance['kudosc'];
		$client_c = $instance['clientc'];
		
		echo $before_widget;
		
		if ( $title ) {
			echo $before_title . $title . $after_title;
		}
		
		?>
		
		<script type="text/javascript">
		(function($) {
			$(document).ready(function() {
				$('.testimonials-container').cycle({
					fx:            'fade',
					prev:          '.testimonial-controls .slide-controls-previous',
					next:          '.testimonial-controls .slide-controls-next',
					speed:         <?php echo $speed; ?>,
					cleartypeNoBg: true,
					timeout:       <?php echo $timeout; ?>
				});
			});
		})(jQuery);
		</script>
		
		<ul class="slide-controls testimonial-controls clear">
			<li><a class="slide-controls-next" href="#" title="<?php _e( 'Next Testimonial', 'wap8theme-i18n' ); ?>"><?php _e( 'Next Testimonial', 'wap8theme-i18n' ); ?></a></li>
			<li><a class="slide-controls-previous" href="#" title="<?php _e( 'Previous Testimonial', 'wap8theme-i18n' ); ?>"><?php _e( 'Previous Testimonial', 'wap8theme-i18n' ); ?></a></li>
		</ul>
		
		<div class="testimonials-container">
			<?php if ( $kudos_a ) { ?>
			<div class="client-testimonial">
				<blockquote>
					<p><?php echo esc_html( $kudos_a ); ?></p>
					<p class="quote-author">&#151; <?php echo esc_html( $client_a ); ?></p>
				</blockquote>
			</div>
			<?php }
			
			if ( $kudos_b ) { ?>
			<div class="client-testimonial">
				<blockquote>
					<p><?php echo esc_html( $kudos_b ); ?></p>
					<p class="quote-author">&#151; <?php echo esc_html( $client_b ); ?></p>
				</blockquote>
			</div>
			<?php }
			
			if ( $kudos_c ) { ?>
			<div class="client-testimonial">
				<blockquote>
					<p><?php echo esc_html( $kudos_c ); ?></p>
					<p class="quote-author">&#151; <?php echo esc_html( $client_c ); ?></p>
				</blockquote>
			</div>
			<?php } ?>
		</div>
		
		<?php
		
		echo $after_widget;
		
	}
	
	// Update widget
	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = strip_tags( $new_instance['title'] );
		$instance['sliderspeed'] = (int) $new_instance['sliderspeed'];
		$instance['slidertimeout'] = (int) $new_instance['slidertimeout'];
		$instance['kudosa'] = strip_tags( $new_instance['kudosa'] );
		$instance['clienta'] = strip_tags( $new_instance['clienta'] );
		$instance['kudosb'] = strip_tags( $new_instance['kudosb'] );
		$instance['clientb'] = strip_tags( $new_instance['clientb'] );
		$instance['kudosc'] = strip_tags( $new_instance['kudosc'] );
		$instance['clientc'] = strip_tags( $new_instance['clientc'] );
		
		return $instance;
	}
	
	// Widget form
	function form( $instance ) {
		$defaults = array(
			'title' => __( 'Client Testimonials', 'wap8theme-i18n' ),
			'sliderspeed' => 300,
			'slidertimeout' => 0
		);
		$instance = wp_parse_args( ( array ) $instance, $defaults );
		
		?>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title', 'wap8theme-i18n' ); ?></label><br />
			<input class="widefat" type="text" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title'];?>" />
		</p>
		
		<p><?php _e( 'For each testimonial to appear, in this widget, you must enter the quotation and the author. Due to limited spacing, please be as brief as possible.', 'wap8theme-i18n' ); ?></p>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'sliderspeed' ); ?>"><?php _e( 'Animation Speed', 'wap8theme-i18n' ); ?></label>
			<input type="text" id="<?php echo $this->get_field_id( 'sliderspeed' ); ?>" name="<?php echo $this->get_field_name( 'sliderspeed' ); ?>" value="<?php echo $instance['sliderspeed'];?>" size="4" maxlength="4" /> <small><?php _e( 'In milliseconds', 'wap8theme-i18n' ); ?></small>
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'slidertimeout' ); ?>"><?php _e( 'Time between slides', 'wap8theme-i18n' ); ?></label>
			<input type="text" id="<?php echo $this->get_field_id( 'slidertimeout' ); ?>" name="<?php echo $this->get_field_name( 'slidertimeout' ); ?>" value="<?php echo $instance['slidertimeout'];?>" size="4" maxlength="4" /> <small><?php _e( 'In milliseconds. 0 = no auto animation', 'wap8theme-i18n' ); ?></small>
		</p>		
		
		<p>
			<label for="<?php echo $this->get_field_id( 'clienta' ); ?>"><?php _e( 'Client 1', 'wap8theme-i18n' ); ?></label><br />
			<input class="widefat" type="text" id="<?php echo $this->get_field_id( 'clienta' ); ?>" name="<?php echo $this->get_field_name( 'clienta' ); ?>" value="<?php echo $instance['clienta'];?>" />
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'kudosa' ); ?>"><?php _e( 'Testimonial 1', 'wap8theme-i18n' ); ?></label><br />
			<textarea class="widefat" rows="3" cols="20" id="<?php echo $this->get_field_id( 'kudosa' ); ?>" name="<?php echo $this->get_field_name( 'kudosa' ); ?>"><?php echo $instance['kudosa']; ?></textarea>
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'clientb' ); ?>"><?php _e( 'Client 2', 'wap8theme-i18n' ); ?></label><br />
			<input class="widefat" type="text" id="<?php echo $this->get_field_id( 'clientb' ); ?>" name="<?php echo $this->get_field_name( 'clientb' ); ?>" value="<?php echo $instance['clientb'];?>" />
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'kudosb' ); ?>"><?php _e( 'Testimonial 2', 'wap8theme-i18n' ); ?></label><br />
			<textarea class="widefat" rows="3" cols="20" id="<?php echo $this->get_field_id( 'kudosb' ); ?>" name="<?php echo $this->get_field_name( 'kudosb' ); ?>"><?php echo $instance['kudosb']; ?></textarea>
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'clientc' ); ?>"><?php _e( 'Client 3', 'wap8theme-i18n' ); ?></label><br />
			<input class="widefat" type="text" id="<?php echo $this->get_field_id( 'clientc' ); ?>" name="<?php echo $this->get_field_name( 'clientc' ); ?>" value="<?php echo $instance['clientc'];?>" />
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'kudosc' ); ?>"><?php _e( 'Testimonial 3', 'wap8theme-i18n' ); ?></label><br />
			<textarea class="widefat" rows="3" cols="20" id="<?php echo $this->get_field_id( 'kudosc' ); ?>" name="<?php echo $this->get_field_name( 'kudosc' ); ?>"><?php echo $instance['kudosc']; ?></textarea>
		</p>
		
		<?php
		
	}		
	
}

?>
