<?php

/*
Plugin Name: Tabbr
Plugin URI: http://www.wearepixel8.com
Description: A widget that will display tabbed content for popular posts, recent posts and popular tags.
Version: 1.0.0
Author: We Are Pixel8
Author URI: http://www.wearepixel8.com
License:
	Copyright 2012 We Are Pixel8 <hello@wearepixel8.com>
	
	This program is free software; you can redistribute it and/or modify it under
	the terms of the GNU General Public License, version 2, as published by the Free
	Software Foundation.
	
	This program is distributed in the hope that it will be useful, but WITHOUT ANY
	WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
	PARTICULAR PURPOSE. See the GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software Foundation, Inc.,
	51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
*/

/*----------------------------------------------------------------------------*/
/* Tabbr
/*----------------------------------------------------------------------------*/
 
add_action( 'widgets_init', 'wap8_tabbr_widget' );

/**
 * Tabbr widget
 *
 * Register the Tabbr widget.
 *
 * @package Tabbr
 * @version 1.0.0
 * @since 1.0.0
 * @author Erik Ford for We Are Pixel8 <@notdivisible>
 *
 */

function wap8_tabbr_widget() {
	register_widget( 'wap8_Tabbr_Widget' );
}

/*----------------------------------------------------------------------------*/
/* Extend WP_Widget by adding This Widget Class
/*----------------------------------------------------------------------------*/

class wap8_Tabbr_Widget extends WP_Widget {

	// widget setup
	function wap8_Tabbr_Widget() {
		$widget_ops = array(
			'classname'   => 'wap8_tabbr_widget',
			'description' => __( 'Display a tabbed content widget for your popular posts, recent posts and popular tags.', 'wap8theme-i18n' )
			);
			
		$this->WP_Widget( 'wap8-tabbr-widget', __( 'Tabbr', 'wap8theme-i18n' ), $widget_ops );	
	}
	
	// widget output
	function widget( $args, $instance ) {
		
		extract( $args );
		
		$postcount = $instance['postcount'];
		$tagcount = $instance['tagcount'];
				
		echo $before_widget;
		
		?>

		<div id="tab-container"><!-- Begin #tab-container -->
			<ul class="tab-nav clear">
				<li><a href="#popular" title="<?php _e( 'Popular', 'wap8theme-i18n' ); ?>"><?php _e( 'Popular', 'wap8theme-i18n' ); ?></a></li>
				<li><a href="#recent" title="<?php _e( 'Recent', 'wap8theme-i18n' ); ?>"><?php _e( 'Recent', 'wap8theme-i18n' ); ?></a></li>
				<li><a href="#tags" title="<?php _e( 'Tags', 'wap8theme-i18n' ); ?>"><?php _e( 'Tags', 'wap8theme-i18n' ); ?></a></li>
			</ul>
	
			<div id="popular" class="tab-body"><!-- Begin popular posts -->
				<ol>
				
				<?php
					$myquery = array(
						'numberposts' => $postcount,
						'orderby'     => 'comment_count',
						'order'       => 'DESC',
						'post_type'   => 'post',
						'post_status' => 'publish'
					);
				
					$mypopular = get_posts( $myquery );
		
					foreach( $mypopular as $post ) {
					setup_postdata( $post );
   					$postid = $post->ID;
   					$posttitle = $post->post_title;
   					$commentcount = $post->comment_count;
				?>
					<?php if ( $commentcount != 0 ) : ?>							
					<li>
						<a href="<?php echo get_permalink( $postid ); ?>" title="<?php echo __( 'Permanent link to ', 'wap8theme-i18n' ) . $posttitle; ?>" rel="bookmark"><?php echo $posttitle; ?></a>
						<span><?php echo $commentcount; ?><?php if ( $commentcount > 1 ) { ?><?php _e( ' Comments', ' wap8theme-i18n' ); ?><?php } else { ?><?php _e( ' Comment', ' wap8theme-i18n' ); ?><?php } ?></span>	
					</li>
					<?php endif; ?>
				<?php } ?>

				</ol>
			</div><!-- End popular posts -->
	
			<div id="recent" class="tab-body"><!-- Begin recent posts -->
				<ol>
					<?php $recent_articles = new WP_Query( 'orderby=post_date&order=DESC&ignore_sticky_posts=1&post_type=post&posts_per_page=' . $postcount );
					while ( $recent_articles->have_posts() ) : $recent_articles->the_post(); ?>
					<li>
						<?php the_title( '<a href="' . get_permalink() . '" title="' . the_title_attribute( array( 'before' => __( 'Permanent link to ', 'wap8theme-i18n' ), 'echo' => 0 ) ) . '" rel="bookmark">', '</a>' ); ?>
						<span><?php the_time( get_option( 'date_format' ) ); ?></span>						
					</li>
					<?php endwhile; wp_reset_query(); ?>
				</ol>
			</div><!-- End recent posts -->
	
			<div id="tags" class="tab-body"><!-- Begin tags -->
				<?php wp_tag_cloud( 'smallest=11&largest=11&format=list&unit=px&orderby=count&order=ASC&number=' . $tagcount ); ?>
			</div><!-- End tags -->
		</div><!-- End #tab-container -->
		
		<?php
		
		echo $after_widget;	
		
	}
	
	// Update widget
	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['postcount'] = ( int ) $new_instance['postcount'];
		$instance['tagcount'] = ( int ) $new_instance['tagcount'];
		return $instance;
	}
	
	// Widget form
	function form( $instance ) {

		if ( ( int ) $instance['postcount'] < 1 )
			( int ) $intsance['postcount'] = 5;
		else if ( ( int ) $instance['postcount'] > 20 )
			( int ) $instance['postcount'] = 20;
			
		if ( ( int ) $instance['tagcount'] < 1 )
			( int ) $intsance['tagcount'] = 10;
		else if ( ( int ) $instance['tagcount'] > 50 )
			( int ) $instance['tagcount'] = 50;
			
		?>
		
		<p><?php _e( 'Use this widget to display Popular Posts, Recent Posts and Popular Tags, in a jQuery tabbed format, in your sidebar. You will be able to set how many posts and tags to display.', 'wap8theme-i18n' ); ?></p>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'postcount' ); ?>"><?php _e( 'Posts to Show', 'wap8theme-i18n' ); ?></label>
			<input type="text" id="<?php echo $this->get_field_id( 'postcount' ); ?>" name="<?php echo $this->get_field_name( 'postcount' ); ?>" value="<?php echo $instance['postcount'];?>" size="3" maxlength="2" /> <small><?php _e( 'Max: 20', 'wap8theme-i18n' ); ?></small>
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'tagcount' ); ?>"><?php _e( 'Tags to Show', 'wap8theme-i18n' ); ?></label>
			<input type="text" id="<?php echo $this->get_field_id( 'tagcount' ); ?>" name="<?php echo $this->get_field_name( 'tagcount' ); ?>" value="<?php echo $instance['tagcount'];?>" size="3" maxlength="2" /> <small><?php _e( 'Max: 50', 'wap8theme-i18n' ); ?></small>
		</p>
		
		<?php
			
	}		
	
}

?>
