<?php

/*
Plugin Name: Custom Meta Boxes
Plugin URI: http://www.wearepixel8.com
Description: A simple plugin that will add custom meta boxes to specific post editor screens.
Version: 1.0.0
Author: We Are Pixel8
Author URI: http://www.wearepixel8.com
License:
	Copyright 2012 We Are Pixel8 <hello@wearepixel8.com>
	
	This program is free software; you can redistribute it and/or modify it under
	the terms of the GNU General Public License, version 2, as published by the Free
	Software Foundation.
	
	This program is distributed in the hope that it will be useful, but WITHOUT ANY
	WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
	PARTICULAR PURPOSE. See the GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software Foundation, Inc.,
	51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
*/

/*----------------------------------------------------------------------------*/
/* Artisan Creatif Post Meta Boxes
/*----------------------------------------------------------------------------*/

add_action( 'add_meta_boxes', 'wap8_artisancreatif_post_meta_boxes' );

/**
 * Artisan Creatif Post Meta Boxes
 *
 * Add all meta boxes to specific post editor screens using add_meta_box.
 *
 * @package Artisan Creatif
 * @version 2.0.0
 * @since 2.0.0
 * @author Erik Ford for We Are Pixel8 <@notdivisible>
 *
 */

function wap8_artisancreatif_post_meta_boxes() {

	// add the meta boxes to the post editor screen
	add_meta_box( 'wap8-portfolio-client-mb', __( 'Client Info', 'wap8theme-i18n' ), 'wap8_portfolio_client_mb_cb', 'portfolio', 'side', 'high' );
	add_meta_box( 'wap8-portfolio-gallery-mb', __( 'Portfolio Gallery Type', 'wap8theme-i18n' ), 'wap8_portfolio_gallery_mb_cb', 'portfolio', 'side', 'default' );
	add_meta_box( 'wap8-portfolio-related-mb', __( 'Related Case Studies', 'wap8theme-i18n' ), 'wap8_portfolio_related_mb_cb', 'portfolio', 'side', 'default' );
	add_meta_box( 'wap8-audio-meta', __( 'Audio Files', 'wap8theme-i18n' ), 'wap8_audio_mb_cb', 'portfolio', 'normal', 'low' );
	
}

/*----------------------------------------------------------------------------*/
/* Portfolio Client Meta Box Callback
/*----------------------------------------------------------------------------*/

/**
 * Portfolio Client Meta Box Callback
 *
 * Render a sidebar meta box to save client name.
 *
 * @param $post
 *
 * @package Artisan Creatif
 * @version 2.0.0
 * @since 2.0.0
 * @author Erik Ford for We Are Pixel8 <@notdivisible>
 *
 */

function wap8_portfolio_client_mb_cb( $post ) {
	
	// saved meta data
	$client = get_post_meta( $post->ID, 'wap8_client_name', true );
	
	// nonce to verify intention later
	wp_nonce_field( 'wap8_save_artisancreatif_post_meta', 'wap8_artisancreatif_post_meta_nonce' );
	
	?>
	
	<p>
		<label for="wap8-client-name"><?php _e( 'Client Name', 'wap8theme-i18n' ); ?></label><br />
		<input type="text" id="wap8-client-name" name="wap8_client_name" size="30" value="<?php echo esc_html( $client ); ?>" />
	</p>
	
	<p><?php _e( 'Leave this field blank, if you do not wish to display the client name.', 'wap8theme-i18n' ); ?></p>
	
	<?php
	
}

/*----------------------------------------------------------------------------*/
/* Portfolio Gallery Type Meta Box Callback
/*----------------------------------------------------------------------------*/

/**
 * Portfolio Gallery Type Meta Box Callback
 *
 * Render a sidebar meta box to save portfolio gallery type.
 *
 * @param $post
 *
 * @package Artisan Creatif
 * @version 2.0.0
 * @since 2.0.0
 * @author Erik Ford for We Are Pixel8 <@notdivisible>
 *
 */

function wap8_portfolio_gallery_mb_cb( $post ) {

	// saved meta data
	$gallery_type = get_post_meta( $post->ID, 'wap8_gallery_type', true );
	
	// nonce to verify intention later
	wp_nonce_field( 'wap8_save_artisancreatif_post_meta', 'wap8_artisancreatif_post_meta_nonce' );
	
	?>
	
	<input id="wap8-portfolio-gallery-audio" name="wap8_gallery_type" type="radio" value="audio" <?php checked( $gallery_type, 'audio' ); ?> />
	<label for="wap8-portfolio-gallery-audio"><?php _e( 'Audio', 'wap8theme-i18n' ); ?></label><br />
	
	<input id="wap8-portfolio-gallery-featured" name="wap8_gallery_type" type="radio" value="featured" <?php checked( $gallery_type, 'featured' ); ?> />
	<label for="wap8-portfolio-gallery-featured"><?php _e( 'Featured Image', 'wap8theme-i18n' ); ?></label><br />
	
	<input id="wap8-portfolio-gallery-slider" name="wap8_gallery_type" type="radio" value="slider" <?php checked( $gallery_type, 'slider' ); ?> />
	<label for="wap8-portfolio-gallery-slider"><?php _e( 'Slider', 'wap8theme-i18n' ); ?></label><br />
	
	<input id="wap8-portfolio-gallery-stacked" name="wap8_gallery_type" type="radio" value="stacked" <?php checked( $gallery_type, 'stacked' ); ?> />
	<label for="wap8-portfolio-gallery-stacked"><?php _e( 'Stacked Images', 'wap8theme-i18n' ); ?></label><br />
	
	<input id="wap8-portfolio-gallery-video" name="wap8_gallery_type" type="radio" value="video" <?php checked( $gallery_type, 'video' ); ?> />
	<label for="wap8-portfolio-gallery-video"><?php _e( 'Video', 'wap8theme-i18n' ); ?></label>
	
	<?php

}

/*----------------------------------------------------------------------------*/
/* Portfolio Related Case Studies Meta Box Callback
/*----------------------------------------------------------------------------*/

/**
 * Portfolio Related Case Studies Meta Box Callback
 *
 * Render a sidebar meta box to save related case studies setting.
 *
 * @param $post
 *
 * @package Artisan Creatif
 * @version 2.0.0
 * @since 2.0.0
 * @author Erik Ford for We Are Pixel8 <@notdivisible>
 *
 */

function wap8_portfolio_related_mb_cb( $post ) {
	
	// saved meta data
	$case_study = get_post_meta( $post->ID, 'wap8_portfolio_related_case', true );
	$case_study_heading = get_post_meta( $post->ID, 'wap8_heading_related_case', true );
	
	// nonce to verify intention later
	wp_nonce_field( 'wap8_save_artisancreatif_post_meta', 'wap8_artisancreatif_post_meta_nonce' );
	
	?>
	
	<input id="wap8-portfolio-related-yes" name="wap8_portfolio_related_case" type="radio" value="yes" <?php checked( $case_study, 'yes' ); ?> />
	<label for="wap8-portfolio-related-yes"><?php _e( 'Yes', 'wap8theme-i18n' ); ?></label><br />
	
	<input id="wap8-portfolio-related-no" name="wap8_portfolio_related_case" type="radio" value="no" <?php checked( $case_study, 'no' ); ?> />
	<label for="wap8-portfolio-related-no"><?php _e( 'No', 'wap8theme-i18n' ); ?></label><br />
	
	<p>
		<label for="wap8-heading-related-case"><?php _e( 'Related Case Study Heading', 'wap8theme-i18n' ); ?></label><br />
		<input type="text" id="wap8-heading-related-case" name="wap8_heading_related_case" size="30" value="<?php echo esc_html( $case_study_heading ); ?>" />
	</p>
	
	<?php
	
}

/*----------------------------------------------------------------------------*/
/* Audio Meta Box Callback
/*----------------------------------------------------------------------------*/

/**
 * Audio Meta Box Callback
 *
 * Render a meta box, below the editor, to save audio files.
 *
 * @param $post
 *
 * @package Artisan Creatif
 * @version 1.1.2
 * @since 2.0.0
 * @author Erik Ford for We Are Pixel8 <@notdivisible>
 *
 */

function wap8_audio_mb_cb( $post ) {

	// Store the saved values
	$audio_cover = get_post_meta( $post->ID, '_wap8_audio_cover', true );
	$audio = get_post_meta( $post->ID, '_wap8_audio_file', true );
	$audio_m4a = get_post_meta( $post->ID, '_wap8_audio_m4a_file', true );
	$audio_ogg = get_post_meta( $post->ID, '_wap8_audio_ogg_file', true );

	// nonce to verify intention later
	wp_nonce_field( 'wap8_save_artisancreatif_post_meta', 'wap8_artisancreatif_post_meta_nonce' );

	?>
	
	<p>
		<input id="wap8-audio-cover" name="_wap8_audio_cover" type="checkbox" <?php checked( isset( $audio_cover ) ? $audio_cover : 0 ); ?> />&nbsp;<label for="wap8-audio-cover"><?php _e( 'Use featured image on case study page', 'wap8theme-i18n' ); ?></label>
	</p>
	
	<p>
		<label for="wap8-audio-file"><?php _e( 'MP3 Audio File', 'wap8theme-i18n' ); ?></label><br />
		<input type="text" id="wap8-audio-file" style=" width: 400px;" name="_wap8_audio_file" value="<?php echo esc_url( $audio ); ?>" />
		<span style="margin-top: 5px; display: block;"><?php _e( '<strong>Important</strong>: Paste the URL of your MP3. If you are using a M4A audio file, leave this field blank.', 'wap8theme-i18n' ); ?></span>
	</p>
	
	<p>
		<label for="wap8-audio-m4a-file"><?php _e( 'M4A Audio File', 'wap8theme-i18n' ); ?></label><br />
		<input type="text" id="wap8-audio-m4a-file" style=" width: 400px;" name="_wap8_audio_m4a_file" value="<?php echo esc_url( $audio_m4a ); ?>" />
		<span style="margin-top: 5px; display: block;"><?php _e( '<strong>Important</strong>: Paste the URL of your M4A. If you are using a MP3 audio file, leave this field blank.', 'wap8theme-i18n' ); ?></span>
	</p>
	
	<p>
		<label for="wap8-audio-ogg-file"><?php _e( 'OGG Audio File', 'wap8theme-i18n' ); ?></label><br />
		<input type="text" id="wap8-audio-ogg-file" style=" width: 400px;" name="_wap8_audio_ogg_file" value="<?php echo esc_url( $audio_ogg ); ?>" />
		<span style="margin-top: 5px; display: block;"><?php _e( '<strong>Optional</strong>: For ultimate cross browser compatibility and functionality, we recommend including an OGG version of your audio file.', 'wap8theme-i18n' ); ?></span>
	</p>

	<?php

}

/*----------------------------------------------------------------------------*/
/* Save Meta Boxes
/*----------------------------------------------------------------------------*/

add_action( 'save_post', 'wap8_save_artisan_creatif_post_mb' );

/**
 * Save Artisan Creatif Post Meta Boxes
 *
 * Save and sanitize the post meta boxes.
 *
 * @param $id
 *
 * @package Artisan Creatif
 * @version 2.0.0
 * @since 2.0.0
 * @author Erik Ford for We Are Pixel8 <@notdivisible>
 *
 */

function wap8_save_artisan_creatif_post_mb( $id ) {
	
	// we do not want to auto save the data
	if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) return; 

	// check our nonce
	if ( !isset( $_POST['wap8_artisancreatif_post_meta_nonce'] ) || !wp_verify_nonce( $_POST['wap8_artisancreatif_post_meta_nonce'], 'wap8_save_artisancreatif_post_meta' ) ) return;

	// Make sure the current user can edit the post
	if ( !current_user_can( 'edit_post' ) ) return;
	
	// strip all tags and escape HTML before saving client name
	if ( isset( $_POST['wap8_client_name'] ) )
		update_post_meta( $id, 'wap8_client_name', wp_strip_all_tags( esc_html( $_POST['wap8_client_name'] ) ) );
	
	// save portfolio gallery type radio button
	update_post_meta( $id, 'wap8_gallery_type', $_POST['wap8_gallery_type'] );
	
	// save related case studies radio button
	update_post_meta( $id, 'wap8_portfolio_related_case', $_POST['wap8_portfolio_related_case'] );
	
	// strip all tags and escape HTML before related case studies heading
	if ( isset( $_POST['wap8_heading_related_case'] ) )
		update_post_meta( $id, 'wap8_heading_related_case', wp_strip_all_tags( esc_html( $_POST['wap8_heading_related_case'] ) ) );
		
	// save audio file poster image checkbox
	$chk = isset( $_POST['_wap8_audio_cover'] ) && $_POST['_wap8_audio_cover'] ? 1 : 0;
	update_post_meta( $id, '_wap8_audio_cover', $chk );

	// save mp3 file URL
	if( isset( $_POST['_wap8_audio_file'] ) )
		update_post_meta( $id, '_wap8_audio_file', esc_url_raw( $_POST['_wap8_audio_file'] ) );
		
	// save m4a file URL
	if( isset( $_POST['_wap8_audio_m4a_file'] ) )
		update_post_meta( $id, '_wap8_audio_m4a_file', esc_url_raw( $_POST['_wap8_audio_m4a_file'] ) );
		
	// save oga file URL
	if( isset( $_POST['_wap8_audio_ogg_file'] ) )
		update_post_meta( $id, '_wap8_audio_ogg_file', esc_url_raw( $_POST['_wap8_audio_ogg_file'] ) );
			
}

?>
