<?php

/*
Plugin Name: Contact
Plugin URI: http://www.wearepixel8.com
Description: A widget to display contact information.
Version: 1.0.1
Author: We Are Pixel8
Author URI: http://www.wearepixel8.com
License:
	Copyright 2012 We Are Pixel8 <hello@wearepixel8.com>
	
	This program is free software; you can redistribute it and/or modify it under
	the terms of the GNU General Public License, version 2, as published by the Free
	Software Foundation.
	
	This program is distributed in the hope that it will be useful, but WITHOUT ANY
	WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
	PARTICULAR PURPOSE. See the GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software Foundation, Inc.,
	51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
*/

/*----------------------------------------------------------------------------*/
/* Contact Widget
/*----------------------------------------------------------------------------*/

add_action( 'widgets_init', 'wap8_contact_widget' );

/**
 * Contact widget
 *
 * Register the Contact widget.
 *
 * @package Contact
 * @version 1.0.0
 * @since 1.0.1 Fixed Twitter link
 * @author Erik Ford for We Are Pixel8 <@notdivisible>
 *
 */

function wap8_contact_widget() {
	register_widget( 'wap8_Contact_Widget' );
}

/*----------------------------------------------------------------------------*/
/* Extend WP_Widget by adding This Widget Class
/*----------------------------------------------------------------------------*/

class wap8_Contact_Widget extends WP_Widget {

	// widget setup
	function wap8_Contact_Widget() {
		$widget_ops = array(
			'classname'   => 'wap8_contact_widget',
			'description' => __( 'Display your contact information.', 'wap8theme-i18n' )
			);
			
		$control_ops = array(
			'width'  => 400,
			'height' => 350
			);
			
		$this->WP_Widget( 'wap8-Contact-widget', __( 'Contact', 'wap8theme-i18n' ), $widget_ops, $control_ops );	
	}
	
	// widget output
	function widget( $args, $instance ) {
		
		extract($args);
		
		$title = apply_filters( 'widget_title', $instance['title'] );
		$text = apply_filters( 'widget_text', $instance['text'] );
		$quickcontact = $instance['quick_contact'];
		
		echo $before_widget;
		
		if ( $title ) {
			echo $before_title . $title . $after_title;	
		}
		
		?>
		
		<div class="widget-address">
			<?php
			
				echo $text;
			
				if ( $quickcontact == '1' ) :	
			?>
			
				<ul>
					<?php if ( of_get_option( 'artisan_phone' ) != '' ) { ?><li class="ac-phone"><?php echo esc_html( of_get_option( 'artisan_phone' ) ); ?></li><?php } ?>
					<?php if ( of_get_option( 'artisan_email' ) != '' ) { ?><li class="ac-email"><a class="emailaddy"><?php echo esc_html( of_get_option( 'artisan_email' ) ); ?></a></li><?php } ?>
					<?php if ( of_get_option( 'artisan_twitter' ) != '' ) { ?><li class="ac-twitter"><a href="<?php echo esc_url( 'http://twitter.com/' ) . esc_attr( of_get_option( 'artisan_twitter' ) ); ?>">&#64;<?php echo esc_html( of_get_option( 'artisan_twitter' ) ); ?></a></li><?php } ?>
					<?php if ( of_get_option( 'artisan_facebook' ) != '' ) { ?><li class="ac-facebook"><a href="<?php echo esc_url( of_get_option( 'artisan_facebook' ) ); ?>"><?php _e( 'Facebook', 'wap8theme-i18n' ); ?></a></li><?php } ?>
				</ul>
			
			<?php endif; ?>
		</div>
	
		<?php		
		
		echo $after_widget;		
	}
	
	// update widget
	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = strip_tags( $new_instance['title'] );
		$instance['text'] = $new_instance['text'];
		$instance['quick_contact'] = isset( $new_instance['quick_contact'] );
		return $instance;
	}
	
	// widget form
	function form( $instance ) {
		$defaults = array(
			'title' => __( 'Your Name', 'wap8theme-i18n' )
		);
		$text = esc_textarea( $instance['text'] );
		$instance = wp_parse_args( ( array ) $instance, $defaults );

		?>
		
		<p><?php _e( 'Use this widget to display your contact information. The <code>textarea</code> will process arbitrary HTML.', 'wap8theme-i18n' ); ?></p>
		
		<p><strong><?php _e( 'Example Address Entry:', 'wap8theme-i18n' ); ?></strong></p>
		
		<p><small><code><?php _e( '&lt;p&gt;7510 Sunsent Boulevard, Suite 1421&lt;br /&gt;Hollywood, CA 90046&lt;br/&gt;United States&lt;/p&gt;', 'wap8theme-i18n' ); ?></code></small></p>

		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Your Name', 'wap8theme-i18n' ); ?></label><br />
			<input class="widefat" type="text" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title'];?>" />
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'text' ); ?>"><?php _e( 'Address', 'wap8theme-i18n' ); ?></label><br />
			<textarea class="widefat" rows="3" cols="20" id="<?php echo $this->get_field_id( 'text' ); ?>" name="<?php echo $this->get_field_name( 'text' ); ?>"><?php echo $instance['text']; ?></textarea>
		</p>
		
		<p>
			<input id="<?php echo $this->get_field_id( 'quick_contact' ); ?>" name="<?php echo $this->get_field_name( 'quick_contact' ); ?>" type="checkbox" <?php checked( isset($instance['quick_contact'] ) ? $instance['quick_contact'] : 0); ?> />&nbsp;<label for="<?php echo $this->get_field_id( 'quick_contact' ); ?>"><?php _e( 'Display your Quick Contacts', 'wap8theme-i18n' ); ?></label>
		</p>

		<?php	
	}
	
}

?>
