jQuery(document).ready(function() {

	// Anchor scrolling
	jQuery('.scroll-it').click(function(event){
		
		// Prevent the default action for the click event
		event.preventDefault();

		// Get the full url - like mysitecom/index.htm#home
		var full_url = this.href;

		// Split the url by # and get the anchor target name - home in mysitecom/index.htm#home
		var parts = full_url.split('#');
		var trgt = parts[1];

		// Get the top offset of the target anchor
		var target_offset = jQuery('#'+trgt).offset();
		var target_top = target_offset.top;

		// Go to that anchor by setting the body scroll top to anchor top
		jQuery('html, body').animate({scrollTop:target_top}, 500);
	});

	// No spam, please
	jQuery('a.emailaddy').each(function(i) {
		var text = jQuery(this).text();
		var address = text.replace(' at ', '@');
		jQuery(this).attr('href', 'mailto:' + address);
			jQuery(this).text(address);
	});

	// Toggle quick contact bar
	jQuery('.hide-quick-contact').click(function() {
		jQuery('#quick-contact').slideToggle({
			speed:	300,
			easing:	'easeOutBounce'
		});
		jQuery(this).toggleClass('show-quick-contact');
		return false;
	});
	
	// Scroll to top
	jQuery('.scroll-top').click(function() {
		jQuery('html, body').animate({scrollTop:0});
		return false;
	});
	
	// Toggle home page portfolio info
	jQuery('.close-info').toggle(function() {
		jQuery('.portfolio-meta').stop().animate({marginLeft:'-460px'},{queue:false,duration:300});
		jQuery(this).addClass('open-info');
		}, function() {
		jQuery('.portfolio-meta').stop().animate({marginLeft:0},{queue:false,duration:300});
		jQuery(this).removeClass('open-info');
	});
	
	// Home page large portfolio slider
    jQuery('#home-large-slides').cycle({
		fx:					'fade',
		prev:				'.portfolio-controls .slide-controls-previous',
		next:				'.portfolio-controls .slide-controls-next',
		speed:				300,
		cleartypeNoBg:		true,
		timeout:			6000,
		pause:				true
	});
	
	// Toggle home page large portfolio slider
	jQuery('.portfolio-controls .slide-controls-toggler').click(function() {
		jQuery('#home-large-slides').slideToggle(300);
		jQuery(this).toggleClass('show-slider');
		return false;
	});
	
	// Home page small portfolio slider
    jQuery('#home-small-slides').cycle({
		fx:					'fade',
		prev:				'.sm-portfolio-controls .slide-controls-previous',
		next:				'.sm-portfolio-controls .slide-controls-next',
		speed:				300,
		cleartypeNoBg:		true,
		timeout:			6000,
		pause:				true
	});
	
	// Toggle home page small portfolio slider
	jQuery('.sm-portfolio-controls .slide-controls-toggler').click(function() {
		jQuery('#home-small-slides').slideToggle(300);
		jQuery(this).toggleClass('show-slider');
		return false;
	});
	
	// Archive thumbnail fade effects
	jQuery('.archivethumblink-460').hover(function() { // Thumbnail 460px x 280px
		jQuery(this).stop().animate({opacity:0},{queue:false,duration:300});
		}, function() {  
		jQuery(this).stop().animate({opacity:1},{queue:false,duration:300});
	});
	
	// Portfolio thumbnail fade effects
	jQuery('.grid-thumb').hover(function() {
		jQuery(this).stop().animate({opacity:0},{queue:false,duration:300});
		}, function() {  
		jQuery(this).stop().animate({opacity:1},{queue:false,duration:300});
	});
	
	// Animate grid portfolio
	jQuery('.grid-portfolio').delegate('.grid-portfolio li', 'mouseover mouseout', function(e) {
		if (e.type == 'mouseover') {
			jQuery('.grid-portfolio li').not(this).dequeue().animate({opacity: '0.3'}, 300);
    	} else {
			jQuery('.grid-portfolio li').not(this).dequeue().animate({opacity: '1'}, 300);
   		}
	});
	
	// Related case studies thumbnail fade effects
	jQuery('.related-thumb').hover(function() {
		jQuery(this).stop().animate({opacity:0},{queue:false,duration:300});
		}, function() {  
		jQuery(this).stop().animate({opacity:1},{queue:false,duration:300});
	});
	
	// Animate related case studies
	jQuery('.related-case ul').delegate('.related-case li', 'mouseover mouseout', function(e) {
		if (e.type == 'mouseover') {
			jQuery('.related-case li').not(this).dequeue().animate({opacity: '0.3'}, 300);
    	} else {
			jQuery('.related-case li').not(this).dequeue().animate({opacity: '1'}, 300);
   		}
	});
	
	// Home portfolio carousel
    jQuery('#home-carousel-slides').cycle({
		fx:					'fade',
		prev:				'.carousel-controls .slide-controls-previous',
		next:				'.carousel-controls .slide-controls-next',
		speed:				300,
		cleartypeNoBg:		true,
		timeout:			0,
		nowrap:				1
	});
	
	// Toggle home portfolio carousel
	jQuery('.carousel-controls .slide-controls-toggler').click(function() {
		jQuery('#home-carousel-slides').slideToggle(300);
		jQuery(this).toggleClass('show-slider');
		return false;
	});
	
	// Animate home portfolio carousel
	jQuery('#home-carousel-slides').delegate('.home-blog-column', 'mouseover mouseout', function(e) {
		if (e.type == 'mouseover') {
			jQuery('#home-carousel-slides .home-blog-column').not(this).dequeue().animate({opacity: '0.3'}, 300);
    	} else {
			jQuery('#home-carousel-slides .home-blog-column').not(this).dequeue().animate({opacity: '1'}, 300);
   		}
	});
	
	// Home blog posts carousel
    jQuery('#home-blog-slides').cycle({
		fx:					'fade',
		prev:				'.blog-controls .slide-controls-previous',
		next:				'.blog-controls .slide-controls-next',
		speed:				300,
		cleartypeNoBg:		true,
		timeout:			0,
		nowrap:				1
	});
	
	// Toggle home page blog posts
	jQuery('.blog-controls .slide-controls-toggler').click(function() {
		jQuery('#home-blog-slides').slideToggle(300);
		jQuery(this).toggleClass('show-slider');
		return false;
	});
	
	// Animate home page blog posts
	jQuery('#home-blog-slides').delegate('.home-blog-column', 'mouseover mouseout', function(e) {
		if (e.type == 'mouseover') {
			jQuery('#home-blog-slides .home-blog-column').not(this).dequeue().animate({opacity: '0.3'}, 300);
    	} else {
			jQuery('#home-blog-slides .home-blog-column').not(this).dequeue().animate({opacity: '1'}, 300);
   		}
	});
	
	// Toggle 404 page search form
	jQuery('.toggle-search').click(function() {
		jQuery('.search-404').slideToggle(300);
		return false;
	});
	
	// Animate post galleries
	jQuery('.gallery').delegate('.gallery-item', 'mouseover mouseout', function(e) {
		if (e.type == 'mouseover') {
			jQuery('.gallery .gallery-item').not(this).dequeue().animate({opacity: '0.3'}, 300);
    	} else {
			jQuery('.gallery .gallery-item').not(this).dequeue().animate({opacity: '1'}, 300);
   		}
	});
	
	// Initiate Fancybox on post anchors with images
	jQuery('.post-entry a:has(img)').fancybox({
		'transitionIn'	:	'elastic',
		'transitionOut'	:	'elastic',
		'speedIn'		:	400, 
		'speedOut'		:	200,
		'overlayColor'  : '#000',
		'overlayOpacity': 0.75
	});
	
	// Initiate Fancybox on portfolio anchors with images
	jQuery('.artisan-portfolio a:has(img)').fancybox({
		'transitionIn'	:	'elastic',
		'transitionOut'	:	'elastic',
		'speedIn'		:	400, 
		'speedOut'		:	200,
		'overlayColor'  : '#000',
		'overlayOpacity': 0.75
	});
	
	// Sidebar Tabs	
	jQuery('#tab-container').tabs({
		fx: {
			height: 'toggle',
			opacity: 'toggle'
		}
	});
	
	// Case Study slider
    jQuery('.slider-gallery').cycle({
		fx:					'fade',
		prev:				'.case-study-controls .slide-controls-previous',
		next:				'.case-study-controls .slide-controls-next',
		speed:				300,
		cleartypeNoBg:		true,
		timeout:			0,
		nowrap:				1
	});
	
	// Filter portfolios
	jQuery('#filter-portfolio').filterable();
	
	// Post Accordion	
	jQuery('.post-entry .artisan-accordion').accordion({
		autoHeight:	false
	});
	
	// initiate Fancybox on gallery items
	jQuery('.gallery-icon a').attr('rel', 'fancybox');
	

});
