<?php

/**
 * Artisan Creatif Quick Contact
 *
 * This template will be used to generate the quick contact section in the header
 * if set to display.
 *
 * You should only customize this template in a child theme.
 *
 * @package Artisan Creatif
 * @version 1.0.0
 * @since 2.0.0
 * @author Erik Ford for We Are Pixel8 <@notdivisible>
 *
 */

?>

	<div id="quick-contact-container"><!-- Begin #quick-contact-container -->
		<div id="quick-contact" class="clear"><!-- Begin #quick-contact -->
			<div class="wrapper"><!-- Begin .wrapper for #quick-contact -->
				<ul class="clear">
					<?php if ( of_get_option( 'artisan_phone' ) != '' ) { ?><li class="ac-phone"><?php echo esc_html( of_get_option( 'artisan_phone' ) ); ?></li><?php } ?>
					<?php if ( of_get_option( 'artisan_email' ) != '' ) { ?><li class="ac-email"><a class="emailaddy" title="<?php esc_attr_e( 'Send us an email', 'wap8theme-i18n' ); ?>"><?php echo of_get_option( 'artisan_email' ); ?></a></li><?php } ?>
					<?php if ( of_get_option( 'artisan_twitter' ) != '' ) { ?><li class="ac-twitter"><a href="<?php echo esc_url( 'http://twitter.com/') .  esc_html( of_get_option( 'artisan_twitter' ) ); ?>" title="<?php esc_attr_e( 'Follow us on Twitter', 'wap8theme-i18n' ); ?>">&#64;<?php echo esc_html( of_get_option( 'artisan_twitter', 'no entry' ) ); ?></a></li><?php } ?>
					<?php if ( of_get_option( 'artisan_facebook' ) != '' ) { ?><li class="ac-facebook"><a href="<?php echo esc_url( of_get_option( 'artisan_facebook' ) ); ?>" title="<?php esc_attr_e( 'Follow us on Facebook', 'wap8theme-i18n' ); ?>"><?php _e( 'Facebook', 'wap8theme-i18n' ); ?></a></li><?php } ?>
				</ul>
			</div><!-- End .wrapper for #quick-contact -->
		</div><!-- End #quick-contact -->
		
		<?php if ( of_get_option( 'artisan_qk_contact_toggle' ) == '1' ) { ?>
		<div id="quick-contact-controls"><!-- Begin #quick-contact-controls -->		
			<a class="hide-quick-contact" href="#" title="<?php _e( 'Toggle Quick Contact Bar', 'wap8theme-i18n' ); ?>"><?php _e( 'Toggle Quick Contact Bar', 'wap8theme-i18n' ); ?></a>
		</div><!-- End #quick-contact-controls -->
		<?php } ?>
	</div><!-- End #quick-container-container -->
