<?php

/**
 * Artisan Creatif Home Blog Template
 *
 * This template will be used to generate the home page blog posts.
 *
 * You should only customize this template in a child theme.
 *
 * @package Artisan Creatif
 * @version 1.0.0
 * @since 2.0.0
 * @author Erik Ford for We Are Pixel8 <@notdivisible>
 *
 */

if ( of_get_option( 'artisan_home_blog_count' ) == 'four' ) {
	$numberposts = 4;
} else if ( of_get_option( 'artisan_home_blog_count' ) == 'eight' ) {
	$numberposts = 8;
} else if ( of_get_option( 'artisan_home_blog_count' ) == 'twelve' ) {
	$numberposts = 12;
} else if ( of_get_option( 'artisan_home_blog_count' ) == 'sixteen' ) {
	$numberposts = 16;
} ?>

		<div class="flowlines"><!-- Begin .flowlines -->
			<div class="wrapper"><!-- Begin .wrapper for home page blog .flowlines -->
				<h2><?php echo esc_html( of_get_option( 'artisan_home_blog_heading' ) ); ?></h2>
				
				<?php if ( $numberposts > 4 || of_get_option( 'artisan_home_blog_toggle' ) == '1' ) { ?>
				<ul class="slide-controls blog-controls clear">
					<?php if ( $numberposts > 4 ) { // enough blog posts to warrant a slider ?>
					<li><a class="slide-controls-next" href="#" title="<?php _e( 'Next Blog Posts', 'wap8theme-i18n' ); ?>"><?php _e( 'Next Blog Posts', 'wap8theme-i18n' ); ?></a></li>
					<li><a class="slide-controls-previous" href="#" title="<?php _e( 'Previous Blog Posts', 'wap8theme-i18n' ); ?>"><?php _e( 'Previous Blog Posts', 'wap8theme-i18n' ); ?></a></li>
					<?php } ?>
					<?php if ( of_get_option( 'artisan_home_blog_toggle' ) == '1' ) { ?><li><a class="slide-controls-toggler" href="#" title="<?php _e( 'Toggle Blog Posts', 'wap8theme-i18n' ); ?>"><?php _e( 'Toggle Blog Posts', 'wap8theme-i18n' ); ?></a></li><?php } ?>
				</ul>
				<?php } ?>
				
			</div><!-- End .wrapper for home page blog .flowlines -->
		</div><!-- End .flowlines -->
		
		<div id="home-blog-wrapper" class="clear"><!-- Begin #home-blog-wrapper -->
			<div id="home-blog-slides"><!-- Begin #home-blog-slides -->
				
			<?php
				
				// get the cached version of the query if one exists
				if ( false === ( $home_blog = get_transient( 'home_blog' ) ) ) {
    
					// it did not exist, so run through the query
					global $post;
				
					$args = array(
						'numberposts' => $numberposts,
						'post_type'   => 'post'
						);
							
					$home_blog = get_posts( $args );
								
					// set the transient for 8 hours
					set_transient( 'home_blog', $home_blog, 60*60*8 );
					
					}
				
				foreach( $home_blog as $post ) :
				
				setup_postdata( $post );
				
				$postid = $post->ID;
   				$title = $post->post_title;		

				if ( ++$post_counter % 4 == 1 ) {
         			if ( $post_counter > 1 ) {
            			echo '</div><!-- End .blog-slides -->';  // End previous grp
         				}
       	  				echo '<div class="blog-slides">';  // Start a new grp
   					} ?>
				
				<div <?php post_class( 'home-blog-column alignleft' ); ?> id="post-<?php the_ID(); ?>">
					
					<div class="home-blog-thumbnail">
					<?php if ( has_post_thumbnail() ) { ?>
						<a href="<?php the_permalink(); ?>" rel="bookmark" title="<?php the_title_attribute(); ?>"><?php the_post_thumbnail( 'img-220x165', array( 'title' => get_the_title() ) ); ?></a>
					<?php } ?>					
					</div>
					
					<?php the_title( '<h3><a href="' . get_permalink() . '" title="' . the_title_attribute( array( 'before' => __( 'Permanent link to ', 'wap8theme-i18n' ), 'echo' => 0 ) ) . '" rel="bookmark">', '</a></h3>' ); ?>
					<?php the_excerpt(); ?>
					
					<p><a href="<?php the_permalink(); ?>" title="<?php _e( 'Read ', 'wap8theme-i18n' ); ?><?php the_title_attribute(); ?>" rel="bookmark"><?php _e( 'Read this Entry  &#8594;', 'wap8theme-i18n' ); ?></a></p>
						
				</div>
				
			<?php endforeach; // End custom loop ?>
				</div><!-- End .blog-slides -->
				
			</div><!-- End #home-blog-slides -->			
		</div><!-- End #home-blog-wrapper -->
