<?php

/**
 * Artisan Creatif Related Blog Posts
 *
 * This template will be used to generate the related blog posts.
 *
 * You should only customize this template in a child theme.
 *
 * @package Artisan Creatif
 * @version 1.0.0
 * @since 2.0.2
 * @author Erik Ford for We Are Pixel8 <@notdivisible>
 *
 */

?>

					<div class="artisancolumn-700 clear"><!-- Begin author bio -->
					
						<div class="artisancolumn-220 post-section <?php if ( of_get_option( 'artisan_sidebar' ) == '2c-l-fixed' ) { echo 'alignright'; } else if ( of_get_option( 'artisan_sidebar' ) == '2c-r-fixed' ) { echo 'right-side alignleft'; } ?>">
							<h4><?php _e( '<span>Related</span> Blog Posts', 'wap8theme-i18n' ); ?></h4>
						</div>
						
						<div class="post-section artisan-post <?php if ( of_get_option( 'artisan_sidebar' ) == '2c-l-fixed' ) { echo 'alignleft'; } else if ( of_get_option( 'artisan_sidebar' ) == '2c-r-fixed' ) { echo 'alignright'; } ?>">
						
						<?php
						
						$backup = $post;
						
						$num = of_get_option( 'artisan_blog_related_count' );

						$tags = wp_get_post_tags( $post->ID );
						if ( $tags ) {
							$tag_ids = array();
							foreach( $tags as $individual_tag ) $tag_ids[] = $individual_tag->term_id;

						$args = array(
							'tag__in'             => $tag_ids,
							'post__not_in'        => array( $post->ID ),
							'posts_per_page'      => $num,
							'ignore_sticky_posts' => 1,
							'orderby'             => 'rand'
						);
						
						$relatedposts = new WP_Query( $args );
						
						if ( $relatedposts->have_posts() ) {
							
							echo '<ul class="related-posts">';
							
								while ( $relatedposts->have_posts() ) {
								$relatedposts->the_post();
							
								?>
						
								<li>
									<?php the_title( '<a href="' . get_permalink() . '" title="' . the_title_attribute( array( 'before' => __( 'Permanent link to ', 'wap8theme-i18n' ), 'echo' => 0 ) ) . '" rel="bookmark">', '</a>' ); ?>
									
									<span><?php the_time( get_option( 'date_format' ) ); ?> &#151; <?php comments_number(__( 'No Comments', 'wap8theme-i18n' ),__( '1 Comment', 'wap8theme-i18n' ),__( '% Comments', 'wap8theme-i18n' )); ?>
								</li>
							
								<?php
							
								}
							
							echo '</ul>';
							
							} else echo _e( '<p>Sorry. There are no related blog posts at this time.</p>', 'wap8theme-i18n' );
						
						}
						
						$post = $backup;
						
						wp_reset_query(); ?>

						</div>

					</div><!-- End author bio -->
