<?php

/**
 * Artisan Creatif Large Slider Featured Work Template
 *
 * This template will be used to generate the large home page slider for featured
 * portfolio posts.
 *
 * You should only customize this template in a child theme.
 *
 * @package Artisan Creatif
 * @version 1.0.0
 * @since 2.0.0
 * @author Erik Ford for We Are Pixel8 <@notdivisible>
 *
 */

if ( of_get_option( 'artisan_home_slider_posts' ) == 'three' ) {
	$sliderposts = 3;
} if ( of_get_option( 'artisan_home_slider_posts' ) == 'four' ) {
	$sliderposts = 4;
} if ( of_get_option( 'artisan_home_slider_posts' ) == 'five' ) {
	$sliderposts = 5;
} if ( of_get_option( 'artisan_home_slider_posts' ) == 'six' ) {
	$sliderposts = 6;
} ?>

		<div class="flowlines"><!-- Begin .flowlines -->
			<div class="wrapper"><!-- Begin .wrapper for home page slider .flowlines -->

				<h2><?php echo esc_html( of_get_option( 'artisan_home_slider_heading' ) ); ?></h2>
				
				<ul class="slide-controls portfolio-controls clear">
					<li><a class="slide-controls-next" href="#" title="<?php _e( 'Next Project', 'wap8theme-i18n' ); ?>"><?php _e( 'Next Project', 'wap8theme-i18n' ); ?></a></li>
					<li><a class="slide-controls-previous" href="#" title="<?php _e( 'Previous Project', 'wap8theme-i18n' ); ?>"><?php _e( 'Previous Project', 'wap8theme-i18n' ); ?></a></li>
					<?php if ( of_get_option( 'artisan_home_portfolio_toggle' ) == '1' ) { ?><li><a class="slide-controls-toggler" href="#" title="<?php _e( 'Toggle Recent Work', 'wap8theme-i18n' ); ?>"><?php _e( 'Toggle Recent Work', 'wap8theme-i18n' ); ?></a></li><?php } ?>
				</ul>

			</div><!-- End .wrapper for home page slider .flowlines -->		
		</div><!-- End .flowlines -->
		
		<div class="wrapper">
		
		<?php if ( of_get_option( 'artisan_home_slider_overylay' ) == '1' ) { // if user has enabled overlay ?>
		
			<a class="close-info" href="#" title="<?php _e( 'Toggle Portfolio Information', 'wap8theme-i18n' ); ?>"><?php _e( 'Toggle Portfolio Information', 'wap8theme-i18n' ); ?></a>
			
		<?php } // end if user has enabled overlay ?>
		
			<div id="home-large-slides"><!-- Begin #home-large-slides -->
		
			<?php
			
				// get the cached version of the query if one exists
				if ( false === ( $lrg_featured_work = get_transient( 'lrg_featured_work' ) ) ) {
    
					// it did not exist, so run through the query
					$args = array(
						'post_type'      => 'portfolio',
						'post_status'    => 'publish',
						'posts_per_page' => $sliderposts,
						'orderby'        => 'date',
						'order'          => 'DESC',
						'portfolio-tags' => 'home-featured'
						);
							
					$lrg_featured_work = new WP_Query( $args );
								
					// set the transient for 8 hours
					set_transient( 'lrg_featured_work', $lrg_featured_work, 60*60*8 );
					
					}
			
				while ( $lrg_featured_work->have_posts() ) : $lrg_featured_work->the_post();
			
				$clientname = get_post_meta( $post->ID, 'wap8_client_name', true ); ?>
		
				<div <?php post_class( 'lrgproject' ); ?> id="post-<?php the_ID(); ?>-slider">
			
				<?php if ( has_post_thumbnail() ) { ?>
					<a href="<?php the_permalink(); ?>" rel="bookmark" title="<?php the_title_attribute(); ?>"><?php the_post_thumbnail( 'img-940x470', array( 'title' => get_the_title() ) ); ?></a>
				<?php } // end if there is a post thumbnail
				
				if ( of_get_option( 'artisan_home_slider_overylay' ) == '1' ) { // if user has enabled overlay ?>		
			
					<div class="portfolio-meta">				
						<?php the_title( '<h3><a href="' . get_permalink() . '" title="' . the_title_attribute( array( 'before' => __( 'Permanent link to ', 'wap8theme-i18n' ), 'echo' => 0 ) ) . '" rel="bookmark">', '</a></h3>' ); ?>
						
						<?php if ( $clientname ) { ?>
						<ul>
							<li><?php _e( '<strong>Client: </strong>', 'wap8theme-i18n' ); ?><?php echo esc_html( $clientname ); ?></li>
						</ul>
						<?php } ?>
					
						<?php the_excerpt(); ?>
						
						<?php if ( of_get_option( 'artisan_home_slider_button_true' ) == '1' ) { ?>
						<p class="cta-link"><a class="pill-button" href="<?php the_permalink(); ?>" rel="bookmark"><?php echo esc_html( of_get_option( 'artisan_home_slider_button' ) ); ?></a></p>
						<?php } ?>
					</div>
					
				<?php } // end if  user has enabled overlay ?>				
				</div>
		
			<?php endwhile; wp_reset_query(); ?>
		
			</div><!-- End #home-large-slides -->
		</div>
