<?php
 
/*----------------------------------------------------------------------------*/
/* Theme Version Cache
/*----------------------------------------------------------------------------*/

/**
 * Version Cache
 *
 * Current stable theme version number to be appended to theme related scripts
 * and stylesheets.
 *
 * @return Version number
 *
 * @package Artisan Creatif
 * @version 2.0.0
 * @since 2.0.3 Theme version number increment
 * @author Erik Ford for We Are Pixel8 <@notdivisible>
 *
 */

function wap8_version_cache() {

	return '2.0.3';
	
}

/*----------------------------------------------------------------------------*/
/* Theme Setup
/*----------------------------------------------------------------------------*/

add_action( 'after_setup_theme', 'wap8_theme_setup', 10 );

/**
 * Theme Setup
 *
 * Perform basic theme setup, registrations and init actions during theme
 * initialization.
 *
 * @package Artisan Creatif
 * @version 1.0.0
 * @since 2.0.0
 * @author Erik Ford for We Are Pixel8 <@notdivisible>
 *
 */

function wap8_theme_setup() {

	// set the $content_width
	global $content_width;
	if ( !isset( $content_width ) ) $content_width = 700;
	
	// add theme support for automatic-feed-links
	add_theme_support( 'automatic-feed-links' );
	
	// add theme support for post-thumbnails
	add_theme_support( 'post-thumbnails' );
	
	// add post thumbnail image size
	add_action( 'init', 'wap8_post_thumbnails', 10 );
	
	// register theme menus
	add_action( 'init', 'wap8_theme_menus', 10 );
	
	// register sidebars
	add_action( 'widgets_init', 'wap8_theme_sidebars', 10 );
	
	// register theme js
	add_action( 'wp_enqueue_scripts', 'wap8_theme_js', 10 );
	
	// enqueue comment-reply.js
	add_action( 'template_redirect', 'wap8_enqueue_comment_reply_js', 10 );
	
	// Add action for registering and enqueueing global stylesheets
	add_action( 'wp_enqueue_scripts', 'wap8_theme_css', 10 );
	
	// deregister stylesheets
	add_action( 'wp_print_styles', 'wap8_deregister_styles', 100 );
	
	// wp title
	add_filter( 'wp_title', 'wap8_wp_title', 10, 2 );
	
	// load HTML5 Shiv for versions of IE older than 9
	add_action( 'wp_head', 'wap8_html5_shiv', 10 );
	
	// trim excerpt
	add_filter( 'excerpt_length', 'wap8_trim_excerpt', 10, 1 );
	
	// excerpt ellispis
	add_filter( 'excerpt_more', 'wap8_excerpt_ellipsis', 10, 1 );
	
	// enable style dropdown on the visual editor screen
	add_filter( 'mce_buttons_2', 'wap8_style_mce_button', 10, 1 );
	
	// custom theme classes
	add_filter( 'tiny_mce_before_init', 'wap8_custom_theme_classes', 10, 1 );
	
	// search filter
	add_filter( 'pre_get_posts', 'wap8_search_filter', 10, 1 );
	
	// add editor styles
	add_action( 'admin_head', 'wap8_editor_styles', 10 );
	
	// add favicon to head element
	add_action( 'wp_head', 'wap8_favicon');
	
	// load theme plugins
	require_once( get_template_directory() . '/lib/plugins/case-studies.php' );
	require_once( get_template_directory() . '/lib/plugins/contact.php' );
	require_once( get_template_directory() . '/lib/plugins/cleaner-image-markup.php' );
	require_once( get_template_directory() . '/lib/plugins/custom-meta-boxes.php' );
	require_once( get_template_directory() . '/lib/plugins/flickr-feedr/flickr-feedr.php' );
	require_once( get_template_directory() . '/lib/plugins/jplayable.php' );
	require_once( get_template_directory() . '/lib/plugins/portfolio.php' );
	require_once( get_template_directory() . '/lib/plugins/tabbr.php' );
	require_once( get_template_directory() . '/lib/plugins/testify.php' );
	require_once( get_template_directory() . '/lib/plugins/twitter-feedr.php' );
	require_once( get_template_directory() . '/lib/plugins/video-postr.php' );
	
	// load theme text domain
	load_theme_textdomain( 'wap8theme-i18n', get_template_directory() . '/languages' );

}

/*----------------------------------------------------------------------------*/
/* Post Thumbnails
/*----------------------------------------------------------------------------*/

/**
 * Post Thumbnails
 *
 * Adding theme support for post-thumbnails but allowing child themes the ability
 * to override this function with remove_action( 'wap8_post_thumbnails' )
 *
 * @package Artisan Creatif
 * @version 2.0.0
 * @since 2.0.0
 * @author Erik Ford for We Are Pixel8 <@notdivisible>
 *
 */

function wap8_post_thumbnails() {

	add_image_size( 'img-75x75', 75, 75, true ); // 75px x 75px thumbnail
	add_image_size( 'img-220x165', 220, 165, true ); // 220px x 165px thumbnail
	add_image_size( 'img-460x345', 460, 345, true ); // 460px x 345px thumbnail
	add_image_size( 'img-460x460', 460, 460, true ); // 460px x 460px thumbnail
	add_image_size( 'img-460x', 460, '', true ); // 460px x unlimited thumbnail
	add_image_size( 'img-940x470', 940, 470, true ); // 940px x 470px thumbnail
	
}

/*----------------------------------------------------------------------------*/
/* Theme Menus
/*----------------------------------------------------------------------------*/

/**
 * Theme Menus
 *
 * Register custom navigation menus using register_nav_menus().
 *
 * @package Artisan Creatif
 * @version 1.0.0
 * @since 2.0.0
 * @author Erik Ford for We Are Pixel8 <@notdivisible>
 *
 */

function wap8_theme_menus() {

	register_nav_menus(
		array(
			'main-menu'   => __( 'Main Menu', 'wap8theme-i18n' ),
			'footer-menu' => __( 'Footer Menu', 'wap8theme-i18n' )
		)
	);
	
}

/*----------------------------------------------------------------------------*/
/* Theme Sidebars
/*----------------------------------------------------------------------------*/

/**
 * Theme Sidebars
 *
 * Register two widget ready areas with register_sidebar().
 *
 * @package Artisan Creatif
 * @version 1.0.0
 * @since 2.0.0
 * @author Erik Ford for We Are Pixel8 <@notdivisible>
 *
 */

function wap8_theme_sidebars() {

	register_sidebar(
		array(
			'id'            => 'home',
			'name'          => __( 'Sidebar for Home Page', 'wap8theme-i18n' ),
			'description'   => __( 'Drag, organize and save widgets for the sidebar that will appear on your home page.', 'wap8theme-i18n' ),
			'before_widget' => '<div id="%1$s" class="sidebar-widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h3 class="widget-title">',
			'after_title'   => '</h3>'
		)
	);

	register_sidebar(
		array(
			'id'            => 'pages',
			'name'          => __( 'Sidebar for Pages', 'wap8theme-i18n' ),
			'description'   => __( 'Drag, organize and save widgets for the sidebar that will appear on your pages.', 'wap8theme-i18n' ),
			'before_widget' => '<div id="%1$s" class="sidebar-widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h3 class="widget-title">',
			'after_title'   => '</h3>'
		)
	);

	register_sidebar(
		array(
			'id'            => 'archives',
			'name'          => __( 'Sidebar for Archives', 'wap8theme-i18n' ),
			'description'   => __( 'Drag, organize and save widgets for the sidebar that will appear on your archives.', 'wap8theme-i18n' ),
			'before_widget' => '<div id="%1$s" class="sidebar-widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h3 class="widget-title">',
			'after_title'   => '</h3>'
		)
	);
	
	register_sidebar(
		array(
			'id'            => 'posts',
			'name'          => __( 'Sidebar for Blog Posts', 'wap8theme-i18n' ),
			'description'   => __( 'Drag, organize and save widgets for the sidebar that will appear on your blog posts.', 'wap8theme-i18n' ),
			'before_widget' => '<div id="%1$s" class="sidebar-widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h3 class="widget-title">',
			'after_title'   => '</h3>'
		)
	);
	
	register_sidebar(
		array(
			'id'            => 'contact-one',
			'name'          => __( 'Sidebar for Contact Column One', 'wap8theme-i18n' ),
			'description'   => __( 'Drag, organize and save widgets for the column one sidebar on your contact page.', 'wap8theme-i18n' ),
			'before_widget' => '<div id="%1$s" class="sidebar-widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h3 class="widget-title">',
			'after_title'   => '</h3>'
		)
	);
	
	register_sidebar(
		array(
			'id'            => 'contact-two',
			'name'          => __( 'Sidebar for Contact Column Two', 'wap8theme-i18n' ),
			'description'   => __( 'Drag, organize and save widgets for the column two sidebar on your contact page.', 'wap8theme-i18n' ),
			'before_widget' => '<div id="%1$s" class="sidebar-widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h3 class="widget-title">',
			'after_title'   => '</h3>'
		)
	);

}

/*----------------------------------------------------------------------------*/
/* Theme JS
/*----------------------------------------------------------------------------*/

/**
 * Theme JS
 *
 * Register all theme related javascripts using wp_register_script().
 *
 * @package Artisan Creatif
 * @version 1.0.0
 * @since 2.0.0
 * @author Erik Ford for We Are Pixel8 <@notdivisible>
 *
 */

function wap8_theme_js() {
	
	if ( !is_admin() ) { // we do not want to register or enqueue these scripts on admin screens
	
		// register javascripts
		wp_register_script( 'jquery-easing', get_template_directory_uri() . '/js/jquery.easing.1.3.min.js', 'jquery', '1.3', true );
		wp_register_script( 'jquery-cycle', get_template_directory_uri() . '/js/jquery.cycle.all.min.js', array( 'jquery', 'jquery-easing' ), '2.99', true );
		wp_register_script( 'jquery-fancybox', get_template_directory_uri() . '/js/jquery.fancybox-1.3.4.pack.js', array( 'jquery', 'jquery-easing' ), '1.3.4', true );
		wp_register_script( 'jquery-filterable', get_template_directory_uri() . '/js/jquery.filterable.js', 'jquery', wap8_version_cache(), true );
		wp_register_script( 'jquery-ui-accordion', get_template_directory_uri() . '/js/jquery.ui.accordion.js', array( 'jquery', 'jquery-ui-core', 'jquery-ui-widget' ), '1.8.13', true );
		wp_register_script( 'jquery-jplayer', get_template_directory_uri() . '/js/jplayer/jquery.jplayer.min.js', array( 'jquery' ), '2.2.0', true );
		wp_register_script( 'ac-jquery', get_template_directory_uri() . '/js/ac-jquery.js', array( 'jquery' ), wap8_version_cache(), true );
		
		// enqueue javascripts
		wp_enqueue_script( 'jquery' );
		wp_enqueue_script( 'jquery-easing' );
		wp_enqueue_script( 'jquery-cycle' );
		wp_enqueue_script( 'ac-jquery' );
		wp_enqueue_script( 'jquery-ui-core' );
		wp_enqueue_script( 'jquery-ui-widget' );
		wp_enqueue_script( 'jquery-ui-tabs' );
		wp_enqueue_script( 'jquery-ui-accordion' );
		wp_enqueue_script( 'jquery-filterable' );
		wp_enqueue_script( 'jquery-fancybox' );
		
		// enqueue jquery-jplayer on portfolio posts only
		if ( is_singular( 'portfolio' ) ) {
			wp_enqueue_script( 'jquery-jplayer' );
		}
	
	}

}

/*----------------------------------------------------------------------------*/
/* Comment Reply JS
/*----------------------------------------------------------------------------*/

/**
 * Enqueue Comment Reply JS
 *
 * Enqueue the comment-reply.js file, with wp_enqueue_script(), on singular
 * templates, but not a custom front page. The condition checks to make sure 
 * comments are open and enabled as well the threaded comments option is set.
 *
 * @package Artisan Creatif
 * @version 1.0.0
 * @since 1.0.0
 * @author Erik Ford for We Are Pixel8 <@notdivisible>
 *
 */

function wap8_enqueue_comment_reply_js() {

	if ( !is_admin() ) { // we do not want to load this script on admin screens
		
		if ( is_singular() && !is_front_page() && comments_open() && ( get_option( 'thread_comments' ) == '1' ) ) wp_enqueue_script( 'comment-reply' );
		
	}

}

/*----------------------------------------------------------------------------*/
/* Theme CSS
/*----------------------------------------------------------------------------*/

/**
 * Theme CSS
 *
 * Register and enqueue all theme related stylesheets using wp_register_style()
 * and wp_enqueue_style() respectively.
 *
 * @package Artisan Creatif
 * @version 1.0.0
 * @since 1.0.0
 * @author Erik Ford for We Are Pixel8 <@notdivisible>
 *
 */

function wap8_theme_css() {
	
	if ( !is_admin() ) { // we do not want to register or enqueue these stylesheets on admin screens
		
		// register stylesheets
		wp_register_style( 'ac-core', get_template_directory_uri() . '/style.css', '', wap8_version_cache(), 'screen' );
		wp_register_style( 'ac-light', get_template_directory_uri() . '/css/ac-light.css', 'ac-core', wap8_version_cache(), 'screen' );
		wp_register_style( 'ac-dark', get_template_directory_uri() . '/css/ac-dark.css', 'ac-core', wap8_version_cache(), 'screen' );
		wp_register_style( 'fancybox-styles', get_template_directory_uri() . '/fancybox/jquery.fancybox-1.3.4.css', 'ac-core', '1.3.4', 'screen' );
		
		// enqueue ac-light if set
		if ( of_get_option( 'artisan_stylesheet' ) == 'light' ) { // if light version is set
			wp_enqueue_style( 'ac-light' );
			}
		
		// enqueue ac-dark if set
		if ( of_get_option( 'artisan_stylesheet' ) == 'dark' ) { // if dark version is set
			wp_enqueue_style( 'ac-dark' );
			}
		
		// enqueue fancybox-styles
		wp_enqueue_style( 'fancybox-styles' );
	
	}

}

/*----------------------------------------------------------------------------*/
/* Update Transients
/*----------------------------------------------------------------------------*/

add_action( 'save_post', 'wap8_update_transients', 10, 2 );

/**
 * Update Transients
 *
 * Delete transients when a new post has been saved or a post has been updated.
 *
 * @param $post_id
 * @param $post
 *
 * @package Artisan Creatif
 * @version 2.0.0
 * @since 2.0.0
 * @author Erik Ford for We Are Pixel8 <@notdivisible>
 *
 */

function wap8_update_transients( $post_id, $post ) {

	// if this is an autosave routine, do nothing
	if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) return;
	
	if ( $post->post_type == 'portfolio' ) { // portfolio posts
		
		delete_transient( 'carousel_hm' ); // home-portfolio carousel
		delete_transient( 'carousel_work' ); // recent work carousel
		delete_transient( 'lrg_featured_work' ); // large featured work slider
		delete_transient( 'lrg_recent_work' ); // large recent work slider
		delete_transient( 'sm_featured_work' ); // small featured work slider
		delete_transient( 'sm_recent_work' ); // small recent work slider
		delete_transient( 'portfolio_pg' ); // small recent work slider
		delete_transient( 'error_portfolio_results' ); // 404 posts
		
	}
	
	if ( $post->post_type == 'post' ) { // blog posts
		
		delete_transient( 'home_blog' ); // home-portfolio carousel
		delete_transient( 'error_posts_results' ); // 404 posts
		
	}
	
}

/*----------------------------------------------------------------------------*/
/* Deregister Styles
/*----------------------------------------------------------------------------*/

/**
 * Deregister Styles
 *
 * Deregister stylesheets created by plugins using wp_deregister_style().
 *
 * @package Artisan Creatif
 * @version 1.0.0
 * @since 1.0.0
 * @author Erik Ford for We Are Pixel8 <@notdivisible>
 *
 */

function wap8_deregister_styles() {
	
	if ( function_exists( 'wpcf7' ) ) { // if contact form 7 is installed and activated
		
		wp_deregister_style( 'contact-form-7' );
	
	}

}

/*----------------------------------------------------------------------------*/
/* WP Title
/*----------------------------------------------------------------------------*/

/**
 * WP Title
 *
 * A filter to return SEO friendly browser titles.
 *
 * @param $title Default title
 * @param $sep Separator
 * @return $title Filtered title
 *
 * @package Artisan Creatif
 * @version 2.0.0
 * @since 2.0.0
 * @author Erik Ford for We Are Pixel8 <@notdivisible>
 *
 */

function wap8_wp_title( $title, $sep ) {
	
	global $page, $paged;
	
	if ( is_feed() )
		return $title;
		
	// add the site name
	$title .= get_bloginfo( 'name' );
	
	// add site description
	$site_description = get_bloginfo( 'description', 'display' );
	if ( $site_description && ( is_front_page() ) )
		$title = "$title $sep $site_description";
		
	// add page numbers on paged templates
	if ( $paged >= 2 || $page >= 2 )
		$title = "$title $sep " . sprintf( __( 'Page %s', 'wap8theme-i18n' ), max( $paged, $page ) );
	
	return $title;
	
}

/*----------------------------------------------------------------------------*/
/* HTML5 Shiv
/*----------------------------------------------------------------------------*/

/**
 * HTML5 Shiv
 *
 * Load the HTML5 polyfill javascripts for versions of IE older than 9.
 *
 * @package Artisan Creatif
 * @version 2.0.0
 * @since 2.0.0
 * @author Erik Ford for We Are Pixel8 <@notdivisible>
 *
 */

function wap8_html5_shiv() {
?>
<!--[if lt IE 9]>
<script src="//html5shiv.googlecode.com/svn/trunk/html5.js"></script>
<![endif]-->
<?php
}

/*----------------------------------------------------------------------------*/
/* Trim Excerpt
/*----------------------------------------------------------------------------*/

/**
 * Trim Excerpt
 *
 * A filter to trim post excerpts to 35 words.
 *
 * @param $length Default length
 * @return integer Filtered length
 *
 * @package Artisan Creatif
 * @version 1.0.0
 * @since 2.0.0
 * @author Erik Ford for We Are Pixel8 <@notdivisible>
 *
 */

function wap8_trim_excerpt( $length ) {
	return 35;
}

/*----------------------------------------------------------------------------*/
/* Excerpt Ellipsis
/*----------------------------------------------------------------------------*/

/**
 * Excerpt Ellipsis
 *
 * A filter to add a horizontal ellipsis to the end of excerpts.
 *
 * @param $more Default more string
 * @return string Filtered more string
 *
 * @package Artisan Creatif
 * @version 1.0.0
 * @since 2.0.0
 * @author Erik Ford for We Are Pixel8 <@notdivisible>
 *
 */

function wap8_excerpt_ellipsis( $more ) {
	return '&hellip;';
}

/*----------------------------------------------------------------------------*/
/* Print Archive Pagination
/*----------------------------------------------------------------------------*/

/**
 * Print Archive Pagination
 *
 * This function will be used to determine if we need to print the archive
 * pagination. If not, we want to avoid an empty div scenario.
 *
 * @return max_num_pages greater than 1
 *
 * @package Artisan Creatif
 * @version 2.0.0
 * @since 2.0.0
 * @author Erik Ford for We Are Pixel8 <@notdivisible>
 *
 */

function wap8_print_archive_pagination() {
	
	global $wp_query;
	
	return ( $wp_query->max_num_pages > 1 );

}

/*----------------------------------------------------------------------------*/
/* Style MCE Button
/*----------------------------------------------------------------------------*/

/**
 * Style MCE Button
 *
 * Enable the Style drop down button on the WordPress Visual Editor screen.
 *
 * @param $buttons
 * @return $buttons
 *
 * @package Artisan Creatif
 * @version 1.0.0
 * @since 2.0.0
 * @author Erik Ford for We Are Pixel8 <@notdivisible>
 *
 */

function wap8_style_mce_button( $buttons ) {

	array_unshift( $buttons, 'styleselect' );
	
	return $buttons;

}

/*----------------------------------------------------------------------------*/
/* Custom Theme Classes
/*----------------------------------------------------------------------------*/

/**
 * Custom Theme Classes
 *
 * Adding CSS classes for additional type styling and setting.
 *
 * @param $settings
 * @return $settings
 *
 * @package Artisan Creatif
 * @version 1.0.0
 * @since 2.0.0
 * @author Erik Ford for We Are Pixel8 <@notdivisible>
 *
 */

function wap8_custom_theme_classes( $settings ) {

	$style_formats = array(
		array(
    		'title'   => __( 'Accordion', 'wap8theme-i18n' ),
    		'block'   => 'div',
    		'classes' => 'artisan-accordion',
    		'wrapper' => true
    	),
		array(
    		'title'    => __( 'Accordion Trigger', 'wap8theme-i18n' ),
    		'selector' => 'a',
    		'classes'  => 'artisan-accordion-trigger'
    	),
    	array(
    		'title'   => __( 'Accordion Content', 'wap8theme-i18n' ),
    		'block'   => 'div',
    		'classes' => 'artisan-accordion-content',
    		'wrapper' => true
    	),
    	array(
    		'title'    => __( 'Pill Button', 'wap8theme-i18n' ),
    		'selector' => 'a',
    		'classes'  => 'pill-button'
    	),
    	array(
        	'title'    => __( 'Left Pull Quote', 'wap8theme-i18n' ),
        	'selector' => 'blockquote',
        	'classes'  => 'pullquote pullleft alignleft'
        ),
        array(
        	'title'    => __( 'Right Pull Quote', 'wap8theme-i18n' ),
        	'selector' => 'blockquote',
        	'classes'  => 'pullquote pullright alignright'
        ),
		array(
        	'title'    => __( 'Testimonial Quote', 'wap8theme-i18n' ),
        	'selector' => 'blockquote',
        	'classes'  => 'testimonial-quote'
        ),
		array(
        	'title'    => __( 'Testimonial Author', 'wap8theme-i18n' ),
        	'selector' => 'p',
        	'classes'  => 'testimonial-author'
        ),
		array(
        	'title'   => __( 'Two Column', 'wap8theme-i18n' ),
        	'block'   => 'div',
        	'classes' => 'artisan-two-column',
        	'wrapper' => true
        ),
		array(
        	'title'   => __( 'Three Column', 'wap8theme-i18n' ),
        	'block'   => 'div',
        	'classes' => 'artisan-three-column',
        	'wrapper' => true
        ),
		array(
        	'title'   => __( 'Four Column', 'wap8theme-i18n' ),
        	'block'   => 'div',
        	'classes' => 'artisan-four-column',
        	'wrapper' => true
        )
	);
	
	$settings['style_formats'] = json_encode( $style_formats );
	
	return $settings;

}

/*----------------------------------------------------------------------------*/
/* Search Filter
/*----------------------------------------------------------------------------*/

/**
 * Search Filter
 *
 * Filter the search results to only return posts.
 *
 * @param $query Default query
 * @return $query Filtered query
 *
 * @package Artisan Creatif
 * @version 1.0.0
 * @since 2.0.0
 * @author Erik Ford for We Are Pixel8 <@notdivisible>
 *
 */

function wap8_search_filter( $query ) {
	if ( !is_admin() && $query->is_search ) { // do not filter the search in the admin
		$query->set( 'post_type', 'post' );
	}
	return $query;
}

/*----------------------------------------------------------------------------*/
/* Editor Styles
/*----------------------------------------------------------------------------*/

/**
 * Editor Styles
 *
 * Add the correct stylesheet to the tinyMCE editor based on post type.
 *
 * @package Artisan Creatif
 * @version 1.0.0
 * @since 2.0.0
 * @author Erik Ford for We Are Pixel8 <@notdivisible>
 *
 */

function wap8_editor_styles() {
	
	global $current_screen;
	
	switch ( $current_screen->post_type ) {
	
		case 'page':
			add_editor_style( 'editor-styles-page.css' );
			break;
		
		case 'post':
			add_editor_style( 'editor-styles-post.css' );
			break;
		
		case 'portfolio':
			add_editor_style( 'editor-styles-post.css' );
			break;
	
	}
}

/*----------------------------------------------------------------------------*/
/* Favicon
/*----------------------------------------------------------------------------*/

/**
 * Favicon
 *
 * If a favicon image is set, add to the head element.
 *
 * @package Artisan Creatif
 * @version 1.0.0
 * @since 2.0.0
 * @author Erik Ford for We Are Pixel8 <@notdivisible>
 *
 */

function wap8_favicon() {
	if ( of_get_option( 'artisan_favicon' ) != '' ) {	
echo '<link rel="shortcut icon" href="'.  of_get_option( 'artisan_favicon' )  .'"/>'."\n";	
	} else { ?>	
<link rel="shortcut icon" href="<?php echo get_template_directory_uri(); ?>/images/favicon.ico" />	
	<?php }
}
	
/*----------------------------------------------------------------------------*/
/* User Comments Callback
/*----------------------------------------------------------------------------*/

/**
 * User Comments Callback
 *
 * This is our custom comments callback that will be used to markup the user
 * comments list when comments are enabled and the post has comments.
 *
 * @param $comment
 * @param $args
 * @param $depth
 *
 * @package Artisan Creatif
 * @version 1.0.0
 * @since 1.0.0
 * @author Erik Ford for We Are Pixel8 <@notdivisible>
 *
 */

function wap8_user_comments_cb( $comment, $args, $depth ) {
$GLOBALS['comment'] = $comment; ?>
<li <?php comment_class(); ?> id="li-comment-<?php comment_ID(); ?>">
	<div id="comment-<?php comment_ID(); ?>">
		<?php echo get_avatar( $comment, $size='50' ); // get the comment author avatar ?>
			
		<?php printf( __( '<address>%s</address>', 'wap8theme-i18n' ), get_comment_author_link() ) // the comment author name and link if URL was provided ?>
			
		<time class="comment-date" datetime="<?php comment_date( 'Y-m-d' ); ?>"><?php printf( __( '%1$s &#64; %2$s', 'wap8theme-i18n' ), get_comment_date(), get_comment_time() ) ?> <a href="#comment-<?php comment_ID(); ?>" title="<?php esc_attr_e( 'Permanent link to this comment', 'wap8theme-i18n' ); ?>">&#35;</a></time>
			
		<?php if ( $args['max_depth'] != $depth ) { // if the maximum threaded comments limit has not been met ?>
		
		<?php } // end comment reply conditional check ?>
		
		<?php if ( $comment->comment_approved == '0' ) : // if this comment has not been approved ?>
		
		<p class="approval"><?php _e( 'Your comment is awaiting moderation.', 'wap8theme-i18n' ) ?></p>
		
		<?php endif; // end comment approval conditional check ?>
			
		<?php comment_text(); ?>
			
		<p class="reply">
			<?php comment_reply_link(
				array_merge(
					$args, array(
						'reply_text' => __( 'Reply', 'wap8theme-i18n' ),
						'depth'      => $depth,
						'max_depth'  => $args['max_depth']
					)
				)
			); ?>
		
			<?php edit_comment_link( __( 'Edit', 'wap8theme-i18n' ) ); ?>
		</p>
		
	</div>
<?php
}

/*----------------------------------------------------------------------------*/
/* Trackback Comments Callback
/*----------------------------------------------------------------------------*/

/**
 * Trackback Comments Callback
 *
 * This is our custom comments callback that will be used to markup the trackback
 * comments list when comments are enabled and the post has comments.
 *
 * @param $comment
 *
 * @package Artisan Creatif
 * @version 1.0.0
 * @since 2.0.0
 * @author Erik Ford for We Are Pixel8 <@notdivisible>
 *
 */

function wap8_trackback_comments_cb( $comment ) {
$GLOBALS['comment'] = $comment; ?>
<li><?php printf( __( '%s', 'wap8theme-i18n' ), get_comment_author_link() ) ?> <?php edit_comment_link( __( 'Edit', 'wap8theme-i18n' ) ); ?></li>
<?php
}

/*----------------------------------------------------------------------------*/
/* Theme Options
/*----------------------------------------------------------------------------*/

/**
 * Theme Options
 *
 * Load the theme options upon activatation.
 *
 * @package Artisan Creatif
 * @version 1.0.0
 * @since 1.0.0
 * @author Erik Ford for We Are Pixel8 <@notdivisible>
 *
 */

if ( !function_exists( 'optionsframework_init' ) ) {

/* Set the file path */

	define( 'OPTIONS_FRAMEWORK_URL', TEMPLATEPATH . '/admin/' );
	define( 'OPTIONS_FRAMEWORK_DIRECTORY', get_template_directory_uri() . '/admin/' );

	require_once ( OPTIONS_FRAMEWORK_URL . 'options-framework.php' );

}

?>
