<?php

/**
 * Artisan Creatif Footer Template
 *
 * This is the footer template that will display the closing <html> and <body>
 * tags as well as the footer widgets.
 *
 * This template also contains the wp_footer() function which allows the theme
 * and plugins to fire the wp_footer action hook. You should only customize this
 * template in a child theme.
 *
 * @package Artisan Creatif
 * @version 1.0.0
 * @since 2.0.0
 * @author Erik Ford for We Are Pixel8 <@notdivisible>
 *
 */

?>

	<div id="footer" class="clear"><!-- Begin #footer -->
		<div class="wrapper"><!-- Begin .wrapper for #footer -->
			<div class="left-footer">
				<p><?php _e( 'Copyright &copy; ', 'wap8theme-i18n' ); ?><?php echo date( 'Y' ); ?> <a href="<?php echo home_url(); ?>" title="<?php bloginfo( 'name' ); ?>"><?php bloginfo( 'name' ); ?></a>. <?php _e( 'Theme design &amp; development by ', 'wap8theme-i18n' ); ?><a href="<?php echo esc_url( 'http://themeforest.net/user/wearepixel8?ref=wearepixel8' ); ?>"><?php _e( 'We Are Pixel8', 'wap8theme-i18n' ); ?></a>.</p>			

				<?php wp_nav_menu(
					
					/**
					 * Artisan Creatif Footer Menu
					 *
					 * Display the footer menu with a maximum depth of 1.
					 *
					 * You can override this functionality in a child theme.
					 *
					 * @package Artisan Creatif
					 * @version 1.0.0
					 * @since 1.0.0
					 * @author Erik Ford for We Are Pixel8 <@notdivisible>
					 *
					 */
					 
					array(
						'theme_location' => 'footer-menu',
						'menu_class'     => 'footer-links',
						'depth'          => 1
					)
				); ?>
			</div>
			
			<div class="right-footer">
				<p><a class="scroll-top" href="#" title="<?php _e( 'Back to Top' , 'wap8theme-i18n' ); ?>"><?php _e( 'Back to Top' , 'wap8theme-i18n' ); ?></a></p>
			</div>				
		</div><!-- End .wrapper for footer -->
	</div><!-- End #footer -->

<?php wp_footer(); // Do not delete this line or your world will come to an end ?>

</body>

</html>
