<?php
/**********************************************************************
* OSAKA UNLIMITED WORDPRESS THEME 
* (Ideal For Business And Personal Use: Portfolio or Blog)   
* 
* File name:   
*      comments.php
* Brief:       
*      Theme comments page code
* Author:      
*      DigitalCavalry
* Author URI:
*      http://themeforest.net/user/DigitalCavalry
* Contact:
*      digitalcavalry@gmail.com   
***********************************************************************/ 
 
if(!empty($_SERVER['SCRIPT_FILENAME']) && 'comments.php' == basename($_SERVER['SCRIPT_FILENAME']))
{   
    die(__('You can not access this page directly!', CMS_TXT_DOMAIN));   
}

function dcf_commentHTML($comment, $args, $depth) 
{    
   global $post;
   $GLOBALS['comment'] = $comment; 
   $out = '';
                  
   $out .= '<li class="'.join(' ', get_comment_class()).'" id="li-comment-'.$comment->comment_ID.'">';     
        $out .= '<div id="comment-'.$comment->comment_ID.'">';         
            $out .= '<div class="comment">';                
                                  
                $show_avatars = GetDCCPI()->getIGeneral()->getOption('comments_avatar_display');
                if($show_avatars)
                {
                    $out .= '<div class="gravatar">'; 
                    
                    $default_avatar = GetDCCPI()->getIGeneral()->getOption('comments_def_avatar');                                         
                    $out .= get_avatar($comment, '60', $default_avatar);
                    
                    if(GetDCCPI()->getIGeneral()->getOption('comments_author_url_display'))  // TODO: comments_url_display
                    {
                        $website = get_comment_author_url($comment->comment_ID);
                        if($website != '')
                        {
                            $out .= '<a class="author-url" target="_blank" href="'.$website.'">'.__('Visit site', CMS_TXT_DOMAIN).'</a>';
                        }
                    }
                    $out .= '</div>';                    
                }
            
                $out .= '<div class="content '.(!$show_avatars ? 'content-no-margin' : '').'">';
                                   
                if(GetDCCPI()->getIGeneral()->getOption('comments_time_ago_display'))
                {          
                    $out .= '<div class="date-ago"><span class="when">'.dcf_calculatePastTime(
                        __('Posted', CMS_TXT_DOMAIN), 
                        mysql2date('H', $comment->comment_date, true), 
                        mysql2date('i', $comment->comment_date, true),
                        mysql2date('s', $comment->comment_date, true),
                        mysql2date('n', $comment->comment_date, true),
                        mysql2date('j', $comment->comment_date, true),
                        mysql2date('Y', $comment->comment_date, true)).'</span></div>';                      
                }
                    
                $out .= '<div class="text">';
                    $out .= apply_filters('comment_text', $comment->comment_content, $comment);
                $out .= '</div>';
                $out .= '<div class="dc-clear-left"></div>';
  
                if($comment->comment_approved == '0') 
                { 
                    $out .= '<div class="to-approve" ><em>'.__('Your comment is awaiting moderation', CMS_TXT_DOMAIN).'</em></div>';
                } 
                $out .= '<div class="dc-clear-left"></div>';
            
                $out .= '<div class="comment-info">';  
                          
                    if(GetDCCPI()->getIGeneral()->getOption('comments_author_display'))
                    {                                               
                        $out .= '<span>'.__('by', CMS_TXT_DOMAIN).'</span> ';             
                        $out .= '<span class="author">'.get_comment_author($comment->comment_ID);
                        $out .= '</span>'; 
                    
                        if(GetDCCPI()->getIGeneral()->getOption('comments_mark_author'))
                        {
                            if($post->post_author == $comment->user_id)
                            {
                                $out .= ' <span class="marked">('.__('Author', CMS_TXT_DOMAIN).')</span>';   
                            }
                        }                                            
                    }                                                      

                    if(GetDCCPI()->getIGeneral()->getOption('comments_time_display'))
                    {            
                        $format = GetDCCPI()->getIGeneral()->getOption('comments_time_format');
                        if($format == '') { $format = 'F j, Y g:i a'; }
                    
                        if(GetDCCPI()->getIGeneral()->getOption('comments_author_display')) 
                        {
                            $out .= '<span> '.__('on', CMS_TXT_DOMAIN).' </span>';
                        }
                        $out .= '<span class="date">';
                        $out .= get_comment_time($format);             
                        $out .= '</span>';
                    }
                    
                    if((bool)get_option('thread_comments'))
                    {
                        $out .= '<span class="reply"> | ';                                    
                        $out .= get_comment_reply_link(array_merge( $args, array('depth' => $depth, 'max_depth' => $args['max_depth']))); 
                        $out .= '</span>';
                    }           
                                                                          
                $out .= '</div>'; 
           $out .= '</div> <!-- content -->';
           $out .= '<div class="dc-clear-both"></div>';
     $out .= '</div> <!-- comment -->';                     
     $out .= '</div> <!-- comment-ID -->';          
     echo $out;
}                                            


echo '<div class="dc-comments-columns">'; 

    if($post->comment_count > 0)
    {
        echo '<a name="comments"></a>'; 
        echo '<div id="dc-comments-section">';
   
        $DC_SHOW_COMMENTS_TITLE = false;
        $DC_SHOW_COMMENTS_COUNT = true;         
    
        if($DC_SHOW_COMMENTS_TITLE)
        {
            echo '<div>'.__('Comments', CMS_TXT_DOMAIN).'</div>';
        }
        
        if($DC_SHOW_COMMENTS_COUNT) 
        { 
            echo '<h3 class="comments-count-info">'; 
                switch($post->comment_count)
                {
                    case 0: { echo __('No comments', CMS_TXT_DOMAIN); } break;
                    case 1: { echo __('One comment', CMS_TXT_DOMAIN); } break;
                    default: { echo $post->comment_count.__(' comments', CMS_TXT_DOMAIN); } break;
                }     
            echo '</h3>'; 
        } 
                        
                
        echo '<ul class="comment-list">';
            $args = array('type' => 'comment', 'callback' => 'dcf_commentHTML');        
            if(GetDCCPI()->getIGeneral()->getOption('comments_reverse_children'))
            {
                $args['reverse_children'] = true;
            }
            wp_list_comments($args);
        echo '</ul>';
        
        echo '<div class="dc-clear-both"></div>';
        echo '</div> <!-- comments-section -->';           
    } else
    {
        echo '<div id="dc-comments-section-empty">';
        
        $DC_SHOW_NO_COMMENTS_INFO = false;
        
        if($DC_SHOW_NO_COMMENTS_INFO)
        {
            echo '<div class="dc-no-comments-info">'.__('No comments at this moment', CMS_TXT_DOMAIN).'</div>';    
        }
        
        echo '</div>';
    }
        
    if($post->comment_count > 0)
    {        
        
        if(get_option('page_comments'))
        {
            global $wp_rewrite; 
            $comment_page = get_query_var('cpage');
            if(!$comment_page)
            {
              $comment_page = 1;
            }

            $comment_max_page = get_comment_pages_count();

            if($comment_max_page > 1)
            {
              $prev_text = __('Prev', CMS_TXT_DOMAIN);
              $next_text = __('Next', CMS_TXT_DOMAIN);
              $DC_SHOW_COMMENTS_PAGES_NEXT_BTN = false; 
              $DC_SHOW_COMMENTS_PAGES_PREV_BTN = false;
              
              $comment_defaults_args = array(
                  'base' => add_query_arg('cpage', '%#%'),
                  'format' => '',
                  'total' => $comment_max_page,
                  'current' => $comment_page,
                  'echo' => true,
                  'prev_next' => false,                  
                  'add_fragment' => '#comments',
                  'end_size' => 3,
                  'mid_size' => 2
              );
              
              if($DC_SHOW_COMMENTS_PAGES_NEXT_BTN) { $comment_defaults_args['prev_text'] = '&laquo; '.$prev_text; }
              if($DC_SHOW_COMMENTS_PAGES_PREV_BTN) { $comment_defaults_args['next_text'] = $next_text.' &raquo;'; }
              if($DC_SHOW_COMMENTS_PAGES_NEXT_BTN or $DC_SHOW_COMMENTS_PAGES_PREV_BTN) { $comment_defaults_args['prev_next'] = true; }
              
              if($wp_rewrite->using_permalinks())
              {
                  $comment_defaults_args['base'] = user_trailingslashit(trailingslashit(get_permalink()) . 'comment-page-%#%', 'commentpaged');
              }

              $comment_args = wp_parse_args(array(), $comment_defaults_args);
              $comment_page_links = paginate_links($comment_args);   

              $out = '';
              $out .= '<div class="dc-comments-pages-links">';
                
                $DC_SHOW_BEFORE_COMMENTS_PAGES = false;
                
                if($DC_SHOW_BEFORE_COMMENTS_PAGES)
                {
                    $out .= '<span class="before">'.__('Pages', CMS_TXT_DOMAIN).': </span>';
                }
                $out .= $comment_page_links;
                $out .= '<div class="dc-clear-both"></div>';
              $out .= '</div>';
              echo $out;
            }
        }              
    }


/*
    global $post;
    global $user_ID;
    $commenter = wp_get_current_commenter();
    $user = wp_get_current_user();
    $user_identity = $user->exists() ? $user->display_name : '';    
                              
    if(get_option('comment_registration') && !$user_ID)
    {
        $out = '';
        $out .= '<div class="dc-send-comment-form-info-bar">'; 
            $out .= '<span class="span-info">'.__('You must be', CMS_TXT_DOMAIN).'<span> ';
            $out .= '<a class="anchor-info" href="'.wp_logout_url(get_permalink()).'">'.__('logged in', CMS_TXT_DOMAIN).'</a> '; 
            $out .= '<span class="span-info">'.__('to post comment.', CMS_TXT_DOMAIN).'</span>';
        $out .= '</div>';
        echo $out;             
    } else
    {
        $out  = '<div id="respond">';
            $out .= '<div class="dc-send-comment-form">';
            
                $out .= '<h4 class="leave-comment-head">'.__('Leave your comment', CMS_TXT_DOMAIN).'</h4>';
                $out .= '<form action="'.site_url('/wp-comments-post.php').'" method="post" id="commentform" name="commentform">';
                
                // if user is not loged
                if(!$user_ID) 
                {                    
                    $req_ne = (bool)get_option('require_name_email');                                         
                    $out .= '<div class="dc-control-label">';
                        $out .= '<span class="inner-label">'.__('Your Name', CMS_TXT_DOMAIN).'</span>';
                        if($req_ne) { $out .= '<span class="inner-info">('.__('required', CMS_TXT_DOMAIN).')</span>'; }
                    $out .= '</div>';                   
                    $out .= '<input type="text" value="'.$commenter['comment_author'].'" name="author" id="author" />';
                      
                    $out .= '<div class="dc-control-label">';
                        $out .= '<span class="inner-label">'.__('E-Mail', CMS_TXT_DOMAIN).'</span>';
                        if($req_ne) { $out .= '<span class="inner-info">('.__('required', CMS_TXT_DOMAIN).')</span>'; }
                    $out .= '</div>';                     
                    $out .= '<input type="text" value="'.$commenter['comment_author_email'].'" name="email" id="email" />';
                    
                    if(GetDCCPI()->getIGeneral()->getOption('comments_url_field')) 
                    {                    
                        $out .= '<div class="dc-control-label">';
                            $out .= '<span class="inner-label">'.__('Website', CMS_TXT_DOMAIN).'</span>';
                            // $out .= '<span class="inner-info">('.__('required', CMS_TXT_DOMAIN).')</span>';
                        $out .= '</div>';                          
                        $out .= '<input type="text" value="'.$commenter['comment_author_url'].'" name="url" id="url" />';
                    }
                    
                    if(GetDCCPI()->getIGeneral()->getOption('theme_authorize_comment')) 
                    {
                        $secure_data = dcf_getSecurityImage();
                        $out .= '<input type="hidden" name="dc_scode" value="'.$secure_data['code'].'" /> ';
                        
                        $out .= '<div class="dc-control-label">';
                            $out .= '<span class="inner-label">'.__('Authorization code from image', CMS_TXT_DOMAIN).'</span>';
                        $out .= '</div>';                         
                        $out .= '<input type="text" name="dc_scodeuser" value="" /><br />';                  
                        $out .= '<div class="dc-authorization-image">'.$secure_data['image'].'</div>';              
                    }
                } else
                {   // if some user is logged we display only information about loged user - the display name and how to logout
                    $out .= '<div class="dc-send-comment-form-info-bar">';
                        $out .= '<span class="span-info">'.__('Logged in as', CMS_TXT_DOMAIN).'</span> ';
                        $out .= '<a class="anchor-info" href="'.admin_url('profile.php').'">'.$user_identity.'</a>';
                        $out .= '<span class="span-info">. </span> ';
                        $out .= '<span class="span-info">'.__('Here you can', CMS_TXT_DOMAIN).'</span> ';
                        $out .= '<a class="anchor-info" href="'.wp_logout_url().'">'.__('log out', CMS_TXT_DOMAIN).'</a> ';
                        $out .= '<span class="span-info">'.__('of this account.', CMS_TXT_DOMAIN).'</span>';
                    $out .= '</div>';
                }

                $out .= '<div class="dc-control-label">';
                    $out .= '<span class="inner-label">'.__('Message', CMS_TXT_DOMAIN).'</span>';
                    $out .= '<span class="inner-info">('.__('required', CMS_TXT_DOMAIN).')</span>';
                $out .= '</div>'; 
                
                $out .= '<textarea rows="5" cols="10" name="comment" id="comment" ></textarea>';        
                $out .= '<div class="dc-clear-both"></div>';
                $out .= '<div class="dc-submit-btn-field">'; 
                    $out .= '<input type="submit" class="dc-submit-btn" value="'.__('Post comment', CMS_TXT_DOMAIN).'" />';
                $out .= '</div>';
                $out .= '<div class="dc-clear-both"></div>';
                echo $out;
                
                comment_id_fields();
                do_action('comment_form', $post->ID);                                    
                        
                $out = '</form>'; 
                $out .= '<div class="cancel-respond" id="cancel-comment-reply">';
                echo $out;
                                
                cancel_comment_reply_link(__('Cancel reply', CMS_TXT_DOMAIN));
                
                $out  = '</div>';               
            $out .= '</div>';        
        $out .= '</div>'; // respond       
        echo $out;
    } 
*/

    $commenter = wp_get_current_commenter();
    $user = wp_get_current_user();
    $user_identity = $user->exists() ? $user->display_name : '';
    $req_ne = get_option('require_name_email');                           
    
    $wpcf_logged_in_as = '';
    $wpcf_logged_in_as .= '<div class="dc-send-comment-form-info-bar">';
        $wpcf_logged_in_as .= '<span class="span-info">'.__('Logged in as', CMS_TXT_DOMAIN).'</span> ';
        $wpcf_logged_in_as .= '<a class="anchor-info" href="'.admin_url('profile.php').'">'.$user_identity.'</a>';
        $wpcf_logged_in_as .= '<span class="span-info">. </span> ';
        $wpcf_logged_in_as .= '<span class="span-info">'.__('Here you can', CMS_TXT_DOMAIN).'</span> ';
        $wpcf_logged_in_as .= '<a class="anchor-info" href="'.wp_logout_url().'">'.__('log out', CMS_TXT_DOMAIN).'</a> ';
        $wpcf_logged_in_as .= '<span class="span-info">'.__('of this account.', CMS_TXT_DOMAIN).'</span>';
    $wpcf_logged_in_as .= '</div>';                        
    
    $wpcf_must_log_in = '';
    $wpcf_must_log_in .= '<div class="dc-send-comment-form-info-bar">'; 
        $wpcf_must_log_in .= '<span class="span-info">'.__('You must be', CMS_TXT_DOMAIN).'<span> ';
        $wpcf_must_log_in .= '<a class="anchor-info" href="'.wp_logout_url(get_permalink()).'">'.__('logged in', CMS_TXT_DOMAIN).'</a> '; 
        $wpcf_must_log_in .= '<span class="span-info">'.__('to post comment.', CMS_TXT_DOMAIN).'</span>';
    $wpcf_must_log_in .= '</div>';                  
    
    $wpcf_author = '';
    $wpcf_author .= '<div class="dc-control-label">';
        $wpcf_author .= '<span class="inner-label">'.__('Your Name', CMS_TXT_DOMAIN).'</span>';
        if($req_ne) { $wpcf_author .= '<span class="inner-info">('.__('required', CMS_TXT_DOMAIN).')</span>'; }
    $wpcf_author .= '</div>';                   
    $wpcf_author .= '<input type="text" value="'.$commenter['comment_author'].'" name="author" id="author" />';                        
    
    $wpcf_email = '';
    $wpcf_email .= '<div class="dc-control-label">';
        $wpcf_email .= '<span class="inner-label">'.__('E-Mail', CMS_TXT_DOMAIN).'</span>';
        if($req_ne) { $wpcf_email .= '<span class="inner-info">('.__('required', CMS_TXT_DOMAIN).')</span>'; }
    $wpcf_email .= '</div>';                     
    $wpcf_email .= '<input type="text" value="'.$commenter['comment_author_email'].'" name="email" id="email" />';                        
                   
    $wpcf_url = '';
    if(GetDCCPI()->getIGeneral()->getOption('comments_url_field')) 
    {                    
        $wpcf_url .= '<div class="dc-control-label">';
            $wpcf_url .= '<span class="inner-label">'.__('Website', CMS_TXT_DOMAIN).'</span>';
            // $wpcf_url .= '<span class="inner-info">('.__('required', CMS_TXT_DOMAIN).')</span>';
        $wpcf_url .= '</div>';                          
        $wpcf_url .= '<input type="text" value="'.$commenter['comment_author_url'].'" name="url" id="url" />';
    }      
    
    $wpcf_dcsecure = '';
    if(GetDCCPI()->getIGeneral()->getOption('theme_authorize_comment')) 
    {
        $secure_data = dcf_getSecurityImage();
        $wpcf_dcsecure .= '<input type="hidden" name="dc_scode" value="'.$secure_data['code'].'" /> ';
        
        $wpcf_dcsecure .= '<div class="dc-control-label">';                                                                
            $wpcf_dcsecure .= '<span class="inner-label">'.__('Authorization code from image', CMS_TXT_DOMAIN).'</span>';
            $wpcf_dcsecure .= '<span class="inner-info">('.__('required', CMS_TXT_DOMAIN).')</span>';   
        $wpcf_dcsecure .= '</div>';                         
        $wpcf_dcsecure .= '<input type="text" name="dc_scodeuser" value="" /><br />';                  
        $wpcf_dcsecure .= '<div class="dc-authorization-image">'.$secure_data['image'].'</div>';              
    }                                          
    
    $wpcf_comment_field = '';
    $wpcf_comment_field .= '<div class="dc-control-label">';
        $wpcf_comment_field .= '<span class="inner-label">'.__('Message', CMS_TXT_DOMAIN).'</span>';
        $wpcf_comment_field .= '<span class="inner-info">('.__('required', CMS_TXT_DOMAIN).')</span>';
    $wpcf_comment_field .= '</div>';                         
    $wpcf_comment_field .= '<textarea rows="5" cols="10" name="comment" id="comment" ></textarea>';                            
    
    $args = array(
        'fields' => array(
            'author' => $wpcf_author,
            'email' => $wpcf_email,
            'url' => $wpcf_url,
            'dcsecure' => $wpcf_dcsecure
        ),
        'comment_notes_before' => '',
        'comment_notes_after' => '',
        'title_reply' => __('Leave your comment', CMS_TXT_DOMAIN),
        'logged_in_as' => $wpcf_logged_in_as,
        'must_log_in' => $wpcf_must_log_in,
        'comment_field' => $wpcf_comment_field,
        'label_submit' => __('Post comment', CMS_TXT_DOMAIN) 
    );
    echo '<div class="dc-send-comment-form">';
    comment_form($args);        
    echo '</div>';
    
echo '</div>'; 
    
?>
