<?php
/**********************************************************************
* OSAKA WORDPRESS THEME 
* (Ideal For Business And Personal Use: Portfolio or Blog)     
* 
* File name:   
*      cp_metaproject.php
* Brief:       
*      Part of theme control panel.
* Author:      
*      DigitalCavalry
* Author URI:
*      http://themeforest.net/user/DigitalCavalry
* Contact:
*      digitalcavalry@gmail.com 
***********************************************************************/

/*********************************************************** 
* Definitions
************************************************************/
 
/*********************************************************** 
* Class name:
*    DCC_ProjectMetaOpt
* Descripton:
*    Implementation of DCC_ProjectMetaOpt
***********************************************************/
class DCC_ProjectMetaOpt extends DCC_MetaMultiple 
{         
    /*********************************************************** 
    * Constructor
    ************************************************************/
    public function __construct() 
    {
        $this->_names = array(
            'dc_project_opt', 
            'dc_project_opt_cbox',
             
            'dc_project_layout', 
            
            'dc_project_sid_left', 
            'dc_project_sid_right',                 
             
            'dc_project_bg_image', 
            'dc_project_bg_attachment',
            'dc_project_bg_repeat',
            'dc_project_bg_color',
            'dc_project_bg_pos_x',
            'dc_project_bg_pos_y', 
            'dc_project_bg_pos_x_px',
            'dc_project_bg_pos_y_px',
            'dc_project_bg_pos_x_px_use_cbox',
            'dc_project_bg_pos_y_px_use_cbox',
            'dc_project_bg_use_cbox',
            'dc_project_bg_color_use_cbox',               
            
            'dc_project_image',
            'dc_project_image_desc',
            'dc_project_image_desc_display_cbox',
            'dc_project_image_alt',
            'dc_project_image_filter',
            
            'dc_project_video_url',
            'dc_project_video_desc',            
            'dc_project_video_desc_display_cbox',            
            'dc_project_video_display_cbox',
            
            'dc_project_only_content_cbox', 
            
            'dc_project_about_client_name',
            'dc_project_about_client_url',
            'dc_project_about_website_name',
            'dc_project_about_website_url',
            'dc_project_about_skills'
             
            );     
                     
        $this->_std = array(
            'dc_project_opt_cbox' => true,
            
            'dc_project_layout' => CMS_PAGE_LAYOUT_RIGHT_SIDEBAR,
            
            'dc_project_sid_left' => CMS_NOT_SELECTED,
            'dc_project_sid_right' => CMS_NOT_SELECTED,              
            
            'dc_project_bg_image' => '',
            'dc_project_bg_attachment' => 'scroll',
            'dc_project_bg_repeat' => 'no-repeat',
            'dc_project_bg_color' => '#E2E2E2',
            'dc_project_bg_pos_x' => 'center',
            'dc_project_bg_pos_y' => 'top',            
            'dc_project_bg_pos_x_px' => 0,
            'dc_project_bg_pos_y_px' => 0,
            'dc_project_bg_pos_x_px_use_cbox' => false,
            'dc_project_bg_pos_y_px_use_cbox' => false,            
            'dc_project_bg_use_cbox' => false,
            'dc_project_bg_color_use_cbox' => false,            
             
            'dc_project_image' => '', 
            'dc_project_image_desc' => '',
            'dc_project_image_desc_display_cbox' => false,
            'dc_project_image_alt' => '',
            'dc_project_image_filter' => CMS_IMAGE_FILTER_NONE,
            
            'dc_project_video_url' => '',            
            'dc_project_video_desc' => '',
            'dc_project_video_desc_display_cbox' => false,                
            'dc_project_video_display_cbox' => false,
            
            'dc_project_only_content_cbox' => false,
            
            'dc_project_about_client_name' => '',
            'dc_project_about_client_url' => '',
            'dc_project_about_website_name' => '',
            'dc_project_about_website_url' => '',
            'dc_project_about_skills' => ''                   
            );
                             
        $this->_title = 'Project Settings';
        $this->_slug = 'dc-project-settings';
        $this->_closed = true;
        $this->_post_type = DCC_ControlPanelCustomPosts::PT_PROJECT_POST;
        
        add_action('admin_menu', array(&$this, 'adminMenu')); 
        add_action('save_post', array(&$this, 'save'));        
    } // constructor 

    /*********************************************************** 
    * Public functions
    ************************************************************/        
      
    public function display()
    {       
        $meta = $this->initDisplay();                            
        global $post;           
        
        $out = '';     
        $out .= '<div class="dc-cms-custom-field-panel">';     
            $out .= $this->getMetaTopSavePanel();       
            $out .= '<div class="center-content-panel">';   
                                
                $out .= '<input type="hidden" name="dc_project_opt_cbox" checked="checked" />';        
        
                // layout
                $out .= $this->getGroupFieldBegin(array('title' => 'Project layout', 'max_w' => 800, 'mtop' => 30)); 
                    $out .= '<span class="dc-cms-control-top-label-nomargin">Select post layout</span>';                    
                    $out .= '<div class="dc-cms-page-layout-box">';
                    
                        $out .= '<div class="item">';
                            $out .= '<div class="layout-image-both-sidebars">Both sidebars</div>';                    
                            $out .= '<input type="radio" name="dc_project_layout" '.$this->attrChecked($meta['dc_project_layout'] == CMS_PAGE_LAYOUT_BOTH_SIDEBARS).' value="'.CMS_PAGE_LAYOUT_BOTH_SIDEBARS.'" />';
                        $out .= '</div>';  
                        
                        $out .= '<div class="item">';
                            $out .= '<div class="layout-image-left-sidebar">Left sidebar</div>';                    
                            $out .= '<input type="radio" name="dc_project_layout" '.$this->attrChecked($meta['dc_project_layout'] == CMS_PAGE_LAYOUT_LEFT_SIDEBAR).' value="'.CMS_PAGE_LAYOUT_LEFT_SIDEBAR.'" />';
                        $out .= '</div>';                                             

                        $out .= '<div class="item">';
                            $out .= '<div class="layout-image-right-sidebar">Right sidebar</div>';                    
                            $out .= '<input type="radio" name="dc_project_layout" '.$this->attrChecked($meta['dc_project_layout'] == CMS_PAGE_LAYOUT_RIGHT_SIDEBAR).' value="'.CMS_PAGE_LAYOUT_RIGHT_SIDEBAR.'" />';
                        $out .= '</div>'; 
                        
                        $out .= '<div class="item">';
                            $out .= '<div class="layout-image-full-width">Full width</div>';                    
                            $out .= '<input type="radio" name="dc_project_layout" '.$this->attrChecked($meta['dc_project_layout'] == CMS_PAGE_LAYOUT_FULL_WIDTH).' value="'.CMS_PAGE_LAYOUT_FULL_WIDTH.'" />';
                        $out .= '</div>';                         
                        
                        $out .= $this->getClearBoth();
                        
                    $out .= '</div>';
                    
                $out .= $this->getGroupFieldEnd();                         
                         
                // sidebar
                $out .= $this->getGroupFieldBegin(array('title' => 'Sidebars', 'max_w' => 800));
                    $out .= '<span class="dc-cms-control-top-label-nomargin">Left sidebar</span>';
                    $out .= GetDCCPI()->getIGeneral()->selectCtrlSidebarsList($meta['dc_project_sid_left'], 'dc_project_sid_left', 300);
                    
                    $out .= '<span class="dc-cms-control-top-label">Right sidebar</span>';
                    $out .= GetDCCPI()->getIGeneral()->selectCtrlSidebarsList($meta['dc_project_sid_right'], 'dc_project_sid_right', 300); 
                    $out .= '<div class="dc-cms-help-note-box">';
                        $out .= 'If sidebar is not selected, default sidebar will be used.';
                    $out .= '</div>';                      
                    
                $out .= $this->getGroupFieldEnd();             
        
                // background                                        
                $out .= $this->getGroupFieldBegin(array('title' => 'Background', 'max_w' => 800));
                    $out .= '<span class="dc-cms-control-top-label-nomargin">URL</span>'; 
                    $out .= '<input type="text" class="dc-cms-control-100per" name="dc_project_bg_image" value="'.$meta['dc_project_bg_image'].'" id="dc_id_dc_project_bg_image" /> ';
                    $out .= '<div class="dc-cms-btn-frame">';
                        $out .= '<input class="dc-cms-submit-image-btn" type="submit" name="dc_id_dc_project_bg_image" value="'.__('Load image', CMS_TXT_DOMAIN).'"> ';  
                    $out .= '</div>';                   
                
                    $out .= $this->getImagePreviewBox(array('path' => $meta['dc_project_bg_image'], 'width' => 240, 'height' => 180));  
                    
                    $out .= $this->getStdWrapperStart();
                    
                        $out .= $this->getStdColumnStart(array('width'=>220)); 
                            
                                $out .= '<span class="dc-cms-control-top-label-nomargin">Background X align</span>';   
                                $out .= '<select name="dc_project_bg_pos_x" class="dc-cms-control-100">';
                                    $out .= '<option value="left" '.$this->attrSelected($meta['dc_project_bg_pos_x'] == 'left').'>Left</option>';
                                    $out .= '<option value="center" '.$this->attrSelected($meta['dc_project_bg_pos_x'] == 'center').'>Center</option>';
                                    $out .= '<option value="right" '.$this->attrSelected($meta['dc_project_bg_pos_x'] == 'right').'>Right</option>';
                                $out .= '</select>'; 
                                                                
                                $out .= '<span class="dc-cms-control-top-label">Background Y align</span>';
                                $out .= '<select name="dc_project_bg_pos_y" class="dc-cms-control-100">';
                                    $out .= '<option value="top" '.$this->attrSelected($meta['dc_project_bg_pos_y'] == 'top').'>Top</option>';
                                    $out .= '<option value="center" '.$this->attrSelected($meta['dc_project_bg_pos_y'] == 'center').'>Center</option>';
                                    $out .= '<option value="bottom" '.$this->attrSelected($meta['dc_project_bg_pos_y'] == 'bottom').'>Bottom</option>';
                                $out .= '</select>';
                                
                                
                                $out .= '<span class="dc-cms-control-top-label">Background X position in pixels</span>';
                                $out .= $this->getCtrlInputInt('dc_project_bg_pos_x_px', $meta['dc_project_bg_pos_x_px']);                        
  
                                $out .= '<span class="dc-cms-control-top-label">Background Y position in pixels</span>';
                                $out .= $this->getCtrlInputInt('dc_project_bg_pos_y_px', $meta['dc_project_bg_pos_y_px']);
                                   
                                               
                        $out .= $this->getStdColumnEnd();                    
                    
                        $out .= $this->getStdColumnStart(array('width'=>150));
                            $out .= '<span class="dc-cms-control-top-label-nomargin">Attachment mode</span>';
                            $out .= $this->getStdInputsFieldStart();  
                                $out .= '<input type="radio" name="dc_project_bg_attachment" '.$this->attrChecked($meta['dc_project_bg_attachment'] == 'scroll').' value="scroll" /> Scroll';
                                $out .= $this->getBR();
                                $out .= '<input type="radio" name="dc_project_bg_attachment" '.$this->attrChecked($meta['dc_project_bg_attachment'] == 'fixed').' value="fixed" /> Fixed'; 
                                
                                $out .= '<span class="dc-cms-control-top-label">Background color</span>';
                                $out .= '<input type="text" class="dc-color-picker" value="'.$meta['dc_project_bg_color'].'" name="dc_project_bg_color" />';   
                            $out .= $this->getStdInputsFieldEnd();                                       
                        $out .= $this->getStdColumnEnd();                    
     
                        $out .= $this->getStdColumnStart(array('width'=>150));
                            $out .= '<span class="dc-cms-control-top-label-nomargin">Repeat mode</span>'; 
                            $out .= $this->getStdInputsFieldStart(); 
                                $out .= '<input type="radio" '.$this->attrChecked($meta['dc_project_bg_repeat'] == 'repeat').' value="repeat" name="dc_project_bg_repeat" /> Repeat';
                                $out .= $this->getBR();         
                                $out .= '<input type="radio" '.$this->attrChecked($meta['dc_project_bg_repeat'] == 'repeat-x').' value="repeat-x" name="dc_project_bg_repeat" /> Repeat X';
                                $out .= $this->getBR();
                                $out .= '<input type="radio" '.$this->attrChecked($meta['dc_project_bg_repeat'] == 'repeat-y').' value="repeat-y" name="dc_project_bg_repeat" /> Repeat Y';
                                $out .= $this->getBR();
                                $out .= '<input type="radio" '.$this->attrChecked($meta['dc_project_bg_repeat'] == 'no-repeat').' value="no-repeat" name="dc_project_bg_repeat" /> No repeat';    
                            $out .= $this->getStdInputsFieldEnd();
                        $out .= $this->getStdColumnEnd();

                        $out .= $this->getClearBoth();                   
                    $out .= $this->getStdWrapperEnd();
                      
                    $out .= '<span class="dc-cms-control-top-label">Other settings</span>';
                    $out .= $this->getStdInputsFieldStart();
                        $out .= '<input type="checkbox" name="dc_project_bg_use_cbox" '.$this->attrChecked($meta['dc_project_bg_use_cbox']).' /> Use background image'; 
                        $out .= $this->getBR(); 
                        $out .= '<input type="checkbox" name="dc_project_bg_color_use_cbox" '.$this->attrChecked($meta['dc_project_bg_color_use_cbox']).' /> Use background color';  
                        $out .= $this->getBR();                    
                        $out .= '<input type="checkbox" name="dc_project_bg_pos_x_px_use_cbox" '.$this->attrChecked($meta['dc_project_bg_pos_x_px_use_cbox']).' /> Use pixels X position';
                        $out .= $this->getBR(); 
                        $out .= '<input type="checkbox" name="dc_project_bg_pos_y_px_use_cbox" '.$this->attrChecked($meta['dc_project_bg_pos_y_px_use_cbox']).' /> Use pixels Y position';                    
                    $out .= $this->getStdInputsFieldEnd();                    
                $out .= $this->getGroupFieldEnd();          

                // main image
                $out .= $this->getGroupFieldBegin(array('title' => 'Main image', 'max_w' => 800, 'mtop' => 50));
    
                    $out .= '<span class="dc-cms-control-top-label-nomargin">URL</span>'; 
                    $out .= '<input type="text" class="dc-cms-control-wide" name="dc_project_image" value="'.$meta['dc_project_image'].'" id="dc_id_dc_project_image" /> ';
                    $out .= '<div class="dc-cms-btn-frame">';
                        $out .= '<input class="dc-cms-submit-image-btn" type="submit" name="dc_id_dc_project_image" value="'.__('Load image', CMS_TXT_DOMAIN).'"> ';  
                    $out .= '</div>';        

                    $out .= $this->getImagePreviewBox(array('path' => $meta['dc_project_image'], 'width' => 240, 'height' => 180));                                                               
                         
                    $out .= '<span class="dc-cms-control-top-label">Image filter</span>';  
                    $out .= $this->getStdInputsFieldStart();
                        $out .= '<input type="radio" name="dc_project_image_filter" value="'.CMS_IMAGE_FILTER_NONE.'" '.$this->attrChecked($meta['dc_project_image_filter'] == CMS_IMAGE_FILTER_NONE).' /> None';
                        $out .= $this->getBR();
                        $out .= '<input type="radio" name="dc_project_image_filter" value="'.CMS_IMAGE_FILTER_GRAYSCALE.'" '.$this->attrChecked($meta['dc_project_image_filter'] == CMS_IMAGE_FILTER_GRAYSCALE).' /> Grayscale';
                    $out .= $this->getStdInputsFieldEnd();
                    
                    
                    $out .= '<span class="dc-cms-control-top-label">Image description</span>'; 
                    $out .= '<textarea class="dc-cms-control-wide dc-cms-control-textarea dc-cms-control-h-40" name="dc_project_image_desc">'.$meta['dc_project_image_desc'].'</textarea>';

                    $out .= '<span class="dc-cms-control-top-label">Image alt</span>'; 
                    $out .= '<textarea class="dc-cms-control-wide dc-cms-control-textarea dc-cms-control-h-40" name="dc_project_image_alt">'.$meta['dc_project_image_alt'].'</textarea>';
                    
                    $out .= $this->getStdInputsFieldStart(array('mtop-type' => 'small'));
                        $out .= '<input type="checkbox" name="dc_project_image_desc_display_cbox" '.$this->attrChecked($meta['dc_project_image_desc_display_cbox']).' /> Display image description';                   
                    $out .= $this->getStdInputsFieldEnd();                            
                           
                $out .= $this->getGroupFieldEnd();                  
                
                // video
                $out .= $this->getGroupFieldBegin(array('title' => 'Video', 'max_w' => 800)); 
                
                    $out .= '<span class="dc-cms-control-top-label-nomargin">Youtube or Vimeo video URL</span>'; 
                    $out .= '<input type="text" class="dc-cms-control-wide" name="dc_project_video_url" value="'.$meta['dc_project_video_url'].'" /> ';                
                
                    $out .= '<span class="dc-cms-control-top-label">Video description</span>'; 
                    $out .= '<textarea name="dc_project_video_desc" class="dc-cms-control-textarea dc-cms-control-wide dc-cms-control-h-80">'.$meta['dc_project_video_desc'].'</textarea>';
                
                    $out .= $this->getStdInputsFieldStart(array('mtop-type' => 'small'));
                        $out .= '<input type="checkbox" name="dc_project_video_display_cbox" '.$this->attrChecked($meta['dc_project_video_display_cbox']).' /> Display video';                   
                        $out .= $this->getBR();
                        $out .= '<input type="checkbox" name="dc_project_video_desc_display_cbox" '.$this->attrChecked($meta['dc_project_video_desc_display_cbox']).' /> Display video description';                                                    
                    $out .= $this->getStdInputsFieldEnd();                
                
                $out .= $this->getGroupFieldEnd();                 
                
                // about project
                $out .= $this->getGroupFieldBegin(array('title' => 'About project', 'max_w' => 800));
                    $out .= '<span class="dc-cms-control-top-label-nomargin">Client name</span>';
                    $out .= '<input type="text" class="dc-cms-control-300" name="dc_project_about_client_name" value="'.$meta['dc_project_about_client_name'].'" />';
                    
                    $out .= '<span class="dc-cms-control-top-label">Client URL</span>';
                    $out .= '<input type="text" class="dc-cms-control-wide" name="dc_project_about_client_url" value="'.$meta['dc_project_about_client_url'].'" />';                                    
                 
                    $out .= '<span class="dc-cms-control-top-label">Project website name</span>';
                    $out .= '<input type="text" class="dc-cms-control-300" name="dc_project_about_website_name" value="'.$meta['dc_project_about_website_name'].'" />';
                    
                    $out .= '<span class="dc-cms-control-top-label">Project website URL</span>';
                    $out .= '<input type="text" class="dc-cms-control-wide" name="dc_project_about_website_url" value="'.$meta['dc_project_about_website_url'].'" />';                     

                    $out .= '<span class="dc-cms-control-top-label">Comma separated skills used in project</span>';
                    $out .= '<textarea class="dc-cms-control-textarea dc-cms-control-wide dc-cms-control-h-80" name="dc_project_about_skills" >'.$meta['dc_project_about_skills'].'</textarea>';   
                    
                $out .= $this->getGroupFieldEnd();                   
                
                // miscellaneous
                $out .= $this->getGroupFieldBegin(array('title' => 'Miscellaneous settings', 'max_w' => 800, 'mtop' => 50));                                                                     
                     $out .= $this->getStdInputsFieldStart();
                        $out .= '<input type="checkbox" name="dc_project_only_content_cbox" '.$this->attrChecked($meta['dc_project_only_content_cbox']).' /> Display only content without default formating';                    
                    $out .= $this->getStdInputsFieldEnd(); 
                $out .= $this->getGroupFieldEnd();                  
                
            $out .= '</div>';      
            $out .= $this->getMetaBottomSavePanel();     
        $out .= '</div>';
        
        echo $out;
    } 
}   
        
?>