<?php
/**********************************************************************
* OSAKA WORDPRESS THEME 
* (Ideal For Business And Personal Use: Portfolio or Blog)     
* 
* File name:   
*      cp_metapost.php
* Brief:       
*      Part of theme control panel.
* Author:      
*      DigitalCavalry
* Author URI:
*      http://themeforest.net/user/DigitalCavalry
* Contact:
*      digitalcavalry@gmail.com 
***********************************************************************/

/*********************************************************** 
* Definitions
************************************************************/

/*********************************************************** 
* Class name:
*    DCC_PostCommonMetaOpt
* Descripton:
*    Implementation of DCC_PostCommonMetaOpt
***********************************************************/
class DCC_PostCommonMetaOpt extends DCC_MetaMultiple 
{        
    /*********************************************************** 
    * Constructor
    ************************************************************/
    public function __construct() 
    {
        $this->_names = array(
            'post_common_opt', 
            'post_common_opt_cbox', 
            
            'post_layout', 
            
            'post_sid_left', 
            'post_sid_right',        
            
            'post_bg_image', 
            'post_bg_attachment',
            'post_bg_repeat',
            'post_bg_color',
            'post_bg_pos_x',
            'post_bg_pos_y', 
            'post_bg_pos_x_px',
            'post_bg_pos_y_px',
            'post_bg_pos_x_px_use_cbox',
            'post_bg_pos_y_px_use_cbox',
            'post_bg_use_cbox',
            'post_bg_color_use_cbox'           
            );
                          
        $this->_std = array(
            'post_common_opt_cbox' => true,
                             
            'post_layout' => CMS_PAGE_LAYOUT_RIGHT_SIDEBAR,
            
            'post_sid_left' => CMS_NOT_SELECTED,
            'post_sid_right' => CMS_NOT_SELECTED,           
            
            'post_bg_image' => '',
            'post_bg_attachment' => 'scroll',
            'post_bg_repeat' => 'no-repeat',
            'post_bg_color' => '#E2E2E2',
            'post_bg_pos_x' => 'center',
            'post_bg_pos_y' => 'top',            
            'post_bg_pos_x_px' => 0,
            'post_bg_pos_y_px' => 0,
            'post_bg_pos_x_px_use_cbox' => false,
            'post_bg_pos_y_px_use_cbox' => false,            
            'post_bg_use_cbox' => false,
            'post_bg_color_use_cbox' => false                          
            );
                             
        $this->_title = 'Post Common Settings';
        $this->_slug = 'dc-post-common-settings';
        $this->_closed = true;
        $this->_post_type = 'post';
        
        add_action('admin_menu', array(&$this, 'adminMenu')); 
        add_action('save_post', array(&$this, 'save')); 
    } 

    /*********************************************************** 
    * Public functions
    ************************************************************/             
      

    
    public function display()
    {       
        $meta = $this->initDisplay();                            
        global $post;           
        
        $out = '';     
        $out .= '<div class="dc-cms-custom-field-panel">';     
            $out .= $this->getMetaTopSavePanel();       
            $out .= '<div class="center-content-panel">';          
                              
                $out .= '<input type="hidden" name="post_common_opt_cbox" checked="checked" />'; 
                         
                // layout
                $out .= $this->getGroupFieldBegin(array('title' => 'Post layout', 'max_w' => 800, 'mtop' => 30)); 
                    $out .= '<span class="dc-cms-control-top-label-nomargin">Select post layout</span>';                    
                    $out .= '<div class="dc-cms-page-layout-box">';
                        
                        $out .= '<div class="item">';
                            $out .= '<div class="layout-image-both-sidebars">Both sidebars</div>';                    
                            $out .= '<input type="radio" name="post_layout" '.$this->attrChecked($meta['post_layout'] == CMS_PAGE_LAYOUT_BOTH_SIDEBARS).' value="'.CMS_PAGE_LAYOUT_BOTH_SIDEBARS.'" />';
                        $out .= '</div>';  
                        
                        $out .= '<div class="item">';
                            $out .= '<div class="layout-image-left-sidebar">Left sidebar</div>';                    
                            $out .= '<input type="radio" name="post_layout" '.$this->attrChecked($meta['post_layout'] == CMS_PAGE_LAYOUT_LEFT_SIDEBAR).' value="'.CMS_PAGE_LAYOUT_LEFT_SIDEBAR.'" />';
                        $out .= '</div>';                                             

                        $out .= '<div class="item">';
                            $out .= '<div class="layout-image-right-sidebar">Right sidebar</div>';                    
                            $out .= '<input type="radio" name="post_layout" '.$this->attrChecked($meta['post_layout'] == CMS_PAGE_LAYOUT_RIGHT_SIDEBAR).' value="'.CMS_PAGE_LAYOUT_RIGHT_SIDEBAR.'" />';
                        $out .= '</div>'; 
                        
                        $out .= '<div class="item">';
                            $out .= '<div class="layout-image-full-width">Full width</div>';                    
                            $out .= '<input type="radio" name="post_layout" '.$this->attrChecked($meta['post_layout'] == CMS_PAGE_LAYOUT_FULL_WIDTH).' value="'.CMS_PAGE_LAYOUT_FULL_WIDTH.'" />';
                        $out .= '</div>';                         
                        
                        $out .= $this->getClearBoth();
                        
                    $out .= '</div>';
                    
                $out .= $this->getGroupFieldEnd();                         
                         
                // sidebar
                $out .= $this->getGroupFieldBegin(array('title' => 'Sidebars', 'max_w' => 800));
                    $out .= '<span class="dc-cms-control-top-label-nomargin">Left sidebar</span>';
                    $out .= GetDCCPI()->getIGeneral()->selectCtrlSidebarsList($meta['post_sid_left'], 'post_sid_left', 300);
                    
                    $out .= '<span class="dc-cms-control-top-label">Right sidebar</span>';
                    $out .= GetDCCPI()->getIGeneral()->selectCtrlSidebarsList($meta['post_sid_right'], 'post_sid_right', 300); 
                    $out .= '<div class="dc-cms-help-note-box">';
                        $out .= 'If sidebar is not selected, default sidebar will be used.';
                    $out .= '</div>';                      
                    
                $out .= $this->getGroupFieldEnd();                          
                     
                // background                                        
                $out .= $this->getGroupFieldBegin(array('title' => 'Background', 'max_w' => 800));
                    $out .= '<span class="dc-cms-control-top-label-nomargin">URL</span>'; 
                    $out .= '<input type="text" class="dc-cms-control-100per" name="post_bg_image" value="'.$meta['post_bg_image'].'" id="dc_id_post_bg_image" /> ';
                    $out .= '<div class="dc-cms-btn-frame">';
                        $out .= '<input class="dc-cms-submit-image-btn" type="submit" name="dc_id_post_bg_image" value="'.__('Load image', CMS_TXT_DOMAIN).'"> ';  
                    $out .= '</div>';                   
                
                    $out .= $this->getImagePreviewBox(array('path' => $meta['post_bg_image'], 'width' => 240, 'height' => 180));  
                    
                    $out .= $this->getStdWrapperStart();
                    
                        $out .= $this->getStdColumnStart(array('width'=>220)); 
                            
                                $out .= '<span class="dc-cms-control-top-label-nomargin">Background X align</span>';   
                                $out .= '<select name="post_bg_pos_x" class="dc-cms-control-100">';
                                    $out .= '<option value="left" '.$this->attrSelected($meta['post_bg_pos_x'] == 'left').'>Left</option>';
                                    $out .= '<option value="center" '.$this->attrSelected($meta['post_bg_pos_x'] == 'center').'>Center</option>';
                                    $out .= '<option value="right" '.$this->attrSelected($meta['post_bg_pos_x'] == 'right').'>Right</option>';
                                $out .= '</select>'; 
                                                                
                                $out .= '<span class="dc-cms-control-top-label">Background Y align</span>';
                                $out .= '<select name="post_bg_pos_y" class="dc-cms-control-100">';
                                    $out .= '<option value="top" '.$this->attrSelected($meta['post_bg_pos_y'] == 'top').'>Top</option>';
                                    $out .= '<option value="center" '.$this->attrSelected($meta['post_bg_pos_y'] == 'center').'>Center</option>';
                                    $out .= '<option value="bottom" '.$this->attrSelected($meta['post_bg_pos_y'] == 'bottom').'>Bottom</option>';
                                $out .= '</select>';
                                
                                
                                $out .= '<span class="dc-cms-control-top-label">Background X position in pixels</span>';
                                $out .= $this->getCtrlInputInt('post_bg_pos_x_px', $meta['post_bg_pos_x_px']);                        
  
                                $out .= '<span class="dc-cms-control-top-label">Background Y position in pixels</span>';
                                $out .= $this->getCtrlInputInt('post_bg_pos_y_px', $meta['post_bg_pos_y_px']);
                                   
                                               
                        $out .= $this->getStdColumnEnd();                    
                    
                        $out .= $this->getStdColumnStart(array('width'=>150));
                            $out .= '<span class="dc-cms-control-top-label-nomargin">Attachment mode</span>';
                            $out .= $this->getStdInputsFieldStart();  
                                $out .= '<input type="radio" name="post_bg_attachment" '.$this->attrChecked($meta['post_bg_attachment'] == 'scroll').' value="scroll" /> Scroll';
                                $out .= $this->getBR();
                                $out .= '<input type="radio" name="post_bg_attachment" '.$this->attrChecked($meta['post_bg_attachment'] == 'fixed').' value="fixed" /> Fixed'; 
                                
                                $out .= '<span class="dc-cms-control-top-label">Background color</span>';
                                $out .= '<input type="text" class="dc-color-picker" value="'.$meta['post_bg_color'].'" name="post_bg_color" />';   
                            $out .= $this->getStdInputsFieldEnd();                                       
                        $out .= $this->getStdColumnEnd();                    
     
                        $out .= $this->getStdColumnStart(array('width'=>150));
                            $out .= '<span class="dc-cms-control-top-label-nomargin">Repeat mode</span>'; 
                            $out .= $this->getStdInputsFieldStart(); 
                                $out .= '<input type="radio" '.$this->attrChecked($meta['post_bg_repeat'] == 'repeat').' value="repeat" name="post_bg_repeat" /> Repeat';
                                $out .= $this->getBR();         
                                $out .= '<input type="radio" '.$this->attrChecked($meta['post_bg_repeat'] == 'repeat-x').' value="repeat-x" name="post_bg_repeat" /> Repeat X';
                                $out .= $this->getBR();
                                $out .= '<input type="radio" '.$this->attrChecked($meta['post_bg_repeat'] == 'repeat-y').' value="repeat-y" name="post_bg_repeat" /> Repeat Y';
                                $out .= $this->getBR();
                                $out .= '<input type="radio" '.$this->attrChecked($meta['post_bg_repeat'] == 'no-repeat').' value="no-repeat" name="post_bg_repeat" /> No repeat';    
                            $out .= $this->getStdInputsFieldEnd();
                        $out .= $this->getStdColumnEnd();

                        $out .= $this->getClearBoth();                   
                    $out .= $this->getStdWrapperEnd();
                      
                    $out .= '<span class="dc-cms-control-top-label">Other settings</span>';
                    $out .= $this->getStdInputsFieldStart();
                        $out .= '<input type="checkbox" name="post_bg_use_cbox" '.$this->attrChecked($meta['post_bg_use_cbox']).' /> Use background image'; 
                        $out .= $this->getBR(); 
                        $out .= '<input type="checkbox" name="post_bg_color_use_cbox" '.$this->attrChecked($meta['post_bg_color_use_cbox']).' /> Use background color';  
                        $out .= $this->getBR();                    
                        $out .= '<input type="checkbox" name="post_bg_pos_x_px_use_cbox" '.$this->attrChecked($meta['post_bg_pos_x_px_use_cbox']).' /> Use pixels X position';
                        $out .= $this->getBR(); 
                        $out .= '<input type="checkbox" name="post_bg_pos_y_px_use_cbox" '.$this->attrChecked($meta['post_bg_pos_y_px_use_cbox']).' /> Use pixels Y position';                    
                    $out .= $this->getStdInputsFieldEnd();                    
                $out .= $this->getGroupFieldEnd();                                                                                             
        
            $out .= '</div>';      
            $out .= $this->getMetaBottomSavePanel();     
        $out .= '</div>';
        
        echo $out;
    } 
}  

/*********************************************************** 
* Class name:
*    DCC_PostMetaOpt
* Descripton:
*    Implementation of DCC_PostMetaOpt
***********************************************************/
class DCC_PostMetaOpt extends DCC_MetaMultiple 
{         
    /*********************************************************** 
    * Constructor
    ************************************************************/
    public function __construct() 
    {
        $this->_names = array(
            'post_opt', 
            'post_opt_cbox',
             
            'post_image', 
            'post_image_desc',
            'post_image_desc_display_cbox',
            'post_image_alt',
            'post_image_filter',
            'post_image_hide_cbox',
            'post_image_hide_single_cbox',
            
            'post_video_url',
            'post_video_desc',            
            'post_video_desc_display_cbox',
            'post_video_display_cbox', 
            'post_video_hide_single_cbox',  
            
            'post_authors_arr', 
         //   'post_only_content_cbox',
            'post_misc_layout',                 
            );     
                     
        $this->_std = array(
            'post_opt_cbox' => true,
            
            'post_image' => '',
            'post_image_desc' => '',
            'post_image_desc_display_cbox' => false,
            'post_image_alt' => '', 
            'post_image_filter' => CMS_IMAGE_FILTER_NONE,
            'post_image_hide_cbox' => false,
            'post_image_hide_single_cbox' => false,
            
            'post_video_url' => '',            
            'post_video_desc' => '',
            'post_video_desc_display_cbox' => false,
            'post_video_display_cbox' => false, 
            'post_video_hide_single_cbox' => false,                    
            
            'post_authors_arr' => array(),
         //   'post_only_content_cbox' => false,
            'post_misc_layout' => 'normal' // normal, compact                        
            );
                             
        $this->_title = 'Post Settings';
        $this->_slug = 'dc-post-settings';
        $this->_closed = true;
        $this->_post_type = 'post';
        
        add_action('admin_menu', array(&$this, 'adminMenu')); 
        add_action('save_post', array(&$this, 'save'));        
    } // constructor 

    /*********************************************************** 
    * Public functions
    ************************************************************/        
      
    public function display()
    {       
        $meta = $this->initDisplay();                            
        global $post;           
        
        $out = '';     
        $out .= '<div class="dc-cms-custom-field-panel">';     
            $out .= $this->getMetaTopSavePanel();       
            $out .= '<div class="center-content-panel">';   
                                
                $out .= '<input type="hidden" name="post_opt_cbox" checked="checked" />';        
        
                // main image
                $out .= $this->getGroupFieldBegin(array('title' => 'Main image', 'max_w' => 800, 'mtop' => 30));
    
                    $out .= '<span class="dc-cms-control-top-label-nomargin">URL</span>'; 
                    $out .= '<input type="text" class="dc-cms-control-100per" name="post_image" value="'.$meta['post_image'].'" id="dc_id_post_image" /> ';      

                    $out .= $this->getImagePreviewBox(array('path' => $meta['post_image'], 'width' => 240, 'height' => 180, 'info' => true));
                    
                    $out .= '<div class="dc-cms-btn-frame">';
                        $out .= '<input class="dc-cms-submit-image-btn" type="submit" name="dc_id_post_image" value="'.__('Load image', CMS_TXT_DOMAIN).'"> ';  
                    $out .= '</div>';                      
                    
                    $out .= '<span class="dc-cms-control-top-label">Image filter</span>';  
                    $out .= $this->getStdInputsFieldStart();
                        $out .= '<input type="radio" name="post_image_filter" value="'.CMS_IMAGE_FILTER_NONE.'" '.$this->attrChecked($meta['post_image_filter'] == CMS_IMAGE_FILTER_NONE).' /> None';
                        $out .= $this->getBR();
                        $out .= '<input type="radio" name="post_image_filter" value="'.CMS_IMAGE_FILTER_GRAYSCALE.'" '.$this->attrChecked($meta['post_image_filter'] == CMS_IMAGE_FILTER_GRAYSCALE).' /> Grayscale';
                    $out .= $this->getStdInputsFieldEnd();
                                        
                    $out .= '<span class="dc-cms-control-top-label">Image description</span>'; 
                    $out .= '<textarea class="dc-cms-control-wide dc-cms-control-textarea dc-cms-control-h-40" name="post_image_desc">'.$meta['post_image_desc'].'</textarea>';
                   
                    $out .= '<span class="dc-cms-control-top-label">Image alt</span>'; 
                    $out .= '<textarea class="dc-cms-control-wide dc-cms-control-textarea dc-cms-control-h-40" name="post_image_alt">'.$meta['post_image_alt'].'</textarea>';                   
                    
                    $out .= '<span class="dc-cms-control-top-label">Other settings</span>'; 
                    $out .= $this->getStdInputsFieldStart();
                        $out .= '<input type="checkbox" name="post_image_desc_display_cbox" '.$this->attrChecked($meta['post_image_desc_display_cbox']).' /> Display image description';                   
                        $out .= $this->getBR();     
                        $out .= '<input type="checkbox" name="post_image_hide_cbox" '.$this->attrChecked($meta['post_image_hide_cbox']).' /> Hide image';   
                        $out .= $this->getBR();
                        $out .= '<input type="checkbox" name="post_image_hide_single_cbox" '.$this->attrChecked($meta['post_image_hide_single_cbox']).' /> Hide image on post single page only';   
                    $out .= $this->getStdInputsFieldEnd();             
                           
                $out .= $this->getGroupFieldEnd();                                    
                
                // video
                $out .= $this->getGroupFieldBegin(array('title' => 'Video', 'max_w' => 800)); 
                
                    $out .= '<span class="dc-cms-control-top-label-nomargin">YouTube or Vimeo video URL</span>'; 
                    $out .= '<input type="text" class="dc-cms-control-wide" name="post_video_url" value="'.$meta['post_video_url'].'" /> ';                
                
                    $out .= '<span class="dc-cms-control-top-label">Video description</span>'; 
                    $out .= '<textarea name="post_video_desc" class="dc-cms-control-textarea dc-cms-control-wide dc-cms-control-h-80">'.$meta['post_video_desc'].'</textarea>';
                                                   
                    $out .= $this->getStdInputsFieldStart(array('mtop-type' => 'small'));
                        $out .= '<input type="checkbox" name="post_video_display_cbox" '.$this->attrChecked($meta['post_video_display_cbox']).' /> Display video';
                        $out .= $this->getBR();
                        $out .= '<input type="checkbox" name="post_video_desc_display_cbox" '.$this->attrChecked($meta['post_video_desc_display_cbox']).' /> Display video description';                   
                        $out .= $this->getBR();
                        $out .= '<input type="checkbox" name="post_video_hide_single_cbox" '.$this->attrChecked($meta['post_video_hide_single_cbox']).' /> Hide video on post single page only';                   
                    $out .= $this->getStdInputsFieldEnd();                
                
                $out .= $this->getGroupFieldEnd(); 
                
                // miscellaneous
                $out .= $this->getGroupFieldBegin(array('title' => 'Miscellaneous settings', 'max_w' => 800, 'mtop' => 50));  
                     $out .= '<span class="dc-cms-control-top-label-nomargin">Layout</span>'; 
                     $out .= '<select name="post_misc_layout" class="dc-cms-control-100">';
                        $val = $meta['post_misc_layout'];
                        $out .= '<option value="normal" '.$this->attrSelected($val == 'normal').'>Normal</option>';
                        $out .= '<option value="compact" '.$this->attrSelected($val == 'compact').'>Compact</option>';
                     $out .= '</select>';
                    
                  //   $out .= '<span class="dc-cms-control-top-label">Other settings</span>';                                                                  
                  //   $out .= $this->getStdInputsFieldStart();
                  //      $out .= '<input type="checkbox" name="post_only_content_cbox" '.$this->attrChecked($meta['post_only_content_cbox']).' /> Display only content, without default formatting'.$this->getBookHelp(array('text' => 'Works only on post single page'));                    
                  //   $out .= $this->getStdInputsFieldEnd(); 
                $out .= $this->getGroupFieldEnd();                  
                
                // authors
                $blogusers = get_users();
                if(!is_array($meta['post_authors_arr'])) { $meta['post_authors_arr'] = array(); }
                
                if(is_array($blogusers) and count($blogusers) > 0)
                {
                    $out .= $this->getGroupFieldBegin(array('title' => 'Post additional authors', 'max_w' => 800));
                    
                    foreach($blogusers as $user)
                    {
                        $on_list = false;
                        $on_list = in_array($user->ID, $meta['post_authors_arr']);
                        
                        $out .= $this->getStdColumnStart(array('width'=>120));
                            $out .= '<input type="checkbox" ';
                            if((int)$post->post_author != (int)$user->ID)
                            {
                                $out .= ' name="post_authors_arr[]" ';
                            }
                            $out .= $this->attrChecked($on_list or ($post->post_author == $user->ID));
                            $out .= $this->attrDisabled($post->post_author == $user->ID);
                            $out .= ' value="'.$user->ID.'" /> '.$user->display_name;                        
                        $out .= $this->getStdColumnEnd();                                                                     
                    }
                    $out .= $this->getClearBoth();
                    
                    $out .= $this->getGroupFieldEnd();        
                }     
        
            $out .= '</div>';      
            $out .= $this->getMetaBottomSavePanel();     
        $out .= '</div>';
        
        echo $out;
    } 
}   

/*********************************************************** 
* Class name:
*    DCC_PostMetaSEO
* Descripton:
*    Implementation of DCC_PostMetaSEO
***********************************************************/
class DCC_PostMetaSEO extends DCC_MetaMultiple 
{         
    /*********************************************************** 
    * Constructor
    ************************************************************/
    public function __construct() 
    {
        $this->_names = array(
            'post_seo_opt', 
            'post_seo_opt_cbox',
            
            'post_seo_active_cbox', 
            
            'post_seo_title',
            'post_seo_title_use_cbox',
            'post_seo_add_blog_name_cbox',

            'post_seo_keywords',
            'post_seo_keywords_use_cbox',

            'post_seo_desc',
            'post_seo_desc_use_cbox',
            
            'post_seo_noindex_cbox',
            'post_seo_nofollow_cbox',
            'post_seo_nosnippet_cbox',
            'post_seo_noodp_cbox',
            'post_seo_noarchive_cbox',
            'post_seo_noimageindex_cbox',
            
            'post_seo_private_meta' 
            );     
                     
        $this->_std = array(
            'post_seo_opt_cbox' => true,
            
            'post_seo_active_cbox' => false,
            
            'post_seo_title' => '',
            'post_seo_title_use_cbox' => false,
            'post_seo_add_blog_name_cbox' => false,
            
            'post_seo_keywords' => '',
            'post_seo_keywords_use_cbox' => false,            

            'post_seo_desc' => '',
            'post_seo_desc_use_cbox' => false,
            
            'post_seo_noindex_cbox' => false,
            'post_seo_nofollow_cbox' => false,
            'post_seo_nosnippet_cbox' => false,
            'post_seo_noodp_cbox' => false,
            'post_seo_noarchive_cbox' => false,
            'post_seo_noimageindex_cbox'  => false,               
                
            'post_seo_private_meta' => array()    
            );
                             
        $this->_title = 'Post SEO Settings';
        $this->_slug = 'dc-post-seo-settings';
        $this->_closed = true;
        $this->_post_type = 'post';
        
        add_action('admin_menu', array(&$this, 'adminMenu')); 
        add_action('save_post', array(&$this, 'save'));        
    } // constructor 

    /*********************************************************** 
    * Public functions
    ************************************************************/        
    
    public function save($post_id)
    {    
        global $post;
          
        if(isset($_POST['post_type']) and 'page' == $_POST['post_type']) 
        {  
            if(!current_user_can('edit_page', $post_id))
            {  
                return $post_id;
            }  
        } else 
        {  
            if(!current_user_can('edit_post', $post_id)) 
            { 
                return $post_id;  
            }
        }  

        $data = array();
        $count = count($this->_names);
        if(isset($_POST[($this->_names[0].'_cbox')]))
        {        
            for($i = 1; $i < $count; $i++)
            {
                if($this->_names[$i] == 'post_seo_private_meta')
                {
                    $list = $_POST['post_seo_private_meta_list'];
                    $list = explode(',', $list);
                    
                    $private_meta = array();
                    if(is_array($list))
                    {
                        foreach($list as $index)
                        {
                            if($index == '') { continue; }
                            $obj = new DCC_PrivateSeoMeta();
                            
                            if(isset($_POST['dc-seo-private-meta-'.$index.'-name']))
                            {
                                $obj->_name = $_POST['dc-seo-private-meta-'.$index.'-name'];
                                $obj->_content = $_POST['dc-seo-private-meta-'.$index.'-content'];
                                $obj->_active = isset($_POST['dc-seo-private-meta-'.$index.'-active']) ? true : false; 
                                array_push($private_meta, $obj);                            
                            }
                        }
                    }                    
                    
                    $data[$this->_names[$i]] = $private_meta;
                } else
                {                
                    $checkbox = strstr($this->_names[$i], '_cbox');
                    if($checkbox !== false) { $checkbox = true; }
                    
                    if($checkbox)
                    {
                       $data[$this->_names[$i]] = isset($_POST[$this->_names[$i]]) ? true : false;
                    } else
                    {
                       $data[$this->_names[$i]] = $_POST[$this->_names[$i]]; 
                    }
                }
            }    

            update_post_meta($post_id, $this->_names[0], $data);                    
        } else
        {
           $t_value = get_post_meta($post_id, $this->_names[0], true);
           if($t_value != '')
           {
                $t_value[($this->_names[0].'_cbox')] = false;
                update_post_meta($post_id, $this->_names[0], $t_value);    
           }  
        }
    }
      
    public function display()
    {       
        $meta = $this->initDisplay();                            
        global $post;           
        
        $out = '';     
        $out .= '<div class="dc-cms-custom-field-panel">';     
            $out .= $this->getMetaTopSavePanel();       
            $out .= '<div class="center-content-panel">';   
                                
                $out .= '<input type="hidden" name="post_seo_opt_cbox" checked="checked" />';        
        
                $out .= $this->getGroupFieldBegin(array('title' => 'SEO Settings', 'max_w' => 800, 'mtop' => 30)); 
                            
                    $out .= '<input type="checkbox" name="post_seo_active_cbox" '.$this->attrChecked($meta['post_seo_active_cbox']).' /> Active'; 
                    
                    $out .= '<span class="dc-cms-control-top-label">Title</span>'; 
                    $out .= '<textarea class="dc-cms-control-textarea dc-cms-control-h-40 dc-cms-control-wide" name="post_seo_title">'.$meta['post_seo_title'].'</textarea>';
                    $out .= $this->getStdInputsFieldStart();
                        $out .= '<input type="checkbox" name="post_seo_title_use_cbox" '.$this->attrChecked($meta['post_seo_title_use_cbox']).' /> Use title';
                        $out .= $this->getBR();
                        $out .= '<input type="checkbox" name="post_seo_add_blog_name_cbox" '.$this->attrChecked($meta['post_seo_add_blog_name_cbox']).' /> Add blog name before title';                        
                    $out .= $this->getStdInputsFieldEnd();
                    
                    $out .= '<span class="dc-cms-control-top-label">Keywords meta tag (if more then one, you can use comma to separate it)</span>'; 
                    $out .= '<textarea class="dc-cms-control-textarea dc-cms-control-h-60 dc-cms-control-wide" name="post_seo_keywords">'.$meta['post_seo_keywords'].'</textarea>';
                    $out .= $this->getStdInputsFieldStart();
                        $out .= '<input type="checkbox" name="post_seo_keywords_use_cbox" '.$this->attrChecked($meta['post_seo_keywords_use_cbox']).' /> Use keywords'; 
                    $out .= $this->getStdInputsFieldEnd();
                    
                    $out .= '<span class="dc-cms-control-top-label">Description meta tag</span>'; 
                    $out .= '<textarea class="dc-cms-control-textarea dc-cms-control-h-80 dc-cms-control-wide" name="post_seo_desc">'.$meta['post_seo_desc'].'</textarea>';
                    $out .= $this->getStdInputsFieldStart();
                        $out .= '<input type="checkbox" name="post_seo_desc_use_cbox" '.$this->attrChecked($meta['post_seo_desc_use_cbox']).' /> Use description';
                    $out .= $this->getStdInputsFieldEnd();                    
                    
                    $out .= '<span class="dc-cms-control-top-label">Robots meta tag</span>'; 
                    $out .= $this->getStdInputsFieldStart();
                        $out .= '<input type="checkbox" name="post_seo_noindex_cbox" '.$this->attrChecked($meta['post_seo_noindex_cbox']).' /> noindex';
                        $out .= $this->getBR();
                        $out .= '<input type="checkbox" name="post_seo_nofollow_cbox" '.$this->attrChecked($meta['post_seo_nofollow_cbox']).' /> nofollow';
                        $out .= $this->getBR();                                                 
                        $out .= '<input type="checkbox" name="post_seo_nosnippet_cbox" '.$this->attrChecked($meta['post_seo_nosnippet_cbox']).' /> nosnippet';
                        $out .= $this->getBR();  
                        $out .= '<input type="checkbox" name="post_seo_noodp_cbox" '.$this->attrChecked($meta['post_seo_noodp_cbox']).' /> noodp';
                        $out .= $this->getBR(); 
                        $out .= '<input type="checkbox" name="post_seo_noarchive_cbox" '.$this->attrChecked($meta['post_seo_noarchive_cbox']).' /> noarchive';
                        $out .= $this->getBR();  
                        $out .= '<input type="checkbox" name="post_seo_noimageindex_cbox" '.$this->attrChecked($meta['post_seo_noimageindex_cbox']).' /> noimageindex';                       
                    $out .= $this->getStdInputsFieldEnd();
                    
                    $out .= '<span class="dc-cms-control-top-label">Private meta tags</span>';  
                    if(!is_array($meta['post_seo_private_meta'])) { $meta['post_seo_private_meta'] = array(); }
                    
                    $list = '';
                    $meta_count = count($meta['post_seo_private_meta']);
                    
                    for($i = 0; $i < $meta_count; $i++)
                    {
                        if($i > 0) { $list .= ','; }
                        $list .= $i;
                    }                    
                     
                    $out .= '<div class="dc-post-private-seo-meta-wrapper">'; 

                        $out .= '<input type="hidden" name="post_seo_private_meta_list" value="'.$list.'" />';
                        for($i = 0; $i < $meta_count; $i++)
                        {
                            $out .= DCC_PrivateSeoMeta::getHTMLMeta($meta['post_seo_private_meta'][$i], $i);
                        }

                    $out .= '</div>';
                    
                    $out .= '<div class="dc-cms-btn-frame">';
                        $out .= '<span class="dc-cms-action-name">dc_add_seo_meta</span>';
                        $out .= '<input class="dc-cms-submit-btn" type="button" name="dc-post-meta-add-private-seo-meta" value="Add meta" /> ';  
                    $out .= '</div>';                      
                    
                    
                    
        
                $out .= $this->getGroupFieldEnd();
        
            $out .= '</div>';      
            $out .= $this->getMetaBottomSavePanel();     
        $out .= '</div>';
        
        echo $out;
    } 
}    
        
?>
