<?php
/**********************************************************************
* OSAKA WORDPRESS THEME  
* (Ideal For Business And Personal Use: Portfolio or Blog)     
* 
* File name:   
*      cp_menu.php 
* Brief:       
*      Part of theme control panel.
* Author:      
*      DigitalCavalry
* Author URI:
*      http://themeforest.net/user/DigitalCavalry
* Contact:
*      digitalcavalry@gmail.com 
***********************************************************************/

/*********************************************************** 
* Definitions
************************************************************/

class DCC_MenuItemStdMetaObjectData
{    
    /*********************************************************** 
    * Constructor
    ************************************************************/     
    public function __construct()
    {
        $this->core = array();
        $this->subtext = array();
        $this->ul = array(); 
        $this->custom = array(); 
        $this->link = array(); 
        $this->misc = array(); 
    }
   
    /*********************************************************** 
    * Public members
    ************************************************************/ 
    public $core;    
    public $subtext;
    public $ul; 
    public $custom; 
    public $link; 
    public $misc;    
}   

/*********************************************************** 
* Class name:
*    DCC_ControlPanelMenu
* Descripton:
*    Implementation of DCC_Menu 
***********************************************************/
class DCC_ControlPanelMenu extends DCC_ControlPanelBase 
{        
    /*********************************************************** 
    * Constructor
    ************************************************************/
    public function __construct() 
    {
        
        
        global $wpdb;
        $this->_db_table_menu_name =  $wpdb->prefix . CMS_THEME_NAME_SLUG . '_' . 'dc_menu';
        $this->_db_table_items_name = $wpdb->prefix . CMS_THEME_NAME_SLUG . '_' . 'dc_menu_items';            
        
        $this->setupDBTables();  
                                    
        $this->_DBIDOPT_OPTIONS = CMS_THEME_NAME_UPPERCASE.'_MENU_OPT';
        $this->setDefaults();
        
        $this->_options = get_option($this->_DBIDOPT_OPTIONS);
        if (!is_array($this->_options))
        {            
            add_option($this->_DBIDOPT_OPTIONS, $this->_optionsDef);
            $this->_options = get_option($this->_DBIDOPT_OPTIONS);
        }       

        $this->getMenuList();                                                
    } 

    /*********************************************************** 
    * Public members
    ************************************************************/      
    public $_options = Array();

    /*********************************************************** 
    * Private members
    ************************************************************/    
    private $_DBIDOPT_OPTIONS = null;
    private $_db_table_menu_name = null;
    private $_db_table_items_name = null;    
                   
    private $_optionsDef = Array(
        'active_menu' => CMS_NOT_SELECTED,
        'active_theme' => ''
        );               
 
    private $_menus_list = array(); 
    private $_items_list = array();
   
    private $_is_page = false;
    private $_is_category = false;
    private $_is_custom = false;    
    
     protected $_submenu = array (
        'Menu manager' => 'dc-menu-opt',        
        'Export / Import menu settings' => 'dc-menu-subpage-export-opt' 
     );    
    
    /*********************************************************** 
    * Public functions
    ************************************************************/
             
    public function renderTab($global_menu)
    {   
        $this->process();
        $this->renderCMS($global_menu);
    }

    public function ajaxAddCustomLink()
    {
        global $wpdb;
        
        $url = $_POST['url'];
        $label = $_POST['label'];
        $menu_id = $_POST['menu_id']; 
        
        $result = $wpdb->insert($this->_db_table_items_name, array('menu_id' => $menu_id, 'label' => $label, 'url' => $url, 'type' => 'custom'));
        
        if($result !== false)
        {
            $db_id = $wpdb->insert_id;
            
            $liobj = new stdClass();

            $liobj->asmega = false;

            $liobj->assidebar = false;
            $liobj->content = '';
            $liobj->class = '';                                                                                                 

            $liobj->hide = false;            
            $liobj->hidechild = false;            
            $liobj->id = $db_id;

            $liobj->label = $label; 
            $liobj->meta = '';
            $liobj->megatype = 0;

            $liobj->parent = 0;
            $liobj->rel = '';
            $liobj->sidebarid = '';
            $liobj->style = '';
            $liobj->target = '_self';
            $liobj->title = '';
            $liobj->type = 'custom';
         
            $liobj->url = $url;
        
            
            $out = '';                       
                $out .= $this->renderSortableLiCMS($liobj);
                $out .= '</li>';
            echo $out;
            
        } else
        {
            echo 'error';
        }            
    }    
    
    public function ajaxAddPageLink()
    {
        global $wpdb;
        
        $wpid = $_POST['wpid'];
        $url = get_permalink($wpid);
        $label = $_POST['label'];
        $menu_id = $_POST['menu_id']; 
        
        $result = $wpdb->insert($this->_db_table_items_name, array('menu_id' => $menu_id, 'label' => $label, 'url' => $url, 'wpid' => $wpid, 'type' => 'page'));
        
        if($result !== false)
        {
            $db_id = $wpdb->insert_id;
            
            $liobj = new stdClass();

            $liobj->asmega = false;

            $liobj->assidebar = false;
            $liobj->content = '';
            $liobj->class = '';                                                                                                 

            $liobj->hide = false;            
            $liobj->hidechild = false;            
            $liobj->id = $db_id;

            $liobj->label = $label; 
            $liobj->meta = '';
            $liobj->megatype = 0;

            $liobj->parent = 0;
            $liobj->rel = '';
            $liobj->sidebarid = '';
            $liobj->style = '';
            $liobj->target = '_self';
            $liobj->title = '';
            $liobj->type = 'page';
         
            $liobj->url = $url;
            $liobj->wpid = $wpid; 
        
            
            $out = '';                       
                $out .= $this->renderSortableLiCMS($liobj);
                $out .= '</li>';
            echo $out;
            
        } else
        {
            echo 'error';
        }            
    }    
    
    public function ajaxAddCategoryLink()
    {
        global $wpdb;
        
        $wpid = $_POST['wpid'];
        $url = get_category_link($wpid);
        $label = $_POST['label'];
        $menu_id = $_POST['menu_id']; 
        
        $result = $wpdb->insert($this->_db_table_items_name, array('menu_id' => $menu_id, 'label' => $label, 'url' => $url, 'wpid' => $wpid, 'type' => 'category'));
        
        if($result !== false)
        {
            $db_id = $wpdb->insert_id;
            
            $liobj = new stdClass();

            $liobj->asmega = false;

            $liobj->assidebar = false;
            $liobj->content = '';
            $liobj->class = '';                                                                                                 

            $liobj->hide = false;            
            $liobj->hidechild = false;            
            $liobj->id = $db_id;

            $liobj->label = $label; 
            $liobj->meta = '';
            $liobj->megatype = 0;

            $liobj->parent = 0;
            $liobj->rel = '';
            $liobj->sidebarid = '';
            $liobj->style = '';
            $liobj->target = '_self';
            $liobj->title = '';
            $liobj->type = 'category';
         
            $liobj->url = $url;
            $liobj->wpid = $wpid; 
        
            
            $out = '';                       
                $out .= $this->renderSortableLiCMS($liobj);
                $out .= '</li>';
            echo $out;
            
        } else
        {
            echo 'error';
        }            
    }     
 
    /*********************************************************** 
    * Private functions
    ************************************************************/
    private function setDefaults()
    {

    } 
    
    private function getActiveMenuCMS()
    {
        $value = false;
        if($this->_options['active_menu'] != CMS_NOT_SELECTED)
        {            
            if(is_array($this->_menus_list))
            {
                foreach($this->_menus_list as $m)
                {
                    if($this->_options['active_menu'] == $m->id)
                    {
                        $value = $m;
                        break;
                    }
                }
                
                // if we cant find menu width given id we will set first menu as active 
                if($value === false)
                {
                    if(count($this->_menus_list) > 0)
                    {
                        $value = $this->_menus_list[0];
                    }
                }
            }
        }
        return $value;
    }        
    
    public function getMenuList()
    {
        global $wpdb;
        $list = array();
        
        $table_name = $this->_db_table_menu_name; 
        $query = "SELECT * FROM $table_name ORDER BY name ASC";
        $this->_menus_list = $wpdb->get_results($query);        
        if(!is_array($this->_menus_list)) {$this->_menus_list = array();} else { $list = $this->_menus_list; }          
        
        return $list;
    }    
    
    
    
             
       
    private function setupDBTables()
    {
        global $wpdb;
        $wpdb->dc_menu_items = $this->_db_table_items_name; 
        $wpdb->dc_menu = $this->_db_table_menu_name;       
    
        $charset_collate = '';
        if(version_compare(mysql_get_server_info(), '4.1.0', '>=')) 
        {
            if ( ! empty($wpdb->charset) )
                $charset_collate = "DEFAULT CHARACTER SET $wpdb->charset";
            if ( ! empty($wpdb->collate) )
                $charset_collate .= " COLLATE $wpdb->collate";
        }           
    
        if($wpdb->get_var("SHOW TABLES LIKE '$wpdb->dc_menu_items'") != $wpdb->dc_menu_items) 
        {                                   
             $sql = "CREATE TABLE " . $wpdb->dc_menu_items . " (
            id bigint(20) unsigned NOT NULL auto_increment,
            menu_id bigint(20) unsigned NOT NULL default '0',
            status varchar(20) NOT NULL default 'draft',
            type varchar(20) NOT NULL default 'custom',
            pos int(11) NOT NULL default '0',
            parent bigint(20) NOT NULL default '0',
            wpid bigint(20) unsigned NOT NULL default '0',
            label text NOT NULL default '',
            url varchar(255) NOT NULL default '',
            target varchar(20) NOT NULL default '_self',
            rel varchar(255) NOT NULL default '',
            title varchar(255) NOT NULL default '', 
            meta longtext NOT NULL default '',
            content longtext NOT NULL default '',
            current tinyint NOT NULL default '0' ,
            current_child tinyint NOT NULL default '0' ,
            count tinyint NOT NULL default '0' ,
            childs tinyint NOT NULL default '0' ,              
            PRIMARY KEY id (id)
            ) $charset_collate;";
            

            // id:         unique item id
            // menu_id:    unique menu id, item is assigned to this menu
            // meta:       any value depended from implemetation, in most cases array with multiple values
            // status:     draft, publish
            // type:       custom, page, category 
            // parent:     parent item id    
            // wpid:       wordpress category or page ID when type is set to category or page
            // title:      title attribute value
            // target:     _self or _blank
            // rel:        rel attribute value
            // url:        item url address
            // pos:        zero basex index position of item in menu part
            // label:      item text label
            
            
            require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
            dbDelta($sql);                                                         
        }      
        
        if($wpdb->get_var("SHOW TABLES LIKE '$wpdb->dc_menu'") != $wpdb->dc_menu) 
        {                             
             $sql = "CREATE TABLE " . $wpdb->dc_menu . " (
            id bigint(20) unsigned NOT NULL auto_increment,
            name text NOT NULL default '',
            meta longtext NOT NULL default '', 
            PRIMARY KEY id (id)
            ) $charset_collate;";

            require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
            dbDelta($sql);                                                         
        }             
    }    
    
    public function getMenu($args=array(), $echo=true)
    {
        $def = array(            
            'menu_id' => CMS_NOT_SELECTED,
            'position' => 'static',
            'left' => null,
            'top' => null,
            'right' => null,
            'bottom' => null,
            'responsive' => true        
        );      

        $args = $this->combineArgs($def, $args);  
        
        $out = '';
        $menu = $this->getSortedMenuItems($args['menu_id']); 
                
        if(count($menu) > 0)
        {
            $out = $this->renderTopItems($menu, $args);
            if($args['responsive'])
            {
                $out .= $this->renderResponsive($menu, $args);
            }                   
        }                    
          
        if($echo) { echo $out; } else { return $out; }   
    }
    
    private function renderResponsive($menu, $args=array())
    {
        $out = '';
        $out .= '<select id="dc-primary-theme-menu-responsive">';
        
        foreach($menu as $item)
        {
            if($item->meta->core['hide'] or $item->meta->core['hide-in-responsive']) { continue; } 
            
            if((($item->url != '') or 
                ($item->meta->link['url-use'] and $item->meta->link['url'] != '') or
                ($item->meta->link['page-use'] and $item->meta->link['page'] != CMS_NOT_SELECTED)) and
               !$item->meta->core['as-nl'])
            {
                $out .= '<option ';            
                
                    $out .= ' class="level-'.$item->level.'" ';
                
                    if(!$item->meta->core['as-nl'])
                    {
                        if($item->meta->link['url-use'] and $item->meta->link['url'] != '')
                        { $out .= ' value="'.$item->meta->link['url'].'" '; } 
                        else if($item->meta->link['page-use'] and $item->meta->link['page'] != CMS_NOT_SELECTED)
                        { $out .= ' value="'.get_permalink($item->meta->link['page']).'" '; } 
                        else { $out .= ' value="'.$item->url.'" '; } 
                    }
                    
                    if($item->current) { $out .= ' selected="selected" '; }             
                
                $out .= ' >';
                    $out .= stripcslashes($item->label);
                $out .= '</option>';             
            }
            
            if($item->count > 0 and !$item->meta->core['hide-childs'])  
            {
                $out .= $this->renderResponsiveSubItems($item->childs); 
            }                       
        }    
        
        $out .= '</select>';
    
        return $out;
    }
    
    private function renderResponsiveSubItems($submenu)
    {
        $out = '';        
        
        foreach($submenu as $item)
        {
            if($item->meta->core['hide'] or $item->meta->core['hide-in-responsive']) { continue; }
            
            if(($item->meta->core['as-empty'] or $item->meta->core['as-text'] or 
               $item->meta->core['as-head-nl'] or $item->meta->core['as-head-fancy']) and
               ($item->count == 0 or $item->meta->core['hide-childs'])) 
            {                                                                       
                continue;   
            }        
            
            if((($item->url != '') or 
                ($item->meta->link['url-use'] and $item->meta->link['url'] != '') or
                ($item->meta->link['page-use'] and $item->meta->link['page'] != CMS_NOT_SELECTED)) and
               !$item->meta->core['as-nl'])
            {            
            
                $out .= '<option ';
                          
                    $out .= ' class="level-'.$item->level.'" ';
                                                           
                    if(!$item->meta->core['as-nl'])
                    {
                        if($item->meta->link['url-use'] and $item->meta->link['url'] != '')
                        { $out .= ' value="'.$item->meta->link['url'].'" '; } 
                        else if($item->meta->link['page-use'] and $item->meta->link['page'] != CMS_NOT_SELECTED)
                        { $out .= ' value="'.get_permalink($item->meta->link['page']).'" '; } 
                        else { $out .= ' value="'.$item->url.'" '; } 
                    }                           
                        
                    if($item->current) { $out .= ' selected="selected" '; }    
                          
                $out .= ' >';
                    for($i = 0; $i < $item->level; $i++)
                    {
                        $out .= '- ';
                    }
                    $out .= ' ';
                    $out .= stripcslashes($item->label);
                $out .= '</option>';     
           
            }
           
            if($item->count > 0 and !$item->meta->core['hide-childs'])
            {                            
                $out .= $this->renderResponsiveSubItems($item->childs);
            }                               
        }    
        
        return $out;      
    }
    
    
    
    private function renderTopItems($menu, $args=array())
    {      
                         
        $out = '';
        $out .= '<div id="dc-primary-theme-menu-wrapper-wrapper">';
        $out .= '<div id="dc-primary-theme-menu-wrapper">';
        $out .= '<ul id="dc-primary-theme-menu">';
        
        foreach($menu as $item)
        {
            if($item->meta->core['hide']) { continue; }            
            
            $li_class = '';
            if($item->current or $item->current_child) { $li_class .= ' top-current'; }
            if(($item->count == 0 or $item->meta->core['hide-childs']) and !$item->meta->core['as-custom']) { $li_class .= ' no-any-submenu'; }           
            if($li_class != '') { $li_class = ' class="'.$li_class.'" '; }
            
            $out .= '<li '.$li_class.'>';                            
                
                $out .= '<a ';
                
                if(!$item->meta->core['as-nl'])
                {
                    if($item->meta->link['url-use'] and $item->meta->link['url'] != '')
                    { $out .= ' href="'.$item->meta->link['url'].'" '; } 
                    else if($item->meta->link['page-use'] and $item->meta->link['page'] != CMS_NOT_SELECTED)
                    { $out .= ' href="'.get_permalink($item->meta->link['page']).'" '; } 
                    else { $out .= ' href="'.$item->url.'" '; } 
                        
                        $out .= ($item->rel != '') ? ' rel="'.$item->rel.'" ' : '';
                        $out .= ($item->title != '') ? ' title="'.$item->title.'" ' : '';
                        $out .= ' target="'.$item->target.'" ';  
                }                                        
                $out .= '><div>';
                $out .= stripcslashes($item->label);
                
                if(!$item->meta->core['hide-sub-indicator'])
                {
                    if(($item->count > 0 and !$item->meta->core['hide-childs']) or $item->meta->core['as-custom'])
                    {
                        $out .= '<div class="sub-arrow"></div>';
                    }
                }
                
                $out .= '</div></a>';  
                
                

                if($item->meta->core['as-custom'])
                {
                    $block_style = ' style="';
                        $block_style .= 'color:'.$item->meta->custom['color'].';';
                        if($item->meta->custom['width-use']) { $block_style .= 'width:'.$item->meta->custom['width'].'px;'; }
                        if($item->meta->custom['height-use']) { $block_style .= 'height:'.$item->meta->custom['height'].'px;'; }
                        if($item->meta->custom['padding-left-use']) { $block_style .= 'padding-left:'.$item->meta->custom['padding-left'].'px;'; }
                        if($item->meta->custom['padding-top-use']) { $block_style .= 'padding-top:'.$item->meta->custom['padding-top'].'px;'; }
                        if($item->meta->custom['padding-right-use']) { $block_style .= 'padding-right:'.$item->meta->custom['padding-right'].'px;'; }
                        if($item->meta->custom['padding-bottom-use']) { $block_style .= 'padding-bottom:'.$item->meta->custom['padding-bottom'].'px;'; }    
                        if($item->meta->custom['f-family-use']) { $block_style .= 'font-family:'.$item->meta->custom['f-family'].';'; }
                        if($item->meta->custom['f-size-use']) { $block_style .= 'font-size:'.$item->meta->custom['f-size'].'px;'; }
                        if($item->meta->custom['f-line-height-use']) { $block_style .= 'line-height:'.$item->meta->custom['f-line-height'].'px;'; }                 
                    $block_style .= '" ';
                    
                    $out .= '<div class="mega-custom-block" '.$block_style.'>';
                        if($item->meta->custom['align-right']) { $out .= '<span class="opt-align-right"></span>'; }
                        $out .= '<div class="mask-line"><div class="black-line"></div></div>';
                        $out .= do_shortcode(stripcslashes($item->content));
                    $out .= '</div>';     
                } else                
                if($item->meta->core['as-mega'])
                {
                    $columns = 0;
                    $ul_rendered = 0;
                    $ul_count = 0;
                    $columns_containers = array();
                     

                    if($item->count > 0 and !$item->meta->core['hide-childs'])
                    {
                        foreach($item->childs as $m_item)
                        {
                            if($m_item->count > 0 and !$m_item->meta->core['hide-childs'])
                            {
                                $ul_count++;
                            }
                        }
                    }                        

                    
                    $add_class = '';                                    
                    if($item->meta->core['mega-fancy']) { $add_class = ' highlighted-top'; }
                    
                    $out .= '<div class="mega-block '.$add_class.'">';
                        if($item->meta->core['mega-align-right'])
                        {
                            $out .= '<span class="opt-align-right"></span>';
                        }
                        $out .= '<div class="mask-line"><div class="black-line"></div></div>';   
                        
                        if($item->count > 0 and !$item->meta->core['hide-childs'])
                        {
                            foreach($item->childs as $m_item)
                            {
                                if($m_item->count > 0 and !$m_item->meta->core['hide-childs'])
                                {            
                                    $ul_style = ''; 
                                    if($m_item->meta->ul['height-use']) { $ul_style .= 'height:'.$m_item->meta->ul['height'].'px;'; }
                                    if($m_item->meta->ul['width-use']) { $ul_style .= 'width:'.$m_item->meta->ul['width'].'px;'; }
                                    if($ul_style != '') { $ul_style = ' style="'.$ul_style.'" '; }                                       
                                                        
                                    $ul_class = '';
                                    $div_class = '';                   
                                    if($item->meta->core['mega-fancy'])
                                    {              
                                        $div_class = ($columns == 0 ? 'first-column' : '');
                                          
                                        if($item->meta->core['mega-align-right']) { $ul_class = ($ul_rendered >= 0 and $ul_rendered < ($ul_count-2)) ? ' inner-column' : ''; }   
                                        else { $ul_class = ($ul_rendered > 0 and $ul_rendered < ($ul_count-1)) ? ' inner-column' : ''; } 
                                    } else
                                    {
                                        $ul_class = ($ul_rendered >= 0 and $ul_rendered < ($ul_count-1)) ? ' inner-column' : '';                                        
                                    }   
                                                                                                         
                                    $out .= '<div class="mega-column '.$div_class.'">';
                                        $out .= '<ul '.$ul_style.' class="'.$ul_class.'">';
                                            $out .= $this->renderSubItems($m_item->childs, array('childs'=>false));                                            
                                        $out .= '</ul>';                                      
                                    $out .= '</div>';    
                                    
                                    $columns++;
                                    $ul_rendered++;
                                }    
                            }    
                        }                                                                        

                        $out .= '<div class="dc-clear"></div>';
                        
                        if($item->meta->ul['image-use'] and trim($item->meta->ul['image']) != '')
                        {   
                            $img_width = $item->meta->ul['image-width']; 
                            $img_height = $item->meta->ul['image-height']; 
                            
                            $img_style = '';
                                if($item->meta->ul['image-margin-top'] > 0) { $img_style .='margin-top:'.$item->meta->ul['image-margin-top'].'px;'; }
                                if($item->meta->ul['image-noborder']) { $img_style .= 'border-top:none;'; } 
                                if($item->meta->ul['image-nopadding']) { $img_style .= 'padding:0px;'; }
                            $img_style = ' style="'.$img_style.'" ';
                            
                            $out .= '<div class="mega-block-image-wrapper" '.$img_style.'>';
                            
                            if($item->meta->ul['image-link-use'])
                            {
                                $out .= '<a href="'.$item->meta->ul['image-link'].'">';
                            }   
                            
                            if($item->meta->ul['image-fit'])
                            {
                                $out .= '<img class="mega-block-image img-fited" src="'.$item->meta->ul['image'].'" />';     
                            } else                                                                                                         
                            {
                                $out .= '<img class="mega-block-image" src="'.dcf_getImageURL($item->meta->ul['image'], $img_width, $img_height, CMS_IMAGE_CROP_FIT).'" />';                            
                            }
                            
                            if($item->meta->ul['image-link-use'])
                            {
                                $out .= '</a>';
                            }
                            
                            $out .= '</div>';
                        }          
                                          
                    $out .= '</div>';    
                } else
                {                                
                    if($item->count > 0 and !$item->meta->core['hide-childs'])
                    {                
                        $ul_style = '';
                        $ul_class = '';
                        $ul_args = array();
                        
                        
                        if($item->meta->ul['height-use']) { $ul_style .= 'height:'.$item->meta->ul['height'].'px;'; }
                        if($item->meta->ul['width-use']) { $ul_style .= 'width:'.$item->meta->ul['width'].'px;'; $ul_args['left'] = $item->meta->ul['width']; }
                        if($ul_style != '') { $ul_style = ' style="'.$ul_style.'" '; }
                        
                        if($item->meta->ul['align-right']) { $ul_class .= ' align-right'; }
                        if($item->meta->ul['image-use'] and $item->meta->ul['image'] != '') { $ul_class .= ' has-image'; }
                        if($ul_class != '') { $ul_class = ' class="'.$ul_class.'" '; } 
                                                                                                                                   
                        $out .= '<ul '.$ul_style.' '.$ul_class.'>';
                            if($item->meta->ul['align-right']) { $out .= '<span class="opt-align-right"></span>'; }
                            $out .= '<div class="mask-line"><div class="black-line"></div></div>';                                         
                            $out .= $this->renderSubItems($item->childs, $ul_args);
                            
                            if($item->meta->ul['image-use'] and $item->meta->ul['image'] != '')
                            {   
                                $img_width = $item->meta->ul['image-width']; 
                                $img_height = $item->meta->ul['image-height'];                      
                                $img_wrapper_style = '';          
                                    if($item->meta->ul['image-margin-top'] > 0) { $img_wrapper_style .= 'margin-top:'.$item->meta->ul['image-margin-top'].'px;'; }
                                    if($item->meta->ul['image-noborder']) { $img_wrapper_style .= 'border-top:none;'; } 
                                    if($item->meta->ul['image-nopadding']) { $img_wrapper_style .= 'padding:0px;'; }
                                $img_wrapper_style = ' style="'.$img_wrapper_style.'" ';
                                
                                $out .= '<div '.$img_wrapper_style.' '.($item->meta->ul['image-abs'] ? ' class="ul-image ul-image-as-abs" ' : ' class="ul-image" ').'>';
                                
                                if($item->meta->ul['image-link-use'])
                                {
                                    $out .= '<a href="'.$item->meta->ul['image-link'].'">';
                                }   
                                          
                                if($item->meta->ul['image-fit'])
                                {
                                    $out .= '<img src="'.$item->meta->ul['image'].'" class="img-fited" />';     
                                } else                                                                                                         
                                {                                             
                                    $out .= '<img src="'.dcf_getImageURL($item->meta->ul['image'], $img_width, $img_height, CMS_IMAGE_CROP_FIT).'" />';                            
                                }
                                if($item->meta->ul['image-link-use'])
                                {
                                    $out .= '</a>';
                                }
                                $out .= '</div>';
                            }
                        $out .= '</ul>';                   
                         
                    }                
                }             
                  
           $out .= '</li>';    
        } 
        
        $out .= '<div class="dc-clear"></div>';
        $out .= '</ul>'; 
        $out .= '</div>';
        $out .= '</div>';        
        return $out; 
    }    

    private function renderSubItems($submenu, $args=array())
    {
        $def = array(                                                           
            'childs' => true,
            'left' => null
        );      
        $args = $this->combineArgs($def, $args);          
        
        $out = '';        
        foreach($submenu as $item)
        {
            if($item->meta->core['hide']) { continue; }   
            
            $submenu_arrow = '';
            if(($item->count > 0 and !$item->meta->core['hide-childs'] and $args['childs']) or $item->meta->core['as-head'])
            {
                $submenu_arrow .= '<div class="sub-submenu-arrow"></div>';
            }
            
            $li_class = '';
            if($item->current or $item->current_child) { $li_class .= ' sub-current'; } 
            if($item->meta->core['as-empty']) { $li_class = ' empty-space'; } 
            else if($item->meta->core['as-text']) { $li_class = ' text-block'; } 
            else  if($item->meta->core['as-head']) { $li_class = ' simple-head'; }
            else  if($item->meta->core['as-head-nl']) { $li_class = ' simple-head-not-linkable'; }
            else  if($item->meta->core['as-head-fancy']) { $li_class = ' fancy-head'; }   
            
            if($li_class != '') { $li_class = ' class="'.$li_class.'" '; }
            
            $style = '';
                if($item->meta->core['as-empty']) { $style .= 'height:'.$item->meta->misc['empty_h'].'px;'; }
                     
            $style = ' style="'.$style.'" ';
            
            $out .= '<li '.$li_class.' '.$style.'>';
                          
                if($item->meta->core['as-text'])
                {
                    $wrapper_style = '';
                    $wrapper_style .= 'color:'.$item->meta->custom['color'].';';
                        if($item->meta->custom['padding-left-use']) { $wrapper_style .= 'padding-left:'.$item->meta->custom['padding-left'].'px;'; }
                        if($item->meta->custom['padding-top-use']) { $wrapper_style .= 'padding-top:'.$item->meta->custom['padding-top'].'px;'; }
                        if($item->meta->custom['padding-right-use']) { $wrapper_style .= 'padding-right:'.$item->meta->custom['padding-right'].'px;'; }
                        if($item->meta->custom['padding-bottom-use']) { $wrapper_style .= 'padding-bottom:'.$item->meta->custom['padding-bottom'].'px;'; }    
                        if($item->meta->custom['f-family-use']) { $wrapper_style .= 'font-family:'.$item->meta->custom['f-family'].';'; }
                        if($item->meta->custom['f-size-use']) { $wrapper_style .= 'font-size:'.$item->meta->custom['f-size'].'px;'; }
                        if($item->meta->custom['f-line-height-use']) { $wrapper_style .= 'line-height:'.$item->meta->custom['f-line-height'].'px;'; }                         
                    $wrapper_style = ' style="'.$wrapper_style.'" ';  
                    
                    $out .= '<div class="tb-inner-wrapper" '.$wrapper_style.'>'.stripcslashes($item->content).'</div>';    
                } else                
                if(!$item->meta->core['as-empty'])
                {
                    $out .= $submenu_arrow;
                    
                    $out .= '<a ';
                    if(!$item->meta->core['as-nl'] and !$item->meta->core['as-head-nl'] and !$item->meta->core['as-head-fancy'])
                    {                        
                        if($item->meta->link['url-use'] and $item->meta->link['url'] != '')
                        { $out .= ' href="'.$item->meta->link['url'].'" '; } 
                        else if($item->meta->link['page-use'] and $item->meta->link['page'] != CMS_NOT_SELECTED)
                        { $out .= ' href="'.get_permalink($item->meta->link['page']).'" '; } 
                        else { $out .= ' href="'.$item->url.'" '; } 
                                           
                        $out .= ($item->rel != '') ? ' rel="'.$item->rel.'" ' : '';
                        $out .= ($item->title != '') ? ' title="'.$item->title.'" ' : '';
                        $out .= ' target="'.$item->target.'" ';                                          
                    }
                    $out .= '>';
                    $out .= stripcslashes($item->label);
                        if($item->meta->subtext['display'])
                        {
                            $style = ' style="';
                            $style .= 'font-style:'.$item->meta->subtext['style'].';';
                            $style .= 'font-weight:'.$item->meta->subtext['weight'].';';
                            $style .= 'color:'.$item->meta->subtext['color'].';';
                            $style .= '" ';
                            $out .= ' <span '.$style.'>'.stripcslashes($item->meta->subtext['text']).'</span>'; 
                        }
                    $out .= '</a>';             
                    
                    if($item->count > 0 and !$item->meta->core['hide-childs'] and $args['childs'])
                    {     
                        $ul_style = '';
                        $ul_args = array();
                        
                        if($args['left'] !== null) { $ul_style .= 'left:'.$args['left'].'px;'; } 
                        if($item->meta->ul['height-use']) { $ul_style .= 'height:'.$item->meta->ul['height'].'px;'; }
                        if($item->meta->ul['width-use']) { $ul_style .= 'width:'.$item->meta->ul['width'].'px;'; $ul_args['left'] = $item->meta->ul['width']; }                                               
                        if($ul_style != '') { $ul_style = ' style="'.$ul_style.'" '; }   
                       
                        $out .= '<ul '.$ul_style.'>';
                        $out .= $this->renderSubItems($item->childs, $ul_args);
                        $out .= '</ul>';
                    }
                }
                
                $out .= '</li>';                                 
        }                    
        return $out;    
    }       
    
    
    public function getSortedMenuItems($id)
    {
        global $wpdb;
        $menu = array();
                          
        $table_name = $this->_db_table_items_name;
        $query = "SELECT * FROM $table_name WHERE menu_id = $id AND status = 'publish' ";
        $this->_items_list = $wpdb->get_results($query);        
        if(!is_array($this->_items_list)) {$this->_items_list = array();}
        else { $menu = $this->getSortableMenu(); }
        
        return $menu;            
    }    
    
    private function getSortableMenu()
    {
        $this->_is_category = false;
        $this->_is_page = false;
        $this->_is_custom = false;                        
        
        if(is_category())
        {
            $this->_is_category = true;            
        } else
        if(is_page())
        {
            $this->_is_page = true;
        } else
        {
            $this->_is_custom = true;
        }        
        
        $top_items = array(); 
                                
        if(is_array($this->_items_list))
        {
            // get all top items
            foreach($this->_items_list as $li)
            {
                if($li->parent == 0)
                {
                    array_push($top_items, $li);
                }    
            }       
            
            if(count($top_items) > 0)
            {                
                // sort top items                             
                $change = true;
                while($change)
                {
                    $change = false;
                    $count = count($top_items);
                    for($i = 0; $i < $count-1; $i++)
                    {
                        if($top_items[$i]->pos > $top_items[$i+1]->pos)
                        {
                            $temp = $top_items[$i];
                            $top_items[$i] = $top_items[$i+1];
                            $top_items[$i+1] = $temp;
                            $change = true;    
                        }                        
                    }                                
                }                        
                
                $count = count($top_items);
                for($i = 0; $i < $count; $i++)
                {            
                    $childs = array();              
                    $top_items[$i]->level = 0;                     
                                        
                    if(is_string($top_items[$i]->meta) and $top_items[$i]->meta != '')
                    {                                                
                        $top_items[$i]->meta = unserialize($top_items[$i]->meta);                      
                    }
                    
                    $top_items[$i]->current = $this->checkSingleActiveMenuItem($top_items[$i]); 
                    
                    $childs = $this->getSortableSubmenu($top_items[$i]->id, 1); 
                    
                    $top_items[$i]->childs = array();
                    foreach($childs as $c)
                    {
                        array_push($top_items[$i]->childs, $c);    
                    }
                    $top_items[$i]->count = count($top_items[$i]->childs);
                                        
                    if(!$top_items[$i]->current and $top_items[$i]->count > 0)
                    {
                        $top_items[$i]->current_child = $this->checkDownActiveMenuItem($top_items[$i]->childs);    
                    }
                }
            }
        }                
        return $top_items;
    }
    
    private function getSortableSubmenu($parent_id, $level)
    {
        $child_items = array();

        // get all top items
        foreach($this->_items_list as $li)
        {
            if($li->parent == $parent_id)
            {
                array_push($child_items, $li);
            }    
        }  
        
        if(count($child_items) > 0)
        {            
            // sort childs                             
            $change = true;
            while($change)
            {
                $change = false;
                $count = count($child_items);
                for($i = 0; $i < $count-1; $i++)
                {
                    if($child_items[$i]->pos > $child_items[$i+1]->pos)
                    {
                        $temp = $child_items[$i];
                        $child_items[$i] = $child_items[$i+1];
                        $child_items[$i+1] = $temp;
                        $change = true;    
                    }                        
                }                                
            } 
            
            $count = count($child_items);
                   
            for($i = 0; $i < $count; $i++)
            {   
                $childs = array();
                $child_items[$i]->level = $level;                             
                
                if(is_string($child_items[$i]->meta) and  $child_items[$i]->meta != '')
                {
                    $child_items[$i]->meta = unserialize($child_items[$i]->meta);
                }                
                $child_items[$i]->current = $this->checkSingleActiveMenuItem($child_items[$i]); 
                
                $childs = $this->getSortableSubmenu($child_items[$i]->id, $level+1);
                
                $child_items[$i]->childs = array(); 
                foreach($childs as $c)
                {    
                    array_push($child_items[$i]->childs, $c);    
                }  
                $child_items[$i]->count = count($child_items[$i]->childs); 
                                
                if(!$child_items[$i]->current and $child_items[$i]->count > 0)
                {
                    $child_items[$i]->current_child = $this->checkDownActiveMenuItem($child_items[$i]->childs);    
                }                               
            }
        }     
        
        return $child_items;                     
    }    
    
    private function checkDownActiveMenuItem($menu)
    {
        $value = false;
        
        foreach($menu as $item)
        {
            if($item->meta->core['hide'])
            {
                continue;
            }
            
            $value = $this->checkSingleActiveMenuItem($item);
            
            if($value)
            {
                break;
            } else
            {
                if($item->count > 0 and !$item->meta->core['hide-childs'])
                {
                    $value = $this->checkDownActiveMenuItem($item->childs);
                    if($value)
                    {
                        break;
                    }
                }
            }                        
        }
        
        return $value;
    }    
    
    private function checkSingleActiveMenuURL($url)
    {
        $value = false;

        if($url != '' and $url != 'http://' and $url != 'http://#')
        {        
            $info_server = parse_url($_SERVER['REQUEST_URI']);
            $info_item = parse_url($url);
            
            if(isset($info_server['path']))
            {
                if($info_server['path'] == $info_item['path'] or (rtrim($info_server['path'], ' /') == rtrim($info_item['path'], ' /')))
                {
                    if(isset($info_server['query']))
                    {
                        if($info_server['query'] == $info_item['query'])
                        {
                            $value = true;    
                        }    
                    } else
                    {
                        $value = true;
                    }
                }
            }
        }
        
        return $value;    
    }
    
    private function checkSingleActiveMenuItem($item)
    {          
        $value = false;  
        
        switch(strtolower($item->type))
        {
            case 'custom':
            {
                if($item->meta->link['url-use'])
                {
                    $url = $item->meta->link['url'];                        
                    $value = $this->checkSingleActiveMenuURL($url);                    
                } else                
                if($this->_is_page and $item->meta->link['page-use'])
                {
                    global $post;
                    if($post->ID == $item->meta->link['page'])
                    {
                        $value = true;
                    }                    
                } else
               /* if($this->_is_custom)
                {
                    $url = $item->url;
                    if($item->meta->link['url-use']) 
                    {
                        $url = $item->meta->link['url'];    
                    }
                    $value = $this->checkSingleActiveMenuURL($url);                    
                } else */
                {
                    $url = $item->url;
                    $value = $this->checkSingleActiveMenuURL($url);      
                }                     
            }
            break;
            
            case 'page':
            {
                if($item->meta->link['url-use'] and $item->meta->link['url'] != '')
                {
                    $url = $item->meta->link['url'];                        
                    $value = $this->checkSingleActiveMenuURL($url);                    
                } else
                if($this->_is_page)
                {
                    global $post;
                    
                    if($item->meta->link['page-use'])
                    {
                        if($post->ID == $item->meta->link['page'])
                        {
                            $value = true;
                        }                         
                    } else
                    if($post->ID == $item->wpid)
                    {
                        $value = true;
                    }
                }    
            }
            break;
            
            case 'category':
            {
                if($item->meta->link['url-use'])
                {
                    $url = $item->meta->link['url'];                        
                    $value = $this->checkSingleActiveMenuURL($url);                    
                } else                
                if($this->_is_page and $item->meta->link['page-use'])
                {
                    global $post;
                    if($post->ID == $item->meta->link['page'])
                    {
                        $value = true;
                    }                    
                } else
                if($this->_is_category)
                {             
                    $categoryid = (get_query_var('cat')) ? get_query_var('cat') : '';
                    if($item->wpid == $categoryid)
                    {
                        $value = true;
                    }
                }     
            } break;
        }        
        
        return $value;   
    }        

        
    
    private function process()
    {
        global $wpdb;  
        $this->_process_info = '';      
        $this->_process_info_error = ''; 
        
        # CREATE NEW MENU
        if(isset($_POST['create-new-menu']))
        {
            $menu_name = $_POST['data-new-menu-name'];
            if($menu_name != '')
            {   
                $result = $wpdb->insert($this->_db_table_menu_name, array('name' => $menu_name));
                
                if($result !== false)
                {
                    $this->_options['active_menu'] = $wpdb->insert_id;  
                    update_option($this->_DBIDOPT_OPTIONS, $this->_options);            
                    $this->_process_info = 'New menu created successfully';                     
                } else
                {
                    $this->_process_info_error = 'There was some problem with access to database';                    
                }                    
            }        
        }     
        
        # SELECT MENU TO EDIT
        if(isset($_POST['select-menu-toedit']))
        {
            $this->_options['active_menu'] = $_POST['data-selected-menu']; 
            update_option($this->_DBIDOPT_OPTIONS, $this->_options);                                                                                    
            $this->_process_info = 'Active menu changed successfully';                
        }   
        
        # DELETE MENU
        if(isset($_POST['delete-edited-menu']))
        {
            $id = $_POST['data-active-menu-id'];  
            
            $result = $wpdb->query("DELETE FROM $this->_db_table_items_name WHERE menu_id = $id");
            $result = $wpdb->query("DELETE FROM $this->_db_table_menu_name WHERE id = $id"); 
            
            if($result !== false)
            {         
                $this->_process_info = 'Menu deleted successfully';                     
            } else
            {
                $this->_process_info_error = 'There was some problem with access to database';                    
            }                   
        }    
        
        # SAVE MENU
        if(isset($_POST['save-menu-changes']))
        {
            $name = $_POST['data-changed-menu-name'];
            $id = $_POST['data-active-menu-id'];    
            
            $result = true;
            if(is_array($_POST))
            {
                $result = $wpdb->query("UPDATE $this->_db_table_items_name SET status = 'draft' WHERE menu_id = $id"); 
                
                if($result !== false)
                {
                    
                    $parents_array = array();
                    
                    foreach($_POST as $key => $value)
                    {
                        if(strstr($key, '-db-id'))
                        {
                            // separete key
                            $key = str_replace('data-item-', '', $key);
                            $key = str_replace('-db-id', '', $key);
                            
                            // find item data by key
                            $pos = 0;
                            $db_id = $_POST['data-item-'.$key.'-db-id']; 
                            
                            $parent = $_POST['data-item-'.$key.'-parent']; 
                            $status = 'publish';
                            $type = $_POST['data-item-'.$key.'-type'];
                            
                            $label = $_POST['data-item-'.$key.'-label'];
                            $rel = $_POST['data-item-'.$key.'-rel'];  
                            $target = isset($_POST['data-item-'.$key.'-target']) ? '_blank' : '_self';
                            $title = $_POST['data-item-'.$key.'-title'];
                            $url = $_POST['data-item-'.$key.'-url'];                                   
                            $content = $_POST['data-item-'.$key.'-content'];                        
                                         
                            // prepeare meta data
                            $meta = $this->createStandardMetaOjectData();
                            
                            // core
                            $meta->core['hide'] = isset($_POST['data-item-'.$key.'-core-hide']) ? true : false;
                            $meta->core['hide-in-responsive'] = isset($_POST['data-item-'.$key.'-core-hide-in-responsive']) ? true : false;     
                            $meta->core['hide-childs'] = isset($_POST['data-item-'.$key.'-core-hide-childs']) ? true : false; 
                            $meta->core['hide-sub-indicator'] = isset($_POST['data-item-'.$key.'-core-hide-sub-indicator']) ? true : false; 
                            $meta->core['as-mega'] = isset($_POST['data-item-'.$key.'-core-as-mega']) ? true : false;
                            $meta->core['as-nl'] = isset($_POST['data-item-'.$key.'-core-as-nl']) ? true : false;
                            $meta->core['as-head'] = isset($_POST['data-item-'.$key.'-core-as-head']) ? true : false;
                            $meta->core['as-head-nl'] = isset($_POST['data-item-'.$key.'-core-as-head-nl']) ? true : false; 
                            $meta->core['as-head-fancy'] = isset($_POST['data-item-'.$key.'-core-as-head-fancy']) ? true : false; 
                            $meta->core['as-text'] = isset($_POST['data-item-'.$key.'-core-as-text']) ? true : false; 
                            $meta->core['as-empty'] = isset($_POST['data-item-'.$key.'-core-as-empty']) ? true : false;
                            $meta->core['as-custom'] = isset($_POST['data-item-'.$key.'-core-as-custom']) ? true : false; 
                                       
                            $meta->core['mega-fancy'] = isset($_POST['data-item-'.$key.'-core-mega-fancy']) ? true : false; 
                            $meta->core['mega-align-right'] = isset($_POST['data-item-'.$key.'-core-mega-align-right']) ? true : false;
                                                       
                            // sub-text 
                            $meta->subtext['display'] = isset($_POST['data-item-'.$key.'-subtext-display']) ? true : false;
                            $meta->subtext['text'] = $_POST['data-item-'.$key.'-subtext-text'];
                            $meta->subtext['color'] = $_POST['data-item-'.$key.'-subtext-color'];
                            $meta->subtext['style'] = $_POST['data-item-'.$key.'-subtext-style'];
                            $meta->subtext['weight'] = $_POST['data-item-'.$key.'-subtext-weight'];   
                                                
                            
                            // submenu
                            $meta->ul['height'] = $_POST['data-item-'.$key.'-ul-height'];
                            $meta->ul['height-use'] = isset($_POST['data-item-'.$key.'-ul-height-use']) ? true : false; 
                            $meta->ul['width'] = $_POST['data-item-'.$key.'-ul-width'];
                            $meta->ul['width-use'] = isset($_POST['data-item-'.$key.'-ul-width-use']) ? true : false; 
                            $meta->ul['align-right'] = isset($_POST['data-item-'.$key.'-ul-align-right']) ? true : false;
                            $meta->ul['image'] = trim($_POST['data-item-'.$key.'-ul-image']);
                            $meta->ul['image-margin-top'] = $_POST['data-item-'.$key.'-ul-image-margin-top'];
                            $meta->ul['image-height'] = $_POST['data-item-'.$key.'-ul-image-height'];  
                            $meta->ul['image-width'] = $_POST['data-item-'.$key.'-ul-image-width']; 
                            $meta->ul['image-use'] = isset($_POST['data-item-'.$key.'-ul-image-use']) ? true : false; 
                            $meta->ul['image-abs'] = isset($_POST['data-item-'.$key.'-ul-image-abs']) ? true : false;  
                            $meta->ul['image-fit'] = isset($_POST['data-item-'.$key.'-ul-image-fit']) ? true : false; 
                            $meta->ul['image-link'] = $_POST['data-item-'.$key.'-ul-image-link'];
                            $meta->ul['image-link-use'] = isset($_POST['data-item-'.$key.'-ul-image-link-use']) ? true : false;                               
                            $meta->ul['image-noborder'] = isset($_POST['data-item-'.$key.'-ul-image-noborder']) ? true : false;  
                            $meta->ul['image-nopadding'] = isset($_POST['data-item-'.$key.'-ul-image-nopadding']) ? true : false; 
                            
                            // custom
                            $meta->custom['width'] = $_POST['data-item-'.$key.'-custom-width'];
                            $meta->custom['width-use'] = isset($_POST['data-item-'.$key.'-custom-width-use']) ? true : false;
                            $meta->custom['height'] = $_POST['data-item-'.$key.'-custom-height'];
                            $meta->custom['height-use'] = isset($_POST['data-item-'.$key.'-custom-height-use']) ? true : false;
                            
                            $meta->custom['color'] = $_POST['data-item-'.$key.'-custom-color'];  
                            
                            $meta->custom['align-right'] = isset($_POST['data-item-'.$key.'-custom-align-right']) ? true : false;
                            
                            $meta->custom['padding-left'] = $_POST['data-item-'.$key.'-custom-padding-left']; 
                            $meta->custom['padding-top'] = $_POST['data-item-'.$key.'-custom-padding-top'];
                            $meta->custom['padding-right'] = $_POST['data-item-'.$key.'-custom-padding-right'];
                            $meta->custom['padding-bottom'] = $_POST['data-item-'.$key.'-custom-padding-bottom'];
                            
                            $meta->custom['padding-left-use'] = isset($_POST['data-item-'.$key.'-custom-padding-left-use']) ? true : false;
                            $meta->custom['padding-top-use'] = isset($_POST['data-item-'.$key.'-custom-padding-top-use']) ? true : false;
                            $meta->custom['padding-right-use'] = isset($_POST['data-item-'.$key.'-custom-padding-right-use']) ? true : false;
                            $meta->custom['padding-bottom-use'] = isset($_POST['data-item-'.$key.'-custom-padding-bottom-use']) ? true : false;
                                                    
                            $meta->custom['f-family'] = $_POST['data-item-'.$key.'-custom-f-family']; 
                            $meta->custom['f-family-use'] = isset($_POST['data-item-'.$key.'-custom-f-family-use']) ? true : false;
                            $meta->custom['f-size'] = $_POST['data-item-'.$key.'-custom-f-size']; 
                            $meta->custom['f-size-use'] = isset($_POST['data-item-'.$key.'-custom-f-size-use']) ? true : false;
                            $meta->custom['f-line-height'] = $_POST['data-item-'.$key.'-custom-f-line-height']; 
                            $meta->custom['f-line-height-use'] = isset($_POST['data-item-'.$key.'-custom-f-line-height-use']) ? true : false;
                               
                            // link   
                            $meta->link['url'] = $_POST['data-item-'.$key.'-link-url'];
                            $meta->link['url-use'] = isset($_POST['data-item-'.$key.'-link-url-use']) ? true : false;
                            $meta->link['page'] = $_POST['data-item-'.$key.'-link-page'];
                            $meta->link['page-use'] = isset($_POST['data-item-'.$key.'-link-page-use']) ? true : false;                                                        
                             
                            // misc 
                            $meta->misc['empty_h'] = $_POST['data-item-'.$key.'-misc-empty_h'];
                            
                            
                            $change_wpid = isset($_POST['data-item-'.$key.'-change_wpid']) ? true : false;  
                            
                            if($change_wpid)
                            {
                                $selected_new_wpid = $_POST['data-item-'.$key.'-selected_new_wpid']; 
                                if($type == 'page')
                                {
                                    $url = get_permalink($selected_new_wpid);
                                }
                                
                                if($type == 'category')
                                {
                                    $url = get_category_link($selected_new_wpid); 
                                }
                            }                            
                               
                            $meta = serialize($meta);
                            
                            // calculate item position (position starts from zero)
                            if(!isset($parents_array[$parent]))
                            {
                                $parents_array[$parent] = 0;
                                $pos = 0;    
                            } else
                            {
                               $parents_array[$parent]++;
                               $pos = $parents_array[$parent]; 
                            }
                            
                            $data_a = array(
                                'parent' => $parent,
                                'pos' => $pos,
                                'status' => $status,
                                'type' => $type,                                                                
                                'meta' => $meta,
                                'label' => $label,  
                                'rel' => $rel,                                                             
                                'target' => $target,
                                'title' => $title,
                                'url' => $url,
                                'content' => $content                             
                            );
                            
                            if($change_wpid)
                            {
                                $selected_new_wpid = $_POST['data-item-'.$key.'-selected_new_wpid']; 
                                $data_a['wpid'] = $selected_new_wpid;
                            }                              
                             
                            // save/update item in database
                            $result = $wpdb->update($this->_db_table_items_name, $data_a, array('id' => $db_id));  
                        }
                    }
                    
                    $result = $wpdb->query("DELETE FROM $this->_db_table_items_name WHERE menu_id = $id AND status = 'draft'");
                }
            }
            
            if($result !== false)
            {
                $result = $wpdb->update($this->_db_table_menu_name, array('name' => $name), array('id' => $id));   
            }
            
            if($result !== false)
            {         
                $this->_process_info = 'Changes in menu saved successfully';                     
            } else
            {
                $this->_process_info_error = 'There was some problem with access to database';                    
            }              
            
        }                                                                
    }    
          
    private function renderSortableMenuCMS()
    {        
        $out = '';
                                
        if(is_array($this->_items_list))
        {
            $top_items = array();

            // get all top items
            foreach($this->_items_list as $li)
            {
                if($li->parent == 0)
                {
                    array_push($top_items, $li);
                }    
            }       
            
            // sort top items                             
            $change = true;
            while($change)
            {
                $change = false;
                $count = count($top_items);
                for($i = 0; $i < $count-1; $i++)
                {
                    if($top_items[$i]->pos > $top_items[$i+1]->pos)
                    {
                        $temp = $top_items[$i];
                        $top_items[$i] = $top_items[$i+1];
                        $top_items[$i+1] = $temp;
                        $change = true;    
                    }                        
                }                                
            }                        
            
            $out .= '<ol class="dc-cms-menu-sys-sortable ui-sortable">';
            foreach($top_items as $li)
            {               
                $out .= $this->renderSortableLiCMS($li);             
               
                $out .= $this->renderSortableSubmenuCMS($li->id, 1); 
                $out .= '</li>';
            }
            $out .= '</ol>'; 
        }
        
        return $out;
    }
    

    
    private function renderSortableSubmenuCMS($parent_id, $level)
    {
        $out = '';
        $child_items = array();

        // get all top items
        foreach($this->_items_list as $li)
        {
            if($li->parent == $parent_id)
            {
                array_push($child_items, $li);
            }    
        }  
        
        // sort childs                             
        $change = true;
        while($change)
        {
            $change = false;
            $count = count($child_items);
            for($i = 0; $i < $count-1; $i++)
            {
                if($child_items[$i]->pos > $child_items[$i+1]->pos)
                {
                    $temp = $child_items[$i];
                    $child_items[$i] = $child_items[$i+1];
                    $child_items[$i+1] = $temp;
                    $change = true;    
                }                        
            }                                
        } 
        
        if(count($child_items) > 0)
        {
            $out .= '<ol>';            
            foreach($child_items as $li)
            {
                $out .= $this->renderSortableLiCMS($li); 

                $out .= $this->renderSortableSubmenuCMS($li->id, $level+1); 
                $out .= '</li>';
            }
            $out .= '</ol>';
        }        
        
        return $out;                     
    }           
          

    private function createStandardMetaOjectData()
    {
        $meta = new DCC_MenuItemStdMetaObjectData();
            
        // core
        $meta->core['hide'] = false;
        $meta->core['hide-in-responsive'] = false;
        $meta->core['hide-childs'] = false;
        $meta->core['hide-sub-indicator'] = false;        
        $meta->core['as-mega'] = false;  
        $meta->core['as-nl'] = false;
        $meta->core['as-head'] = false;
        $meta->core['as-head-nl'] = false;
        $meta->core['as-head-fancy'] = false;
        $meta->core['as-empty'] = false;
        $meta->core['as-custom'] = false; 
        $meta->core['as-text'] = false;  
        $meta->core['mega-fancy'] = false;
        $meta->core['mega-align-right'] = false;         
        
        // subtext
        $meta->subtext['display'] = false;
        $meta->subtext['text'] = '';
        $meta->subtext['color'] = '#5F69E3';
        $meta->subtext['weight'] = 'normal';
        $meta->subtext['style'] = 'normal';
         
        // submenu 
        $meta->ul['image'] = '';
        $meta->ul['image-margin-top'] = 50;
        $meta->ul['image-height'] = 124;
        $meta->ul['image-width'] = 168;
        $meta->ul['image-use'] = false;
        $meta->ul['image-abs'] = false;
        $meta->ul['image-fit'] = false; 
        $meta->ul['image-link'] = ''; 
        $meta->ul['image-link-use'] = false;
        $meta->ul['image-noborder'] = false;
        $meta->ul['image-nopadding'] = false;
        $meta->ul['height'] = 200;
        $meta->ul['height-use'] = false;
        $meta->ul['width'] = 168;
        $meta->ul['width-use'] = false;
        $meta->ul['align-right'] = false;
        
        // custom 
        $meta->custom['width'] = 300;  
        $meta->custom['height'] = 200;
        $meta->custom['width-use'] = false;
        $meta->custom['height-use'] = false;    
        $meta->custom['padding-left'] = 10;              
        $meta->custom['padding-top'] = 10;
        $meta->custom['padding-right'] = 10;
        $meta->custom['padding-bottom'] = 10; 

        $meta->custom['color'] = '#393939'; 
        
        $meta->custom['align-right'] = false; 
        
        $meta->custom['padding-left-use'] = false;              
        $meta->custom['padding-top-use'] = false;
        $meta->custom['padding-right-use'] = false;
        $meta->custom['padding-bottom-use'] = false;
            
        $meta->custom['f-family'] = 'Arial'; 
        $meta->custom['f-family-use'] = false;
        $meta->custom['f-size'] = 11;     
        $meta->custom['f-size-use'] = 11;
        $meta->custom['f-line-height'] = 14;
        $meta->custom['f-line-height-use'] = 14;
            
        // link   
        $meta->link['page'] = CMS_NOT_SELECTED;
        $meta->link['page-use'] = false;
        $meta->link['url'] = '';
        $meta->link['url-use'] = false;

        // misc   
        $meta->misc['empty_h'] = 8;
            
        return $meta;
    } 
    
    private function renderSortableLiCMS($li)
    {      
        if(is_string($li->meta))
        {
            if($li->meta !== '')
            {                    
                $li->meta = unserialize($li->meta);
            } else
            {
                $li->meta = $this->createStandardMetaOjectData();    
            }
        }
        
        $out = '';    
        
        $class = '';
        if($li->meta->core['hide'] or $li->meta->core['hide-childs']) 
        {  
            $class .= ' class="';
            if($li->meta->core['hide']) { $class .= 'hidden-object '; }
            if($li->meta->core['hide-childs']) { $class .= 'hidden-childs'; }
            $class .= '" ';
        }
        
        $out .= '<li '.$class.'><div class="item-content-wrapper">';        
        
        if((string)$li->label === '' or trim($li->label) == '') 
        {
            $out .= '<div class="head"><span class="title">[...]</span>';    
        } else
        {
            $out .= '<div class="head"><span class="title">'.stripcslashes($li->label).'</span>';
        }
            $out .= '<span class="item-type">'.ucwords($li->type).'</span>';
            $out .= '<a class="node-delete-btn" title="Delete node"></a>';
            $out .= '<a class="node-pin-btn" title="Pin"></a>';
            $out .= '<a class="show-opt-btn" title="Show options"></a>';
            $out .= '<div class="tags-box">';
                $out .= '<div class="tag-icon-mega" '.((bool)$li->meta->core['as-mega'] ? ' style="display:block;" ' : '').'></div>';
                $out .= '<div class="tag-icon-empty" '.((bool)$li->meta->core['as-empty'] ? ' style="display:block;" ' : '').'></div>';  
            $out .= '</div>';
        $out .= '</div>'; // head
       
        $out .= '<div class="item-data">';                
            
            $out .= '<span style="display:none;" class="db-id">'.$li->id.'</span>'; 
            $out .= '<input type="hidden" value="'.$li->type.'" name="data-item-'.$li->id.'-type" />';
            $out .= '<input type="hidden" value="'.$li->id.'" name="data-item-'.$li->id.'-db-id" />';
            $out .= '<input type="hidden" value="'.$li->parent.'" name="data-item-'.$li->id.'-parent" />'; 
 
            $out .= '<div class="field-short-left">';
                $out .= '<span class="dc-cms-control-top-label-nomargin">URL</span>'; 
                if($li->type == 'page')
                {
                    $out .= '<input type="text" class="dc-cms-control-100per" value="'.get_permalink($li->wpid).'" name="data-item-'.$li->id.'-url" readonly="readonly" style="background-color:#F0F0F0;" />';
                } else
                if($li->type == 'category')
                {
                    $out .= '<input type="text" class="dc-cms-control-100per" value="'.get_category_link($li->wpid).'" name="data-item-'.$li->id.'-url" readonly="readonly" style="background-color:#F0F0F0;" />';
                } else
                {
                    $out .= '<input type="text" class="dc-cms-control-100per" value="'.$li->url.'" name="data-item-'.$li->id.'-url" />';
                }
            $out .= '</div>';
            
            $out .= '<div class="field-short-right">';                
                $out .= '<span class="dc-cms-control-top-label-nomargin">Navigation Label</span>';
                $out .= '<input type="text" class="dc-cms-control-100per" value="'.stripcslashes($li->label).'" name="data-item-'.$li->id.'-label" />';
            $out .= '</div>';
                 
            $out .= '<div class="field-short-left">';
                $out .= '<span class="dc-cms-control-top-label-s-margin">Title Attribute</span>';
                $out .= '<input type="text" class="dc-cms-control-100per" value="'.stripcslashes($li->title).'" name="data-item-'.$li->id.'-title" />';
            $out .= '</div>';                                   
            
            $out .= '<div class="field-short-right">';
                $out .= '<span class="dc-cms-control-top-label-s-margin">Link Relationship</span>';
                $out .= '<input type="text" class="dc-cms-control-100per" value="'.$li->rel.'" name="data-item-'.$li->id.'-rel" />';
            $out .= '</div>';   
 
            $out .= $this->getClearBoth(); 
           
            if($li->type == 'page' or $li->type == 'category')
            {
                // page and category original name
                $out .= '<div class="original-name-section">Original name: ';
                    if($li->type == 'page')
                    {
                        $pages_list = GetDCCPI()->getICache()->get_pages();
                        if(is_array($pages_list))
                        {
                            foreach($pages_list as $p)
                            {
                                if($li->wpid == $p->ID)
                                {
                                    $out .= '<a href="'.get_permalink($p->ID).'" target="_blank">'.$p->post_title.'</a>';
                                    $out .= ' <span class="object-id">(ID:'.$p->ID.')</span>';
                                }
                            }
                        }    
                    } else
                    if($li->type == 'category')
                    {
                        $categories_list = GetDCCPI()->getICache()->get_terms('category');
                        if(is_array($categories_list))
                        {
                            foreach($categories_list as $c)
                            {
                                if($li->wpid == $c->term_id)
                                {
                                    $out .= '<a href="'.get_category_link($c->term_id).'" target="_blank">'.$c->name.'</a>';
                                    $out .= ' <span class="object-id">(ID:'.$c->term_id.')</span>';
                                }
                            }
                        }                    
                    }
                $out .= '</div>';
                            
                // change current page to selected one
                if($li->type == 'page')
                {
                    $out .= '<div class="change-wpid-section">';
                        $pages_list = GetDCCPI()->getICache()->get_pages(); 
                        if(is_array($pages_list))
                        {
                            if(count($pages_list))
                            {
                                $out .= '<span class="dc-cms-control-top-label-nomargin">Select page for replace</span>';                                 
                                $out .= '<select class="dc-cms-control-wide" name="data-item-'.$li->id.'-selected_new_wpid">';
                                    foreach($pages_list as $p)
                                    {
                                        $out .= '<option value="'.$p->ID.'" '.($p->ID == $li->wpid ? ' selected="selected" ' : '').'>'.$p->post_title.'</option>';
                                    }
                                $out .= '</select>';
                            }                                       
                        }  
                    $out .= '</div>';                  
                }               

                // change current category to selected one
                if($li->type == 'category')
                {
                    $out .= '<div class="change-wpid-section">';
                        $categories_list = GetDCCPI()->getICache()->get_terms('category');  
                        if(is_array($categories_list))
                        {
                            if(count($categories_list))
                            {
                                $out .= '<span class="dc-cms-control-top-label-nomargin">Select category for replace</span>';                                 
                                $out .= '<select class="dc-cms-control-wide" name="data-item-'.$li->id.'-selected_new_wpid">';
                                    foreach($categories_list as $c)
                                    {
                                        $out .= '<option value="'.$c->term_id.'" '.($c->term_id == $li->wpid ? ' selected="selected" ' : '').'>'.$c->name.'</option>';
                                    }
                                $out .= '</select>';
                            }                                       
                        }  
                    $out .= '</div>';                  
                }              
            
            }
                 
            $out .= '<div class="new-window-tab-section">';
                $out .= $this->getStdInputsFieldStart(); 
                    if($li->type == 'page')
                    {
                        $out .= '<input type="checkbox" name="data-item-'.$li->id.'-change_wpid" /> <span class="dc-cms-checkbox-label">Use selected page for replace</span>'; 
                        $out .= $this->getBR();                       
                    }  
                    if($li->type == 'category')
                    {
                        $out .= '<input type="checkbox" name="data-item-'.$li->id.'-change_wpid" /> <span class="dc-cms-checkbox-label">Use selected category for replace</span>'; 
                        $out .= $this->getBR();                       
                    }                                  
                    $out .= '<input type="checkbox" '.$this->attrChecked($li->target == '_blank').' name="data-item-'.$li->id.'-target" /> ';
                    $out .= '<span class="dc-cms-checkbox-label">Open menu item link in a new window/tab</span>';
                $out .= $this->getStdInputsFieldEnd(); 
            $out .= '</div>';                             
         
          
            $out .= '<div class="advanced-opt-btn"><div class="show-hide-open"></div></div>';                       
            $out .= '<div class="advanced-opt">';
              
                $out .= '<div class="tabs-bar">';
                    $out .= '<a class="tab-active">General</a>'; 
                    $out .= '<a class="tab">Sub-Text</a>'; 
                    $out .= '<a class="tab">Sub-Content</a>'; 
                    $out .= '<a class="tab">Sub-Menu</a>';
                    $out .= '<a class="tab">Link</a>';
                    $out .= '<a class="tab">Misc</a>'; 
                $out .= '</div>';                          
            
                // tab general
                $out .= $this->getAdvTabContentStart(); 

                    $out .= '<div class="dc-cms-settings-section-head-nomargin">Display settings</div>'; 
                    
                    $out .= '<div class="dc-cms-inputs-field-nomargin">'; 
                        
                        $out .= '<div class="dc-cms-excludable-checkbox-field-nomargin">';
                            $out .= '<input type="checkbox" class="mega-checkbox" '.$this->attrChecked((bool)$li->meta->core['as-mega']).' name="data-item-'.$li->id.'-core-as-mega" /> ';
                            $out .= '<span class="dc-cms-checkbox-label">Display as mega menu</span>';                        
                            $out .= $this->getBR(); 
                            $out .= '<input type="checkbox" '.$this->attrChecked((bool)$li->meta->core['as-custom']).' name="data-item-'.$li->id.'-core-as-custom" /> ';
                            $out .= '<span class="dc-cms-checkbox-label">Display as mega custom content</span>';                                                                     
                            $out .= $this->getBR();
                            $out .= '<input type="checkbox" '.$this->attrChecked((bool)$li->meta->core['as-head']).' name="data-item-'.$li->id.'-core-as-head" /> ';
                            $out .= '<span class="dc-cms-checkbox-label">Display as simple head</span>';                        
                            $out .= $this->getBR();
                            $out .= '<input type="checkbox" '.$this->attrChecked((bool)$li->meta->core['as-head-nl']).' name="data-item-'.$li->id.'-core-as-head-nl" /> ';
                            $out .= '<span class="dc-cms-checkbox-label">Display as not linkable simple head</span>';                        
                            $out .= $this->getBR();
                            $out .= '<input type="checkbox" '.$this->attrChecked((bool)$li->meta->core['as-head-fancy']).' name="data-item-'.$li->id.'-core-as-head-fancy" /> ';
                            $out .= '<span class="dc-cms-checkbox-label">Display as not linkable fancy head</span>';                        
                            $out .= $this->getBR();
                            $out .= '<input type="checkbox" class="empty-checkbox" '.$this->attrChecked((bool)$li->meta->core['as-text']).' name="data-item-'.$li->id.'-core-as-text" /> ';
                            $out .= '<span class="dc-cms-checkbox-label">Display as text (sub content)</span>';
                            $out .= $this->getBR();
                            $out .= '<input type="checkbox" class="empty-checkbox" '.$this->attrChecked((bool)$li->meta->core['as-empty']).' name="data-item-'.$li->id.'-core-as-empty" /> ';
                            $out .= '<span class="dc-cms-checkbox-label">Display as empty space</span>';
                        $out .= '</div>';
                        
                    $out .= '</div>';

                    $out .= '<div class="dc-cms-settings-section-head">Mega menu settings</div>'; 
                    $out .= '<div class="dc-cms-inputs-field-nomargin">';
                 
                            $out .= '<input type="checkbox" '.$this->attrChecked((bool)$li->meta->core['mega-fancy']).' name="data-item-'.$li->id.'-core-mega-fancy" /> ';
                            $out .= '<span class="dc-cms-checkbox-label">Fancy triger item and first column</span>';                                                                     
                            $out .= $this->getBR();
                            $out .= '<input type="checkbox" '.$this->attrChecked((bool)$li->meta->core['mega-align-right']).' name="data-item-'.$li->id.'-core-mega-align-right" /> ';
                            $out .= '<span class="dc-cms-checkbox-label">Align to right</span>';                                                                     
                            $out .= $this->getBR();                                                
                    
                    $out .= '</div>';  
 
 
                    $out .= '<div class="dc-cms-settings-section-head">Other settings</div>';
                    $out .= '<div class="dc-cms-inputs-field-nomargin">';
                    
                        $out .= '<input type="checkbox" '.$this->attrChecked((bool)$li->meta->core['as-nl']).' name="data-item-'.$li->id.'-core-as-nl" /> ';
                        $out .= '<span class="dc-cms-checkbox-label">Display as not linkable</span>';                        
                    
                    $out .= '</div>';     
 
                    $out .= '<div class="dc-cms-settings-section-head">Hide settings</div>'; 
                                                                                        
                    $out .= '<div class="dc-cms-inputs-field-nomargin">';
                        $out .= '<input type="checkbox" class="hide-checkbox" '.$this->attrChecked((bool)$li->meta->core['hide']).' name="data-item-'.$li->id.'-core-hide" /> ';
                        $out .= '<span class="dc-cms-checkbox-label">Hide item</span>';
                        $out .= $this->getBR();
                        $out .= '<input type="checkbox" '.$this->attrChecked((bool)$li->meta->core['hide-in-responsive']).' name="data-item-'.$li->id.'-core-hide-in-responsive" /> ';
                        $out .= '<span class="dc-cms-checkbox-label">Hide item in responsive menu</span>';
                        $out .= $this->getBR();
                        $out .= '<input type="checkbox" class="hidechilds-checkbox" '.$this->attrChecked((bool)$li->meta->core['hide-childs']).' name="data-item-'.$li->id.'-core-hide-childs" /> ';
                        $out .= '<span class="dc-cms-checkbox-label">Hide childs</span>';
                        $out .= $this->getBR();                        
                        $out .= '<input type="checkbox" '.$this->attrChecked((bool)$li->meta->core['hide-sub-indicator']).' name="data-item-'.$li->id.'-core-hide-sub-indicator" /> ';
                        $out .= '<span class="dc-cms-checkbox-label">Hide submenu indicator</span>';
                    $out .= '</div>';

                    $out .= $this->getClearBoth();
                $out .= $this->getAdvTabContentEnd(); 

                // tab sub-text
                $out .= $this->getAdvTabContentStart();

                    $out .= '<div class="dc-cms-settings-section-head-nomargin">Item Extra Text Settings</div>'; 
                
                    $out .= '<div class="field-wide">';
                        $out .= '<span class="dc-cms-control-top-label-nomargin">Text</span>'; 
                        $out .= '<input type="text" class="dc-cms-control-100per" value="'.$li->meta->subtext['text'].'" name="data-item-'.$li->id.'-subtext-text" /> ';

                        $out .= $this->getStdInputsFieldStart(array('mtop-type' => 'small'));
                            $out .= '<input type="checkbox" '.$this->attrChecked((bool)$li->meta->subtext['display']).' name="data-item-'.$li->id.'-subtext-display" /> ';
                            $out .= '<span class="dc-cms-checkbox-label">Display sub-text</span>';
                        $out .= $this->getStdInputsFieldEnd();
                    $out .= '</div>';                                    
           
       
           
                    $out .= '<div class="field-short-left">';
                        $out .= '<span class="dc-cms-control-top-label">Font style</span>';
                        $out .= '<select class="dc-cms-control-100per" name="data-item-'.$li->id.'-subtext-style" >';
                            $out .= '<option value="normal" '.$this->attrSelected($li->meta->subtext['style'] == 'normal').'>Normal</option>';
                            $out .= '<option value="italic" '.$this->attrSelected($li->meta->subtext['style'] == 'italic').'>Italic</option>';
                        $out .= '</select>';
                    $out .= '</div>';  
                
                    $out .= '<div class="field-short-right">';        
                        $out .= '<span class="dc-cms-control-top-label">Font weight</span>';
                        $out .= '<select class="dc-cms-control-100per" name="data-item-'.$li->id.'-subtext-weight" >';
                            $out .= '<option value="normal" '.$this->attrSelected($li->meta->subtext['weight'] == 'normal').'>Normal</option>';
                            $out .= '<option value="bold" '.$this->attrSelected($li->meta->subtext['weight'] == 'bold').'>Bold</option>';
                        $out .= '</select>';
                    $out .= '</div>';                           
             
                     $out .= '<div class="field-short-left">';
                        $out .= '<span class="dc-cms-control-top-label-s-margin">Text color</span>';
                        $out .= '<input type="text" class="dc-color-picker" value="'.$li->meta->subtext['color'].'" name="data-item-'.$li->id.'-subtext-color" />';
                    $out .= '</div>';  
 
                    $out .= $this->getClearBoth();                                
                $out .= $this->getAdvTabContentEnd();   
                
                // tab sub-content
                $out .= $this->getAdvTabContentStart(); 
                
                    $out .= '<div class="dc-cms-settings-section-head-nomargin">Item sub content block settings</div>';                

                    $out .= '<span class="dc-cms-control-top-label-nomargin">Content</span>';
                    $out .= '<textarea class="custom-content" name="data-item-'.$li->id.'-content" >'.stripcslashes($li->content).'</textarea>'; 
                
                    $out .= '<div class="field-short-left">';
                        $out .= '<span class="dc-cms-control-top-label-s-margin">Block width</span>';
                        $out .= $this->getCtrlInputInt('data-item-'.$li->id.'-custom-width', $li->meta->custom['width'], 0, 1000);
                    $out .= '</div>';
                    
                    $out .= '<div class="field-short-right">';    
                        $out .= '<span class="dc-cms-control-top-label-s-margin">Block height</span>';
                        $out .= $this->getCtrlInputInt('data-item-'.$li->id.'-custom-height', $li->meta->custom['height'], 0, 1000);
                    $out .= '</div>';                

                    $out .= '<div class="field-short-left">';
                        $out .= '<span class="dc-cms-control-top-label-s-margin">Padding left</span>';
                        $out .= $this->getCtrlInputInt('data-item-'.$li->id.'-custom-padding-left', $li->meta->custom['padding-left'], 0, 1000);
                    $out .= '</div>';
                    
                    $out .= '<div class="field-short-right">';    
                        $out .= '<span class="dc-cms-control-top-label-s-margin">Padding top</span>';
                        $out .= $this->getCtrlInputInt('data-item-'.$li->id.'-custom-padding-top', $li->meta->custom['padding-top'], 0, 1000);
                    $out .= '</div>';  
                
                    $out .= '<div class="field-short-left">';
                        $out .= '<span class="dc-cms-control-top-label-s-margin">Padding right</span>';
                        $out .= $this->getCtrlInputInt('data-item-'.$li->id.'-custom-padding-right', $li->meta->custom['padding-right'], 0, 1000);
                    $out .= '</div>';
                    
                    $out .= '<div class="field-short-right">';    
                        $out .= '<span class="dc-cms-control-top-label-s-margin">Padding bottom</span>';
                        $out .= $this->getCtrlInputInt('data-item-'.$li->id.'-custom-padding-bottom', $li->meta->custom['padding-bottom'], 0, 1000);
                    $out .= '</div>';  
                    
                    $out .= '<div class="field-short-left">';    
                        $out .= '<span class="dc-cms-control-top-label-s-margin">Select font size</span>';
                        $out .= '<select name="data-item-'.$li->id.'-custom-f-size" class="dc-cms-control-100per">';
                            $out .= '<option value="9" '.$this->attrSelected($li->meta->custom['f-size'] == 9).'>9px</option>';
                            $out .= '<option value="10" '.$this->attrSelected($li->meta->custom['f-size'] == 10).'>10px</option>';
                            $out .= '<option value="11" '.$this->attrSelected($li->meta->custom['f-size'] == 11).'>11px</option>'; 
                            $out .= '<option value="12" '.$this->attrSelected($li->meta->custom['f-size'] == 12).'>12px</option>'; 
                            $out .= '<option value="13" '.$this->attrSelected($li->meta->custom['f-size'] == 13).'>13px</option>'; 
                            $out .= '<option value="14" '.$this->attrSelected($li->meta->custom['f-size'] == 14).'>14px</option>';
                            $out .= '<option value="15" '.$this->attrSelected($li->meta->custom['f-size'] == 15).'>15px</option>'; 
                            $out .= '<option value="16" '.$this->attrSelected($li->meta->custom['f-size'] == 16).'>16px</option>';
                            $out .= '<option value="17" '.$this->attrSelected($li->meta->custom['f-size'] == 17).'>17px</option>';
                            $out .= '<option value="18" '.$this->attrSelected($li->meta->custom['f-size'] == 18).'>18px</option>';
                            $out .= '<option value="19" '.$this->attrSelected($li->meta->custom['f-size'] == 19).'>19px</option>';
                            $out .= '<option value="20" '.$this->attrSelected($li->meta->custom['f-size'] == 20).'>20px</option>';  
                        $out .= '</select> ';
                    $out .= '</div>';                      

                    $out .= '<div class="field-short-right">';    
                        $out .= '<span class="dc-cms-control-top-label-s-margin">Select font line height</span>';
                        $out .= '<select name="data-item-'.$li->id.'-custom-f-line-height" class="dc-cms-control-100per">';
                            $out .= '<option value="9" '.$this->attrSelected($li->meta->custom['f-line-height'] == 9).'>9px</option>';
                            $out .= '<option value="10" '.$this->attrSelected($li->meta->custom['f-line-height'] == 10).'>10px</option>';
                            $out .= '<option value="11" '.$this->attrSelected($li->meta->custom['f-line-height'] == 11).'>11px</option>'; 
                            $out .= '<option value="12" '.$this->attrSelected($li->meta->custom['f-line-height'] == 12).'>12px</option>'; 
                            $out .= '<option value="13" '.$this->attrSelected($li->meta->custom['f-line-height'] == 13).'>13px</option>'; 
                            $out .= '<option value="14" '.$this->attrSelected($li->meta->custom['f-line-height'] == 14).'>14px</option>'; 
                            $out .= '<option value="15" '.$this->attrSelected($li->meta->custom['f-line-height'] == 15).'>15px</option>'; 
                            $out .= '<option value="16" '.$this->attrSelected($li->meta->custom['f-line-height'] == 16).'>16px</option>'; 
                            $out .= '<option value="17" '.$this->attrSelected($li->meta->custom['f-line-height'] == 17).'>17px</option>'; 
                            $out .= '<option value="18" '.$this->attrSelected($li->meta->custom['f-line-height'] == 18).'>18px</option>';
                            $out .= '<option value="19" '.$this->attrSelected($li->meta->custom['f-line-height'] == 19).'>19px</option>'; 
                            $out .= '<option value="20" '.$this->attrSelected($li->meta->custom['f-line-height'] == 20).'>20px</option>'; 
                            $out .= '<option value="21" '.$this->attrSelected($li->meta->custom['f-line-height'] == 21).'>21px</option>'; 
                            $out .= '<option value="22" '.$this->attrSelected($li->meta->custom['f-line-height'] == 22).'>22px</option>';
                            $out .= '<option value="23" '.$this->attrSelected($li->meta->custom['f-line-height'] == 23).'>23px</option>'; 
                            $out .= '<option value="24" '.$this->attrSelected($li->meta->custom['f-line-height'] == 24).'>24px</option>';  
                        $out .= '</select> ';
                    $out .= '</div>';                                       
                    
                    $out .= '<div class="field-short-left">';    
                        $out .= '<span class="dc-cms-control-top-label-s-margin">Select font family</span>';
                        $out .= '<select name="data-item-'.$li->id.'-custom-f-family" class="dc-cms-control-100per">';
                            $out .= '<option value="Arial" '.$this->attrSelected($li->meta->custom['f-family'] == 'Arial').'>Arial</option>';
                            $out .= '<option value="Georgia" '.$this->attrSelected($li->meta->custom['f-family'] == 'Georgia').'>Georgia</option>';
                            $out .= '<option value="Lucida Sans" '.$this->attrSelected($li->meta->custom['f-family'] == 'Lucida Sans').'>Lucida Sans</option>'; 
                            $out .= '<option value="Tahoma" '.$this->attrSelected($li->meta->custom['f-family'] == 'Tahoma').'>Tahoma</option>';
                            $out .= '<option value="Times New Roman" '.$this->attrSelected($li->meta->custom['f-family'] == 'Times New Roman').'>Times New Roman</option>';
                            $out .= '<option value="Trebuchet MS" '.$this->attrSelected($li->meta->custom['f-family'] == 'Trebuchet MS').'>Trebuchet MS</option>';
                            $out .= '<option value="Verdana" '.$this->attrSelected($li->meta->custom['f-family'] == 'Verdana').'>Verdana</option>'; 
                        $out .= '</select>';  
                    $out .= '</div>';  
                    
                     $out .= '<div class="field-short-right">';
                        $out .= '<span class="dc-cms-control-top-label-s-margin">Text color</span>';
                        $out .= '<input type="text" class="dc-color-picker" value="'.$li->meta->custom['color'].'" name="data-item-'.$li->id.'-custom-color" />';
                    $out .= '</div>';                                                                                                   
                
                    $out .= $this->getClearBoth();
                
                    $out .= '<span class="dc-cms-control-top-label-s-margin">Settings</span>'; 
                    
                    $out .= '<div class="field-short-left">'; 
                        $out .= '<div class="dc-cms-inputs-field-nomargin">'; 
                            $out .= '<input type="checkbox" '.$this->attrChecked((bool)$li->meta->custom['width-use']).' name="data-item-'.$li->id.'-custom-width-use" /> ';
                            $out .= '<span class="dc-cms-checkbox-label">Use width</span>';
                            $out .= $this->getBR();
                            $out .= '<input type="checkbox" '.$this->attrChecked((bool)$li->meta->custom['height-use']).' name="data-item-'.$li->id.'-custom-height-use" /> ';
                            $out .= '<span class="dc-cms-checkbox-label">Use height</span>';
                            $out .= $this->getBR();
                            $out .= '<input type="checkbox" '.$this->attrChecked((bool)$li->meta->custom['f-family-use']).' name="data-item-'.$li->id.'-custom-f-family-use" /> ';
                            $out .= '<span class="dc-cms-checkbox-label">Use font family</span>';
                            $out .= $this->getBR();                              
                            $out .= '<input type="checkbox" '.$this->attrChecked((bool)$li->meta->custom['f-size-use']).' name="data-item-'.$li->id.'-custom-f-size-use" /> ';
                            $out .= '<span class="dc-cms-checkbox-label">Use font size</span>';
                            $out .= $this->getBR();                                                           
                            $out .= '<input type="checkbox" '.$this->attrChecked((bool)$li->meta->custom['f-line-height-use']).' name="data-item-'.$li->id.'-custom-f-line-height-use" /> ';
                            $out .= '<span class="dc-cms-checkbox-label">Use font line height</span>';
                            $out .= $this->getBR();  
                        $out .= '</div>';               
                    $out .= '</div>';
                    
                    $out .= '<div class="field-short-right">'; 
                        $out .= '<div class="dc-cms-inputs-field-nomargin">'; 
                            $out .= '<input type="checkbox" '.$this->attrChecked((bool)$li->meta->custom['padding-left-use']).' name="data-item-'.$li->id.'-custom-padding-left-use" /> ';
                            $out .= '<span class="dc-cms-checkbox-label">Use padding left</span>';
                            $out .= $this->getBR();
                            $out .= '<input type="checkbox" '.$this->attrChecked((bool)$li->meta->custom['padding-top-use']).' name="data-item-'.$li->id.'-custom-padding-top-use" /> ';
                            $out .= '<span class="dc-cms-checkbox-label">Use padding top</span>';
                            $out .= $this->getBR();    
                            $out .= '<input type="checkbox" '.$this->attrChecked((bool)$li->meta->custom['padding-right-use']).' name="data-item-'.$li->id.'-custom-padding-right-use" /> ';
                            $out .= '<span class="dc-cms-checkbox-label">Use padding right</span>';
                            $out .= $this->getBR();
                            $out .= '<input type="checkbox" '.$this->attrChecked((bool)$li->meta->custom['padding-bottom-use']).' name="data-item-'.$li->id.'-custom-padding-bottom-use" /> ';
                            $out .= '<span class="dc-cms-checkbox-label">Use padding bottom</span>';
                            $out .= $this->getBR();  
                            $out .= '<input type="checkbox" '.$this->attrChecked((bool)$li->meta->custom['align-right']).' name="data-item-'.$li->id.'-custom-align-right" /> ';
                            $out .= '<span class="dc-cms-checkbox-label">Align to right</span>';                                                                               
                        $out .= '</div>';               
                    $out .= '</div>';                    
                
                    $out .= $this->getClearBoth();                                
                $out .= $this->getAdvTabContentEnd();  
                
                // tab sub-menu
                $out .= $this->getAdvTabContentStart();                
                    $out .= '<div class="dc-cms-settings-section-head-nomargin">Attached submenu settings</div>';      
                         
                    $out .= '<div class="field-short-left">';
                        $out .= '<span class="dc-cms-control-top-label-nomargin">Submenu width</span>';
                        $out .= $this->getCtrlInputInt('data-item-'.$li->id.'-ul-width', $li->meta->ul['width'], 0, 1000);
                    $out .= '</div>';
                    
                    $out .= '<div class="field-short-right">';    
                        $out .= '<span class="dc-cms-control-top-label-nomargin">Submenu height</span>';
                        $out .= $this->getCtrlInputInt('data-item-'.$li->id.'-ul-height', $li->meta->ul['height'], 0, 1000);
                    $out .= '</div>';

                    $out .= '<div class="field-short-left">';
                        $out .= '<span class="dc-cms-control-top-label-s-margin">Image width</span>';
                        $out .= $this->getCtrlInputInt('data-item-'.$li->id.'-ul-image-width', $li->meta->ul['image-width'], 0, 1000);
                    $out .= '</div>';                    
                    
                    $out .= '<div class="field-short-right">';
                        $out .= '<span class="dc-cms-control-top-label-s-margin">Image height</span>';
                        $out .= $this->getCtrlInputInt('data-item-'.$li->id.'-ul-image-height', $li->meta->ul['image-height'], 0, 1000);
                    $out .= '</div>';
                    
                    $out .= '<div class="field-short-left">';    
                        $out .= '<span class="dc-cms-control-top-label-s-margin">Image top margin</span>';
                        $out .= $this->getCtrlInputInt('data-item-'.$li->id.'-ul-image-margin-top', $li->meta->ul['image-margin-top'], 0, 1000);
                    $out .= '</div>';
                    
                    $out .= $this->getClearBoth(); 
                        
   
                        $out .= '<span class="dc-cms-control-top-label-s-margin">Image link</span>';
                        $out .= '<input type="text" class="dc-cms-control-100per" value="'.$li->meta->ul['image-link'].'" name="data-item-'.$li->id.'-ul-image-link" /> ';  

                         
                        $out .= '<span class="dc-cms-control-top-label-s-margin">Settings</span>';
                        $out .= '<div class="dc-cms-inputs-field-nomargin">';
                            $out .= ' <input type="checkbox" '.$this->attrChecked((bool)$li->meta->ul['width-use']).' name="data-item-'.$li->id.'-ul-width-use" /> Use submenu width';
                            $out .= $this->getBR();
                            $out .= ' <input type="checkbox" '.$this->attrChecked((bool)$li->meta->ul['height-use']).' name="data-item-'.$li->id.'-ul-height-use" /> Use submenu height';                                                        
                            $out .= $this->getBR();
                            $out .= ' <input type="checkbox" '.$this->attrChecked((bool)$li->meta->ul['image-link-use']).' name="data-item-'.$li->id.'-ul-image-link-use" /> Use link';
                            $out .= $this->getBR();
                            $out .= ' <input type="checkbox" '.$this->attrChecked((bool)$li->meta->ul['image-use']).' name="data-item-'.$li->id.'-ul-image-use" /> Display image';
                            $out .= $this->getBR();
                            $out .= ' <input type="checkbox" '.$this->attrChecked((bool)$li->meta->ul['image-noborder']).' name="data-item-'.$li->id.'-ul-image-noborder" /> Hide image top border'.$this->getBookHelp(array('text' => 'Removing the border may be useful for displaying PNG images with irregular edges.'));
                            $out .= $this->getBR();
                            $out .= ' <input type="checkbox" '.$this->attrChecked((bool)$li->meta->ul['image-nopadding']).' name="data-item-'.$li->id.'-ul-image-nopadding" /> Remove image padding';
                            $out .= $this->getBR();
                            $out .= ' <input type="checkbox" '.$this->attrChecked((bool)$li->meta->ul['image-abs']).' name="data-item-'.$li->id.'-ul-image-abs" /> Align image to the bottom of submenu'.$this->getBookHelp(array('text' => 'Use with submenu height option. If item is displayd as mega menu, this option is ignored.'));
                            $out .= $this->getBR();
                            $out .= ' <input type="checkbox" '.$this->attrChecked((bool)$li->meta->ul['image-fit']).' name="data-item-'.$li->id.'-ul-image-fit" /> Fit image size to wrapper'.$this->getBookHelp(array('text' => 'If checked, image width and height will be ignored.'));
                            $out .= $this->getBR();
                            $out .= ' <input type="checkbox" '.$this->attrChecked((bool)$li->meta->ul['align-right']).' name="data-item-'.$li->id.'-ul-align-right" /> Align menu to right';                                                    
                        $out .= '</div>';                                                            

                        $out .= '<span class="dc-cms-control-top-label-s-margin">Submenu image</span>';
                        $out .= '<input type="text" class="dc-cms-control-100per" value="'.$li->meta->ul['image'].'" name="data-item-'.$li->id.'-ul-image" id="dc_id-data-item-'.$li->id.'-ul-image" /> ';  
                        $out .= $this->getImagePreviewBox(array('path' => $li->meta->ul['image'], 'width' => 366, 'height' => 124, 'margin' => '15px 0px 0px 0px'));
                    
                        $out .= '<div class="dc-cms-btn-frame">';
                            $out .= '<input class="dc-cms-submit-image-btn" type="submit" name="dc_id-data-item-'.$li->id.'-ul-image" value="'.__('Load image', CMS_TXT_DOMAIN).'"> ';  
                        $out .= '</div>';                     

                         
                    $out .= $this->getClearBoth();                                
                $out .= $this->getAdvTabContentEnd();                            

                // tab link
                $out .= $this->getAdvTabContentStart();                  
                    $out .= '<div class="dc-cms-settings-section-head-nomargin">Alternative link</div>'; 
                    
                    $out .= '<span class="dc-cms-control-top-label-nomargin">URL</span>';
                    $out .= '<input type="text" class="dc-cms-control-100per" value="'.$li->meta->link['url'].'" name="data-item-'.$li->id.'-link-url" />'; 
                
                    $out .= '<span class="dc-cms-control-top-label-s-margin">Select page</span>';
                    $out .= $this->selectCtrlPagesList(array('value' => $li->meta->link['page'], 'width' => '', 'name' => 'data-item-'.$li->id.'-link-page', 'class' => 'dc-cms-control-wide'));
                
                $out .= '<span class="dc-cms-control-top-label">Settings</span>'; 
                    $out .= '<div class="dc-cms-excludable-checkbox-field-nomargin">'; 
                        $out .= '<div class="field-short-left">'; 
                            $out .= '<input type="checkbox" '.$this->attrChecked((bool)$li->meta->link['url-use']).' name="data-item-'.$li->id.'-link-url-use" /> ';
                            $out .= '<span class="dc-cms-checkbox-label">Use custom URL</span>';            
                        $out .= '</div>';
                        
                        $out .= '<div class="field-short-right">'; 
                            $out .= '<input type="checkbox" '.$this->attrChecked((bool)$li->meta->link['page-use']).' name="data-item-'.$li->id.'-link-page-use" /> ';
                            $out .= '<span class="dc-cms-checkbox-label">Use selected page</span>';                                                               
                        $out .= '</div>';
                    $out .= '</div>';                   
                
                    $out .= $this->getClearBoth();                                
                $out .= $this->getAdvTabContentEnd();    

                // tab misc
                $out .= $this->getAdvTabContentStart();                  
                    $out .= '<div class="dc-cms-settings-section-head-nomargin">Miscellaneous</div>'; 
            
                        $out .= '<span class="dc-cms-control-top-label-nomargin">Height of item displayed as empty space</span>';
                        $out .= $this->getCtrlInputInt('data-item-'.$li->id.'-misc-empty_h', $li->meta->misc['empty_h'], 0, 1000);                 
                
                    $out .= $this->getClearBoth();                                
                $out .= $this->getAdvTabContentEnd();   
                         
                $out .= $this->getClearBoth();                
            $out .= '</div>'; // advanced-opt
              
            $out .= '<div class="save-all-menu-items-panel">';
                $out .= '<input type="submit" class="dc-cms-submit-btn-primary" name="save-menu-changes" value="Save all changes" />';
            $out .= '</div>';                 
              
        $out .= '</div>'; // item-data      
        
        $out .= '</div>';                   

        return $out;    
    }       
      
    private function getAdvTabContentStart($echo=false)
    {
        $out = '';
        $out .= '<div class="tab-content">';
        
        if($echo) { echo $out; } else { return $out; }    
    }    

    private function getAdvTabContentEnd($echo=false)
    {
        $out = '';
        $out .= '</div>';
        
        if($echo) { echo $out; } else { return $out; }    
    }    
          
    private function renderCMS($global_menu)
    {   
        $out = '';     
        
        # MENU MANAGER
        $out .= $this->renderMenuManagerCMS($global_menu);
        
        # EXPORT
        $out .= $this->renderExportCMS($global_menu);
                    
        echo $out;                                            
    }
  
  
    public function renderMenuManagerCMS($global_menu, $echo=false)
    {
        $out = '';          
        
        if($this->isMasterPage('dc-menu-opt'))
        {                
            global $wpdb;
            
            $query = "SELECT * FROM $this->_db_table_menu_name ORDER BY name ASC";
            $this->_menus_list = $wpdb->get_results($query);        
            if(!is_array($this->_menus_list)) {$this->_menus_list = array();}        
            
            $active_menu = $this->getActiveMenuCMS();
          
            $out .= $this->getColumnsWraperBegin();      
               
                $out .= '<div id="dc-cms-menu-sys-content-wrappper">'; 
                
                    if($active_menu !== false) 
                    {
                        ////////////////////
                        // LEFT COLUMN
                        ////////////////////                
                        $out .= '<div class="menu-sys-left-data-column">';
                            
                                $out .= $this->getPanelBegin('Custom link');                  
                                    $out .= '<div class="custom-link-panel">';
                                        $out .= '<span class="dc-cms-control-top-label-nomargin">URL</span>';
                                        $out .= '<input type="text" class="dc-cms-control-100per custom-link-url" name="data-custom-link-url" value="http://" />';

                                        $out .= '<span class="dc-cms-control-top-label">Label</span>';
                                        $out .= '<input type="text" class="dc-cms-control-100per custom-link-name" title="Menu item" name="data-custom-link-name" value="Menu item" />';
                                                  
                                        $out .= '<div class="dc-cms-btn-frame">';
                                            $out .= '<input type="hidden" name="menu-id" value="'.$active_menu->id.'" />';
                                            $out .= '<input type="button" class="dc-cms-submit-btn" name="add-custom-link" value="Add to Menu" />';                              
                                        $out .= '</div>';                                         
                                                                        
                                    $out .= '</div>';                        
                                $out .= $this->getPanelEnd();    
                            
                            $pages_list = GetDCCPI()->getICache()->get_pages(); 
                            if(is_array($pages_list))
                            {
                                if(count($pages_list))
                                {
                                    $out .= $this->getPanelBegin('Page link');                    
                                        $out .= '<div class="page-link-panel">'; 

                                            $out .= '<span class="dc-cms-control-top-label-nomargin">Page title</span>'; 
                                            $out .= '<select class="dc-cms-control-100per page-link-id" name="data-page-link-id">';
                                                $counter = 0;
                                                foreach($pages_list as $p)
                                                {
                                                    $out .= '<option value="'.$p->ID.'" '.($counter == 0 ? ' selected="selected" ' : '').'>'.$p->post_title.'</option>';
                                                    $counter++;
                                                }
                                            $out .= '</select>';
                                                                                                                                        
                                            $out .= '<div class="dc-cms-btn-frame">';
                                                $out .= '<input type="hidden" name="menu-id" value="'.$active_menu->id.'" />';
                                                $out .= '<input type="button" class="dc-cms-submit-btn" name="add-page-link" value="Add to Menu" />';
                                            $out .= '</div>';                                       
                                            
                                        $out .= '</div>';
                                    $out .= $this->getPanelEnd();
                                }                                       
                            }
                            
                            $categories_list = GetDCCPI()->getICache()->get_terms('category');
                            if(is_array($categories_list))
                            {
                                if(count($categories_list))
                                {
                                    $out .= $this->getPanelBegin('Category link');                    
                                        $out .= '<div class="category-link-panel">'; 

                                            $out .= '<span class="dc-cms-control-top-label-nomargin">Category name</span>'; 
                                            $out .= '<select class="dc-cms-control-100per category-link-id" name="data-category-link-id">';
                                                $counter = 0;                                                
                                                foreach($categories_list as $c)
                                                {
                                                    $out .= '<option value="'.$c->term_id.'" '.($counter == 0 ? ' selected="selected" ' : '').'>'.$c->name.'</option>';
                                                    $counter++;
                                                }
                                            $out .= '</select>';
                                                                                                                                        
                                            $out .= '<div class="dc-cms-btn-frame">';
                                                $out .= '<input type="hidden" name="menu-id" value="'.$active_menu->id.'" />';
                                                $out .= '<input type="button" class="dc-cms-submit-btn" name="add-category-link" value="Add to Menu" />';
                                            $out .= '</div>';                                       
                                            
                                        $out .= '</div>';
                                    $out .= $this->getPanelEnd();                                
                                }
                            }                        
            
                        $out .= '</div>'; // left data column
                    }            
                  
                    if($active_menu !== false)
                    {            
                        ////////////////////
                        // CENTER COLUMN
                        ////////////////////                

                        $out .= '<div class="menu-sys-center-data-column">';                 
                            
                            $title = 'Selected menu';
                            $title .= ': '.$active_menu->name;
                            
                            $out .= $this->getPanelBegin($title); 

                                $out .= '<form action="#" method="post">';                    

                                    // edit selected menu box
                                    $out .= '<div class="center-column-submit-panel">';                    
                                        $out .= '<span class="menu-id">ID:'.$active_menu->id.'</span>';                                                           
                                    
                                        
                                        $out .= '<span class="dc-cms-control-top-label-nomargin">Name:</span>'; 
                                        $out .= '<input type="text" style="width:250px;" class="menu-name" value="'.$active_menu->name.'" name="data-changed-menu-name" />';
                                        $out .= '<input type="hidden" name="data-active-menu-id" value="'.$active_menu->id.'" />';                   
                                        
                                        $out .= '<div class="buttons-panel">';             
                                            $out .= '<input type="submit" class="dc-cms-submit-delete-btn" name="delete-edited-menu" value="Delete" />'; 
                                            $out .= '<input type="submit" class="dc-cms-submit-btn-primary" name="save-menu-changes" value="Save" />';
                                        $out .= '</div>';
                                    $out .= '</div>';                                                                         
                       
                                    $query = "SELECT * FROM $this->_db_table_items_name WHERE menu_id = $active_menu->id AND status = 'publish' ";
                                    $this->_items_list = $wpdb->get_results($query);        
                                    if(!is_array($this->_items_list)) {$this->_items_list = array();}
                                    else { $out .= $this->renderSortableMenuCMS(); }                                   
          
                                $out .= '</form>';
                            $out .= $this->getPanelEnd();    
                            
                        $out .= '</div>'; // center data column                                        
                    }
                
                    ////////////////////
                    // RIGHT COLUMN
                    ////////////////////
                    $out .= '<div class="menu-sys-right-data-column">';
                        $out .= $this->getPanelProcessInfo(); 
                                         
                        $out .= $this->getPanelBegin('Tools');
                                
                                $out .= '<form action="#" method="post">';                            
                            
                                // create new menu
                                $out .= '<div class="create-new-menu-panel">';
                                    $out .= '<div class="section-head-light">'.__('Create new menu', CMS_TXT_DOMAIN).'</div>';
                                    $out .= '<input type="text" class="dc-cms-control-100per menu-name" title="'.__('Enter new menu name here', CMS_TXT_DOMAIN).'" value="'.__('Enter new menu name here', CMS_TXT_DOMAIN).'" name="data-new-menu-name" />';

                                    $out .= '<div class="dc-cms-btn-frame">';
                                        $out .= '<input class="dc-cms-submit-btn" type="submit" name="create-new-menu" value="Create"> ';                                 
                                    $out .= '</div>';                                    
                                $out .= '</div>'; 

                                // select existing menu to edit
                                $count = count($this->_menus_list);
                                
                                $out .= '<div class="select-menu-toedit-panel">';
                                    $out .= '<div class="section-head-light">'.__('Select menu to edit', CMS_TXT_DOMAIN).'</div>';
                                    $out .= '<select class="dc-cms-control-100per" name="data-selected-menu">';
                                        if($count == 0)
                                        {
                                            $out .= '<option value="'.CMS_NOT_SELECTED.'">'.__('No menus available', CMS_TXT_DOMAIN).'</option>';    
                                        } else
                                        {
                                            foreach($this->_menus_list as $m)
                                            {
                                                $selected = '';
                                                if($this->_options['active_menu'] == $m->id) { $selected = ' selected="selected" '; }
                                                $out .= '<option value="'.$m->id.'" '.$selected.'>'.$m->name.'</option>';        
                                            }
                                        }
                                    $out .= '</select>';

                                    $out .= '<div class="dc-cms-btn-frame">';
                                        $out .= '<input class="dc-cms-submit-btn" type="submit" name="select-menu-toedit" value="'.__('Edit selected menu', CMS_TXT_DOMAIN).'"> ';                                 
                                    $out .= '</div>';                                  
                                $out .= '</div>';                                                          
                                
                                // legend
                                $out .= '<div class="legend-panel">';
                                    $out .= '<div class="section-head-light">'.__('Menu legend', CMS_TXT_DOMAIN).'</div>';
                                    $out .= '<div class="item"><img class="icon" src="'.get_bloginfo('template_url').'/cms/img/menusystem/mega.png" /><div class="desc">- Displayed as mega menu</div><div class="dc-cms-clear"></div></div>'; 
                                    $out .= '<div class="item"><img class="icon" src="'.get_bloginfo('template_url').'/cms/img/menusystem/empty-item.png" /><div class="desc">- Empty item</div><div class="dc-cms-clear"></div></div>';   
                                $out .= '</div>';
                                
                                $out .= '</form>';           
                        
                        $out .= $this->getPanelEnd();  
                    $out .= '</div>'; // right data column              
                
                    $out .= $this->renderNav($global_menu); 
                
                    $out .= '<div class="dc-cms-clear"></div>';
                $out .= '</div>'; // dc-cms-menu-sys-content-wrappper       
               
            $out .= $this->getColumnsWraperEnd();                    
        }     
        
        if($echo) { echo $out; } else { return $out; }        
    }

    public function renderExportCMS($global_menu, $echo=false)
    {
        $out = '';
       
        if($this->isSubPage('dc-menu-subpage-export-opt'))
        {
            
            $out .= $this->getTopLink();                 
            
            $out .= $this->getColumnsWraperBegin();        
            $out .= $this->getLeftColumnBegin();            
            
                $out .= $this->getPanelBegin('Export / import menu settings');
             
                    $out .= '<form action="#" method="post">';                                                            
                            
                        $out .= '<div class="dc-cms-submit-panel-top-empty">';                         
                            $out .= $this->getPanelProcessInfo();                            
                        $out .= '</div>';               

                            // import
                            $out .= $this->getPanelSectionHead('Import settings');   
            
                                $out .= '<table class="dc-cms-table-standard">';                     
                                    $out .= '<tbody>';                                       

                                    $out .= '<tr><td><span class="dc-cms-left-marked-title">Import</span></td><td>';                            
                                    
                                        $out .= '<span class="dc-cms-control-top-label-nomargin">Uploaded ZIP archive URL</span>'; 
                                        $out .= '<input type="text" class="dc-cms-control-600" name="import_menu_settings_file" value="" id="dc_id_menu_import_menu_file" /> ';
                                        $out .= '<div class="dc-cms-btn-frame">';
                                            $out .= '<input class="dc-cms-submit-image-btn" type="submit" name="dc_id_menu_import_menu_file" value="Load ZIP archive file with menu settings" /> ';
                                            $out .= '<input class="dc-cms-submit-btn" onclick="return confirm(\'Are you sure? This operation will add new menu.\')" name="dc-menu-import-menu-settings" type="submit" value="Import menu" /> ';    
                                        $out .= '</div>';                              
                                   
                                        $log  = '';
                                        
                                        if(isset($_POST['dc-menu-import-menu-settings']))
                                        {
                                            if(trim($_POST['import_menu_settings_file']) == '')
                                            {
                                                $log .= 'Sorry, but the ZIP archive file URL was empty.';
                                            } else
                                            {
                                                $zip_file_path = dcf_getRelativePath($_POST['import_menu_settings_file']);
                                                $extract_path = CMS_TEMPLATEPATH.'/cms/temp/extract';                                          
                                                
                                                $result = $this->importDataFromZip(array('zip_file_path' => $zip_file_path, 'extract_path' => $extract_path));
                                                
                                                $log = $result['log']; 
                                                if($result['status'])
                                                {
                                                    $log .= '<br />';
                                                    $log .= 'Menu imported successfully.';
                                                } else
                                                {
                                                    $log .= '<br />';
                                                    $log .= 'Sorry, but an error occurred while importing menu to database.';                                                                                    
                                                }                                                   
                                            }   
                                        }       
                                        
                                        if(trim($log) != '')
                                        {
                                            $out .= '<div class="dc-cms-help-note-box">';
                                                $out .= $log;                                 
                                            $out .= '</div>';
                                        }                                        
                                        
                                    $out .= '</td></tr>';                             
                        
                                    $out .= '</tbody>';
                                $out .= '</table>';                                               
            
                            // export
                            $out .= $this->getPanelSectionHead('Export settings', 50);   
                                                                   
                            $out .= '<table class="dc-cms-table-standard">';
                                $out .= '<tbody>';                                                          
                                                    
                                $out .= '<tr><td><span class="dc-cms-left-marked-title">Select menu to export</span></td><td>'; 
                                    $list = $this->getMenuList();
                                    $out .= '<select class="dc-cms-control-300" name="dc_export_cms_menu_id">';
                                        $out .= '<option value="'.CMS_NOT_SELECTED.'">Not selected</option>';  
                                        foreach($list as $m)
                                        {
                                            $selected = '';
                                            if(isset($_POST['dc_export_cms_menu_id'])) { $selected = $this->attrSelected($m->id == $_POST['dc_export_cms_menu_id']); }
                                            $out .= '<option value="'.$m->id.'" '.$selected.'>'.$m->name.'</option>';    
                                        }
                                    $out .= '</select>';
                                   
                                    $out .= '<div class="dc-cms-btn-frame">';                                    
                                        $out .= '<input class="dc-cms-submit-btn" name="dc-menu-export-selected-menu-btn" type="submit" value="Export selected menu to ZIP file" /> ';    
                                    $out .= '</div>';  
                                    
                                    if(isset($_POST['dc-menu-export-selected-menu-btn']) and isset($_POST['dc_export_cms_menu_id']))                                   
                                    {
                                        if($_POST['dc_export_cms_menu_id'] != CMS_NOT_SELECTED)
                                        {
                                            $id = $_POST['dc_export_cms_menu_id'];
                                            $on_list = false;
                                            $menu_name = '';
                                            
                                            $list = $this->getMenuList(); 
                                            foreach($list as $m)
                                            {
                                                if($m->id == $id) 
                                                { 
                                                    $on_list = true; 
                                                    $menu_name = $m->name;
                                                    break; 
                                                }    
                                            }
                                            if(trim($menu_name) == '') { $menu_name = 'noname'; } 
                                            
                                            if($on_list)
                                            {
                                                
                                                
                                                global $wpdb;
                                                $result = false;
                                                                  
                                                $table_name = $this->_db_table_items_name;
                                                $query = "SELECT * FROM $table_name WHERE menu_id = $id AND status = 'publish' ";
                                                $menu_items = $wpdb->get_results($query);        
                                                if(!is_array($menu_items)) {$menu_items = array();}                                            
                                                                                          
                                                $export = array(
                                                    'version' => '1.0',
                                                    'name' => 'DCC_ControlPanelMenu',
                                                    'menu_name' => $menu_name,
                                                    'data' => $menu_items
                                                );
                                                
                                                $export = serialize($export);  
                                                
                                                $year = date('Y');
                                                $month = date('F');
                                                $day = date('d');
                                                
                                                $menu_name = strtolower($menu_name);
                                                $menu_name = trim($menu_name);
                                                $menu_name = str_replace(' ', '_', $menu_name);
                                                if(strlen($menu_name) > 0) { $menu_name .= '_'; }
                                                
                                                $filename = CMS_THEME_NAME_SLUG.'_menu_'.$menu_name.'id_'.$id.'_'.$day.'-'.$month.'-'.$year.'.zip';                                                
                                                $export_path = CMS_TEMPLATEPATH.'/cms/export'; 
                                                
                                                $is_dir = is_dir($export_path);  
                                                if($is_dir and $filename != '')
                                                {
                                                                
                                                    if(class_exists('ZipArchive'))
                                                    {
                                                        $zip = new ZipArchive;
                                                        $res = $zip->open($export_path.'/'.$filename, ZipArchive::CREATE | ZipArchive::OVERWRITE);
                                                        if($res == true)
                                                        {            
                                                            $zip->addFromString('menu.txt', $export);                                                                                                                        
                                                            $zip->close();
                                                            
                                                            $result = true;
                                                        }
                                                    }                        
                                                                            
                                                }                                                
                                                  
                                               $out .= '<div class="dc-cms-help-note-box">';      
                                                   if($result === true)
                                                   {         
                                                        $out .= 'Click <a href="'.get_bloginfo('template_url').'/cms/export/'.$filename.'" >here</a> to save ZIP archive file with your exported menu settings.';
                                                   } else
                                                   {
                                                        $out .= 'Sorry, but there was some problem with exporting <span class="dc-cms-marked-span">menu setting</span> to ZIP file.';
                                                   }                                          
                                               $out .= '</div>';           
                                            }
                                              
                                        }
                                    }
                                    
                                $out .= '</td></tr>';   
                                    
                            $out .= '</tbody>';
                        $out .= '</table>';                                     
                
                        $out .= '<div class="dc-cms-submit-panel-bottom-empty">';
                        $out .= '</div>';                        
                                                       
                    $out .= '</form>';
             
                $out .= $this->getPanelEnd();                    
               
            $out .= $this->getLeftColumnsEnd();
            $out .= $this->renderNav($global_menu);                        
                       
            $out .= $this->getColumnsWraperEnd();    

        }        
    
        if($echo) { echo $out; } else { return $out; }        
    }     
    
    private function importSingleMenuItem($new_menu_id, $new_id, $old_id, $items)
    {
        global $wpdb;
        $result = true;
        
        if(is_array($items)) 
        {
            foreach($items as $obj)
            {
                if($obj->parent == $old_id)
                {
                    $result = $wpdb->insert($this->_db_table_items_name, 
                        array(
                            'menu_id' => $new_menu_id, 
                            'status' => $obj->status,  
                            'type' => $obj->type, 
                            'pos' => $obj->pos, 
                            'parent' => $new_id, 
                            'wpid' => $obj->wpid,
                            'label' => $obj->label, 
                            'url' => $obj->url,
                            'target' => $obj->target, 
                            'rel' => $obj->rel,
                            'title' => $obj->title,
                            'meta' => $obj->meta,
                            'content' => $obj->content      
                            )
                        ); 
                       
                   if($result !== false)
                   {
                       $new_item_id = $wpdb->insert_id;
                       $old_item_id = $obj->id;
                       $result = $this->importSingleMenuItem($new_menu_id, $new_item_id, $old_item_id, $items);
                   }                                           
                    
                }    
            }
        }
        
        return $result;   
    }
    
    private function setImportedData($import)    
    {
        global $wpdb;
        $result = array('status' => false, 'message' => '');  
        
        if($import['version'] == '1.0' and $import['name'] == 'DCC_ControlPanelMenu')
        {
            $obj_menu_opt = null;
            $menu_name = $import['menu_name'];
            $new_menu_id = null;
            
            if(is_array($import['data']) and (count($import['data']) > 0))
            {
                $result['message'] .= 'Creating new menu.. ';
                
                $r = $wpdb->insert($this->_db_table_menu_name, array('name' => $menu_name));
                
                if($r !== false)
                {
                    $result['message'] .= 'OK<br />';
                    $new_menu_id = $wpdb->insert_id;           
                    
                    $result['message'] .= 'Adding menu items.. ';                  
                    
                    $r = false;
                    foreach($import['data'] as $item_obj) 
                    {                        
                        if($item_obj->parent == 0)
                        {                        
                            $r = $wpdb->insert($this->_db_table_items_name, 
                                array(
                                    'menu_id' => $new_menu_id, 
                                    'status' => $item_obj->status,  
                                    'type' => $item_obj->type, 
                                    'pos' => $item_obj->pos, 
                                    'parent' => $item_obj->parent, 
                                    'wpid' => $item_obj->wpid,
                                    'label' => $item_obj->label, 
                                    'url' => $item_obj->url,
                                    'target' => $item_obj->target, 
                                    'rel' => $item_obj->rel,
                                    'title' => $item_obj->title,
                                    'meta' => $item_obj->meta,
                                    'content' => $item_obj->content      
                                    )
                                ); 
                           
                           if($r !== false)
                           {
                               $new_item_id = $wpdb->insert_id;
                               $old_item_id = $item_obj->id;
                               $r = $this->importSingleMenuItem($new_menu_id, $new_item_id, $old_item_id, $import['data']);
                           }        
                        } 
                            
                       if($r === false)
                       {
                            $result['message'] .= 'Error<br />';
                            break;    
                       } 
                    }
                    
                    if($r !== false)
                    {
                        $result['message'] .= 'OK<br />';     
                        $result['status'] = true;
                    }                                   
                                             
                } else
                {
                    $result['message'] .= 'Error<br />';                    
                }                    
                    
            } else { $result['message'] .= 'Imported menu is empty.. Operation aborted<br />'; }  
        } else
        {
            $result['message'] .= 'Menu version problem.. Error<br />';    
        }
        
        return $result;
    } 
    
    private function importDataFromZip($args=array())
    {
        $result = array('status' => false, 'log' => '');
        $log = '';
        
        $def = array(
            'zip_file_path' => '',
            'extract_path' => '',       
        );
        $args = $this->combineArgs($def, $args);
    
        $log .= 'Checking file.. ';    
        $is_file = is_file($args['zip_file_path']);
        if($is_file) { $log .= 'OK<br />'; } else { $log .= 'Error<br />'; }
        
        $log .= 'Checking extract dir.. ';
        $is_dir = is_dir($args['extract_path']);
        if($is_dir) { $log .= 'OK<br />'; } else { $log .= 'Error<br />'; }
        
        if($is_file and $is_dir)
        {
            $log .= 'Opening ZIP archive.. ';
            if(class_exists('ZipArchive'))
            {
                $zip = new ZipArchive;
                if($zip->open($args['zip_file_path']) === true) 
                {
                    $log .= 'OK<br />'; 
        
                    $log .= 'Extracting archive.. ';
                    if($zip->extractTo($args['extract_path'], array('menu.txt')) === true)
                    {
                        $log .= 'OK<br />';
                       
                        $handle = false;
                        $file_content = '';
                        $file_path = '';
                        $file_size = 0;
                        $file_name = '';
                        
                        $menu_status = false;
                        
                        // general cms
                        $file_name = 'menu.txt';
                        $file_path = $args['extract_path'].'/'.$file_name;                        
                        
                       // $log .= 'Start to reading general settings.. OK<br />';                        
                        $log .= 'Looking for '.$file_name.' file.. ';                  
                        
                        if(is_file($file_path))
                        {
                            $file_size = filesize($file_path);                        
                            $handle = fopen($file_path, 'r');
                            
                            if($handle)
                            {
                                $log .= 'OK<br />';
                                $log .= 'Unpacked file size '.$file_size.' bytes.. OK<br />';                             
                                
                                $file_content = fread($handle, $file_size);
                                $file_content = unserialize($file_content);
                                 
                                $r = $this->setImportedData($file_content);

                                if($r['status'])
                                {
                                    $log .= $r['message'];
                                    $menu_status = true;    
                                } else
                                {
                                    $log .= $r['message'];   
                                }
                                
                                fclose($handle);
                            } else { $log .= 'Error<br />'; }
                        } else 
                        { 
                            $log .= 'Error<br />';                            
                        }
                                          
                         
                        if($menu_status)
                        {
                            $result['status'] = true; 
                        }    
                            
                    } else
                    {
                        $log .= 'Error<br />';   
                    }
                    
                  
                    $zip->close();
                    
                } else { $log .= 'Error<br />'; }
            } else { $log .= 'Error<br />'; }            
        }
        
        $result['log'] = $log;
        return $result;
    }
   
    
} 


        
        
?>