<?php
/**********************************************************************
* OSAKA UNLIMITED WORDPRESS THEME 
* (Ideal For Business And Personal Use: Portfolio or Blog)     
* 
* File name:   
*      cp_general.php
* Brief:       
*      Part of theme control panel.
* Author:      
*      DigitalCavalry
* Author URI:
*      http://themeforest.net/user/DigitalCavalry
* Contact:
*      digitalcavalry@gmail.com 
***********************************************************************/

/*********************************************************** 
* Class name:
*    DCC_ControlPanelGeneral
* Descripton:
*    Implementation of DCC_ControlPanelGeneral 
***********************************************************/
class DCC_ControlPanelGeneral extends DCC_ControlPanelBase
{
    /*********************************************************** 
    * Constructor
    ************************************************************/
    public function __construct() 
    {              
        $this->_DBIDOPT_GENERAL = CMS_THEME_NAME_UPPERCASE.'_GENERAL_OPT';
        $this->_DBIDOPT_SIDLIST = CMS_THEME_NAME_UPPERCASE.'_SIDLIST_OPT';
        
        $this->_general = get_option($this->_DBIDOPT_GENERAL);

        if(!is_array($this->_general))
        {
            $this->setDefaults(); 
            add_option($this->_DBIDOPT_GENERAL, $this->_generalDef);
            $this->_general = get_option($this->_DBIDOPT_GENERAL);
        } 
        $this->_general = wp_parse_args($this->_general, $this->_generalDef);

        $this->_sidlist = get_option($this->_DBIDOPT_SIDLIST); 
        if(!is_array($this->_sidlist)) 
        { 
            add_option($this->_DBIDOPT_SIDLIST, array());
            $this->_sidlist = array();           
        }
        
            
    } // constructor 
    
    const FOOTER_LAYOUT_2_COLS = '2-cols';
    const FOOTER_LAYOUT_2_COLS_LEFT_SMALL = '2-cols-left-small';
    const FOOTER_LAYOUT_2_COLS_RIGHT_SMALL = '2-cols-right-small';
    const FOOTER_LAYOUT_3_COLS = '3-cols'; 
    const FOOTER_LAYOUT_3_COLS_LEFT_BIG = '3-cols-left-big';
    const FOOTER_LAYOUT_3_COLS_RIGHT_BIG = '3-cols-right-big';
    const FOOTER_LAYOUT_4_COLS = '4-cols';
        
    /*********************************************************** 
    * Public members
    ************************************************************/      
    
    /*********************************************************** 
    * Private members
    ************************************************************/           
     private $_DBIDOPT_GENERAL = null; // data base id options
     private $_DBIDOPT_SIDLIST = null; // data base id options 
     
     private $_sidlist = array(); 
     private $_general = array();
     private $_generalDef = array(     
        
        // core
        'theme_autoformating' => true,
        'theme_autotexturize' => false,
        'theme_authorize_comment' => false,
        'theme_authorize_contact' => false,    
        'theme_primary_menu' => CMS_NOT_SELECTED,
        'theme_css_mode' => 'responsive', // responsive, responsive_hires, std_fixed, std_hires_fixed                        
        'theme_primary_menu_wp' => false,  
        
        // thumbnails              
        'theme_use_post_wp_thumbnail' => false,
        'theme_use_page_wp_thumbnail' => false,
        
        // general look
        'theme_top_empty_space' => 0,
        'theme_bottom_empty_space' => 0,
        
        'theme_h_color' => '#444444',
        'theme_hsub_color' => '#AAAAAA',        
        'theme_a_color' => '#3399CC', 
        'theme_ahover_color' => '##D54E21', 
        
        'theme_h_color_use' => false,
        'theme_hsub_color_use' => false,        
        'theme_a_color_use' => false,
        'theme_ahover_color_use' => false, 
        
        // background
        'bg_image' => '', 
        'bg_attachment' => 'scroll',
        'bg_repeat' => 'no-repeat',
        'bg_color' => '#E2E2E2',
        'bg_pos_x' => 'center',
        'bg_pos_y' => 'top', 
        'bg_pos_x_px' => 0,
        'bg_pos_y_px' => 0,
        'bg_pos_x_px_use' => false,
        'bg_pos_y_px_use' => false,
        'bg_display' => false,
        'bg_force' => false,
        'bg_color_use' => false,           
        
        // emoticons
        'emoticons_use' => true,
        'emoticons_files' => array(),
        'emoticons_ext_prior' => 'gif', // extension priority, gif or png
        'emoticons_top' => 0,
        
        // twitter
        'twitter_consumer_key' => '',
        'twitter_consumer_secret' => '',
        'twitter_token_key' => '',
        'twitter_token_secret' => '',   
        
        // seo
        'seo_use' => false,
        'seo_overwrite_page' => false,
        'seo_overwrite_post' => false,
        
        'seo_title' => '',
        'seo_title_use' => false,
        'seo_add_blog_name' => false,
            
        'seo_keywords' => '',
        'seo_keywords_use' => false,            

        'seo_desc' => '',
        'seo_desc_use' => false,
            
        'seo_noindex' => false,
        'seo_nofollow' => false,
        'seo_nosnippet' => false,
        'seo_noodp' => false,
        'seo_noarchive' => false,
        'seo_noimageindex'  => false,               
                
        'seo_private_meta' => array(),           
        
        // header
        'header_infobox_display' => true,
        'header_infobox_list' => array(),               
        
        // footer
        'footer_display' => false,
        'footer_before_display' => false,
        'footer_after_display' => false,

        'footer_before_autoformat' => true,
        'footer_after_autoformat' => true,        
        
        'footer_layout' => self::FOOTER_LAYOUT_4_COLS,
        'footer_before' => '',
        'footer_after' => '',
        'footer_sid_1' => CMS_NOT_SELECTED,
        'footer_sid_2' => CMS_NOT_SELECTED,
        'footer_sid_3' => CMS_NOT_SELECTED,
        'footer_sid_4' => CMS_NOT_SELECTED,
        
        'footer_logo' => '',
        'footer_logo_display' => false,
        'footer_logo_grayscale' => false,    
        'footer_copyright' => '',
        'footer_copyright_display' => false,
        'footer_copyright_align' => 'center', 
        'footer_copyright_pl' => 0,
        'footer_copyright_pr' => 0,  
        'footer_logo_pt' => 0,
        'footer_logo_pb' => 15,
        'footer_logo_opacity' => 100, 
        'footer_logo_align' => 'center',          
        
        // layout
        'layout_category_page' => CMS_PAGE_LAYOUT_LEFT_SIDEBAR,
        'layout_archive_page' => CMS_PAGE_LAYOUT_LEFT_SIDEBAR,
        'layout_search_page' => CMS_PAGE_LAYOUT_LEFT_SIDEBAR,
        'layout_404_page' => CMS_PAGE_LAYOUT_LEFT_SIDEBAR,
        
        // archive
        'archive_category_per_page' => 10,
        'archive_per_page' => 10,
        
        // custom css
        'css_code' => '',
        'css_code_use' => false,
        
        // breadcrumb
        'breadcrumb_display' => true,
        'breadcrumb_before' => 'You are here:',
        'breadcrumb_before_display' => true,
        'breadcrumb_blog_name' => '',
        'breadcrumb_blog_name_display' => true,
        'breadcrumb_blog_name_force' => false,
        
        // comments
        'comments_in_posts_display' => true,
        'comments_in_pages_display' => true,
        'comments_reverse_children' => false,
        'comments_time_format' => 'F j, Y g:i a',
        'comments_time_display' => true,
        'comments_author_display' => true,
        'comments_author_url_display' => true,
        'comments_mark_author' => true, 
        'comments_url_field' => true, 
        'comments_time_ago_display' => true, 
        'comments_avatar_display' => true,
        'comments_def_avatar' => '',          
             
        // sidebar
        'sid_last_as_first' => false,
        'sid_default_left' => CMS_NOT_SELECTED,
        'sid_default_right' => CMS_NOT_SELECTED,
        'sid_default_post_left' => CMS_NOT_SELECTED,
        'sid_default_post_right' => CMS_NOT_SELECTED,
        'sid_default_cats_left' => CMS_NOT_SELECTED,
        'sid_default_cats_right' => CMS_NOT_SELECTED,
        'sid_default_archive_left' => CMS_NOT_SELECTED,  # sidebar shared between date, tag and author page 
        'sid_default_archive_right' => CMS_NOT_SELECTED,
        'sid_404_left' => CMS_NOT_SELECTED,
        'sid_404_right' => CMS_NOT_SELECTED,
        'sid_search_left' => CMS_NOT_SELECTED,
        'sid_search_right' => CMS_NOT_SELECTED,
        
        'sid_individual_cats' => array(),                     

        // project
        'project_infobar_date_format' => 'F j, Y',
        'project_infobar_date_display' => true,
        'project_infobar_author_display' => true,
        'project_infobar_comments_display' => true,
        'project_infobar_categories_display' => true,
        'project_infobar_client_display' => true,
        'project_infobar_website_display' => true,                      
        'project_infobar_skills_display' => true,
        
        'project_single_posted_date' => true,
        
        'project_layout_category_page' => CMS_PAGE_LAYOUT_LEFT_SIDEBAR,
        'project_sid_default_cats_left' => CMS_NOT_SELECTED,
        'project_sid_default_cats_right' => CMS_NOT_SELECTED,
        'project_category_per_page' => 8,
        'project_category_columns' => 1, # 1, 2, 3, 4
        'project_category_order' => 'DESC', # DESC, ASC
        'project_category_orderby' => 'date', # title, date, comment_count
        'project_category_words' => 24,
        'project_category_excerpt' => true,
        'project_category_viewport_use' => false,
        'project_category_viewport_w' => 300,
        'project_category_viewport_h' => 400,        
                                     
        // blog
        'blog_infobar_date_format' => 'F j, Y',
        'blog_infobar_date_display' => true,
        'blog_infobar_author_display' => true,
        'blog_infobar_comments_display' => true,
        'blog_infobar_categories_display' => true,
        'blog_infobar_tags_display' => true,           
        
        'blog_full_ib_date_format' => 'F j, Y', 
        'blog_full_ib_date_display' => true,
        'blog_full_ib_author_display' => true,
        'blog_full_ib_comments_display' => true,
        'blog_full_ib_categories_display' => true,
        'blog_full_ib_tags_display' => true,        
        
        'blog_full_about_user_display' => true,
        'blog_full_about_extra_users_display' => true,
        
        'blog_date_under_title_display' => true,
        'blog_full_date_under_title_display' => true,        
        
        'blog_related_display' => true,
        'blog_related_count' => 8,
        'blog_related_taxonomy' => 'post_tag',  // post_tag, category
        
        // logo
        'logo_display' => true, 
        'logo_width' => 100,
        'logo_height' => 100,
        'logo_height_use' => false,          
        'logo_url' => '',            
        'logo_img' => '',
        'logo_grayscale' => false,   
        'logo_linkable' => true,            # allow logo linking
        'logo_link_to_theme' => true,          
        'logo_target_blank' => false,
        'logo_link_to_url' => false,       
        'logo_link_to_page' => false,       
        'logo_page' => CMS_NOT_SELECTED, 
        'logo_debug_frame' => false, 
        'logo_center' => false,    
        
        // icons box
        'icons_display' => true, 
        'icons_tooltip_display' => true, 
        'icons_icon_width' => 32,
        'icons_icon_height' => 32,
        'icons_icon_mergin_left' => 6,
        'icons_list' => array(),
        'icons_debug_frame' => false,
        
        // announcement bar
        'abar_display' => false,
        'abar_display_in_lowres' => false,
        'abar_display_shadow' => false, 
        'abar_h' => 80,
        
        'abar_cbtn_display' => false,
        'abar_cbtn_size' => 17,
        'abar_cbtn_image' => false,
        'abar_cbtn_bg_color' => '#EEEEEE', 
        'abar_cbtn_bg_hcolor' => '#EEEEEE',
        
        'abar_font' => 'Arial',
        'abar_font_use' => false,
        'abar_fstyle' => 'normal',
        'abar_fstyle_use' => false,
        'abar_align' => 'left',
        'abar_color' => '#000000',
        'abar_color_use' => false,
        'abar_a_color' => '#000000',
        'abar_a_color_use' => false,
        'abar_a_hcolor' => '#000000',
        'abar_a_hcolor_use' => false,
        'abar_fsize' => 12,
        'abar_fsize_use' => false, 
        'abar_lheight' => 15,
        'abar_lheight_use' => false,
        
        'abar_pt' => 10,
        'abar_pr' => 10,
        'abar_pb' => 10,
        'abar_pl' => 10,

        'abar_pt_use' => false,
        'abar_pr_use' => false,
        'abar_pb_use' => false,
        'abar_pl_use' => false,     
        
        'abar_content' => '',
        'abar_content_use' => false,
        
        'abar_link' => '',
        'abar_link_use' => false,
        'abar_link_new_tab' => false,        
                                
        'abar_bg_color' => '#FFFFFF',
        'abar_bg_color_use' => false,                
        'abar_bg_image' => '', 
        'abar_bg_image_display' => false,                
        'abar_bg_repeat' => 'no-repeat',
        'abar_bg_pos_x' => 'center',
        'abar_bg_pos_y' => 'top', 
        'abar_bg_pos_x_px' => 0,
        'abar_bg_pos_y_px' => 0,
        'abar_bg_pos_x_px_use' => false,
        'abar_bg_pos_y_px_use' => false,  
        
        'abar_border_display' => true,
        'abar_border_width' => 1,
        'abar_border_color' => '#666666',
        'abar_border_style' => 'solid',           
        
        // contact forms
        'cf_list' => array(),
        'cf_edited' => CMS_NOT_SELECTED,
        'cf_message_ok' => 'Success, email was sent.',
        'cf_message_error' => 'Error, email not sent.',       
                      
        // favicon        
        'favicon_display' => false,
        'favicon_url' => '',
        
        'icon_iphone_display' => false,
        'icon_iphone_url' => '',
        'icon_iphone_ret_display' => false,
        'icon_iphone_ret_url' => '',
        'icon_iphone_ret_size' => 120,
        'icon_ipad_display' => false,
        'icon_ipad_url' => '',
        'icon_ipad_size' => 76,
        'icon_ipad_ret_display' => false,
        'icon_ipad_ret_url' => '',
        'icon_ipad_ret_size' => 152,        
        
        // search
        'search_content' => 'Sorry, but nothing matched your search criteria. Please try again with some different keywords.',    
        'search_in_posts' => true,
        'search_in_pages' => true,
        'search_in_member' => true, 
        'search_in_service' => true, 
        'search_in_project' => true,
        'search_form_display' => true,
        'search_header_panel_display' => false,  
        'search_per_page' => 8,
        'search_dummy_text' => 'Type text to search',
        
        // 404 page
        '404_content' => 'The page you are looking for doesn\'t exist.',                      
        
        // tracking code
        'tracking_header_use' => false,
        'tracking_footer_use' => false,
        'tracking_header_code' => '',
        'tracking_footer_code' => '' 
          
     );    
   
     protected $_submenu = array (
        'Theme core' => 'dc-general-opt',        
        'Sidebars' => 'dc-subpage-sidebar-opt',
        'Footer' => 'dc-subpage-footer-opt',
        'Main logo' => 'dc-subpage-main-logo-opt', 
        'Header icons box' => 'dc-subpage-icons-box-opt', 
        'Contact form creator' => 'dc-subpage-contact-form-opt',
        'SEO' => 'dc-subpage-seo-opt', 
        'Twitter' => 'dc-subpage-twitter-opt', 
        'Announcement bar' => 'dc-subpage-announcement-bar-opt',
        'Miscellaneous' => 'dc-subpage-misc-opt',
        'Site tracking' => 'dc-subpage-tracking-opt',
        'Extras' => 'dc-subpage-extras-opt',
        'Export / Import CMS settings' => 'dc-subpage-export-opt' 
     );
     

   
    /*********************************************************** 
    * Public functions
    ************************************************************/           
 
         
    public function renderTab($global_menu)
    { 
        $this->process();          
        $this->renderCMS($global_menu);        
    }

    public function getOption($opt)
    {                        
        return $this->_general[$opt];
    }
    
    public function customCSS()
    {
        $out = '';        
        $out .= '<style type="text/css">';                 

        if($this->_general['theme_h_color_use'])
        {        
            $out .= ' h1, h2, h3, h4, h5, h6 { ';
                $out .= 'color:'.$this->_general['theme_h_color'].';';
            $out .= '} ';
        }

        if($this->_general['theme_hsub_color_use'])
        {           
            $out .= ' h1 span, h2 span, h3 span, h4 span, h5 span, h6 span { ';
                $out .= 'color:'.$this->_general['theme_hsub_color'].';';
            $out .= '} ';
        }

        if($this->_general['theme_a_color_use'])
        {           
            $out .= ' a { ';
                $out .= 'color:'.$this->_general['theme_a_color'].';';
            $out .= '} ';
        }
       
        if($this->_general['theme_ahover_color_use'])
        {           
            $out .= ' a:hover { ';
                $out .= 'color:'.$this->_general['theme_ahover_color'].';';
            $out .= '} ';
        }
        
        if($this->_general['bg_display'] or $this->_general['bg_color_use'])
        {   
            $out .= ' body { ';
                if($this->_general['bg_display'])
                {
                    $out .= 'background-image:url('.$this->_general['bg_image'].');';
                    $out .= 'background-repeat:'.$this->_general['bg_repeat'].';';
                    $out .= 'background-attachment:'.$this->_general['bg_attachment'].';';
                    
                    $pos_x = $this->_general['bg_pos_x'];
                    $pos_y = $this->_general['bg_pos_y'];
                    if($this->_general['bg_pos_x_px_use']) { $pos_x = $this->_general['bg_pos_x_px'].'px'; }
                    if($this->_general['bg_pos_y_px_use']) { $pos_y = $this->_general['bg_pos_y_px'].'px'; }
                    
                    $out .= 'background-position:'.$pos_x.' '.$pos_y.';';
                }
                
                if($this->_general['bg_color_use'])
                {
                    $out .= 'background-color:'.$this->_general['bg_color'].';';    
                } 
            $out .= ' } ';        
        }                   
        
        if($this->_general['emoticons_use'])
        {
            $out .= ' .wp-smiley { ';
                $out .= 'position:relative;';
                $out .= 'top:'.$this->_general['emoticons_top'].'px;';
            $out .= '} ';
        }     
        
        if($this->_general['abar_a_color_use'])
        {
            $out .= ' #dc-announcement-bar a { ';
                $out .= 'color:'.$this->_general['abar_a_color'].';';
            $out .= '} ';
        }

        if($this->_general['abar_a_hcolor_use'])
        {
            $out .= ' #dc-announcement-bar a:hover { ';
                $out .= 'color:'.$this->_general['abar_a_hcolor'].';';
            $out .= '} ';
        }

        if($this->_general['abar_display'])
        {          
            if($this->_general['abar_cbtn_display'])
            {
                $out .= '#dc-announcement-bar .close-btn:hover ';
                $out .= '{ ';
                    $out .= 'background-color:'.$this->_general['abar_cbtn_bg_hcolor'].' !important; ';     
                $out .= '} ';                
            }
            
            if($this->_general['abar_display_in_lowres'])
            {                        
                $out .= '/* All Mobile Sizes (devices and browser) */ ';
                $out .= '@media only screen and (max-width: 767px) { ';
            
                    $out .= '#dc-announcement-bar ';
                    $out .= '{ ';
                        $out .= 'display:block !important; ';     
                    $out .= '} ';
                    
                $out .= '} /* @media */ ';                 
            }
        
        }
        
        if($this->_general['css_code_use'] and $this->_general['css_code'] != '')
        {
            $out .= $this->_general['css_code'];
        }
                        
        $out .= '</style>';        
        echo $out;
    }  

    public function getThemeCSSLink($echo=true)    
    {        
        $file = 'common.css';
        switch($this->_general['theme_css_mode'])
        {
            case 'responsive':       { $file = 'common.css'; }             break; 
            case 'responsive_hires': { $file = 'common_hires.css'; }       break;
            case 'std_fixed':        { $file = 'common_fixed.css'; }       break; 
            case 'std_hires_fixed':  { $file = 'common_hires_fixed.css'; } break; 
            default:                 { $file = 'common.css'; }             break;            
        }
        
        $out = '<link type="text/css" rel="stylesheet" href="'.CMS_THEME_URL.'/css/'.$file.'" />';        
        if($echo) { echo $out; } else return $out;       
    }                                   

    // media buttons
    public function getMediaButtons()
    {
        $out = '';
        $out .= $this->getPredefinedMediaButtons();
        return $out;
    }
    
    private function getPredefinedMediaButtons($echo=false)
    {
        $out = '';
        $out .= '<a class="dc-cms-add-media-shortcodes dc-cms-wp-media-btn" title="Theme shortcodes" href="">';
            $out .= '<img alt="Embed a Video" src="'.CMS_THEME_URL.'/cms/img/lightbulb/shortcodes.png" alt="DC Button" onclick="return false;" />';
        $out .= '</a>';              
             
        if($echo) { echo $out; } else { return $out; }
    }

    // favicon
    public function getFavicon($echo=true)
    {        
        $out = '';
        if($this->_general['icon_iphone_display'] and $this->_general['icon_iphone_url'] != '')
        {            
            $out .= '<link rel="apple-touch-icon" href="'.$this->_general['icon_iphone_url'].'" /> ';
        }
        if($this->_general['icon_ipad_display'] and $this->_general['icon_ipad_url'] != '')
        {            
            $out .= '<link rel="apple-touch-icon" sizes="'.$this->_general['icon_ipad_size'].'x'.$this->_general['icon_ipad_size'].'" href="'.$this->_general['icon_ipad_url'].'" /> ';
        }
        if($this->_general['icon_iphone_ret_display'] and $this->_general['icon_iphone_ret_url'] != '')
        {            
            $out .= '<link rel="apple-touch-icon" sizes="'.$this->_general['icon_iphone_ret_size'].'x'.$this->_general['icon_iphone_ret_size'].'" href="'.$this->_general['icon_iphone_ret_url'].'" /> ';
        }
        if($this->_general['icon_ipad_ret_display'] and $this->_general['icon_ipad_ret_url'] != '')
        {            
            $out .= '<link rel="apple-touch-icon" sizes="'.$this->_general['icon_ipad_ret_size'].'x'.$this->_general['icon_ipad_ret_size'].'" href="'.$this->_general['icon_ipad_ret_url'].'" /> ';
        }
        if($this->_general['favicon_display'] and $this->_general['favicon_url'] != '')
        {            
            $out .= '<link rel="icon" href="'.$this->_general['favicon_url'].'" type="image/x-icon" /> ';               
        }        
        
        if($echo) { echo $out; } else { return $out; }
    }
                              
    /*********************************************************** 
    * Private functions
    ************************************************************/      

    public function setDefaults()
    { 
        $this->_generalDef['breadcrumb_blog_name'] = get_bloginfo('name');
        $this->_generalDef['comments_def_avatar'] = CMS_THEME_URL.'/cms/img/def_avatar.jpg'; 
        $this->_generalDef['abar_cbtn_image'] = CMS_THEME_URL.'/img/annobar/close-btn.png';   
        
        $theme_icons_list = new DCC_ServerCatalogContent();
        $theme_icons_list->readCatalog(array('catalog' => 'img/smilies'));                  
        $this->_general['emoticons_files'] = $theme_icons_list->_files_list;
    }
   
    private function process()
    {
        $this->_process_info = '';
        $this->_process_info_error = '';
        $this->_process_info_exclamation = '';
        
        # THEME CORE
        $this->processThemeCore();               
    
        # THEME MAIN LOGO   
        $this->processMainLogo();
        
        # HEADER ICONS BOX
        $this->processHeaderIconsBox();
        
        # SIDEBAR
        $this->processSidebar();         
        
        # CONTACT FORM CREATOR
        $this->processContactFormCreator();
        
        # MISC PANEL
        $this->processMisc();
        
        # FOOTER
        $this->processFooter();       
        
        # SEO
        $this->processSEO();    
        
        # TWITTER
        $this->processTwitter();
        
        # ANNOUNCEMENT BAR
        $this->processAnnouncementBar();

        # TRACKING
        $this->processTracking();   
                           
        # EXTRAS
        $this->processExtras();                                               
    }
    
    private function processThemeCore()
    {
        if(isset($_POST['dc-general-save-core-opt']))
        {                          
            $this->_general['theme_autoformating'] = isset($_POST['theme_autoformating']) ? true : false;   
            $this->_general['theme_autotexturize'] = isset($_POST['theme_autotexturize']) ? true : false;
            $this->_general['theme_authorize_comment'] = isset($_POST['theme_authorize_comment']) ? true : false;
            $this->_general['theme_authorize_contact'] = isset($_POST['theme_authorize_contact']) ? true : false;

            $this->_general['theme_use_post_wp_thumbnail'] = isset($_POST['theme_use_post_wp_thumbnail']) ? true : false;
            $this->_general['theme_use_page_wp_thumbnail'] = isset($_POST['theme_use_page_wp_thumbnail']) ? true : false;            
            
            $this->_general['theme_primary_menu'] = $_POST['theme_primary_menu']; 
            $this->_general['theme_primary_menu_wp'] = isset($_POST['theme_primary_menu_wp']) ? true : false;  
            $this->_general['theme_css_mode'] = $_POST['theme_css_mode'];
            
            $this->_general['theme_top_empty_space'] = $_POST['theme_top_empty_space'];
            $this->_general['theme_bottom_empty_space'] = $_POST['theme_bottom_empty_space'];
                                 
            $this->_general['theme_h_color'] = $_POST['theme_h_color']; 
            $this->_general['theme_hsub_color'] = $_POST['theme_hsub_color'];             
            $this->_general['theme_a_color'] = $_POST['theme_a_color']; 
            $this->_general['theme_ahover_color'] = $_POST['theme_ahover_color'];  
            
            $this->_general['theme_h_color_use'] = isset($_POST['theme_h_color_use']) ? true : false; 
            $this->_general['theme_hsub_color_use'] = isset($_POST['theme_hsub_color_use']) ? true : false;             
            $this->_general['theme_a_color_use'] = isset($_POST['theme_a_color_use']) ? true : false;   
            $this->_general['theme_ahover_color_use'] = isset($_POST['theme_ahover_color_use']) ? true : false;   
                                           
            $this->_general['bg_image'] = $_POST['bg_image']; 
            $this->_general['bg_attachment'] = $_POST['bg_attachment']; 
            $this->_general['bg_repeat'] = $_POST['bg_repeat'];
            $this->_general['bg_color'] = $_POST['bg_color'];
            $this->_general['bg_pos_x'] = $_POST['bg_pos_x']; 
            $this->_general['bg_pos_y'] = $_POST['bg_pos_y']; 

            $this->_general['bg_pos_x_px'] = $_POST['bg_pos_x_px']; 
            $this->_general['bg_pos_y_px'] = $_POST['bg_pos_y_px']; 
            
            $this->_general['bg_pos_x_px_use'] = isset($_POST['bg_pos_x_px_use']) ? true : false;   
            $this->_general['bg_pos_y_px_use'] = isset($_POST['bg_pos_y_px_use']) ? true : false;
            $this->_general['bg_display'] = isset($_POST['bg_display']) ? true : false;
            $this->_general['bg_force'] = isset($_POST['bg_force']) ? true : false;
            $this->_general['bg_color_use'] = isset($_POST['bg_color_use']) ? true : false;            
            
            $this->_general['breadcrumb_display'] = isset($_POST['breadcrumb_display']) ? true : false; 
            $this->_general['breadcrumb_blog_name'] = stripcslashes($_POST['breadcrumb_blog_name']); 
            $this->_general['breadcrumb_before'] = stripcslashes($_POST['breadcrumb_before']); 
            $this->_general['breadcrumb_before_display'] = isset($_POST['breadcrumb_before_display']) ? true : false; 
            $this->_general['breadcrumb_blog_name_force'] = isset($_POST['breadcrumb_blog_name_force']) ? true : false; 
            $this->_general['breadcrumb_blog_name_display'] = isset($_POST['breadcrumb_blog_name_display']) ? true : false; 

            $this->_general['project_infobar_date_format'] = $_POST['project_infobar_date_format'];
            $this->_general['project_infobar_date_display'] = isset($_POST['project_infobar_date_display']) ? true : false;
            $this->_general['project_infobar_author_display'] = isset($_POST['project_infobar_author_display']) ? true : false; 
            $this->_general['project_infobar_comments_display'] = isset($_POST['project_infobar_comments_display']) ? true : false; 
            $this->_general['project_infobar_categories_display'] = isset($_POST['project_infobar_categories_display']) ? true : false;          
            $this->_general['project_infobar_website_display'] = isset($_POST['project_infobar_website_display']) ? true : false;
            $this->_general['project_infobar_client_display'] = isset($_POST['project_infobar_client_display']) ? true : false;
            $this->_general['project_infobar_skills_display'] = isset($_POST['project_infobar_skills_display']) ? true : false;
            
            $this->_general['project_single_posted_date'] = isset($_POST['project_single_posted_date']) ? true : false;                
            
            $this->_general['project_layout_category_page'] = $_POST['project_layout_category_page'];             
            $this->_general['project_sid_default_cats_left'] = $_POST['project_sid_default_cats_left'];
            $this->_general['project_sid_default_cats_right'] = $_POST['project_sid_default_cats_right'];            
            $this->_general['project_category_per_page'] = $_POST['project_category_per_page'];
            $this->_general['project_category_columns'] = $_POST['project_category_columns'];
            $this->_general['project_category_order'] = $_POST['project_category_order'];
            $this->_general['project_category_orderby'] = $_POST['project_category_orderby'];
            $this->_general['project_category_words'] = $_POST['project_category_words']; 
            $this->_general['project_category_excerpt'] = isset($_POST['project_category_excerpt']) ? true : false; 
            $this->_general['project_category_viewport_use'] = isset($_POST['project_category_viewport_use']) ? true : false;
            $this->_general['project_category_viewport_w'] = $_POST['project_category_viewport_w'];  
            $this->_general['project_category_viewport_h'] = $_POST['project_category_viewport_h']; 
            
            $this->_general['blog_infobar_date_format'] = $_POST['blog_infobar_date_format'];
            $this->_general['blog_infobar_date_display'] = isset($_POST['blog_infobar_date_display']) ? true : false;
            $this->_general['blog_infobar_author_display'] = isset($_POST['blog_infobar_author_display']) ? true : false; 
            $this->_general['blog_infobar_comments_display'] = isset($_POST['blog_infobar_comments_display']) ? true : false; 
            $this->_general['blog_infobar_categories_display'] = isset($_POST['blog_infobar_categories_display']) ? true : false;          
            $this->_general['blog_infobar_tags_display'] = isset($_POST['blog_infobar_tags_display']) ? true : false; 
                        
            $this->_general['blog_full_ib_date_format'] = $_POST['blog_full_ib_date_format'];
            $this->_general['blog_full_ib_date_display'] = isset($_POST['blog_full_ib_date_display']) ? true : false;
            $this->_general['blog_full_ib_author_display'] = isset($_POST['blog_full_ib_author_display']) ? true : false; 
            $this->_general['blog_full_ib_comments_display'] = isset($_POST['blog_full_ib_comments_display']) ? true : false; 
            $this->_general['blog_full_ib_categories_display'] = isset($_POST['blog_full_ib_categories_display']) ? true : false;          
            $this->_general['blog_full_ib_tags_display'] = isset($_POST['blog_full_ib_tags_display']) ? true : false;           
            
            $this->_general['blog_full_about_user_display'] = isset($_POST['blog_full_about_user_display']) ? true : false;          
            $this->_general['blog_full_about_extra_users_display'] = isset($_POST['blog_full_about_extra_users_display']) ? true : false;                 
                           
            $this->_general['blog_date_under_title_display'] = isset($_POST['blog_date_under_title_display']) ? true : false;          
            $this->_general['blog_full_date_under_title_display'] = isset($_POST['blog_full_date_under_title_display']) ? true : false;                 
            
            $this->_general['blog_related_display'] = isset($_POST['blog_related_display']) ? true : false;
            $this->_general['blog_related_count'] = $_POST['blog_related_count'];
            $this->_general['blog_related_taxonomy'] = $_POST['blog_related_taxonomy'];         
            
            $this->_general['comments_in_posts_display'] = isset($_POST['comments_in_posts_display']) ? true : false; 
            $this->_general['comments_in_pages_display'] = isset($_POST['comments_in_pages_display']) ? true : false; 
            $this->_general['comments_reverse_children'] = isset($_POST['comments_reverse_children']) ? true : false;
            
            $this->_general['comments_time_format'] = $_POST['comments_time_format']; 
            $this->_general['comments_time_display'] = isset($_POST['comments_time_display']) ? true : false;
            $this->_general['comments_author_display'] = isset($_POST['comments_author_display']) ? true : false; 
            $this->_general['comments_author_url_display'] = isset($_POST['comments_author_url_display']) ? true : false;            
            $this->_general['comments_mark_author'] = isset($_POST['comments_mark_author']) ? true : false;
            $this->_general['comments_url_field'] = isset($_POST['comments_url_field']) ? true : false;        
            $this->_general['comments_time_ago_display'] = isset($_POST['comments_time_ago_display']) ? true : false;            
            $this->_general['comments_def_avatar'] = $_POST['comments_def_avatar'];            
            $this->_general['comments_avatar_display'] = isset($_POST['comments_avatar_display']) ? true : false;                         
            
            update_option($this->_DBIDOPT_GENERAL, $this->_general);                         
            $this->_process_info = 'Theme core settings saved';                 
        }           
    }
    
    private function processMainLogo()
    {
        if($this->isSubPage('dc-subpage-main-logo-opt'))
        {
            if(isset($_POST['dc-general-save-main-logo-opt']))
            {
                $this->_general['logo_display'] = isset($_POST['logo_display']) ? true : false;    
                        
                $this->_general['logo_grayscale'] = isset($_POST['logo_grayscale']) ? true : false; 
                $this->_general['logo_linkable'] = isset($_POST['logo_linkable']) ? true : false; 
                $this->_general['logo_target_blank'] = isset($_POST['logo_target_blank']) ? true : false; 
                $this->_general['logo_link_to_page'] = isset($_POST['logo_link_to_page']) ? true : false;
                $this->_general['logo_link_to_theme'] = isset($_POST['logo_link_to_theme']) ? true : false; 
                $this->_general['logo_link_to_url'] = isset($_POST['logo_link_to_url']) ? true : false; 
                
                $this->_general['logo_debug_frame'] = isset($_POST['logo_debug_frame']) ? true : false;                
                $this->_general['logo_center'] = isset($_POST['logo_center']) ? true : false;
                
                $this->_general['logo_page'] = $_POST['logo_page'];
                $this->_general['logo_url'] = $_POST['logo_url'];                
                
                $this->_general['logo_img'] = $_POST['logo_img']; 
                $this->_general['logo_width'] = $_POST['logo_width'];
                $this->_general['logo_height'] = $_POST['logo_height'];
                $this->_general['logo_height_use'] = isset($_POST['logo_height_use']) ? true : false;
                
                update_option($this->_DBIDOPT_GENERAL, $this->_general);            
                $this->_process_info = 'Theme main logo settings saved';    
            }            
        }          
    }  
    
    private function processHeaderIconsBox()
    {
        if($this->isSubPage('dc-subpage-icons-box-opt'))
        {
            if(isset($_POST['dc-general-save-icons-box-opt']))
            {
                $this->_general['icons_display'] = isset($_POST['icons_display']) ? true : false;    
                $this->_general['icons_tooltip_display'] = isset($_POST['icons_tooltip_display']) ? true : false; 
                $this->_general['icons_debug_frame'] = isset($_POST['icons_debug_frame']) ? true : false;
                             
                $this->_general['icons_icon_width'] = (int)$_POST['icons_icon_width'];
                $this->_general['icons_icon_height'] = (int)$_POST['icons_icon_height'];
                $this->_general['icons_icon_mergin_left'] = (int)$_POST['icons_icon_mergin_left'];               
                
                $new_icons_list = array();
                $count = 0;
                foreach($_POST as $key => $value)
                {
                    if(strstr($key, 'icon-box-index-'))
                    {
                        // separete key
                        $index = str_replace('icon-box-index-', '', $key);
                        
                        $args = array();
                        $args['name'] = $_POST['icon-name-'.$index];
                        $args['imgurl'] = $_POST['icon-image-'.$index];
                        $args['imgurl_hover'] = $_POST['icon-image-hover-'.$index]; 
                        $args['desc'] = $_POST['icon-desc-'.$index];
                        $args['url'] = $_POST['icon-url-'.$index];
                        $args['hide'] = isset($_POST['icon-hide-'.$index]) ? true : false;
                        $args['target_blank'] = isset($_POST['icon-target-blank-'.$index]) ? true : false;
                        $args['hovered'] = isset($_POST['icon-hovered-'.$index]) ? true : false; 
                        
                        $saved_icon = new DCC_StandardIcon($args);
                        array_push($new_icons_list, $saved_icon);
                        $count++;                   
                    }                                       
                }     
                
                if($count > 0)
                {
                    $this->_general['icons_list'] = $new_icons_list;
                }           
                
                update_option($this->_DBIDOPT_GENERAL, $this->_general);            
                $this->_process_info = 'Icons box settings saved';                  
            }                        
                        
            if(isset($_POST['dc-general-create-new-icon-box']))
            {
                $name = $_POST['new-icon-name'];                
                $icon = new DCC_StandardIcon(array('name' => $name));
            
                array_push($this->_general['icons_list'], $icon);
            
                update_option($this->_DBIDOPT_GENERAL, $this->_general);
                $this->_process_info = 'New icon created';    
            }
            
            foreach($_POST as $key => $value)
            {
                if(strstr($key, 'dc-general-delete-icon-box-'))
                {
                    // separete key
                    $index = str_replace('dc-general-delete-icon-box-', '', $key);
                    unset($this->_general['icons_list'][$index]);
                    $this->_general['icons_list'] = array_values($this->_general['icons_list']);
                    
                    update_option($this->_DBIDOPT_GENERAL, $this->_general);
                    $this->_process_info = 'Icon was deleted'; 
                    break;
                }
            }                           
        }           
    }
    
    private function processSidebar()
    {
        if($this->isSubPage('dc-subpage-sidebar-opt'))
        {   
            if(isset($_POST['dc-general-save-sidebar-opt'])) 
            {
                $this->_general['sid_last_as_first'] = isset($_POST['sid_last_as_first']) ? true : false;
                $this->_general['sid_default_left'] = $_POST['sid_default_left'];
                $this->_general['sid_default_right'] = $_POST['sid_default_right']; 
                $this->_general['sid_default_post_left'] = $_POST['sid_default_post_left'];
                $this->_general['sid_default_post_right'] = $_POST['sid_default_post_right']; 
                $this->_general['sid_default_cats_left'] = $_POST['sid_default_cats_left'];
                $this->_general['sid_default_cats_right'] = $_POST['sid_default_cats_right'];
                $this->_general['sid_default_archive_left'] = $_POST['sid_default_archive_left'];
                $this->_general['sid_default_archive_right'] = $_POST['sid_default_archive_right'];
                $this->_general['sid_404_left'] = $_POST['sid_404_left'];
                $this->_general['sid_404_right'] = $_POST['sid_404_right'];
                $this->_general['sid_search_left'] = $_POST['sid_search_left'];
                $this->_general['sid_search_right'] = $_POST['sid_search_right'];
                
                $this->_general['sid_individual_cats'] = array();
                foreach($_POST as $key => $value)
                {
                    $left_finded = strstr($key, 'sid-individual-cats-left-');
                    $right_finded = strstr($key, 'sid-individual-cats-right-');
                    
                    if($left_finded or $right_finded)
                    {
                        $index = null;
                        if($left_finded) { $index = str_replace('sid-individual-cats-left-', '', $key); }
                        if($right_finded) { $index = str_replace('sid-individual-cats-right-', '', $key); }
                        
                        if(!array_key_exists($index, $this->_general['sid_individual_cats']) or 
                           !is_object($this->_general['sid_individual_cats'][$index]))
                        {   
                             
                            $obj = new DCC_PageSidebars();
                            $obj->left = CMS_NOT_SELECTED;
                            $obj->right = CMS_NOT_SELECTED;
                            $this->_general['sid_individual_cats'][$index] = $obj;                             
                        }                           
                         
                        if($left_finded) { $this->_general['sid_individual_cats'][$index]->left = $value; }
                        if($right_finded) { $this->_general['sid_individual_cats'][$index]->right = $value; }                         
                    }                                       
                }                                                

                update_option($this->_DBIDOPT_GENERAL, $this->_general);                         
                $this->_process_info = 'Sidebars settings saved';                     
            }
            
            
            if(isset($_POST['dc-general-create-new-sidebar']))
            {
                $name = $_POST['new-sidebar-name'];
                $sid = new DCC_Sidebar($name);
                array_push($this->_sidlist, $sid);    
                
                update_option($this->_DBIDOPT_SIDLIST, $this->_sidlist);                         
                $this->_process_info = 'New sidebar created';                  
            }   
           
            foreach($_POST as $key => $value)
            {                
                if(strstr($key, 'dc-general-delete-sidebar-'))
                {
                    // separete key
                    $index = str_replace('dc-general-delete-sidebar-', '', $key);
                    unset($this->_sidlist[$index]); 
                    $this->_sidlist = array_values($this->_sidlist);
                    update_option($this->_DBIDOPT_SIDLIST, $this->_sidlist);
                    $this->_process_info = 'Sidebar was deleted'; 
                    break;
                }
            }
                                 
        }          
    }
    
    private function processContactFormCreator()
    {
        if($this->isSubPage('dc-subpage-contact-form-opt'))
        {
            if(isset($_POST['dc-general-create-new-contact-form']))
            {
                $name = $_POST['new-contact-form-name'];
                $args = array();
                if($name != '') { $args['name'] = $name; }
                $cf = new DCC_ContactForm($args);
                
                array_push($this->_general['cf_list'], $cf);
                
                update_option($this->_DBIDOPT_GENERAL, $this->_general);
                $this->_process_info = 'New contact form was created';                                
            }     
            
            if(isset($_POST['dc-general-create-default-contact-form']))
            {
                $name = $_POST['new-contact-form-name'];
                $args = array();
                if($name != '') { $args['name'] = $name; }
                $cf = new DCC_ContactForm($args);                     

                $user = new DCC_ContactFormInput(array('type'=>'text', 'required'=>true, 'label'=>'Your Name:', 'func_name' => true));
                $email = new DCC_ContactFormInput(array('type'=>'text', 'required'=>true, 'label'=>'Your Email:', 'is_email'=>true, 'func_email' => true));
                $subject = new DCC_ContactFormInput(array('type'=>'text', 'required'=>true, 'label'=>'Subject:', 'func_subject' => true));
                $message = new DCC_ContactFormInput(array('type'=>'textarea', 'required'=>true, 'label'=>'Your message:', 'func_message' => true));
                
                $cf->_inputs = array($user, $email, $subject, $message);
                
                array_push($this->_general['cf_list'], $cf);
                
                update_option($this->_DBIDOPT_GENERAL, $this->_general);
                $this->_process_info = 'Theme standard contact form was created';                
            
            }

            if(isset($_POST['dc-general-save-contact-form-opt']))
            {
                $this->_general['cf_message_ok'] = stripcslashes($_POST['cf_message_ok']); 
                $this->_general['cf_message_error'] = stripcslashes($_POST['cf_message_error']); 
                
                $edited_cf_index = CMS_NOT_SELECTED;
                if(isset($_POST['edited-cf-index'])) { $edited_cf_index = $_POST['edited-cf-index']; }  
                
                if($edited_cf_index != CMS_NOT_SELECTED)
                {
                    $new_inputs_list = array();
                    $count = 0;
                    
                    foreach($_POST as $key => $value)
                    {
                        if(strstr($key, 'cf-ctrl-data-type-'))
                        {
                            $index = str_replace('cf-ctrl-data-type-', '', $key);
                            
                            $type = $_POST['cf-ctrl-data-type-'.$index];
                            $label = $_POST['cf-ctrl-data-label-'.$index];
                            $required = isset($_POST['cf-ctrl-data-required-'.$index]) ? true : false; 
                            $default = $_POST['cf-ctrl-data-default-'.$index];
                            $is_email = isset($_POST['cf-ctrl-data-is-email-'.$index]) ? true : false;
                            $is_authorization = isset($_POST['cf-ctrl-data-is-authorization-'.$index]) ? true : false; 
                            
                            $hide = isset($_POST['cf-ctrl-data-hide-'.$index]) ? true : false;
                            $hide_label = isset($_POST['cf-ctrl-data-hide-label-'.$index]) ? true : false; 
                            $use_default = isset($_POST['cf-ctrl-data-use-default-'.$index]) ? true : false; 
                            $width = $_POST['cf-ctrl-data-width-'.$index];
                            $height = $_POST['cf-ctrl-data-height-'.$index];
                            $use_width = isset($_POST['cf-ctrl-data-use-width-'.$index]) ? true : false;  
                            $use_height = isset($_POST['cf-ctrl-data-use-height-'.$index]) ? true : false;                              
                        
                            $func_info = isset($_POST['cf-ctrl-data-func-info-'.$index]) ? true : false;
                            $func_name = isset($_POST['cf-ctrl-data-func-name-'.$index]) ? true : false;
                            $func_email = isset($_POST['cf-ctrl-data-func-email-'.$index]) ? true : false;
                            $func_subject = isset($_POST['cf-ctrl-data-func-subject-'.$index]) ? true : false;
                            $func_message = isset($_POST['cf-ctrl-data-func-message-'.$index]) ? true : false; 
                        
                            $args = array();
                            $args['type'] = $type;
                            $args['label'] = $label;
                            $args['required'] = $required;
                            $args['default'] = $default; 
                            $args['is_email'] = $is_email; 
                            $args['is_authorization'] = $is_authorization;
                            $args['hide'] = $hide;
                            $args['use_default'] = $use_default;
                            $args['hide_label'] = $hide_label;
                            $args['use_width'] = $use_width;
                            $args['use_height'] = $use_height;
                            $args['width'] = $width;
                            $args['height'] = $height;
                            $args['default_option'] = CMS_NOT_SELECTED;
                            $args['func_info'] = $func_info;
                            $args['func_name'] = $func_name;
                            $args['func_email'] = $func_email;
                            $args['func_subject'] = $func_subject;
                            $args['func_message'] = $func_message;
                            $args['options'] = array();
                            
                            // if select control, read all options data
                            if($type == 'select')
                            {
                                if(isset($_POST['cf-ctrl-data-default-option-'.$index]))
                                {   
                                    $args['default_option'] = $_POST['cf-ctrl-data-default-option-'.$index];
                                } else { $args['default_option'] = CMS_NOT_SELECTED; }
                                
                                $new_options_table = array();
                                
                                foreach($_POST as $option_key => $option_value)
                                {                                    
                                    if(strstr($option_key, 'cf-ctrl-data-option-'.$index.'-'))
                                    {
                                        $option_index = str_replace('cf-ctrl-data-option-'.$index.'-', '', $option_key);
                                        
                                        $value = $_POST['cf-ctrl-data-option-'.$index.'-'.$option_index];  
                                                        
                                        $id = $_POST['cf-ctrl-data-option-id-'.$index.'-'.$option_index]; 
                                        $option = new DCC_ContactFormSelectOption(array('id'=>$id, 'value' => $value));      
                                        array_push($new_options_table, $option);  
                                    }     
                                }
                                $args['options'] = $new_options_table;
                            }
                        
                            $control = new  DCC_ContactFormInput($args); 
                            array_push($new_inputs_list, $control);              
                            $count++;
                        } 
                    }
                    
                    if($count)
                    {
                        $this->_general['cf_list'][$edited_cf_index]->_inputs = $new_inputs_list;
                    }                                             
                }
                
                update_option($this->_DBIDOPT_GENERAL, $this->_general);
                $this->_process_info = 'Contact form settings saved';                    
            }
            
            
            foreach($_POST as $key => $value)
            {
           
                if(strstr($key, 'dc-general-delete-cf-control-'))
                {
                    $edited_cf_index = CMS_NOT_SELECTED;
                    if(isset($_POST['edited-cf-index'])) { $edited_cf_index = $_POST['edited-cf-index']; }  
                
                    if($edited_cf_index != CMS_NOT_SELECTED)
                    {
                        $index = str_replace('dc-general-delete-cf-control-', '', $key);
                        unset($this->_general['cf_list'][$edited_cf_index]->_inputs[$index]);   
                        
                        $this->_general['cf_list'][$edited_cf_index]->_inputs = array_values($this->_general['cf_list'][$edited_cf_index]->_inputs);
                        
                        update_option($this->_DBIDOPT_GENERAL, $this->_general);
                        $this->_process_info = 'Contact form control was deleted';
                        break;
                    }                 
                }                
                
                
                if(strstr($key, 'dc-general-update-contact-form-'))
                {
                    $index = str_replace('dc-general-update-contact-form-', '', $key);
                    $name = $_POST['contact-form-name-'.$index];
                    $this->_general['cf_list'][$index]->_name = $name;
                    
                    update_option($this->_DBIDOPT_GENERAL, $this->_general);
                    $this->_process_info = 'Contact form was updated'; 
                        
                }                 
                
                
                if(strstr($key, 'dc-general-edit-contact-form-'))
                {
                    $index = str_replace('dc-general-edit-contact-form-', '', $key);
                    $this->_general['cf_edited'] = $index;
                    
                    update_option($this->_DBIDOPT_GENERAL, $this->_general);
                    $this->_process_info = 'Contact form <strong>'.$this->_general['cf_list'][$index]->_name.'</strong> was selected to edit'; 
                        
                } 
                
                if(strstr($key, 'dc-general-delete-contact-form-'))
                {
                    $index = str_replace('dc-general-delete-contact-form-', '', $key);
                    if($this->_general['cf_edited'] == $index) { $this->_general['cf_edited'] = CMS_NOT_SELECTED; }
                    unset($this->_general['cf_list'][$index]);
                    $this->_general['cf_list'] = array_values($this->_general['cf_list']);
                    
                    update_option($this->_DBIDOPT_GENERAL, $this->_general);
                    $this->_process_info = 'Contact form was deleted'; 
                    break;                    
                }
            }       
        }        
    }
    
    private function processMisc()
    {
        if($this->isSubPage('dc-subpage-misc-opt'))
        {               
            if(isset($_POST['dc-general-save-misc-opt']))
            {
                $this->_general['favicon_url'] = trim($_POST['favicon_url']);
                $this->_general['favicon_display'] = isset($_POST['favicon_display']) ? true : false;
                
                $this->_general['icon_iphone_url'] = trim($_POST['icon_iphone_url']);
                $this->_general['icon_iphone_display'] = isset($_POST['icon_iphone_display']) ? true : false;
                $this->_general['icon_ipad_url'] = trim($_POST['icon_ipad_url']);
                $this->_general['icon_ipad_display'] = isset($_POST['icon_ipad_display']) ? true : false;
                $this->_general['icon_ipad_size'] = $_POST['icon_ipad_size'];
                $this->_general['icon_iphone_ret_url'] = trim($_POST['icon_iphone_ret_url']);
                $this->_general['icon_iphone_ret_display'] = isset($_POST['icon_iphone_ret_display']) ? true : false;
                $this->_general['icon_iphone_ret_size'] = $_POST['icon_iphone_ret_size'];
                $this->_general['icon_ipad_ret_url'] = trim($_POST['icon_ipad_ret_url']);
                $this->_general['icon_ipad_ret_display'] = isset($_POST['icon_ipad_ret_display']) ? true : false;
                $this->_general['icon_ipad_ret_size'] = $_POST['icon_ipad_ret_size'];                                
                                
                $this->_general['header_infobox_display'] = isset($_POST['header_infobox_display']) ? true : false;
     
                $info_box_entrys = array();
                foreach($_POST as $key => $value)
                {
                    if(strstr($key, 'dc-header-info-bar-entry-index-'))
                    {
                        $index = str_replace('dc-header-info-bar-entry-index-', '', $key);
                        $text = stripcslashes($_POST['dc-header-info-bar-entry-text-'.$index]);
                        $hide = isset($_POST['dc-header-info-bar-entry-hide-'.$index]) ? true : false;
                        
                        $obj = new DCC_HeaderInfoBoxEntry(array('text' => $text, 'hide' => $hide));
                        array_push($info_box_entrys, $obj);                                            
                    }                                    
                }
                $this->_general['header_infobox_list'] = $info_box_entrys;            
                
                $this->_general['layout_category_page'] = $_POST['layout_category_page']; 
                $this->_general['layout_archive_page'] = $_POST['layout_archive_page']; 
                $this->_general['layout_search_page'] = $_POST['layout_search_page']; 
                $this->_general['layout_404_page'] = $_POST['layout_404_page']; 

                $this->_general['archive_category_per_page'] = $_POST['archive_category_per_page']; 
                $this->_general['archive_per_page'] = $_POST['archive_per_page'];              

                $this->_general['404_content'] = stripcslashes($_POST['404_content']); 
                
                $this->_general['search_in_posts'] = isset($_POST['search_in_posts']) ? true : false;
                $this->_general['search_in_pages'] = isset($_POST['search_in_pages']) ? true : false;            
                $this->_general['search_in_member'] = isset($_POST['search_in_member']) ? true : false;  
                $this->_general['search_in_service'] = isset($_POST['search_in_service']) ? true : false;
                $this->_general['search_in_project'] = isset($_POST['search_in_project']) ? true : false;                 
                
                $this->_general['search_form_display'] = isset($_POST['search_form_display']) ? true : false;     
                $this->_general['search_header_panel_display'] = isset($_POST['search_header_panel_display']) ? true : false;                        
                $this->_general['search_per_page'] = $_POST['search_per_page'];            
                $this->_general['search_content'] = stripcslashes($_POST['search_content']); 
                $this->_general['search_dummy_text'] = stripcslashes($_POST['search_dummy_text']);      
                
                $this->_general['css_code'] = stripcslashes(trim($_POST['css_code'])); 
                $this->_general['css_code_use'] = isset($_POST['css_code_use']) ? true : false;            
                
                update_option($this->_DBIDOPT_GENERAL, $this->_general);
                $this->_process_info = 'Miscellaneous setings saved';    
            }
                   
            foreach($_POST as $key => $value)
            {                             
                if(strstr($key, 'dc-delete-header-info-box-entry-'))
                {
                    $index = str_replace('dc-delete-header-info-box-entry-', '', $key);            
                    unset($this->_general['header_infobox_list'][$index]);
                    $this->_general['header_infobox_list'] = array_values($this->_general['header_infobox_list']);
                    
                    update_option($this->_DBIDOPT_GENERAL, $this->_general);
                    $this->_process_info = 'Header info box entry was deleted'; 
                    break;                    
                }
            }            
        
        }        
    }
    
    private function processSEO()
    {
        if($this->isSubPage('dc-subpage-seo-opt'))
        {
            if(isset($_POST['dc-general-save-seo-opt']))
            {   
                $this->_general['seo_use'] = isset($_POST['seo_use']) ? true : false; 
                $this->_general['seo_overwrite_page'] = isset($_POST['seo_overwrite_page']) ? true : false;
                $this->_general['seo_overwrite_post'] = isset($_POST['seo_overwrite_post']) ? true : false;       
                
                $this->_general['seo_title'] = $_POST['seo_title'];  
                $this->_general['seo_title_use'] = isset($_POST['seo_title_use']) ? true : false;
                $this->_general['seo_add_blog_name'] = isset($_POST['seo_add_blog_name']) ? true : false; 
                
                $this->_general['seo_keywords'] = $_POST['seo_keywords'];
                $this->_general['seo_keywords_use'] = isset($_POST['seo_keywords_use']) ? true : false;

                $this->_general['seo_desc'] = $_POST['seo_desc'];
                $this->_general['seo_desc_use'] = isset($_POST['seo_desc_use']) ? true : false;
                
                $this->_general['seo_noindex'] = isset($_POST['seo_noindex']) ? true : false;
                $this->_general['seo_nofollow'] = isset($_POST['seo_nofollow']) ? true : false; 
                $this->_general['seo_nosnippet'] = isset($_POST['seo_nosnippet']) ? true : false; 
                $this->_general['seo_noodp'] = isset($_POST['seo_noodp']) ? true : false; 
                $this->_general['seo_noarchive'] = isset($_POST['seo_noarchive']) ? true : false; 
                $this->_general['seo_noimageindex'] = isset($_POST['seo_noimageindex']) ? true : false; 
                          
                $list = $_POST['global_seo_private_meta_list'];
                $list = explode(',', $list);
                
                $private_meta = array();
                if(is_array($list))
                {
                    foreach($list as $index)
                    {
                        if($index == '') { continue; }
                        $obj = new DCC_PrivateSeoMeta();
                        
                        if(isset($_POST['dc-seo-private-meta-'.$index.'-name']))
                        {
                            $obj->_name = $_POST['dc-seo-private-meta-'.$index.'-name'];
                            $obj->_content = $_POST['dc-seo-private-meta-'.$index.'-content'];
                            $obj->_active = isset($_POST['dc-seo-private-meta-'.$index.'-active']) ? true : false; 
                            array_push($private_meta, $obj);                            
                        }
                    }
                }                    
                
                $this->_general['seo_private_meta'] = $private_meta;                          
                          
                update_option($this->_DBIDOPT_GENERAL, $this->_general);
                $this->_process_info = 'SEO settings saved';   
            }            
        }        
    }       
    
    private function processTwitter()
    {
        if($this->isSubPage('dc-subpage-twitter-opt'))
        {
            if(isset($_POST['dc-general-save-twitter-opt']))
            {   
                $this->_general['twitter_consumer_key'] = trim($_POST['twitter_consumer_key']);   
                $this->_general['twitter_consumer_secret'] = trim($_POST['twitter_consumer_secret']); 
                $this->_general['twitter_token_key'] = trim($_POST['twitter_token_key']); 
                $this->_general['twitter_token_secret'] = trim($_POST['twitter_token_secret']);                                            
                          
                update_option($this->_DBIDOPT_GENERAL, $this->_general);
                $this->_process_info = 'Twitter settings saved';   
            }            
        }        
    }        

    private function processAnnouncementBar()
    {
        if($this->isSubPage('dc-subpage-announcement-bar-opt'))
        {
            if(isset($_POST['dc-general-save-abar-opt']))
            {
                $this->_general['abar_display'] = isset($_POST['abar_display']) ? true : false;  
                $this->_general['abar_display_in_lowres'] = isset($_POST['abar_display_in_lowres']) ? true : false;                  
                $this->_general['abar_display_shadow'] = isset($_POST['abar_display_shadow']) ? true : false; 

                $this->_general['abar_h'] = $_POST['abar_h'];  
                $this->_general['abar_pt'] = $_POST['abar_pt'];
                $this->_general['abar_pr'] = $_POST['abar_pr'];
                $this->_general['abar_pb'] = $_POST['abar_pb'];
                $this->_general['abar_pl'] = $_POST['abar_pl'];

                $this->_general['abar_pt_use'] = isset($_POST['abar_pt_use']) ? true : false;
                $this->_general['abar_pr_use'] = isset($_POST['abar_pr_use']) ? true : false;
                $this->_general['abar_pb_use'] = isset($_POST['abar_pb_use']) ? true : false;
                $this->_general['abar_pl_use'] = isset($_POST['abar_pl_use']) ? true : false;
                
                $this->_general['abar_cbtn_display'] = isset($_POST['abar_cbtn_display']) ? true : false;  
                $this->_general['abar_cbtn_bg_color'] = $_POST['abar_cbtn_bg_color'];   
                $this->_general['abar_cbtn_bg_hcolor'] = $_POST['abar_cbtn_bg_hcolor'];  
                $this->_general['abar_cbtn_image'] = $_POST['abar_cbtn_image']; 
                $this->_general['abar_cbtn_size'] = $_POST['abar_cbtn_size']; 
                
                $this->_general['abar_content'] = stripcslashes($_POST['abar_content']);
                $this->_general['abar_content_use'] = isset($_POST['abar_content_use']) ? true : false;  
                
                $this->_general['abar_link'] = $_POST['abar_link'];   
                $this->_general['abar_link_use'] = isset($_POST['abar_link_use']) ? true : false;
                $this->_general['abar_link_new_tab'] = isset($_POST['abar_link_new_tab']) ? true : false;
                
                $this->_general['abar_font'] = $_POST['abar_font'];
                $this->_general['abar_font_use'] = isset($_POST['abar_font_use']) ? true : false;
                $this->_general['abar_fstyle'] = $_POST['abar_fstyle'];
                $this->_general['abar_fstyle_use'] = isset($_POST['abar_fstyle_use']) ? true : false;
                $this->_general['abar_align'] = $_POST['abar_align'];
                $this->_general['abar_fsize'] = $_POST['abar_fsize'];
                $this->_general['abar_fsize_use'] = isset($_POST['abar_fsize_use']) ? true : false; 
                $this->_general['abar_lheight'] = $_POST['abar_lheight'];
                $this->_general['abar_lheight_use'] = isset($_POST['abar_lheight_use']) ? true : false; 
                $this->_general['abar_color'] = $_POST['abar_color'];
                $this->_general['abar_a_color'] = $_POST['abar_a_color'];
                $this->_general['abar_a_hcolor'] = $_POST['abar_a_hcolor'];
                $this->_general['abar_color_use'] = isset($_POST['abar_color_use']) ? true : false;
                $this->_general['abar_a_color_use'] = isset($_POST['abar_a_color_use']) ? true : false;
                $this->_general['abar_a_hcolor_use'] = isset($_POST['abar_a_hcolor_use']) ? true : false;              

                $this->_general['abar_border_display'] = isset($_POST['abar_border_display']) ? true : false;                
                $this->_general['abar_border_width'] = $_POST['abar_border_width'];
                $this->_general['abar_border_color'] = $_POST['abar_border_color'];
                $this->_general['abar_border_style'] = $_POST['abar_border_style'];                                   
                
                $this->_general['abar_bg_color'] = $_POST['abar_bg_color']; 
                $this->_general['abar_bg_color_use'] = isset($_POST['abar_bg_color_use']) ? true : false; 
                $this->_general['abar_bg_image'] = $_POST['abar_bg_image']; 
                $this->_general['abar_bg_image_display'] = isset($_POST['abar_bg_image_display']) ? true : false; 
                $this->_general['abar_bg_repeat'] = $_POST['abar_bg_repeat'];
                $this->_general['abar_bg_pos_x'] = $_POST['abar_bg_pos_x']; 
                $this->_general['abar_bg_pos_y'] = $_POST['abar_bg_pos_y'];  
                $this->_general['abar_bg_pos_x_px'] = $_POST['abar_bg_pos_x_px']; 
                $this->_general['abar_bg_pos_y_px'] = $_POST['abar_bg_pos_y_px']; 
                $this->_general['abar_bg_pos_x_px_use'] = isset($_POST['abar_bg_pos_x_px_use']) ? true : false; 
                $this->_general['abar_bg_pos_y_px_use'] = isset($_POST['abar_bg_pos_y_px_use']) ? true : false;                                 
                
                update_option($this->_DBIDOPT_GENERAL, $this->_general);
                $this->_process_info = 'Announcement bar settings saved';                              
            }
        }
    }
    
    private function processExtras()
    {
        if($this->isSubPage('dc-subpage-extras-opt'))
        {
            if(isset($_POST['dc-general-save-extras-opt']))
            {   
                $this->_general['emoticons_use'] = isset($_POST['emoticons_use']) ? true : false;  
                $this->_general['emoticons_ext_prior'] = $_POST['emoticons_ext_prior'];                                       
                $this->_general['emoticons_top'] = $_POST['emoticons_top']; 
                          
                $theme_icons_list = new DCC_ServerCatalogContent();
                $theme_icons_list->readCatalog(array('catalog' => 'img/smilies', 'tolower' => true));                   
                $this->_general['emoticons_files'] = $theme_icons_list->_files_list;                                        
                          
                update_option($this->_DBIDOPT_GENERAL, $this->_general);
                $this->_process_info = 'Extras settings saved'; 
            }            
        }        
    }  

    private function processTracking()
    {
        if($this->isSubPage('dc-subpage-tracking-opt'))
        {
            if(isset($_POST['dc-general-save-tracking-opt']))
            {         
                $this->_general['tracking_header_use'] = isset($_POST['tracking_header_use']) ? true : false;  
                $this->_general['tracking_footer_use'] = isset($_POST['tracking_footer_use']) ? true : false;  
                $this->_general['tracking_header_code'] = stripcslashes($_POST['tracking_header_code']);  
                $this->_general['tracking_footer_code'] = stripcslashes($_POST['tracking_footer_code']); 
                          
                update_option($this->_DBIDOPT_GENERAL, $this->_general);
                $this->_process_info = 'Tracking settings saved';   
            }            
        }        
    }  
    
    private function processFooter()
    {
        if($this->isSubPage('dc-subpage-footer-opt'))
        {        
            if(isset($_POST['dc-general-save-footer-opt']))
            {                              
                $this->_general['footer_display'] = isset($_POST['footer_display']) ? true : false;
                $this->_general['footer_before_display'] = isset($_POST['footer_before_display']) ? true : false; 
                $this->_general['footer_after_display'] = isset($_POST['footer_after_display']) ? true : false; 

                $this->_general['footer_before_autoformat'] = isset($_POST['footer_before_autoformat']) ? true : false; 
                $this->_general['footer_after_autoformat'] = isset($_POST['footer_after_autoformat']) ? true : false;                 
                
                $this->_general['footer_before'] = stripcslashes($_POST['footer_before']); 
                $this->_general['footer_after'] = stripcslashes($_POST['footer_after']); 
                
                $this->_general['footer_layout'] = $_POST['footer_layout']; 
                
                $this->_general['footer_sid_1'] = $_POST['footer_sid_1']; 
                $this->_general['footer_sid_2'] = $_POST['footer_sid_2']; 
                $this->_general['footer_sid_3'] = $_POST['footer_sid_3']; 
                $this->_general['footer_sid_4'] = $_POST['footer_sid_4']; 

                                                              
                $this->_general['footer_logo'] = $_POST['footer_logo']; 
                $this->_general['footer_copyright'] = stripcslashes($_POST['footer_copyright']);                 
                $this->_general['footer_copyright_align'] = $_POST['footer_copyright_align'];  
                $this->_general['footer_copyright_pl'] = $_POST['footer_copyright_pl'];                 
                $this->_general['footer_copyright_pr'] = $_POST['footer_copyright_pr']; 
                                
                                
                $this->_general['footer_logo_display'] = isset($_POST['footer_logo_display']) ? true : false; 
                $this->_general['footer_logo_grayscale'] = isset($_POST['footer_logo_grayscale']) ? true : false;  
                $this->_general['footer_copyright_display'] = isset($_POST['footer_copyright_display']) ? true : false;   
                
                $this->_general['footer_logo_opacity'] = $_POST['footer_logo_opacity'];
                $this->_general['footer_logo_pt'] = $_POST['footer_logo_pt'];
                $this->_general['footer_logo_pb'] = $_POST['footer_logo_pb']; 
                $this->_general['footer_logo_align'] = $_POST['footer_logo_align'];                               
                
                update_option($this->_DBIDOPT_GENERAL, $this->_general);
                $this->_process_info = 'Footer settings saved';                    
                
            }
        }        
    }
    
                                                                                      
    private function renderCMS($global_menu)
    {        
        $out = '';
        $out .= $this->getTopLink();                 
        
        $out .= $this->getColumnsWraperBegin();        
        $out .= $this->getLeftColumnBegin();
        
            # THEME CORE
            $out .= $this->renderGeneralCMS();            
            
            # SIDEBAR
            $out .= $this->renderSidebarsCMS(); 
            
            # FOOTER
            $out .= $this->renderFooterCMS(); 
            
            # MAIN LOGO
            $out .= $this->renderMainLogoCMS();     
            
            # ICONS BOX
            $out .= $this->renderIconsBoxCMS();  

            # CONTACT FORM CREATOR
            $out .= $this->renderContactFormCreatorCMS();
            
            # SEO
            $out .= $this->renderSearchEngineCMS();
            
            # TWITTER
            $out .= $this->renderTwitterCMS();

            # ANNOUNCEMENT BAR
            $out .= $this->renderAnnouncementBarCMS();
            
            # EXTRAS
            $out .= $this->renderExtrasCMS();
            
            # MISCELLANEOUS
            $out .= $this->renderMiscCMS();  
            
            # TRACKING
            $out .= $this->renderTrackingCMS();   
            
            # EXPORT
            $out .= $this->renderExportCMS();         

        $out .= $this->getLeftColumnsEnd();
        $out .= $this->renderNav($global_menu);                        
                   
        $out .= $this->getColumnsWraperEnd();    
        echo $out;    
                                                           
    }         

    public function renderGeneralCMS($echo=false)
    {
        $out = '';
        
        if($this->isMasterPage('dc-general-opt'))
        {        
            $out .= $this->getPanelBegin('Theme core settings');
                $out .= '<form action="#" method="post">';
                    $out .= $this->getSubmitTopPanel('dc-general-save-core-opt');
                                                                                                  
                    $out .= $this->getPanelSectionHead('Basic settings');                                          
                    $out .= '<table class="dc-cms-table-standard">';
                        $out .= '<tbody>';                                                          
                                            
                        // primary menu
                        $out .= '<tr><td><span class="dc-cms-left-marked-title">Theme primary menu</span></td><td>'; 
                            $list = GetDCCPI()->getIMenu()->getMenuList();
                            $out .= '<span class="dc-cms-control-top-label-nomargin">Select menu</span>'; 
                            $out .= '<select class="dc-cms-control-300" name="theme_primary_menu">';
                                $out .= '<option value="'.CMS_NOT_SELECTED.'">Not selected</option>';
                                foreach($list as $m)
                                {
                                    $out .= '<option value="'.$m->id.'" '.$this->attrSelected($this->_general['theme_primary_menu'] == $m->id).'>'.$m->name.'</option>';    
                                }
                            $out .= '</select>';
                            
                            $out .= $this->getStdInputsFieldStart(array('mtop-type'=>'small'));
                                $out .= '<input type="checkbox" name="theme_primary_menu_wp" '.$this->attrChecked($this->_general['theme_primary_menu_wp']).' /> Use WordPress menu as primary navigation';
                                $out .= $this->getBookHelp(array('text' => 'If checked, the menu must be created and selected in <span class="dc-cms-marked-span">Appearance &gt; Menus</span> settings section.'));
                            $out .= $this->getStdInputsFieldEnd();
                            
                        $out .= '</td></tr>';   
                        
                        
                        
                        // css mode    
                        $out .= '<tr><td><span class="dc-cms-left-marked-title">CSS mode</span></td><td>'; 
                            $out .= '<span class="dc-cms-control-top-label-nomargin">Select theme CSS mode</span>';
                            $out .= '<select class="dc-cms-control-300" name="theme_css_mode">';
                                $val = $this->_general['theme_css_mode'];
                                $out .= '<option value="responsive"       '.$this->attrSelected($val == 'responsive').'>Responsive (960 pixels grid)</option>';    
                                $out .= '<option value="responsive_hires" '.$this->attrSelected($val == 'responsive_hires').'>Responsive HiRes (1152 pixels grid)</option>';
                                $out .= '<option value="std_fixed"        '.$this->attrSelected($val == 'std_fixed').'>No responsive (960 pixels grid)</option>';
                                $out .= '<option value="std_hires_fixed"  '.$this->attrSelected($val == 'std_hires_fixed').'>No responsive HiRes (1152 pixels grid)</option>';
                            $out .= '</select>';
                        $out .= '</td></tr>';                           
                        
                        // theme general display settings
                        $out .= '<tr><td><span class="dc-cms-left-marked-title">Theme general display settings</span></td><td>'; 
                            $out .= '<span class="dc-cms-control-top-label-nomargin">Top empty space height</span>';
                            $out .= $this->getCtrlInputInt('theme_top_empty_space', $this->_general['theme_top_empty_space'], 0);                        

                            $out .= '<span class="dc-cms-control-top-label">Bottom empty space height</span>';
                            $out .= $this->getCtrlInputInt('theme_bottom_empty_space', $this->_general['theme_bottom_empty_space'], 0);      
                        $out .= '</td></tr>';                                                             
                                                
                        // content formating
                        $out .= '<tr><td><span class="dc-cms-left-marked-title">Content formating</span></td><td>';
                            $out .= $this->getStdInputsFieldStart();
                                $out .= '<input type="checkbox" name="theme_autoformating" '.$this->attrChecked($this->_general['theme_autoformating']).' /> Enable text auto fromating';
                                $out .= $this->getBR();
                                $out .= '<input type="checkbox" name="theme_autotexturize" '.$this->attrChecked($this->_general['theme_autotexturize']).' /> Enable text auto texturize';    
                            $out .= $this->getStdInputsFieldEnd();
                        $out .= '</td></tr>'; 
                    
                        // authorization 
                        $out .= '<tr><td><span class="dc-cms-left-marked-title">Forms authorization</span></td><td>';
                            $out .= $this->getStdInputsFieldStart();
                                $out .= '<input type="checkbox" name="theme_authorize_comment" '.$this->attrChecked($this->_general['theme_authorize_comment']).' /> Enable authorization for comment form';
                                $out .= $this->getBR();
                                $out .= '<input type="checkbox" name="theme_authorize_contact" '.$this->attrChecked($this->_general['theme_authorize_contact']).' /> Enable authorization for contact form';    
                            $out .= $this->getStdInputsFieldEnd();
                        $out .= '</td></tr>';                                                                                                 
                    
                    
                        // thumbnails
                        $out .= '<tr><td><span class="dc-cms-left-marked-title">Wordpress thumbnails</span></td><td>';
                            $out .= $this->getStdInputsFieldStart();
                                $out .= '<input type="checkbox" name="theme_use_post_wp_thumbnail" '.$this->attrChecked($this->_general['theme_use_post_wp_thumbnail']).' /> Use native wordpress thumbnails for posts';
                                $out .= $this->getBR();
                                $out .= '<input type="checkbox" name="theme_use_page_wp_thumbnail" '.$this->attrChecked($this->_general['theme_use_page_wp_thumbnail']).' /> Use native wordpress thumbnails for pages';    
                            $out .= $this->getStdInputsFieldEnd();
                        $out .= '</td></tr>';    
                        
                        // main colors
                        $out .= '<tr><td><span class="dc-cms-left-marked-title">Main colors</span></td><td>';
                            $out .= '<span class="dc-cms-control-top-label-nomargin">Headings color</span>';      
                            $out .= '<input type="text" class="dc-color-picker" name="theme_h_color" value="'.$this->_general['theme_h_color'].'" />';
                            
                            $out .= '<span class="dc-cms-control-top-label">Headings subtitle color</span>';
                            $out .= '<input type="text" class="dc-color-picker" name="theme_hsub_color" value="'.$this->_general['theme_hsub_color'].'" />';

                            $out .= '<span class="dc-cms-control-top-label">Anchor color</span>';
                            $out .= '<input type="text" class="dc-color-picker" name="theme_a_color" value="'.$this->_general['theme_a_color'].'" />';

                            $out .= '<span class="dc-cms-control-top-label">Anchor hover color</span>';
                            $out .= '<input type="text" class="dc-color-picker" name="theme_ahover_color" value="'.$this->_general['theme_ahover_color'].'" />';
                            
                            $out .= $this->getStdInputsFieldStart(array('mtop' => 20));
                                $out .= '<input type="checkbox" name="theme_h_color_use" '.$this->attrChecked($this->_general['theme_h_color_use']).' /> Use header color';
                                $out .= $this->getBR();                                
                                $out .= '<input type="checkbox" name="theme_hsub_color_use" '.$this->attrChecked($this->_general['theme_hsub_color_use']).' /> Use header subtitle color';
                                $out .= $this->getBR();                                
                                $out .= '<input type="checkbox" name="theme_a_color_use" '.$this->attrChecked($this->_general['theme_a_color_use']).' /> Use anchor color';
                                $out .= $this->getBR();                                
                                $out .= '<input type="checkbox" name="theme_ahover_color_use" '.$this->attrChecked($this->_general['theme_ahover_color_use']).' /> Use anchor hover color';
                                $out .= $this->getBR();                                                                                                
                            $out .= $this->getStdInputsFieldEnd();
                                                                                                 
                        $out .= '</td></tr>';                                                                             
      
                        $out .= '</tbody>';
                    $out .= '</table>';                                                                                      
                                                             

                    
                    // theme background
                    $out .= $this->getPanelSectionHead('Theme background settings', 50);
                    $out .= '<table class="dc-cms-table-standard">';                           
                        $out .= '<tbody>';
                    
                        $out .= '<tr><td><span class="dc-cms-left-marked-title">Setup theme background</span></td><td>';
                        
                            $out .= $this->getStdInputsFieldStart();
                                $out .= '<input type="checkbox" name="bg_display" '.$this->attrChecked($this->_general['bg_display']).' /> Display background image';     
                                $out .= $this->getBR();
                                $out .= '<input type="checkbox" name="bg_color_use" '.$this->attrChecked($this->_general['bg_color_use']).' /> Use background color';  
                                $out .= $this->getBR();                                   
                                $out .= '<input type="checkbox" name="bg_force" '.$this->attrChecked($this->_general['bg_force']).' /> Force on whole website (will overwrite pages and posts invidual background settings)';
                            $out .= $this->getStdInputsFieldEnd();
                        
                            $out .= '<span class="dc-cms-control-top-label">URL</span>'; 
                            $out .= '<input type="text" class="dc-cms-control-600" name="bg_image" value="'.$this->_general['bg_image'].'" id="dc_id_bg_image" /> ';                 
                        
                            $out .= $this->getImagePreviewBox(array('path' => $this->_general['bg_image'], 'width' => 240, 'height' => 180));  
                            
                            $out .= '<div class="dc-cms-btn-frame">';
                                $out .= '<input class="dc-cms-submit-image-btn" type="submit" name="dc_id_bg_image" value="'.__('Load image', CMS_TXT_DOMAIN).'" /> ';  
                            $out .= '</div>';                              
                            
                            $out .= $this->getStdWrapperStart();
                            
                                $out .= $this->getStdColumnStart(array('width'=>220)); 
                                    
                                        $out .= '<span class="dc-cms-control-top-label-nomargin">Background X align</span>';   
                                        $out .= '<select name="bg_pos_x" class="dc-cms-control-100">';
                                            $out .= '<option value="left" '.$this->attrSelected($this->_general['bg_pos_x'] == 'left').'>Left</option>';
                                            $out .= '<option value="center" '.$this->attrSelected($this->_general['bg_pos_x'] == 'center').'>Center</option>';
                                            $out .= '<option value="right" '.$this->attrSelected($this->_general['bg_pos_x'] == 'right').'>Right</option>';
                                        $out .= '</select>'; 
                                                                        
                                        $out .= '<span class="dc-cms-control-top-label">Background Y align</span>';
                                        $out .= '<select name="bg_pos_y" class="dc-cms-control-100">';
                                            $out .= '<option value="top" '.$this->attrSelected($this->_general['bg_pos_y'] == 'top').'>Top</option>';
                                            $out .= '<option value="center" '.$this->attrSelected($this->_general['bg_pos_y'] == 'center').'>Center</option>';
                                            $out .= '<option value="bottom" '.$this->attrSelected($this->_general['bg_pos_y'] == 'bottom').'>Bottom</option>';
                                        $out .= '</select>';
                                        
                                        
                                        $out .= '<span class="dc-cms-control-top-label">Background X position in pixels</span>';
                                        $out .= $this->getCtrlInputInt('bg_pos_x_px', $this->_general['bg_pos_x_px']);                        
          
                                        $out .= '<span class="dc-cms-control-top-label">Background Y position in pixels</span>';
                                        $out .= $this->getCtrlInputInt('bg_pos_y_px', $this->_general['bg_pos_y_px']);
                                           
                                                       
                                $out .= $this->getStdColumnEnd();                                
                            
                                $out .= $this->getStdColumnStart(array('width'=>150));
                                    $out .= '<span class="dc-cms-control-top-label-nomargin">Attachment mode</span>';
                                    $out .= $this->getStdInputsFieldStart();
                                        $out .= '<input type="radio" name="bg_attachment" '.$this->attrChecked($this->_general['bg_attachment'] == 'scroll').' value="scroll" /> Scroll';
                                        $out .= $this->getBR();
                                        $out .= '<input type="radio" name="bg_attachment" '.$this->attrChecked($this->_general['bg_attachment'] == 'fixed').' value="fixed" /> Fixed<br />';      

                                        $out .= '<span class="dc-cms-control-top-label">Background color</span>';
                                        $out .= '<input type="text" class="dc-color-picker" value="'.$this->_general['bg_color'].'" name="bg_color" />';                                                             

                                    $out .= $this->getStdInputsFieldEnd();                                  
                                $out .= $this->getStdColumnEnd();                    
             
                                $out .= $this->getStdColumnStart(array('width'=>150));
                                    $out .= '<span class="dc-cms-control-top-label-nomargin">Repeat mode</span>';
                                    $out .= $this->getStdInputsFieldStart();   
                                        $out .= '<input type="radio" '.$this->attrChecked($this->_general['bg_repeat'] == 'repeat').' value="repeat" name="bg_repeat" /> Repeat';
                                        $out .= $this->getBR();         
                                        $out .= '<input type="radio" '.$this->attrChecked($this->_general['bg_repeat'] == 'repeat-x').' value="repeat-x" name="bg_repeat" /> Repeat X';
                                        $out .= $this->getBR();
                                        $out .= '<input type="radio" '.$this->attrChecked($this->_general['bg_repeat'] == 'repeat-y').' value="repeat-y" name="bg_repeat" /> Repeat Y';
                                        $out .= $this->getBR();
                                        $out .= '<input type="radio" '.$this->attrChecked($this->_general['bg_repeat'] == 'no-repeat').' value="no-repeat" name="bg_repeat" /> No repeat';    
                                    $out .= $this->getStdInputsFieldEnd();
                                $out .= $this->getStdColumnEnd();                          
                                
                                $out .= $this->getClearBoth();                   
                            $out .= $this->getStdWrapperEnd();
                              
                            $out .= '<span class="dc-cms-control-top-label">Other settings</span>';
                            $out .= $this->getStdInputsFieldStart();                                              
                                $out .= '<input type="checkbox" name="bg_pos_x_px_use" '.$this->attrChecked($this->_general['bg_pos_x_px_use']).' /> Use pixels X position';
                                $out .= $this->getBR(); 
                                $out .= '<input type="checkbox" name="bg_pos_y_px_use" '.$this->attrChecked($this->_general['bg_pos_y_px_use']).' /> Use pixels Y position';                    
                            $out .= $this->getStdInputsFieldEnd();                        
                        
                        $out .= '</td></tr>';                           
                        
                        $out .= '</tbody>';
                    $out .= '</table>';                         
                    
                    // blog short
                    $out .= $this->getPanelSectionHead('Blog short post settings (blog page, archive pages)', 50);                                          
                    $out .= '<table class="dc-cms-table-standard">';                           
                        $out .= '<tbody>';
                    
                        $out .= '<tr><td><span class="dc-cms-left-marked-title">Post short (e.g on blog page) information bar settings</span></td><td>';
                                                  
                            $out .= '<span class="dc-cms-control-top-label-nomargin">Post time format</span>';
                            $out .= '<input class="dc-cms-control-200" type="text" name="blog_infobar_date_format" value="'.$this->_general['blog_infobar_date_format'].'" />';
                            $out .= $this->getNoteStart(array('type'=>'inline'));
                                $out .= '<a href="http://codex.wordpress.org/Formatting_Date_and_Time">More about time formatting</a>';
                            $out .= $this->getNoteEnd();
                            $out .= $this->getBR();
                            
                            $out .= $this->getStdInputsFieldStart(array('mtop-type'=>'small'));
                                $out .= '<input type="checkbox" name="blog_infobar_date_display" '.$this->attrChecked($this->_general['blog_infobar_date_display']).' /> Show post date';                                                       
                            $out .= $this->getStdInputsFieldEnd();                                      
                                
                            $out .= $this->getNoteStart(array('type'=>'box'));
                                $out .= 'Current time formated with above format: <strong>'.date($this->_general['blog_infobar_date_format']).'</strong>';
                            $out .= $this->getNoteEnd();                                    
                                
                            $out .= $this->getStdInputsFieldStart(array('mtop-type'=>'small')); 
                                $out .= '<input type="checkbox" name="blog_infobar_author_display" '.$this->attrChecked($this->_general['blog_infobar_author_display']).' /> Show post author name';
                                $out .= $this->getBR();    
                                $out .= '<input type="checkbox" name="blog_infobar_categories_display" '.$this->attrChecked($this->_general['blog_infobar_categories_display']).' /> Show post categories';
                                $out .= $this->getBR(); 
                                $out .= '<input type="checkbox" name="blog_infobar_comments_display" '.$this->attrChecked($this->_general['blog_infobar_comments_display']).' /> Show post comments count';
                                $out .= $this->getBR();                                                                                
                                $out .= '<input type="checkbox" name="blog_infobar_tags_display" '.$this->attrChecked($this->_general['blog_infobar_tags_display']).' /> Show post tags';
                                $out .= $this->getBR(); 
                            $out .= $this->getStdInputsFieldEnd();                                                                
                        
                        $out .= '</td></tr>';      
                        
                        $out .= '<tr><td><span class="dc-cms-left-marked-title">Post short (e.g on blog page) other settings</span></td><td>';                                                                                 
                                
                            $out .= $this->getStdInputsFieldStart(array('mtop-type'=>'none')); 
                                $out .= '<input type="checkbox" name="blog_date_under_title_display" '.$this->attrChecked($this->_general['blog_date_under_title_display']).' /> Show date under post titlte';
                                $out .= $this->getBR();    
                            $out .= $this->getStdInputsFieldEnd();                                                                
                        
                        $out .= '</td></tr>'; 
                        
                        $out .= '</tbody>';
                    $out .= '</table>';                                                                                                                                                     
                                       
                    // blog full
                    $out .= $this->getPanelSectionHead('Blog full post settings (single page)', 50);                                          
                    $out .= '<table class="dc-cms-table-standard">';                           
                        $out .= '<tbody>';                                       
                                                                       
                        $out .= '<tr><td><span class="dc-cms-left-marked-title">Post full (single page) about post author</span></td><td>';   

                            $out .= $this->getStdInputsFieldStart(); 
                                $out .= '<input type="checkbox" name="blog_full_about_user_display" '.$this->attrChecked($this->_general['blog_full_about_user_display']).' /> Display information about post author';
                                $out .= $this->getBR();    
                                $out .= '<input type="checkbox" name="blog_full_about_extra_users_display" '.$this->attrChecked($this->_general['blog_full_about_extra_users_display']).' /> Display information about additional authors';
                            $out .= $this->getStdInputsFieldEnd();                                                                                       
                        
                        $out .= '</td></tr>';  
                        
                        $out .= '<tr><td><span class="dc-cms-left-marked-title">Post full (single page) related posts</span></td><td>';
                        
                            $out .= '<span class="dc-cms-control-top-label-nomargin">Number of displayed posts</span>';
                            $out .= $this->getCtrlInputInt('blog_related_count', $this->_general['blog_related_count'], 1);
                                 
                            $out .= '<span class="dc-cms-control-top-label">Taxonomy</span>';
                            $out .= '<select name="blog_related_taxonomy">';
                                $out .= '<option value="post_tag" '.$this->attrSelected($this->_general['blog_related_taxonomy'] == 'post_tag').'>Post tag</option>';
                                $out .= '<option value="category" '.$this->attrSelected($this->_general['blog_related_taxonomy'] == 'category').'>Post category</option>'; 
                            $out .= '</select>';
                        
                            $out .= $this->getStdInputsFieldStart(array('mtop-type' => 'small'));
                                $out .= '<input type="checkbox" name="blog_related_display" '.$this->attrChecked($this->_general['blog_related_display']).' /> Display related posts';                                                         
                            $out .= $this->getStdInputsFieldEnd();
                            
                        $out .= '</td></tr>';
                           
                        $out .= '<tr><td><span class="dc-cms-left-marked-title">Post full (single page) information bar settings</span></td><td>';
                                                  
                            $out .= '<span class="dc-cms-control-top-label-nomargin">Post time format</span>';
                            $out .= '<input class="dc-cms-control-200" type="text" name="blog_full_ib_date_format" value="'.$this->_general['blog_full_ib_date_format'].'" />';
                            $out .= $this->getNoteStart(array('type'=>'inline'));
                                $out .= '<a href="http://codex.wordpress.org/Formatting_Date_and_Time">More about time formatting</a>';
                            $out .= $this->getNoteEnd();
                            $out .= $this->getBR();
                            
                            $out .= $this->getStdInputsFieldStart(array('mtop-type'=>'small'));
                                $out .= '<input type="checkbox" name="blog_full_ib_date_display" '.$this->attrChecked($this->_general['blog_full_ib_date_display']).' /> Show post date';                                                       
                            $out .= $this->getStdInputsFieldEnd();                                      
                                
                            $out .= $this->getNoteStart(array('type'=>'box'));
                                $out .= 'Current time formated with above format: <strong>'.date($this->_general['blog_full_ib_date_format']).'</strong>';
                            $out .= $this->getNoteEnd();                                    
                                
                            $out .= $this->getStdInputsFieldStart(array('mtop-type'=>'small')); 
                                $out .= '<input type="checkbox" name="blog_full_ib_author_display" '.$this->attrChecked($this->_general['blog_full_ib_author_display']).' /> Show post author name';
                                $out .= $this->getBR();    
                                $out .= '<input type="checkbox" name="blog_full_ib_categories_display" '.$this->attrChecked($this->_general['blog_full_ib_categories_display']).' /> Show post categories';
                                $out .= $this->getBR(); 
                                $out .= '<input type="checkbox" name="blog_full_ib_comments_display" '.$this->attrChecked($this->_general['blog_full_ib_comments_display']).' /> Show post comments count';
                                $out .= $this->getBR();                                                                                
                                $out .= '<input type="checkbox" name="blog_full_ib_tags_display" '.$this->attrChecked($this->_general['blog_full_ib_tags_display']).' /> Show post tags';
                                $out .= $this->getBR(); 
                            $out .= $this->getStdInputsFieldEnd();                                                                
                        
                        $out .= '</td></tr>';                                     
                        
                        $out .= '<tr><td><span class="dc-cms-left-marked-title">Post full (single page) other settings</span></td><td>';                                                                                 
                                
                            $out .= $this->getStdInputsFieldStart(array('mtop-type'=>'none')); 
                                $out .= '<input type="checkbox" name="blog_full_date_under_title_display" '.$this->attrChecked($this->_general['blog_full_date_under_title_display']).' /> Show date under post titlte';
                                $out .= $this->getBR();    
                            $out .= $this->getStdInputsFieldEnd();                                                                
                        
                        $out .= '</td></tr>';                         
                                                       
                        $out .= '</tbody>';
                    $out .= '</table>'; 
                    
                    // project
                    $out .= $this->getPanelSectionHead('Projects settings', 50);                                          
                    $out .= '<table class="dc-cms-table-standard">';                           
                        $out .= '<tbody>';
                    
                        $out .= '<tr><td><span class="dc-cms-left-marked-title">Project (single page and short) information bar settings</span></td><td>';
                                                  
                            $out .= '<span class="dc-cms-control-top-label-nomargin">Project time format</span>';
                            $out .= '<input class="dc-cms-control-200" type="text" name="project_infobar_date_format" value="'.$this->_general['project_infobar_date_format'].'" />';
                            $out .= $this->getNoteStart(array('type'=>'inline'));
                                $out .= '<a href="http://codex.wordpress.org/Formatting_Date_and_Time">More about time formatting</a>';
                            $out .= $this->getNoteEnd();
                            $out .= $this->getBR();
                            
                            $out .= $this->getStdInputsFieldStart(array('mtop-type'=>'small'));
                                $out .= '<input type="checkbox" name="project_infobar_date_display" '.$this->attrChecked($this->_general['project_infobar_date_display']).' /> Show project date';                                                       
                            $out .= $this->getStdInputsFieldEnd();                                      
                                
                            $out .= $this->getNoteStart(array('type'=>'box'));
                                $out .= 'Current time formated with above format: <strong>'.date($this->_general['project_infobar_date_format']).'</strong>';
                            $out .= $this->getNoteEnd();                                    
                                
                            $out .= $this->getStdInputsFieldStart(array('mtop-type'=>'small')); 
                                $out .= '<input type="checkbox" name="project_infobar_client_display" '.$this->attrChecked($this->_general['project_infobar_client_display']).' /> Show project client name';
                                $out .= $this->getBR();                            
                                $out .= '<input type="checkbox" name="project_infobar_website_display" '.$this->attrChecked($this->_general['project_infobar_website_display']).' /> Show project website';
                                $out .= $this->getBR();
                                $out .= '<input type="checkbox" name="project_infobar_skills_display" '.$this->attrChecked($this->_general['project_infobar_skills_display']).' /> Show author skills used in project';
                                $out .= $this->getBR();
                                $out .= '<input type="checkbox" name="project_infobar_author_display" '.$this->attrChecked($this->_general['project_infobar_author_display']).' /> Show project author name';
                                $out .= $this->getBR();    
                                $out .= '<input type="checkbox" name="project_infobar_categories_display" '.$this->attrChecked($this->_general['project_infobar_categories_display']).' /> Show project categories';
                                $out .= $this->getBR(); 
                                $out .= '<input type="checkbox" name="project_infobar_comments_display" '.$this->attrChecked($this->_general['project_infobar_comments_display']).' /> Show project comments count';
                                $out .= $this->getBR();                                                                                 
                            $out .= $this->getStdInputsFieldEnd();                                                                
                                               
                            $out .= $this->getStdInputsFieldStart(array('mtop'=>20));
                                $out .= '<input type="checkbox" name="project_single_posted_date" '.$this->attrChecked($this->_general['project_single_posted_date']).' /> Display posted date located under project title';
                                $out .= $this->getBR();                         
                            $out .= $this->getStdInputsFieldEnd();                                                 
                                                                     
                        $out .= '</td></tr>';                                                                                                        
                                               
                        
                        $out .= '<tr><td><span class="dc-cms-left-marked-title">Project category page layout</span></td><td>';    
                        
                            $out .= '<span class="dc-cms-control-top-label-nomargin">Select category page layout</span>';                    
                            $out .= '<div class="dc-cms-page-layout-box">';
                            
                                $out .= '<div class="item">';
                                    $out .= '<div class="layout-image-both-sidebars">Both sidebars</div>';                    
                                    $out .= '<input type="radio" name="project_layout_category_page" '.$this->attrChecked($this->_general['project_layout_category_page'] == CMS_PAGE_LAYOUT_BOTH_SIDEBARS).' value="'.CMS_PAGE_LAYOUT_BOTH_SIDEBARS.'" />';
                                $out .= '</div>';  
                                
                                $out .= '<div class="item">';
                                    $out .= '<div class="layout-image-left-sidebar">Left sidebar</div>';                    
                                    $out .= '<input type="radio" name="project_layout_category_page" '.$this->attrChecked($this->_general['project_layout_category_page'] == CMS_PAGE_LAYOUT_LEFT_SIDEBAR).' value="'.CMS_PAGE_LAYOUT_LEFT_SIDEBAR.'" />';
                                $out .= '</div>';                                             

                                $out .= '<div class="item">';
                                    $out .= '<div class="layout-image-right-sidebar">Right sidebar</div>';                    
                                    $out .= '<input type="radio" name="project_layout_category_page" '.$this->attrChecked($this->_general['project_layout_category_page'] == CMS_PAGE_LAYOUT_RIGHT_SIDEBAR).' value="'.CMS_PAGE_LAYOUT_RIGHT_SIDEBAR.'" />';
                                $out .= '</div>'; 
                                
                                $out .= '<div class="item">';
                                    $out .= '<div class="layout-image-full-width">Full width</div>';                    
                                    $out .= '<input type="radio" name="project_layout_category_page" '.$this->attrChecked($this->_general['project_layout_category_page'] == CMS_PAGE_LAYOUT_FULL_WIDTH).' value="'.CMS_PAGE_LAYOUT_FULL_WIDTH.'" />';
                                $out .= '</div>';                         
                                
                                $out .= $this->getClearBoth();                                                                
                                        
                            $out .= '</div>';                                                                      
                                         
                        $out .= '</td></tr>';                                                
                        
                        $out .= '<tr><td><span class="dc-cms-left-marked-title">Default project category sidebars</span></td><td>';
                        
                            $out .= '<span class="dc-cms-control-top-label-nomargin">Project category global default left sidebar</span>'; 
                            $out .= $this->selectCtrlSidebarsList($this->_general['project_sid_default_cats_left'], 'project_sid_default_cats_left');
                              
                            $out .= '<span class="dc-cms-control-top-label">Project category global default right sidebar</span>'; 
                            $out .= $this->selectCtrlSidebarsList($this->_general['project_sid_default_cats_right'], 'project_sid_default_cats_right');                            
                        
                        $out .= '</td></tr>';  
                        
                        $out .= '<tr><td><span class="dc-cms-left-marked-title">Other project category page settings</span></td><td>'; 
                        
                            $out .= '<span class="dc-cms-control-top-label-nomargin">Projects per page</span>';
                            $out .= $this->getCtrlInputInt('project_category_per_page', $this->_general['project_category_per_page'], 1);  
                            
                            $out .= '<span class="dc-cms-control-top-label">Columns on page</span>';
                            $out .= '<select class="dc-cms-control-120" name="project_category_columns">';
                                $out .= '<option value="1" '.self::attrSelected($this->_general['project_category_columns'] == 1).'>1</option>';
                                $out .= '<option value="2" '.self::attrSelected($this->_general['project_category_columns'] == 2).'>2</option>';
                                $out .= '<option value="3" '.self::attrSelected($this->_general['project_category_columns'] == 3).'>3</option>';
                                $out .= '<option value="4" '.self::attrSelected($this->_general['project_category_columns'] == 4).'>4</option>';
                            $out .= '</select>';                            
                            
                            $out .= '<span class="dc-cms-control-top-label">Order</span>';
                            $out .= '<select class="dc-cms-control-120" name="project_category_order">';
                                $out .= '<option value="ASC" '.self::attrSelected($this->_general['project_category_order'] == 'ASC').'>ASC</option>';
                                $out .= '<option value="DESC" '.self::attrSelected($this->_general['project_category_order'] == 'DESC').'>DESC</option>';
                            $out .= '</select>';  
                            
                            $out .= '<span class="dc-cms-control-top-label">Order by</span>';
                            $out .= '<select class="dc-cms-control-120" name="project_category_orderby">';
                                $out .= '<option value="date" '.self::attrSelected($this->_general['project_category_orderby'] == 'date').'>Date</option>';
                                $out .= '<option value="title" '.self::attrSelected($this->_general['project_category_orderby'] == 'title').'>Title</option>';
                                $out .= '<option value="comment_count" '.self::attrSelected($this->_general['project_category_orderby'] == 'comment_count').'>Comments count</option>';
                            $out .= '</select>';                               
                             
                            $out .= '<span class="dc-cms-control-top-label">Words in excerpt</span>';
                            $out .= $this->getCtrlInputInt('project_category_words', $this->_general['project_category_words'], 1);                               
                             
                            $out .= '<span class="dc-cms-control-top-label">Viewport width</span>';
                            $out .= $this->getCtrlInputInt('project_category_viewport_w', $this->_general['project_category_viewport_w'], 1);                               

                            $out .= '<span class="dc-cms-control-top-label">Viewport height</span>';
                            $out .= $this->getCtrlInputInt('project_category_viewport_h', $this->_general['project_category_viewport_h'], 1);  
                             
                            $out .= $this->getStdInputsFieldStart(array('mtop-type'=>'normal'));
                                $out .= '<input type="checkbox" name="project_category_excerpt" '.$this->attrChecked($this->_general['project_category_excerpt']).' /> Display project excerpt';        
                                $out .= $this->getBR();
                                $out .= '<input type="checkbox" name="project_category_viewport_use" '.$this->attrChecked($this->_general['project_category_viewport_use']).' /> Use viewport';                                                 
                            $out .= $this->getStdInputsFieldEnd();                               
                             
                        $out .= '</td></tr>';
                        
                        $out .= '</tbody>';
                    $out .= '</table>';                     
                    
                    // comments
                    $out .= $this->getPanelSectionHead('Comments settings', 50);                                          
                    $out .= '<table class="dc-cms-table-standard">';   
                        $out .= '<tbody>';    
                        
                        $out .= '<tr><td>Adjust some comments settings to your needs</td><td>';

                            $out .= '<span class="dc-cms-control-top-label-nomargin">Comments display</span>';
                            $out .= $this->getStdInputsFieldStart(); 
                                $out .= '<input type="checkbox" name="comments_in_posts_display" '.$this->attrChecked($this->_general['comments_in_posts_display']).' /> Show comment in posts';
                                $out .= $this->getBR(); 
                                $out .= '<input type="checkbox" name="comments_in_pages_display" '.$this->attrChecked($this->_general['comments_in_pages_display']).' /> Show comment in pages';
                                $out .= $this->getBR();
                                $out .= '<input type="checkbox" name="comments_reverse_children" '.$this->attrChecked($this->_general['comments_reverse_children']).' /> Reverse children (display the children - reply level comments - with the most recent ones first, then going back in order)'; 
                                
                                                              
                           $out .= $this->getStdInputsFieldEnd();
                        
                        
                            $out .= '<span class="dc-cms-control-top-label">Comment time format</span>';
                            $out .= '<input class="dc-cms-control-200" type="text" name="comments_time_format" value="'.$this->_general['comments_time_format'].'" />';
                            $out .= $this->getNoteStart(array('type'=>'inline'));
                                $out .= '<a href="http://codex.wordpress.org/Formatting_Date_and_Time">More about time formatting</a>';
                            $out .= $this->getNoteEnd();
                            $out .= $this->getBR();
                            
                            $out .= $this->getStdInputsFieldStart(array('mtop-type'=>'small'));
                                $out .= '<input type="checkbox" name="comments_time_display" '.$this->attrChecked($this->_general['comments_time_display']).' /> Show comment time';                                                       
                            $out .= $this->getStdInputsFieldEnd();  
                                                 
                            $out .= $this->getNoteStart(array('type'=>'box'));
                                $out .= 'Current time formated with above format: <strong>'.date($this->_general['comments_time_format']).'</strong>';
                            $out .= $this->getNoteEnd();
                           
                            $out .= $this->getStdInputsFieldStart(array('mtop-type'=>'small')); 
                                $out .= '<input type="checkbox" name="comments_author_display" '.$this->attrChecked($this->_general['comments_author_display']).' /> Show comment author name';
                                $out .= $this->getBR(); 
                                $out .= '<input type="checkbox" name="comments_author_url_display" '.$this->attrChecked($this->_general['comments_author_url_display']).' /> Show comment author URL';
                                $out .= $this->getBR();                                                                     
                                $out .= '<input type="checkbox" name="comments_mark_author" '.$this->attrChecked($this->_general['comments_mark_author']).' /> Mark comments posted by post author';                                     
                                $out .= $this->getBR();
                                $out .= '<input type="checkbox" name="comments_url_field" '.$this->attrChecked($this->_general['comments_url_field']).' /> Display author Website/URL field in comment form';                                     
                                $out .= $this->getBR();
                                $out .= '<input type="checkbox" name="comments_time_ago_display" '.$this->attrChecked($this->_general['comments_time_ago_display']).' /> Display how long ago comment was posted'; 
                                $out .= $this->getBR();
                                $out .= '<input type="checkbox" name="comments_avatar_display" '.$this->attrChecked($this->_general['comments_avatar_display']).' /> Display comment avatar';      
                            $out .= $this->getStdInputsFieldEnd();  
                                 
                            $out .= '<span class="dc-cms-control-top-label">Default comment avatart image URL</span>'; 
                            $out .= '<input type="text" class="dc-cms-control-600" name="comments_def_avatar" value="'.$this->_general['comments_def_avatar'].'" id="dc_id_comments_def_avatar" /> ';
                            $out .= '<div class="dc-cms-btn-frame">';
                                $out .= '<input class="dc-cms-submit-image-btn" type="submit" name="dc_id_comments_def_avatar" value="'.__('Load image', CMS_TXT_DOMAIN).'"> ';  
                            $out .= '</div>';                                                  
                                       
                            $out .= $this->getImagePreviewBox(array('path' => $this->_general['comments_def_avatar'], 'width' => 60, 'height' => 60));                                    
     
                        $out .= '</td></tr>';                         
                    
                        $out .= '</tbody>';
                    $out .= '</table>';
                                            
                    // breadcrumb
                    $out .= $this->getPanelSectionHead('Breadcrumb navigation settings', 50);                                          
                    $out .= '<table class="dc-cms-table-standard">';   
                        $out .= '<tbody>';
                    
                        $out .= '<tr><td>Adjust breadcrumb settings to your needs</td><td>';
                        
                            $out .= '<div class="dc-cms-inputs-field-nomargin">';
                                $out .= '<span class="dc-cms-control-top-label-nomargin">Blog name</span>';
                                $out .= '<input class="dc-cms-control-200" type="text" name="breadcrumb_blog_name" value="'.$this->_general['breadcrumb_blog_name'].'" />';                                
                                $out .= '<br />';

                                $out .= '<span class="dc-cms-control-top-label">Text displayed before navigation path</span>';
                                $out .= '<input class="dc-cms-control-200" type="text" name="breadcrumb_before" value="'.$this->_general['breadcrumb_before'].'" />';                                
                                                                    
                                $out .= '<div class="dc-cms-inputs-field-smargin">';
                                    $out .= '<input type="checkbox" name="breadcrumb_display" '.$this->attrChecked($this->_general['breadcrumb_display']).' /> Display breadcrumb navigation';                                                                                 
                                    $out .= $this->getBR();
                                    $out .= '<input type="checkbox" name="breadcrumb_before_display" '.$this->attrChecked($this->_general['breadcrumb_before_display']).' /> Display before text'; 
                                    $out .= $this->getBR();
                                    $out .= '<input type="checkbox" name="breadcrumb_blog_name_display" '.$this->attrChecked($this->_general['breadcrumb_blog_name_display']).' /> Display blog name';
                                    $out .= $this->getBR();
                                    $out .= '<input type="checkbox" name="breadcrumb_blog_name_force" '.$this->attrChecked($this->_general['breadcrumb_blog_name_force']).' /> Force alternative blog name';
                                $out .= '</dov>';
                            $out .= '</div>';
                            
                        $out .= '</td></tr>';                         
                    
                        $out .= '</tbody>';
                    $out .= '</table>';                        
                                      
                    $out .= $this->getSubmitBottomPanel('dc-general-save-core-opt');
                $out .= '</form>';

            $out .= $this->getPanelEnd();             
        }        
        
        if($echo) { echo $out; } else { return $out; }
    }    

    public function renderFooterCMS($echo=false)
    {
        $out = ''; 
    
        if($this->isSubPage('dc-subpage-footer-opt'))
        {            
            $out .= $this->getPanelBegin('Theme footer settings');
            
                $out .= '<form action="#" method="post">';
             
                    $out .= '<div class="dc-cms-submit-panel-top">';
                        $out .= '<input class="dc-cms-submit-btn-primary" type="submit" name="dc-general-save-footer-opt" value="Save changes"> ';                            
                        $out .= $this->getPanelProcessInfo();                            
                    $out .= '</div>';                 
             
                    $out .= $this->getPanelSectionHead('Footer core settings'); 
            
                    $out .= '<table class="dc-cms-table-standard">'; 
                        $out .= '<tbody>';    
                        
                                     
                        // core                                                                                              
                        $out .= '<tr><td><span class="dc-cms-left-marked-title">Core</span></td><td>'; 
                                                                                                      
                            $out .= $this->getStdInputsFieldStart();
                                $out .= '<input type="checkbox" name="footer_display" '.$this->attrChecked($this->_general['footer_display']).' /> Display footer sidebars';   
                                $out .= $this->getBR();
                                $out .= '<input type="checkbox" name="footer_before_display" '.$this->attrChecked($this->_general['footer_before_display']).' /> Display extra content before footer'; 
                                $out .= $this->getBR();
                                $out .= '<input type="checkbox" name="footer_after_display" '.$this->attrChecked($this->_general['footer_after_display']).' /> Display extra content after footer';
                            $out .= $this->getStdInputsFieldEnd();

                            $out .= $this->getStdInputsFieldStart(array('mtop-type' => 'normal'));
                                $out .= '<input type="checkbox" name="footer_before_autoformat" '.$this->attrChecked($this->_general['footer_before_autoformat']).' /> Enable autoformating for before footer content'; 
                                $out .= $this->getBR();
                                $out .= '<input type="checkbox" name="footer_after_autoformat" '.$this->attrChecked($this->_general['footer_after_autoformat']).' /> Enable autoformating for after footer content';
                            $out .= $this->getStdInputsFieldEnd();
                                                 
                            $out .= $this->getStdInputsFieldStart(array('mtop-type' => 'normal'));
                                $out .= '<input type="checkbox" name="footer_logo_display" '.$this->attrChecked($this->_general['footer_logo_display']).' /> Display footer logo'; 
                                $out .= $this->getBR();
                                $out .= '<input type="checkbox" name="footer_copyright_display" '.$this->attrChecked($this->_general['footer_copyright_display']).' /> Display copyright text';
                            $out .= $this->getStdInputsFieldEnd();
                                   
                        $out .= '</td></tr>';                   

                        // sidebars                                                                                              
                        $out .= '<tr><td><span class="dc-cms-left-marked-title">Footer sidebars</span></td><td>';
                            $out .= '<span class="dc-cms-control-top-label-nomargin">Select sidebar for first footer column</span>';                                                                                
                            $out .= $this->selectCtrlSidebarsList($this->_general['footer_sid_1'], 'footer_sid_1');        

                            $out .= '<span class="dc-cms-control-top-label">Select sidebar for second footer column</span>';                                                                                
                            $out .= $this->selectCtrlSidebarsList($this->_general['footer_sid_2'], 'footer_sid_2');

                            $out .= '<span class="dc-cms-control-top-label">Select sidebar for third footer column</span>';                                                                                
                            $out .= $this->selectCtrlSidebarsList($this->_general['footer_sid_3'], 'footer_sid_3');

                            $out .= '<span class="dc-cms-control-top-label">Select sidebar for fourth footer column</span>';                                                                                
                            $out .= $this->selectCtrlSidebarsList($this->_general['footer_sid_4'], 'footer_sid_4');
                        $out .= '</td></tr>';                   
                        
                        $out .= '</tbody>';
                    $out .= '</table>';                             
                        
                    $out .= $this->getPanelSectionHead('Footer layout settings', 50); 
            
                    $out .= '<table class="dc-cms-table-standard">'; 
                        $out .= '<tbody>';                            
                        
                        // layout
                        $out .= '<tr><td><span class="dc-cms-left-marked-title">Footer layout</span></td><td>';
                            $out .= '<div class="dc-cms-footer-layout-2-columns">';
                                $out .= '<input type="radio" name="footer_layout" value="'.self::FOOTER_LAYOUT_2_COLS.'" '.$this->attrChecked($this->_general['footer_layout'] == self::FOOTER_LAYOUT_2_COLS).' /> 2 columns';
                            $out .= '</div>';                            
                 
                            $out .= '<div class="dc-cms-footer-layout-2-columns-left-small">';
                                $out .= '<input type="radio" name="footer_layout" value="'.self::FOOTER_LAYOUT_2_COLS_LEFT_SMALL.'" '.$this->attrChecked($this->_general['footer_layout'] == self::FOOTER_LAYOUT_2_COLS_LEFT_SMALL).' /> 2 columns';
                            $out .= '</div>';                    
                            
                            $out .= '<div class="dc-cms-footer-layout-2-columns-right-small">';
                                $out .= '<input type="radio" name="footer_layout" value="'.self::FOOTER_LAYOUT_2_COLS_RIGHT_SMALL.'" '.$this->attrChecked($this->_general['footer_layout'] == self::FOOTER_LAYOUT_2_COLS_RIGHT_SMALL).' /> 2 columns';
                            $out .= '</div>';                               

                            $out .= '<div class="dc-cms-footer-layout-3-columns">';
                                $out .= '<input type="radio" name="footer_layout" value="'.self::FOOTER_LAYOUT_3_COLS.'" '.$this->attrChecked($this->_general['footer_layout'] == self::FOOTER_LAYOUT_3_COLS).' /> 3 columns';
                            $out .= '</div>';                                                
                            
                            $out .= '<div class="dc-cms-footer-layout-3-columns-left-big">';
                                $out .= '<input type="radio" name="footer_layout" value="'.self::FOOTER_LAYOUT_3_COLS_LEFT_BIG.'" '.$this->attrChecked($this->_general['footer_layout'] == self::FOOTER_LAYOUT_3_COLS_LEFT_BIG).' /> 3 columns';
                            $out .= '</div>';                    
                            
                            $out .= '<div class="dc-cms-footer-layout-3-columns-right-big">';
                                $out .= '<input type="radio" name="footer_layout" value="'.self::FOOTER_LAYOUT_3_COLS_RIGHT_BIG.'" '.$this->attrChecked($this->_general['footer_layout'] == self::FOOTER_LAYOUT_3_COLS_RIGHT_BIG).' /> 3 columns';
                            $out .= '</div>';                              
                            
                            $out .= '<div class="dc-cms-footer-layout-4-columns">';
                                $out .= '<input type="radio" name="footer_layout" value="'.self::FOOTER_LAYOUT_4_COLS.'" '.$this->attrChecked($this->_general['footer_layout'] == self::FOOTER_LAYOUT_4_COLS).' /> 4 columns';
                            $out .= '</div>';
                                                        
                        $out .= '</td></tr>';
                        
                        $out .= '</tbody>';
                    $out .= '</table>';                          
                        
                    $out .= $this->getPanelSectionHead('Before and after footer content settings', 50); 
            
                    $out .= '<table class="dc-cms-table-standard">'; 
                        $out .= '<tbody>';                           
                        
                        // before footer                                                                                              
                        $out .= '<tr><td><span class="dc-cms-left-marked-title">Before footer</span></td><td>';
                            $out .= '<span class="dc-cms-control-top-label-nomargin">Optional content displayed before footer columns (shortcodes allowed)</span>';  
                            $out .= $this->getTextAreaShortCodeWrapperStart();                             
                                $out .= '<textarea name="footer_before" class="dc-cms-control-textarea dc-cms-control-600 dc-cms-control-h-200">'.$this->_general['footer_before'].'</textarea>';
                            $out .= $this->getTextAreaShortCodeWrapperEnd();
                        $out .= '</td></tr>';                           

                        // after footer                                                                                              
                        $out .= '<tr><td><span class="dc-cms-left-marked-title">After footer</span></td><td>';
                            $out .= '<span class="dc-cms-control-top-label-nomargin">Optional content displayed after footer columns (shortcodes allowed)</span>';
                            $out .= $this->getTextAreaShortCodeWrapperStart();                               
                                $out .= '<textarea name="footer_after" class="dc-cms-control-textarea dc-cms-control-600 dc-cms-control-h-200">'.$this->_general['footer_after'].'</textarea>';
                            $out .= $this->getTextAreaShortCodeWrapperEnd();
                        $out .= '</td></tr>';  

                        $out .= '</tbody>';
                    $out .= '</table>';                           

                    $out .= $this->getPanelSectionHead('Footer logo', 50); 
            
                    $out .= '<table class="dc-cms-table-standard">'; 
                        $out .= '<tbody>';                           
                        
                        
                        // footer logo
                        $out .= '<tr><td><span class="dc-cms-left-marked-title">Select image for footer logo</span></td><td>';
                        
                            $out .= '<input type="text" class="dc-cms-control-600" name="footer_logo" value="'.$this->_general['footer_logo'].'" id="dc_id_footer_logo" /> ';
                            $out .= '<div class="dc-cms-btn-frame">';
                                $out .= '<input class="dc-cms-submit-image-btn" type="submit" name="dc_id_footer_logo" value="Load image"> ';  
                            $out .= '</div>';
                            
                            $out .= $this->getImagePreviewBox(array('path' => $this->_general['footer_logo'], 'width' => 240, 'height' => 160, 'icon' => false)); 
                     
                            $out .= $this->getStdInputsFieldStart(array('mtop-type' => 'small'));
                                $out .= '<input type="checkbox" name="footer_logo_grayscale" '.$this->attrChecked($this->_general['footer_logo_grayscale']).' /> Display in grayscale'; 
                            $out .= $this->getStdInputsFieldEnd();                     
                     
                        $out .= '</td></tr>';  
                        

                        $out .= '<tr><td><span class="dc-cms-left-marked-title">Logo container padding</span></td><td>';
                        
                            $out .= '<span class="dc-cms-control-top-label-nomargin">Top padding</span>';                                
                            $args = array(
                                'name' => 'footer_logo_pt',
                                'value' => $this->_general['footer_logo_pt'],
                                'min' => 0,
                                'max' => 1000,
                                'disabled' => false,
                                'step' => 2);
                            $out .= $this->getCtrlInputIntArgs($args);                                  

                            $out .= '<span class="dc-cms-control-top-label">Bottom padding</span>';                                
                            $args = array(
                                'name' => 'footer_logo_pb',
                                'value' => $this->_general['footer_logo_pb'],
                                'min' => 0,
                                'max' => 1000,
                                'disabled' => false,
                                'step' => 2);
                            $out .= $this->getCtrlInputIntArgs($args);  
                        
                        $out .= '</td></tr>';

                        $out .= '<tr><td><span class="dc-cms-left-marked-title">Logo opacity</span></td><td>';
                        
                            $out .= '<span class="dc-cms-control-top-label-nomargin">Opacity (where zero value means fully transparent image)</span>';                                
                            $args = array(
                                'name' => 'footer_logo_opacity',
                                'value' => $this->_general['footer_logo_opacity'],
                                'min' => 0,
                                'max' => 100,
                                'disabled' => false,
                                'step' => null);
                            $out .= $this->getCtrlInputIntArgs($args);                                  
                        
                        $out .= '</td></tr>';

                        $out .= '<tr><td><span class="dc-cms-left-marked-title">Logo align</span></td><td>';
                        
                            $out .= '<span class="dc-cms-control-top-label-nomargin">Select logo align</span>';                                
                            $out .= '<select name="footer_logo_align" class="dc-cms-control-100">';
                                $out .= '<option value="left" '.$this->attrSelected($this->_general['footer_logo_align'] == 'left').'>Left</option>';
                                $out .= '<option value="center" '.$this->attrSelected($this->_general['footer_logo_align'] == 'center').'>Center</option>';
                                $out .= '<option value="right" '.$this->attrSelected($this->_general['footer_logo_align'] == 'right').'>Right</option>';
                            $out .= '</select>';                                
                        
                        $out .= '</td></tr>';
                                                                         
                        $out .= '</tbody>';
                    $out .= '</table>';                           
                        
                    $out .= $this->getPanelSectionHead('Footer copyright text', 50); 
                  
                    $out .= '<table class="dc-cms-table-standard">'; 
                        $out .= '<tbody>';                              
                        
                        // copyright text                                                                                              
                        $out .= '<tr><td><span class="dc-cms-left-marked-title">Copyright text</span></td><td>';
                            $out .= '<span class="dc-cms-control-top-label-nomargin">Optional copyright text</span>';                               
                            $out .= '<textarea name="footer_copyright" class="dc-cms-control-textarea dc-cms-control-600 dc-cms-control-h-200">'.$this->_general['footer_copyright'].'</textarea>';
                        $out .= '</td></tr>';                         
                                  
                        $out .= '<tr><td><span class="dc-cms-left-marked-title">Container padding</span></td><td>';
                        
                            $out .= '<span class="dc-cms-control-top-label-nomargin">Left padding</span>';                                
                            $args = array(
                                'name' => 'footer_copyright_pl',
                                'value' => $this->_general['footer_copyright_pl'],
                                'min' => 0,
                                'max' => 1000,
                                'disabled' => false,
                                'step' => 2);
                            $out .= $this->getCtrlInputIntArgs($args);                                  

                            $out .= '<span class="dc-cms-control-top-label">Right padding</span>';                                
                            $args = array(
                                'name' => 'footer_copyright_pr',
                                'value' => $this->_general['footer_copyright_pr'],
                                'min' => 0,
                                'max' => 1000,
                                'disabled' => false,
                                'step' => 2);
                            $out .= $this->getCtrlInputIntArgs($args);  
                        
                        $out .= '</td></tr>';                                  
                                   
                        $out .= '<tr><td><span class="dc-cms-left-marked-title">Copyright text align</span></td><td>';
                        
                            $out .= '<span class="dc-cms-control-top-label-nomargin">Select align</span>';                                
                            $out .= '<select name="footer_copyright_align" class="dc-cms-control-100">';
                                $out .= '<option value="left" '.$this->attrSelected($this->_general['footer_copyright_align'] == 'left').'>Left</option>';
                                $out .= '<option value="center" '.$this->attrSelected($this->_general['footer_copyright_align'] == 'center').'>Center</option>';
                                $out .= '<option value="right" '.$this->attrSelected($this->_general['footer_copyright_align'] == 'right').'>Right</option>';
                            $out .= '</select>';                                
                        
                        $out .= '</td></tr>';                                   
                                                                        
                        $out .= '</tbody>';
                    $out .= '</table>';                     
            
                    $out .= '<div class="dc-cms-submit-panel-bottom">';
                        $out .= '<input class="dc-cms-submit-btn-primary" type="submit" name="dc-general-save-footer-opt" value="Save changes"> ';
                    $out .= '</div>';
                $out .= '</form>';                           
                    
            $out .= $this->getPanelEnd();         
        
        }
        
        if($echo) { echo $out; } else { return $out; } 
    }    
    
    public function renderThemeFooter($echo=true)
    {
        $out = '';
        $display_before = $this->_general['footer_before_display'];
        $display = $this->_general['footer_display'];
        $display_after = $this->_general['footer_after_display'];
        $display_logo = $this->_general['footer_logo_display'];
        $logo_grayscale = $this->_general['footer_logo_grayscale'];
        $display_copyright = $this->_general['footer_copyright_display'];
        
        global $dc_post_type;
        global $dc_is_page;
        global $dc_page_common_opt;
        
        if($dc_is_page and ($dc_post_type == 'page') and $dc_page_common_opt !== false)
        {
            $display_before = ($display_before and $dc_page_common_opt['page_misc_footer_before_cbox']);
            $display_after = ($display_after and $dc_page_common_opt['page_misc_footer_after_cbox']);
            $display = ($display and $dc_page_common_opt['page_misc_footer_sidebars_cbox']);
            $display_logo = ($display_logo and $dc_page_common_opt['page_misc_footer_logo_cbox']);
            $display_copyright = ($display_copyright and $dc_page_common_opt['page_misc_footer_copyright_cbox']);    
        }      
        
        if($display_before or $display or $display_after or $display_logo or $display_copyright)
        {
            $out .= '<div class="dc-footer-wrapper">';

                if($display_before)
                {    
                    $out .= '<div class="footer-before-wrapper">';
                    
                        if($this->_general['footer_before_autoformat'])
                        {
                            $out .= apply_filters('the_content', $this->_general['footer_before']);    
                        } else
                        {
                            $out .= do_shortcode($this->_general['footer_before']);
                        }
                        
                    $out .= '</div>'; 
                }
            
                if($display)
                {                           
                    $out .= '<div class="footer-columns-wrapper">';
                   
                        switch($this->_general['footer_layout'])
                        {
                           case self::FOOTER_LAYOUT_2_COLS:
                           {
                                $out .= '<div class="dc-eight dc-columns">';
                                    $out .= $this->getSidebar(array('id' => $this->_general['footer_sid_1'], 'side' => CMS_SIDEBAR_LEFT), false);
                                $out .= '</div>';

                                $out .= '<div class="dc-eight dc-columns">';
                                    $out .= $this->getSidebar(array('id' => $this->_general['footer_sid_2'], 'side' => CMS_SIDEBAR_RIGHT), false);
                                $out .= '</div>';                               
                           } break;

                           case self::FOOTER_LAYOUT_2_COLS_LEFT_SMALL:
                           {
                                $out .= '<div class="dc-four dc-columns">';
                                    $out .= $this->getSidebar(array('id' => $this->_general['footer_sid_1'], 'side' => CMS_SIDEBAR_LEFT), false);
                                $out .= '</div>';

                                $out .= '<div class="dc-twelve dc-columns sid-pl0">';
                                    $out .= $this->getSidebar(array('id' => $this->_general['footer_sid_2'], 'side' => CMS_SIDEBAR_RIGHT), false);
                                $out .= '</div>';                                  
                           } break;
                          
                           case self::FOOTER_LAYOUT_2_COLS_RIGHT_SMALL:
                           {
                                $out .= '<div class="dc-twelve dc-columns sid-pr0">';
                                    $out .= $this->getSidebar(array('id' => $this->_general['footer_sid_1'], 'side' => CMS_SIDEBAR_LEFT), false);
                                $out .= '</div>';

                                $out .= '<div class="dc-four dc-columns">';
                                    $out .= $this->getSidebar(array('id' => $this->_general['footer_sid_2'], 'side' => CMS_SIDEBAR_RIGHT), false);
                                $out .= '</div>';                                  
                           } break;
                                                   
                           case self::FOOTER_LAYOUT_3_COLS:
                           {
                                $out .= '<div class="dc-one-third dc-columns">';
                                    $out .= $this->getSidebar(array('id' => $this->_general['footer_sid_1'], 'side' => CMS_SIDEBAR_LEFT), false);
                                $out .= '</div>';

                                $out .= '<div class="dc-one-third dc-columns sid-pr0">';
                                    $out .= $this->getSidebar(array('id' => $this->_general['footer_sid_2'], 'side' => CMS_SIDEBAR_LEFT), false);
                                $out .= '</div>';
                                
                                $out .= '<div class="dc-one-third dc-columns">';
                                    $out .= $this->getSidebar(array('id' => $this->_general['footer_sid_3'], 'side' => CMS_SIDEBAR_RIGHT), false);
                                $out .= '</div>';                                 
                           } break;
                           
                           case self::FOOTER_LAYOUT_3_COLS_LEFT_BIG:
                           {
                                $out .= '<div class="dc-eight dc-columns">';
                                    $out .= $this->getSidebar(array('id' => $this->_general['footer_sid_1'], 'side' => CMS_SIDEBAR_LEFT), false);
                                $out .= '</div>';

                                $out .= '<div class="dc-four dc-columns sid-pr0">';
                                    $out .= $this->getSidebar(array('id' => $this->_general['footer_sid_2'], 'side' => CMS_SIDEBAR_LEFT), false);
                                $out .= '</div>';
                                
                                $out .= '<div class="dc-four dc-columns">';
                                    $out .= $this->getSidebar(array('id' => $this->_general['footer_sid_3'], 'side' => CMS_SIDEBAR_RIGHT), false);
                                $out .= '</div>';                               
                           } break;
                           
                           case self::FOOTER_LAYOUT_3_COLS_RIGHT_BIG:
                           {
                                $out .= '<div class="dc-four dc-columns">';
                                    $out .= $this->getSidebar(array('id' => $this->_general['footer_sid_1'], 'side' => CMS_SIDEBAR_LEFT), false);
                                $out .= '</div>';

                                $out .= '<div class="dc-four dc-columns sid-pr0">';
                                    $out .= $this->getSidebar(array('id' => $this->_general['footer_sid_2'], 'side' => CMS_SIDEBAR_LEFT), false);
                                $out .= '</div>';
                                
                                $out .= '<div class="dc-eight dc-columns">';
                                    $out .= $this->getSidebar(array('id' => $this->_general['footer_sid_3'], 'side' => CMS_SIDEBAR_RIGHT), false);
                                $out .= '</div>';                                 
                           } break;
                           
                           case self::FOOTER_LAYOUT_4_COLS:
                           {
                                $out .= '<div class="dc-four dc-columns">';
                                    $out .= $this->getSidebar(array('id' => $this->_general['footer_sid_1'], 'side' => CMS_SIDEBAR_LEFT), false);
                                $out .= '</div>';

                                $out .= '<div class="dc-four dc-columns">';
                                    $out .= $this->getSidebar(array('id' => $this->_general['footer_sid_2'], 'side' => CMS_SIDEBAR_LEFT), false); 
                                $out .= '</div>';
                                
                                $out .= '<div class="dc-four dc-columns  sid-pr0">';
                                    $out .= $this->getSidebar(array('id' => $this->_general['footer_sid_3'], 'side' => CMS_SIDEBAR_LEFT), false); 
                                $out .= '</div>';
                                
                                $out .= '<div class="dc-four dc-columns">';
                                    $out .= $this->getSidebar(array('id' => $this->_general['footer_sid_4'], 'side' => CMS_SIDEBAR_RIGHT), false); 
                                $out .= '</div>';                             
                           } break;                                                                                                               
                        }                     
                                                
                        $out .= '<div class="dc-clear-both"></div>';                      
                    $out .= '</div>';                 
                }

                if($display_after)
                {    
                    $out .= '<div class="footer-after-wrapper">'; 

                        if($this->_general['footer_after_autoformat'])
                        {
                            $out .= apply_filters('the_content', $this->_general['footer_after']);    
                        } else
                        {
                            $out .= do_shortcode($this->_general['footer_after']);
                        }
 
                    $out .= '</div>';
                }
                
                if($display_logo or $display_copyright) 
                {
                    $out .= '<div class="footer-copyright-wrapper">';
                        if($display_logo and $this->_general['footer_logo'] != '')
                        {
                            $img = $this->_general['footer_logo'];
                            if($logo_grayscale)
                            {
                                $img = dcf_getImageURL($img, null, null, CMS_IMAGE_NOCROP, CMS_IMAGE_FILTER_GRAYSCALE, true);    
                            }
            
                            $style = '';
                                $style .= 'text-align:'.$this->_general['footer_logo_align'].';'; 
                                $style .= 'padding-top:'.$this->_general['footer_logo_pt'].'px;';
                                $style .= 'padding-bottom:'.$this->_general['footer_logo_pb'].'px;';
                                $style .= 'opacity:'.number_format($this->_general['footer_logo_opacity']/100, 2, '.', '').';';
                            $style = ' style="'.$style.'" ';
                            
                            $out .= '<div class="logo" '.$style.'>';
                                $out .= '<img src="'.$img.'" alt="'.get_bloginfo('name').'" />';
                            $out .= '</div>';
                        }
                        if($display_copyright and $this->_general['footer_copyright'] != '')
                        {
                            $style = '';
                                $style .= 'text-align:'.$this->_general['footer_copyright_align'].';'; 
                                $style .= 'padding-left:'.$this->_general['footer_copyright_pl'].'px;';
                                $style .= 'padding-right:'.$this->_general['footer_copyright_pr'].'px;';                                
                            $style = ' style="'.$style.'" ';

                            $out .= '<div class="text" '.$style.'>';
                            $out .= $this->_general['footer_copyright'];
                            $out .= '</div>';
                        }
                    $out .= '</div>';
                }
                
                

            $out .= '</div>';
        }
        
        if($echo) { echo $out; } else { return $out; }    
    }      
    
    public function renderSidebarsCMS($echo=false)
    {
        $out = '';  
    
        if($this->isSubPage('dc-subpage-sidebar-opt'))
        {
            $out .= $this->getPanelBegin('Sidebars settings');
                $out .= '<form action="#" method="post">';
                    $out .= $this->getSubmitTopPanel('dc-general-save-sidebar-opt');
                                                                          
                    $out .= $this->getPanelSectionHead('Create sidebar');                                                        
                    $out .= '<table class="dc-cms-table-standard">';
                        $out .= '<tbody>';
                     
                        $out .= '<tr><td><span class="dc-cms-left-marked-title">Enter name for new sidebar</span></td><td>';
                          
                            $out .= '<span class="dc-cms-control-top-label-nomargin">Sidebar name</span>';
                            $out .= '<input class="dc-cms-control-300" type="text" name="new-sidebar-name" />'; 
                            
                            $out .= '<div class="dc-cms-btn-frame">';
                                $out .= '<input class="dc-cms-submit-btn" type="submit" name="dc-general-create-new-sidebar" value="Create new sidebar"> ';                                 
                            $out .= '</div>';                              
                          
                        $out .= '</td></tr>';    
                        
                        $out .= '</tbody>';
                    $out .= '</table>';
                    
                    $out .= $this->getPanelSectionHead('Options', 50); 
                    $out .= '<table class="dc-cms-table-standard">'; 
                        $out .= '<tbody>';
                    
                        $out .= '<tr><td><span class="dc-cms-left-marked-title">Sidebars registration order</span></td><td>';  
                            $out .= '<input type="checkbox" name="sid_last_as_first" '.$this->attrChecked($this->_general['sid_last_as_first']).'> Last created sidebar register as first';
                            $out .= '<div class="dc-cms-help-note-box">';
                                $out .= 'Display order in <em>Appearance > Widgets</em> section.';
                            $out .= '</div>';
                        $out .= '</td></tr>';
                        
                        $out .= '</tbody>';
                    $out .= '</table>';  
                    
                    $out .= $this->getPanelSectionHead('Default assigned sidebars', 50); 
                    $out .= '<table class="dc-cms-table-standard">';
                     
                        $out .= '<tr><td><span class="dc-cms-left-marked-title">Choose default sidebars</span></td><td>'; 
                            
                            $out .= '<span class="dc-cms-control-top-label-nomargin">Global default left sidebar</span>'; 
                            $out .= $this->selectCtrlSidebarsList($this->_general['sid_default_left'], 'sid_default_left');
                              
                            $out .= '<span class="dc-cms-control-top-label">Global default right sidebar</span>'; 
                            $out .= $this->selectCtrlSidebarsList($this->_general['sid_default_right'], 'sid_default_right');
                               
                            $out .= '<span class="dc-cms-control-top-label">Post global default left sidebar</span>'; 
                            $out .= $this->selectCtrlSidebarsList($this->_general['sid_default_post_left'], 'sid_default_post_left');
                              
                            $out .= '<span class="dc-cms-control-top-label">Post global default right sidebar</span>'; 
                            $out .= $this->selectCtrlSidebarsList($this->_general['sid_default_post_right'], 'sid_default_post_right');                                   

                            $out .= $this->getPanelSectionHeadSmall('Category archive pages sidebar', 40);
                              
                            $out .= '<span class="dc-cms-control-top-label">Categories default left sidebar</span>'; 
                            $out .= $this->selectCtrlSidebarsList($this->_general['sid_default_cats_left'], 'sid_default_cats_left');
                           
                            $out .= '<span class="dc-cms-control-top-label">Categories default right sidebar</span>'; 
                            $out .= $this->selectCtrlSidebarsList($this->_general['sid_default_cats_right'], 'sid_default_cats_right');  
                            
                            $out .= $this->getPanelSectionHeadSmall('Other archive pages sidebar', 40); 
                            
                            $out .= '<span class="dc-cms-control-top-label">Archive default left sidebar</span>'; 
                            $out .= $this->selectCtrlSidebarsList($this->_general['sid_default_archive_left'], 'sid_default_archive_left');
                           
                            $out .= '<span class="dc-cms-control-top-label">Archive default right sidebar</span>'; 
                            $out .= $this->selectCtrlSidebarsList($this->_general['sid_default_archive_right'], 'sid_default_archive_right');      
                            
                            $out .= '<div class="dc-cms-help-note-box">';
                                $out .= 'Archive sidebars are shared between default WordPress <span class="dc-cms-marked-span">date</span>, <span class="dc-cms-marked-span">tag</span> and <span class="dc-cms-marked-span">author</span> page.';
                            $out .= '</div>';                                                                                          
                            
                            $out .= $this->getPanelSectionHeadSmall('Other pages sidebar', 40);
                                
                            $out .= '<span class="dc-cms-control-top-label">Search page left sidebar</span>'; 
                            $out .= $this->selectCtrlSidebarsList($this->_general['sid_search_left'], 'sid_search_left');
                           
                            $out .= '<span class="dc-cms-control-top-label">Search page right sidebar</span>'; 
                            $out .= $this->selectCtrlSidebarsList($this->_general['sid_search_right'], 'sid_search_right');                                        

                            $out .= '<span class="dc-cms-control-top-label">404 Error (page not found) left sidebar</span>'; 
                            $out .= $this->selectCtrlSidebarsList($this->_general['sid_404_left'], 'sid_404_left');
                           
                            $out .= '<span class="dc-cms-control-top-label">404 Error (page not found) right sidebar</span>'; 
                            $out .= $this->selectCtrlSidebarsList($this->_general['sid_404_right'], 'sid_404_right');    
                                
                        $out .= '</td></tr>';

                        $out .= '<tr><td><span class="dc-cms-left-marked-title">Choose default sidebar for individual categories</span></td><td>'; 
                            $categories = get_categories();

                            $out .= '<div class="dc-cms-categories-sidebar-list">';
                                if(is_array($categories))
                                {
                                    $index = 0;
                                    foreach($categories as $cat)
                                    {
                                        $out .= '<div class="item">';
                                            $out .= '<span class="label">'.$cat->name.'</span>';
                                            $current = null;
                                            if(array_key_exists($cat->slug, $this->_general['sid_individual_cats']))
                                            {
                                                $current = $this->_general['sid_individual_cats'][$cat->slug];
                                            }
                                            $out .= '<span class="dc-cms-control-top-label-s-margin">Left</span>'; 
                                            $out .= $this->selectCtrlSidebarsList($current->left, 'sid-individual-cats-left-'.$cat->slug, 200);
                                            $out .= '<span class="dc-cms-control-top-label-s-margin">Right</span>'; 
                                            $out .= $this->selectCtrlSidebarsList($current->right, 'sid-individual-cats-right-'.$cat->slug, 200); 
                                        $out .= '</div>';
                                        $index++;
                                    }
                                }
                            $out .= '</div>';    
                        $out .= '</td></tr>';
                        
                        $out .= '</tbody>';
                    $out .= '</table>';                                                
                                         
                                                                                                  
                    $out .= $this->getPanelSectionHead('Sidebars List', 50);   
                    $out .= '<table class="dc-cms-table-standard">'; 
                        $out .= '<tbody>';
                        
                        $out .= '<tr><td><span class="dc-cms-left-marked-title">Delete or combine particular sidebars</span></td><td>';                               
                            
                            $out .= '<div class="dc-cms-sidebars-list">';
                            if(is_array($this->_sidlist))
                            {                                
                                $index = 0;
                                foreach($this->_sidlist as $sid)
                                {
                                    $out .= '<div class="item">';
                                        $out .= '<span class="label">Sidebar name: </span>'.$sid->_name.'<br />';
                                        
                                        
                                        $out .= '<div class="dc-cms-sortable-sidebars-list-wrapper">';
                                            $out .= '<span class="dc-cms-control-top-label">Attached sidebars content</span>'; 
                                            $out .= '<ul class="dc-cms-sortable-sidebars-list">';
                                                $index_in = 1;
                                                foreach($this->_sidlist as $sid_in)
                                                {
                                                    if($sid_in->_id == $sid->_id)
                                                    {
                                                        foreach($sid_in->_childs as $child_id => $use)
                                                        {
                                                            $sidebar = $this->getSidebarObjectByID($child_id);
                                                            if($sidebar !== false)
                                                            {
                                                                $class = '';
                                                                if($sidebar->_id == $sid->_id) { $class = ' class="primary" '; }
                                                                $out .= '<li '.$class.'><span class="number">'.$index_in.'</span>. '.$sidebar->_name.' <span class="dc-cms-hidden id">'.$sidebar->_id.'</span> <div class="input-use"><input class="use" type="checkbox" '.$this->attrChecked($use).'/> Display</div></li>';                                                                
                                                                $index_in++; 
                                                            }
                                                        }
                                                    }
                                                    
                                                    if(!$sid->inChilds($sid_in->_id))
                                                    {           
                                                        $class = '';
                                                        if($sid_id->_id == $sid->_id) { $class = ' class="primary" '; }                                                 
                                                        $out .= '<li '.$class.'><span class="number">'.$index_in.'</span>. '.$sid_in->_name.' <span class="dc-cms-hidden id">'.$sid_in->_id.'</span> <div class="input-use"><input class="use" type="checkbox" /> Display</div></li>';   
                                                        $index_in++;
                                                    }                          
                                                }
                                            $out .= '</ul>';
                                        $out .= '</div>';
                                        
                                        $out .= '<span class="dc-cms-action-name">dc_sid_combine</span>';
                                        $out .= '<span class="dc-cms-hidden index">'.$index.'</span>'; 
                                        
                                        $out .= '<input class="dc-cms-submit-btn" type="button" name="dc-general-update-sidebar" value="Update order and display settings"> ';                                        
                                        $out .= '<input class="dc-cms-submit-delete-btn" onclick="return confirm(\'Delete sidebar?\')" type="submit" name="dc-general-delete-sidebar-'.$index.'" value="Delete"> ';                                 
                                    $out .= '</div>';
                                                                        
                                    $index++;
                                }                                                                                                        
                            }
                            $out .= '</div>';                                                              
                          
                        $out .= '</td></tr>';
                        
                        $out .= '</tbody>';    
                    $out .= '</table>';                        
                    
                    
                    $out .= $this->getSubmitBottomPanel('dc-general-save-sidebar-opt');
                $out .= '</form>';

            $out .= $this->getPanelEnd();                                           
        }    
    
        if($echo) { echo $out; } else { return $out; } 
    }    
    
    public function renderMainLogoCMS($echo=false)
    {
        $out = '';    
    
        if($this->isSubPage('dc-subpage-main-logo-opt'))
        {
            $out .= $this->getPanelBegin('Theme main logo settings');
                $out .= '<form action="#" method="post">';
                    $out .= $this->getSubmitTopPanel('dc-general-save-main-logo-opt');

                    $out .= $this->getPanelSectionHead('Logo image', 0);                                                        
                    $out .= '<table class="dc-cms-table-standard">'; 
                        $out .= '<tbody>';
                    
                        $out .= '<tr><td><span class="dc-cms-left-marked-title">Select image for logo</span></td><td>';
                            $out .= $this->getStdInputsFieldStart();
                                $out .= '<input type="checkbox" name="logo_display" '.$this->attrChecked($this->_general['logo_display']).' /> Display';
                                $out .= $this->getBR();
                                $out .= '<input type="checkbox" name="logo_center" '.$this->attrChecked($this->_general['logo_center']).' /> Center logo horizontally'; 
                            $out .= $this->getStdInputsFieldEnd();
                            
                            $out .= $this->getEmptySpaceField(20);
                            
                            $out .= '<input type="text" class="dc-cms-control-500" name="logo_img" value="'.$this->_general['logo_img'].'" id="dc_id_logo_img" /> ';
                            $out .= '<div class="dc-cms-btn-frame">';
                                $out .= '<input class="dc-cms-submit-image-btn" type="submit" name="dc_id_logo_img" value="Load image"> ';  
                            $out .= '</div>';    
                        
                            $out .= $this->getImagePreviewBox(array('path' => $this->_general['logo_img'], 'width' => 240, 'height' => 180));                               
                        
                            $path = dcf_getRelativePath($this->_general['logo_img']); 
                            if(is_file($path))
                            {
                                $img_info = getimagesize($path);
                                $path_info = pathinfo($path);                                    
                                
                                $out .= '<span class="dc-cms-control-top-label">Selected logo image information</span>'; 
                                 
                                $out .= '<div class="dc-cms-object-data-box">';
                                    $out .= '<div class="option"><div class="property">Width</div><div class="value">'.$img_info[0].'</div></div>';
                                    $out .= '<div class="option"><div class="property">Height</div><div class="value">'.$img_info[1].'</div></div>';
                                    $out .= '<div class="option"><div class="property">Type</div><div class="value">'.strtoupper($path_info['extension']).'</div></div>'; 
                                $out .= '</div>';
                            }
                        
                        $out .= '</td></tr>';
                        
                        $out .= '</tbody>';
                    $out .= '</table>'; 
                                                                          
                    $out .= $this->getPanelSectionHead('Logo dimensions', 50);                                                        
                    $out .= '<table class="dc-cms-table-standard">';                     
                        $out .= '<tbody>';
                        
                        $out .= '<tr><td><span class="dc-cms-left-marked-title">Setup size</span></td><td>';                                                             

                            $out .= '<span class="dc-cms-control-top-label-nomargin">Width</span>';                                
                            $out .= $this->getCtrlInputInt('logo_width', $this->_general['logo_width'], 0, 1000);  

                            $out .= '<span class="dc-cms-control-top-label">Height</span>';                                                        
                            $out .= $this->getCtrlInputInt('logo_height', $this->_general['logo_height'], 0, 1000); 
                            
                            $out .= $this->getStdInputsFieldStart(array('mtop-type' => 'normal'));
                                $out .= '<input type="checkbox" name="logo_height_use" '.$this->attrChecked($this->_general['logo_height_use']).' /> Use logo height';
                                $out .= $this->getBR();
                                $out .= '<input type="checkbox" name="logo_debug_frame" '.$this->attrChecked($this->_general['logo_debug_frame']).' /> Display logo debug frame';                                                                  
                            $out .= $this->getStdInputsFieldEnd();                                                                                                                                        
                                               
                        $out .= '</td></tr>';    
                        
                        $out .= '</tbody>';
                    $out .= '</table>';      
                    
                    $out .= $this->getPanelSectionHead('Logo link', 50);                                                        
                    $out .= '<table class="dc-cms-table-standard">'; 
                        $out .= '<tbody>';
                    
                        $out .= '<tr><td><span class="dc-cms-left-marked-title">Choose logo link and it parameters</span></td><td>';  
                                     
                            $out .= '<div class="dc-cms-inputs-field-nomargin">';                                               
                                $out .= '<input type="checkbox" name="logo_linkable" '.$this->attrChecked($this->_general['logo_linkable']).' /> Allow linking';                                    
                                $out .= $this->getBR();  
                                $out .= '<input type="checkbox" name="logo_target_blank" '.$this->attrChecked($this->_general['logo_target_blank']).' /> Open logo link in new window/tab';  
                                $out .= $this->getBR();  
                                $out .= '<input type="checkbox" name="logo_grayscale" '.$this->attrChecked($this->_general['logo_grayscale']).' /> Display logo image in grayscale';  
                            $out .= '</div>';
                                                            
                            $out .= '<div class="dc-cms-excludable-checkbox-field">';
                                $out .= '<input type="checkbox" name="logo_link_to_theme" '.$this->attrChecked($this->_general['logo_link_to_theme']).' /> Link logo to WordPress address URL';
                                $out .= $this->getBR();                                   
                                $out .= '<input type="checkbox" name="logo_link_to_url" '.$this->attrChecked($this->_general['logo_link_to_url']).' /> Link logo to manually choosed address URL';
                                $out .= $this->getBR();   
                                $out .= '<input type="checkbox" name="logo_link_to_page" '.$this->attrChecked($this->_general['logo_link_to_page']).' /> Link logo to selected page'; 
                            $out .= '</div>';                                
                        
                            $out .= '<span class="dc-cms-control-top-label">Manually link</span>';  
                            $out .= '<input type="text" class="dc-cms-control-600" name="logo_url" value="'.$this->_general['logo_url'].'" /> ';                            
                        
                            $out .= '<span class="dc-cms-control-top-label">Page link</span>'; 
                            $out .= $this->selectCtrlPagesList(array('value' => $this->_general['logo_page'], 'name' => 'logo_page', 'width' => 300));
                        
                        $out .= '</td></tr>';    
                        
                        $out .= '</tbody>';
                    $out .= '</table>';      
                    
                    $out .= $this->getSubmitBottomPanel('dc-general-save-main-logo-opt');
                $out .= '</form>';

            $out .= $this->getPanelEnd();                                           
        }        
    
        if($echo) { echo $out; } else { return $out; }
    }
    
    public function renderIconsBoxCMS($echo=false)
    {
        $out = '';
    
        if($this->isSubPage('dc-subpage-icons-box-opt'))
        {
            $out .= $this->getPanelBegin('Icons box');
                $out .= '<form action="#" method="post">';
                    $out .= $this->getSubmitTopPanel('dc-general-save-icons-box-opt');

                    // icons wrapper
                    $out .= $this->getPanelSectionHead('icons wrapper dimensions and position');                                                        
                    $out .= '<table class="dc-cms-table-standard">';
                        $out .= '<tbody>';
                     
                        $out .= '<tr><td><span class="dc-cms-left-marked-title">Setup icons wrapper size and position</span></td><td>';                           
                    
                            $out .= $this->getStdInputsFieldStart();
                                $out .= '<input type="checkbox" name="icons_display" '.$this->attrChecked($this->_general['icons_display']).' /> Display';
                                $out .= $this->getBR();
                                $out .= '<input type="checkbox" name="icons_tooltip_display" '.$this->attrChecked($this->_general['icons_tooltip_display']).' /> Display icons tooltip';
                                $out .= $this->getBR();                                    
                                $out .= '<input type="checkbox" name="icons_debug_frame" '.$this->attrChecked($this->_general['icons_debug_frame']).' /> Display wrapper and icons debug frame'; 
                            $out .= $this->getStdInputsFieldEnd();                                             
                    
                        $out .= '</td></tr>';
                        
                        $out .= '</tbody>';    
                    $out .= '</table>';                            
                    
                    // icons options
                    $out .= $this->getPanelSectionHead('Icons settings', 50);                                                        
                    $out .= '<table class="dc-cms-table-standard">'; 
                        $out .= '<tbody>';
                    
                        $out .= '<tr><td><span class="dc-cms-left-marked-title">Setup properties for icons</span></td><td>';  
                        
                            $out .= '<span class="dc-cms-control-top-label-nomargin">Icon width</span>';                                
                            $out .= $this->getCtrlInputInt('icons_icon_width', $this->_general['icons_icon_width']);

                            $out .= '<span class="dc-cms-control-top-label">Icon height</span>';                                
                            $out .= $this->getCtrlInputInt('icons_icon_height', $this->_general['icons_icon_height']);                                                                               
                        
                            $out .= '<span class="dc-cms-control-top-label">Distance between icons</span>';                                
                            $out .= $this->getCtrlInputInt('icons_icon_mergin_left', $this->_general['icons_icon_mergin_left']);                               
                        
                        
                        $out .= '</td></tr>';    
                        
                        $out .= '</tbody>';
                    $out .= '</table>';
                            
                    // create new icon                                              
                    $out .= $this->getPanelSectionHead('Create new icon', 50);                                                        
                    $out .= '<table class="dc-cms-table-standard">'; 
                        $out .= '<tbody>';
                    
                        $out .= '<tr><td><span class="dc-cms-left-marked-title">Enter data for new icon</span></td><td>';
                        
                            $out .= '<span class="dc-cms-control-top-label-nomargin">Icon name</span>';
                            $out .= '<input class="dc-cms-control-300" type="text" name="new-icon-name" />'; 
                            
                            $out .= '<div class="dc-cms-btn-frame">';
                                $out .= '<input class="dc-cms-submit-btn" type="submit" name="dc-general-create-new-icon-box" value="Create new icon"> ';                                 
                            $out .= '</div>';                               
                          
                        $out .= '</td></tr>';
                        
                        $out .= '</tbody>';    
                    $out .= '</table>';
                    
                    // icons list
                    $is_array = is_array($this->_general['icons_list']);
                    if(!$is_array) { $this->_general['icons_list'] = array(); }
                    
                    if(count($this->_general['icons_list'])) 
                    {        
                                                                                                              
                        $out .= $this->getPanelSectionHead('Edit icons', 50);                                                        
                        $out .= '<table class="dc-cms-table-standard">'; 
                            $out .= '<tbody>';
                        
                            $out .= '<tr><td><span class="dc-cms-left-marked-title">List of created icons</span></td><td>';                                                                                        
                            
                                $out .= '<div class="dc-cms-sortable-icons-box-list-wrapper">';
                                    $out .= '<ul class="dc-cms-sortable-icons-box-list">';
                                        $index = 0;
                                        foreach($this->_general['icons_list'] as $icon)
                                        {
                                            $out .= '<li>';
                                                $out .= '<div class="index-box">'.($index+1).'</div>';
                                            
                                                $out .= '<input type="hidden" value="'.$index.'" name="icon-box-index-'.$index.'" />';
                                                $out .= '<span class="dc-cms-control-top-label-nomargin">Icon name</span>';
                                                $out .= '<input type="text" class="dc-cms-control-300" name="icon-name-'.$index.'" value="'.stripcslashes($icon->_name).'" />';
                                                
                                                $out .= '<div class="icon-images-wrapper">';
                                                    $out .= '<div class="icon-main-image-wrapper">';
                                                    
                                                        $out .= '<span class="dc-cms-control-top-label-nomargin">Image URL</span>'; 
                                                        $out .= '<input type="text" class="dc-cms-control-100per" name="icon-image-'.$index.'" value="'.$icon->_imgurl.'" id="dc_id_icon-image-'.$index.'" /> ';
                                                        
                                                        $style = '';
                                                        if($icon->_imgurl != '') { $style = ' style="background-image:url('.$icon->_imgurl.');" '; }
                                                        $out .= '<div class="image" '.$style.'>';                                                            
                                                        $out .= '</div>';                                                            
                                                        
                                                        $out .= '<input class="dc-cms-submit-image-btn" type="submit" name="dc_id_icon-image-'.$index.'" value="Load image"> ';                                                          
                                                    
                                                    $out .= '</div>';
                                                    
                                                    $out .= '<div class="icon-hover-image-wrapper">';
                                                    
                                                        $out .= '<span class="dc-cms-control-top-label-nomargin">Hover image URL</span>'; 
                                                        $out .= '<input type="text" class="dc-cms-control-100per" name="icon-image-hover-'.$index.'" value="'.$icon->_imgurl_hover.'" id="dc_id_icon-image-hover-'.$index.'" /> ';

                                                        $style = '';
                                                        if($icon->_imgurl_hover != '') { $style = ' style="background-image:url('.$icon->_imgurl_hover.');" '; }                                                            
                                                        $out .= '<div class="image" '.$style.'>';                                                            
                                                        $out .= '</div>';             
                                                                                                       
                                                        $out .= '<input class="dc-cms-submit-image-btn" type="submit" name="dc_id_icon-image-hover-'.$index.'" value="Load image"> ';  
                                                        
                                                    $out .= '</div>';
                                                    $out .= '<div class="dc-cms-clear"></div>'; 
                                                $out .= '</div>';                                                
                                                
                                                $out .= '<span class="dc-cms-control-top-label">Description</span>';
                                                $out .= '<input type="text" class="dc-cms-control-300" name="icon-desc-'.$index.'" value="'.stripcslashes($icon->_desc).'" />';

                                                $out .= '<span class="dc-cms-control-top-label">Link URL</span>';
                                                $out .= '<input type="text" class="dc-cms-control-300" name="icon-url-'.$index.'" value="'.$icon->_url.'" />';
                                                
                                                $out .= '<span class="dc-cms-control-top-label">Other options</span>';  
                                                $out .= '<div class="dc-cms-inputs-field-nomargin">';
                                                    $out .= '<input type="checkbox" name="icon-hide-'.$index.'" '.$this->attrChecked($icon->_hide).' /> Hide icon';
                                                    $out .= '<br />';
                                                    $out .= '<input type="checkbox" name="icon-target-blank-'.$index.'" '.$this->attrChecked($icon->_target_blank).' /> Open icon link in new window/tab';
                                                    $out .= '<br />';
                                                    $out .= '<input type="checkbox" name="icon-hovered-'.$index.'" '.$this->attrChecked($icon->_hovered).' /> Use hover image';
                                                $out .= '</div>';
                                                
                                                $out .= '<div class="dc-cms-btn-frame">';
                                                    $out .= '<input class="dc-cms-submit-delete-btn" onclick="return confirm(\'Delete this icon?\')" type="submit" name="dc-general-delete-icon-box-'.$index.'" value="Delete"> ';                                 
                                                $out .= '</div>'; 
                                                
                                            $out .= '</li>';
                                            $index++;    
                                        }
                                    $out .= '</ul>';
                                    $out .= '<div class="dc-cms-clear"></div>'; 
                                $out .= '</div>';
                              
                            $out .= '</td></tr>'; 
                            
                            $out .= '</tbody>';   
                        $out .= '</table>';                        
                 
                    }                     
                    
                    $out .= $this->getSubmitBottomPanel('dc-general-save-icons-box-opt');
                $out .= '</form>';

            $out .= $this->getPanelEnd();                                           
        }        
    
        if($echo) { echo $out; } else { return $out; }  
    }    
   
    public function renderContactFormCreatorCMS($echo=false)
    {
        $out = '';
        
        if($this->isSubPage('dc-subpage-contact-form-opt'))
        {
            $out .= $this->getPanelBegin('Contact form creator');
                $out .= '<form action="#" method="post">';
                    $out .= $this->getSubmitTopPanel('dc-general-save-contact-form-opt');
                                                                          
                        $out .= $this->getPanelSectionHead('Create new contact form');                                                        
                        $out .= '<table class="dc-cms-table-standard">'; 
                            $out .= '<tbody>';
                        
                            $out .= '<tr><td>Insert name for new contact form</td><td>';  

                                $out .= '<span class="dc-cms-control-top-label-nomargin">Contact form name</span>';
                                $out .= '<textarea class="dc-cms-control-600 dc-cms-control-textarea dc-cms-control-h-40" name="new-contact-form-name" ></textarea>'; 
                                
                                $out .= '<div class="dc-cms-btn-frame">';
                                    $out .= '<input class="dc-cms-submit-btn" type="submit" name="dc-general-create-new-contact-form" value="Create new contact form"> ';
                                    $out .= '<input class="dc-cms-submit-btn" type="submit" name="dc-general-create-default-contact-form" value="Create standard contact form"> ';                                 
                                $out .= '</div>'; 
                            
                            $out .= '</td></tr>'; 

                            $out .= '<tr><td>Contact form action messages</td><td>';   
                            
                                $out .= '<span class="dc-cms-control-top-label-nomargin">Text displayed when message was sent successfully</span>';
                                $out .= '<textarea name="cf_message_ok" class="dc-cms-control-textarea dc-cms-control-600 dc-cms-control-h-40">'.$this->_general['cf_message_ok'].'</textarea>';
                            
                                $out .= '<span class="dc-cms-control-top-label">Text displayed when message was not sent (error)</span>';     
                                $out .= '<textarea name="cf_message_error" class="dc-cms-control-textarea dc-cms-control-600 dc-cms-control-h-40">'.$this->_general['cf_message_error'].'</textarea>';
                            
                            $out .= '</td></tr>'; 
                            
                            $out .= '</tbody>';   
                        $out .= '</table>';
                        
                        $count = count($this->_general['cf_list']);
                        if($count > 0)
                        {
                            $out .= $this->getPanelSectionHead('Contact forms list', 50);  

                            $out .= '<table class="dc-cms-table-standard">'; 
                                $out .= '<tbody>';
                            
                                $out .= '<tr><td>Select contact form to edit or delete it</td><td>';                            
                        
                                    $out .= '<div class="dc-cms-contact-forms-list">';
                                        
                                        $index = 0;
                                        foreach($this->_general['cf_list'] as $cf)
                                        {
                                            $class = '';
                                            if($index == $this->_general['cf_edited']) { $class = ' in-edit'; }
                                            
                                            $out .= '<div class="item'.$class.'">';   
                                                $out .= '<span class="dc-cms-control-top-label-nomargin">Name</span>';                      
                                                $out .= '<input type="text" class="dc-cms-control-300" value="'.$cf->_name.'" name="contact-form-name-'.$index.'" />';                                                                                 
                                                $out .= '<div class="menu-id-box">Form ID: '.$cf->_id.'</div>';
                                                
                                                $out .= '<div class="dc-cms-btn-frame">'; 
                                                    $out .= '<input type="submit" class="dc-cms-submit-btn" value="Select to edit" name="dc-general-edit-contact-form-'.$index.'" />';
                                                    $out .= '<input type="submit" class="dc-cms-submit-btn" value="Update" name="dc-general-update-contact-form-'.$index.'" />';
                                                    $out .= '<input type="submit" onclick="return confirm(\'Delete form?\')" name="dc-general-delete-contact-form-'.$index.'" class="dc-cms-submit-delete-btn" value="Delete" />'; 
                                                $out .= '</div>';
                                            
                                            $out .= '</div>';
                                            $index++;    
                                        }
                                        
                                        $out .= '<div class="dc-cms-clear"></div>';
                                    $out .= '</div>';
                        
                                $out .= '</td></tr>'; 
                                
                                $out .= '</tbody>';   
                            $out .= '</table>';
                        }                                                        
                    
                        if($this->_general['cf_edited'] != CMS_NOT_SELECTED)
                        {
                            $cf_index = $this->_general['cf_edited'];
                            $out .= $this->getPanelSectionHead('Edit selected contact form', 50);                                                        
                            $out .= '<table class="dc-cms-table-standard">'; 
                                $out .= '<tbody>';
                            
                                $out .= '<tr><td>Add, delete and setup form controls</td><td>';                          

                                    $out .= '<input type="hidden" value="'.$cf_index.'" name="edited-cf-index" />';
                                    $out .= '<div class="dc-cms-edit-contact-form-wrapper">';
                                        
                                        $out .= '<div class="edit-contact-form-left-column">';
                                        
                                        $out .= '<ul class="cf-items-list">';                                         
                                        if(is_array($this->_general['cf_list'][$cf_index]->_inputs))
                                        {
                                            
                                            if(count($this->_general['cf_list'][$cf_index]->_inputs) > 0)
                                            {
                                                
                                                $input_index = 0;
                                                foreach($this->_general['cf_list'][$cf_index]->_inputs as $input)
                                                {                                                        
                                                    $out .= $this->getContactFormInputHtml($input_index, $input);
                                                    $input_index++;    
                                                }
                                            }
                                            
                                        }
                                        $out .= '</ul>';     
                                        $out .= '</div>';

                                        
                                        $out .= '<div class="edit-contact-form-right-column">';
                                            $out .= '<div class="panel">';
                                                $out .= '<span class="dc-cms-control-top-label-nomargin">Select control type</span>';
                                                $out .= '<select class="dc-cms-control-200" name="control-type">';
                                                    $out .= '<option value="text">Text</option>';
                                                    $out .= '<option value="select">Select</option>';
                                                    $out .= '<option value="textarea">Textarea</option>';
                                                $out .= '</select>';                                                    
                                                
                                                $out .= '<div class="dc-cms-btn-frame">';
                                                    $out .= '<span class="dc-cms-action-name">dc_add_cf_node</span>'; 
                                                    $out .= '<input class="dc-cms-submit-btn" type="button" value="Add to form"> ';                                 
                                                $out .= '</div>';                                                    
                                                
                                            $out .= '</div>';
                                        $out .= '</div>';
                                    
                                        $out .= '<div class="dc-cms-clear"></div>';
                                    $out .= '</div>';
                                
                                $out .= '</td></tr>';  
                                
                                $out .= '</tbody>';  
                            $out .= '</table>';
                        }
                        
                    $out .= $this->getSubmitBottomPanel('dc-general-save-contact-form-opt');
                $out .= '</form>';

            $out .= $this->getPanelEnd();                 
        }        
        
        if($echo) { echo $out; } else { return $out; } 
    }    

    public function renderSearchEngineCMS($echo=false)
    {
        $out = '';
        
        if($this->isSubPage('dc-subpage-seo-opt'))
        {
            $out .= $this->getPanelBegin('Global SEO (Search Engine Optimization) settings');
         
                $out .= '<form action="#" method="post">'; 
                
                    $out .= $this->getSubmitTopPanel('dc-general-save-seo-opt');                                                              
                    $out .= $this->getPanelSectionHead('Main settings');     
                         
                        $out .= '<table class="dc-cms-table-standard">';
                            $out .= '<tbody>';  
                        
                            // global seo
                            $out .= '<tr><td><span class="dc-cms-left-marked-title">Configure global and invidual post, page SEO options interaction</span></td><td>';
                                $out .= $this->getStdInputsFieldStart();
                                    $out .= '<input type="checkbox" name="seo_use" '.$this->attrChecked($this->_general['seo_use']).' /> Use global SEO';
                                    $out .= $this->getBR();                                    
                                    $out .= '<input type="checkbox" name="seo_overwrite_post" '.$this->attrChecked($this->_general['seo_overwrite_post']).' /> Overwrite post invidual SEO with global SEO settings';
                                    $out .= $this->getBR();
                                    $out .= '<input type="checkbox" name="seo_overwrite_page" '.$this->attrChecked($this->_general['seo_overwrite_page']).' /> Overwrite page invidual SEO with global SEO settings';                                
                                $out .= $this->getStdInputsFieldEnd();
                                
                                $out .= '<div class="dc-cms-help-note-box">';
                                    $out .= 'Post and page inviudual settings will be overwritten only if option <span class="dc-cms-marked-span">Use global SEO</span> is selected.';
                                $out .= '</div>';
                            $out .= '</td></tr>'; 
                            
                            $out .= '<tr><td><span class="dc-cms-left-marked-title">Page title outputed in header</span></td><td>';  
                                $out .= '<textarea class="dc-cms-control-textarea dc-cms-control-h-40 dc-cms-control-500" name="seo_title">'.$this->_general['seo_title'].'</textarea>';
                                $out .= $this->getStdInputsFieldStart();
                                    $out .= '<input type="checkbox" name="seo_title_use" '.$this->attrChecked($this->_general['seo_title_use']).' /> Use title';
                                    $out .= $this->getBR();
                                    $out .= '<input type="checkbox" name="seo_add_blog_name" '.$this->attrChecked($this->_general['seo_add_blog_name']).' /> Add blog name before title';                        
                                $out .= $this->getStdInputsFieldEnd();                          
                            $out .= '</td></tr>';   
                            
                            $out .= '<tr><td><span class="dc-cms-left-marked-title">Page keywords meta tag (if more then one keyword, you can use comma to separate it)</span></td><td>';
                                $out .= '<textarea class="dc-cms-control-textarea dc-cms-control-h-60 dc-cms-control-500" name="seo_keywords">'.$this->_general['seo_keywords'].'</textarea>';
                                $out .= $this->getStdInputsFieldStart();
                                    $out .= '<input type="checkbox" name="seo_keywords_use" '.$this->attrChecked($this->_general['seo_keywords_use']).' /> Use keywords'; 
                                $out .= $this->getStdInputsFieldEnd();
                            $out .= '</td></tr>'; 
                            
                            $out .= '<tr><td><span class="dc-cms-left-marked-title">Page description meta tag</span></td><td>'; 
                                $out .= '<textarea class="dc-cms-control-textarea dc-cms-control-h-80 dc-cms-control-wide" name="seo_desc">'.$this->_general['seo_desc'].'</textarea>';
                                $out .= $this->getStdInputsFieldStart();
                                    $out .= '<input type="checkbox" name="seo_desc_use" '.$this->attrChecked($this->_general['seo_desc_use']).' /> Use description';
                                $out .= $this->getStdInputsFieldEnd();
                            $out .= '</td></tr>';                                                                                                             
                
                            $out .= '<tr><td><span class="dc-cms-left-marked-title">Search engine robots meta tags</span></td><td>';  
                                $out .= $this->getStdInputsFieldStart();
                                    $out .= '<input type="checkbox" name="seo_noindex" '.$this->attrChecked($this->_general['seo_noindex']).' /> noindex';
                                    $out .= $this->getBR();
                                    $out .= '<input type="checkbox" name="seo_nofollow" '.$this->attrChecked($this->_general['seo_nofollow']).' /> nofollow';
                                    $out .= $this->getBR();                                                 
                                    $out .= '<input type="checkbox" name="seo_nosnippet" '.$this->attrChecked($this->_general['seo_nosnippet']).' /> nosnippet';
                                    $out .= $this->getBR();  
                                    $out .= '<input type="checkbox" name="seo_noodp" '.$this->attrChecked($this->_general['seo_noodp']).' /> noodp';
                                    $out .= $this->getBR(); 
                                    $out .= '<input type="checkbox" name="seo_noarchive" '.$this->attrChecked($this->_general['seo_noarchive']).' /> noarchive';
                                    $out .= $this->getBR();  
                                    $out .= '<input type="checkbox" name="seo_noimageindex" '.$this->attrChecked($this->_general['seo_noimageindex']).' /> noimageindex';                       
                                $out .= $this->getStdInputsFieldEnd();
                            $out .= '</td></tr>';                            
                            
                            // private meta tags
                            $out .= '<tr><td><span class="dc-cms-left-marked-title">Private meta tags</span></td><td>';
                            
                                if(!is_array($this->_general['seo_private_meta'])) { $this->_general['seo_private_meta'] = array(); }
                                
                                $list = '';
                                $meta_count = count($this->_general['seo_private_meta']);
                                
                                for($i = 0; $i < $meta_count; $i++)
                                {
                                    if($i > 0) { $list .= ','; }
                                    $list .= $i;
                                }
                                
                                $out .= '<div class="dc-cms-global-seo-meta-wrapper">'; 

                                    $out .= '<input type="hidden" name="global_seo_private_meta_list" value="'.$list.'" />';
                                    for($i = 0; $i < $meta_count; $i++)
                                    {
                                        $out .= DCC_PrivateSeoMeta::getHTMLMeta($this->_general['seo_private_meta'][$i], $i);
                                    }

                                $out .= '</div>';
                                
                                $out .= '<div class="dc-cms-btn-frame-nomargin">';
                                    $out .= '<span class="dc-cms-action-name">dc_add_seo_meta</span>';
                                    $out .= '<input class="dc-cms-submit-btn" type="button" name="dc-global-meta-add-private-seo-meta" value="Add meta" /> ';  
                                $out .= '</div>';                                  
                            
                            $out .= '</td></tr>';                     
                
                            $out .= '</tbody>';
                        $out .= '</table>';                   
                
                    $out .= $this->getSubmitBottomPanel('dc-general-save-seo-opt');                                          
                $out .= '</form>';
         
            $out .= $this->getPanelEnd();                       
        }
        
        if($echo) { echo $out; } else { return $out; }   
    }    
    
    public function renderTwitterCMS($echo=false)
    {
        $out = '';
        
        if($this->isSubPage('dc-subpage-twitter-opt'))
        {
            $out .= $this->getPanelBegin('Twitter settings');
         
                $out .= '<form action="#" method="post">'; 
                
                    $out .= $this->getSubmitTopPanel('dc-general-save-twitter-opt');                                                              
                    $out .= $this->getPanelSectionHead('Twitter configuration');     
                         
                        $out .= '<table class="dc-cms-table-standard">';                     
                            $out .= '<tbody>';
                        
                            // customer key and secret
                            $out .= '<tr><td><span class="dc-cms-left-marked-title">Set your consumer key and secret</span></td><td>';
                            
                                $out .= '<span class="dc-cms-control-top-label-nomargin">Consumer key</span>';  
                                $out .= '<input type="text" class="dc-cms-control-600" name="twitter_consumer_key" value="'.$this->_general['twitter_consumer_key'].'" />';

                                $out .= '<span class="dc-cms-control-top-label">Consumer secret</span>';  
                                $out .= '<input type="text" class="dc-cms-control-600" name="twitter_consumer_secret" value="'.$this->_general['twitter_consumer_secret'].'" />';

                                $out .= '<div class="dc-cms-help-note-box">';
                                    $out .= 'The configuration of <span class="dc-cms-marked-span">Twitter</span> funcionality in this <span class="dc-cms-marked-span">WordPress</span> theme take few steps.';
                                    $out .= '<ul class="disc-list">';
                                        $out .= '<li>Create application for your site domain</li>';
                                        $out .= '<li>Collect consumer key and it secret for newly created application</li>';
                                        $out .= '<li>Generate token key and it secret</li>';
                                        $out .= '<li>Save in theme options consumer and token data</li>';
                                        $out .= '<li>Create Twitter widget on selected siderbar</li>';
                                    $out .= '</ul>';                                
                                    $out .= 'Under this link you can create your own <a href="https://dev.twitter.com/apps" target="_blank">Twitter application</a> associoated with your <span class="dc-cms-marked-span">Twitter</span> account.';
                                    $out .= '<br />';
                                    $out .= 'The creating process will generate for you all data you need to proper <span class="dc-cms-marked-span">Twitter</span> configuration.';
                                $out .= '</div>';
                                
                            $out .= '</td></tr>'; 

                            // token key and secret
                            $out .= '<tr><td><span class="dc-cms-left-marked-title">Set your token key and secret</span></td><td>';

                                $out .= '<span class="dc-cms-control-top-label-nomargin">Token key</span>';  
                                $out .= '<input type="text" class="dc-cms-control-600" name="twitter_token_key" value="'.$this->_general['twitter_token_key'].'" />';

                                $out .= '<span class="dc-cms-control-top-label">Token secret</span>';  
                                $out .= '<input type="text" class="dc-cms-control-600" name="twitter_token_secret" value="'.$this->_general['twitter_token_secret'].'" />';                                

                            $out .= '</td></tr>';                             
                
                            $out .= '</tbody>';
                        $out .= '</table>';                   
                
                    $out .= $this->getSubmitBottomPanel('dc-general-save-twitter-opt');                                          
                $out .= '</form>';
         
            $out .= $this->getPanelEnd();                       
        }
        
        if($echo) { echo $out; } else { return $out; }   
    }        
    
    public function renderAnnouncementBarCMS($echo=false)
    {
        $out = '';
        
        if($this->isSubPage('dc-subpage-announcement-bar-opt'))
        {
            $out .= $this->getPanelBegin('Announcement bar settings');
         
                $out .= '<form action="#" method="post">'; 
                
                    $out .= $this->getSubmitTopPanel('dc-general-save-abar-opt'); 
                    
                    $out .= $this->getPanelSectionHead('Core settings');   
                
                        $out .= '<table class="dc-cms-table-standard">';                     
                            $out .= '<tbody>';                    
                            
                            $out .= '<tr><td><span class="dc-cms-left-marked-title">Render settings</span></td><td>';                     

                                $out .= '<span class="dc-cms-control-top-label-nomargin">Display options</span>'; 
                                $out .= $this->getStdInputsFieldStart();
                                    $out .= '<input type="checkbox" name="abar_display" '.$this->attrChecked($this->_general['abar_display']).' /> Display';                                   
                                    $out .= $this->getBR();
                                    $out .= '<input type="checkbox" name="abar_display_in_lowres" '.$this->attrChecked($this->_general['abar_display_in_lowres']).' /> Display in low screen resolution'; 
                                    $out .= $this->getBookHelp(array('text' => 'If checked the <span class="dc-cms-marked-span">announcement bar</span> will be displayed under 768 pixels screen horizontal resolultion.'));
                                    $out .= $this->getBR(); 
                                    $out .= '<input type="checkbox" name="abar_display_shadow" '.$this->attrChecked($this->_general['abar_display_shadow']).' /> Display shadow'; 
                                $out .= $this->getStdInputsFieldEnd();
                            
                                $out .= '<span class="dc-cms-control-top-label">Height in pixels</span>';                    
                                $out .= $this->getCtrlInputInt('abar_h', $this->_general['abar_h'], 1);                                                                                              
                                
                                $out .= $this->getEmptySpaceField(10);
                                
                                $out .= $this->getStdColumnStart(array('width' => 120));
                                    $out .= '<span class="dc-cms-control-top-label">Padding top</span>';                    
                                    $out .= $this->getCtrlInputInt('abar_pt', $this->_general['abar_pt'], 0);
                                    $out .= $this->getBR();
                                    $out .= $this->getStdInputsFieldStart(array('mtop-type' => 'small'));  
                                        $out .= '<input type="checkbox" name="abar_pt_use" '.$this->attrChecked($this->_general['abar_pt_use']).' /> Use';
                                    $out .= $this->getStdInputsFieldEnd();
                                $out .= $this->getStdColumnEnd();                               

                                $out .= $this->getStdColumnStart(array('width' => 120));
                                    $out .= '<span class="dc-cms-control-top-label">Padding right</span>';                    
                                    $out .= $this->getCtrlInputInt('abar_pr', $this->_general['abar_pr'], 0);
                                    $out .= $this->getBR();
                                    $out .= $this->getStdInputsFieldStart(array('mtop-type' => 'small'));  
                                        $out .= '<input type="checkbox" name="abar_pr_use" '.$this->attrChecked($this->_general['abar_pr_use']).' /> Use';
                                    $out .= $this->getStdInputsFieldEnd();
                                $out .= $this->getStdColumnEnd();     

                                $out .= $this->getStdColumnStart(array('width' => 120));
                                    $out .= '<span class="dc-cms-control-top-label">Padding bottom</span>';                    
                                    $out .= $this->getCtrlInputInt('abar_pb', $this->_general['abar_pb'], 0);
                                    $out .= $this->getBR();
                                    $out .= $this->getStdInputsFieldStart(array('mtop-type' => 'small'));  
                                        $out .= '<input type="checkbox" name="abar_pb_use" '.$this->attrChecked($this->_general['abar_pb_use']).' /> Use';
                                    $out .= $this->getStdInputsFieldEnd(); 
                                $out .= $this->getStdColumnEnd();   
                                
                                $out .= $this->getStdColumnStart(array('width' => 120));
                                    $out .= '<span class="dc-cms-control-top-label">Padding left</span>';                    
                                    $out .= $this->getCtrlInputInt('abar_pl', $this->_general['abar_pl'], 0);
                                    $out .= $this->getBR();
                                    $out .= $this->getStdInputsFieldStart(array('mtop-type' => 'small')); 
                                        $out .= '<input type="checkbox" name="abar_pl_use" '.$this->attrChecked($this->_general['abar_pl_use']).' /> Use';
                                    $out .= $this->getStdInputsFieldEnd();
                                $out .= $this->getStdColumnEnd();                                   
                            
                                $out .= $this->getClearBoth();
                            
                            $out .= '</td></tr>'; 
                
                            $out .= '<tr><td><span class="dc-cms-left-marked-title">Content</span></td><td>';    
                                $out .= '<span class="dc-cms-control-top-label-nomargin">Insert here your announcement bar content</span>';                  
                                $out .= '<textarea class="dc-cms-control-wide dc-cms-control-textarea dc-cms-control-h-280" name="abar_content">';
                                    $out .= $this->_general['abar_content'];
                                $out .= '</textarea>';
                                
                                $out .= $this->getStdInputsFieldStart();
                                    $out .= '<input type="checkbox" name="abar_content_use" '.$this->attrChecked($this->_general['abar_content_use']).' /> Use content';       
                                $out .= $this->getStdInputsFieldEnd();
                            $out .= '</td></tr>';       
                            
                            $out .= '<tr><td><span class="dc-cms-left-marked-title">Link</span></td><td>';      
                                $out .= '<span class="dc-cms-control-top-label-nomargin">URL address</span>';
                                $out .= '<input type="text" class="dc-cms-control-wide" value="'.$this->_general['abar_link'].'" name="abar_link" />';  
                                
                                $out .= '<span class="dc-cms-control-top-label">Other link settings</span>';
                                $out .= $this->getStdInputsFieldStart();
                                    $out .= '<input type="checkbox" name="abar_link_use" '.$this->attrChecked($this->_general['abar_link_use']).' /> Use link';       
                                    $out .= $this->getBR();
                                    $out .= '<input type="checkbox" name="abar_link_new_tab" '.$this->attrChecked($this->_general['abar_link_new_tab']).' /> Open link in new window/tab';
                                $out .= $this->getStdInputsFieldEnd();
                                                        
                                $out .= '<div class="dc-cms-help-note-box">';
                                    $out .= 'Link will be ignored if announcement bar content is displayed.';
                                $out .= '</div>';                                 
                                
                            $out .= '</td></tr>';                                                                  
                
                            $out .= '</tbody>';
                        $out .= '</table>'; 
                        
                    $out .= $this->getPanelSectionHead('Content font settings', 50);   
                
                        $out .= '<table class="dc-cms-table-standard">';                     
                            $out .= '<tbody>';    
                            
                                $out .= '<tr><td><span class="dc-cms-left-marked-title">Configure font</span></td><td>';      
                            
                                $out .= '<span class="dc-cms-control-top-label-nomargin">Font family</span>';
                                $browser_fonts = array(
                                    'Arial', 'Helvetica', 'Times', 'Times New Roman', 'Courier', 
                                    'Courier New', 'Verdana', 'Tahoma', 'Arial Black', 'Comic Sans MS', 'Trebuchet MS', 'Impact', 'Avant Garde',
                                    'Georgia', 'Palatino', 'Bookman', 'Garamond', 'Century Schoolbook');
                                $out .= '<select class="dc-cms-control-300" name="abar_font">';
                                    foreach($browser_fonts as $font)
                                    {
                                        $out .= '<option value="'.$font.'" '.$this->attrSelected($this->_general['abar_font'] == $font).'>'.$font.'</option>';
                                    }
                                $out .= '</select>';                            
                            
                                $out .= '<span class="dc-cms-control-top-label">Font size</span>';                    
                                $out .= $this->getCtrlInputInt('abar_fsize', $this->_general['abar_fsize'], 1);                                           

                                $out .= '<span class="dc-cms-control-top-label">Line height</span>';                    
                                $out .= $this->getCtrlInputInt('abar_lheight', $this->_general['abar_lheight'], 1);
                                
                                $out .= '<span class="dc-cms-control-top-label">Font style</span>';
                                $out .= '<select name="abar_fstyle" class="dc-cms-control-100">';
                                    $val = $this->_general['abar_fstyle'];
                                    $out .= '<option value="normal" '.$this->attrSelected($val == 'normal').'>Normal</option>';
                                    $out .= '<option value="italic" '.$this->attrSelected($val == 'italic').'>Italic</option>';
                                $out .= '</select>';                                   
                                                                       
                                $out .= '<span class="dc-cms-control-top-label">Text align</span>';
                                $out .= '<select name="abar_align" class="dc-cms-control-100">';
                                    $val = $this->_general['abar_align'];
                                    $out .= '<option value="left" '.$this->attrSelected($val == 'left').'>Left</option>';
                                    $out .= '<option value="center" '.$this->attrSelected($val == 'center').'>Center</option>';
                                    $out .= '<option value="right" '.$this->attrSelected($val == 'right').'>Right</option>';
                                $out .= '</select>';                                       
                                
                                $out .= '<span class="dc-cms-control-top-label">Text color</span>';  
                                $out .= '<input type="text" class="dc-color-picker" name="abar_color" value="'.$this->_general['abar_color'].'" />';  
                                
                                $out .= '<span class="dc-cms-control-top-label">Anchor color</span>';
                                $out .= '<input type="text" class="dc-color-picker" name="abar_a_color" value="'.$this->_general['abar_a_color'].'" />';  
                                
                                $out .= '<span class="dc-cms-control-top-label">Anchor hover color</span>';
                                $out .= '<input type="text" class="dc-color-picker" name="abar_a_hcolor" value="'.$this->_general['abar_a_hcolor'].'" />';  
                                
                                $out .= '<span class="dc-cms-control-top-label">Other settings</span>';
                                $out .= $this->getStdInputsFieldStart();
                                    $out .= '<input type="checkbox" name="abar_font_use" '.$this->attrChecked($this->_general['abar_font_use']).' /> Use font family';       
                                    $out .= $this->getBR();
                                    $out .= '<input type="checkbox" name="abar_fsize_use" '.$this->attrChecked($this->_general['abar_fsize_use']).' /> Use font size';       
                                    $out .= $this->getBR();
                                    $out .= '<input type="checkbox" name="abar_lheight_use" '.$this->attrChecked($this->_general['abar_lheight_use']).' /> Use line height';       
                                    $out .= $this->getBR();                                    
                                    $out .= '<input type="checkbox" name="abar_fstyle_use" '.$this->attrChecked($this->_general['abar_fstyle_use']).' /> Use font style';       
                                    $out .= $this->getBR(); 
                                    $out .= '<input type="checkbox" name="abar_color_use" '.$this->attrChecked($this->_general['abar_color_use']).' /> Use text color';       
                                    $out .= $this->getBR();
                                    $out .= '<input type="checkbox" name="abar_a_color_use" '.$this->attrChecked($this->_general['abar_a_color_use']).' /> Use anchor color';
                                    $out .= $this->getBR();
                                    $out .= '<input type="checkbox" name="abar_a_hcolor_use" '.$this->attrChecked($this->_general['abar_a_hcolor_use']).' /> Use anchor hover color'; 
                                $out .= $this->getStdInputsFieldEnd();  
                                            
                            $out .= '</td></tr>';                                               
                                                                       
                            $out .= '</tbody>';
                        $out .= '</table>';
                        
                    $out .= $this->getPanelSectionHead('Border settings', 50);   
                
                        $out .= '<table class="dc-cms-table-standard">';                     
                            $out .= '<tbody>';    
                            
                                $out .= '<tr><td><span class="dc-cms-left-marked-title">Configure border</span></td><td>';      
                                
                                    $out .= '<span class="dc-cms-control-top-label-nomargin">Display options</span>'; 
                                    $out .= $this->getStdInputsFieldStart();
                                        $out .= '<input type="checkbox" name="abar_border_display" '.$this->attrChecked($this->_general['abar_border_display']).' /> Display border';  
                                    $out .= $this->getStdInputsFieldEnd();                            
                                
                                    $out .= '<span class="dc-cms-control-top-label">Border width</span>';                    
                                    $out .= $this->getCtrlInputInt('abar_border_width', $this->_general['abar_border_width'], 0);                                           

                                    $out .= '<span class="dc-cms-control-top-label">Border color</span>';                    
                                    $out .= '<input type="text" class="dc-color-picker" name="abar_border_color" value="'.$this->_general['abar_border_color'].'" />';                                                                        
                                              
                                    $out .= '<span class="dc-cms-control-top-label">Border style</span>';
                                    $out .= '<select name="abar_border_style" class="dc-cms-control-100">';
                                        $val = $this->_general['abar_border_style'];
                                        $out .= '<option value="solid" '.$this->attrSelected($val == 'solid').'>Solid</option>';
                                        $out .= '<option value="dotted" '.$this->attrSelected($val == 'dotted').'>Dotted</option>';
                                        $out .= '<option value="dashed" '.$this->attrSelected($val == 'dashed').'>Dashed</option>';
                                    $out .= '</select>';                                             
                                                
                                $out .= '</td></tr>';                                               
                                                                       
                            $out .= '</tbody>';
                        $out .= '</table>';    
                    
                    // close button    
                    $out .= $this->getPanelSectionHead('Close button settings', 50);  
                    
                        $out .= '<table class="dc-cms-table-standard">';                     
                            $out .= '<tbody>';    
                            
                                $out .= '<tr><td><span class="dc-cms-left-marked-title">Configure close button</span></td><td>';                                                    
                        
                                    $out .= '<span class="dc-cms-control-top-label-nomargin">Display options</span>'; 
                                    $out .= $this->getStdInputsFieldStart();
                                        
                                        $out .= '<input type="checkbox" name="abar_cbtn_display" '.$this->attrChecked($this->_general['abar_cbtn_display']).' /> Display close button'; 
                                        $out .= $this->getBookHelp(array('text' => 'If checked a small <span class="dc-cms-marked-span">close button</span> will be added. After clicking on this button the announcement bar will be closed and not displayed in current browser session.'));

                                    $out .= $this->getStdInputsFieldEnd();                        
                        
                                    $out .= '<span class="dc-cms-control-top-label">Size in pixels</span>';                    
                                    $out .= $this->getCtrlInputInt('abar_cbtn_size', $this->_general['abar_cbtn_size'], 0);                             
                        
                                    $out .= '<span class="dc-cms-control-top-label">Close button background color</span>';
                                    $out .= '<input type="text" class="dc-color-picker" name="abar_cbtn_bg_color" value="'.$this->_general['abar_cbtn_bg_color'].'" />';                            

                                    $out .= '<span class="dc-cms-control-top-label">Close button background hover color</span>';
                                    $out .= '<input type="text" class="dc-color-picker" name="abar_cbtn_bg_hcolor" value="'.$this->_general['abar_cbtn_bg_hcolor'].'" />';  
                        
                                    $out .= '<span class="dc-cms-control-top-label">Image URL</span>'; 
                                    $out .= '<input type="text" class="dc-cms-control-600" name="abar_cbtn_image" value="'.$this->_general['abar_cbtn_image'].'" id="dc_id_abar_cbtn_image" /> ';                  
                                
                                    $out .= $this->getImagePreviewBox(array('path' => $this->_general['abar_cbtn_image'], 'width' => 120, 'height' => 60, 'info' => true));  
                                    
                                    $out .= '<div class="dc-cms-btn-frame">';
                                        $out .= '<input class="dc-cms-submit-image-btn" type="submit" name="dc_id_abar_cbtn_image" value="'.__('Load image', CMS_TXT_DOMAIN).'" /> ';  
                                    $out .= '</div>';                           
                        
                                $out .= '</td></tr>';                                               
                                                                       
                            $out .= '</tbody>';
                        $out .= '</table>';                            
                        
                    // background
                    $out .= $this->getPanelSectionHead('Background settings', 50);   
                
                        $out .= '<table class="dc-cms-table-standard">';                     
                            $out .= '<tbody>';    
                            
                                $out .= '<tr><td><span class="dc-cms-left-marked-title">Configure background</span></td><td>';      
                                  
                                    $out .= $this->getStdInputsFieldStart();
                                        $out .= '<input type="checkbox" name="abar_bg_image_display" '.$this->attrChecked($this->_general['abar_bg_image_display']).' /> Display background image';     
                                        $out .= $this->getBR();
                                        $out .= '<input type="checkbox" name="abar_bg_color_use" '.$this->attrChecked($this->_general['abar_bg_color_use']).' /> Use background color';  
                                    $out .= $this->getStdInputsFieldEnd();
                                
                                    $out .= '<span class="dc-cms-control-top-label">URL</span>'; 
                                    $out .= '<input type="text" class="dc-cms-control-600" name="abar_bg_image" value="'.$this->_general['abar_bg_image'].'" id="dc_id_abar_bg_image" /> ';                  
                                
                                    $out .= $this->getImagePreviewBox(array('path' => $this->_general['abar_bg_image'], 'width' => 220, 'height' => 120, 'info' => true));  
                                    
                                    $out .= '<div class="dc-cms-btn-frame">';
                                        $out .= '<input class="dc-cms-submit-image-btn" type="submit" name="dc_id_abar_bg_image" value="'.__('Load image', CMS_TXT_DOMAIN).'" /> ';  
                                    $out .= '</div>';                                     
                                    
                                    $out .= $this->getStdWrapperStart(array('top' => 30));
                                    
                                        $out .= $this->getStdColumnStart(array('width'=>150)); 
                                            
                                                $out .= '<span class="dc-cms-control-top-label-nomargin">Background X align</span>';   
                                                $out .= '<select name="abar_bg_pos_x" class="dc-cms-control-100">';
                                                    $out .= '<option value="left" '.$this->attrSelected($this->_general['abar_bg_pos_x'] == 'left').'>Left</option>';
                                                    $out .= '<option value="center" '.$this->attrSelected($this->_general['abar_bg_pos_x'] == 'center').'>Center</option>';
                                                    $out .= '<option value="right" '.$this->attrSelected($this->_general['abar_bg_pos_x'] == 'right').'>Right</option>';
                                                $out .= '</select>'; 
                                                                                
                                                $out .= '<span class="dc-cms-control-top-label">Background Y align</span>';
                                                $out .= '<select name="abar_bg_pos_y" class="dc-cms-control-100">';
                                                    $out .= '<option value="top" '.$this->attrSelected($this->_general['abar_bg_pos_y'] == 'top').'>Top</option>';
                                                    $out .= '<option value="center" '.$this->attrSelected($this->_general['abar_bg_pos_y'] == 'center').'>Center</option>';
                                                    $out .= '<option value="bottom" '.$this->attrSelected($this->_general['abar_bg_pos_y'] == 'bottom').'>Bottom</option>';
                                                $out .= '</select>';
                                                
                                                
                                                $out .= '<span class="dc-cms-control-top-label">Background X position in pixels</span>';
                                                $out .= $this->getCtrlInputInt('abar_bg_pos_x_px', $this->_general['abar_bg_pos_x_px']);                        
                  
                                                $out .= '<span class="dc-cms-control-top-label">Background Y position in pixels</span>';
                                                $out .= $this->getCtrlInputInt('abar_bg_pos_y_px', $this->_general['abar_bg_pos_y_px']);
                                                   
                                                               
                                        $out .= $this->getStdColumnEnd();                                                                                  
                     
                                        $out .= $this->getStdColumnStart(array('width'=>150));
                                                $out .= '<span class="dc-cms-control-top-label-nomargin">Background color</span>';
                                                $out .= '<input type="text" class="dc-color-picker" value="'.$this->_general['abar_bg_color'].'" name="abar_bg_color" />';                                
                                        $out .= $this->getStdColumnEnd();                       
                     
                                        $out .= $this->getStdColumnStart(array('width'=>150));
                                            $out .= '<span class="dc-cms-control-top-label-nomargin">Repeat mode</span>';
                                            $out .= $this->getStdInputsFieldStart();   
                                                $val = $this->_general['abar_bg_repeat'];
                                                $out .= '<input type="radio" '.$this->attrChecked($val == 'repeat').' value="repeat" name="abar_bg_repeat" /> Repeat';
                                                $out .= $this->getBR();         
                                                $out .= '<input type="radio" '.$this->attrChecked($val == 'repeat-x').' value="repeat-x" name="abar_bg_repeat" /> Repeat X';
                                                $out .= $this->getBR();
                                                $out .= '<input type="radio" '.$this->attrChecked($val == 'repeat-y').' value="repeat-y" name="abar_bg_repeat" /> Repeat Y';
                                                $out .= $this->getBR();
                                                $out .= '<input type="radio" '.$this->attrChecked($val == 'no-repeat').' value="no-repeat" name="abar_bg_repeat" /> No repeat';    
                                            $out .= $this->getStdInputsFieldEnd();
                                        $out .= $this->getStdColumnEnd();                          
                                        
                                        $out .= $this->getClearBoth();                   
                                    $out .= $this->getStdWrapperEnd();
                                      
                                    $out .= '<span class="dc-cms-control-top-label">Other settings</span>';
                                    $out .= $this->getStdInputsFieldStart();                                              
                                        $out .= '<input type="checkbox" name="abar_bg_pos_x_px_use" '.$this->attrChecked($this->_general['abar_bg_pos_x_px_use']).' /> Use pixels X position';
                                        $out .= $this->getBR(); 
                                        $out .= '<input type="checkbox" name="abar_bg_pos_y_px_use" '.$this->attrChecked($this->_general['abar_bg_pos_y_px_use']).' /> Use pixels Y position';                    
                                    $out .= $this->getStdInputsFieldEnd();                                                                              
                                            
                                $out .= '</td></tr>';                                               
                                                                       
                            $out .= '</tbody>';
                        $out .= '</table>';                                                                                      
                    
                    $out .= $this->getSubmitBottomPanel('dc-general-save-abar-opt');                                          
                $out .= '</form>';
         
            $out .= $this->getPanelEnd();                       
        }
        
        if($echo) { echo $out; } else { return $out; }                                 
    }
    
    public function renderExportCMS($echo=false)
    {
        $out = '';
        
        if($this->isSubPage('dc-subpage-export-opt'))
        {
            $out .= $this->getPanelBegin('Export / import theme CMS settings');
         
                $out .= '<form action="#" method="post">';                                                            
                        
                    $out .= '<div class="dc-cms-submit-panel-top-empty">';                         
                        $out .= $this->getPanelProcessInfo();                            
                    $out .= '</div>';                              
                        
                    // Import
                    $out .= $this->getPanelSectionHead('Import settings');     
                    
                        $out .= '<table class="dc-cms-table-standard">';                     
                            $out .= '<tbody>';                                       

                            $out .= '<tr><td><span class="dc-cms-left-marked-title">Import</span></td><td>';                            
                            
                                $out .= '<span class="dc-cms-control-top-label-nomargin">Uploaded ZIP archive URL</span>'; 
                                $out .= '<input type="text" class="dc-cms-control-600" name="import_cms_settings_file" value="" id="dc_id_general_import_cms_file" /> ';
                                $out .= '<div class="dc-cms-btn-frame">';
                                    $out .= '<input class="dc-cms-submit-image-btn" type="submit" name="dc_id_general_import_cms_file" value="Load ZIP archive file with CMS settings" /> ';
                                    $out .= '<input class="dc-cms-submit-btn" onclick="return confirm(\'Are you sure? All your CMS settings will be changed!\')" name="dc-general-import-cms-settings" type="submit" value="Apply settings" /> ';    
                                $out .= '</div>';                              
                           
                                $log  = '';
                                
                                if(isset($_POST['dc-general-import-cms-settings']))
                                {
                                    if(trim($_POST['import_cms_settings_file']) == '')
                                    {
                                        $log .= 'Sorry, but the ZIP archive file URL was empty.';
                                    } else
                                    {
                                        $cms_manager = new DCC_ThemeCMSSettingsManager(); 
                                        $zip_file_path = dcf_getRelativePath($_POST['import_cms_settings_file']);
                                        $extract_path = CMS_TEMPLATEPATH.'/cms/temp/extract';
                                        $result = $cms_manager->importDataFromZip(array('zip_file_path' => $zip_file_path, 'extract_path' => $extract_path));                                           
                                        
                                        $log = $cms_manager->_log; 
                                        if($result)
                                        {
                                            $log .= '<br />';
                                            $log .= 'Theme options updated successfully.';
                                        } else
                                        {
                                            $log .= '<br />';
                                            $log .= 'Sorry, but an error occurred while updating the settings.';                                                                                    
                                        }                                       
                                        
                                    }
                                }          
                                
                                if(trim($log) != '')
                                {
                                    $out .= '<div class="dc-cms-help-note-box">';
                                        $out .= $log;                                 
                                    $out .= '</div>';
                                }
                            
                            $out .= '</td></tr>';                             
                
                            $out .= '</tbody>';
                        $out .= '</table>';     

                    // Export                                                                                                                        
                    $out .= $this->getPanelSectionHead('Export settings', 50);     
                                                               
                        $out .= '<table class="dc-cms-table-standard">';                     
                            $out .= '<tbody>';                      
                            
                            $out .= '<tr><td><span class="dc-cms-left-marked-title">Export</span></td><td>';

                                if(isset($_POST['dc-general-export-cms-settings-btn']))
                                {
                                    $year = date('Y');
                                    $month = date('F');
                                    $day = date('d');
                                    
                                    $clear_twitter = isset($_POST['dc-general-export-st-include-twitter']) ? false : true;
                                    $clear_tracking = isset($_POST['dc-general-export-st-include-tracking']) ? false : true;
                                    
                                    $filename = CMS_THEME_NAME_SLUG.'_cms_settings_'.$day.'-'.$month.'-'.$year.'.zip';
                                    $cms_manager = new DCC_ThemeCMSSettingsManager();
                                    $result = $cms_manager->exportDataToZip(
                                        array(
                                            'export_path' => CMS_TEMPLATEPATH.'/cms/export', 
                                            'filename' => $filename,
                                            'clear_twitter' => $clear_twitter,
                                            'clear_tracking' => $clear_tracking
                                            ));
                                   
                                   if($result === true)
                                   {         
                                        $out .= 'Click <a href="'.CMS_THEME_URL.'/cms/export/'.$filename.'" >here</a> to save ZIP archive file with your exported CMS settings.';
                                   } else
                                   {
                                        $out .= 'Sorry, but there was some problem with exporting <span class="dc-cms-marked-span">CMS setting</span> to ZIP file.';
                                   }
                                   
                                   $out .= $this->getEmptySpaceField(20);
                                }
                               
                                $out .= '<span class="dc-cms-control-top-label-nomargin">Export settings</span>';
                                $out .= $this->getStdInputsFieldStart();                                              
                                    $out .= '<input type="checkbox" name="dc-general-export-st-include-twitter" '.$this->attrChecked(true).' /> Include Twitter data';
                                    $out .= $this->getBR(); 
                                    $out .= '<input type="checkbox" name="dc-general-export-st-include-tracking" '.$this->attrChecked(true).' /> Include tracking code data';                    
                                $out .= $this->getStdInputsFieldEnd();                                  
                                
                                $out .= $this->getEmptySpaceField(20);
                                $out .= '<div class="dc-cms-btn-frame-nomargin">';                                    
                                    $out .= '<input class="dc-cms-submit-btn" name="dc-general-export-cms-settings-btn" type="submit" value="Create export file" /> ';    
                                $out .= '</div>';                                
                                    
                            $out .= '</td></tr>';                             
                
                            $out .= '</tbody>';
                        $out .= '</table>';     
                                                
                        $out .= '<div class="dc-cms-submit-panel-bottom-empty">';
                        $out .= '</div>';                        
                                                       
                $out .= '</form>';
         
            $out .= $this->getPanelEnd();                       
        }
        
        if($echo) { echo $out; } else { return $out; }          
    }
    
    public function getExportedData($args=array())
    {
        $def = array(
            'clear_twitter' => false,
            'clear_tracking' => false
        );
        $args = $this->combineArgs($def, $args);
        
        $export = array(
            'version' => '1.0',
            'name' => 'DCC_ControlPanelGeneral',
            'data' => array()
        );
                               
        $obj_general_opt = new DCC_ExportDataCMSObject();        
        $obj_general_opt->name = '_general';
        $obj_general_opt->version = '1.0'; 
        
        $opt = $this->_general;
        if($args['clear_twitter'])
        {
            $opt['twitter_consumer_key'] = '';
            $opt['twitter_consumer_secret'] = '';
            $opt['twitter_token_key'] = '';
            $opt['twitter_token_secret'] = '';               
        }
        if($args['clear_tracking'])
        {
            $opt['tracking_header_use'] = false;
            $opt['tracking_footer_use'] = false;
            $opt['tracking_header_code'] = '';
            $opt['tracking_footer_code'] = '';             
        }
        $obj_general_opt->data = serialize($opt);

        $obj_sidlist_opt = new DCC_ExportDataCMSObject();        
        $obj_sidlist_opt->name = '_sidlist';
        $obj_sidlist_opt->version = '1.0';
        $obj_sidlist_opt->data = serialize($this->_sidlist);  
        
        array_push($export['data'], $obj_general_opt);
        array_push($export['data'], $obj_sidlist_opt);
        
        return $export;  
    }
    
    public function setImportedData($import)    
    {
        $result = array('status' => false, 'message' => 'Error');  
        
        if($import['version'] == '1.0' and $import['name'] == 'DCC_ControlPanelGeneral')
        {
            $obj_general_opt = null;
            $obj_sidlist_opt = null;
            
            if(is_array($import['data']))
            {
                foreach($import['data'] as $obj)
                {
                    switch($obj->name)
                    {
                        case '_general':
                        {
                            if($obj->version == '1.0')
                            {
                                $obj_general_opt = $obj;                                                                
                            }    
                        } break;
                        
                        case '_sidlist':
                        {
                            if($obj->version == '1.0')
                            {
                                $obj_sidlist_opt = $obj;
                            }                                
                        } break;                        
                    }
                }
            } 
            
            if(($obj_general_opt !== null) and 
               ($obj_sidlist_opt !== null))
            {
                $this->_general = unserialize($obj_general_opt->data);
                update_option($this->_DBIDOPT_GENERAL, $this->_general);
                
                $this->_sidlist = unserialize($obj_sidlist_opt->data);
                update_option($this->_DBIDOPT_SIDLIST, $this->_sidlist);                       
            
                $result['status'] = true;
                $result['message'] = 'OK - General options updated successfully';
            } else
            {
                $result['message'] = 'Error';
            }
        }
        
        return $result;
    }
    
    public function renderMiscCMS($echo=false)
    {
        $out = '';
        
        if($this->isSubPage('dc-subpage-misc-opt'))
        {            
            $out .= $this->getPanelBegin('Miscellaneous settings');
         
                $out .= '<form action="#" method="post">'; 
                
                    $out .= $this->getSubmitTopPanel('dc-general-save-misc-opt');                                                              
                    $out .= $this->getPanelSectionHead('Favicon');
                    
                    $out .= '<table class="dc-cms-table-standard">';
                        $out .= '<tbody>';  
                    
                        // site favicon url
                        $out .= '<tr><td><span class="dc-cms-left-marked-title">Site favicon image</span></td><td>';
                            $out .= '<input type="text" class="dc-cms-control-600" name="favicon_url" value="'.$this->_general['favicon_url'].'" id="dc_id_favicon_url" /> ';
                            $out .= '<div class="dc-cms-btn-frame">';
                                $out .= '<input class="dc-cms-submit-image-btn" type="submit" name="dc_id_favicon_url" value="Load image"> ';  
                            $out .= '</div>';
                            
                            $out .= $this->getImagePreviewBox(array('path' => $this->_general['favicon_url'], 'width' => 80, 'height' => 80, 'icon' => false)); 
                            
                            // site favicon use
                            $out .= $this->getEmptySpaceField(20);
                            $out .= '<input type="checkbox" name="favicon_display" '.$this->attrChecked($this->_general['favicon_display']).' /> Use favicon';
                            $out .= $this->getBookHelp(array('text' => 'If checked, line with favicon will be placed in site header - selected favicon will be displayed in the browser.'));
                        $out .= '</td></tr>';
                    
                        // site icon iphone-ipod url
                        $out .= '<tr><td><span class="dc-cms-left-marked-title">Site iPhone and iPod icon image (default, 60x60)</span></td><td>';
                            $out .= '<input type="text" class="dc-cms-control-600" name="icon_iphone_url" value="'.$this->_general['icon_iphone_url'].'" id="dc_id_icon_iphone_url" /> ';
                            $out .= '<div class="dc-cms-btn-frame">';
                                $out .= '<input class="dc-cms-submit-image-btn" type="submit" name="dc_id_icon_iphone_url" value="Load image"> ';  
                            $out .= '</div>';
                            
                            $out .= $this->getImagePreviewBox(array('path' => $this->_general['icon_iphone_url'], 'width' => 80, 'height' => 80, 'icon' => false)); 
                                                        
                            // site icon iphone-ipod use
                            $out .= $this->getEmptySpaceField(20);
                            $out .= '<input type="checkbox" name="icon_iphone_display" '.$this->attrChecked($this->_general['icon_iphone_display']).' /> Use iPhone and iPod icon';
                        $out .= '</td></tr>';
                        
                        
                        
                        // site icon ipad url
                        $out .= '<tr><td><span class="dc-cms-left-marked-title">Site iPad icon image</span></td><td>';
                            $out .= '<input type="text" class="dc-cms-control-600" name="icon_ipad_url" value="'.$this->_general['icon_ipad_url'].'" id="dc_id_icon_ipad_url" /> ';
                            $out .= '<div class="dc-cms-btn-frame">';
                                $out .= '<input class="dc-cms-submit-image-btn" type="submit" name="dc_id_icon_ipad_url" value="Load image"> ';  
                            $out .= '</div>';
                            
                            $out .= $this->getImagePreviewBox(array('path' => $this->_general['icon_ipad_url'], 'width' => 85, 'height' => 85, 'icon' => false)); 
                            
                            // site icon ipad size
                            $out .= $this->getEmptySpaceField(20);
                            $out .= '<span class="dc-cms-control-top-label">iPad icon size</span>';
                            $out .= $this->getCtrlInputInt('icon_ipad_size', $this->_general['icon_ipad_size'], 1);
                            
                            // site icon ipad use
                            $out .= $this->getEmptySpaceField(20);
                            $out .= '<input type="checkbox" name="icon_ipad_display" '.$this->attrChecked($this->_general['icon_ipad_display']).' /> Use iPad icon';
                        $out .= '</td></tr>';
                        
                        
                        
                        // site icon iphone-ipod retina url
                        $out .= '<tr><td><span class="dc-cms-left-marked-title">Site iPhone and iPod (Retina) icon image</span></td><td>';
                            $out .= '<input type="text" class="dc-cms-control-600" name="icon_iphone_ret_url" value="'.$this->_general['icon_iphone_ret_url'].'" id="dc_id_icon_iphone_ret_url" /> ';
                            $out .= '<div class="dc-cms-btn-frame">';
                                $out .= '<input class="dc-cms-submit-image-btn" type="submit" name="dc_id_icon_iphone_ret_url" value="Load image"> ';  
                            $out .= '</div>';
                            
                            $out .= $this->getImagePreviewBox(array('path' => $this->_general['icon_iphone_ret_url'], 'width' => 130, 'height' => 130, 'icon' => false)); 
                            
                            // site icon iphone-ipod retina size
                            $out .= $this->getEmptySpaceField(20);
                            $out .= '<span class="dc-cms-control-top-label">iPhone and iPod (Retina) icon size</span>';                    
                            $out .= $this->getCtrlInputInt('icon_iphone_ret_size', $this->_general['icon_iphone_ret_size'], 1);
                            
                            // site icon iphone-ipod retina use
                            $out .= $this->getEmptySpaceField(20);
                            $out .= '<input type="checkbox" name="icon_iphone_ret_display" '.$this->attrChecked($this->_general['icon_iphone_ret_display']).' /> Use iPhone and iPod (Retina) icon';
                        $out .= '</td></tr>';
                        
                        
                        
                        // site icon ipad retina url
                        $out .= '<tr><td><span class="dc-cms-left-marked-title">Site iPad (Retina) icon image</span></td><td>';
                            $out .= '<input type="text" class="dc-cms-control-600" name="icon_ipad_ret_url" value="'.$this->_general['icon_ipad_ret_url'].'" id="dc_id_icon_ipad_ret_url" /> ';
                            $out .= '<div class="dc-cms-btn-frame">';
                                $out .= '<input class="dc-cms-submit-image-btn" type="submit" name="dc_id_icon_ipad_ret_url" value="Load image"> ';  
                            $out .= '</div>';
                            
                            $out .= $this->getImagePreviewBox(array('path' => $this->_general['icon_ipad_ret_url'], 'width' => 160, 'height' => 160, 'icon' => false)); 
                            
                            // site icon ipad retina size
                            $out .= $this->getEmptySpaceField(20);
                            $out .= '<span class="dc-cms-control-top-label">iPad (Retina) icon size</span>';
                            $out .= $this->getCtrlInputInt('icon_ipad_ret_size', $this->_general['icon_ipad_ret_size'], 1);
                            
                            // site icon ipad retina use
                            $out .= $this->getEmptySpaceField(20);
                            $out .= '<input type="checkbox" name="icon_ipad_ret_display" '.$this->attrChecked($this->_general['icon_ipad_ret_display']).' /> Use iPad (Retina) icon';
                        $out .= '</td></tr>';                    
                    
                        $out .= '</tbody>';
                    $out .= '</table>';                                          
                    
                    $out .= $this->getPanelSectionHead('Header extra information table', 50);
                    $out .= '<table class="dc-cms-table-standard">';                           
                        $out .= '<tbody>';
                    
                        $out .= '<tr><td><span class="dc-cms-left-marked-title">Add your header information</span></td><td>';   
                                                    
                            $out .= '<input type="checkbox" name="header_infobox_display" '.$this->attrChecked($this->_general['header_infobox_display']).' /> Display';
                        
                            $out .= '<div class="dc-cms-edit-header-info-list-wrapper">';
                            
                                $out .= '<div class="dc-cms-edit-header-info-list-left-column">';
                                    $out .= '<ul class="dc-cms-edit-header-info-list">';
                                    
                                        $counter = 0;
                                        foreach($this->_general['header_infobox_list'] as $entry)
                                        {
                                            $out .= $this->getHeaderInfoBoxEntryHtml($counter, $entry);
                                            $counter++;
                                        }
                                    
                                    $out .= '</ul>';                                                                            
                                $out .= '</div>';
                            
                                $out .= '<div class="dc-cms-edit-header-info-list-right-column">';
                                    $out .= '<span class="dc-cms-action-name">dc_add_header_info_bar</span>';
                                    $out .= '<input class="dc-cms-submit-btn" type="button" value="Add new entry" />';                                                                    
                                $out .= '</div>';
                            
                                $out .= '<div class="dc-cms-clear"></div>'; 
                            $out .= '</div>';                      

                            $out .= '</tbody>';
                    $out .= '</table>'; 
                    
                    
                    
                    $out .= $this->getPanelSectionHead('Category archive page', 50);                                          
                    $out .= '<table class="dc-cms-table-standard">';   
                        $out .= '<tbody>';                        
                 
                        // Categories
                        $out .= '<tr><td><span class="dc-cms-left-marked-title">Category page layout</span></td><td>';
                        
                            $out .= '<span class="dc-cms-control-top-label-nomargin">Select category page layout</span>';                    
                            $out .= '<div class="dc-cms-page-layout-box">';
                            
                                $out .= '<div class="item">';
                                    $out .= '<div class="layout-image-both-sidebars">Both sidebars</div>';                    
                                    $out .= '<input type="radio" name="layout_category_page" '.$this->attrChecked($this->_general['layout_category_page'] == CMS_PAGE_LAYOUT_BOTH_SIDEBARS).' value="'.CMS_PAGE_LAYOUT_BOTH_SIDEBARS.'" />';
                                $out .= '</div>';  
                                
                                $out .= '<div class="item">';
                                    $out .= '<div class="layout-image-left-sidebar">Left sidebar</div>';                    
                                    $out .= '<input type="radio" name="layout_category_page" '.$this->attrChecked($this->_general['layout_category_page'] == CMS_PAGE_LAYOUT_LEFT_SIDEBAR).' value="'.CMS_PAGE_LAYOUT_LEFT_SIDEBAR.'" />';
                                $out .= '</div>';                                             

                                $out .= '<div class="item">';
                                    $out .= '<div class="layout-image-right-sidebar">Right sidebar</div>';                    
                                    $out .= '<input type="radio" name="layout_category_page" '.$this->attrChecked($this->_general['layout_category_page'] == CMS_PAGE_LAYOUT_RIGHT_SIDEBAR).' value="'.CMS_PAGE_LAYOUT_RIGHT_SIDEBAR.'" />';
                                $out .= '</div>'; 
                                
                                $out .= '<div class="item">';
                                    $out .= '<div class="layout-image-full-width">Full width</div>';                    
                                    $out .= '<input type="radio" name="layout_category_page" '.$this->attrChecked($this->_general['layout_category_page'] == CMS_PAGE_LAYOUT_FULL_WIDTH).' value="'.CMS_PAGE_LAYOUT_FULL_WIDTH.'" />';
                                $out .= '</div>';                         
                                
                                $out .= $this->getClearBoth();
                                
                            $out .= '</div>';      

                        $out .= '</td></tr>';                                

                        $out .= '<tr><td><span class="dc-cms-left-marked-title">Posts per page</span></td><td>';                                
                            
                            $out .= '<span class="dc-cms-control-top-label-nomargin">Number of posts to display on category page</span>';                    
                            $out .= $this->getCtrlInputInt('archive_category_per_page', $this->_general['archive_category_per_page'], 1);                      
                                             
                        $out .= '</td></tr>'; 
                 
                        $out .= '</tbody>';
                    $out .= '</table>'; 
                 
                    $out .= $this->getPanelSectionHead('Other archive pages', 50);                                          
                    $out .= '<table class="dc-cms-table-standard">'; 
                        $out .= '<tbody>';                      
                 
                        // Date, Author and Tags
                        $out .= '<tr><td><span class="dc-cms-left-marked-title">Date, author and tags page layout</span></td><td>';    
                        
                            $out .= '<span class="dc-cms-control-top-label-nomargin">Select archive page layout (date, tags and author page)</span>';                    
                            $out .= '<div class="dc-cms-page-layout-box">';
                            
                                $out .= '<div class="item">';
                                    $out .= '<div class="layout-image-both-sidebars">Both sidebars</div>';                    
                                    $out .= '<input type="radio" name="layout_archive_page" '.$this->attrChecked($this->_general['layout_archive_page'] == CMS_PAGE_LAYOUT_BOTH_SIDEBARS).' value="'.CMS_PAGE_LAYOUT_BOTH_SIDEBARS.'" />';
                                $out .= '</div>';  
                                
                                $out .= '<div class="item">';
                                    $out .= '<div class="layout-image-left-sidebar">Left sidebar</div>';                    
                                    $out .= '<input type="radio" name="layout_archive_page" '.$this->attrChecked($this->_general['layout_archive_page'] == CMS_PAGE_LAYOUT_LEFT_SIDEBAR).' value="'.CMS_PAGE_LAYOUT_LEFT_SIDEBAR.'" />';
                                $out .= '</div>';                                             

                                $out .= '<div class="item">';
                                    $out .= '<div class="layout-image-right-sidebar">Right sidebar</div>';                    
                                    $out .= '<input type="radio" name="layout_archive_page" '.$this->attrChecked($this->_general['layout_archive_page'] == CMS_PAGE_LAYOUT_RIGHT_SIDEBAR).' value="'.CMS_PAGE_LAYOUT_RIGHT_SIDEBAR.'" />';
                                $out .= '</div>'; 
                                
                                $out .= '<div class="item">';
                                    $out .= '<div class="layout-image-full-width">Full width</div>';                    
                                    $out .= '<input type="radio" name="layout_archive_page" '.$this->attrChecked($this->_general['layout_archive_page'] == CMS_PAGE_LAYOUT_FULL_WIDTH).' value="'.CMS_PAGE_LAYOUT_FULL_WIDTH.'" />';
                                $out .= '</div>';                         
                                
                                $out .= $this->getClearBoth();                                                                
                                        
                            $out .= '</div>'; 
                            
                        $out .= '</td></tr>';                                

                        $out .= '<tr><td><span class="dc-cms-left-marked-title">Posts per page</span></td><td>';                                       
                        
                            $out .= '<span class="dc-cms-control-top-label-nomargin">Number of posts to display on date, tag and author archive page</span>';                    
                            $out .= $this->getCtrlInputInt('archive_per_page', $this->_general['archive_per_page'], 1);                                          
                                         
                        $out .= '</td></tr>'; 
                        
                        $out .= '</tbody>';
                    $out .= '</table>';                                
                        
                    $out .= $this->getPanelSectionHead('404 page', 50);                                          
                    $out .= '<table class="dc-cms-table-standard">';                              
                        $out .= '<tbody>';
                        
                        // 404 page layout
                        $out .= '<tr><td><span class="dc-cms-left-marked-title">404 error page layout</span></td><td>';    
                        
                            $out .= '<span class="dc-cms-control-top-label-nomargin">Select 404 page layout</span>';                    
                            $out .= '<div class="dc-cms-page-layout-box">';
                            
                                $out .= '<div class="item">';
                                    $out .= '<div class="layout-image-both-sidebars">Both sidebars</div>';                    
                                    $out .= '<input type="radio" name="layout_404_page" '.$this->attrChecked($this->_general['layout_404_page'] == CMS_PAGE_LAYOUT_BOTH_SIDEBARS).' value="'.CMS_PAGE_LAYOUT_BOTH_SIDEBARS.'" />';
                                $out .= '</div>';  
                                
                                $out .= '<div class="item">';
                                    $out .= '<div class="layout-image-left-sidebar">Left sidebar</div>';                    
                                    $out .= '<input type="radio" name="layout_404_page" '.$this->attrChecked($this->_general['layout_404_page'] == CMS_PAGE_LAYOUT_LEFT_SIDEBAR).' value="'.CMS_PAGE_LAYOUT_LEFT_SIDEBAR.'" />';
                                $out .= '</div>';                                             

                                $out .= '<div class="item">';
                                    $out .= '<div class="layout-image-right-sidebar">Right sidebar</div>';                    
                                    $out .= '<input type="radio" name="layout_404_page" '.$this->attrChecked($this->_general['layout_404_page'] == CMS_PAGE_LAYOUT_RIGHT_SIDEBAR).' value="'.CMS_PAGE_LAYOUT_RIGHT_SIDEBAR.'" />';
                                $out .= '</div>'; 
                                
                                $out .= '<div class="item">';
                                    $out .= '<div class="layout-image-full-width">Full width</div>';                    
                                    $out .= '<input type="radio" name="layout_404_page" '.$this->attrChecked($this->_general['layout_404_page'] == CMS_PAGE_LAYOUT_FULL_WIDTH).' value="'.CMS_PAGE_LAYOUT_FULL_WIDTH.'" />';
                                $out .= '</div>';                         
                                
                                $out .= $this->getClearBoth();                                                                
                                        
                            $out .= '</div>';                                                                      
                                         
                        $out .= '</td></tr>';
                        
                        $out .= '<tr><td><span class="dc-cms-left-marked-title">Other 404 page settings</span></td><td>';   
                                                    
                            $out .= '<span class="dc-cms-control-top-label-nomargin">Page content</span>'; 
                            $out .= '<textarea name="404_content" class="dc-cms-control-600 dc-cms-control-h-150 dc-cms-control-textarea">';
                                $out .= $this->_general['404_content'];
                            $out .= '</textarea>';                                                                                            
                        
                        $out .= '</td></tr>';                    
                                                    
                        
                        $out .= '</tbody>';
                    $out .= '</table>';                                        
                        
                    $out .= $this->getPanelSectionHead('Search page', 50);                                          
                    $out .= '<table class="dc-cms-table-standard">';                               
                        $out .= '<tbody>';
                        
                        // search page layout
                        $out .= '<tr><td><span class="dc-cms-left-marked-title">Search page layout</span></td><td>';    
                        
                            $out .= '<span class="dc-cms-control-top-label-nomargin">Select search page layout</span>';                    
                            $out .= '<div class="dc-cms-page-layout-box">';
                            
                                $out .= '<div class="item">';
                                    $out .= '<div class="layout-image-both-sidebars">Both sidebars</div>';                    
                                    $out .= '<input type="radio" name="layout_search_page" '.$this->attrChecked($this->_general['layout_search_page'] == CMS_PAGE_LAYOUT_BOTH_SIDEBARS).' value="'.CMS_PAGE_LAYOUT_BOTH_SIDEBARS.'" />';
                                $out .= '</div>';  
                                
                                $out .= '<div class="item">';
                                    $out .= '<div class="layout-image-left-sidebar">Left sidebar</div>';                    
                                    $out .= '<input type="radio" name="layout_search_page" '.$this->attrChecked($this->_general['layout_search_page'] == CMS_PAGE_LAYOUT_LEFT_SIDEBAR).' value="'.CMS_PAGE_LAYOUT_LEFT_SIDEBAR.'" />';
                                $out .= '</div>';                                             

                                $out .= '<div class="item">';
                                    $out .= '<div class="layout-image-right-sidebar">Right sidebar</div>';                    
                                    $out .= '<input type="radio" name="layout_search_page" '.$this->attrChecked($this->_general['layout_search_page'] == CMS_PAGE_LAYOUT_RIGHT_SIDEBAR).' value="'.CMS_PAGE_LAYOUT_RIGHT_SIDEBAR.'" />';
                                $out .= '</div>'; 
                                
                                $out .= '<div class="item">';
                                    $out .= '<div class="layout-image-full-width">Full width</div>';                    
                                    $out .= '<input type="radio" name="layout_search_page" '.$this->attrChecked($this->_general['layout_search_page'] == CMS_PAGE_LAYOUT_FULL_WIDTH).' value="'.CMS_PAGE_LAYOUT_FULL_WIDTH.'" />';
                                $out .= '</div>';                         
                                
                                $out .= $this->getClearBoth();                                                                
                                        
                            $out .= '</div>';                                                                      
                                         
                        $out .= '</td></tr>';                                                
                        
                        $out .= '<tr><td><span class="dc-cms-left-marked-title">Other search page settings</span></td><td>';
                                                    
                            $out .= '<span class="dc-cms-control-top-label-nomargin">Search input control dummy text</span>';
                            $out .= '<textarea name="search_dummy_text" class="dc-cms-control-wide dc-cms-control-textarea dc-cms-control-h-40">'.$this->_general['search_dummy_text'].'</textarea>';                                                        
                            $out .= $this->getStdInputsFieldStart(array('mtop-type' => 'small')); 
                                $out .= '<input type="checkbox" name="search_header_panel_display" '.$this->attrChecked($this->_general['search_header_panel_display']).'/> Display search panel in header'; 
                            $out .= $this->getStdInputsFieldEnd();                          
                        
                            $out .= $this->getEmptySpaceField(10);
                        
                            $out .= '<span class="dc-cms-control-top-label">Infomation that is displayed when no search results</span>'; 
                            $out .= '<textarea name="search_content" class="dc-cms-control-600 dc-cms-control-h-150 dc-cms-control-textarea">';
                                $out .= $this->_general['search_content'];
                            $out .= '</textarea>';     
                            
                            $out .= $this->getStdInputsFieldStart(); 
                                $out .= '<input type="checkbox" name="search_form_display" '.$this->attrChecked($this->_general['search_form_display']).'/> Display search form'; 
                                $out .= $this->getBR();
                                $out .= '<input type="checkbox" name="search_in_posts" '.$this->attrChecked($this->_general['search_in_posts']).'/> Search in posts';
                                $out .= $this->getBR();
                                $out .= '<input type="checkbox" name="search_in_pages" '.$this->attrChecked($this->_general['search_in_pages']).'/> Search in pages';  
                                $out .= $this->getBR();
                                $out .= '<input type="checkbox" name="search_in_member" '.$this->attrChecked($this->_general['search_in_member']).'/> Search in members posts';  
                                $out .= $this->getBR();   
                                $out .= '<input type="checkbox" name="search_in_service" '.$this->attrChecked($this->_general['search_in_service']).'/> Search in services posts';  
                                $out .= $this->getBR(); 
                                $out .= '<input type="checkbox" name="search_in_project" '.$this->attrChecked($this->_general['search_in_project']).'/> Search in projects posts';  
                                $out .= $this->getBR(); 
                            $out .= $this->getStdInputsFieldEnd();                                             
                                        
                        $out .= '</td></tr>';  
                        
                        $out .= '<tr><td><span class="dc-cms-left-marked-title">Posts per page</span></td><td>';                                       
                        
                            $out .= '<span class="dc-cms-control-top-label-nomargin">Number of posts on search page</span>';                    
                            $out .= $this->getCtrlInputInt('search_per_page', $this->_general['search_per_page'], 1);                                          
                                         
                        $out .= '</td></tr>';                                                                                      
                                      
                        $out .= '</tbody>';       
                    $out .= '</table>';   
                    
                    // custom css 
                    $out .= $this->getPanelSectionHead('Custom CSS code', 50);                                          
                    $out .= '<table class="dc-cms-table-standard">';                               
                        $out .= '<tbody>';
                        
                        
                        $out .= '<tr><td><span class="dc-cms-left-marked-title">Define custom CSS code</span></td><td>';                                              

                            $out .= '<span class="dc-cms-control-top-label-nomargin">CSS code</span>'; 
                            $out .= '<textarea name="css_code" class="dc-cms-control-600 dc-cms-control-h-600 dc-cms-control-monospace-textarea">';
                                $out .= $this->_general['css_code'];
                            $out .= '</textarea>';                            
                        
                            $out .= $this->getStdInputsFieldStart(array('mtop-type' => 'small')); 
                                $out .= '<input type="checkbox" name="css_code_use" '.$this->attrChecked($this->_general['css_code_use']).'/> Use CSS code'; 
                                $out .= $this->getBR();
                            $out .= $this->getStdInputsFieldEnd();                           
                        
                        $out .= '</td></tr>';                                                                                      
                                      
                        $out .= '</tbody>';       
                    $out .= '</table>';   
                
                    $out .= $this->getSubmitBottomPanel('dc-general-save-misc-opt');                                          
                $out .= '</form>';
         
            $out .= $this->getPanelEnd();               
        }          
        
        if($echo) { echo $out; } else { return $out; }
    }  
    
    public function renderExtrasCMS($echo=false)
    {
        $out = '';
        
        if($this->isSubPage('dc-subpage-extras-opt'))
        {
            $out .= $this->getPanelBegin('Extras settings');
         
                $out .= '<form action="#" method="post">'; 
                
                    $out .= $this->getSubmitTopPanel('dc-general-save-extras-opt');                                                              
                    $out .= $this->getPanelSectionHead('Theme emoticons');     
                         
                        $out .= '<table class="dc-cms-table-standard">';                     
                            $out .= '<tbody>';                    
                            
                            $out .= '<tr><td><span class="dc-cms-left-marked-title">Configure emoticons</span></td><td>';       
                                
                                $out .= $this->getStdInputsFieldStart();
                                    $out .= '<input type="checkbox" name="emoticons_use" '.$this->attrChecked($this->_general['emoticons_use']).' /> Activate theme emoticons replacement';
                                $out .= $this->getStdInputsFieldEnd();
                                
                                $out .= '<div class="dc-cms-help-note-box">';
                                    $out .= 'For use own emoticons please copy your icons set to <span class="dc-cms-marked-span">THEME-FOLDER/IMG/SMILIES</span> folder.<br />';
                                    $out .= 'Next back to this page, refresh it and save settings. Only GIF and PNG images are allowed.<br />';
                                    $out .= 'Optimal smiley icon size compatible with WP original is 15x15 pixels, but you can also use icons with size 16x16 pixels.';
                                $out .= '</div>';                                

                                $out .= '<span class="dc-cms-control-top-label">Select image extension priority</span>';  
                                $out .= $this->getStdInputsFieldStart();
                                    $out .= '<input type="radio" value="gif" name="emoticons_ext_prior" '.$this->attrChecked($this->_general['emoticons_ext_prior'] == 'gif').' /> GIF';
                                    $out .= $this->getBR();
                                    $out .= '<input type="radio" value="png" name="emoticons_ext_prior" '.$this->attrChecked($this->_general['emoticons_ext_prior'] == 'png').' /> PNG'; 
                                $out .= $this->getStdInputsFieldEnd();
                                
                                $out .= '<span class="dc-cms-control-top-label">Icon top offset</span>'; 
                                $out .= $this->getCtrlInputInt('emoticons_top', $this->_general['emoticons_top']);   
                                
                                $theme_icons_list = new DCC_ServerCatalogContent();
                                $theme_icons_list->readCatalog(array('catalog' => 'img/smilies')); 
                                
                                global $wpsmiliestrans;
                               // $out .= var_export($wpsmiliestrans, true);
                                
                                $out .= '<table class="dc-cms-smilies-table">';
                                  $out .= '<thead>';
                                    $out .= '<tr>';
                                      $out .= '<th class="icon-wp-image">WP Default Icon</th>';
                                      $out .= '<th class="icon-text">Text</th>';
                                      $out .= '<th class="icon-theme-image">Theme Replacement Icon</th>';
                                      $out .= '<th class="icon-text">Original WP File Name</th>';
                                      $out .= '<th class="icon-text">Final Icon</th>';
                                      $out .= '<th class="icon-text">Final File Name</th>';   
                                    $out .= '</tr>';
                                  $out .= '</thead>';                                
                                    $out .= '<tbody>';

                                        $wp_smilies_folder = includes_url().'/images/smilies/';
                                        $theme_url = CMS_THEME_URL;
                                        foreach($wpsmiliestrans as $smilie_text => $filename)
                                        {
                                            $out .= '<tr>';
                                                $out .= '<td><img src="'.$wp_smilies_folder.$filename.'" /></td>';
                                                $out .= '<td class="icon-text">'.$smilie_text.'</td>';
                                                
                                                $split = explode('.', $filename);
                                                
                                                $png_exist = $theme_icons_list->fileExist(array('name' => $split[0], 'ext' => 'png'));
                                                $gif_exist = $theme_icons_list->fileExist(array('name' => $split[0], 'ext' => 'gif'));
                                                
                                                $outputed = '';
                                                $outputed_filename = '';
                                                
                                                if($this->_general['emoticons_ext_prior'] == 'png')
                                                {
                                                    if($png_exist)
                                                    {
                                                        $out .= '<td class="icon-theme-image"><img src="'.$theme_url.'/img/smilies/'.$split[0].'.png" /></td>';    
                                                        $outputed = $theme_url.'/img/smilies/'.$split[0].'.png';
                                                        $outputed_filename = $split[0].'.png';
                                                    } else
                                                    if($gif_exist)
                                                    {
                                                        $out .= '<td class="icon-theme-image"><img src="'.$theme_url.'/img/smilies/'.$split[0].'.gif" /></td>';
                                                        $outputed = $theme_url.'/img/smilies/'.$split[0].'.gif';
                                                        $outputed_filename = $split[0].'.gif';       
                                                    } else                                                
                                                    if(!$gif_exist and !$png_exist)
                                                    {
                                                        $out .= '<td class="icon-theme-image">Not found</td>';    
                                                    }
                                                }

                                                if($this->_general['emoticons_ext_prior'] == 'gif')
                                                {
                                                    if($gif_exist)
                                                    {
                                                        $out .= '<td class="icon-theme-image"><img src="'.$theme_url.'/img/smilies/'.$split[0].'.gif" /></td>';
                                                        $outputed = $theme_url.'/img/smilies/'.$split[0].'.gif'; 
                                                        $outputed_filename = $split[0].'.gif';    
                                                    } else
                                                    if($png_exist)
                                                    {
                                                        $out .= '<td class="icon-theme-image"><img src="'.$theme_url.'/img/smilies/'.$split[0].'.png" /></td>'; 
                                                        $outputed = $theme_url.'/img/smilies/'.$split[0].'.png';  
                                                        $outputed_filename = $split[0].'.png';   
                                                    } else                                                
                                                    if(!$gif_exist and !$png_exist)
                                                    {
                                                        $out .= '<td class="icon-theme-image">Not found</td>';    
                                                    }
                                                }
                                                
                                                $out .= '<td class="icon-filename">'.$filename.'</td>'; 
                                                
                                                if($outputed == '') 
                                                { 
                                                    $outputed = $wp_smilies_folder.$filename; 
                                                    $outputed_filename = $filename; 
                                                }
                                                $out .= '<td class="icon-outputed-image"><img src="'.$outputed.'" /></td>';   
                                                $out .= '<td class="icon-filename">'.$outputed_filename.'</td>';  
                                             
                                            $out .= '</tr>';
                                        }
                                    
                                    $out .= '</tbody>';
                                $out .= '</table>';                                
                                
                            $out .= '</td></tr>'; 
                
                            $out .= '</tbody>';
                        $out .= '</table>';                   
     
                    $out .= $this->getSubmitBottomPanel('dc-general-save-extras-opt');                                          
                $out .= '</form>';
         
            $out .= $this->getPanelEnd();                       
        }
        
        if($echo) { echo $out; } else { return $out; }   
    }        
    
    public function renderTrackingCMS($echo=false)
    {
        $out = '';
        
        if($this->isSubPage('dc-subpage-tracking-opt'))
        {
            $out .= $this->getPanelBegin('Site tracking settings');
         
                $out .= '<form action="#" method="post">'; 
                
                    $out .= $this->getSubmitTopPanel('dc-general-save-tracking-opt');                                                              
                    $out .= $this->getPanelSectionHead('General tracking settings');     
                         
                        $out .= '<table class="dc-cms-table-standard">';                     
                            $out .= '<tbody>';                    
                            
                            $out .= '<tr><td><span class="dc-cms-left-marked-title">Activate site tracking</span></td><td>';                                                                    
                                
                                $out .= $this->getStdInputsFieldStart();
                                    $out .= '<input type="checkbox" name="tracking_header_use" '.$this->attrChecked($this->_general['tracking_header_use']).' /> Use header tracking code';
                                    $out .= $this->getBR();
                                    $out .= '<input type="checkbox" name="tracking_footer_use" '.$this->attrChecked($this->_general['tracking_footer_use']).' /> Use footer tracking code';
                                $out .= $this->getStdInputsFieldEnd();
                                                                                           
                            $out .= '</td></tr>';                                                         
                
                            $out .= '</tbody>';
                        $out .= '</table>';                   

                    $out .= $this->getPanelSectionHead('Header tracking code', 50);     
                         
                        $out .= '<table class="dc-cms-table-standard">';                     
                            $out .= '<tbody>'; 
                            
                            $out .= '<tr><td><span class="dc-cms-left-marked-title">Insert your header tracking code</span></td><td>';    
                                $out .= '<textarea name="tracking_header_code" class="dc-cms-control-textarea dc-cms-control-600 dc-cms-control-h-300" >'.$this->_general['tracking_header_code'].'</textarea>';
                            $out .= '</td></tr>';                            
                            
                            $out .= '</tbody>';
                        $out .= '</table>';                                

                    $out .= $this->getPanelSectionHead('Footer tracking code', 50);     
                         
                        $out .= '<table class="dc-cms-table-standard">';                     
                            $out .= '<tbody>'; 
                            
                            $out .= '<tr><td><span class="dc-cms-left-marked-title">Insert your footer tracking code</span></td><td>';    
                                $out .= '<textarea name="tracking_footer_code" class="dc-cms-control-textarea dc-cms-control-600 dc-cms-control-h-300" >'.$this->_general['tracking_footer_code'].'</textarea>';
                            $out .= '</td></tr>';                            
                            
                            $out .= '</tbody>';
                        $out .= '</table>';  
                
                    $out .= $this->getSubmitBottomPanel('dc-general-save-tracking-opt');                                          
                $out .= '</form>';
         
            $out .= $this->getPanelEnd();                       
        }
        
        if($echo) { echo $out; } else { return $out; }   
    }       
    
    public function getHeaderInfoBoxEntryHtml($index, $entry, $echo=false)
    {
        $out = '';
        
        $out .= '<li>';
            $out .= '<div class="index-box">'.($index+1).'</div>';
            $out .= '<input type="hidden" value="'.$index.'" name="dc-header-info-bar-entry-index-'.$index.'" />'; 
            $out .= '<span class="dc-cms-control-top-label-nomargin">Text</span>'; 
            $out .= '<textarea class="dc-cms-control-wide dc-cms-control-textarea" type="text" name="dc-header-info-bar-entry-text-'.$index.'">'.$entry->_text.'</textarea>';
            $out .= '<span class="dc-cms-control-top-label-s-margin"></span>'; 
            $out .= '<input type="checkbox" name="dc-header-info-bar-entry-hide-'.$index.'" '.$this->attrChecked($entry->_hide).' /> Hide';
            $out .= '<div class="dc-cms-btn-frame">';
                $out .= '<input class="dc-cms-submit-delete-btn" onclick="return confirm(\'Delete this item?\')" type="submit" name="dc-delete-header-info-box-entry-'.$index.'" value="Delete">';
                $out .= '<input class="dc-cms-submit-btn" type="button" name="add-span" value="Span">';
                $out .= '<input class="dc-cms-submit-btn" type="button" name="add-anchor" value="Anchor">';
                $out .= '<input class="dc-cms-submit-btn" type="button" name="add-default" value="Default">';
            $out .= '</div>';            
        $out .= '</li>';
        
        if($echo) { echo $out; } else { return $out; } 
    }
    
    // contact form creator
    public function getContactFormOptionHtml($control_index, $option_index, $option, $value=CMS_NOT_SELECTED, $echo=false)
    {
        $out = '';
                                                                                            
        $out .= '<li class="select-option">';
            $out .= '<input type="text" name="cf-ctrl-data-option-'.$control_index.'-'.$option_index.'" value="'.stripcslashes($option->_value).'" />';
            $out .= '<input type="hidden" name="cf-ctrl-data-option-id-'.$control_index.'-'.$option_index.'" value="'.$option->_id.'" />';
            $out .= '<input type="radio" name="cf-ctrl-data-default-option-'.$control_index.'" value="'.$option->_id.'" '.$this->attrChecked($option->_id == $value).' /> Default';
            $out .= '<input type="button" class="dc-cms-submit-delete-btn" value="Delete" />';            
            $out .= '<div class="dc-cms-clear"></div>';
        $out .= '</li>';          
        
        if($echo) { echo $out; } else { return $out; }    
    }  
    
    public function getContactFormInputHtml($input_index, $input, $echo=false)
    {
        $out = ''; 
        
        $out .= '<li class="cf-item">';
            
            $out .= '<div class="index-box">'.($input_index+1).'</div>';
            $out .= '<div class="type-box">'.ucfirst($input->_type).' control</div>';
            
            $out .= '<input type="hidden" value="'.$input->_type.'" name="cf-ctrl-data-type-'.$input_index.'" />';
            
            $out .= '<div class="col-left">';
                $out .= '<span class="dc-cms-control-top-label-nomargin">Label</span>';
                $out .= '<textarea name="cf-ctrl-data-label-'.$input_index.'">'.stripcslashes($input->_label).'</textarea>';  
            $out .= '</div>';
            
            if($input->_type != 'select')
            {
                $out .= '<div class="col-right">';
                    $out .= '<span class="dc-cms-control-top-label-nomargin">Default value</span>';
                    $out .= '<textarea name="cf-ctrl-data-default-'.$input_index.'">'.stripcslashes($input->_default).'</textarea>';                                                                                                                        
                $out .= '</div>';
            }
            
            $out .= $this->getClearBoth(); 

            $out .= '<div class="col-full">';                          
                $out .= '<span class="dc-cms-control-top-label">Control functionality</span>';  
                $out .= '<div class="dc-cms-excludable-checkbox-field-nomargin check-if-empty-field">';
                    
                    $out .= '<div class="col-left">';
                        $out .= '<input type="checkbox" name="cf-ctrl-data-func-info-'.$input_index.'" '.$this->attrChecked($input->_func_info).' /> Additional information';
                        $out .= $this->getBR();
                        $out .= '<input type="checkbox" name="cf-ctrl-data-func-name-'.$input_index.'" '.$this->attrChecked($input->_func_name).' /> User name'; 
                        $out .= $this->getBR();
                        $out .= '<input type="checkbox" name="cf-ctrl-data-func-email-'.$input_index.'" '.$this->attrChecked($input->_func_email).' /> User respond email';
                    $out .= '</div>';
                    
                    $out .= '<div class="col-right">';
                        $out .= '<input type="checkbox" name="cf-ctrl-data-func-subject-'.$input_index.'" '.$this->attrChecked($input->_func_subject).' /> Message subject';
                        $out .= $this->getBR();
                        $out .= '<input type="checkbox" name="cf-ctrl-data-func-message-'.$input_index.'" '.$this->attrChecked($input->_func_message).' /> Message content';
                    $out .= '</div>';
                    
                    $out .= $this->getClearBoth();
                    
                $out .= '</div>';
            $out .= '</div>';
        
            $out .= $this->getClearBoth();
        
            $out .= '<div class="col-full">';
                $out .= '<div class="dc-cms-help-note-box">';
                    $out .= 'Here you need to select the functionality of given form control. ';
                    $out .= 'Every form should have one <span class="dc-cms-marked-span">name</span>, <span class="dc-cms-marked-span">subject</span>, <span class="dc-cms-marked-span">email</span>, and <span class="dc-cms-marked-span">message</span> ';
                    $out .= 'field to fully proper work. Each of this field is optional, but if is not choosed mail script will don\'t known e.g what information should be send as message and what information should be send as user name.';
                $out .= '</div>';         
            $out .= '</div>';
        
            $out .= '<div class="col-left">';                          
                $out .= '<span class="dc-cms-control-top-label">Additional options</span>';                                      
                $out .= '<div class="dc-cms-inputs-field-nomargin">';                                                                 
                    $out .= '<input type="checkbox" name="cf-ctrl-data-hide-'.$input_index.'" '.$this->attrChecked($input->_hide).' /> Hide control';
                    $out .= '<br />';                     
                    $out .= '<input type="checkbox" name="cf-ctrl-data-is-email-'.$input_index.'" '.$this->attrChecked($input->_is_email).' /> Analyse as email address'; 
                    $out .= '<br />';
                    $out .= '<input type="checkbox" name="cf-ctrl-data-required-'.$input_index.'" '.$this->attrChecked($input->_required).' /> Required';                                                                                                                                        
                    $out .= '<br />';
                    $out .= '<input type="checkbox" name="cf-ctrl-data-hide-label-'.$input_index.'" '.$this->attrChecked($input->_hide_label).' /> Hide label'; 
                $out .= '</div>';
            $out .= '</div>';
        
            $out .= '<div class="col-right">';                          
                $out .= '<span class="dc-cms-control-top-label">&nbsp;</span>';                                      
                $out .= '<div class="dc-cms-inputs-field-nomargin">';                                                                                     
                    $out .= '<input type="checkbox" name="cf-ctrl-data-is-authorization-'.$input_index.'" '.$this->attrChecked($input->_is_authorization).' /> Display as authorization field';
                    $out .= '<br />';
                    $out .= '<input type="checkbox" name="cf-ctrl-data-use-default-'.$input_index.'" '.$this->attrChecked($input->_use_default).' /> Use default value';
                    $out .= '<br />';
                    $out .= '<input type="checkbox" name="cf-ctrl-data-use-width-'.$input_index.'" '.$this->attrChecked($input->_use_width).' /> Use width (all types)';                                                                                                                                           
                    $out .= '<br />';
                    $out .= '<input type="checkbox" name="cf-ctrl-data-use-height-'.$input_index.'" '.$this->attrChecked($input->_use_height).' /> Use height (only textarea)';
                $out .= '</div>';
            $out .= '</div>';                                                            
            
            $out .= $this->getClearBoth();                                                                
            
            $out .= '<div class="col-left">'; 
                $out .= '<span class="dc-cms-control-top-label">Control width</span>';                                
                $out .= $this->getCtrlInputInt('cf-ctrl-data-width-'.$input_index, $input->_width, 50, 900);
            $out .= '</div>';

            $out .= '<div class="col-right">'; 
                $out .= '<span class="dc-cms-control-top-label">Control height</span>';                                
                $out .= $this->getCtrlInputInt('cf-ctrl-data-height-'.$input_index, $input->_height, 50, 900);
            $out .= '</div>';
            
            $out .= $this->getClearBoth();
            
            
            if($input->_type == 'select')
            {
                $options_count = count($input->_options);
                 
                $out .= '<div class="col-full">';
                
                    $out .= '<span class="dc-cms-control-top-label" '.(($options_count == 0) ? ' style="display:none;" ' : '').' >Select options</span>';
                    
                    $out .= '<ul class="select-option-list">';    
                        $option_index = 0;
                        foreach($input->_options as $option)
                        {
                            $out .= $this->getContactFormOptionHtml($input_index, $option_index, $option, $input->_default_option);       
                            $option_index++;
                        }      
                    $out .= '</ul>';                                                                                                                        
                    
                $out .= '</div>';
                
                $out .= $this->getClearBoth();
            }
        
            $out .= '<div class="dc-cms-btn-frame-top-border">';
                $out .= '<span class="dc-cms-hidden dc-control-index">'.$input_index.'</span>';
                $out .= '<input type="submit" onclick="return confirm(\'Delete contact form control?\')" name="dc-general-delete-cf-control-'.$input_index.'" class="dc-cms-submit-delete-btn" value="Delete control" />';                                 
                if($input->_type == 'select')
                {
                    $out .= '<span class="dc-cms-action-name">dc_add_cf_node</span>';
                    $out .= '<input type="button" class="dc-cms-submit-btn add-option-btn" value="Add select option" />';  
                }
                $out .= '<input class="dc-cms-submit-btn" type="submit" name="dc-general-save-contact-form-opt" value="Save">';
            $out .= '</div>';                                   
        
        $out .= '</li>';        
        
        if($echo) { echo $out; } else { return $out; }   
    }
     
    public function getSidebarObjectByID($id)
    {
        $value = false;
        if(is_array($this->_sidlist))
        {
            foreach($this->_sidlist as $sid)
            {
                if($id == $sid->_id)
                {
                    $value = $sid;
                    break;
                }
            }
        }
        
        return $value;
    }              
    
    public function setSidebarChildsOrderAjax($index=null, $order=array())
    {     
        if(array_key_exists($index, $this->_sidlist))
        {   
            $this->_sidlist[$index]->_childs = $order;  
            update_option($this->_DBIDOPT_SIDLIST, $this->_sidlist);
        
        }
    }                            
    
    public function getPostCategorySidebar($slug, $side)
    {
        $sid = CMS_NOT_SELECTED;
        
        if(array_key_exists($slug, $this->_general['sid_individual_cats']))
        {   
            if(is_object($this->_general['sid_individual_cats'][$slug]))
            {
                if($side == CMS_SIDEBAR_LEFT)
                {
                    $sid = $this->_general['sid_individual_cats'][$slug]->left;        
                } else
                {
                    $sid = $this->_general['sid_individual_cats'][$slug]->right;     
                }
            }
        } 
        
        if($sid == CMS_NOT_SELECTED)
        {             
            if($side == CMS_SIDEBAR_LEFT)        
            {   
                $sid = $this->_general['sid_default_cats_left'];
            } else
            {
                $sid = $this->_general['sid_default_cats_right'];
            }
        }         
        
        return $sid;
    }
    
    public function getSidebar($args=array(), $echo=true)
    {                     
        global $dc_is_category;
        
        ob_start();        
        $def = array(
            'id' => CMS_NOT_SELECTED,
            'side' => CMS_NOT_SELECTED
        );
        $args = $this->combineArgs($def, $args);     
        
        if($args['side'] != CMS_NOT_SELECTED)
        {                
            if($args['id'] == CMS_NOT_SELECTED)
            {           
                if($args['side'] == CMS_SIDEBAR_LEFT)
                { 
                    $args['id'] = $this->_general['sid_default_left']; 
                } else 
                { 
                    $args['id'] = $this->_general['sid_default_right']; 
                }                           
            }        
            
            if($args['side'] == CMS_SIDEBAR_RIGHT) 
            {                
                echo '<div class="dc-right-sidebar">';
            } else 
            if($args['side'] == CMS_SIDEBAR_LEFT) 
            {                     
                echo '<div class="dc-left-sidebar">'; 
            } else
            {                     
                echo '<div class="dc-center-sidebar">'; 
            }                                 
            
            if($args['id'] != CMS_NOT_SELECTED)
            {      
                $sidebar = $this->getSidebarObjectByID($args['id']);
                if(is_array($sidebar->_childs))
                {
                    foreach($sidebar->_childs as $key => $value)
                    {
                        if($value)
                        {
                            dynamic_sidebar('sidebar-'.$key);    
                        }    
                    }
                }              
            } else
            {
                echo '<div class="dc-theme-exception"><div class="exception-title">Theme Exception</div>No sidebar defined or selected for this page/post. 
                Please go to theme general options and create sidebar - section '.CMS_THEME_NAME.' > General > Sidebars. Then go to (WordPress) Appearance > Widget section - here you can add some widget to created sidebar. Set default sidebar in theme general 
                options or assign invidual sidebar to given page or post in Custom Page/Post Settings. More about using sidebars and widgets you will find also in PDF User Guide.', CMS_TXT_DOMAIN.'</div>';                
            }
            
                echo '<div class="dc-clear-both"></div>';
            echo '</div>';
        }
        
        $out = ob_get_contents();
        ob_end_clean();
        
        if($echo) { echo $out; } else { return $out; }                
    }
    
    public function registerSidebars()
    {        
        if(is_array($this->_sidlist))
        {                
            $count = count($this->_sidlist);
            
            if($this->_general['sid_last_as_first'])
            {
                for($i = $count-1; $i >= 0; $i--)
                {        
                    $id = 'sidebar-'.$this->_sidlist[$i]->_id;
                    $args = array(
                        'name' => $this->_sidlist[$i]->_name,
                        'id' => $id,
                        'before_widget' => $this->getBeforeWidget(),
                        'after_widget' => $this->getAfterWidget(),
                        'before_title' => '<div class="dc-widget-title">',
                        'after_title' => '</div>'
                    );                
                                    
                    register_sidebar($args);                     
                }                
            } else
            {
                for($i = 0; $i < $count; $i++)
                {        
                    $id = 'sidebar-'.$this->_sidlist[$i]->_id;
                    $args = array(
                        'name' => $this->_sidlist[$i]->_name,
                        'id' => $id,
                        'before_widget' => $this->getBeforeWidget(),
                        'after_widget' => $this->getAfterWidget(),
                        'before_title' => '<div class="dc-widget-title">',
                        'after_title' => '</div>'
                    );                
                                    
                    register_sidebar($args);                      
                }
            }        
        }
    }      
    
    public function getBeforeWidget($args=array())
    {
        $def = array(
            'pb' => 30,
            'pb_use' => false
        );
        $args = $this->combineArgs($def, $args);
        
        $style = '';
        if($args['pb_use']) { $style .= 'padding-bottom:'.$args['pb'].'px;'; }
        if($style != '') { $style = ' style="'.$style.'" '; }
        
        $out = '';
        $out .= '<div class="dc-widget-wrapper" '.$style.'>';
        return $out;
    }   
    
    public function getAfterWidget()
    {
        $out = '';
        $out .= '</div>';
        return $out;
    }        
    
    public function getContactFormByID($id)
    {
        $value = null;
        if(is_array($this->_general['cf_list']))
        {
            foreach($this->_general['cf_list'] as $form)
            {
                if($form->_id == $id)
                {
                    $value = $form;
                    break;
                }    
            }
        }
        return $value;
    }
    
    
    public function selectCtrlSidebarsList($sidebar, $name, $width=300, $echo=false)
    {   
        $out = '';
        
        if(is_array($this->_sidlist))
        {
            $count = count($this->_sidlist);        
        
            $out .= '<select style="width:'.$width.'px;" name="'.$name.'">';                                   
            $out .= '<option value="'.CMS_NOT_SELECTED.'" '.($sidebar == CMS_NOT_SELECTED ? ' selected="selected" ' : '').'>'.__('Not selected', CMS_TXT_DOMAIN).'</option>';
            for($i = 0; $i < $count; $i++)
            {
                $out .= '<option value="';
                $out .= $this->_sidlist[$i]->_id;
                $out .= '" ';
                $out .= ($sidebar == $this->_sidlist[$i]->_id ? ' selected="selected" ' : '');
                $out .= '>';
                $out .= $this->_sidlist[$i]->_name;
                $out .= '</option>';
            }
            $out .= '</select>';
        
        }
        
        if($echo) { echo $out; } else { return $out; }           
    }      
    
    public function getHeaderInfoBox($echo=false)
    {
        $out = '';
        
        if($this->_general['header_infobox_display'])
        {         
            if(!is_array($this->_general['header_infobox_list'])) { $this->_general['header_infobox_list'] = array(); }
            
            $counter = 0;
            foreach($this->_general['header_infobox_list'] as $entry)
            {
                if($entry->_hide) { continue; }
                if($entry->_text == '') { continue; }
                
                $counter++;    
            }
                   
            if($counter)
            {
                $out .= '<div class="dc-header-info-box-wrapper">'; 

                    foreach($this->_general['header_infobox_list'] as $entry)
                    {
                        if($entry->_hide) { continue; }
                        
                        if($entry->_text != '')
                        {
                            $out .= '<div class="entry">';                                        
                                $out .= $entry->_text;                                              
                            $out .= '</div>';    
                        }                    
                    }            
                
                $out .= '</div>';
            }
        }
        
        if($echo) { echo $out; } else { return $out; }                
    }
    
    public function getMainIconsBox($echo=false)
    {
        $out = '';        
        if(!is_array($this->_general['icons_list'])) { $this->_general['icons_list'] = array(); }
        
        if($this->_general['icons_display'] and count($this->_general['icons_list']))
        {
            $w = $this->_general['icons_icon_width'];
            $h = $this->_general['icons_icon_height'];
            $m = $this->_general['icons_icon_mergin_left']; 
            
            // calculating container width
            $c_w = 0;
            foreach($this->_general['icons_list'] as $ico)
            {
                if($ico->_hide) { continue; }    
                
                $c_w += $w + $m; 
                if($this->_general['icons_debug_frame']) { $c_w += 2; }
            }
            
            $style = '';            
            $style .= 'width:'.(int)$c_w.'px;';
            $style .= 'height:'.(int)$this->_general['icons_icon_height'].'px;';
            if($this->_general['icons_debug_frame']) { $style .= 'border:1px solid red;'; }
            
            $style = ' style="'.$style.'" ';            
            
            $out .= '<div class="dc-main-icons-wrapper" '.$style.'>';            

                $count = count($this->_general['icons_list']);
                for($i = ($count - 1); $i >= 0; $i--)
                {         
                    $ico = & $this->_general['icons_list'][$i];
                    
                    if($ico->_hide) { continue; }
                           
                    $style = '';
                    $style .= 'width:'.(int)$w.'px;';
                    $style .= 'height:'.(int)$h.'px;';                    
                    if($this->_general['icons_debug_frame']) { $style .= 'border:1px solid blue;'; } 
                    $style .= 'margin-left:'.(int)$m.'px;';
                    $style = ' style="'.$style.'" ';
                    
                    $href = '';
                    $href .= ' href="'.$ico->_url.'" ';
                    
                    $target = ' target="_self" ';
                    if($ico->_target_blank) { $target = ' target="_blank" '; }
                    
                    $title = '';
                    if($ico->_desc != '' and $this->_general['icons_tooltip_display']) { $title = ' title="'.$ico->_desc.'" '; }
                    
                    $class = '';
                    if($ico->_desc != '' and $this->_general['icons_tooltip_display']) { $class .= 'dc-tip-top'; }
                    
                    $out .= '<a class="icon-object '.$class.'" '.$style.' '.$href.' '.$target.' '.$title.'>';
                    
                        if($ico->_imgurl != '') { $out .= '<img class="icon-img" src="'.$ico->_imgurl.'" alt="'.$ico->_desc.'" />'; };
                        if($ico->_hovered and $ico->_imgurl_hover != '') { $out .= '<img class="icon-img-hover" src="'.$ico->_imgurl_hover.'" alt="'.$ico->_desc.'" />'; };                        
                        
                    $out .= '</a>';    
                }
            $out .= '</div>';                
        }
        
        if($echo) { echo $out; } else { return $out; } 
    }   
    
    public function getGlobalSEOData($echo=false)
    {
        $out = '';
      
        if($this->_general['seo_title_use'] and $this->_general['seo_title'] != '')
        {
            $before = '';
            if($this->_general['seo_add_blog_name']) { $before = get_bloginfo('name').' - '; }
            $out .= '<title>'.$before.$this->_general['seo_title'].'</title>';      
        } else
        {
            $out .= '<title>'.get_bloginfo('name').wp_title('-', false).'</title> ';    
        }
        
        if($this->_general['seo_keywords_use'] and $this->_general['seo_keywords'] != '')
        {
            $out .= '<meta name="keywords" content="'.$this->_general['seo_keywords'].'" /> ';
        }

        if($this->_general['seo_desc_use'] and $this->_general['seo_desc'] != '')
        {
            $out .= '<meta name="description" content="'.$this->_general['seo_desc'].'" /> ';
        }
        
        if($this->_general['seo_noindex'] != false or
           $this->_general['seo_nofollow'] != false or
           $this->_general['seo_nosnippet'] != false or
           $this->_general['seo_noodp'] != false or
           $this->_general['seo_noarchive'] != false or
           $this->_general['seo_noimageindex'] != false)
        {            
            $out .= '<meta name="robots" content="';
                $comma = false;
                if($this->_general['seo_noindex'])      { if($comma) { $out .= ', '; } $out .= 'noindex'; $comma = true; }
                if($this->_general['seo_nofollow'])     { if($comma) { $out .= ', '; } $out .= 'nofollow'; $comma = true; }
                if($this->_general['seo_nosnippet'])    { if($comma) { $out .= ', '; } $out .= 'nosnippet'; $comma = true; }
                if($this->_general['seo_noodp'])        { if($comma) { $out .= ', '; } $out .= 'noodp'; $comma = true; }
                if($this->_general['seo_noarchive'])    { if($comma) { $out .= ', '; } $out .= 'noarchive'; $comma = true; }
                if($this->_general['seo_noimageindex']) { if($comma) { $out .= ', '; } $out .= 'noimageindex'; $comma = true; } 
            $out .= '" />';                       
        }
        
        if(is_array($this->_general['seo_private_meta']))
        {                                                       
            foreach($this->_general['seo_private_meta'] as $meta)
            {
                if(!$meta->_active) { continue; }
                
                $meta->_content = str_replace(array("\r\n", "\n", "\r"), ' ', $meta->_content);
                
                if($meta->_name != '' and (trim($meta->_content) != ''))
                {
                    $out .= '<meta name="'.$meta->_name.'" content="'.$meta->_content.'" />';
            
                }
            }    
        }        
    
        if($echo) { echo $out; } else { return $out; }     
    }
    
    public function addFilter($args=array())
    {
        if($this->_general['emoticons_use'])
        {
            add_filter('smilies_src', array(&$this, 'filter_smilies_src'), 1, 3); 
        }
    }
    
    public function filter_smilies_src($src, $file, $url)
    {
        global $dc_template_url;
        
        if($this->_general['emoticons_ext_prior'] == 'png')
        {
            $split = explode('.', $file);
            if(in_array($split[0].'.png', $this->_general['emoticons_files']))
            {
                $src = $dc_template_url.'/img/smilies/'.$split[0].'.png';     
            } else    
            if(in_array($split[0].'.gif', $this->_general['emoticons_files']))
            {
                $src = $dc_template_url.'/img/smilies/'.$split[0].'.gif';     
            }
        }
        
         if($this->_general['emoticons_ext_prior'] == 'gif')
        {
            $split = explode('.', $file);
            if(in_array($split[0].'.gif', $this->_general['emoticons_files']))
            {
                $src = $dc_template_url.'/img/smilies/'.$split[0].'.gif';     
            } else    
            if(in_array($split[0].'.png', $this->_general['emoticons_files']))
            {
                $src = $dc_template_url.'/img/smilies/'.$split[0].'.png';     
            }
        }
        
        return $src;
    }       
     
    public function getHeaderTrackingCode($echo=true)
    {
        $out = '';
        
        if($this->_general['tracking_header_use'])
        {
            $out .= $this->_general['tracking_header_code'];
        }
        
        if($echo) { echo $out; } else { return $out; }  
    } 

    public function getFooterTrackingCode($echo=true)
    {
        $out = '';
        
        if($this->_general['tracking_footer_use'])
        {
            $out .= $this->_general['tracking_footer_code'];
        }
        
        if($echo) { echo $out; } else { return $out; }  
    } 
     
    public function getAnnouncementBar($echo=true)
    {    
        $out = '';        
        if($this->_general['abar_display'])
        {
            $style = '';
            
                $style .= 'height:'.$this->_general['abar_h'].'px;';
                // padding
                if($this->_general['abar_pt_use']) { $style .= 'padding-top:'.$this->_general['abar_pt'].'px;'; }
                if($this->_general['abar_pr_use']) { $style .= 'padding-right:'.$this->_general['abar_pr'].'px;'; }
                if($this->_general['abar_pb_use']) { $style .= 'padding-bottom:'.$this->_general['abar_pb'].'px;'; }
                if($this->_general['abar_pl_use']) { $style .= 'padding-left:'.$this->_general['abar_pl'].'px;'; }
                // font
                if($this->_general['abar_font_use']) { $style .= 'font-family:'.$this->_general['abar_font'].';'; }
                if($this->_general['abar_fsize_use']) { $style .= 'font-size:'.$this->_general['abar_fsize'].'px;'; }
                if($this->_general['abar_lheight_use']) { $style .= 'line-height:'.$this->_general['abar_lheight'].'px;'; }
                if($this->_general['abar_fstyle_use']) { $style .= 'font-style:'.$this->_general['abar_fstyle'].';'; }
                $style .= 'text-align:'.$this->_general['abar_align'].';';
                if($this->_general['abar_color_use']) { $style .= 'color:'.$this->_general['abar_color'].';'; }     
                // border
                if($this->_general['abar_border_display']) 
                { 
                    $style .= 'border-top:'.$this->_general['abar_border_width'].'px '.$this->_general['abar_border_style'].' '.$this->_general['abar_border_color'].';'; 
                } 
                // background
                if($this->_general['abar_bg_image_display'] or $this->_general['abar_bg_color_use'])
                {   
                    if($this->_general['abar_bg_image_display'])
                    {
                        $style .= 'background-image:url('.$this->_general['abar_bg_image'].');';
                        $style .= 'background-repeat:'.$this->_general['abar_bg_repeat'].';';
                        
                        $pos_x = $this->_general['abar_bg_pos_x'];
                        $pos_y = $this->_general['abar_bg_pos_y'];
                        if($this->_general['abar_bg_pos_x_px_use']) { $pos_x = $this->_general['abar_bg_pos_x_px'].'px'; }
                        if($this->_general['abar_bg_pos_y_px_use']) { $pos_y = $this->_general['abar_bg_pos_y_px'].'px'; }
                        
                        $style .= 'background-position:'.$pos_x.' '.$pos_y.';';
                    }
                    
                     if($this->_general['abar_bg_color_use']) { $style .= 'background-color:'.$this->_general['abar_bg_color'].';'; }         
                }                                    
                
            $style = ' style="'.$style.'" ';
            
            $class = '';
            if($this->_general['abar_display_shadow']) { $class = ' add-shadow'; }
            
            $out .= '<div id="dc-announcement-bar" class="'.$class.'" '.$style.'>';            
                
                if($this->_general['abar_content_use'])
                {
                    $out .= $this->_general['abar_content'];
                }
                
                if($this->_general['abar_link_use'] and !$this->_general['abar_content_use'])
                {
                    $href = ' href="'.$this->_general['abar_link'].'" ';
                    $target = $this->_general['abar_link_new_tab'] ? ' target="_blank" ' : ' target="_self" ';
                    
                    $out .= '<a class="link-layer" '.$href.' '.$target.'></a>';
                }
                
                if($this->_general['abar_cbtn_display'])
                {
                    $style = '';
                        $style .= 'background-image:url('.$this->_general['abar_cbtn_image'].');';
                        $style .= 'background-color:'.$this->_general['abar_cbtn_bg_color'].';';
                        $style .= 'width:'.$this->_general['abar_cbtn_size'].'px;';   
                        $style .= 'height:'.$this->_general['abar_cbtn_size'].'px;';
                    $style = ' style="'.$style.'" '; 
                    
                    $out .= '<div class="close-btn" '.$style.'></div>';
                }                
            
            $out .= '</div>';
        }
    
        if($echo) { echo $out; } else { return $out; }     
    }  
     
     
     private function renderWPSubMenuResponsive($level, $parent_id, $menu)
     {
        $out = '';
        $prefix = '';
        for($i = 0; $i < $level; $i++)
        {
            $prefix .= '- ';
        }
        $prefix .= ' '; 
        
        foreach($menu as $item)
        {
            if($parent_id == $item->menu_item_parent)
            {
                $out .= '<option ';
                    $out .= 'class="level-'.$level.'" ';
                    $out .= 'value="'.$item->url.'" ';

                   if(($item->object == 'page' and is_page($item->object_id)) or 
                      ($item->object == 'category' and is_category($item->object_id)) or
                      ($item->object == DCC_ControlPanelCustomPosts::PT_SERVICE_POST and is_single($item->object_id)) or
                      ($item->object == DCC_ControlPanelCustomPosts::PT_MEMBER_POST and is_single($item->object_id)) or
                      ($item->object == DCC_ControlPanelCustomPosts::PT_PROJECT_POST and is_single($item->object_id)) or
                      ($item->object == DCC_ControlPanelCustomPosts::PT_PROJECT_CATEGORY and is_tax(DCC_ControlPanelCustomPosts::PT_PROJECT_CATEGORY)))  
                    {
                        $out .= ' selected="selected" ';
                    }
                $out .= ' >';
                    $out .= $prefix;
                    $out .= $item->title;
                $out .= '</option>';
                $out .= $this->renderWPSubMenuResponsive($level+1, $item->db_id, $menu);
            }
        }        
        return $out; 
     }
     
     public function renderPrimaryWPMenuResponsive($args=array(), $echo=false)
     {
         global $post;
         $theme_locations = get_nav_menu_locations();
         $menu = wp_get_nav_menu_items($theme_locations[CMS_WP_PRIMARY_MENU]);
         
         $out = '';
         
         if(is_array($menu))
         {
             $level = 0;
             $out .= '<select class="dc-wp-primary-theme-menu-responsive">';   
                foreach($menu as $item)
                {
                    if($item->menu_item_parent == 0)
                    {
                        $out .= '<option ';
                            $out .= 'class="level-'.$level.'" ';
                            $out .= 'value="'.$item->url.'" ';

                           if(($item->object == 'page' and is_page($item->object_id)) or 
                              ($item->object == 'category' and is_category($item->object_id)) or
                              ($item->object == DCC_ControlPanelCustomPosts::PT_SERVICE_POST and is_single($item->object_id)) or
                              ($item->object == DCC_ControlPanelCustomPosts::PT_MEMBER_POST and is_single($item->object_id)) or
                              ($item->object == DCC_ControlPanelCustomPosts::PT_PROJECT_POST and is_single($item->object_id)) or
                              ($item->object == DCC_ControlPanelCustomPosts::PT_PROJECT_CATEGORY and is_tax(DCC_ControlPanelCustomPosts::PT_PROJECT_CATEGORY)))  
                            {
                                $out .= ' selected="selected" ';
                            }
                        $out .= ' >';
                            $out .= $item->title;
                        $out .= '</option>';
                        $out .= $this->renderWPSubMenuResponsive($level+1, $item->db_id, $menu);
                    }
                }  
             $out .= '</select>';
         }
         
         if($echo) { echo $out; } else { return $out; }   
     }
     
     public function renderPrimaryWPMenu($args=array(), $echo=false)
     {         
         $out = '';
         $theme_locations = get_nav_menu_locations();          
         
         if(isset($theme_locations[CMS_WP_PRIMARY_MENU]) and $theme_locations[CMS_WP_PRIMARY_MENU] != 0)
         {
             $out .= '<div class="dc-wp-primary-theme-menu-wrapper">';
                $out .= '<div class="dc-wp-primary-theme-menu-inner-wrapper">';
                    $out .= wp_nav_menu(
                        array(
                            'theme_location' => CMS_WP_PRIMARY_MENU, 
                            'echo' => false,
                            'container' => false,
                            'menu_class' => 'dc-wp-primary-theme-menu',
                            'link_before' => '<div>',
                            'link_after' => '</div>',
                        ));     
                    $out .= '<div class="dc-clear"></div>';
                $out .= '</div>';
             $out .= '</div>';
         }
         
         if($echo) { echo $out; } else { return $out; }
     }
     
/*
    public function selectCtrlWPMenusList($itemvalue, $name, $width)
    {
        $menus = get_terms('nav_menu');
        
        $out = '';
        $out .= '<select style="width:'.$width.'px;" name="'.$name.'"><option value="'.CMS_NOT_SELECTED.'">Not selected</option>';
            
            $count = count($menus);
            for($i = 0; $i < $count; $i++)
            {
       
                $out .= '<option value="'.$menus[$i]->name.'" ';
                
                if($itemvalue !== null)
                {
                    if($menus[$i]->name == $itemvalue) $out .= ' selected="selected" ';
                }
                
                $out .= '>';
                $out .= $menus[$i]->name.' (ID:'.$menus[$i]->term_id.')';
                $out .= '</option>';
                   
            } // for              
        $out .= '</select>';
        return $out;         
    }
*/     
     
} // class
        
        
?>
