<?php
/**********************************************************************
* OSAKA UNLIMITED WORDPRESS THEME 
* (Ideal For Business And Personal Use: Portfolio or Blog)     
* 
* File name:   
*      cp_font.php
* Brief:       
*      Part of theme control panel.
* Author:      
*      DigitalCavalry
* Author URI:
*      http://themeforest.net/user/DigitalCavalry
* Contact:
*      digitalcavalry@gmail.com 
***********************************************************************/

/*********************************************************** 
* Class name:
*    DCC_ControlPanelFont
* Descripton:
*    Implementation of DCC_ControlPanelFont 
***********************************************************/
class DCC_ControlPanelFont extends DCC_ControlPanelBase
{
    /*********************************************************** 
    * Constructor
    ************************************************************/
    public function __construct() 
    {              
        $this->_DBIDOPT_FONT = CMS_THEME_NAME_UPPERCASE.'_FONT_OPT';
        
        $this->_opt = get_option($this->_DBIDOPT_FONT);
        if(!is_array($this->_opt))
        {
            $this->setDefaults(); 
            add_option($this->_DBIDOPT_FONT, $this->_optDef);
            $this->_opt = get_option($this->_DBIDOPT_FONT);
        } 
            
    } // constructor 
    
    /*********************************************************** 
    * Public members
    ************************************************************/      
    
    /*********************************************************** 
    * Private members
    ************************************************************/           
     private $_DBIDOPT_FONT = null; // data base id options
      
     private $_opt = array();
     private $_optDef = array(
        
        // heading font
        'font_type' => CMS_FONT_TYPE_GOOGLE,
        'font_cufon' => '',
        'font_browser' => 'Tahoma', 
        'font_face' => '',         
        'font_google_url' => 'http://fonts.googleapis.com/css?family=Yanone+Kaffeesatz', 
        'font_google_css' => "'Yanone Kaffeesatz', sans-serif",     
        
        // body font
        'body_font_type' => CMS_FONT_TYPE_BROWSER,
        'body_font_browser' => 'Helvetica',
        'body_font_google_url' => '',
        'body_font_google_css' => '',
        
        // other
        'cms_font_google_page' => 1,
        'cms_font_google_perpage' => 10            
     );    
   
     protected $_submenu = array (
        'Heading font' => 'dc-font-opt',        
        'Body font' => 'dc-subpage-bodyfont-opt',
        'Google fonts list' => 'dc-subpage-googlefontslist-opt'      
     );
     

   
    /*********************************************************** 
    * Public functions
    ************************************************************/                
    public function renderTab($global_menu)
    { 
        $this->process();          
        $this->renderCMS($global_menu);        
    }

    public function getOption($opt)
    {                        
        return $this->_opt[$opt];
    }

                              
    /*********************************************************** 
    * Private functions
    ************************************************************/      

    public function setDefaults()
    { 

    }
   
    public function fontCSS()
    {
        $out = '';
        $out .= '<style type="text/css">'; 
        
            switch($this->_opt['body_font_type'])
            {
                case CMS_FONT_TYPE_BROWSER:
                    $out .= 'body { font-family:'.$this->_opt['body_font_browser'].'; } ';
                break;                
                
                case CMS_FONT_TYPE_GOOGLE:
                    $out .= 'body { font-family:'.$this->_opt['body_font_google_css'].'; } ';
                break;                                
            }
        
        
            switch($this->_opt['font_type'])
            {
                case CMS_FONT_TYPE_GOOGLE:
                    $out .= 'h1, h2, h3, h4, h5, h6 { font-family:'.$this->_opt['font_google_css'].'; } ';
                    $out .= 'h1 > a, h2 > a, h3 > a, h4 > a, h5 > a, h6 > a { font-family:\''.$this->_opt['font_google_css'].'\'; } ';
                break;
                
                case CMS_FONT_TYPE_BROWSER:
                    $out .= 'h1, h2, h3, h4, h5, h6 { font-family:'.$this->_opt['font_browser'].'; } ';
                break;
                
                case CMS_FONT_TYPE_FONT_FACE:
                    $out .= ' @font-face {
                      font-family: \''.$this->_opt['font_face'].'\'; ';                
                    $out .= 'font-style:normal; ';
                    $out .= 'font-weight:normal; ';
                    $out .= 'src: local(\''.$this->_opt['font_face'].'\'), url(\''.get_bloginfo('template_url').'/fonts/'.$this->_opt['font_face'].'\') format(\'woff\');
                    } ';     
                    
                    $out .= 'h1, h2, h3, h4, h5, h6 { font-family:\''.$this->_opt['font_face'].'\'; } '; 
                    $out .= 'h1 > a, h2 > a, h3 > a, h4 > a, h5 > a, h6 > a { font-family:\''.$this->_opt['font_face'].'\'; } ';         
                break;
            }                         
                        
        $out .= '</style>';        
        echo $out;        
    }
    
    public function getThemeCufonFontJSLink($echo=true)
    {
        $out = '';
        
        if($this->_opt['font_type'] == CMS_FONT_TYPE_CUFON) 
        {
            $out .= '<script type="text/javascript" src="'.get_bloginfo('template_url').'/fonts/'.$this->_opt['font_cufon'].'"></script>'; 
        }
            
        if($echo) { echo $out;  } else return $out;       
    }
    
    public function getThemeGoogleFontCSSLink($echo=true)
    {
        $out =  '';
        
        if($this->_opt['font_type'] == CMS_FONT_TYPE_GOOGLE)
        {
            $out .= '<link href="'.$this->_opt['font_google_url'].'" rel="stylesheet" type="text/css">';      
        }        

        if($this->_opt['body_font_type'] == CMS_FONT_TYPE_GOOGLE and 
           !($this->_opt['font_type'] == CMS_FONT_TYPE_GOOGLE and ($this->_opt['font_google_url'] == $this->_opt['body_font_google_url'])))
        {
            $out .= '<link href="'.$this->_opt['body_font_google_url'].'" rel="stylesheet" type="text/css">';      
        }          
          
        if($echo) { echo $out; } else return $out;    
    }    
   
    private function process()
    {
        $this->_process_info = '';
        $this->_process_info_error = '';
        $this->_process_info_exclamation = '';                      
        
        $this->processHeadingFont();
        $this->processBodyFont(); 
        $this->processGoogleFontsList();                                                  
    }
    
    private function processHeadingFont()
    {
        # HEADING FONT
        if($this->isMasterPage('dc-font-opt'))
        {                    
            if(isset($_POST['dc-font-save-font-opt']))
            {
                $this->_opt['font_cufon'] = $_POST['font_cufon'];
                $this->_opt['font_browser'] = $_POST['font_browser'];
                $this->_opt['font_type'] = $_POST['font_type']; 
                $this->_opt['font_google_url'] = $_POST['font_google_url'];
                
                $gfm = new DCC_GoogleFontManager();
                $font = $gfm->findFontByURL($this->_opt['font_google_url']);
                if($font != null)
                {
                    $this->_opt['font_google_css'] = $font->_css;        
                }        
                
                $this->_opt['font_face'] = $_POST['font_face'];
                
                update_option($this->_DBIDOPT_FONT, $this->_opt);            
                $this->_process_info = 'Fonts settings saved';    
            }        
            
            if(isset($_POST['dc-font-update-font-list']))
            {
                $fm = new DCC_CufonFontManager(); 
                $fm->updateFonts(); 
                $this->_process_info = 'Cufon fonts list updated';      
            }
                             
            if(isset($_POST['dc-font-update-font-face-font-list']))
            {
                $ffm = new DCC_FontFaceManager(); 
                $ffm->updateFonts(); 
                $this->_process_info = 'Font face fonts list updated';      
            }                             

        }        
    }

    private function processBodyFont()
    {
        # BODY FONT  
        if($this->isSubPage('dc-subpage-bodyfont-opt'))
        {        
            if(isset($_POST['dc-font-save-bodyfont-opt']))
            {
                $this->_opt['body_font_type'] = $_POST['body_font_type']; 
                
                $this->_opt['body_font_browser'] = $_POST['body_font_browser'];                
  
                $this->_opt['body_font_google_url'] = $_POST['body_font_google_url'];
                
                $gfm = new DCC_GoogleFontManager();
                $font = $gfm->findFontByURL($this->_opt['body_font_google_url']);
                if($font != null)
                {
                    $this->_opt['body_font_google_css'] = $font->_css;        
                }        
                
                update_option($this->_DBIDOPT_FONT, $this->_opt);            
                $this->_process_info = 'Fonts settings saved';                    
            }         
            
            if(isset($_POST['dc-font-restore-google-fonts']))
            {
                $gfm = new DCC_GoogleFontManager(); 
                $gfm->restoreDefaultFonts();    
                $this->_process_info = 'Default google fonts restored';    
            }                  
            
        }        
    }    

    private function processGoogleFontsList()
    {
        # BODY FONT  
        if($this->isSubPage('dc-subpage-googlefontslist-opt'))
        {        
            if(isset($_POST['dc-font-save-googlefontslist-opt']))
            {
                
            }
            
            if(isset($_POST['dc-font-add-google-font']))
            {
                $name = stripcslashes($_POST['new-google-font-name']);
                $css = stripcslashes($_POST['new-google-font-css']);
                $url = stripcslashes($_POST['new-google-font-url']);
                
                if($name != '' and $css != '' and $url != '')
                {
                    $gfm = new DCC_GoogleFontManager();
                    $result = $gfm->addFont($name, $css, $url);
                    if($result)
                    {
                        $this->_process_info = 'New google font added'; 
                    } else
                    {
                        $this->_process_info_exclamation = 'There was some problem with adding new google font, probably font <strong>'.$name.'</strong> is alread on list';    
                    }   
                } else
                {
                    $this->_process_info_error = 'Please fill all needed data fields';    
                }                                      
            }            
            
            if(isset($_POST['dc-font-gfonts-paging-set-perpage']))
            {
                $perpage = $_POST['dc-font-gfonts-paging-perpage'];
                $this->_opt['cms_font_google_perpage'] = $perpage;
                $this->_opt['cms_font_google_page'] = 1;  
                update_option($this->_DBIDOPT_FONT, $this->_opt);   
                $this->_process_info = 'Settings changes';
            }
            
            if(isset($_POST['dc-font-gfonts-paging-prev']))
            {
                $page = $this->_opt['cms_font_google_page'];
                if($page > 1)
                {
                    $page -= 1;
                    $this->_opt['cms_font_google_page'] = $page;
                    update_option($this->_DBIDOPT_FONT, $this->_opt);
                }    
            }
            
            if(isset($_POST['dc-font-gfonts-paging-next']))
            {
                $page = $this->_opt['cms_font_google_page'];
                $count = 0;
                $gfm = new DCC_GoogleFontManager();
                $count = $gfm->getFontsCount();
                $pages = ceil($count/$this->_opt['cms_font_google_perpage']);
                
                if($page < $pages)
                {
                    $page += 1;
                    $this->_opt['cms_font_google_page'] = $page;
                    update_option($this->_DBIDOPT_FONT, $this->_opt);
                } else
                if($page > $pages)
                {
                    $page = 1;
                    $this->_opt['cms_font_google_page'] = $page;
                    update_option($this->_DBIDOPT_FONT, $this->_opt);                        
                }   
            }            

            if(isset($_POST['dc-font-gfonts-paging-goto']))
            {
                $page = $_POST['dc-font-gfonts-paging-page'];
                $this->_opt['cms_font_google_page'] = $page;  
                update_option($this->_DBIDOPT_FONT, $this->_opt);   
                $this->_process_info = 'Settings changes';
            }
            
                  
            if(isset($_POST['dc-font-gfonts-paging-apply']))
            {
                $action = $_POST['dc-font-gfonts-paging-action'];
                $selected = $_POST['dc-font-gfonts-paging-selected'];
                if($action == 'delete')
                {
                    $gfm = new DCC_GoogleFontManager();
                    $gfm->deleteFontList($selected);
                    $this->_process_info = 'Google font was deleted';                     
                }
            }                       
            
        }        
    }   
                                                                                 
    private function renderCMS($global_menu)
    {        
        $out = '';
        $out .= $this->getTopLink();                 
        
        $out .= $this->getColumnsWraperBegin();        
            
            $out .= $this->getLeftColumnBegin();      
            
                # HEADING FONT SETTINGS
                $out .= $this->renderHeadingFontCMS();                    

                # BODY FONT SETTINGS
                $out .= $this->renderBodyFontCMS();   
                
                # GOOGLE FONTS LIST SETTINGS
                $out .= $this->renderGoogleFontsListCMS();          
            
            $out .= $this->getLeftColumnsEnd();
            $out .= $this->renderNav($global_menu);                        
                   
        $out .= $this->getColumnsWraperEnd();    
        echo $out;    
                                                           
    }         

    public function renderHeadingFontCMS($echo=false)
    {
        $out = ''; 
    
        if($this->isMasterPage('dc-font-opt'))
        {            
            $out .= $this->getPanelBegin('Heading font settings');
            
                // table start
                $out .= '<form action="#" method="post">';
             
                    $out .= '<div class="dc-cms-submit-panel-top">';
                        $out .= '<input class="dc-cms-submit-btn-primary" type="submit" name="dc-font-save-font-opt" value="Save changes"> ';                            
                        $out .= $this->getPanelProcessInfo();                            
                    $out .= '</div>';                 
             
                    $out .= $this->getPanelSectionHead('Heading font type'); 

                    $out .= '<table class="dc-cms-table-standard">';
                        $out .= '<tbody>'; 
                                                                                                  
                        // font type
                        $out .= '<tr><td><span class="dc-cms-left-marked-title">Font type</span></td><td>';
                            $out .= '<div class="dc-cms-inputs-field-nomargin">';
                                $out .= '<input type="radio" name="font_type" value="'.CMS_FONT_TYPE_BROWSER.'" '.$this->attrChecked($this->_opt['font_type'] == CMS_FONT_TYPE_BROWSER).' /> Native browser font'; 
                                $out .= $this->getBR();
                                $out .= '<input type="radio" name="font_type" value="'.CMS_FONT_TYPE_CUFON.'" '.$this->attrChecked($this->_opt['font_type'] == CMS_FONT_TYPE_CUFON).' /> Cufon font';   
                                $out .= $this->getBR();
                                $out .= '<input type="radio" name="font_type" value="'.CMS_FONT_TYPE_FONT_FACE.'" '.$this->attrChecked($this->_opt['font_type'] == CMS_FONT_TYPE_FONT_FACE).' /> Font face font';                                                        
                                $out .= $this->getBR();
                                $out .= '<input type="radio" name="font_type" value="'.CMS_FONT_TYPE_GOOGLE.'" '.$this->attrChecked($this->_opt['font_type'] == CMS_FONT_TYPE_GOOGLE).' /> Google font';                                                            
                            $out .= '</div>';
                        $out .= '</td></tr>';                   
                        
                        $out .= '</tbody>';
                    $out .= '</table>';
             
                    $out .= $this->getPanelSectionHead('Browser font', 50); 
                    $out .= '<table class="dc-cms-table-standard">';  
                        $out .= '<tbody>';
                                                                                                                         
                        // choose browser font
                        $out .= '<tr><td><span class="dc-cms-left-marked-title">Select your favorite native browser font</span></td><td>';
                        $out .= '<span class="dc-cms-control-top-label-nomargin">Native browser fonts list</span>';
                        $browser_fonts = array(
                            'Arial', 'Helvetica', 'Times', 'Times New Roman', 'Courier', 
                            'Courier New', 'Verdana', 'Tahoma', 'Arial Black', 'Comic Sans MS', 'Trebuchet MS', 'Impact', 'Avant Garde',
                            'Georgia', 'Palatino', 'Bookman', 'Garamond', 'Century Schoolbook');
                        $out .= '<select class="dc-cms-control-300" name="font_browser">';
                            foreach($browser_fonts as $font)
                            {
                                $out .= '<option '.($this->_opt['font_browser'] == $font ? ' selected="selected" ' : '').'>'.$font.'</option>';
                            }
                        $out .= '</select>';
                        $out .= '</td></tr>';                   
                        
                        $out .= '</tbody>';
                    $out .= '</table>';
                        
             
                    $out .= $this->getPanelSectionHead('Cufon font', 50);                 
                    $out .= '<table class="dc-cms-table-standard">'; 
                        $out .= '<tbody>';                                                                
                                                                                                  
                        // choose cufon font file
                        $out .= '<tr><td><span class="dc-cms-left-marked-title">Select your favorite Cufon font from list</span></td><td>';
                        $fm = new DCC_CufonFontManager('fonts');
                        $out .= '<span class="dc-cms-control-top-label-nomargin">Cufon fonts list</span>'; 
                        $out .= $fm->selectFontList($this->_opt['font_cufon'], 'font_cufon', 300);
                        $out .= '<div class="dc-cms-btn-frame">';
                            $out .= '<input class="dc-cms-submit-btn" type="submit" name="dc-font-update-font-list" value="Update font list"> ';  
                        $out .= '</div>';                            
                        $out .= '<div class="dc-cms-help-note-box">';
                            $out .= 'To add completely new Cufon font, place .js font file into <span class="dc-cms-marked-span">fonts</span> folder. Next click <span class="dc-cms-marked-span">Update font list</span> button.';
                        $out .= '</div>';                        
                        $out .= '</td></tr>';                   
                        
                        $out .= '</tbody>';
                    $out .= '</table>';

                    $out .= $this->getPanelSectionHead('Font face font', 50);
             
                    $out .= '<table class="dc-cms-table-standard">';    
                        $out .= '<tbody>';
                    
                        // choose font face font 
                        $out .= '<tr><td><span class="dc-cms-left-marked-title">Select your favorite font face font from list</span></td><td>';
                        $ffm = new DCC_FontFaceManager('fonts'); 
                        $out .= '<span class="dc-cms-control-top-label-nomargin">Font face fonts list</span>'; 
                        $out .= $ffm->selectFontList($this->_opt['font_face'], 'font_face', 300);
                        
                        $out .= '<div class="dc-cms-btn-frame">';
                            $out .= '<input class="dc-cms-submit-btn" type="submit" name="dc-font-update-font-face-font-list" value="Update font face font list"> ';  
                        $out .= '</div>';                            
                        $out .= '<div class="dc-cms-help-note-box">';
                            $out .= 'To add completely new font face font, place .woff font file into <span class="dc-cms-marked-span">fonts</span> folder. Next click <span class="dc-cms-marked-span">Update font face font list</span> button.';
                        $out .= '</div>';                              
                        
                        $out .= '</td></tr>';                                                
                    
                        $out .= '</tbody>';
                    $out .= '</table>';
                    
                    $out .= $this->getPanelSectionHead('Google font', 50);
             
                    $out .= '<table class="dc-cms-table-standard">';                         
                        $out .= '<tbody>';
                    
                        // choose google font 
                        $out .= '<tr><td><span class="dc-cms-left-marked-title">Select your favorite Google font from list</span></td><td>';
                        $gfm = new DCC_GoogleFontManager(); 
                        $out .= '<span class="dc-cms-control-top-label-nomargin">Google fonts list</span>'; 
                        $out .= $gfm->selectFontList($this->_opt['font_google_url'], 'font_google_url', 300);
                        
                        $out .= '<div class="dc-cms-btn-frame">';
                            $out .= '<input class="dc-cms-submit-btn" type="submit" onclick="return confirm(\'Restore Google font list? You will lost all manually added Google fonts.\')" name="dc-font-restore-google-fonts" value="Restore default google fonts"> ';  
                        $out .= '</div>';                             
                        $out .= '</td></tr>';                                                                                                                                                       
                    
                        $out .= '</tbody>';
                    $out .= '</table>';                        
                    
                         
                    
                    $out .= '<div class="dc-cms-submit-panel-bottom">';
                        $out .= '<input class="dc-cms-submit-btn-primary" type="submit" name="dc-font-save-font-opt" value="Save changes"> ';
                    $out .= '</div>';
                $out .= '</form>';                           
                    
            $out .= $this->getPanelEnd();               
        }    
    
        if($echo) { echo $out; } else { return $out; } 
    }    
    

    public function renderBodyFontCMS($echo=false)
    {
        $out = ''; 
    
        if($this->isSubPage('dc-subpage-bodyfont-opt'))
        {            
            $out .= $this->getPanelBegin('Body font settings');
            
                // table start
                $out .= '<form action="#" method="post">';
             
                    $out .= '<div class="dc-cms-submit-panel-top">';
                        $out .= '<input class="dc-cms-submit-btn-primary" type="submit" name="dc-font-save-bodyfont-opt" value="Save changes"> ';                            
                        $out .= $this->getPanelProcessInfo();                            
                    $out .= '</div>';                 
                                     
                        $out .= $this->getPanelSectionHead('Body font type'); 

                        $out .= '<table class="dc-cms-table-standard">';
                            $out .= '<tbody>'; 
                                                                                                      
                            // font type
                            $out .= '<tr><td><span class="dc-cms-left-marked-title">Font type</span></td><td>';
                                $out .= '<div class="dc-cms-inputs-field-nomargin">';                                    
                                    $out .= '<input type="radio" name="body_font_type" value="'.CMS_FONT_TYPE_BROWSER.'" '.$this->attrChecked($this->_opt['body_font_type'] == CMS_FONT_TYPE_BROWSER).' /> Native browser font';                                
                                    $out .= $this->getBR();
                                    $out .= '<input type="radio" name="body_font_type" value="'.CMS_FONT_TYPE_GOOGLE.'" '.$this->attrChecked($this->_opt['body_font_type'] == CMS_FONT_TYPE_GOOGLE).' /> Google font'; 
                                $out .= '</div>';
                            $out .= '</td></tr>';                   
                            
                            $out .= '</tbody>';
                        $out .= '</table>';     
                        
                        $out .= $this->getPanelSectionHead('Browser font', 50); 
                        $out .= '<table class="dc-cms-table-standard">';  
                            $out .= '<tbody>';
                                                                                                                             
                            // choose browser font
                            $out .= '<tr><td><span class="dc-cms-left-marked-title">Select your favorite native browser font</span></td><td>';
                            $out .= '<span class="dc-cms-control-top-label-nomargin">Native browser fonts list</span>';
                            $browser_fonts = array(
                                'Arial', 'Helvetica', 'Times', 'Times New Roman', 'Courier', 
                                'Courier New', 'Verdana', 'Tahoma', 'Arial Black', 'Comic Sans MS', 'Trebuchet MS', 'Impact', 'Avant Garde',
                                'Georgia', 'Palatino', 'Bookman', 'Garamond', 'Century Schoolbook');
                            $out .= '<select class="dc-cms-control-300" name="body_font_browser">';
                                foreach($browser_fonts as $font)
                                {
                                    $out .= '<option value="'.$font.'" '.($this->_opt['body_font_browser'] == $font ? ' selected="selected" ' : '').'>'.$font.'</option>';
                                }
                            $out .= '</select>';
                            $out .= '</td></tr>';                   
                            
                            $out .= '</tbody>';
                        $out .= '</table>'; 
                        
                    $out .= $this->getPanelSectionHead('Google font', 50);
             
                    $out .= '<table class="dc-cms-table-standard">';                         
                        $out .= '<tbody>';
                    
                        // choose google font file 
                        $out .= '<tr><td><span class="dc-cms-left-marked-title">Select your favorite Google font from list</span></td><td>';
                        $gfm = new DCC_GoogleFontManager(); 
                        $out .= '<span class="dc-cms-control-top-label-nomargin">Google fonts list</span>'; 
                        $out .= $gfm->selectFontList($this->_opt['body_font_google_url'], 'body_font_google_url', 300);
                        
                        $out .= '<div class="dc-cms-btn-frame">';
                            $out .= '<input class="dc-cms-submit-btn" type="submit" onclick="return confirm(\'Restore Google font list? You will lost all manually added Google fonts.\')" name="dc-font-restore-google-fonts" value="Restore default google fonts"> ';  
                        $out .= '</div>';                             
                        $out .= '</td></tr>';                                                                                                                                                       
                    
                        $out .= '</tbody>';
                    $out .= '</table>';                                                                                  
                    
                    $out .= '<div class="dc-cms-submit-panel-bottom">';
                        $out .= '<input class="dc-cms-submit-btn-primary" type="submit" name="dc-font-save-bodyfont-opt" value="Save changes"> ';
                    $out .= '</div>';
                $out .= '</form>';                           
                    
            $out .= $this->getPanelEnd();               
        }    
    
        if($echo) { echo $out; } else { return $out; } 
    }     
    

    public function renderGoogleFontsListCMS($echo=false)
    {
        $out = ''; 
    
        if($this->isSubPage('dc-subpage-googlefontslist-opt'))
        {            
            $out .= $this->getPanelBegin('Google fonts list');
            
                // table start
                $out .= '<form action="#" method="post">';
             
                    $out .= '<div class="dc-cms-submit-panel-top">';
                        $out .= '<input class="dc-cms-submit-btn-primary" type="submit" name="dc-font-save-googlefontslist-opt" value="Save changes"> ';                            
                        $out .= $this->getPanelProcessInfo();                            
                    $out .= '</div>';                 
                         
                    $out .= $this->getPanelSectionHead('Add new google font');
             
                    $out .= '<table class="dc-cms-table-standard">';                         
                        $out .= '<tbody>';
                    
                        $gfm = new DCC_GoogleFontManager();                                                                                                                                  
                    
                        $out .= '<tr><td><span class="dc-cms-left-marked-title">Fill fields with proper data to add new Google font</span></td><td>';
                            $out .= '<span class="dc-cms-control-top-label-nomargin">Google font name</span>';
                            $out .= '<input class="dc-cms-control-300" type="text" name="new-google-font-name" />';
                            
                            $out .= '<span class="dc-cms-control-top-label">Google font CSS family</span>';
                            $out .= '<input class="dc-cms-control-300" type="text" name="new-google-font-css" />';
                            
                            $out .= '<span class="dc-cms-control-top-label">Google font resource URL</span>';
                            $out .= '<input class="dc-cms-control-300" type="text" name="new-google-font-url" />'; 
                            
                            $out .= '<div class="dc-cms-btn-frame">';
                                $out .= '<input class="dc-cms-submit-btn" type="submit" name="dc-font-add-google-font" value="Add google font"> ';                                 
                            $out .= '</div>';
                            
                            $out .= '<div class="dc-cms-help-note-box">';
                                $out .= '<a href="http://www.google.com/webfonts" target="_blank">Google Web Fonts</a>';
                            $out .= '</div>';                                
                        $out .= '</td></tr>';
                    
                        $out .= '</tbody>';
                    $out .= '</table>';                           
                         
                    $out .= $this->getPanelSectionHead('Google fonts list', 50); 
                    $list = $gfm->getFontList(); 
                    
                    $out .= '<table class="dc-cms-table-standard">';                                                                      
                        $out .= '<tbody>';
                    
                        $out .= '<tr><td><span class="dc-cms-left-marked-title">Here you can delete particular Google fonts from list</span></td><td>';                           
                        
                            if(is_array($list))
                            {
                                $count = count($list);
                                
                                $perpage = (int)$this->_opt['cms_font_google_perpage']; 
                                if($perpage <= 0 ) { $perpage = 5; }
                                $pages = ceil($count / $perpage); 
                                
                                if($pages == 0) { $pages = 1; }
                                $page = $this->_opt['cms_font_google_page'];
                                if($page > $pages) { $page = 1; }
                                if($page < 1) { $page = 1; }
                                
                                $out .= '<div class="dc-cms-google-fonts-list">';
                                $out .= '<div class="dc-cms-google-fonts-list-paging">';
                                    $out .= '<div class="top-info">';
                                        $out .= '<div class="items-count">'.$count.' '.($count > 1 ? 'items' : 'item').'</div>';
                                    $out .= '</div>';
                                
                                    $out .= '<div class="left-side">';
                                    
                                        $out .= '<select name="dc-font-gfonts-paging-action" class="dc-cms-control-120">';
                                            $out .= '<option value="none">Bulk Actions</option>';
                                            $out .= '<option value="delete">Delete</option>';
                                        $out .= '</select> ';                                    
                                        $out .= '<input class="dc-cms-submit-btn-paging" type="submit" name="dc-font-gfonts-paging-apply" value="Apply"> ';
                                    
                                        $out .= '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
                                    
                                        $out .= '<select name="dc-font-gfonts-paging-page" class="dc-cms-control-60">';
                                            for($i = 1; $i <= $pages; $i++)
                                            {
                                                $out .= '<option value="'.$i.'" '.($i == $page ? ' selected="selected"' : '').'>'.$i.'</option>';
                                            }
                                        $out .= '</select> ';
                                        $out .= '<input class="dc-cms-submit-btn-paging" type="submit" name="dc-font-gfonts-paging-goto" value="Go to page"> '; 
                                        
                                        $out .= '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'; 
                                        
                                        $out .= '<select name="dc-font-gfonts-paging-perpage" class="dc-cms-control-60">';
                                            $perpage_sizes = array(5, 10, 20, 40, 60, 80, 100, 120, 160, 200);
                                            foreach($perpage_sizes as $size)
                                            {
                                                $out .= '<option value="'.$size.'" '.($perpage == $size ? ' selected="selected" ' : '').'>'.$size.'</option>';
                                            }
                                        $out .= '</select> ';
                                        $out .= '<input class="dc-cms-submit-btn-paging" type="submit" name="dc-font-gfonts-paging-set-perpage" value="Per page"> ';                                           
                                        
                                    $out .= '</div>';
                                    $out .= '<div class="right-side">';
                                        $out .= '<span class="pages-count">'.$page.' / '.$pages.'</span>';
                                        $out .= '<input class="dc-cms-submit-btn-paging" '.($page == 1 ? ' disabled="disabled" ' : '').' type="submit" name="dc-font-gfonts-paging-prev" value="Prev"> ';
                                        $out .= '<input class="dc-cms-submit-btn-paging" '.($page == $pages ? ' disabled="disabled" ' : '').' type="submit" name="dc-font-gfonts-paging-next" value="Next"> ';                                        
                                    $out .= '</div>';
                                $out .= '</div>';
                                
                                $out .= '<table class="dc-cms-table-fat">';
                                
                                    $out .= '<thead>';
                                        $out .= '<tr>';
                                            $out .= '<th scope="col" id="cb" class="manage-column column-cb check-column" style=""><input type="checkbox" /></th>';    
                                            $out .= '<th>Font description</th>';
                                        $out .= '</tr>';
                                    $out .= '</thead>';
                                    
                                    $out .= '<tfoot>';
                                        $out .= '<tr>';
                                        $out .= '<th scope="col" id="cb" class="manage-column column-cb check-column" style=""><input type="checkbox" /></th>'; 
                                        $out .= '<th>Font description</th>';
                                        $out .= '</tr>';
                                    $out .= '</tfoot>';
                                    $out .= '<tbody>';
                                
                                    $index = 0;
                                    $start = ($page-1)*$perpage;
                                    $end = $start + $perpage;
                                    if($end > $count) { $end = $count; }
                                    for($i = $start; $i < $end; $i++)
                                    {
                                        $out .= '<tr>';
                                            $out .= '<th scope="row" class="check-column"><input type="checkbox" name="dc-font-gfonts-paging-selected[]" value="'.$index.'"></th>';
                                            $out .= '<td>';
                                           
                                                $out .= '<div class="inner-item">';
                                                        $out .= '<span class="label">Name: </span>'.$list[$i]->_name;
                                                        $out .= $this->getBR();
                                                        $out .= '<span class="label">Family: </span>'.$list[$i]->_css;
                                                        $out .= $this->getBR();
                                                        $out .= '<span class="label">URL: </span><a href="'.$list[$i]->_url.'" target="_blank">'.$list[$i]->_url.'</a>';  
                                                $out .= '</div>';                                                
                                            
                                            $out .= '</td>';
                                        $out .= '</tr>';
                                        
                                        $index++;
                                    }

                                    $out .= '</tbody>';
                                $out .= '</table>';
                                   
                                $out .= '</div>';                                      
                                
                            }


                        $out .= '</td></tr>';
                        
                        $out .= '</tbody>';                       
                    $out .= '</table>';                                       
                    
                    $out .= '<div class="dc-cms-submit-panel-bottom">';
                        $out .= '<input class="dc-cms-submit-btn-primary" type="submit" name="dc-font-save-googlefontslist-opt" value="Save changes"> ';
                    $out .= '</div>';
                $out .= '</form>';                           
                    
            $out .= $this->getPanelEnd();               
        }    
    
        if($echo) { echo $out; } else { return $out; } 
    }         
    
    
    public function getExportedData()
    {
        $export = array(
            'version' => '1.0',
            'name' => 'DCC_ControlPanelFont',
            'data' => array()
        );
        
        $obj_font_opt = new DCC_ExportDataCMSObject();        
        $obj_font_opt->name = '_opt';
        $obj_font_opt->version = '1.0'; 
        $obj_font_opt->data = serialize($this->_opt);
        
        array_push($export['data'], $obj_font_opt);
        
        return $export;  
    }    
    
    public function setImportedData($import)    
    {
        $result = array('status' => false, 'message' => 'Error');  
        
        if($import['version'] == '1.0' and $import['name'] == 'DCC_ControlPanelFont')
        {
            $obj_font_opt = null;
            
            if(is_array($import['data']))
            {
                foreach($import['data'] as $obj)
                {
                    switch($obj->name)
                    {
                        case '_opt':
                        {
                            if($obj->version == '1.0')
                            {
                                $obj_font_opt = $obj;                                                                
                            }    
                        } break;                      
                    }
                }
            } 
            
            if(($obj_font_opt !== null))
            {
                $this->_opt = unserialize($obj_font_opt->data);                              
                update_option($this->_DBIDOPT_FONT, $this->_opt);  
            
                $result['status'] = true;
                $result['message'] = 'OK - Font options updated successfully';
            } else
            {
                $result['message'] = 'Error';
            }
        }
        
        return $result;
    }    
     
} // class
        
        
?>