<?php
/**********************************************************************
* OSAKA UNLIMITED WORDPRESS THEME 
* (Ideal For Business And Personal Use: Portfolio or Blog)     
* 
* File name:   
*      cp_builder.php
* Brief:       
*      Part of theme control panel.
* Author:      
*      DigitalCavalry
* Author URI:
*      http://themeforest.net/user/DigitalCavalry
* Contact:
*      digitalcavalry@gmail.com 
***********************************************************************/

/*********************************************************** 
* Class name:
*    DCC_ControlPanelBuilder
* Descripton:
*    Implementation of DCC_ControlPanelBuilder 
***********************************************************/
class DCC_ControlPanelBuilder extends DCC_BasicTools
{

    /*********************************************************** 
    * Constructor
    ************************************************************/
    public function __construct() 
    {
    
    } // constructor 

    /*********************************************************** 
    * Public members
    ************************************************************/      
    public $_meta = array();
    
    
    public function renderContent($args=array(), $echo=true)
    {        
        global $post;
        $meta = null;
        
        $def = array(
            'id' => null
        );        
        
        $args = $this->combineArgs($def, $args);                
        
        if($args['id'] === null) 
        {              
            $args['id'] = $post->ID; 
        }
        
        if(!array_key_exists($args['id'], $this->_meta))
        {
            $meta = get_post_meta($args['id'], 'content_builder_opt', true);
            if($meta != '')
            {
                $this->_meta[$args['id']] = $meta; 
            }  
        } else
        {
            $meta = & $this->_meta[$args['id']];
        }
        
        $out = '';
               
        
        
        if($meta != null)
        { 
            $out .= '<div class="dc-content-builder-wrapper">'; 
            
            $counter = 0;            
            foreach($meta->cells as $cell)
            {   
                if(!$cell->common['display']) { continue; }
                     
                $out .= self::getColumnStart($cell);
                    $out .= self::renderCell($cell);    
                $out .= self::getColumnEnd();               
            }
            
            $out .= '<div class="dc-clear-both"></div>';
            $out .= '</div>';                         
        }  
        
        if($echo) { echo $out; } else { return $out; }
    }
    
    /*********************************************************** 
    * Private members
    ************************************************************/ 
    private function renderCell($cell, $echo=false)
    {
        $out = ''; 
        
        switch($cell->core['type'])
        {
            case 'blog':                 $out .= self::renderTypeBlog($cell);              break;            
            case 'post':                 $out .= self::renderTypePost($cell);              break;  
            case 'page-content':         $out .= self::renderTypePageContent($cell);       break;            
            case 'page-title':           $out .= self::renderTypePageTitle($cell);         break;           
            case 'heading':              $out .= self::renderTypeHeading($cell);           break; 
            case 'colored-head':         $out .= self::renderTypeColoredHead($cell);       break;
            case 'sidebar':              $out .= self::renderTypeSidebar($cell);           break;
            case 'gmap':                 $out .= self::renderTypeGoogleMap($cell);         break;
            case 'cform':                $out .= self::renderTypeContactForm($cell);       break;
            case 'text':                 $out .= self::renderTypeText($cell);              break; 
            case 'empty-space':          $out .= self::renderTypeEmptySpace($cell);        break; 
            case 'top-anchor':           $out .= self::renderTypeTopAnchor($cell);         break;  
            case 'line-divider':         $out .= self::renderTypeLineDivider($cell);       break;
            case 'img-divider':          $out .= self::renderTypeImgDivider($cell);        break; 
            case 'note':                 $out .= self::renderTypeNote($cell);              break;     
            case 'blockquote':           $out .= self::renderTypeBlockquote($cell);        break; 
            case 'ul-list':              $out .= self::renderTypeUnorderedList($cell);     break; 
            case 'postbox':              $out .= self::renderTypePostBox($cell);           break;    
            case 'pagebox':              $out .= self::renderTypePageBox($cell);           break;
            case 'tip':                  $out .= self::renderTypeTip($cell);               break;   
            case 'image':                $out .= self::renderTypeImage($cell);             break;  
            case 'video':                $out .= self::renderTypeVideo($cell);             break;   
            case 'ngg':                  $out .= self::renderTypeNGG($cell);               break;  
            case 'ngg-thumbs-slider':    $out .= self::renderTypeNGGThumbsSlider($cell);   break;
            case 'ngg-gallery':          $out .= self::renderTypeNGGBoxGallery($cell);     break; 
            case 'ngg-recent-slider':    $out .= self::renderTypeNGGRecentSlider($cell);   break;
            case 'service':              $out .= self::renderTypeService($cell);           break;
            case 'project':              $out .= self::renderTypeProject($cell);           break; 
            case 'basic-slider':         $out .= self::renderTypeBasicSlider($cell);       break;
            case 'code':                 $out .= self::renderTypeCode($cell);              break;
            case 'board-slider':         $out .= self::renderTypeBoardSlider($cell);       break;
            case 'anno-box':             $out .= self::renderTypeAnnoBox($cell);           break;
              
            case 'recent-posts-list':    $out .= self::renderTypeRecentPostsList($cell);   break;   
            case 'download':             $out .= self::renderTypeDownload($cell);          break; 
            case 'member':               $out .= self::renderTypeMember($cell);            break;
            case 'wgt-member':           $out .= self::renderTypeWgtMember($cell);         break; 
            case 'wgt-twitter':          $out .= self::renderTypeWgtTwitter($cell);        break;                                                                           
        }                
        
        if($echo) { echo $out; } else { return $out; }     
    }
    
    public function renderTypeBlog($cell)
    {                
        if(!is_array($cell->blog['cat'])) { $cell->blog['cat'] = array(); }
        if(!is_array($cell->blog['cat-excluded'])) { $cell->blog['cat-excluded'] = array(); }
        
        $paged = GetDCCPI()->getIRenderer()->getPagedQueryVar();
        $args = array('paged' => $paged, 'post_type' => 'post', 'post_status' => 'publish');
        
        if(count($cell->blog['cat'])) { $args['cat'] = implode(', ', $cell->blog['cat']); } 
        if(count($cell->blog['cat-excluded'])) { $args['category__not_in'] = $cell->blog['cat-excluded']; }
        $args['order'] = $cell->blog['order'];  
        $args['orderby'] = $cell->blog['order-by'];  
        $args['posts_per_page'] = $cell->blog['per-page'];                                                               

        $layout = $cell->blog['layout'];
        
        $dc_query = new WP_Query($args);                             
        
        $out = ''; 
        for($i = 0; $i < $dc_query->post_count; $i++)
        {
            if($i > 0) { $out .= '<div class="blog-post-short-separator"></div>'; }
            $p = new DCC_WPPost($dc_query->posts[$i]);
            
            $out .= GetDCCPI()->getIRenderer()->wpPostShort(array('post' => $p, 'layout' => $layout));                               
        }           
        
        if($cell->blog['pagination'])
        {                                                                            
            $out .= GetDCCPI()->getIRenderer()->wpQueryPaginationBlock(array('paged' => $paged, 'maxpage' => $dc_query->max_num_pages, 'top' => 10, 'pb' => 0));                  
        }
        
        return $out;    
    }

    public function renderTypePost($cell)
    {
        $id = $cell->post['id'];
        $layout = $cell->post['layout'];
        
        $out = '';   
             
        if($id != '')
        {
            $out .= GetDCCPI()->getIRenderer()->wpPostShort(array('id' => $id, 'layout' => $layout));                               
        }
        
        return $out;    
    }
         
    public function renderTypePageContent($cell)
    {
        global $post;
        $content = $post->post_content;
        
        if($cell->page_content['page_use'] and $cell->page_content['page'] != CMS_NOT_SELECTED)
        {
            global $wpdb;
            $c = $wpdb->get_row("SELECT post_content FROM $wpdb->posts WHERE ID = ".$cell->page_content['page']); 
            
            if($c !== null)
            {                
                $content = $c->post_content;    
            }            
        }
        
        $out = '';               
        $out .= apply_filters('the_content', $content); 
        
        if($cell->page_content['pagination'])
        {
            $out .= GetDCCPI()->getIRenderer()->wpPaginationBlock(false); 
        }
        
        return $out;    
    }         

    public function renderTypePageTitle($cell)
    {                      
        global $post;
        global $dc_page_common_opt;
        
        $title = '';
        $subtitle = '';
        
        if($cell->page_title['title_use'] != '') { $title = $cell->page_title['title']; } else { $title = $post->post_title; }
        if($cell->page_title['subtitle_use'] != '') { $subtitle = $cell->page_title['subtitle']; } else { $subtitle = $dc_page_common_opt['page_misc_subtitle']; }        
        
        $out = '';
        
        if($title != '' or $subtitle != '')
        {
            $style = '';
            if($cell->page_title['title_color_use']) { $style .= 'color:'.$cell->page_title['title_color'].';'; }
            $style .= 'text-align:'.$cell->page_title['align_title'].';';
            $style = ' style="'.$style.'" ';
            
            $out .= '<h1 '.$style.'>';
                if($title != '') { $out .= $title; }                          
                if($subtitle != '') { $out .= '<span>'.$subtitle.'</span>'; }
            $out .= '</h1>';
        }
        
        if($cell->page_title['text_use'] and $cell->page_title['text'] != '')
        {
            $style = '';
            $style .= 'text-align:'.$cell->page_title['align_text'].';';
            $style = ' style="'.$style.'" ';

            $cell->page_title['text'] = wptexturize($cell->page_title['text']);
            $cell->page_title['text'] = convert_smilies($cell->page_title['text']);
            $cell->page_title['text'] = convert_chars($cell->page_title['text']);
            $cell->page_title['text'] = wpautop($cell->page_title['text']);   
            $out .= '<div class="dc-seg-page-title-text" '.$style.'>'.wpautop($cell->page_title['text']).'</div>';
        }
        
        return $out;    
    }  

    public function renderTypeHeading($cell)
    {        
        $out = '';      
        
        $style = '';
        $style .= 'text-align:'.$cell->heading['align'].';';
        if($cell->heading['title_font_sizes_use'])
        {
            $style .= 'font-size:'.$cell->heading['title_fsize'].'px;';
            $style .= 'line-height:'.$cell->heading['title_lheight'].'px;';
        }
        if($cell->heading['title_color_use']) 
        {
            $style .= 'color:'.$cell->heading['title_color'].';';
        }
        
        $style = ' style="'.$style.'" ';
        
        $size = (int)$cell->heading['size']; 
        
        $out .= '<h'.$size.' '.$style.'>';
            if($cell->heading['title_use'])  
            {   
                $out .= $cell->heading['title'];
            }
            
            if($cell->heading['subtitle_use'])
            {
                $style = '';
                if($cell->heading['subtitle_pt'] > 0)
                {
                    $style .= 'padding-top:'.$cell->heading['subtitle_pt'].'px;';
                }
                if($cell->heading['subtitle_font_sizes_use'])
                {
                    $style .= 'font-size:'.$cell->heading['subtitle_fsize'].'px;';
                    $style .= 'line-height:'.$cell->heading['subtitle_lheight'].'px;';
                }
                if($cell->heading['subtitle_color_use']) 
                {
                    $style .= 'color:'.$cell->heading['subtitle_color'].';';
                }            
                
                $style = ' style="'.$style.'" ';                
                
                $out .= '<span '.$style.'>';
                    $out .= $cell->heading['subtitle'];
                $out .= '</span>';
            }
        $out .= '</h'.$size.'>';

        return $out;    
    }  
                     
    public function renderTypeSidebar($cell)
    {
        $sid = $cell->sidebar['sid'];
        $wrapper = CMS_SIDEBAR_LEFT;        
        
        $out = '';               
        $out .= GetDCCPI()->getIGeneral()->getSidebar(array('id' => $sid, 'side' => $wrapper), false);
        
        return $out;    
    }  
    
    public function renderTypeGoogleMap($cell)
    {        
        $out = '';        
        
        $out .= '<div class="dc-gmap-container">';
            $out .= '<span class="dc-hidden-opt gmap_type">'.$cell->gmap['type'].'</span>';
            $out .= '<span class="dc-hidden-opt gmap_zoom">'.$cell->gmap['zoom'].'</span>';
            $out .= '<span class="dc-hidden-opt gmap_wheel">'.(int)$cell->gmap['wheel'].'</span>';  
            $out .= '<span class="dc-hidden-opt gmap_controls">'.(int)$cell->gmap['controls'].'</span>';
            $out .= '<span class="dc-hidden-opt gmap_height">'.(int)$cell->gmap['height'].'</span>';
            $out .= '<span class="dc-hidden-opt gmap_latitude">'.(string)$cell->gmap['latitude'].'</span>'; 
            $out .= '<span class="dc-hidden-opt gmap_longitude">'.(string)$cell->gmap['longitude'].'</span>';
            $out .= '<span class="dc-hidden-opt gmap_marker_display">'.(int)$cell->gmap['marker-display'].'</span>'; 
            $out .= '<span class="dc-hidden-opt gmap_marker_popup">'.(int)$cell->gmap['marker-popup'].'</span>';
            $out .= '<span class="dc-hidden-opt gmap_marker_text">'.trim($cell->gmap['marker-text']).'</span>';
            $out .= '<span class="dc-hidden-opt gmap_marker_head">'.trim($cell->gmap['marker-head']).'</span>';      
            
            if($cell->gmap['hue_use']) { $out .= '<span class="dc-hidden-opt gmap_hue">'.$cell->gmap['hue'].'</span>'; }
            if($cell->gmap['saturation_use']) { $out .= '<span class="dc-hidden-opt gmap_saturation">'.(int)$cell->gmap['saturation'].'</span>'; }
            if($cell->gmap['lightness_use']) { $out .= '<span class="dc-hidden-opt gmap_lightness">'.(int)$cell->gmap['lightness'].'</span>'; }
            if($cell->gmap['gamma_use']) { $out .= '<span class="dc-hidden-opt gmap_gamma">'.(int)$cell->gmap['gamma'].'</span>'; }                                                                 
        $out .= '</div>';                                 
        
        return $out;
    }
    
    public function renderTypeText($cell)
    {
        $out = '';  
        
        if($cell->text['sc_filter'])
        {
            $out .= do_shortcode($cell->text['content']);
        } else
        {
            $out .= apply_filters('the_content', $cell->text['content']);
        }
        
        return $out;        
    }
         
    public function renderTypeContactForm($cell)
    {
        $out = '';
        
        $id = $cell->cform['id'];
        $address = $cell->cform['address'];
        
        
        
        $out .= GetDCCPI()->getIRenderer()->getStdContactForm(array('id' => $id, 'address' => $address));
        
        return $out;
    }  
    
    public function renderTypeEmptySpace($cell)
    {
        $out = '';  
        
        $h = $cell->empty_space['h'];
        
        $out .= GetDCCPI()->getIShortcodes()->render_dcs_empty_space(array('h' => $h));
        
        return $out;  
    }   

    public function renderTypeTopAnchor($cell)
    {
        $out = '';  
        
        $text = $cell->top_anchor['text'];
        
        $out .= GetDCCPI()->getIShortcodes()->render_dcs_top(array('top' => 0, 'bottom' => 0, 'text' => $text));
        
        return $out;  
    }       
    
    public function renderTypeLineDivider($cell)
    {
        $out = '';  
        
        $bsize = $cell->line_divider['bsize'];
        $bstyle = $cell->line_divider['bstyle'];
        $bcolor = $cell->line_divider['bcolor'];
        
        $args = array(
            'top' => 0,
            'bottom' => 0,
            'bstyle' => $bstyle, // solid, dashed, dotted 
            'bcolor' => $bcolor,
            'bsize' => $bsize
        );
        
        $out .= GetDCCPI()->getIShortcodes()->render_dcs_line_divider($args);
        
        return $out;  
    }        
    
    public function renderTypeImgDivider($cell)
    {
        $out = '';  
        
        $h = $cell->img_divider['h'];
        $pattern = $cell->img_divider['pattern']; 
        $bgrepeat = $cell->img_divider['bgrepeat'];
        $bgpos = $cell->img_divider['bgpos'];
        $bgimage = $cell->img_divider['bgimage'];
        $bgcolor = $cell->img_divider['bgcolor']; 
        $bgcolor_use = $cell->img_divider['bgcolor_use'] ? 'true' : 'false'; 
        
        $args = array(
            'top' => 0,
            'bottom' => 0,        
            'bgimage' => $bgimage,
            'bgrepeat' => $bgrepeat,
            'bgpos' => $bgpos,
            'bgcolor' => $bgcolor,
            'bgcolor_use' => $bgcolor_use,            
            'h' => $h,
            'pattern' => $pattern
        );
        
        $out .= GetDCCPI()->getIShortcodes()->render_dcs_img_divider($args);
        
        return $out;  
    }         
    
    public function renderTypeNote($cell)
    {
        $out = '';  
        
        $color = $cell->note['color'];
        $bgcolor = $cell->note['bgcolor'];         
        $bcolor = $cell->note['bcolor']; 
        $align = $cell->note['align'];
        $bwidth = $cell->note['bwidth']; 
        $rounded = $cell->note['rounded'];
        $execute = $cell->note['execute'] ? 'true' : 'false';
        $content = $cell->note['content'];
        
        $args = array(
            'color' => $color,
            'bgcolor' => $bgcolor,
            'bcolor' => $bcolor,
            'bwidth' => $bwidth,
            'align' => $align,
            'rounded' => $rounded,
            'bottom' => 0,
            'execute' => $execute
        );
        
        $out .= GetDCCPI()->getIShortcodes()->render_dcs_note($args, $content);
        
        return $out;  
    }       
      
    public function renderTypeBlockquote($cell)
    {
        $out = '';  
        
        $content = $cell->blockquote['content']; 
        $color = $cell->blockquote['color'];    
        $align = $cell->blockquote['align'];  
        $title = $cell->blockquote['title']; 
        $author = $cell->blockquote['author'];
        $fsize = $cell->blockquote['fsize']; 
        $lheight = $cell->blockquote['lheight']; 
        
        $args = array(
          'size' => '1-1',  
          'float' => 'none',
          'color' => $color,
          'top' => 0,
          'right' => 0,
          'bottom' => 0,
          'left' => 0,
          'align' => $align,
          'author' => $author,
          'title' => $title,
          'fsize' => $fsize,
          'lheight' => $lheight 
        );      
    
        $out .= GetDCCPI()->getIShortcodes()->render_dcs_blockquote($args, $content); 
    
        return $out;
    }
                 
    public function renderTypeUnorderedList($cell)
    {
        $out = '';  
        
        $content = $cell->ul_list['content']; 
        $type = $cell->ul_list['type'];    
        
        $args = array(
          'size' => '1-1',
          'ctype' => 'none',
          'float' => 'none',          
          'type' => $type,  
          'left' => 0,
          'bottom' => 0
        );      
    
        $out .= GetDCCPI()->getIShortcodes()->render_dcs_ul_list($args, $content); 
    
        return $out;
    }                
           
    public function renderTypePostBox($cell)
    {
        $out = '';  
        
        $id = $cell->postbox['id']; 
        $desc = $cell->postbox['desc'];    
        $words = $cell->postbox['words'];
        $url = $cell->postbox['url'];
        $border = $cell->postbox['border'] ? 'true' : 'false'; 
        
        $args = array(
          'id' => $id,
          'size' => '1-1',
          'ctype' => 'none', 
          'desc' => $desc,
          'words' => $words,
          'float' => 'none',
          'top' => 0,
          'right' => 0,
          'bottom' => 0,
          'left' => 0,
          'url' => $url,
          'border' => $border
        );     
    
        $out .= GetDCCPI()->getIShortcodes()->render_dcs_postbox($args); 
    
        return $out;
    }
    
    public function renderTypePageBox($cell)
    {
        $out = '';  
        
        $id = $cell->pagebox['id']; 
        $desc = $cell->pagebox['desc'];    
        $words = $cell->pagebox['words'];
        $url = $cell->pagebox['url'];
        $border = $cell->pagebox['border'] ? 'true' : 'false'; 
        
        $args = array(
          'id' => $id,
          'size' => '1-1',
          'ctype' => 'none', 
          'desc' => $desc,
          'words' => $words,
          'float' => 'none',
          'top' => 0,
          'right' => 0,
          'bottom' => 0,
          'left' => 0,
          'url' => $url,
          'border' => $border  
        );     
    
        $out .= GetDCCPI()->getIShortcodes()->render_dcs_pagebox($args); 
    
        return $out;
    }               
    
    public function renderTypeTip($cell)
    {
        $out = '';  
        
        $content = $cell->tip['content'];
        $url = $cell->tip['url']; 
        $title = $cell->tip['title'];    
        $link = $cell->tip['link'];
        $link_name = $cell->tip['link_name'];
        $new_tab = $cell->tip['new_tab'] ? 'true' : 'false'; 
        $color = $cell->tip['color'];
        $image_space = $cell->tip['image_space'];
        
        if(!$cell->tip['link_use']) { $link = ''; }
        if(!$cell->tip['image_use']) { $url = ''; }
        
        $args = array(
          'url' => $url,
          'title' => $title,
          'color' => $color,
          'new_tab' => $new_tab,
          'link' => $link,
          'link_name' => $link_name,
          'bottom' => 0,
          'image_space' => $image_space
        );    
    
        $out .= GetDCCPI()->getIShortcodes()->render_dcs_tip($args, $content); 
    
        return $out;
    }     
    
    public function renderTypeImage($cell)
    {
        $out = '';
        
        $url = $cell->image['url'];
        $alt = $cell->image['alt']; 
        $title = $cell->image['title'];
        $desc = $cell->image['desc'];
        $align = $cell->image['align']; 
        $link = $cell->image['link']; 
        $group = $cell->image['group'];
        $padding = $cell->image['padding'];
        
        $border = $cell->image['border'] ? 'true' : 'false';
        $lightbox = $cell->image['lightbox'] ? 'true' : 'false';
        $image_as_link = $cell->image['image_as_link'] ? 'true' : 'false';
        $new_tab = $cell->image['new_tab'] ? 'true' : 'false';
        
        $grayscale = $cell->image['grayscale'] ? 'true' : 'false';  
        $real_size = $cell->image['real_size'] ? 'true' : 'false';  
        $viewport_w = $cell->image['viewport_w']; 
        $viewport_h = $cell->image['viewport_h'];
                 
        $args = array(
          'url' => $url,
          'alt' => $alt,
          'size' => '1-1',
          'ctype' => 'none',
          'float' => 'none',
          'align' => $align,
          'top' => 0,
          'right' => 0,
          'bottom' => 0,
          'left' => 0,        
          'title' => $title,
          'desc' => $desc,    
          'padding' => $padding,
          'border' => $border,
          'lightbox' => $lightbox,
          'link' => $link,
          'image_as_link' => $image_as_link,
          'new_tab' => $new_tab,
          'group' => $group,
          'grayscale' => $grayscale,
          'real_size' => $real_size,
          'viewport_w' => $viewport_w,
          'viewport_h' => $viewport_h
        );          
        
        $out .= GetDCCPI()->getIShortcodes()->render_dcs_image($args); 
        
        return $out;
    }  
    
    public function renderTypeVideo($cell)
    {
        $out = '';
     
        $url = $cell->video['url'];
        $content = $cell->video['content'];
        $desc_use = $cell->video['desc_use'] ? 'true' : 'false';
     
        $args = array(
          'size' => '1-1',
          'ctype' => 'none',
          'float' => 'none',
          'clear' => 'none',            
          'url' => $url,        
          'bottom' => 0,
          'desc_use' => $desc_use
        );          
     
        $out .= GetDCCPI()->getIShortcodes()->render_dcs_video($args, $content); 
     
        return $out;   
    }   
    
    public function renderTypeNGG($cell)
    {
        $out = '';
     
        $id = $cell->ngg['id'];
        $w = $cell->ngg['w']; 
        $h = $cell->ngg['h']; 
        $tright = $cell->ngg['tright'];  
        $tbottom = $cell->ngg['tbottom'];  
        $count = $cell->ngg['count'];
        $padding = $cell->ngg['padding']; 
        $group = $cell->ngg['group']; 
        $bcolor = $cell->ngg['bcolor']; 
        $bgcolor = $cell->ngg['bgcolor']; 
        
        $border = $cell->ngg['border'] ? 'true' : 'false'; 
        $all = $cell->ngg['all'] ? 'true' : 'false';
        $random = $cell->ngg['random'] ? 'true' : 'false';
        $bgcolor_use = $cell->ngg['bgcolor_use'] ? 'true' : 'false';
        
        $args = array(
          'size' => '1-1',
          'ctype' => 'none',
          'float' => 'none',
          'clear' => 'none',            
          'id' => $id,
          'count' => $count,
          'w' => $w,
          'h' => $h,
          'random' => $random,
          'border' => $border,                     
          'tbottom' => $tbottom, 
          'tright' => $tright,         
          'padding' => $padding,
          'group' => $group,            
          'bcolor' => $bcolor,   
          'bottom' => 0,
          'bgcolor' => $bgcolor,
          'bgcolor_use' => $bgcolor_use,
          'all' => $all
        );         
     
        $out .= GetDCCPI()->getIShortcodes()->render_dcs_ngg($args); 
     
        return $out;   
    }       
    
    public function renderTypeNGGThumbsSlider($cell)
    {
        $out = '';
     
        $id = $cell->ngg_thumbs_slider['id'];
        $desc = $cell->ngg_thumbs_slider['desc'];
        $thumb_size = $cell->ngg_thumbs_slider['thumb_size'];
        $count = $cell->ngg_thumbs_slider['count'];
        $transition = $cell->ngg_thumbs_slider['transition']; 
        $bcolor = $cell->ngg_thumbs_slider['bcolor'];
        
        $slide_title = $cell->ngg_thumbs_slider['slide_title'] ? 'true' : 'false'; 
        $all = $cell->ngg_thumbs_slider['all'] ? 'true' : 'false';
        $random = $cell->ngg_thumbs_slider['random'] ? 'true' : 'false';
        $slide_desc = $cell->ngg_thumbs_slider['slide_desc'] ? 'true' : 'false';        
        
        $args = array(
          'size' => '1-1',
          'ctype' => 'none',
          'float' => 'none',
          'clear' => 'none',            
          'id' => $id,
          'bottom' => 0,
          'left' => 0,
          'right' => 0,
          
          'desc' => $desc,
          'thumb_size' => $thumb_size,                       
          'count' => $count,
          'transition' => $transition,
          'bcolor' => $bcolor,

          'slide_desc' => $slide_desc,
          'slide_title' => $slide_title,          
          'random' => $random,
          'all' => $all                           
        );         
     
        $out .= GetDCCPI()->getIShortcodes()->render_dcs_ngg_thumbs_slider($args); 
     
        return $out;   
    }     
    
    public function renderTypeNGGBoxGallery($cell)
    {            
        $args = array(
            'id' => $cell->ngg_gallery['id'],
            'per_page' => $cell->ngg_gallery['per_page'],
            'list' => $cell->ngg_gallery['list'], 
            'columns' => $cell->ngg_gallery['columns'],
            'exclude' => $cell->ngg_gallery['exclude'],
            'group' => $cell->ngg_gallery['group'], 
            'order' => $cell->ngg_gallery['order'], 
            'orderby' => $cell->ngg_gallery['orderby'], 
            'pagination' => $cell->ngg_gallery['pagination'], 
            
            'viewport_w' => $cell->ngg_gallery['viewport_w'],   
            'viewport_h' => $cell->ngg_gallery['viewport_h'],   
            'viewport_use' => $cell->ngg_gallery['viewport_use'],   
            'item_bottom' => $cell->ngg_gallery['item_bottom'],
            'item_bottom_use' => $cell->ngg_gallery['item_bottom_use'],
             
            'grayscale' => $cell->ngg_gallery['grayscale'],                    
            'title_display' => $cell->ngg_gallery['title_display'],
            'date_display' => $cell->ngg_gallery['date_display'],
            'desc_display' => $cell->ngg_gallery['desc_display'],
            'meta_size' => $cell->ngg_gallery['meta_size'],
            'meta_download' => $cell->ngg_gallery['meta_download'],
        );         
     
        $out = '';
        $out .= GetDCCPI()->getIRenderer()->renderNGGBoxGallery($args);
     
        return $out;   
    }       
    
    public function renderTypeService($cell)
    {
        $out = '';
     
        $count = $cell->service['count'];
        $cats = $cell->service['cats'];
        $words = $cell->service['words'];
        $columns = $cell->service['columns'];
        $size = $cell->service['size']; 
        $layout = $cell->service['layout'];
        
        $list = $cell->service['list']; 
        $order = $cell->service['order'];
        $orderby = $cell->service['orderby'];
        
        $viewport_use = $cell->service['viewport_use'];     
        $viewport_w = $cell->service['viewport_w'];
        $viewport_h = $cell->service['viewport_h'];
        $item_bottom = $cell->service['item_bottom'];   
        $item_bottom_use = $cell->service['item_bottom_use'];              
        
        $args = array(
            'count' => $count,
            'cats' => $cats,
            'words' => $words,
            'columns' => $columns,
            'size' => $size,
            'layout' => $layout, // classic, box 
            'list' => $list,           
            'order' => $order, // DESC, ASC
            'orderby' => $orderby, // date, title, rand
            'viewport_use' => $viewport_use,
            'viewport_w' => $viewport_w,
            'viewport_h' => $viewport_h,
            'item_bottom' => $item_bottom,
            'item_bottom_use' => $item_bottom_use            
        );        
     
        $out .= GetDCCPI()->getIRenderer()->renderServices($args); 
     
        return $out;   
    }    
    
    public function renderTypeProject($cell)
    {
        $out = '';
     
        $per_page = $cell->project['per_page'];
        $cats = $cell->project['cats'];
        $words = $cell->project['words'];
        $columns = $cell->project['columns'];
        $excerpt = $cell->project['excerpt']; 
        $pagination = $cell->project['pagination'];
        
        $list = $cell->project['list']; 
        $order = $cell->project['order'];
        $orderby = $cell->project['orderby'];     
        
        $viewport_use = $cell->project['viewport_use']; 
        $viewport_w = $cell->project['viewport_w'];  
        $viewport_h = $cell->project['viewport_h'];  
        
        $cats_display = $cell->project['cats_display'];   
        $title_display = $cell->project['title_display'];   
        $item_bottom = $cell->project['item_bottom'];   
        $item_bottom_use = $cell->project['item_bottom_use'];      
        
        $args = array(
            'per_page' => $per_page,
            'cats' => $cats,
            'words' => $words,
            'list' => $list,           
            'columns' => $columns,
            'order' => $order, // DESC, ASC
            'orderby' => $orderby, // date, title, comment_count
            'pagination' => $pagination,
            'excerpt' => $excerpt,
            'viewport_use' => $viewport_use,
            'viewport_w' => $viewport_w,
            'viewport_h' => $viewport_h,
            'cats_display' => $cats_display,
            'title_display' => $title_display,
            'item_bottom' => $item_bottom,
            'item_bottom_use' => $item_bottom_use
        );     
     
        $out .= GetDCCPI()->getIRenderer()->renderProjects($args); 
     
        return $out;   
    }  
    
    public function renderTypeBasicSlider($cell)
    {
        $out = '';  
        
        $auto = $cell->basic_slider['auto']; 
        $speed = $cell->basic_slider['speed'];
        $timeout = $cell->basic_slider['timeout'];
        $pager = $cell->basic_slider['pager'];
        $pause = $cell->basic_slider['pause'];
        $maxwidth = $cell->basic_slider['maxwidth']; 
        $transition = $cell->basic_slider['transition'];
        $nextprev = $cell->basic_slider['nextprev'];
        $viewport_use = $cell->basic_slider['viewport_use'];
        $viewport_w = $cell->basic_slider['viewport_w']; 
        $viewport_h = $cell->basic_slider['viewport_h']; 
        $title_size = $cell->basic_slider['title_size']; 
        $title_as_h = $cell->basic_slider['title_as_h']; 
        $title_color = $cell->basic_slider['title_color'];         
     
        
        $args = array(
            'auto' => $auto,             // animate automatically, true or false
            'speed' =>  $speed,           // speed of the transition, in milliseconds
            'timeout' => $timeout,          // time between slide transitions, in milliseconds
            'pager' => $pager,            // show pages, true or false
            'pause' => $pause,            // pause on hover, true or false
            'maxwidth' => $maxwidth,            // max width of the slideshow, in pixels  
            'maxwidth_pager' => true,   // apply max width to pager container
            'maxwidth_wrapper' => true, // apply max width to slider inner wrapper
            'transition' => $transition,     // transition mode, fade, slide
            'nextprev' => $nextprev,         // display next, prev buttons
            'bottom' => 0,
            'viewport_use' => $viewport_use,
            'viewport_w' => $viewport_w,
            'viewport_h' => $viewport_h,
            'title_size' => $title_size,
            'title_as_h' => $title_as_h,
            'title_color' => $title_color                        
        );        
        
        $out .= GetDCCPI()->getIRenderer()->renderBasicSlider($args, $cell->basic_slider['slides']); 
     
        return $out;         
    }    
    
    public function renderTypeCode($cell)
    {
        $out = '';  
        
        $minimized = $cell->code['minimized'] ? 'true' : 'false';  
        $stripes = $cell->code['stripes'] ? 'true' : 'false';
        $lang = $cell->code['lang'];
        $content = html_entity_decode($cell->code['content']);
        
        $title = '';
        if($cell->code['title_use']) { $title = $cell->code['title']; }
        $desc = '';
        if($cell->code['desc_use']) { $desc = $cell->code['desc']; }
        
        $args = array(
          'size' => '1-1',
          'ctype' => 'none',
          'float' => 'none',
          'clear' => 'none',        
          'minimized' => $minimized,
          'stripes' => $stripes,          
          'bottom' => 0,
          'lang' => $lang,                                                                              
          'title' => $title,
          'desc' => $desc
        );         
        
        $out .= GetDCCPI()->getIShortcodes()->render_dcs_code($args, $content); 
     
        return $out;         
    }   
    
    public function renderTypeBoardSlider($cell)        
    {
        $out = '';
        global $dc_page_common_opt;
        
        if($dc_page_common_opt['page_layout'] != CMS_PAGE_LAYOUT_FULL_WIDTH)
        {
            return $out;
        }
        
        $lines_count = $cell->board_slider['lines_count'];
        $pages_count = $cell->board_slider['pages_count'];
        $cats_post = $cell->board_slider['cats_post']; 
        $cats_page = $cell->board_slider['cats_page'];
        $list = $cell->board_slider['list'];
        $in_posts = $cell->board_slider['in_posts'];
        $in_pages = $cell->board_slider['in_pages'];
        $mode = $cell->board_slider['mode'];
        $excerpt = $cell->board_slider['excerpt'];
        $title = $cell->board_slider['title'];
        $excerpt_words_count = $cell->board_slider['excerpt_words_count'];
        $order = $cell->board_slider['order']; 
        $orderby = $cell->board_slider['orderby']; 
        $autoplay = $cell->board_slider['autoplay'];
        $autoplay_time = $cell->board_slider['autoplay_time'];
        $desc_hide_on_hover = $cell->board_slider['desc_hide_on_hover'];  
        $desc_show_on_hover = $cell->board_slider['desc_show_on_hover'];   
        $desc_bottom = $cell->board_slider['desc_bottom'];  
        $show_hidden_post_img = $cell->board_slider['show_hidden_post_img'];
        
        
        $args = array(
            'lines_count' => $lines_count,
            'pages_count' => $pages_count,
            'cats_post' => $cats_post,
            'cats_page' => $cats_page,
            'list' => $list,
            'in_posts' => $in_posts,
            'in_pages' => $in_pages,
            'mode' => $mode, // normal, full-gray, full-gray-hover-color
            'excerpt' => $excerpt,
            'title' => $title,
            'excerpt_words_count' => $excerpt_words_count,
            'order' => $order,
            'orderby' => $orderby,
            'autoplay' => $autoplay,
            'autoplay_time' => $autoplay_time,
            'desc_hide_on_hover' => $desc_hide_on_hover,
            'desc_show_on_hover' => $desc_show_on_hover,
            'desc_bottom' => $desc_bottom,
            'show_hidden_post_img' => $show_hidden_post_img           
        );         
        
        $out .= GetDCCPI()->getIRenderer()->renderBoardSlider($args);        
        return $out;
    }     
    
    public function renderTypeAnnoBox($cell)
    {    
        $out = '';
        
        $title = $cell->anno_box['title'];
        $title_use = $cell->anno_box['title_use'];
        $title_size = $cell->anno_box['title_size']; 
        $subtitle = $cell->anno_box['subtitle'];
        $subtitle_use = $cell->anno_box['subtitle_use'];
        $text = $cell->anno_box['text'];
        $text_use = $cell->anno_box['text_use'];
        $text_fsize = $cell->anno_box['text_fsize'];
        $text_lheight = $cell->anno_box['text_lheight'];
        $text_font_sizes_use = $cell->anno_box['text_font_sizes_use'];
        $align = $cell->anno_box['align'];  
        
        $btn_a_name = $cell->anno_box['btn_a_name'];
        $btn_a_link = $cell->anno_box['btn_a_link'];
        $btn_a_display = $cell->anno_box['btn_a_display'];
        $btn_a_blank = $cell->anno_box['btn_a_blank'];

        $btn_b_name = $cell->anno_box['btn_b_name'];
        $btn_b_link = $cell->anno_box['btn_b_link'];
        $btn_b_display = $cell->anno_box['btn_b_display'];
        $btn_b_blank = $cell->anno_box['btn_b_blank'];
        
        $btn_c_name = $cell->anno_box['btn_c_name'];
        $btn_c_link = $cell->anno_box['btn_c_link'];
        $btn_c_display = $cell->anno_box['btn_c_display'];
        $btn_c_blank = $cell->anno_box['btn_c_blank'];        

        $btn_color = $cell->anno_box['btn_color'];
        $btn_hcolor = $cell->anno_box['btn_hcolor'];
        $btn_bgcolor = $cell->anno_box['btn_bgcolor'];
        $btn_bghcolor = $cell->anno_box['btn_bghcolor'];  
        
        $args = array(
            'title' => $title,
            'title_use' => $title_use,
            'title_size' => $title_size,
            'subtitle' => $subtitle,
            'subtitle_use' => $subtitle_use,
            'text' => $text,
            'text_use' => $text_use,
            'text_fsize' => $text_fsize,
            'text_lheight' => $text_lheight,
            'text_font_sizes_use' => $text_font_sizes_use,
            'align' => $align,

            'btn_a_name' => $btn_a_name,
            'btn_a_link' => $btn_a_link,
            'btn_a_blank' => $btn_a_blank,
            'btn_a_display' => $btn_a_display,
        
            'btn_b_name' => $btn_b_name,
            'btn_b_link' => $btn_b_link,
            'btn_b_blank' => $btn_b_blank,
            'btn_b_display' => $btn_b_display,
        
            'btn_c_name' => $btn_c_name,
            'btn_c_link' => $btn_c_link,
            'btn_c_blank' => $btn_c_blank,
            'btn_c_display' => $btn_c_display,  
            
            'btn_color' => $btn_color,
            'btn_hcolor' => $btn_hcolor,
            'btn_bgcolor' => $btn_bgcolor,
            'btn_bghcolor' => $btn_bghcolor                         
        );        
        
        $out .= GetDCCPI()->getIRenderer()->renderAnnoBox($args);
        return $out;
    }
    
    public function renderTypeNGGRecentSlider($cell)
    {
        $out = '';
        
        $id = $cell->ngg_recent_slider['id'];
        $pages = $cell->ngg_recent_slider['pages'];
        $orderby = $cell->ngg_recent_slider['orderby']; 
        $perpage = $cell->ngg_recent_slider['perpage']; 
        $viewport_w = $cell->ngg_recent_slider['viewport_w'];
        $viewport_h = $cell->ngg_recent_slider['viewport_h'];
        $alttext = $cell->ngg_recent_slider['alttext'];
        $grayscale = $cell->ngg_recent_slider['grayscale'];
        $desc = $cell->ngg_recent_slider['desc']; 
        $desc_use = $cell->ngg_recent_slider['desc_use'];
        
        $args = array(
            'id' => $id,
            'pages' => $pages,
            'orderby' => $orderby, // date, sort, id
            'perpage' => $perpage, // 1-5     
            'viewport_w' => $viewport_w,
            'viewport_h' => $viewport_h,
            'alttext' => $alttext,
            'grayscale' => $grayscale,
            'desc' => $desc,
            'desc_use' => $desc_use   
        );        
        
        $out .= GetDCCPI()->getIRenderer()->renderNGGRecentSlider($args); 
        return $out;
    }
    
    public function renderTypeRecentPostsList($cell)
    {
        $out = '';

        $cats = $cell->recent_posts_list['cats']; 
        $list = $cell->recent_posts_list['list'];
        $count = $cell->recent_posts_list['count']; 
        $words = $cell->recent_posts_list['words'];
        $order = $cell->recent_posts_list['order']; // DESC, ASC  
        $orderby = $cell->recent_posts_list['orderby']; // date, title, comment_count                                
        $grayscale = $cell->recent_posts_list['grayscale'];
        $excerpt_use = $cell->recent_posts_list['excerpt_use'];
        $elapsed_time = $cell->recent_posts_list['elapsed_time'];  
        $layout = $cell->recent_posts_list['layout'];  
        $columns = $cell->recent_posts_list['columns']; 
        $item_bottom = $cell->recent_posts_list['item_bottom']; 
        $item_bottom_use = $cell->recent_posts_list['item_bottom_use']; 
        
        $viewport_w = $cell->recent_posts_list['viewport_w']; 
        $viewport_h = $cell->recent_posts_list['viewport_h']; 
        $viewport_use = $cell->recent_posts_list['viewport_use']; 
        $title_display = $cell->recent_posts_list['title_display']; 
        $date_display = $cell->recent_posts_list['date_display']; 
        $excerpt_display = $cell->recent_posts_list['excerpt_display'];            
        
        $pagination = $cell->recent_posts_list['pagination'];
        
        $args = array(
            'cats' => $cats,
            'list' => $list,             
            'count' => $count,             
            'words' => $words,          
            'order' => $order,
            'orderby' => $orderby,
            'grayscale' => $grayscale,
            'excerpt_use' => $excerpt_use,        
            'elapsed_time' => $elapsed_time,
            'layout' => $layout,
            'columns' => $columns,
            'item_bottom' => $item_bottom,
            'item_bottom_use' => $item_bottom_use,
            'viewport_w' => $viewport_w,
            'viewport_h' => $viewport_h,
            'viewport_use' => $viewport_use,
            'title_display' => $title_display,
            'date_display' => $date_display,
            'excerpt_display' => $excerpt_display,
            'pagination' => $pagination
                       
        );
        
        $out .= GetDCCPI()->getIRenderer()->renderRecentPostsList($args); 
        return $out;        
    }    

    public function renderTypeDownload($cell)
    {
        $out = '';
        
        $title = $cell->download['title'];
        $title_use = $cell->download['title_use'];
        $title_size = $cell->download['title_size'];  
        $subtitle = $cell->download['subtitle'];
        $desc = $cell->download['desc'];
        $desc_use = $cell->download['desc_use'];
        $file_name = $cell->download['file_name'];
        $file_name_use = $cell->download['file_name_use'];
        $file_size = $cell->download['file_size'];
        $file_size_use = $cell->download['file_size_use'];
        $file_url = $cell->download['file_url'];
        $icon_url = $cell->download['icon_url'];  
        $icon_use = $cell->download['icon_use'];  
        $icon_w = $cell->download['icon_w']; 
        $btn_pos = $cell->download['btn_pos']; 
        $arrow_display = $cell->download['arrow_display'];
        
        $args = array(
            'title' => $title,
            'title_use' => $title_use,
            'title_size' => $title_size,
            'subtitle' => $subtitle,             
            'desc' => $desc,             
            'desc_use' => $desc_use,
            'file_name' => $file_name,
            'file_name_use' => $file_name_use,
            'file_size' => $file_size,
            'file_size_use'  => $file_size_use,
            'file_url' => $file_url,
            'icon_url' => $icon_url,
            'icon_use' => $icon_use,
            'icon_w' => $icon_w,
            'btn_pos' => $btn_pos,
            'arrow_display' => $arrow_display
        );        
                
        $out .= GetDCCPI()->getIRenderer()->renderDownloadSeg($args); 
        return $out;        
    }
    
    public function renderTypeMember($cell)
    {
        $out = '';
     
        $per_page = $cell->member['per_page'];
        $cats = $cell->member['cats'];
        $words = $cell->member['words'];
        $columns = $cell->member['columns'];
        $excerpt = $cell->member['excerpt']; 
        $pagination = $cell->member['pagination'];
        
        $list = $cell->member['list']; 
        $order = $cell->member['order'];
        $orderby = $cell->member['orderby'];     
        
        $viewport_use = $cell->member['viewport_use']; 
        $viewport_w = $cell->member['viewport_w'];  
        $viewport_h = $cell->member['viewport_h'];  
        
        $title_display = $cell->member['title_display'];   
        $item_bottom = $cell->member['item_bottom'];   
        $item_bottom_use = $cell->member['item_bottom_use'];      
        
        $link_to_single = $cell->member['link_to_single']; 
        $grayscale = $cell->member['grayscale']; 
        $meta_title = $cell->member['meta_title']; 
        $meta_subtitle = $cell->member['meta_subtitle']; 
        $meta_addinfo = $cell->member['meta_addinfo']; 
        $meta_twitter = $cell->member['meta_twitter']; 
        $meta_facebook = $cell->member['meta_facebook']; 
        $meta_website = $cell->member['meta_website'];
        $addinfo_words = $cell->member['addinfo_words'];                  
        
        $args = array(
            'per_page' => $per_page,
            'cats' => $cats,
            'words' => $words,
            'list' => $list,           
            'columns' => $columns,
            'order' => $order, // DESC, ASC
            'orderby' => $orderby, // date, title, comment_count
            'pagination' => $pagination,
            'excerpt' => $excerpt,
            'viewport_use' => $viewport_use,
            'viewport_w' => $viewport_w,
            'viewport_h' => $viewport_h,
            'title_display' => $title_display,
            'item_bottom' => $item_bottom,
            'item_bottom_use' => $item_bottom_use,
            'link_to_single' => $link_to_single,
            'grayscale' => $grayscale,
            'meta_title' => $meta_title,
            'meta_subtitle' => $meta_subtitle,
            'meta_addinfo' => $meta_addinfo,
            'meta_twitter' => $meta_twitter,
            'meta_facebook' => $meta_facebook,
            'meta_website' => $meta_website,
            'addinfo_words' => $addinfo_words
        );     
     
        $out .= GetDCCPI()->getIRenderer()->renderMembers($args); 
     
        return $out;   
    }      
    
    public function renderTypeWgtMember($cell)
    {
        $out = '';
     
        $per_page = $cell->wgt_member['per_page'];  
        $cats = $cell->wgt_member['cats'];
        $words = $cell->wgt_member['words'];      
        $list = $cell->wgt_member['list']; 
        $columns = $cell->wgt_member['columns']; 
        $order = $cell->wgt_member['order'];
        $orderby = $cell->wgt_member['orderby'];            
        $viewport_use = $cell->wgt_member['viewport_use']; 
        $viewport_w = $cell->wgt_member['viewport_w'];  
        $viewport_h = $cell->wgt_member['viewport_h'];  
        $link_to_single = $cell->wgt_member['link_to_single']; 
        $grayscale = $cell->wgt_member['grayscale']; 
        $image_width = $cell->wgt_member['image_width'];  
        $meta_title = $cell->wgt_member['meta_title']; 
        $meta_subtitle = $cell->wgt_member['meta_subtitle'];
        $meta_addinfo = $cell->wgt_member['meta_addinfo'];
        $addinfo_words = $cell->wgt_member['addinfo_words'];
        $item_bottom_use = $cell->wgt_member['item_bottom_use'];
        $item_bottom = $cell->wgt_member['item_bottom'];
        
       
        
        $args = array(
            'per_page' => $per_page,
            'cats' => $cats,
            'words' => $words,
            'list' => $list,
            'columns' => $columns,           
            'order' => $order, // DESC, ASC
            'orderby' => $orderby, // date, title, comment_count
            'viewport_use' => $viewport_use,
            'viewport_w' => $viewport_w,
            'viewport_h' => $viewport_h,
            'link_to_single' => $link_to_single,
            'grayscale' => $grayscale,
            'image_width' => $image_width,
            'meta_title' => $meta_title,
            'meta_subtitle' => $meta_subtitle,
            'meta_addinfo' => $meta_addinfo,
            'addinfo_words' => $addinfo_words,
            'item_bottom' => $item_bottom,
            'item_bottom_use' => $item_bottom_use            
        );     
     
        $out .= GetDCCPI()->getIRenderer()->wgtMembers($args); 
     
        return $out;   
    }       
         
    public function renderTypeWgtTwitter($cell)
    {     
        $option_id = $cell->core['time'].'_dc_seg_TWITTER';
        $data = get_option($option_id); 
        $time_now = time();     

        $consumer_key = GetDCCPI()->getIGeneral()->getOption('twitter_consumer_key');   
        $consumer_secret = GetDCCPI()->getIGeneral()->getOption('twitter_consumer_secret');
        $token_key = GetDCCPI()->getIGeneral()->getOption('twitter_token_key');
        $token_secret = GetDCCPI()->getIGeneral()->getOption('twitter_token_secret');
        
        $twitter_args = array(
            'consumer_key' => $consumer_key,
            'consumer_secret' => $consumer_secret,
            'token_key' => $token_key,
            'token_secret' => $token_secret            
        );   
        
        if(!is_array($data))
        {            
            $data = array('time' => $time_now, 'user' => false, 'timeline' => false);

            $twitter = new DCC_Twitter($twitter_args);
            $user = $twitter->getUserData(array('screen_name' => $cell->wgt_twitter['twitter_screen_name']));
            $timeline = $twitter->getUserTimelineData(array('screen_name' => $cell->wgt_twitter['twitter_screen_name'], 'count' => 20));
                         
            $data['user'] = $user; 
            $data['timeline'] = $timeline; 
                        
            if($user !== false and $timeline !== false)
            {  
                add_option($option_id, $data);    
            }            
        } else
        {   
            $offset = $cell->wgt_twitter['tweetes_refresh'];
            
            if($time_now - $data['time'] > $offset)
            {   
                $twitter = new DCC_Twitter($twitter_args);
                $user = $twitter->getUserData(array('screen_name' => $cell->wgt_twitter['twitter_screen_name']));
                $timeline = $twitter->getUserTimelineData(array('screen_name' => $cell->wgt_twitter['twitter_screen_name'], 'count' => 20));
            
                $data['time'] = $time_now;
                $data['user'] = $user; 
                $data['timeline'] = $timeline; 
                
                update_option($option_id, $data);                     
            }      
        }               
     
        $out = '';     
     
        $out .= GetDCCPI()->getIRenderer()->wgtTwitter(array(
            'tweetes_count' => $cell->wgt_twitter['tweetes_count'], 
            'image_display' => $cell->wgt_twitter['image_display'], 
            'time_offset' => $cell->wgt_twitter['time_offset'],
            'time_format' => $cell->wgt_twitter['time_format'], 
            'tweets_count_display' => $cell->wgt_twitter['tweets_count_display'], 
            'date_display' => $cell->wgt_twitter['date_display'],
            'data' => $data,
            'layout' => $cell->wgt_twitter['layout'],
            'left_side_w' => $cell->wgt_twitter['left_side_w'],
        ));          
     
        return $out;   
    }             
         
    public function renderTypeColoredHead($cell)
    {             
        $prefix = $cell->colored_head['prefix'];
        $prefix_w = $cell->colored_head['prefix_w']; 
        $prefix_align = $cell->colored_head['prefix_align'];
        $prefix_percent = $cell->colored_head['prefix_percent'] ? 'true' : 'false';
        $prefix_bgcolor = $cell->colored_head['prefix_bgcolor']; 
        $color = $cell->colored_head['color']; 
        $bgcolor = $cell->colored_head['bgcolor']; 
       
        $args = array (
            'prefix' => $prefix,
            'prefix_w' => $prefix_w,
            'prefix_align' => $prefix_align,
            'prefix_percent' => $prefix_percent,
            'prefix_bgcolor' => $prefix_bgcolor,
            'color' => $color,
            'bgcolor' => $bgcolor,
            'top' => 0,
            'bottom' => 0        
        );        
        $content = $cell->colored_head['text'];
        
        $out = '';
        $out .= GetDCCPI()->getIShortcodes()->render_dcs_colored_head($args, $content); 
     
        return $out;         
    }
         
    private function getColumnStart($cell, $echo=false)
    {
        $class = self::getColumnClass($cell->core['size-up'], $cell->core['size-down']);
        
        $style = '';
            if(!$cell->common['pt-use']) { $style .= 'padding-top:0px;'; } else { $style .= 'padding-top:'.(int)$cell->common['pt'].'px;';  }        
            if(!$cell->common['pb-use']) { $style .= 'padding-bottom:0px;'; } else { $style .= 'padding-bottom:'.(int)$cell->common['pb'].'px;';  }
            if($cell->common['clear'] != 'none') { $style .= 'clear:'.$cell->common['clear'].';'; }
            $style .= 'float:'.$cell->common['float'].';';
        $style = ' style="'.$style.'" ';
        
        $out = '';        
        $out .= '<div class="'.$class.'" '.$style.'>';
                        
            $style = '';
            if(!$cell->common['header_border']) { $cell->common['header_bcolor'] = 'transparent'; }
            $style .= 'border-bottom:1px '.$cell->common['header_bstyle'].' '.$cell->common['header_bcolor'].';';
            $style .= 'text-align:'.$cell->common['header_align'].';';
            if($cell->common['header_bottom'] >= 0) { $style .= 'margin-bottom:'.$cell->common['header_bottom'].'px;'; };
            $style = ' style="'.$style.'" '; 
            
            $header = '';  
            $header .= '<div class="dc-over-wrapper-header" '.$style.'>';
                
                $style = '';
                if($cell->common['header_h_pb'] > 0) { $style .= ' style="padding-bottom:'.$cell->common['header_h_pb'].'px;" '; }
                
                if($cell->common['header_as_h']) { $header .= '<h'.$cell->common['header_h_size'].' '.$style.'>'; }
                    $header .= $cell->common['header_title'];
                    if($cell->common['header_as_h'] and $cell->common['header_subtitle'] != '' and $cell->common['header_sub_display'])
                    {
                        $header .= '<span>'.$cell->common['header_subtitle'].'</span>';
                    }
                if($cell->common['header_as_h']) { $header .= '</h'.$cell->common['header_h_size'].'>'; }
            $header .= '</div>';   
            
            if($cell->common['header_display'] and !$cell->common['header_inside']) { $out .= $header; }
            
            $style = ''; 
            if(!$cell->common['pr-use']) { $style .= 'padding-right:0px;'; } else { $style .= 'padding-right:'.(int)$cell->common['pr'].'px;';  }
            if(!$cell->common['pl-use']) { $style .= 'padding-left:0px;'; } else { $style .= 'padding-left:'.(int)$cell->common['pl'].'px;';  }
            $style = ' style="'.$style.'" ';
            
            $out .= '<div class="dc-over-wrapper" '.$style.'>';
                if($cell->common['header_display'] and $cell->common['header_inside']) { $out .= $header; } 
        
        if($echo) { echo $out; } else { return $out; }
    }

    private function getColumnEnd($echo=false)
    {
        $out = '';
        
                $out .= '<div class="dc-clear-both"></div>'; 
            $out .= '</div>';
        $out .= '</div>';
        
        if($echo) { echo $out; } else { return $out; }
    }
   
    private function getColumnClass($up, $down)
    {
        $class = '';
        
        if($up == 1 and $down == 4) { $class = ' dc-four dc-columns '; }
        if($up == 1 and $down == 3) { $class = ' dc-one-third dc-columns '; }
        if($up == 1 and $down == 2) { $class = ' dc-eight dc-columns  '; }
        if($up == 2 and $down == 3) { $class = ' dc-two-thirds dc-columns  '; }
        if($up == 3 and $down == 4) { $class = ' dc-three-fours dc-columns  '; }
        if($up == 1 and $down == 1) { $class = ' dc-sixteen dc-columns  '; }
        
        if($class === '') { $class = ' dc-sixteen dc-columns  '; }
        
        return $class;    
    }
   
    /*********************************************************** 
    * Public functions
    ************************************************************/                
      
}
        
        
?>
