<?php
/**********************************************************************
* OSAKA UNLIMITED WORDPRESS THEME  
* (Ideal For Business And Personal Use: Portfolio or Blog)     
* 
* File name:   
*      cp_ajax.php
* Brief:       
*      Part of theme control panel.
* Author:      
*      DigitalCavalry
* Author URI:
*      http://themeforest.net/user/DigitalCavalry
* Contact:
*      digitalcavalry@gmail.com 
***********************************************************************/

/*********************************************************** 
* Definitions
************************************************************/
if(is_user_logged_in())
{
    add_action('wp_ajax_dc_ctrl_ngg_list', 'dc_ajax_ctrl_ngg_list');
    add_action('wp_ajax_dc_ctrl_page_list', 'dc_ajax_ctrl_pages_list'); 
    add_action('wp_ajax_dc_ctrl_divider_list', 'dc_ajax_ctrl_divider_list'); 
    
    add_action('wp_ajax_dc_box_ul_list_legend', 'dc_ajax_box_ul_list_legend');    
    
    add_action('wp_ajax_dc_sid_combine', 'dc_ajax_sid_combine'); 
    add_action('wp_ajax_dc_add_cf_node', 'dc_ajax_add_cf_node'); 
    add_action('wp_ajax_dc_add_header_info_bar', 'dc_ajax_add_header_info_bar');
    add_action('wp_ajax_dc_menu_sys_add_custom', 'dc_ajax_menu_sys_add_custom'); 
    add_action('wp_ajax_dc_menu_sys_add_page', 'dc_ajax_menu_sys_add_page'); 
    add_action('wp_ajax_dc_menu_sys_add_category', 'dc_ajax_menu_sys_add_category'); 
    
    add_action('wp_ajax_dc_add_seo_meta', 'dc_ajax_add_seo_meta');
    
    
    add_action('wp_ajax_dc_builder_add_cell', 'dc_ajax_builder_add_cell');
    add_action('wp_ajax_dc_builder_add_cell_opt', 'dc_ajax_builder_add_cell_opt');
    add_action('wp_ajax_dc_builder_add_cell_note', 'dc_ajax_builder_add_cell_note');
    add_action('wp_ajax_dc_builder_before_delete', 'dc_ajax_builder_before_delete'); 
    add_action('wp_ajax_dc_builder_basic_slider_add_slide', 'dc_ajax_builder_basic_slider_add_slide');
    
    # EXAMPLE
    # add_action('wp_ajax_dc_questpost', 'dc_ajax_questpost'); 

} else
{
    # EXAMPLE
    # add_action('wp_ajax_nopriv_dc_questpost', 'dc_ajax_questpost'); 
}

function dc_ajax_builder_add_cell()
{
    $id = $_POST['cell_id'];
    $type = $_POST['type'];
    $name = $_POST['name'];  
    
    $builder = new DCC_PageMetaContentBuilderOpt(false);
    $cell = $builder->createStandardCellOjectData(array('id' => $id, 'type' => $type, 'name' => $name));
    $builder->renderCellCMS($cell, true);
    
    die();    
}

function dc_ajax_builder_add_cell_opt()
{
    $id = $_POST['cell_id'];
    $type = $_POST['type'];
    $name = $_POST['name'];
    
    $builder = new DCC_PageMetaContentBuilderOpt(false);
    $cell = $builder->createStandardCellOjectData(array('id' => $id, 'type' => $type, 'name' => $name));
    $builder->renderCellOptionsCMS($cell, true);
    
    die();    
}

function dc_ajax_builder_add_cell_note()
{
    $id = $_POST['cell_id'];
    $type = $_POST['type'];
    $name = $_POST['name'];    
    
    $builder = new DCC_PageMetaContentBuilderOpt(false);
    $cell = $builder->createStandardCellOjectData(array('id' => $id, 'type' => $type, 'name' => $name));
    $builder->renderCellNoteCMS($cell, true);
    
    die();    
}

function dc_ajax_builder_before_delete()
{
    $dc_action = $_POST['dc_action'];  
    
    $builder = new DCC_PageMetaContentBuilderOpt(false);
    switch($dc_action)
    {
        case 'twitter_seg':
        {
            $time = $_POST['time'];          
            $builder->deleteTwitterSegDBData(array('time' => $time));
        }
        break;    
    }
    
    die();    
}

function dc_ajax_builder_basic_slider_add_slide()
{
    $id = $_POST['id']; 
    $index = $_POST['index']; 
        
    $builder = new DCC_PageMetaContentBuilderOpt(false);
    $builder->getHTMLBasicSliderTypeSlide(array('id' => $id, 'index' => $index), null, true);
    
    die();
}

function dc_ajax_menu_sys_add_custom()
{
    GetDCCPI()->getIMenu()->ajaxAddCustomLink();
    die();    
}

function dc_ajax_menu_sys_add_page()
{
    GetDCCPI()->getIMenu()->ajaxAddPageLink();
    die();    
}

function dc_ajax_menu_sys_add_category()
{
    GetDCCPI()->getIMenu()->ajaxAddCategoryLink();
    die();    
}

function dc_ajax_add_header_info_bar()
{
    $index = $_POST['index'];
    $entry = new DCC_HeaderInfoBoxEntry();
    
    $out = '';
    $out .= GetDCCPI()->getIGeneral()->getHeaderInfoBoxEntryHtml($index, $entry); 
    echo $out;
    die();
}

function dc_ajax_add_cf_node()
{     
    $index = $_POST['index'];
    $operation = $_POST['operation'];
    
    $out = '';
    switch($operation)
    {
        case 'add_option':
           $li_index = $_POST['li_index'];
           $option = new DCC_ContactFormSelectOption();
           $out .= GetDCCPI()->getIGeneral()->getContactFormOptionHtml($index, $li_index, $option); 
        break;
        
        case 'add_input':
            $type = $_POST['type'];  
            $input = new DCC_ContactFormInput(array('type'=>$type));      
            $out .= GetDCCPI()->getIGeneral()->getContactFormInputHtml($index, $input);
        break;
        
        default:
        break;
    }
    
    echo $out;
    
    die();
}

function dc_ajax_sid_combine()
{
    $data = $_POST['data']; 
    $index = $_POST['index'];
    
    $data = json_decode(stripcslashes($data));
    
    $order = array();
    if(is_array($data))
    {
        foreach($data as $sid)
        {
            $order[$sid->id] = $sid->use;   
        }    
    }
    GetDCCPI()->getIGeneral()->setSidebarChildsOrderAjax($index, $order); 
    die();
}

    /*
function dc_ajax_questpost() 
{                
    $postID = (int)$_POST['postid'];
    
    $question_views = 0;
    if(!isset($_SESSION[('pv'.$postID)])) { $_SESSION[('pv'.$postID)] = false; } 
    if(isset($_SESSION[('pv'.$postID)]) and $_SESSION[('pv'.$postID)] == false)
    {   
        $question_views = get_post_meta($postID, 'questviews', true);
        if($question_views == '') { $question_views = 0; } else { $question_views++; }
        update_post_meta($postID, 'questviews', (int)$question_views);
        $_SESSION[('pv'.$postID)] = true; 
    } else
    {
        $question_views = get_post_meta($postID, 'questviews', true);     
    }  
    
    echo $question_views;
    die();                          
}     */

function dc_ajax_add_seo_meta()
{
    $index = $_POST['index']; 
    $out = '';
    
    $meta = new DCC_PrivateSeoMeta();
    $out .= DCC_PrivateSeoMeta::getHTMLMeta($meta, $index);
    
    echo $out;
    die();
}

function dc_ajax_ctrl_ngg_list() 
{
    global $nggdb;
    global $wpdb;
    $out = '';
    
    $out .= '<option value="'.CMS_NOT_SELECTED.'">'.__('Not selected', CMS_TXT_DOMAIN).'</option>';
    $result = null;
    
    if(isset($nggdb))
    {
        $result = $wpdb->get_results("SELECT gid, title FROM $wpdb->nggallery");
        if($result !== null)
        {
            if(is_array($result))
            {
                foreach($result as $item)
                {
                    $out .= '<option value="'.$item->gid.'">'.$item->title.'</option>';
                }
            }
        }
    }
    echo $out;
    
    die();      
}  

function dc_ajax_ctrl_pages_list() 
{
    global $wpdb;
    $out = '';
    
    $out .= '<option value="'.CMS_NOT_SELECTED.'">'.__('Not selected', CMS_TXT_DOMAIN).'</option>';
    $result = null;
    $result = $wpdb->get_results("SELECT ID, post_title FROM $wpdb->posts WHERE $wpdb->posts.post_type = 'page' AND $wpdb->posts.post_status = 'publish'");
    
    if($result !== null)
    {
        if(is_array($result))
        {
            foreach($result as $item)
            {
                $out .= '<option value="'.$item->ID.'">'.$item->post_title.'</option>';
            }
        }
    }
    echo $out;
    
    die();      
}    

function dc_ajax_ctrl_divider_list() 
{
    $catalog = new DCC_ServerCatalogContent();
    $catalog->readCatalog(array('catalog' => 'img/divider'));
    
    $out = '';
    
    $out .= '<option value="">'.__('Not selected', CMS_TXT_DOMAIN).'</option>'; 
    if(is_array($catalog->_files_list))
    {
        foreach($catalog->_files_list as $file)
        {
            if(!(strpos($file, ' ') !== false))
            {
                $out .= '<option value="'.$file.'">'.$file.'</option>';    
            }
        }    
    }

    echo $out;
    
    die();      
} 

function dc_ajax_box_ul_list_legend() 
{
    $out = '';
    
    $builder = new DCC_PageMetaContentBuilderOpt(false); 
    $out .= $builder->getHTMLUnorderedListLegend();
    
    echo $out;
    
    die();      
}             
        
?>