<?php
/**********************************************************************
* OSAKA WORDPRESS THEME 
* (Ideal For Business And Personal Use: Portfolio or Blog)   
* 
* File name:   
*      cp_theme.php
* Brief:       
*      Core PHP code for wordpress admin panel
* Author:      
*      DigitalCavalry
* Author URI:
*      http://themeforest.net/user/DigitalCavalry
* Contact:
*      digitalcavalry@gmail.com 
**********************************************************************/
                        
/*********************************************************** 
* Class name:
*    DCC_ControlPanelTheme
* Descripton:   
***********************************************************/
class DCC_ControlPanelTheme 
{    
    /*********************************************************** 
    * Constructor
    ************************************************************/
    public function __construct() 
    {                                                             
        if(is_admin())
        {                                                       
        
            add_action('admin_print_scripts', array(&$this, 'adminLoadScripts'));
            add_action('admin_print_styles', array(&$this, 'adminLoadStyles'));               
            add_action('admin_menu', array(&$this, 'adminMenu'));
            add_action('admin_head', array(&$this, 'adminHead'));               
                  
            add_action('media_buttons', array(&$this, 'adminAddMediaButtons') ); 
            add_filter('manage_edit-post_columns', array(&$this, 'adminPostColumnsCreate'));
            add_action('manage_post_posts_custom_column', array(&$this, 'adminPostColumnsRender'), 10, 2);
            
            add_filter('manage_edit-page_columns', array(&$this, 'adminPageColumnsCreate'));
            add_action('manage_page_posts_custom_column', array(&$this, 'adminPageColumnsRender'), 10, 2);
            
            $this->getIMeta();                                       
        } else
        {            
            
            
            add_post_type_support('page', 'category');
            add_action('init', array(&$this, 'addFilters'), 0);             
            add_action('wp_print_scripts', array(&$this, 'loadScripts'));                                      
            
            add_filter('the_content', array(&$this, 'themeContentFilters'), 1);
            $this->getIGeneral()->addFilter();                                                    
            remove_filter('the_content', 'do_shortcode', 11);
            add_filter('the_content', 'do_shortcode', 7);                
  
            if(!$this->getIGeneral()->getOption('theme_autoformating')) { remove_filter('the_content', 'wpautop'); }
            if(!$this->getIGeneral()->getOption('theme_autotexturize')) { remove_filter('the_content', 'wptexturize'); } 
            if($this->getIGeneral()->getOption('theme_authorize_comment')) { add_action('pre_comment_on_post',  array(&$this, 'processCommentPost')); }                 

            $this->getIShortcodes();            
        }          
        
        register_nav_menu(CMS_WP_PRIMARY_MENU, CMS_THEME_NAME.' '.__('Theme Primary Menu', CMS_TXT_DOMAIN));
        DCC_FreShizer::init();
        load_theme_textdomain(CMS_TXT_DOMAIN, get_template_directory().'/languages');
        add_theme_support('post-thumbnails');
        add_theme_support('automatic-feed-links');
        
        if(!isset($GLOBALS['content_width'])) 
        { 
            // if not defined content_width global variable we need to create it
            $GLOBALS['content_width'] = 0; 
            // set variable value, the name in code is needed for some kind of WP test plugins like theme-check
            global $content_width; 
            $content_width = 960; 
        }
        
        add_post_type_support('page', 'excerpt');
        $this->getICustomPosts();
        $this->getIGeneral()->registerSidebars();
                       
    } 
    

    
    /*********************************************************** 
    * Public members
    ************************************************************/     

    public $_general = null;    
    public $_font = null; 
    public $_help = null;
    public $_meta = null;
    public $_menu = null;  
    public $_renderer = null;
    public $_cache = null;
    public $_shortcodes = null;
    public $_customposts = null;
    public $_builder = null;                           
        
    /*********************************************************** 
    * PRIVATE MEMBERS
    ************************************************************/     
    private $_navigaton = Array(
        'General' => 'dc-general-opt',
        'Font' => 'dc-font-opt',
        'Menu' => 'dc-menu-opt',        
        'Help' => 'dc-help-opt'
    );               
         
    public function initPost()
    {
        global $post;
       // the_post();  
       
        $GLOBALS['dc_template_url'] = CMS_THEME_URL;
       
        $GLOBALS['dc_is_page'] = is_page();
        $GLOBALS['dc_is_single'] = is_single();         
        $GLOBALS['dc_is_date'] = is_date(); 
        $GLOBALS['dc_is_singular'] = is_singular(); 
        $GLOBALS['dc_is_admin'] = is_admin();
        $GLOBALS['dc_is_category'] = is_category();
        
        $GLOBALS['dc_category'] = null; 
        
        if(is_object($post))
        {
            $GLOBALS['dc_post_type'] = $post->post_type;
        }
        
        $GLOBALS['dc_post'] = null;        
        $GLOBALS['dc_post_common_opt'] = false;
        $GLOBALS['dc_post_opt'] = false;
        $GLOBALS['dc_post_seo_opt'] = false; 
        
        $GLOBALS['dc_page_common_opt'] = false;
        $GLOBALS['dc_page_opt'] = false; 
        $GLOBALS['dc_page_seo_opt'] = false;
        $GLOBALS['dc_page_template'] = false;                    

        $GLOBALS['dc_service_opt'] = false;
        $GLOBALS['dc_project_opt'] = false;
        $GLOBALS['dc_member_opt'] = false;  
        
        # dc_flags is a global data array container, can store some bool values
        # dc_data is a global data array container, can be used to store inter functions/classes data
        # dc_loop is a global data array container, can be used to store inter functions data used in loop
        # dc_register is a global data array container, can be used  to store some special inter process data
        $GLOBALS['dc_flags'] = array(); 
        $GLOBALS['dc_data'] = array();          
        $GLOBALS['dc_loop'] = array();         
        $GLOBALS['dc_register'] = array();  
        
        global $dc_is_singular;
        
        if($dc_is_singular)
        {
            if(is_object($post)) 
            { 
                setup_postdata($post); 
            }  
        }    
        
        # getting post meta data
        if($GLOBALS['dc_is_single'] and $post->post_type == 'post')
        {
            $meta = get_post_meta($post->ID, 'post_common_opt', true);            
            if(is_array($meta) and count($meta) > 0)
            {
                $GLOBALS['dc_post_common_opt'] = $meta;
            }

            $meta = get_post_meta($post->ID, 'post_opt', true);            
            if(is_array($meta) and count($meta) > 0)
            {
                $GLOBALS['dc_post_opt'] = $meta;
            }     

            $meta = get_post_meta($post->ID, 'post_seo_opt', true);            
            if(is_array($meta) and count($meta) > 0)
            {
                $GLOBALS['dc_post_seo_opt'] = $meta;
            }  
            
            $GLOBALS['dc_post'] = new DCC_WPPost($post);                   
        }        

        # getting service meta data
        if($GLOBALS['dc_is_single'] and $post->post_type == DCC_ControlPanelCustomPosts::PT_SERVICE_POST)
        {
            $meta = get_post_meta($post->ID, 'dc_service_opt', true);            
            if(is_array($meta) and count($meta) > 0)
            {
                $GLOBALS['dc_service_opt'] = $meta;
            }  
            
            $GLOBALS['dc_post'] = new DCC_WPPost($post);          
        }

        # getting project meta data
        if($GLOBALS['dc_is_single'] and $post->post_type == DCC_ControlPanelCustomPosts::PT_PROJECT_POST)
        {
            $meta = get_post_meta($post->ID, 'dc_project_opt', true);            
            if(is_array($meta) and count($meta) > 0)
            {
                $GLOBALS['dc_project_opt'] = $meta;
            } 
            
            $GLOBALS['dc_post'] = new DCC_WPPost($post);           
        }

        # getting member meta data
        if($GLOBALS['dc_is_single'] and $post->post_type == DCC_ControlPanelCustomPosts::PT_MEMBER_POST)
        {
            $meta = get_post_meta($post->ID, 'dc_member_opt', true);            
            if(is_array($meta) and count($meta) > 0)
            {
                $GLOBALS['dc_member_opt'] = $meta;
            } 
            
            $GLOBALS['dc_post'] = new DCC_WPPost($post);           
        }
         
        # getting page meta data   
        if($GLOBALS['dc_is_page'] and $post->post_type == 'page')
        {
            $GLOBALS['dc_page_template'] = get_post_meta($post->ID, '_wp_page_template', true); 
            
            $meta = get_post_meta($post->ID, 'page_common_opt', true);            
            if(is_array($meta) and count($meta) > 0)
            {
                $GLOBALS['dc_page_common_opt'] = $meta;
            }
            
            /*
            switch($GLOBALS['dc_page_template'])
            {
                case 'board-slider.php': 
                    $meta = get_post_meta($post->ID, 'dc_bspage_opt', true);
                    if(is_array($meta) and count($meta) > 0)  
                    {
                        $GLOBALS['dc_page_opt'] = $meta;    
                    }
                break;
            }
            */
            
            $meta = get_post_meta($post->ID, 'page_seo_opt', true);            
            if(is_array($meta) and count($meta) > 0)
            {
                $GLOBALS['dc_page_seo_opt'] = $meta;
            }              
        }
        
        if($GLOBALS['dc_is_category']) 
        {
            $cat_id = (get_query_var('cat')) ? get_query_var('cat') : '';
            if($cat_id != '')
            {
                $GLOBALS['dc_category'] = get_category($cat_id);            
            }
        }

    }     
               

            
    // INTERFACES
    public function & getIGeneral()       { if($this->_general === null)        { $this->_general = new DCC_ControlPanelGeneral(); }            return $this->_general; }    
    public function & getIFont()          { if($this->_font === null)           { $this->_font = new DCC_ControlPanelFont(); }                  return $this->_font; }   
    public function & getIHelp()          { if($this->_help === null)           { $this->_help = new DCC_ControlPanelHelp(); }                  return $this->_help; } 
    public function & getIMeta()          { if($this->_meta === null)           { $this->_meta = new DCC_ControlPanelMeta(); }                  return $this->_meta; }  
    public function & getIMenu()          { if($this->_menu === null)           { $this->_menu = new DCC_ControlPanelMenu(); }                  return $this->_menu; } 
    public function & getIRenderer()      { if($this->_renderer === null)       { $this->_renderer = new DCC_ControlPanelRenderer(); }          return $this->_renderer; }
    public function & getICache()         { if($this->_cache === null)          { $this->_cache = new DCC_ControlPanelCache(); }                return $this->_cache; }
    public function & getIShortcodes()    { if($this->_shortcodes === null)     { $this->_shortcodes = new DCC_ControlPanelShortCodes(); }      return $this->_shortcodes; } 
    public function & getIBuilder()       { if($this->_builder === null)        { $this->_builder = new DCC_ControlPanelBuilder(); }            return $this->_builder; }
    public function & getICustomPosts()   { if($this->_customposts === null)    { $this->_customposts = new DCC_ControlPanelCustomPosts(); }    return $this->_customposts; }
    
    
    public function processCommentPost($id)
    {
       $user = wp_get_current_user();
       
       // if user is not logged
       if(!$user->ID)
       { 
           $is_scode = isset($_POST['dc_scode']);
           $is_scodeuser = isset($_POST['dc_scodeuser']);
           $error = false;
           
           if(!$is_scode or !$is_scodeuser)
           {
               $error = true;
           } else
           if($_POST['dc_scode'] != md5(md5($_POST['dc_scodeuser'])))
           {
               $error = true;
           }           
           
           if($error)
           {
               wp_die(__('Sorry, the authorization code from image is wrong.', CMS_TXT_DOMAIN));
           }
       }  
    }            
        
    function addFilters() 
    {                              
        add_filter( 'option_posts_per_page', array(&$this, 'option_posts_per_page'));
    }

    function option_posts_per_page($value) 
    {                      
        if(is_search()) { $value = GetDCCPI()->getIGeneral()->getOption('search_per_page'); }        
        if(is_archive()) { $value = GetDCCPI()->getIGeneral()->getOption('archive_per_page'); }         
        if(is_category()) { $value = GetDCCPI()->getIGeneral()->getOption('archive_category_per_page'); }   
                                    
        return $value;
    }          
     
 
    function getThemeHeadJSMeta($echo=true)
    {  
        $out = ' ';               
        $out .= '<script type="text/javascript">';
            $out .= $this->getDCCPSettingsJavaScriptObject();                               
        $out .= '</script> ';
        
        if($echo) { echo $out; } else { return $out; }
    }
 
    public function getDCCPSettingsJavaScriptObject()
    {
        $out = '';
     
        $out .= 'var dccp_s = new Object(); ';
        $out .= 'dccp_s.theme_name = \''.CMS_THEME_NAME.'\'; ';
        $out .= 'dccp_s.url = \''.get_bloginfo('url').'\'; '; 
        $out .= 'dccp_s.theme_url = \''.CMS_THEME_URL.'\'; ';  // wordpress-installation-folder/wp-content/themes/theme-name       
        $out .= 'dccp_s.theme_slug = \''.CMS_THEME_NAME_SLUG.'\'; '; 
        $out .= 'dccp_s.admin_url = \''.get_admin_url().'\'; ';  // wordpress-installation-folder/wp-admin/
        $out .= 'dccp_s.site_url = \''.get_bloginfo('url').'\'; '; 
        $out .= 'dccp_s.ajax_box = \'<div class="dc-cms-ajax-progress"><div class="image"></div>Wait. Ajax in work..</div>\'; '; 
        $out .= 'dccp_s.search_dummy_text = \''.addslashes($this->getIGeneral()->getOption('search_dummy_text')).'\'; '; 
        $out .= 'dccp_s.cf_message_ok = \''.addslashes($this->getIGeneral()->getOption('cf_message_ok')).'\'; ';  
        $out .= 'dccp_s.cf_message_error = \''.addslashes($this->getIGeneral()->getOption('cf_message_error')).'\'; '; 
        $out .= 'dccp_s.lb_label = \''.__('Image %i of %c', CMS_TXT_DOMAIN).'\'; ';
        
        
        $font_type = $this->getIFont()->getOption('font_type');
        if($font_type == CMS_FONT_TYPE_CUFON) { $font_type = 'cufon'; } 
        else if($font_type == CMS_FONT_TYPE_GOOGLE) { $font_type = 'google'; }
        else if($font_type == CMS_FONT_TYPE_BROWSER) { $font_type = 'browser'; }
        else if($font_type == CMS_FONT_TYPE_FONT_FACE) { $font_type = 'ff_own'; }
        else { $font_type = 'none'; }
        $out .= 'dccp_s.font_type = \''.$font_type.'\'; ';     
        
        return $out;
    }
 
    public function getThemeHeaderData($echo=true) 
    {    
        $out = '';
        $out .= '<meta name="format-detection" content="telephone=no" /> '; 
        if($this->getIGeneral()->getOption('theme_css_mode') != 'std_fixed')
        {
            // initial-scale=1, maximum-scale=1
            // minimum-scale=1.0, user-scalable=no
            $out .= '<meta name="viewport" content="width=device-width, initial-scale=1" /> ';
        }
        
        if($echo) { echo $out; } else { return $out; }                
    }     

    public function getWPDefaultCSSLink($echo=true) 
    {    
        $out = '';
        $out .= '<link type="text/css" rel="stylesheet" href="'.get_bloginfo('stylesheet_url').'" />'; 
        if($echo) { echo $out; } else { return $out; }                
    }      
    
    public function loadScripts()
    {
        global $post;      
        global $dc_page_common_opt;
        
        if(!is_admin())
        {     
            if($this->getIFont()->getOption('font_type') == CMS_FONT_TYPE_CUFON)
            { 
                wp_register_script( 'cms_cufon_lib', CMS_THEME_URL.'/lib/cufon-yui.js', array('jquery'), '');
                
                $f = trim($this->getIFont()->getOption('font_cufon'));
                if($f != '')
                {
                    wp_register_script('cms_cufon_font', CMS_THEME_URL.'/fonts/'.$f, array('cms_cufon_lib'), '');  
                }
            }
               
            $allow_gmap_api = false;   
            if(is_page() and $dc_page_common_opt !== false) { $allow_gmap_api = $dc_page_common_opt['page_misc_allow_gmap_cbox']; } 

            if($allow_gmap_api)
            {
                wp_register_script(CMS_THEME_NAME_SLUG.'_google_map', 'http://maps.google.com/maps/api/js?sensor=false', '', '', true);                  
                wp_enqueue_script(CMS_THEME_NAME_SLUG.'_google_map'); 
            }          
                
            wp_register_script( 'cms_common', CMS_THEME_URL.'/js/common.js', array('jquery'), '', true);
            wp_enqueue_script('jquery');          
              

            if(is_singular() and $post->comment_status == 'open') { wp_enqueue_script('comment-reply'); }             
            if($this->getIFont()->getOption('font_type') == CMS_FONT_TYPE_CUFON) 
            { 
                wp_enqueue_script('cms_cufon_lib'); 
                wp_enqueue_script('cms_cufon_font');
            }                                  
                
            wp_enqueue_script('cms_common');
                       
        }          
    }    

    
    public function themeContentFilters($content)
    {
        $content = $this->dc_typography_filter_pre($content);
        return $content;
    }


    public function dc_typography_filter_pre($content)
    {
        // '/<pre\s[^>]*class=\"([^\"]*)\"[^>]*>(.*)<\/pre>/siU'
        // '/<pre\s[^>]*class=\"[^\"]*\"[^>]*>(.*)<\/pre>/siU'    
        
        return preg_replace_callback('/<pre\s[^>]*class=\"[^\"]*\"[^>]*>(.*)<\/pre>/siU', array(&$this, 'dc_typography_filter_pre_match_repleace'), $content);
    }

    public function dc_typography_filter_pre_match_repleace($match)
    {        
        $full = $match[0];
        $end_pos = strpos($full, '>')+1;
        $pre_tag_open = substr($full, 0, $end_pos);
        
        $left_square_bracket = '&#91;';
        $right_square_bracket = '&#93;';
            
        $match[1] = htmlentities($match[1]);
        $match[1] = str_replace('[', $left_square_bracket, $match[1]);    
        $match[1] = str_replace(']', $right_square_bracket, $match[1]);
            
        return $pre_tag_open.$match[1].'</pre>';
    }       
    
    /*********************************************************** 
    * ADMIN FUNCTIONS
    ************************************************************/  
        
    public function adminAddMediaButtons() 
    {                 
        $btns = '';
        $btns .= $this->getIGeneral()->getMediaButtons();    
        echo $btns;
    }                        
    
    public function adminHead() 
    {        
        $out = '';                 
        $out .= '<script type="text/javascript">';
            $out .= $this->getDCCPSettingsJavaScriptObject();                 
        $out .= '</script> ';        
        echo $out;        
    } 
    
    public function adminPostColumnsCreate($columns)
    {
        $new_columns['cb'] = '<input type="checkbox" />';
 
        $new_columns['title'] = _x('Post Name', 'column name', CMS_TXT_DOMAIN);
        $new_columns['id'] = __('ID', CMS_TXT_DOMAIN); 
        $new_columns['author'] = __('Author', CMS_TXT_DOMAIN);
 
        $new_columns['categories'] = __('Categories', CMS_TXT_DOMAIN);
        $new_columns['tags'] = __('Tags', CMS_TXT_DOMAIN);
 
        $new_columns['date'] = _x('Date', 'column name', CMS_TXT_DOMAIN);
 
        return $new_columns;        
    }    

    public function adminPageColumnsCreate($columns)
    {
        $new_columns['cb'] = '<input type="checkbox" />';
 
        
        $new_columns['title'] = _x('Page Name', 'column name', CMS_TXT_DOMAIN);
        $new_columns['id'] = __('ID', CMS_TXT_DOMAIN); 
        $new_columns['template'] = __('Page template file', CMS_TXT_DOMAIN); 
        $new_columns['author'] = __('Author', CMS_TXT_DOMAIN);
 
        $new_columns['comments'] = '<div class="vers"><img alt="Comments" src="'.get_admin_url().'images/comment-grey-bubble.png" /></div>';
 
        $new_columns['date'] = _x('Date', 'column name', CMS_TXT_DOMAIN);
        return $new_columns;        
    }  
 
    public function adminPostColumnsRender($column_name, $id) 
    {
        switch ($column_name) 
        {
            case 'id':
                echo $id;
                    break;
            default:
                break;
        }
    } 
    
    public function adminPageColumnsRender($column_name, $id) 
    {
        switch ($column_name) 
        {
            case 'id':
                echo $id;
                break;
            case 'template':
                $template = get_post_meta($id, '_wp_page_template', true);
                if($template == '') { echo '-'; } else { echo $template; }
                break;
            default:
                break;
        }
    }            
        
    public function adminLoadScripts() 
    {                                                                                         
        wp_register_script(CMS_THEME_NAME.'_admin_js', CMS_THEME_URL.'/cms/js/cms.js', array('jquery', 'jquery-ui-core', 'jquery-ui-sortable'), '');
        wp_register_script(CMS_THEME_NAME.'_htmleditor', CMS_THEME_URL.'/cms/js/htmleditor.js', array('quicktags'), '');        
              
        wp_enqueue_script('media-upload'); 
        wp_enqueue_script(CMS_THEME_NAME.'_admin_js');
        wp_enqueue_script(CMS_THEME_NAME.'_htmleditor');
                                                       
    } 

    public function adminLoadStyles() 
    {
        wp_enqueue_style('thickbox');
        wp_enqueue_style(CMS_THEME_NAME.'_admin_css', CMS_THEME_URL.'/cms/css/cms.css', false);
    }           
        
    public function adminMenu() 
    {
        add_menu_page(CMS_THEME_NAME.' Theme Options', CMS_THEME_NAME, 'administrator', 'dc-general-opt', array(&$this, 'showOptions'));
        add_submenu_page('dc-general-opt', CMS_THEME_NAME.' Theme Options', 'General', 'administrator', 'dc-general-opt', array(&$this, 'showOptions'));
        add_submenu_page('dc-general-opt', CMS_THEME_NAME.' Theme Options', 'Font', 'administrator', 'dc-font-opt', array(&$this, 'showOptions')); 
        add_submenu_page('dc-general-opt', CMS_THEME_NAME.' Theme Options', 'Menu', 'administrator', 'dc-menu-opt', array(&$this, 'showOptions')); 
        add_submenu_page('dc-general-opt', CMS_THEME_NAME.' Theme Options', 'Help', 'administrator', 'dc-help-opt', array(&$this, 'showOptions')); 
    } 

    
    public function showOptions()
    {
        switch($_GET['page'])
        {
            case 'dc-general-opt':
                echo '<div class="wrap">';
                echo $this->getOptionBrandHead(false, CMS_THEME_NAME.' - General Options');            
                $this->getIGeneral()->renderTab($this->_navigaton);
                echo '</div>';             
            break;

            case 'dc-font-opt':
                echo '<div class="wrap">';
                echo $this->getOptionBrandHead(false, CMS_THEME_NAME.' - Font');    
                $this->getIFont()->renderTab($this->_navigaton);                            
                echo '</div>';            
            break;              
            
            case 'dc-menu-opt':
                echo '<div class="wrap">';
                echo $this->getOptionBrandHead(false, CMS_THEME_NAME.' - Menu');    
                $this->getIMenu()->renderTab($this->_navigaton);                            
                echo '</div>';            
            break;    
           
            case 'dc-help-opt':
                echo '<div class="wrap">';
                echo $this->getOptionBrandHead(false, CMS_THEME_NAME.' - Help');    
                $this->getIHelp()->renderTab($this->_navigaton);                            
                echo '</div>';            
            break;                         
                      
        }
    }  
    
    private function getOptionBrandHead($echo=false, $text)
    {
        $out = '';
        $out .= '<div id="icon-tools" class="icon32"></div>';
        $out .= '<h2>'.$text.'</h2>'; 
        
        if($echo) { echo $out; } else { return $out; }           
    }         
    
} // class
 
?>
