<?php
/**********************************************************************
* OSAKA UNLIMITED WORDPRESS THEME  
* (Ideal For Business And Personal Use: Portfolio or Blog)     
* 
* File name:   
*      cp_shortcodes.php
* Brief:       
*      Part of theme control panel.
* Author:      
*      DigitalCavalry
* Author URI:
*      http://themeforest.net/user/DigitalCavalry
* Contact:
*      digitalcavalry@gmail.com 
***********************************************************************/ 
              
class DCC_ControlPanelShortCodes extends DCC_ControlPanelBase    
{
    /*********************************************************** 
    * Constructor
    ************************************************************/       
    public function __construct()
    {                                                              
        // common                           
        add_shortcode('dcs_simple_head', array(&$this, 'dcs_simple_head'));     
        add_shortcode('dcs_colored_head', array(&$this, 'dcs_colored_head'));            
        add_shortcode('dcs_empty_space', array(&$this, 'dcs_empty_space')); 
        add_shortcode('dcs_clear', array(&$this, 'dcs_clear')); 
        add_shortcode('dcs_span', array(&$this, 'dcs_span')); 
        add_shortcode('dcs_highlight', array(&$this, 'dcs_highlight')); 
        add_shortcode('dcs_top', array(&$this, 'dcs_top'));
        add_shortcode('dcs_line_divider', array(&$this, 'dcs_line_divider'));
        add_shortcode('dcs_img_divider', array(&$this, 'dcs_img_divider'));
        
        add_shortcode('dcs_note', array(&$this, 'dcs_note'));
        add_shortcode('dcs_blockquote', array(&$this, 'dcs_blockquote'));        
        add_shortcode('dcs_lightbox_link', array(&$this, 'dcs_lightbox_link')); 
        add_shortcode('dcs_lightbox_ngg_link', array(&$this, 'dcs_lightbox_ngg_link'));
        add_shortcode('dcs_ul_list', array(&$this, 'dcs_ul_list'));          
        add_shortcode('dcs_postbox', array(&$this, 'dcs_postbox'));  
        add_shortcode('dcs_pagebox', array(&$this, 'dcs_pagebox'));       
        add_shortcode('dcs_image', array(&$this, 'dcs_image')); 
        add_shortcode('dcs_btn', array(&$this, 'dcs_btn'));
        add_shortcode('dcs_column', array(&$this, 'dcs_column')); 
        add_shortcode('dcs_tip', array(&$this, 'dcs_tip')); 
        add_shortcode('dcs_video', array(&$this, 'dcs_video'));
        add_shortcode('dcs_code', array(&$this, 'dcs_code')); 
   
        // advanced        
        add_shortcode('dcs_ngg', array(&$this, 'dcs_ngg')); 
        add_shortcode('dcs_ngg_thumbs_slider', array(&$this, 'dcs_ngg_thumbs_slider'));    
                                                                                                                                             
    }

    private function checkSize($size)
    {
        if($size != '1-1' and
           $size != '3-4' and
           $size != '2-3' and
           $size != '1-2' and
           $size != '1-3' and
           $size != '1-4')
        {
            $size = '1-1';
        }
        
        return $size;
    }
    
    private function checkCType($ctype)
    {    
        if($ctype != 'none' and $ctype != 'first' and $ctype != 'first-right' and
           $ctype != 'next' and $ctype != 'next-left' and $ctype != 'next-right' and
           $ctype != 'last' and $ctype != 'last-left' and $ctype != 'center')
        {
            $ctype = 'none';
        }
        
        return $ctype;
    }
    
    private function checkFloatByCType($ctype, $float)
    {
        if($ctype != 'none')
        {        
            if($ctype == 'last' or $ctype == 'last-left') { $float = 'right'; }
            else if($ctype != 'none') { $float = 'left'; }        
            if($ctype == 'center') { $float = 'none'; }   
        }
        
        return $float;     
    }    
    
    private function checkAlign($align)
    {
        if($align != 'left' and $align != 'center' and $align != 'right') { $align = 'left'; }
        return $align;
    }

    private function checkClear($clear)
    {
        if($clear != 'none' and $clear != 'left' and $clear != 'both' and $clear != 'right') { $clear = 'none'; }
        return $clear;
    }   
    
    public function convertStringTypes($args)
    {
        if(is_array($args))
        {
            foreach($args as $key => $value)
            {
                if($value === 'true') { $args[$key] = true; } 
                else if($value === 'false') { $args[$key] = false; }
            }
        }
        
        return $args;
    }     
    
    /*********************************************************** 
    * Public functions
    ************************************************************/

    /**
     * Creates simple head with bottom line
     * @param args = {color=>#444444, top=>0} 
     * @return string HTML code
     */      
    public function render_dcs_simple_head($args=array(), $content=null)   
    {                
        $def = array(
          'color' => '#666666',
          'top' => 0
        );       
        if(!is_array($args)) { $args = array(); } 
        $args = self::combineArgs($def, $args);        
      
        // args
        $args['top'] = (int)$args['top'];
        
        $style = '';        
        if($args['color'] != '' or $args['top'] > 0)
        {
            $style = ' style="';
            if($args['color'] != '')
            {
                $style .= 'color:'.$args['color'].';'; 
            }
            if($args['top'] > 0)
            {
                $style .= 'margin-top:'.$args['top'].'px;'; 
            }         
            $style .= '" ';
        }
        
        // render
        $out = '';                                                     
        $out .= '<div class="dcs-simple-head" '.$style.'><span class="head-text">'.$content.'</span></div>';        
        
        return $out;
    }   
          
    public function dcs_simple_head($args, $content=null, $code='')
    {        
        $out = '';
        $out .= self::render_dcs_simple_head($args, $content);                         

        return $out;
    }    
   
    /**
     * Creates simple head with colored background and optional colored prefix box 
     * @param args = {}
     * @return string HTML code
     */      
    public function render_dcs_colored_head($args=array(), $content=null)   
    {                
        $def = array(
            'prefix' => '',
            'prefix_w' => 0,
            'prefix_align' => 'left',
            'prefix_percent' => 'false',
            'prefix_bgcolor' => '#71639C',
            'color' => '#222222',
            'bgcolor' => '#F4F4F4',
            'top' => 0,
            'bottom' => 15
        );       
        if(!is_array($args)) { $args = array(); } 
        $args = self::combineArgs($def, $args);        
        $args = self::convertStringTypes($args);
      
        // args
        $args['top'] = (int)$args['top'];
        $args['prefix_w'] = (int)$args['prefix_w'];
        
        // checking
        $args['prefix_align'] = $this->checkAlign($args['prefix_align']);
        
        $style = '';        
        $style = ' style="';            
            $style .= 'background-color:'.$args['bgcolor'].';'; 
            if($args['top'] > 0) { $style .= 'margin-top:'.$args['top'].'px;'; }
            if($args['bottom'] > 0) { $style .= 'margin-bottom:'.$args['bottom'].'px;'; }          
        $style .= '" ';
        
        // render
        $out = '';                                                     
        $out .= '<div class="dcs-colored-head" '.$style.'>';
            if($args['prefix'] != '')
            {
                $style = ' style="';
                    $style .= 'background-color:'.$args['prefix_bgcolor'].';';
                    $style .= 'text-align:'.$args['prefix_align'].';';
                    if($args['prefix_w'] > 0) 
                    { 
                        if($args['prefix_percent'])
                        { 
                            if($args['prefix_w'] > 100) { $args['prefix_w'] = 100; }   
                            $style .= 'width:'.$args['prefix_w'].'%;';  
                        } else
                        {
                            $style .= 'width:'.$args['prefix_w'].'px;'; 
                        }
                    }
                $style .= '" ';
                $out .= '<div class="prefix" '.$style.'>'.$args['prefix'].'</div>';    
            }
            
            $style = ' style="color:'.$args['color'].';" ';
            $out .= '<div class="text" '.$style.'>'.$content.'</div>';
            
            $out .= '<div class="dc-clear"></div>';
        $out .= '</div>';        
        
        return $out;
    }      
         
    public function dcs_colored_head($args, $content=null, $code='')
    {        
        $out = '';
        $out .= self::render_dcs_colored_head($args, $content);                         

        return $out;
    }  
     
     
    /**
     * Generate simple empty DIV with clear both style and given height
     * @param args = {h=>50} 
     * @return string HTML code
     */        
    public function render_dcs_empty_space($args=array(), $content=null)
    {
        $def = array(
          'h' => 50
        );         
        if(!is_array($args)) { $args = array(); }
        $args = self::combineArgs($def, $args);  
        
        // args      
        $args['h'] = (int)$args['h'];
        if($args['h'] < 0) { $args['h'] = 0; } 
        
        // render
        $out = ''; 
        $out .= '<div class="dcs-empty-space" style="height:'.$args['h'].'px;"></div>';
        
        return $out;        
    }   
                
    public function dcs_empty_space($args, $content=null, $code='')
    {              
        $out = '';
        $out .= self::render_dcs_empty_space($args, $content);
        return $out;
    }        
    

    /**
     * Generate simple empty DIV with clear both style and given height. Works identical like dcs_empty_space shortcode, but have different, more readable name.
     * @param args = {h=>0} 
     * @return string HTML code
     */        
    public function render_dcs_clear($args=array(), $content=null)
    {
        $def = array(
          'clear' => 'both',  
          'h' => 0
        );        
        if(!is_array($args)) { $args = array(); } 
        $args = self::combineArgs($def, $args);  
              
        // args      
        $args['h'] = (int)$args['h'];
        if($args['h'] < 0) { $args['h'] = 0; }          
        
        $args['clear'] = self::checkClear($args['clear']);
        
        // render
        $out = ''; 
        $out .= '<div  class="dcs-clear" style="height:'.$args['h'].'px;clear:'.$args['clear'].';"></div>';
        return $out;        
    }    
          
    public function dcs_clear($args, $content=null, $code='')
    {               
        $out = ''; 
        $out .= self::render_dcs_clear($args, $content);
        return $out;
    }   
    
   
    /**
     * Generate span with colored text and background
     * @param args = {color=>'', bgcolor=>''} 
     * @return string HTML code
     */       
    public function render_dcs_span($args=array(), $content=null) 
    {
        $def = array(
          'color' => '',
          'bgcolor' => ''
        );        
        if(!is_array($args)) { $args = array(); }
        $args = self::combineArgs($def, $args);     
        
        // args        
        $style = '';        
        if($args['color'] != '') { $style .= 'color:'.$args['color'].';'; }
        if($args['bgcolor'] != '') { $style .= 'background-color:'.$args['bgcolor'].';'; }
        if($style != '') { $style = ' style="'.$style.'" '; }        
        
        // render
        $out = '';
        $out .= '<span '.$style.'>'.$content.'</span>'; 
        
        return $out;    
    }   
        
    public function dcs_span($args, $content=null, $code='')
    {                                                                                        
        $out = '';
        $out .= self::render_dcs_span($args, $content);

        return $out;
    }      
    
   
    /**
     * Generate span with colored background. Works similar to dcs_span, but text color option is not available
     * @param args = {bgcolor=>''} 
     * @return string HTML code
     */  
    public function render_dcs_highlight($args=array(), $content=null) 
    {
        $def = array(
          'bgcolor' => '#FFFFBB'
        );        
        if(!is_array($args)) { $args = array(); }
        $args = self::combineArgs($def, $args);        
                          
        // args
        $style = '';        
        if($args['bgcolor'] != '') { $style .= 'background-color:'.$args['bgcolor'].';'; }
        if($style != '') { $style = ' style="'.$style.'" '; }        
        
        // render
        $out = '';
        $out .= '<span class="dcs-highlight" '.$style.'>'.$content.'</span>';
        return $out;      
    }
    
    public function dcs_highlight($args, $content=null, $code='')
    {                                                             
        $out = '';
        $out .= self::render_dcs_highlight($args, $content);

        return $out;
    } 
    
    /**
     * Generate block with anchor that allows user go back to page top
     * @param args = {top=>0, bottom=>15} 
     * @return string HTML code
     */  
    public function render_dcs_top($args=array(), $content=null) 
    {
        $def = array(
            'top' => 0,
            'bottom' => 15,
            'text' => 'Top'
        );
        if(!is_array($args)) { $args = array(); }
        $args = self::combineArgs($def, $args);
 
        // args
        $args['top'] = (int)$args['top'];
        $args['bottom'] = (int)$args['bottom'];
        
        // render
        $out = '';
        $out .= '<div class="dcs-top" style="margin-bottom:'.$args['bottom'].'px;margin-top:'.$args['top'].'px;">';
            $out .= '<a href="#dc-site-top-anchor">'.$args['text'].'</a>';
        $out .= '</div>';     
        return $out;
    }  
                  
    public function dcs_top($args, $content=null, $code='')
    {
        $out = '';
        $out .= self::render_dcs_top($args, $content);
        return $out;
    }     
    

    /**
     * Generate line divider block
     * @param args = {top=>0, bottom=>15} 
     * @return string HTML code
     */  
    public function render_dcs_line_divider($args=array(), $content=null) 
    {
        $def = array(
            'top' => 0,
            'bottom' => 15,
            'bstyle' => 'solid', // solid, dashed, dotted 
            'bcolor' => '#F0F0F0',
            'bsize' => 1
        );
        if(!is_array($args)) { $args = array(); }
        $args = self::combineArgs($def, $args);
 
        // args
        $args['top'] = (int)$args['top'];
        $args['bottom'] = (int)$args['bottom'];
        
        // style
        $style = '';
            $style .= 'border-top:'.$args['bsize'].'px '.$args['bstyle'].' '.$args['bcolor'].';';
            $style .= 'margin-top:'.$args['top'].'px;';
            $style .= 'padding-bottom:'.$args['bottom'].'px;';
        $style = ' style="'.$style.'" ';
        
        // render
        $out = '';
        $out .= '<div class="dcs-line-divider" '.$style.'></div>';
        return $out;
    }  
                  
    public function dcs_line_divider($args, $content=null, $code='')
    {
        $out = '';
        $out .= self::render_dcs_line_divider($args, $content);
        return $out;
    }  
    
    /**
     * Generate image divider block
     * @param args = {top=>0, bottom=>15} 
     * @return string HTML code
     */  
    public function render_dcs_img_divider($args=array(), $content=null) 
    {
        $def = array(
            'top' => 0,
            'bottom' => 15,        
            'bgimage' => '',
            'bgrepeat' => 'repeat',
            'bgpos' => 'left top',
            'bgcolor' => '#FFFFFF',
            'bgcolor_use' => 'false',            
            'h' => 10,
            'pattern' => ''
        );
        if(!is_array($args)) { $args = array(); }
        $args = self::combineArgs($def, $args);
        $args = self::convertStringTypes($args);
 
        // args
        $args['top'] = (int)$args['top'];
        $args['bottom'] = (int)$args['bottom'];
        $args['h'] = (int)$args['h'];
        
        if($args['bgimage'] == '' and $args['pattern'] != '')
        {
            $args['bgimage'] = CMS_THEME_URL.'/img/divider/'.$args['pattern'];    
        }
        
        // style
        $style = '';
            $style .= 'height:'.$args['h'].'px;';
            if($args['bgimage'] != '')
            {
                $style .= 'background-image:url('.$args['bgimage'].');';
                $style .= 'background-position:'.$args['bgpos'].';';
                $style .= 'background-repeat:'.$args['bgrepeat'].';'; 
            }
            if($args['bgcolor_use'])
            {
                $style .= 'background-color:'.$args['bgcolor'].';';     
            }
            $style .= 'margin-top:'.$args['top'].'px;';
            $style .= 'margin-bottom:'.$args['bottom'].'px;';
        $style = ' style="'.$style.'" ';
        
        // render
        $out = '';
        $out .= '<div class="dcs-img-divider" '.$style.'></div>';
        return $out;
    }  
                  
    public function dcs_img_divider($args, $content=null, $code='')
    {
        $out = '';
        $out .= self::render_dcs_img_divider($args, $content);
        return $out;
    }      
  
    /**
     * Create simple note block 
     * @param args = {color, bgcolor, bcolor, align, execute, rounded, bottom} 
     * @return string HTML code
     */      
    public function render_dcs_note($args=array(), $content=null) 
    { 
        $def = array(
          'color' => '#5a5a5a',
          'bgcolor' => '#FFFFFF',
          'bcolor' => '#F2F2F2',
          'bwidth' => 6,
          'align' => 'left',
          'execute' => 'false',
          'rounded' => 0,
          'bottom' => 15
        );         
        if(!is_array($args)) { $args = array(); }
        $args = self::combineArgs($def, $args);   
             
        // args        
        $style = '';
            $style .= 'color:'.$args['color'].';';
            $style .= 'background-color:'.$args['bgcolor'].';';
            $style .= 'border-color:'.$args['bcolor'].';';
            $style .= 'border-width:'.$args['bwidth'].'px;'; 
            if($args['bwidth'] == 0) { $style .= 'padding:0px;'; }
            $style .= 'text-align:'.$args['align'].';';
            $style .= 'margin-bottom:'.$args['bottom'].'px;';
        $style = ' style="'.$style.'" ';                
   
        if($args['execute'] == 'true') { $content = do_shortcode($content); }
        
        $class = '';
        if((int)$args['rounded'] > 0) {  $class = ' dc-rounded-'.(int)$args['rounded']; }     
        
        // render
        $out = ''; 
        $out .= '<div class="dcs-note '.$class.'" '.$style.'>'.$content.'</div>';         
                
        return $out;
    }
          
    public function dcs_note($args, $content=null, $code='')
    {
        $out = '';
        $out .= self::render_dcs_note($args, $content);
        return $out;
    }      
    

    /**
     * Generate standard block quote 
     * @param args = {w, float} 
     * @return string HTML code
     */      
    public function render_dcs_blockquote($args=array(), $content=null) 
    {   
        $def = array(
          'size' => '1-1', // 1-1, 3-4, 2-3, 1-2, 1-3, 1-4
          'ctype' => 'none',
          'float' => 'none',
          'color' => '',
          'top' => 0,
          'right' => 0,
          'bottom' => 20,
          'left' => 0,
          'align' => 'left',
          'author' => '',
          'title' => '',
          'fsize' => 16,
          'lheight' => 22
        );
        if(!is_array($args)) { $args = array(); }         
        $args = self::combineArgs($def, $args);
        
        $args['ctype'] = self::checkCType($args['ctype']);      
        $args['float'] = self::checkFloatByCType($args['ctype'], $args['float']);         
              
        $column_postfix = '';
        if($args['ctype'] == 'none' and $args['float'] == 'right') { $column_postfix = '-right'; }              
                              
        // args
        $style_w = '';
            $style_w .= 'float:'.$args['float'].';';
        $style_w = ' style="'.$style_w.'" ';
        
        $style = '';
            $style .= 'color:'.$args['color'].';';        
            
            $style .= 'margin-top:'.$args['top'].'px;';
            $style .= 'margin-right:'.$args['right'].'px;';
            $style .= 'margin-bottom:'.$args['bottom'].'px;';
            $style .= 'margin-left:'.$args['left'].'px;';
            
            $style .= 'text-align:'.$args['align'].';'; 
            $style .= 'font-size:'.$args['fsize'].'px;'; 
            $style .= 'line-height:'.$args['lheight'].'px;'; 
                       
        $style = ' style="'.$style.'" ';          
                
        // render
        $out = '';
        
        $out .= '<div class="dcs-blockquote-wrapper dc-percent-column-'.self::checkSize($args['size']).$column_postfix.' dc-ctype-'.$args['ctype'].'" '.$style_w.'>';
            $out .= '<blockquote '.$style.' >'.$content;
                if($args['author'] != '')
                {
                    $out .= '<span class="author">'.$args['author'].'</span>';
                }
                if($args['title'] != '')
                {
                    $out .= '<span class="author-title">'.$args['title'].'</span>';
                }
            $out .= '</blockquote>';  
        $out .= '</div>';         
        return $out;            
    }      
   
    public function dcs_blockquote($args, $content=null, $code='')
    {              
        $out = '';
        $out .= self::render_dcs_blockquote($args, $content);
        return $out;
    }      
    
  
    /**
     * Lightbox inline link
     * @param args = {color, url, group, title, color_use} 
     * @return string HTML code
     */    
    public function render_dcs_lightbox_link($args=array(), $content=null) 
    {
        $def = array(
          'color' => '#808080',  
          'url' => '',
          'group' => '',
          'title' => '',
          'color_use' => 'false'
        );    
        if(!is_array($args)) { $args = array(); }     
        $args = self::combineArgs($def, $args);    
       
        // args
        $style = '';
        if($args['color_use'] == 'true')
        {
            $style = ' style="color:'.$args['color'].';" ';           
        }
        
        $group = $args['group'] != '' ? '['.$args['group'].']' : '' ;
        
        // render
        $out = '';
        $out .= '<a '.$style.' href="'.$args['url'].'" rel="lightbox'.$group.'" name="'.$args['title'].'" >'.$content.'</a>';  
        return $out;       
    }
     
    public function dcs_lightbox_link($args, $content=null, $code='')
    { 
        $out = '';
        $out .= self::render_dcs_lightbox_link($args, $content);        
        return $out;
    }  
  
    /**
     * Unordered list
     * @param args = {type, left, bottom} 
     * @return string HTML code
     */    
    public function render_dcs_ul_list($args=array(), $content=null)    
    {
        $def = array(
          'size' => '1-1',
          'ctype' => 'none',
          'float' => 'none',        
          'type' => 'default',  // default
          'bottom' => 15,
          'left' => 0
        );    
        if(!is_array($args)) { $args = array(); }    
        $args = self::combineArgs($def, $args);          
        
        $args['ctype'] = self::checkCType($args['ctype']);
        $args['float'] = self::checkFloatByCType($args['ctype'], $args['float']);         
              
        $column_postfix = '';
        if($args['ctype'] == 'none' and $args['float'] == 'right') { $column_postfix = '-right'; }             
        
        // args
        $style_w = '';
            $style_w .= 'float:'.$args['float'].';';
        $style_w = ' style="'.$style_w.'" ';           
        
        $lis = preg_split("/(\r\n|\n|\r)/", $content);
                                               
        $filtered = array();
        foreach($lis as $li)
        {           
            if(trim($li) != '') { array_push($filtered, $li); }             
        }
        $lis = $filtered;
        
        $style = '';
        $style .= 'margin-bottom:'.$args['bottom'].'px;';
        $style .= 'margin-left:'.$args['left'].'px;';
        $style = ' style="'.$style.'" ';
        
        // render
        $out = '';
        $out .= '<div class="dcs-ul-list-wrapper dc-percent-column-'.self::checkSize($args['size']).$column_postfix.' dc-ctype-'.$args['ctype'].'" '.$style_w.'>';  
            $out .= '<ul class="dc-list-'.$args['type'].'" '.$style.'>';
                foreach($lis as $li)
                {
                    $out .= '<li>'.$li.'</li>';    
                }     
            $out .= '</ul>'; 
        $out .= '</div>';
        return $out;    
    }

    public function dcs_ul_list($args, $content=null, $code='')
    {                                                                         
        $out = '';
        $out .= self::render_dcs_ul_list($args, $content);
        return $out;
    }       
    
    
    /**
     * Displays a special box with post image, description, and a link to post page  
     * @param args = {id, size, ctype, desc, words, float, top, right, bottom, left, url}  
     * @return string HTML code
     */   
    public function render_dcs_postbox($args=array(), $content=null)  
    {        
        $def = array(
          'id' => CMS_NOT_SELECTED,
          'size' => '1-3', // 1-1, 3-4, 2-3, 1-2, 1-3, 1-4  
          'ctype' => 'none', 
          'desc' => '',
          'words' => 16,
          'float' => 'none',
          'top' => 0,
          'right' => 0,
          'bottom' => 20,
          'left' => 0,
          'url' => '',
          'border' => 'true'
        );         
        if(!is_array($args)) { $args = array(); }
        $args = self::combineArgs($def, $args);
        $args = self::convertStringTypes($args);  
      
        // args
        $args['ctype'] = self::checkCType($args['ctype']);
        $args['float'] = self::checkFloatByCType($args['ctype'], $args['float']);
      
        $column_postfix = '';
        if($args['ctype'] == 'none' and $args['float'] == 'right') { $column_postfix = '-right'; }
      
        // render
        if($args['id'] != CMS_NOT_SELECTED and $args['id'] != '')
        {
            global $wpdb;
            $query = "SELECT ID, post_title, post_excerpt, post_content, post_name FROM $wpdb->posts WHERE ID = ".$args['id']." AND post_type = 'post' AND post_status = 'publish' ";
            $result = $wpdb->get_results($query);
            
            $count = 0;
            if(is_array($result)) { $count = count($result); }                        
            if($count)
            {                                             
                $obj = $result[0];
                $post_opt = null;
                $image_alt = '';
                
                if($args['url'] == '')
                {
                    $post_opt = get_post_meta($obj->ID, 'post_opt', true);
                    $args['url'] = $post_opt['post_image'];
                    $image_alt = $post_opt['post_image_alt'];
                    
                    if(GetDCCPI()->getIGeneral()->getOption('theme_use_post_wp_thumbnail'))
                    {
                        $t_data = GetDCCPI()->getIRenderer()->getPostThumbnailURL($obj->ID);
                        if($t_data['url'] !== false)
                        {
                            $args['url'] = $t_data['url'];
                            $image_alt = $t_data['alt'];                    
                        }           
                    }                                    
                }
  
                $style_w = '';
                    $style_w .= 'float:'.$args['float'].';';
                $style_w = ' style="'.$style_w.'" ';  
  
                $style = '';
                    $style .= 'margin-top:'.$args['top'].'px;';  
                    $style .= 'margin-right:'.$args['right'].'px;';  
                    $style .= 'margin-bottom:'.$args['bottom'].'px;';  
                    $style .= 'margin-left:'.$args['left'].'px;';
                    if(!$args['border'])
                    {
                        $style .= 'border:none;';
                        $style .= 'padding:0px;';    
                    }                    
                $style = ' style="'.$style.'" ';                 
                
                $permalink = get_permalink($obj->ID);
                
                $out = '';
                $out .= '<div class="dcs-post-box-wrapper dc-percent-column-'.self::checkSize($args['size']).$column_postfix.' dc-ctype-'.$args['ctype'].'" '.$style_w.'>'; 
                    $out .= '<div class="dcs-post-box" '.$style.'>';
                        
                        $image_alt = str_replace(array('"'), '', $image_alt);                        
                        $out .= '<a class="image-loader async-img-none" href="'.$permalink.'" rel="'.dcf_getImageURL($args['url'], 480, 320, CMS_IMAGE_CROP_FIT, $post_opt['post_image_filter']).'" title="'.$image_alt.'"></a>';   
                    
                    $out .= '<div class="box-desc">';                    
                        
                        $out .= '<a class="title" href="'.$permalink.'">'.$obj->post_title.'</a>'; 
                        
                        $more_link = '<a class="more-link" href="'.$permalink.'">'.__('Read more', CMS_TXT_DOMAIN).'</a>'; 
                        if($args['words'] > 0)
                        {
                            $desc = '';                            
                            if($args['desc'] != '')
                            {
                                $desc = '<div class="description">'.$args['desc'].'</div>';        
                            } else
                            if($obj->post_excerpt != '' and $args['words'] > 0)
                            {
                                $desc = '<div class="description">'.dcf_strNWords($obj->post_excerpt, $args['words']).'</div>';   
                            } else
                            if($obj->post_content != '' and $args['words'] > 0)
                            {
                                $desc = '<div class="description">'.dcf_strNWords($obj->post_content, $args['words']).'</div>';     
                            }
                            $out .= $desc;
                        }
                        
                        if($args['words'] > 0)
                        {                        
                            $out .= '<div class="more-link-wrapper">';
                                $out .= $more_link; 
                            $out .= '</div>';
                        }
                    $out .= '</div>'; 
                    
                    $out .= '</div>';
                $out .= '</div>';  
                
            }                            
        }
        return $out;         
    }
        
    public function dcs_postbox($args, $content=null, $code='')
    {
        $out = '';
        $out .= self::render_dcs_postbox($args, $content);
        return $out;
    }     
    

    /**
     * Displays a special box with page image, description, and a link to the page  
     * @param args = {id, size, ctype, desc, words, float, top, right, bottom, left, url} 
     * @return string HTML code
     */   
    public function render_dcs_pagebox($args=array(), $content=null)  
    {        
        $def = array(
          'id' => CMS_NOT_SELECTED,
          'size' => '1-3', // 1-1, 3-4, 2-3, 1-2, 1-3, 1-4  
          'ctype' => 'none', 
          'desc' => '',
          'words' => 16,
          'float' => 'none',
          'top' => 0,
          'right' => 0,
          'bottom' => 20,
          'left' => 0,
          'url' => '',
          'border' => 'true' 
        );         
        if(!is_array($args)) { $args = array(); }
        $args = self::combineArgs($def, $args);
        $args = self::convertStringTypes($args);  
      
        // args
        $args['ctype'] = self::checkCType($args['ctype']);
        $args['float'] = self::checkFloatByCType($args['ctype'], $args['float']);
      
        $column_postfix = '';
        if($args['ctype'] == 'none' and $args['float'] == 'right') { $column_postfix = '-right'; }
      
        // render
        if($args['id'] != CMS_NOT_SELECTED and $args['id'] != '')
        {
            global $wpdb;
            $query = "SELECT ID, post_title, post_excerpt, post_content, post_name FROM $wpdb->posts WHERE ID = ".$args['id']." AND post_type = 'page' AND post_status = 'publish' ";
            $result = $wpdb->get_results($query);
            
            $count = 0;
            if(is_array($result)) { $count = count($result); }                        
            if($count)
            {                                             
                $obj = $result[0];
                $post_opt = null;
                $image_alt = '';
                
                if($args['url'] == '')
                {
                    $post_opt = get_post_meta($obj->ID, 'page_common_opt', true);
                    $args['url'] = $post_opt['page_image'];
                    $image_alt = $post_opt['page_image_alt'];
                    
                    if(GetDCCPI()->getIGeneral()->getOption('theme_use_page_wp_thumbnail'))
                    {
                        $t_data = GetDCCPI()->getIRenderer()->getPostThumbnailURL($obj->ID);
                        if($t_data['url'] !== false)
                        {
                            $args['url'] = $t_data['url'];                    
                            $image_alt = $t_data['alt'];
                        }           
                    }                                    
                }
  
                $style_w = '';
                    $style_w .= 'float:'.$args['float'].';';
                $style_w = ' style="'.$style_w.'" ';  
  
                $style = '';
                    $style .= 'margin-top:'.$args['top'].'px;';  
                    $style .= 'margin-right:'.$args['right'].'px;';  
                    $style .= 'margin-bottom:'.$args['bottom'].'px;';  
                    $style .= 'margin-left:'.$args['left'].'px;';
                    if(!$args['border'])
                    {
                        $style .= 'border:none;';
                        $style .= 'padding:0px;';    
                    }
                $style = ' style="'.$style.'" ';                 
                
                $permalink = get_permalink($obj->ID);
                
                $out = '';
                $out .= '<div class="dcs-post-box-wrapper dc-percent-column-'.self::checkSize($args['size']).$column_postfix.' dc-ctype-'.$args['ctype'].'" '.$style_w.'>'; 
                    $out .= '<div class="dcs-post-box" '.$style.'>';
                        
                        $image_alt = str_replace(array('"'), '', $image_alt);                      
                        
                        $out .= '<a class="image-loader async-img-none" href="'.$permalink.'" rel="'.dcf_getImageURL($args['url'], 480, 320, CMS_IMAGE_CROP_FIT, $post_opt['page_image_filter']).'" title="'.$image_alt.'"></a>';   
                    
                    $out .= '<div class="box-desc">';                    
                        
                        $out .= '<a class="title" href="'.$permalink.'">'.$obj->post_title.'</a>'; 
                        
                        $more_link = '<a class="more-link" href="'.$permalink.'">'.__('Read more', CMS_TXT_DOMAIN).'</a>'; 
                        if($args['words'] > 0)
                        {                        
                            $desc = '';
                            if($args['desc'] != '')
                            {
                                $desc = '<div class="description">'.$args['desc'].'</div>';        
                            } else
                            if($obj->post_excerpt != '' and $args['words'] > 0)
                            {
                                $desc = '<div class="description">'.dcf_strNWords($obj->post_excerpt, $args['words']).'</div>';   
                            } else
                            if($obj->post_content != '' and $args['words'] > 0)
                            {
                                $desc = '<div class="description">'.dcf_strNWords($obj->post_content, $args['words']).'</div>';     
                            }
                            $out .= $desc;
                        }
                        
                        if($args['words'] > 0)
                        {
                            $out .= '<div class="more-link-wrapper">';
                                $out .= $more_link; 
                            $out .= '</div>';
                        }
                    $out .= '</div>'; 
                    
                    $out .= '</div>';
                $out .= '</div>';  
                
            }                            
        }
        return $out;         
    }
          
    public function dcs_pagebox($args, $content=null, $code='')
    {
        $out = '';
        $out .= self::render_dcs_pagebox($args, $content);
        return $out;
    }  
    
    /**
     * Lightbox NGG image inline link
     * @param args = {color, id, group, title, color_use} 
     * @return string HTML code
     */    
    public function render_dcs_lightbox_ngg_link($args=array(), $content=null) 
    {
        $def = array(
          'color' => '#000000',  
          'id' => '',
          'group' => '',
          'title' => '',
          'color_use' => 'false'
        );    
        if(!is_array($args)) { $args = array(); }     
        $args = self::combineArgs($def, $args);    
       
        // args
        $style = '';
        if($args['color_use'] == 'true')
        {
            $style = ' style="color:'.$args['color'].';" ';           
        }
        
        $group = $args['group'] != '' ? '['.$args['group'].']' : '' ;                
        
        global $nggdb;
        $pic = false;
        if(isset($nggdb))
        {             
            $pic = $nggdb->find_image($args['id']); 
        }          

        // render                   
        $out = '';
        if($pic !== false)
        {
            if($args['title'] == '') { $args['title'] = $pic->alttext; }            
            $out .= '<a '.$style.' href="'.$pic->imageURL.'" rel="lightbox'.$group.'" name="'.$args['title'].'" >'.$content.'</a>';  
        } else
        {
            $out .= $content;
        }
        
        return $out;       
    }
     
    public function dcs_lightbox_ngg_link($args, $content=null, $code='')
    { 
        $out = '';
        $out .= self::render_dcs_lightbox_ngg_link($args, $content);        
        return $out;
    }      
    
    
    
    /**
     * Display selected image
     * @param args = {url, size, ctype, float, align} 
     * @return string HTML code
     */    
    public function render_dcs_image($args=array(), $content=null)
    {
        $def = array(
          'url' => '',  
          'alt' => '',
          'size' => '1-3',
          'ctype' => 'none',
          'float' => 'none',
          'clear' => 'none',
          'align' => 'left',
          'top' => 0,
          'right' => 0,
          'bottom' => 15,
          'left' => 0,        
          'title' => '',
          'desc' => '',    
          'padding' => 0,
          'border' => 'false',
          'lightbox' => 'false',
          'link' => '',
          'image_as_link' => 'false',
          'new_tab' => 'false',
          'group' => '',
          'real_size' => 'true',
          'viewport_w' => 600,
          'viewport_h' => 400,
          'grayscale' => 'false'
        );   
        if(!is_array($args)) { $args = array(); }      
        $args = self::combineArgs($def, $args);       
        $args = self::convertStringTypes($args);
        
        // checking
        $args['ctype'] = self::checkCType($args['ctype']);
        $args['float'] = self::checkFloatByCType($args['ctype'], $args['float']);         
        $args['clear'] = self::checkClear($args['clear']);   
              
        $column_postfix = '';
        if($args['ctype'] == 'none' and $args['float'] == 'right') { $column_postfix = '-right'; }             
        
        // args
        $style_w = '';
            $style_w .= 'float:'.$args['float'].';';
            $style_w .= 'clear:'.$args['clear'].';'; 
        $style_w = ' style="'.$style_w.'" ';        
        
        $style = '';                
            $style .= 'margin-top:'.$args['top'].'px;';
            $style .= 'margin-right:'.$args['right'].'px;';
            $style .= 'margin-bottom:'.$args['bottom'].'px;';
            $style .= 'margin-left:'.$args['left'].'px;'; 
            
            $style .= 'padding:'.$args['padding'].'px;';    
            if(!$args['border']) { $style .= 'border:none;'; }        
        $style = ' style="'.$style.'" ';           
        
        $args['align'] = self::checkAlign($args['align']);
        $group = $args['group'] != '' ? '['.$args['group'].']' : '' ;  
        $target = $args['new_tab'] ? ' target="_blank" ' : ' target="_self" ' ;
        
        // render
        $out = '';        
        $out .= '<div class="dcs-image-wrapper dc-percent-column-'.self::checkSize($args['size']).$column_postfix.' dc-ctype-'.$args['ctype'].'" '.$style_w.'>';
            $out .= '<div class="dcs-image" '.$style.'>';
                $out .= '<div class="image-wrapper">';
                    
                    $filter = CMS_IMAGE_FILTER_NONE;
                    if($args['grayscale']) { $filter = CMS_IMAGE_FILTER_GRAYSCALE; }
                    
                    $image_url = $args['url'];
                    if($args['real_size'])
                    {
                        $image_url = dcf_getImageURL($args['url'], null, null, CMS_IMAGE_CROP_FIT, $filter, true);
                        $out .= '<a class="image-loader async-img-none" rel="'.$image_url.'" title="'.$args['alt'].'"></a>';
                    } else
                    {
                        $image_url = dcf_getImageURL($args['url'], $args['viewport_w'], $args['viewport_h'], CMS_IMAGE_CROP_FIT, $filter);
                        $out .= '<a class="image-loader async-img-none" rel="'.$image_url.'" title="'.$args['alt'].'"></a>';
                    }
                    if($args['lightbox'])
                    {
                        $lb_url = dcf_getImageURL($args['url'], null, null, CMS_IMAGE_CROP_FIT, $filter, true); 
                        $out .= '<a class="triger" href="'.$lb_url.'" rel="lightbox'.$group.'" name="'.$args['title'].'"></a>';
                    } else
                    if($args['image_as_link'] and $args['link'] != '')
                    {
                        $out .= '<a class="triger" href="'.$args['link'].'" '.$target.'></a>';    
                    }
                $out .= '</div>';
                
                if($args['title'] != '')
                {
                    $out .= '<div class="title" style="text-align:'.$args['align'].';">';
                        $out .= $args['title'];
                    $out .= '</div>';                  
                } 
                if($args['desc'] != '')
                {
                    $out .= '<div class="description" style="text-align:'.$args['align'].';">';
                        $out .= $args['desc']; 
                    $out .= '</div>';
                }    
            $out .= '</div>';
        $out .= '</div>';
        
        return $out;
    }     
    
    public function dcs_image($args, $content=null, $code='')  
    {
        $out = '';
        $out .= self::render_dcs_image($args, $content);
        return $out;
    } 
    
    /**
     * Display standard simple button
     * @param args = {label, url, color, hcolor, wrapper, new_tab, clear, align} 
     * @return string HTML code
     */   
    public function render_dcs_btn($args=array(), $content=null)   
    {
        $def = array(
          'label' => 'Button label',
          'url' => '',  
          'color' => '#757575',
          'hcolor' => '#000000',
          'wrapper' => 'false',
          'new_tab' => 'false',
          'clear' => 'none',
          'align' => 'left'
        );        
        if(!is_array($args)) { $args = array(); }   
        $args = self::combineArgs($def, $args);         

        // args        
        $href = ' href="'.$args['url'].'" ';
        $target = $args['new_tab'] == 'true' ? ' target="_blank" ' : ' target="_self" ' ;   
        $args['align'] = self::checkAlign($args['align']);
        $args['clear'] = self::checkClear($args['clear']);
        
        $style_w = '';
            $style_w .= 'text-align:'.$args['align'].';';
            $style_w .= 'clear:'.$args['clear'].';';
        $style_w = ' style="'.$style_w.'" ';              
        
        $style = '';
            $style = 'color:'.$args['color'].';'; 
            if($args['align'] == 'right') { $style .= 'margin-right:0px;margin-left:4px;'; }
        $style = ' style="'.$style.'" ';
        
        // render
        $out = '';          
        if($args['wrapper'] == 'true') { $out .= '<div class="dcs-btn-wrapper" '.$style_w.'>'; }                                            
            $out .= '<a class="dcs-btn" '.$href.' '.$target.' '.$style.' onmouseover="this.style.color=\''.$args['hcolor'].'\';" onmouseout="this.style.color=\''.$args['color'].'\';">';
                $out .= $args['label'];
            $out .= '</a>';
        if($args['wrapper'] == 'true') { $out .= '</div>'; }                                                    
        
        return $out;        
    } 
     
    public function dcs_btn($args, $content=null, $code='')
    {        
        $out = '';
        $out .= self::render_dcs_btn($args, $content);
        return $out;
    }

    /**
     * Display standard configurable column
     * @param args = {size, ctype, float, clear, sc_filter, wp_filter, top, right, bottom, left} 
     * @return string HTML code
     */   
    public function render_dcs_column($args=array(), $content=null)   
    {
        $def = array(
          'size' => '1-1',
          'ctype' => 'none',
          'float' => 'none', 
          'clear' => 'none',
          'sc_filter' => 'true',
          'wp_filter' => 'false',
          'top' => 0,
          'right' => 0,
          'bottom' => 20,
          'left' => 0  
        );        
        if(!is_array($args)) { $args = array(); }   
        $args = self::combineArgs($def, $args);    
    
        // checking
        $args['ctype'] = self::checkCType($args['ctype']);
        $args['float'] = self::checkFloatByCType($args['ctype'], $args['float']);         
        $args['clear'] = self::checkClear($args['clear']);
              
        $column_postfix = '';
        if($args['ctype'] == 'none' and $args['float'] == 'right') { $column_postfix = '-right'; }             
        
        // args
        $style_w = '';
            $style_w .= 'float:'.$args['float'].';';
            $style_w .= 'clear:'.$args['clear'].';'; 
        $style_w = ' style="'.$style_w.'" ';         
    
        $style = '';                
            $style .= 'margin-top:'.$args['top'].'px;';
            $style .= 'margin-right:'.$args['right'].'px;';
            $style .= 'margin-bottom:'.$args['bottom'].'px;';
            $style .= 'margin-left:'.$args['left'].'px;';      
        $style = ' style="'.$style.'" ';        
    
        // render
        $out = '';
        $out .= '<div class="dcs-column-wrapper dc-percent-column-'.self::checkSize($args['size']).$column_postfix.' dc-ctype-'.$args['ctype'].'" '.$style_w.'>';       
            $out .= '<div class="dcs-column" '.$style.'>';
        
                if($args['sc_filter'] == 'true')
                {
                    $out .= do_shortcode($content);
                } else
                {
                    $content = wptexturize($content);
                    $content = convert_smilies($content);
                    $content = convert_chars($content);
                    $content = wpautop($content);   
                    $out .= $content;                  
                }   
            
            $out .= '</div>';               
        $out .= '</div>';
        
        return $out;    
    }    
    
    public function dcs_column($args, $content=null, $code='')
    {        
        $out = '';
        $out .= self::render_dcs_column($args, $content);
        return $out;
    }    
 
    /**
     * Display tip block with image and link
     * @param args = {label, url, color, hcolor, wrapper, new_tab, clear, align} 
     * @return string HTML code
     */   
    public function render_dcs_tip($args=array(), $content=null)   
    {
        $def = array(
          'url' => '',
          'title' => '',
          'color' => '#666666',
          'new_tab' => 'false',
          'link' => '',
          'link_name' => __('Read more', CMS_TXT_DOMAIN),
          'bottom' => 20,
          'image_space' => 100
        );        
        if(!is_array($args)) { $args = array(); }   
        $args = self::combineArgs($def, $args);  
        $args = self::convertStringTypes($args);       

        // args        
        $href = ' href="'.$args['link'].'" ';
        $target = $args['new_tab'] ? ' target="_blank" ' : ' target="_self" ' ;          
        
        $style = '';
            $style .= 'margin-bottom:'.$args['bottom'].'px;';
        $style = ' style="'.$style.'" ';
        
        // render
        $out = '';          
        $out .= '<div class="dcs-tip" '.$style.'>';
            if($args['url'] != '')
            {
                $out .= '<div class="left-side" style="width:'.$args['image_space'].'px;">';
                    $out .= '<img src="'.$args['url'].'" alt="'.$args['title'].'"/>';
                $out .= '</div>';
            }            
            
            $noimage = 'no-image';
            if($args['url'] != '') { $noimage = ''; }
            
            $style = '';
                $style .= 'color:'.$args['color'].';';
                
                if($args['url'] != '') { $style .= 'margin-left:'.($args['image_space']+15).'px;'; }
            $style = ' style="'.$style.'" ';            
            
            $out .= '<div class="right-side '.$noimage.'" '.$style.'>';
                if($args['title'] != '')
                {
                    $out .= '<div class="tip-title">'.$args['title'].'</div>';    
                }
                 
                $content = wptexturize($content);
                $content = convert_smilies($content);
                $content = convert_chars($content);
                $content = wpautop($content);   
                $out .= $content;                    
                                
                if($args['link'] != '')
                {
                    $out .= '<div class="tip-links">';
                        $out .= '<a '.$href.' '.$target.'>'.$args['link_name'].'</a>';
                    $out .= '</div>';
                }
            $out .= '</div>';
            $out .= '<div class="dc-clear-both"></div>';
        $out .= '</div>';                                                
        
        return $out;        
    }     

    public function dcs_tip($args, $content=null, $code='')
    {        
        $out = '';
        $out .= self::render_dcs_tip($args, $content);
        return $out;
    }       
   
    /**
     * Display video from YouTube or Vimeo
     * @param args = {size=>'1-1'} 
     * @return string HTML code
     */        
    public function render_dcs_video($args=array(), $content=null)
    {
        $def = array(
          'size' => '1-1',
          'ctype' => 'none',
          'float' => 'none',
          'clear' => 'none',            
          'url' => '',        
          'bottom' => 20,
          'desc_use' => 'true'
        );         
        if(!is_array($args)) { $args = array(); }
        $args = self::combineArgs($def, $args);  
        $args = self::convertStringTypes($args); 

        // checking
        $args['ctype'] = self::checkCType($args['ctype']);
        $args['float'] = self::checkFloatByCType($args['ctype'], $args['float']);         
        $args['clear'] = self::checkClear($args['clear']); 
              
        $column_postfix = '';
        if($args['ctype'] == 'none' and $args['float'] == 'right') { $column_postfix = '-right'; }    
        
        // args      
        $style_w = '';
            $style_w .= 'float:'.$args['float'].';'; 
            $style_w .= 'margin-bottom:'.$args['bottom'].'px;';
            $style_w .= 'clear:'.$args['clear'].';';
        $style_w = ' style="'.$style_w.'" ';     
        
        // render
        $out = ''; 

        $is_vimeo = strstr($args['url'], 'vimeo.com') !== false ? true : false;
        $is_youtube = strstr($args['url'], 'youtube.com') !== false ? true : false;
        
        if($is_vimeo or $is_youtube)
        {    
            $out .= '<div class="dcs-video-wrapper dc-percent-column-'.self::checkSize($args['size']).$column_postfix.' dc-ctype-'.$args['ctype'].'" '.$style_w.'>'; 
                $out .= '<div class="dcs-video">';
                    $time = time();
                    if($is_vimeo)
                    {
                        $pos = strrpos($args['url'], '/') + 1;
                        $video_id = substr($args['url'], $pos);
                        $out .= '<iframe src="http://player.vimeo.com/video/'.$video_id.'?dc_param='.$time.'" frameborder="0" webkitAllowFullScreen mozallowfullscreen allowFullScreen></iframe>';
                    } else
                    if($is_youtube)
                    {
                        $url = parse_url($args['url']);
                        $vars = array();
                        parse_str($url['query'], $vars);
                        $out .= '<iframe src="http://www.youtube.com/embed/'.$vars['v'].'?rel=0&wmode=transparent" frameborder="0" allowfullscreen></iframe>';
                    }                                                                                      
                $out .= '</div>';
                
                if($args['desc_use'])
                {
                    if($content !== null)
                    {
                        if(strlen(trim($content)) > 0)
                        {
                            $out .= '<div class="video-description">'.wpautop($content).'</div>';  
                        }  
                    }
                }  
            $out .= '</div>';                        
        }        
        
        return $out;        
    }   
                
    public function dcs_video($args, $content=null, $code='')
    {              
        $out = '';
        $out .= self::render_dcs_video($args, $content);
        return $out;
    }      

    /**
     * Displays NGG gallery in the form of configurable thumbs.
     * @param args = {size=>'1-1'} 
     * @return string HTML code
     */     
    public function render_dcs_ngg($args, $content=null, $code='')
    {      
        $def = array(
          'size' => '1-1',
          'ctype' => 'none',
          'float' => 'none',
          'clear' => 'none',            
          'id' => CMS_NOT_SELECTED,
          'count' => 16,
          'w' => 80,
          'h' => 80,
          'random' => 'false',
          'border' => 'false',                     
          'tbottom' => 10, 
          'tright' => 10,         
          'padding' => 0,
          'group' => '',            
          'bcolor' => '#EEEEEE',   
          'bottom' => 0,
          'bgcolor' => '#FFFFFF',
          'bgcolor_use' => 'false',
          'all' => 'false'
        ); 
        if(!is_array($args)) { $args = array(); }
        $args = self::combineArgs($def, $args);          
        $args = self::convertStringTypes($args);
 
        // checking
        $args['ctype'] = self::checkCType($args['ctype']);
        $args['float'] = self::checkFloatByCType($args['ctype'], $args['float']);         
        $args['clear'] = self::checkClear($args['clear']); 
              
        $column_postfix = '';
        if($args['ctype'] == 'none' and $args['float'] == 'right') { $column_postfix = '-right'; }      

        // args      
        $style_w = '';
            $style_w .= 'float:'.$args['float'].';'; 
            $style_w .= 'margin-bottom:'.$args['bottom'].'px;';
            $style_w .= 'clear:'.$args['clear'].';';
        $style_w = ' style="'.$style_w.'" ';             
        
        // render
        $out = '';          
        $out .= '<div class="dcs-ngg-wrapper dc-percent-column-'.self::checkSize($args['size']).$column_postfix.' dc-ctype-'.$args['ctype'].'" '.$style_w.'>';    

            $out .= '<div class="dcs-ngg">';
            
                global $nggdb;
                if(isset($nggdb) and $args['id'] != CMS_NOT_SELECTED)
                {                              
                    $gallery = $nggdb->find_gallery($args['id']);
                    
                    if($gallery != false)
                    {      
                        $pics = null;
                        if($args['random'])
                        {   
                            $pics = $nggdb->get_random_images($args['count'], $args['id']); 
                        } else
                        {
                            if($args['all']) { $args['count'] = 0; }
                            $pics = $nggdb->get_gallery($args['id'], 'sortorder', 'ASC', true, $args['count'], $start = 0);    
                        }                   
                    
                        if(is_array($pics))
                        {       
                            foreach($pics as $pic)
                            {
                                $t_style = '';
                                    $t_style .= 'width:'.$args['w'].'px;';
                                    $t_style .= 'height:'.$args['h'].'px;';
                                    $t_style .= 'padding:'.$args['padding'].'px;';
                                    $t_style .= 'margin-right:'.$args['tright'].'px;';
                                    $t_style .= 'margin-bottom:'.$args['tbottom'].'px;';
                                    if($args['border']) { $t_style .= 'border:1px solid '.$args['bcolor'].';'; }
                                    if($args['bgcolor_use']) { $t_style .= 'background-color:'.$args['bgcolor'].';'; }
                                $t_style = ' style="'.$t_style.'" ';
                                
                                $t_url = dcf_getImageURL($pic->imageURL, $args['w'], $args['h'], CMS_IMAGE_CROP_FIT);
                                $t_group = '[ngg-gid-'.$args['id'].']';
                                if($args['group'] != '') { $t_group = '['.$args['group'].']'; }
                                
                                $out .= '<div class="thumb" '.$t_style.'>';
                                    $out .= '<a class="loader async-img-none" rel="'.$t_url.'"></a>';
                                    $out .= '<a class="triger" href="'.$pic->imageURL.'" rel="lightbox'.$t_group.'"></a>';     
                                $out .= '</div>';   
                                  
                                // mobile version
                                $t_style = '';
                                    $t_style .= 'padding:'.$args['padding'].'px;';
                                    if($args['border']) { $t_style .= 'border:1px solid '.$args['bcolor'].';'; }
                                    if($args['bgcolor_use']) { $t_style .= 'background-color:'.$args['bgcolor'].';'; }                               
                                $t_style = ' style="'.$t_style.'" ';                                
                                
                                $t_url = dcf_getImageURL($pic->imageURL, 55, 55, CMS_IMAGE_CROP_FIT);   
                                $t_group = '[ngg-gid-'.$args['id'].'-mobile]';
                                if($args['group'] != '') { $t_group = '['.$args['group'].'-mobile]'; }
                                
                                $out .= '<div class="thumb-mobile" '.$t_style.'>';
                                    $out .= '<a class="loader async-img-none" rel="'.$t_url.'"></a>'; 
                                    $out .= '<a class="triger" href="'.$pic->imageURL.'" rel="lightbox'.$t_group.'"></a>';     
                                $out .= '</div>';                                   
                            }                            
                        } // is_array
                    }   
                }        
            
                $out .= '<div class="dc-clear-both"></div>';
            $out .= '</div>'; // dcs-ngg 
        $out .= '</div>'; // wrapper       
        return $out;
    }      
    
    public function dcs_ngg($args, $content=null, $code='')
    {              
        $out = '';
        $out .= self::render_dcs_ngg($args, $content);
        return $out;
    }         
    
    
    /**
     * Displays ngg gallery as slider with thumbs list located at the bottom
     * @param args = {size=>'1-1'} 
     * @return string HTML code
     */             
    public function render_dcs_ngg_thumbs_slider($args, $content=null, $code='')
    {
        $def = array(
          'size' => '1-1',
          'ctype' => 'none',
          'float' => 'none',
          'clear' => 'none',         
          'id' => CMS_NOT_SELECTED,
          'bottom' => 20,
          'left' => 0,
          'right' => 0,            
          'desc' => '', 
          'viewport_w' => 960,
          'viewport_h' => 480,
                    
          'thumb_size' => 40,                       
          'count' => 16,
          'transition' => 'slide', // slide, fade, none
          'bcolor' => '#FFFFFF',
          
          'random' => 'false',
          'slide_desc' => 'false',
          'slide_title' => 'false',
          'all' => 'false'                                                                          
        ); 
        if(!is_array($args)) { $args = array(); } 
        $args = self::combineArgs($def, $args);
        $args = self::convertStringTypes($args);
 
        // checking
        $args['ctype'] = self::checkCType($args['ctype']);
        $args['float'] = self::checkFloatByCType($args['ctype'], $args['float']);         
        $args['clear'] = self::checkClear($args['clear']); 
              
        $column_postfix = '';
        if($args['ctype'] == 'none' and $args['float'] == 'right') { $column_postfix = '-right'; }             
        
        // args
        $style_w = '';
            $style_w .= 'float:'.$args['float'].';'; 
            $style_w .= 'margin-bottom:'.$args['bottom'].'px;';
            $style_w .= 'clear:'.$args['clear'].';';
        $style_w = ' style="'.$style_w.'" ';                                       
              
        // render
        $out = '';
        
        global $nggdb;
        if(isset($nggdb))
        {            
            $gallery = $nggdb->find_gallery($args['id']);
                      
            if($gallery != false)
            {    
                $pics = null;
                if($args['random'])
                {
                    $pics = $nggdb->get_random_images($args['count'], $args['id']); 
                } else
                {   
                    if($args['all']) { $args['count'] = 0; } 
                    $pics = $nggdb->get_gallery($args['id'], 'sortorder', 'ASC', true, $args['count'], 0);                        
                } 
                $pics = array_values($pics);
                
                $out .= '<div class="dcs-ngg-thumbs-slider-wrapper dc-percent-column-'.self::checkSize($args['size']).$column_postfix.' dc-ctype-'.$args['ctype'].'" '.$style_w.'>';
                    
                    $style = '';
                        $style .= 'margin-left:'.$args['left'].'px;';
                        $style .= 'margin-right:'.$args['right'].'px;';
                    $style = ' style="'.$style.'" '; 
                    
                    $out .= '<div class="dcs-ngg-thumbs-slider" '.$style.'>';
                        $out .= '<span class="trans">'.$args['transition'].'</span>';
                        $out .= '<div class="slider">';
                            
                            // empty not used slide for keeping slider container in some height
                            $out .= '<div class="empty-slide">';
                                $rel = dcf_getImageURL($pics[0]->imageURL, $args['viewport_w'], $args['viewport_h']);
                                $out .= '<a class="image async-img-none" rel="'.$rel.'"></a>';
                            $out .= '</div>';
                            
                            foreach($pics as $pic)
                            {
                                $rel = dcf_getImageURL($pic->imageURL, $args['viewport_w'], $args['viewport_h']);                            
                                $out .= '<div class="slide">';
                                    $out .= '<a class="image async-img-none" rel="'.$rel.'"></a>';
                                    $out .= '<a class="triger" href="'.$pic->imageURL.'" rel="lightbox[dcs-ngg-ts-'.$args['id'].']"></a>';
                                    if(($args['slide_desc'] and $pic->description != '') or ($args['slide_title'] and $pic->alttext != ''))
                                    {
                                        $out .= '<div class="slide-desc">';
                                            if($args['slide_title'] and $pic->alttext != '')
                                            {
                                                $out .= '<div class="title">'.stripcslashes($pic->alttext).'</div>';                                          
                                            }
                                            if($args['slide_desc'] and $pic->description != '')
                                            {
                                                $out .= '<div>'.stripcslashes($pic->description).'</div>';
                                            }
                                        $out .= '</div>';
                                    }
                                $out .= '</div>';                                                        
                            }                
                        $out .= '</div>';
                        if($args['desc'] != '')
                        {
                            $out .= '<p class="slider-desc">'.$args['desc'].'</p>';
                        }            
                        $out .= '<div class="thumbs-wrapper">';
                            foreach($pics as $pic)
                            {            
                                $rel = dcf_getImageURL($pic->thumbURL, $args['thumb_size'], $args['thumb_size']); 
                                $out .= '<a class="thumb async-img-none" style="border-color:'.$args['bcolor'].';" rel="'.$rel.'" /></a>';
                            }
                            $out .= '<div class="dc-clear-both"></div>';
                        $out .= '</div>';
                    $out .= '</div>';
                $out .= '</div>';               
                
            }
        }              
        return $out;          
    } 
    
    public function dcs_ngg_thumbs_slider($args, $content=null, $code='')
    {              
        $out = '';
        $out .= self::render_dcs_ngg_thumbs_slider($args, $content);
        return $out;
    }       
         
    /**
     * Displays formated source code in pretty box
     * @param args = {size=>'1-1'} 
     * @return string HTML code
     */     
    public function render_dcs_code($args, $content=null, $code='')
    {              
        $def = array(
          'size' => '1-1',
          'ctype' => 'none',
          'float' => 'none',
          'clear' => 'none',        
          'minimized' => 'false',
          'stripes' => 'false',          
          'bottom' => 20,
          'lang' => 'code', // code, css, html, php                                                                               
          'title' => '',
          'desc' => ''
        ); 
        if(!is_array($args)) { $args = array(); } 
        $args = self::combineArgs($def, $args);
        $args = self::convertStringTypes($args);
 
        // checking
        $args['ctype'] = self::checkCType($args['ctype']);
        $args['float'] = self::checkFloatByCType($args['ctype'], $args['float']);         
        $args['clear'] = self::checkClear($args['clear']); 
              
        $column_postfix = '';
        if($args['ctype'] == 'none' and $args['float'] == 'right') { $column_postfix = '-right'; }             
        
        // args
        $style_w = '';
            $style_w .= 'float:'.$args['float'].';'; 
            $style_w .= 'margin-bottom:'.$args['bottom'].'px;';
            $style_w .= 'clear:'.$args['clear'].';';
        $style_w = ' style="'.$style_w.'" ';                                       
              
        // prepare content
        $left_square_bracket = '&#91;';
        $right_square_bracket = '&#93;';
        $content = htmlentities($content);      
        $content = str_replace('[', $left_square_bracket, $content);    
        $content = str_replace(']', $right_square_bracket, $content);   
              
        // render
        $out = '';        
        $out .= '<div class="dcs-code-wrapper dc-percent-column-'.self::checkSize($args['size']).$column_postfix.' dc-ctype-'.$args['ctype'].'" '.$style_w.'>';          
                
            $minimized = ' data-minimized="'.($args['minimized'] ? 'true' : 'false').'" ';    
            $stripes = ' data-stripes="'.($args['stripes'] ? 'true' : 'false').'" '; 
                
            $out .= '<pre class="dc-code" '.$minimized.' '.$stripes.' lang="'.$args['lang'].'">';
                $out .= $content;   
            $out .= '</pre>';
        
            if($args['title'] != '' or $args['desc'] != '')
            {
                $out .= '<div class="dc-highlight-code-desc">';
                    if($args['title'] != '')
                    {
                        $out .= '<div class="title">'.$args['title'].'</div>';
                    }
                    if($args['desc'] != '')
                    {
                        $out .= '<div class="text">';                
                            $out .= $args['desc'];
                        $out .= '</div>';
                    }
                $out .= '</div>';         
            }
        $out .= '</div>';
        
        return $out;
    }

          
    public function dcs_code($args, $content=null, $code='')
    {              
        $out = '';
        $out .= self::render_dcs_code($args, $content);
        return $out;
    }       
      
} 
     
?>
