<?php
/**********************************************************************
* OSAKA WORDPRESS THEME 
* (Ideal For Business And Personal Use: Portfolio or Blog)     
* 
* File name:   
*      cp_metamember.php
* Brief:       
*      Part of theme control panel.
* Author:      
*      DigitalCavalry
* Author URI:
*      http://themeforest.net/user/DigitalCavalry
* Contact:
*      digitalcavalry@gmail.com 
***********************************************************************/

/*********************************************************** 
* Definitions
************************************************************/
 
/*********************************************************** 
* Class name:
*    DCC_MemberMetaOpt
* Descripton:
*    Implementation of DCC_MemberMetaOpt
***********************************************************/
class DCC_MemberMetaOpt extends DCC_MetaMultiple 
{         
    /*********************************************************** 
    * Constructor
    ************************************************************/
    public function __construct() 
    {
        $this->_names = array(
            'dc_member_opt', 
            'dc_member_opt_cbox',
             
            'dc_member_layout', 
            
            'dc_member_sid_left', 
            'dc_member_sid_right',                 
             
            'dc_member_bg_image', 
            'dc_member_bg_attachment',
            'dc_member_bg_repeat',
            'dc_member_bg_color',
            'dc_member_bg_pos_x',
            'dc_member_bg_pos_y', 
            'dc_member_bg_pos_x_px',
            'dc_member_bg_pos_y_px',
            'dc_member_bg_pos_x_px_use_cbox',
            'dc_member_bg_pos_y_px_use_cbox',
            'dc_member_bg_use_cbox',
            'dc_member_bg_color_use_cbox',               
            
            'dc_member_image',
            'dc_member_image_desc',
            'dc_member_image_desc_display_cbox',
            'dc_member_image_alt', 
            'dc_member_image_filter',        
            
            'dc_member_pi_title',
            'dc_member_pi_subtitle',
            'dc_member_pi_addinfo',
            'dc_member_pi_twitter',
            'dc_member_pi_facebook',
            'dc_member_pi_website',

            'dc_member_pi_title_cbox',
            'dc_member_pi_subtitle_cbox',
            'dc_member_pi_addinfo_cbox',
            'dc_member_pi_twitter_cbox',
            'dc_member_pi_facebook_cbox',
            'dc_member_pi_website_cbox',
            
            'dc_member_only_content_cbox'  
            );     
                     
        $this->_std = array(
            'dc_member_opt_cbox' => true,
            
            'dc_member_layout' => CMS_PAGE_LAYOUT_RIGHT_SIDEBAR,
            
            'dc_member_sid_left' => CMS_NOT_SELECTED,
            'dc_member_sid_right' => CMS_NOT_SELECTED,              
            
            'dc_member_bg_image' => '',
            'dc_member_bg_attachment' => 'scroll',
            'dc_member_bg_repeat' => 'no-repeat',
            'dc_member_bg_color' => '#E2E2E2',
            'dc_member_bg_pos_x' => 'center',
            'dc_member_bg_pos_y' => 'top',            
            'dc_member_bg_pos_x_px' => 0,
            'dc_member_bg_pos_y_px' => 0,
            'dc_member_bg_pos_x_px_use_cbox' => false,
            'dc_member_bg_pos_y_px_use_cbox' => false,            
            'dc_member_bg_use_cbox' => false,
            'dc_member_bg_color_use_cbox' => false,            
             
            'dc_member_image' => '', 
            'dc_member_image_desc' => '',
            'dc_member_image_desc_display_cbox' => false,
            'dc_member_image_alt' => '',
            'dc_member_image_filter' => CMS_IMAGE_FILTER_NONE,

            'dc_member_pi_title' => '',
            'dc_member_pi_subtitle' => '',
            'dc_member_pi_addinfo' => '',
            'dc_member_pi_twitter' => '',
            'dc_member_pi_facebook' => '',
            'dc_member_pi_website' => '', 

            'dc_member_pi_title_cbox' => false,
            'dc_member_pi_subtitle_cbox' => false,
            'dc_member_pi_addinfo_cbox' => false,
            'dc_member_pi_twitter_cbox' => false,
            'dc_member_pi_facebook_cbox' => false,
            'dc_member_pi_website_cbox' => false,          
            
            'dc_member_only_content_cbox' => false
                
            );
                             
        $this->_title = 'Member Settings';
        $this->_slug = 'dc-member-settings';
        $this->_closed = true;
        $this->_post_type = DCC_ControlPanelCustomPosts::PT_MEMBER_POST;
        
        add_action('admin_menu', array(&$this, 'adminMenu')); 
        add_action('save_post', array(&$this, 'save'));        
    } // constructor 

    /*********************************************************** 
    * Public functions
    ************************************************************/        
      
    public function display()
    {       
        $meta = $this->initDisplay();                            
        global $post;           
        
        $out = '';     
        $out .= '<div class="dc-cms-custom-field-panel">';     
            $out .= $this->getMetaTopSavePanel();       
            $out .= '<div class="center-content-panel">';   
                                
                $out .= '<input type="hidden" name="dc_member_opt_cbox" checked="checked" />';        
        
                // layout
                $out .= $this->getGroupFieldBegin(array('title' => 'Member layout', 'max_w' => 800, 'mtop' => 30)); 
                    $out .= '<span class="dc-cms-control-top-label-nomargin">Select post layout</span>';                    
                    $out .= '<div class="dc-cms-page-layout-box">';
                    
                        $out .= '<div class="item">';
                            $out .= '<div class="layout-image-both-sidebars">Both sidebars</div>';                    
                            $out .= '<input type="radio" name="dc_member_layout" '.$this->attrChecked($meta['dc_member_layout'] == CMS_PAGE_LAYOUT_BOTH_SIDEBARS).' value="'.CMS_PAGE_LAYOUT_BOTH_SIDEBARS.'" />';
                        $out .= '</div>';  
                        
                        $out .= '<div class="item">';
                            $out .= '<div class="layout-image-left-sidebar">Left sidebar</div>';                    
                            $out .= '<input type="radio" name="dc_member_layout" '.$this->attrChecked($meta['dc_member_layout'] == CMS_PAGE_LAYOUT_LEFT_SIDEBAR).' value="'.CMS_PAGE_LAYOUT_LEFT_SIDEBAR.'" />';
                        $out .= '</div>';                                             

                        $out .= '<div class="item">';
                            $out .= '<div class="layout-image-right-sidebar">Right sidebar</div>';                    
                            $out .= '<input type="radio" name="dc_member_layout" '.$this->attrChecked($meta['dc_member_layout'] == CMS_PAGE_LAYOUT_RIGHT_SIDEBAR).' value="'.CMS_PAGE_LAYOUT_RIGHT_SIDEBAR.'" />';
                        $out .= '</div>'; 
                        
                        $out .= '<div class="item">';
                            $out .= '<div class="layout-image-full-width">Full width</div>';                    
                            $out .= '<input type="radio" name="dc_member_layout" '.$this->attrChecked($meta['dc_member_layout'] == CMS_PAGE_LAYOUT_FULL_WIDTH).' value="'.CMS_PAGE_LAYOUT_FULL_WIDTH.'" />';
                        $out .= '</div>';                         
                        
                        $out .= $this->getClearBoth();
                        
                    $out .= '</div>';
                    
                $out .= $this->getGroupFieldEnd();                         
                         
                // sidebar
                $out .= $this->getGroupFieldBegin(array('title' => 'Sidebars', 'max_w' => 800));
                    $out .= '<span class="dc-cms-control-top-label-nomargin">Left sidebar</span>';
                    $out .= GetDCCPI()->getIGeneral()->selectCtrlSidebarsList($meta['dc_member_sid_left'], 'dc_member_sid_left', 300);
                    
                    $out .= '<span class="dc-cms-control-top-label">Right sidebar</span>';
                    $out .= GetDCCPI()->getIGeneral()->selectCtrlSidebarsList($meta['dc_member_sid_right'], 'dc_member_sid_right', 300); 
                    $out .= '<div class="dc-cms-help-note-box">';
                        $out .= 'If sidebar is not selected, default sidebar will be used.';
                    $out .= '</div>';                      
                    
                $out .= $this->getGroupFieldEnd();             
        
                // background                                        
                $out .= $this->getGroupFieldBegin(array('title' => 'Background', 'max_w' => 800));
                    $out .= '<span class="dc-cms-control-top-label-nomargin">URL</span>'; 
                    $out .= '<input type="text" class="dc-cms-control-100per" name="dc_member_bg_image" value="'.$meta['dc_member_bg_image'].'" id="dc_id_dc_member_bg_image" /> ';
                    $out .= '<div class="dc-cms-btn-frame">';
                        $out .= '<input class="dc-cms-submit-image-btn" type="submit" name="dc_id_dc_member_bg_image" value="'.__('Load image', CMS_TXT_DOMAIN).'"> ';  
                    $out .= '</div>';                   
                
                    $out .= $this->getImagePreviewBox(array('path' => $meta['dc_member_bg_image'], 'width' => 240, 'height' => 180));  
                    
                    $out .= $this->getStdWrapperStart();
                    
                        $out .= $this->getStdColumnStart(array('width'=>220)); 
                            
                                $out .= '<span class="dc-cms-control-top-label-nomargin">Background X align</span>';   
                                $out .= '<select name="dc_member_bg_pos_x" class="dc-cms-control-100">';
                                    $out .= '<option value="left" '.$this->attrSelected($meta['dc_member_bg_pos_x'] == 'left').'>Left</option>';
                                    $out .= '<option value="center" '.$this->attrSelected($meta['dc_member_bg_pos_x'] == 'center').'>Center</option>';
                                    $out .= '<option value="right" '.$this->attrSelected($meta['dc_member_bg_pos_x'] == 'right').'>Right</option>';
                                $out .= '</select>'; 
                                                                
                                $out .= '<span class="dc-cms-control-top-label">Background Y align</span>';
                                $out .= '<select name="dc_member_bg_pos_y" class="dc-cms-control-100">';
                                    $out .= '<option value="top" '.$this->attrSelected($meta['dc_member_bg_pos_y'] == 'top').'>Top</option>';
                                    $out .= '<option value="center" '.$this->attrSelected($meta['dc_member_bg_pos_y'] == 'center').'>Center</option>';
                                    $out .= '<option value="bottom" '.$this->attrSelected($meta['dc_member_bg_pos_y'] == 'bottom').'>Bottom</option>';
                                $out .= '</select>';
                                
                                
                                $out .= '<span class="dc-cms-control-top-label">Background X position in pixels</span>';
                                $out .= $this->getCtrlInputInt('dc_member_bg_pos_x_px', $meta['dc_member_bg_pos_x_px']);                        
  
                                $out .= '<span class="dc-cms-control-top-label">Background Y position in pixels</span>';
                                $out .= $this->getCtrlInputInt('dc_member_bg_pos_y_px', $meta['dc_member_bg_pos_y_px']);
                                   
                                               
                        $out .= $this->getStdColumnEnd();                    
                    
                        $out .= $this->getStdColumnStart(array('width'=>150));
                            $out .= '<span class="dc-cms-control-top-label-nomargin">Attachment mode</span>';
                            $out .= $this->getStdInputsFieldStart();  
                                $out .= '<input type="radio" name="dc_member_bg_attachment" '.$this->attrChecked($meta['dc_member_bg_attachment'] == 'scroll').' value="scroll" /> Scroll';
                                $out .= $this->getBR();
                                $out .= '<input type="radio" name="dc_member_bg_attachment" '.$this->attrChecked($meta['dc_member_bg_attachment'] == 'fixed').' value="fixed" /> Fixed'; 
                                
                                $out .= '<span class="dc-cms-control-top-label">Background color</span>';
                                $out .= '<input type="text" class="dc-color-picker" value="'.$meta['dc_member_bg_color'].'" name="dc_member_bg_color" />';   
                            $out .= $this->getStdInputsFieldEnd();                                       
                        $out .= $this->getStdColumnEnd();                    
     
                        $out .= $this->getStdColumnStart(array('width'=>150));
                            $out .= '<span class="dc-cms-control-top-label-nomargin">Repeat mode</span>'; 
                            $out .= $this->getStdInputsFieldStart(); 
                                $out .= '<input type="radio" '.$this->attrChecked($meta['dc_member_bg_repeat'] == 'repeat').' value="repeat" name="dc_member_bg_repeat" /> Repeat';
                                $out .= $this->getBR();         
                                $out .= '<input type="radio" '.$this->attrChecked($meta['dc_member_bg_repeat'] == 'repeat-x').' value="repeat-x" name="dc_member_bg_repeat" /> Repeat X';
                                $out .= $this->getBR();
                                $out .= '<input type="radio" '.$this->attrChecked($meta['dc_member_bg_repeat'] == 'repeat-y').' value="repeat-y" name="dc_member_bg_repeat" /> Repeat Y';
                                $out .= $this->getBR();
                                $out .= '<input type="radio" '.$this->attrChecked($meta['dc_member_bg_repeat'] == 'no-repeat').' value="no-repeat" name="dc_member_bg_repeat" /> No repeat';    
                            $out .= $this->getStdInputsFieldEnd();
                        $out .= $this->getStdColumnEnd();

                        $out .= $this->getClearBoth();                   
                    $out .= $this->getStdWrapperEnd();
                      
                    $out .= '<span class="dc-cms-control-top-label">Other settings</span>';
                    $out .= $this->getStdInputsFieldStart();
                        $out .= '<input type="checkbox" name="dc_member_bg_use_cbox" '.$this->attrChecked($meta['dc_member_bg_use_cbox']).' /> Use background image'; 
                        $out .= $this->getBR(); 
                        $out .= '<input type="checkbox" name="dc_member_bg_color_use_cbox" '.$this->attrChecked($meta['dc_member_bg_color_use_cbox']).' /> Use background color';  
                        $out .= $this->getBR();                    
                        $out .= '<input type="checkbox" name="dc_member_bg_pos_x_px_use_cbox" '.$this->attrChecked($meta['dc_member_bg_pos_x_px_use_cbox']).' /> Use pixels X position';
                        $out .= $this->getBR(); 
                        $out .= '<input type="checkbox" name="dc_member_bg_pos_y_px_use_cbox" '.$this->attrChecked($meta['dc_member_bg_pos_y_px_use_cbox']).' /> Use pixels Y position';                    
                    $out .= $this->getStdInputsFieldEnd();                    
                $out .= $this->getGroupFieldEnd();          

                // main image
                $out .= $this->getGroupFieldBegin(array('title' => 'Main image', 'max_w' => 800, 'mtop' => 50));
    
                    $out .= '<span class="dc-cms-control-top-label-nomargin">URL</span>'; 
                    $out .= '<input type="text" class="dc-cms-control-wide" name="dc_member_image" value="'.$meta['dc_member_image'].'" id="dc_id_dc_member_image" /> ';
                    $out .= '<div class="dc-cms-btn-frame">';
                        $out .= '<input class="dc-cms-submit-image-btn" type="submit" name="dc_id_dc_member_image" value="'.__('Load image', CMS_TXT_DOMAIN).'"> ';  
                    $out .= '</div>';        

                    $out .= $this->getImagePreviewBox(array('path' => $meta['dc_member_image'], 'width' => 240, 'height' => 180));                                                               
                         
                    $out .= '<span class="dc-cms-control-top-label">Image filter</span>';  
                    $out .= $this->getStdInputsFieldStart();
                        $out .= '<input type="radio" name="dc_member_image_filter" value="'.CMS_IMAGE_FILTER_NONE.'" '.$this->attrChecked($meta['dc_member_image_filter'] == CMS_IMAGE_FILTER_NONE).' /> None';
                        $out .= $this->getBR();
                        $out .= '<input type="radio" name="dc_member_image_filter" value="'.CMS_IMAGE_FILTER_GRAYSCALE.'" '.$this->attrChecked($meta['dc_member_image_filter'] == CMS_IMAGE_FILTER_GRAYSCALE).' /> Grayscale';
                    $out .= $this->getStdInputsFieldEnd();
                    
                    
                    $out .= '<span class="dc-cms-control-top-label">Image description</span>'; 
                    $out .= '<textarea class="dc-cms-control-wide dc-cms-control-textarea dc-cms-control-h-40" name="dc_member_image_desc">'.$meta['dc_member_image_desc'].'</textarea>';

                    $out .= '<span class="dc-cms-control-top-label">Image alt</span>'; 
                    $out .= '<textarea class="dc-cms-control-wide dc-cms-control-textarea dc-cms-control-h-40" name="dc_member_image_alt">'.$meta['dc_member_image_alt'].'</textarea>';
                    
                    
                    $out .= '<span class="dc-cms-control-top-label">Other settings</span>';  
                    $out .= $this->getStdInputsFieldStart();
                        $out .= '<input type="checkbox" name="dc_member_image_desc_display_cbox" '.$this->attrChecked($meta['dc_member_image_desc_display_cbox']).' /> Display image description';                   
                    $out .= $this->getStdInputsFieldEnd();                            
                           
                $out .= $this->getGroupFieldEnd();                                   
               
                // personal information
                $out .= $this->getGroupFieldBegin(array('title' => 'Member personal information', 'max_w' => 800, 'mtop' => 50)); 
                    
                    $out .= '<span class="dc-cms-control-top-label-nomargin">Title</span>';  
                    $out .= '<textarea name="dc_member_pi_title" class="dc-cms-control-wide dc-cms-control-textarea dc-cms-control-h-40">'.$meta['dc_member_pi_title'].'</textarea>';

                    $out .= '<span class="dc-cms-control-top-label">Subtitle</span>'; 
                    $out .= '<textarea name="dc_member_pi_subtitle" class="dc-cms-control-wide dc-cms-control-textarea dc-cms-control-h-40">'.$meta['dc_member_pi_subtitle'].'</textarea>';

                    $out .= '<span class="dc-cms-control-top-label">Additional information</span>'; 
                    $out .= '<textarea name="dc_member_pi_addinfo" class="dc-cms-control-wide dc-cms-control-textarea dc-cms-control-h-100">'.$meta['dc_member_pi_addinfo'].'</textarea>';
                    
                    $out .= '<span class="dc-cms-control-top-label">Personal website URL</span>';
                    $out .= '<input type="text" class="dc-cms-control-wide" name="dc_member_pi_website" value="'.$meta['dc_member_pi_website'].'" />';
                    
                    $out .= '<span class="dc-cms-control-top-label">Twitter URL</span>';
                    $out .= '<input type="text" class="dc-cms-control-wide" name="dc_member_pi_twitter" value="'.$meta['dc_member_pi_twitter'].'" />';    
                    
                    $out .= '<span class="dc-cms-control-top-label">Facebook URL</span>';  
                    $out .= '<input type="text" class="dc-cms-control-wide" name="dc_member_pi_facebook" value="'.$meta['dc_member_pi_facebook'].'" />';                        
                    
                    $out .= '<span class="dc-cms-control-top-label">Other settings</span>';                                                               
                    $out .= $this->getStdInputsFieldStart();
                        $out .= '<input type="checkbox" name="dc_member_pi_title_cbox" '.$this->attrChecked($meta['dc_member_pi_title_cbox']).' /> Display member title';                    
                        $out .= $this->getBR();
                        $out .= '<input type="checkbox" name="dc_member_pi_subtitle_cbox" '.$this->attrChecked($meta['dc_member_pi_subtitle_cbox']).' /> Display member subtitle';
                        $out .= $this->getBR();
                        $out .= '<input type="checkbox" name="dc_member_pi_addinfo_cbox" '.$this->attrChecked($meta['dc_member_pi_addinfo_cbox']).' /> Display additional information';                    
                        $out .= $this->getBR();                        
                        $out .= '<input type="checkbox" name="dc_member_pi_website_cbox" '.$this->attrChecked($meta['dc_member_pi_website_cbox']).' /> Display personal website link';                    
                        $out .= $this->getBR();   
                        $out .= '<input type="checkbox" name="dc_member_pi_twitter_cbox" '.$this->attrChecked($meta['dc_member_pi_twitter_cbox']).' /> Display Twitter link';                    
                        $out .= $this->getBR();   
                        $out .= '<input type="checkbox" name="dc_member_pi_facebook_cbox" '.$this->attrChecked($meta['dc_member_pi_facebook_cbox']).' /> Display Facebook link';                    
                        $out .= $this->getBR();                                                   
                    $out .= $this->getStdInputsFieldEnd();    
                                     
                $out .= $this->getGroupFieldEnd();
                
                // miscellaneous
                $out .= $this->getGroupFieldBegin(array('title' => 'Miscellaneous settings', 'max_w' => 800, 'mtop' => 50));                                                                     
                     $out .= $this->getStdInputsFieldStart();
                        $out .= '<input type="checkbox" name="dc_member_only_content_cbox" '.$this->attrChecked($meta['dc_member_only_content_cbox']).' /> Display only content without default formating';                    
                    $out .= $this->getStdInputsFieldEnd(); 
                $out .= $this->getGroupFieldEnd();                  
                
            $out .= '</div>';      
            $out .= $this->getMetaBottomSavePanel();     
        $out .= '</div>';
        
        echo $out;
    } 
}   
        
?>