<?php
/**********************************************************************
* OSAKA WORDPRESS THEME
* (Ideal For Business And Personal Use: Portfolio or Blog)   
* 
* File name:   
*      category.php
* Brief:       
*      theme posts archive page
* Author:      
*      DigitalCavalry
* Author URI:
*      http://themeforest.net/user/DigitalCavalry
* Contact:
*      digitalcavalry@gmail.com   
***********************************************************************/ 

    get_header();                                                
?>

    <div class="dc-primary-wrapper">  
        <div class="dc-secondary-wrapper">
            
            <?php 
            
            $category_id = GetDCCPI()->getIRenderer()->getCatIDQueryVar();
            $category = get_category($category_id); 

            //$title = __('Archive for category', CMS_TXT_DOMAIN).' '.$category->name;                   
            
            $crumb = new DCC_Breadcrumb();
            echo $crumb->wpBreadcrumb(array('type' => 'category')); 
                                 
            ?>
            <div class="dc-page-seo-wrapper <?php echo GetDCCPI()->getIRenderer()->getCategoryPageLayoutClass(); ?>">
            <div class="dc-page-content">
            <div class="dc-sixteen dc-columns"> 
                <?php                   

                    $paged = GetDCCPI()->getIRenderer()->getPagedQueryVar();
                    $per_page = GetDCCPI()->getIGeneral()->getOption('archive_category_per_page');
                    $args = array('paged' => $paged, 'post_type' => 'post', 'posts_per_page' => $per_page, 'cat'=> $category->term_id);                                                              

                    $dc_query = new WP_Query($args);                    
                    $out = '';             
                    for($i = 0; $i < $dc_query->post_count; $i++)
                    {
                        if($i > 0) { $out .= '<div class="blog-post-short-separator"></div>'; }
                        $p = new DCC_WPPost($dc_query->posts[$i]);
                        $out .= GetDCCPI()->getIRenderer()->wpPostShort(array('post' => $p));                               
                    } 
                    echo $out;                                                                                      
                    echo GetDCCPI()->getIRenderer()->wpQueryPaginationBlock(array('paged' => $paged, 'maxpage' => $dc_query->max_num_pages), true);                                       
                ?>                           
                </div>
                <div class="dc-clear-both"></div>
            </div> 
            
                <?php GetDCCPI()->getIRenderer()->wpCategoryLeftSidebar(array('slug' => $category->slug)); ?>  
            </div>  <!-- seo-wrapper -->
            
            <?php 
                GetDCCPI()->getIRenderer()->wpCategoryRightSidebar(array('slug' => $category->slug));
            ?>
            <div class="dc-clear-both"></div>                
        </div> <!-- dc-secondary-wrapper -->    
    </div> <!-- dc-primary-wrapper --> 
    
<?php    
    get_footer();
?>                                                               



