<?php

/**
 * Artisan Creatif 404 Template
 * 
 * This is the 404 Page Template which will be used in the event of a 404 error.
 *
 * You should only customize this template in a child theme.
 *
 * @package Artisan Creatif
 * @version 1.0.0
 * @since 2.0.0
 * @author Erik Ford for We Are Pixel8 <@notdivisible>
 *
 */

get_header(); ?>

		<div class="flowlines"><!-- Begin .flowlines -->
			<div class="wrapper">
				<h1><?php _e( '404 Error &#151; Page not found', 'wap8theme-i18n' ); ?></h1>
			</div>
		</div><!-- End .flowlines -->
		
		<div id="page-content"><!-- Begin #page-content -->
			<div class="wrapper"><!-- Begin .wrapper for #page-content -->
				<div class="artisancolumn-700 post-entry centermargin-40">
					<p><?php _e( 'Unfortunately, the page you are looking for has either been moved or deleted. You may be able to locate this content using our ', 'wap8theme-i18n' ); ?><a class="toggle-search" href="#" title="<?php _e( 'Use our Search Form', 'wap8theme-i18n' ); ?>"><?php _e( 'Search Form', 'wap8theme-i18n' ); ?></a><?php _e( ' or the provided links below.', 'wap8theme-i18n' ); ?></p>
				</div>
				
				<div class="artisancolumn-700 search-404 centermargin-40">
					<?php get_search_form(); ?>
				</div>
				
				<div class="artisancolumn-960 padbottom-40 clear">
				
					<div class="artisancolumn-220 archive-404 alignleft">
						<h4><?php _e( 'Our Recent Work', 'wap8theme-i18n' ); ?></h4>
						
						<ul>
						<?php
						
							// get the cached version of the query if one exists
							if ( false === ( $error_portfolio_results = get_transient( 'error_portfolio_results' ) ) ) {
    
								// it did not exist, so run through the query
								$args = array(
									'post_type'      => 'portfolio',
									'post_status'    => 'publish',
									'posts_per_page' => 10,
									'orderby'        => 'date',
									'order'          => 'DESC'
									);
							
								$error_portfolio_results = new WP_Query( $args );
								
								// set the transient for 8 hours
								set_transient( 'error_portfolio_results', $error_portfolio_results, 60*60*8 );
								
								}
								
							if ( $error_portfolio_results->have_posts() ) : while ( $error_portfolio_results->have_posts() ) : $error_portfolio_results->the_post(); ?>
							<?php the_title( '<li><a href="' . get_permalink() . '" title="' . the_title_attribute( array( 'before' => __( 'Permanent link to ', 'wap8theme-i18n' ), 'echo' => 0 ) ) . '" rel="bookmark">', '</a></li>' ); ?>
						
						<?php endwhile; else : ?>
						
							<li><?php _e( 'It seems we have not published any recent work yet.', 'wap8theme-i18n' ); ?></li>
						
						<?php endif; wp_reset_query(); ?>						
						</ul>
					</div>
					
					<div class="artisancolumn-220 archive-404 alignleft">
						<h4><?php _e( 'Our Recent Blog Posts', 'wap8theme-i18n' ); ?></h4>
						
						<ul>
						<?php
						
							// get the cached version of the query if one exists
							if ( false === ( $error_posts_results = get_transient( 'error_posts_results' ) ) ) {
    
								// it did not exist, so run through the query
								$args = array(
									'post_type'        => 'post',
									'posts_per_page'   => 10,
									'caller_get_posts' => 1,
									'orderby'          => 'date',
									'order'            => 'DESC'
									);
							
								$error_posts_results = new WP_Query( $args );
								
								// set the transient for 8 hours
								set_transient( 'error_posts_results', $error_posts_results, 60*60*8 );
								
								}
								
							if ( $error_posts_results -> have_posts() ) : while ( $error_posts_results -> have_posts() ) : $error_posts_results -> the_post(); ?>
							
							<?php the_title( '<li><a href="' . get_permalink() . '" title="' . the_title_attribute( array( 'before' => __( 'Permanent link to ', 'wap8theme-i18n' ), 'echo' => 0 ) ) . '" rel="bookmark">', '</a></li>' ); ?>
						
						<?php endwhile; else : ?>
						
							<li><?php _e( 'It seems we have not published any blog posts yet.', 'wap8theme-i18n' ); ?></li>
						
						<?php endif; wp_reset_query(); ?>	
						</ul>
					</div>
					
					<div class="artisancolumn-220 archive-404 alignleft">
						<h4><?php _e( 'Archives by Month', 'wap8theme-i18n' ); ?></h4>
						
						<ul>
						<?php wp_get_archives( 'limit=12' ); ?>
						</ul>
					</div>
					
					<div class="artisancolumn-220 archive-404 alignleft">
						<h4><?php _e( 'Archives by Year', 'wap8theme-i18n' ); ?></h4>
						
						<ul>
						<?php wp_get_archives( 'type=yearly&limit=10' ); ?>
						</ul>
					</div>
				
				</div>
			</div><!-- End .wrapper for #page-content -->
		</div><!-- End #page-content -->
	</div><!-- End #vertical-grid -->
<?php get_footer(); ?>
